/*
 * Decompiled with CFR 0.152.
 */
package com.collabnet.subversion.merge.wizards;

import com.collabnet.subversion.merge.Activator;
import com.collabnet.subversion.merge.Messages;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.tigris.subversion.subclipse.core.resources.SVNWorkspaceRoot;
import org.tigris.subversion.svnclientadapter.SVNConflictDescriptor;

public class PropertyValueSelectionWizardPage
extends WizardPage {
    private SVNConflictDescriptor conflictDescriptor;
    private IResource resource;
    private String myValue;
    private String incomingValue;
    private IDialogSettings settings = Activator.getDefault().getDialogSettings();
    private Button myValueButton;
    private Text myValueText;
    private Button incomingValueButton;
    private Text incomingValueText;
    private static final String LAST_CHOICE = "PropertyValueSelectionWizardPage.lastChoice";

    public PropertyValueSelectionWizardPage(String pageName) {
        super(pageName, Messages.PropertyValueSelectionWizardPage_handleConflict, Activator.getDefault().getImageDescriptor("svn_wizban.png"));
    }

    public void createControl(Composite parent) {
        Composite outerContainer = new Composite(parent, 0);
        GridLayout outerLayout = new GridLayout();
        outerLayout.numColumns = 1;
        outerContainer.setLayout((Layout)outerLayout);
        outerContainer.setLayoutData((Object)new GridData(768));
        Composite composite = new Composite(outerContainer, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        composite.setLayout((Layout)layout);
        GridData data = new GridData(1808);
        composite.setLayoutData((Object)data);
        IResource resource = SVNWorkspaceRoot.getResourceFor((IResource)this.resource, (IPath)new Path(this.conflictDescriptor.getPath()));
        Label resourceLabel = new Label(composite, 0);
        data = new GridData(128);
        resourceLabel.setLayoutData((Object)data);
        resourceLabel.setText(Messages.PropertyValueSelectionWizardPage_resource);
        Label resourceNameLabel = new Label(composite, 64);
        resourceNameLabel.setText(resource.getFullPath().makeRelative().toOSString());
        data = new GridData();
        data.widthHint = 500;
        resourceNameLabel.setLayoutData((Object)data);
        Label propertyLabel = new Label(composite, 0);
        propertyLabel.setText(Messages.PropertyValueSelectionWizardPage_propertyName);
        Label propertyNameLabel = new Label(composite, 64);
        propertyNameLabel.setText(this.conflictDescriptor.getPropertyName());
        data = new GridData();
        data.widthHint = 500;
        propertyNameLabel.setLayoutData((Object)data);
        new Label(composite, 0);
        new Label(composite, 0);
        this.myValueButton = new Button(composite, 16);
        data = new GridData();
        data.horizontalSpan = 2;
        this.myValueButton.setLayoutData((Object)data);
        this.myValueButton.setText(Messages.PropertyValueSelectionWizardPage_useMine);
        this.myValueText = new Text(composite, 2882);
        data = new GridData(1808);
        data.horizontalSpan = 2;
        data.heightHint = 100;
        data.widthHint = 400;
        data.horizontalIndent = 30;
        data.grabExcessHorizontalSpace = true;
        this.myValueText.setLayoutData((Object)data);
        this.myValueText.setText(this.myValue);
        this.incomingValueButton = new Button(composite, 16);
        data = new GridData();
        data.horizontalSpan = 2;
        this.incomingValueButton.setLayoutData((Object)data);
        this.incomingValueButton.setText(Messages.PropertyValueSelectionWizardPage_useIncoming);
        this.incomingValueText = new Text(composite, 2882);
        data = new GridData(1808);
        data.horizontalSpan = 2;
        data.heightHint = 100;
        data.widthHint = 400;
        data.horizontalIndent = 30;
        data.grabExcessHorizontalSpace = true;
        this.incomingValueText.setLayoutData((Object)data);
        this.incomingValueText.setText(this.incomingValue);
        String lastChoice = this.settings.get(LAST_CHOICE);
        if (lastChoice != null && lastChoice.equals("incoming")) {
            this.myValueText.setEditable(false);
            this.incomingValueButton.setSelection(true);
            this.incomingValueText.setFocus();
        } else {
            this.incomingValueText.setEditable(false);
            this.myValueButton.setSelection(true);
            this.myValueText.setFocus();
        }
        SelectionAdapter selectionListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (PropertyValueSelectionWizardPage.this.incomingValueButton.getSelection()) {
                    PropertyValueSelectionWizardPage.this.settings.put(PropertyValueSelectionWizardPage.LAST_CHOICE, "incoming");
                    PropertyValueSelectionWizardPage.this.incomingValueText.setEditable(true);
                    PropertyValueSelectionWizardPage.this.myValueText.setEditable(false);
                    PropertyValueSelectionWizardPage.this.incomingValueText.setFocus();
                } else {
                    PropertyValueSelectionWizardPage.this.settings.put(PropertyValueSelectionWizardPage.LAST_CHOICE, "mine");
                    PropertyValueSelectionWizardPage.this.myValueText.setEditable(true);
                    PropertyValueSelectionWizardPage.this.incomingValueText.setEditable(false);
                    PropertyValueSelectionWizardPage.this.myValueText.setFocus();
                }
            }
        };
        this.myValueButton.addSelectionListener((SelectionListener)selectionListener);
        this.incomingValueButton.addSelectionListener((SelectionListener)selectionListener);
        FocusAdapter focusListener = new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                ((Text)e.getSource()).selectAll();
            }

            public void focusLost(FocusEvent e) {
                ((Text)e.getSource()).setText(((Text)e.getSource()).getText());
            }
        };
        this.myValueText.addFocusListener((FocusListener)focusListener);
        this.incomingValueText.addFocusListener((FocusListener)focusListener);
        this.setMessage(Messages.PropertyValueSelectionWizardPage_selectValue);
        this.setControl((Control)outerContainer);
    }

    public String getValue() {
        if (this.myValueButton.getSelection()) {
            return this.myValueText.getText().trim();
        }
        return this.incomingValueText.getText().trim();
    }

    public void setConflictDescriptor(SVNConflictDescriptor conflictDescriptor) {
        this.conflictDescriptor = conflictDescriptor;
    }

    public void setMyValue(String myValue) {
        this.myValue = myValue;
    }

    public void setIncomingValue(String incomingValue) {
        this.incomingValue = incomingValue;
    }

    public void setResource(IResource resource) {
        this.resource = resource;
    }
}

