/*
 * Decompiled with CFR 0.152.
 */
package com.collabnet.subversion.merge.wizards;

import com.collabnet.subversion.merge.ConflictResolution;
import com.collabnet.subversion.merge.MergeOutput;
import com.collabnet.subversion.merge.Messages;
import com.collabnet.subversion.merge.wizards.ConflictHandlingWizardPage;
import com.collabnet.subversion.merge.wizards.ConflictsResolvedWizardPage;
import com.collabnet.subversion.merge.wizards.FinishedEditingWizardPage;
import com.collabnet.subversion.merge.wizards.MergeAbortedWizardPage;
import com.collabnet.subversion.merge.wizards.MergeSummaryWizardPage;
import com.collabnet.subversion.merge.wizards.PropertyValueSelectionWizardPage;
import com.collabnet.subversion.merge.wizards.QuestionWizardPage;
import com.collabnet.subversion.merge.wizards.ResolveConflictWizardPage;
import com.collabnet.subversion.merge.wizards.ResumeMergeWizardPage;
import com.collabnet.subversion.merge.wizards.UnresolvedConflictsWizardPage;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.tigris.subversion.svnclientadapter.SVNConflictDescriptor;

public class DialogWizard
extends Wizard {
    private boolean resumed;
    private MergeOutput[] mergeOutputs;
    private boolean conflictResolved;
    private boolean unblock;
    private String errorMessage;
    private SVNConflictDescriptor conflictDescriptor;
    private String myValue;
    private String incomingValue;
    private String valueToUse;
    private IResource[] resources;
    private boolean textConflicts;
    private boolean propertyConflicts;
    private boolean treeConflicts;
    private volatile ConflictResolution conflictResolution;
    private int resolution;
    private FinishedEditingWizardPage finishedEditingWizardPage;
    private ConflictHandlingWizardPage conflictHandlingWizardPage;
    private ResolveConflictWizardPage resolveConflictWizardPage;
    private PropertyValueSelectionWizardPage propertyValueSelectionWizardPage;
    public int type;
    public static final int SUMMARY = 0;
    public static final int CONFLICT_HANDLING = 1;
    public static final int CONFLICTS_RESOLVED = 2;
    public static final int FINISHED_EDITING = 3;
    public static final int UNDO_MERGE_WARNING = 4;
    public static final int UNDO_MERGE_COMPLETED = 5;
    public static final int MERGE_ABORTED = 6;
    public static final int RESUME_MERGE = 7;
    public static final int UNRESOLVED_CONFLICTS = 8;
    public static final int MARK_RESOLVED = 9;
    public static final int PROPERTY_VALUE_SELECTION = 10;
    public static final int COMMIT_MERGEINFO_PROPERTY = 11;

    public DialogWizard(int type) {
        this.type = type;
    }

    public void addPages() {
        QuestionWizardPage questionWizardPage;
        super.addPages();
        if (this.type == 0) {
            this.setWindowTitle(Messages.DialogWizard_summaryTitle);
            MergeSummaryWizardPage summaryPage = new MergeSummaryWizardPage("summary");
            summaryPage.setMergeOutputs(this.mergeOutputs);
            summaryPage.setResumed(this.resumed);
            this.addPage((IWizardPage)summaryPage);
        }
        if (this.type == 3) {
            this.setWindowTitle(Messages.DialogWizard_resolveTitle);
            this.finishedEditingWizardPage = new FinishedEditingWizardPage("finishedEditing");
            this.addPage((IWizardPage)this.finishedEditingWizardPage);
        }
        if (this.type == 1) {
            this.setWindowTitle(Messages.DialogWizard_handleTitle);
            this.conflictHandlingWizardPage = new ConflictHandlingWizardPage("handleConflict");
            this.conflictHandlingWizardPage.setConflictDescriptor(this.conflictDescriptor);
            this.conflictHandlingWizardPage.setResource(this.resources[0]);
            this.addPage((IWizardPage)this.conflictHandlingWizardPage);
        }
        if (this.type == 2) {
            this.setWindowTitle(Messages.DialogWizard_allResolvedTitle);
            ConflictsResolvedWizardPage conflictsResolvedWizardPage = new ConflictsResolvedWizardPage("conflictsResolved");
            conflictsResolvedWizardPage.setMergeOutput(this.mergeOutputs[0]);
            this.addPage((IWizardPage)conflictsResolvedWizardPage);
        }
        if (this.type == 4) {
            this.setWindowTitle(Messages.DialogWizard_undoTitle);
            questionWizardPage = new QuestionWizardPage("question", Messages.DialogWizard_undoTitle, Messages.DialogWizard_revertWarning);
            questionWizardPage.setQuestion(Messages.DialogWizard_revertWarning2);
            this.addPage((IWizardPage)questionWizardPage);
        }
        if (this.type == 5) {
            this.setWindowTitle(Messages.DialogWizard_undoTitle);
            questionWizardPage = new QuestionWizardPage("question", Messages.DialogWizard_undoTitle, Messages.DialogWizard_confirmRevert);
            questionWizardPage.setQuestion(Messages.DialogWizard_confirmRevert2);
            this.addPage((IWizardPage)questionWizardPage);
        }
        if (this.type == 6) {
            this.setWindowTitle(Messages.DialogWizard_terminatedTitle);
            MergeAbortedWizardPage abortedPage = new MergeAbortedWizardPage("aborted");
            abortedPage.setMergeOutput(this.mergeOutputs[0]);
            abortedPage.setErrorMessage(this.errorMessage);
            this.addPage((IWizardPage)abortedPage);
        }
        if (this.type == 7) {
            this.setWindowTitle(Messages.DialogWizard_resumeTitle);
            ResumeMergeWizardPage resumePage = new ResumeMergeWizardPage("resume");
            this.addPage((IWizardPage)resumePage);
        }
        if (this.type == 8) {
            this.setWindowTitle(Messages.DialogWizard_unresolvedConflictsTitle);
            UnresolvedConflictsWizardPage unresolvedPage = new UnresolvedConflictsWizardPage("unresolved");
            unresolvedPage.setMergeOutput(this.mergeOutputs[0]);
            this.addPage((IWizardPage)unresolvedPage);
        }
        if (this.type == 9) {
            this.setWindowTitle(Messages.DialogWizard_resolveTitle);
            this.resolveConflictWizardPage = new ResolveConflictWizardPage("resolveConflict", this.resources);
            this.resolveConflictWizardPage.setTextConflicts(this.textConflicts);
            this.resolveConflictWizardPage.setPropertyConflicts(this.propertyConflicts);
            this.resolveConflictWizardPage.setTreeConflicts(this.treeConflicts);
            this.addPage((IWizardPage)this.resolveConflictWizardPage);
        }
        if (this.type == 10) {
            this.setWindowTitle(Messages.DialogWizard_handleConflictTitle);
            this.propertyValueSelectionWizardPage = new PropertyValueSelectionWizardPage("propertyValueSelection");
            this.propertyValueSelectionWizardPage.setConflictDescriptor(this.conflictDescriptor);
            this.propertyValueSelectionWizardPage.setMyValue(this.myValue);
            this.propertyValueSelectionWizardPage.setIncomingValue(this.incomingValue);
            this.propertyValueSelectionWizardPage.setResource(this.resources[0]);
            this.addPage((IWizardPage)this.propertyValueSelectionWizardPage);
        }
        if (this.type == 11) {
            String text;
            String message;
            this.setWindowTitle(Messages.DialogWizard_mergeCompletedTitle);
            if (this.unblock) {
                message = Messages.DialogWizard_unblockedMessage;
                text = Messages.DialogWizard_unblockedMessage2;
            } else {
                message = Messages.DialogWizard_blockedMessage;
                text = Messages.DialogWizard_blockedMessage2;
            }
            QuestionWizardPage questionWizardPage2 = new QuestionWizardPage("question", Messages.DialogWizard_commitMergeInfoTitle, message);
            questionWizardPage2.setQuestion(text);
            this.addPage((IWizardPage)questionWizardPage2);
        }
    }

    public boolean performFinish() {
        if (this.type == 3) {
            this.resolution = this.finishedEditingWizardPage.getResolution();
            boolean bl = this.conflictResolved = this.resolution != 0;
        }
        if (this.type == 1) {
            this.conflictResolution = this.conflictHandlingWizardPage.getConflictResolution();
        }
        if (this.type == 2) {
            if (this.mergeOutputs[0].isIncomplete()) {
                this.mergeOutputs[0].resume();
            } else {
                this.mergeOutputs[0].delete();
            }
        }
        if (this.type == 10) {
            this.conflictResolved = true;
            this.valueToUse = this.propertyValueSelectionWizardPage.getValue();
        }
        if (this.type == 9) {
            this.resolution = this.resolveConflictWizardPage.getConflictResolution();
        }
        return true;
    }

    public boolean performCancel() {
        if (this.type == 1) {
            this.conflictResolution = this.conflictHandlingWizardPage.getConflictResolution();
        }
        if (this.type == 10) {
            this.valueToUse = this.propertyValueSelectionWizardPage.getValue();
            this.conflictResolved = false;
        }
        return super.performCancel();
    }

    public void setMergeOutput(MergeOutput mergeOutput) {
        this.mergeOutputs = new MergeOutput[1];
        this.mergeOutputs[0] = mergeOutput;
    }

    public void setMergeOutputs(MergeOutput[] mergeOutputs) {
        this.mergeOutputs = mergeOutputs;
    }

    public boolean isConflictResolved() {
        return this.conflictResolved;
    }

    public ConflictResolution getConflictResolution() {
        return this.conflictResolution;
    }

    public void setConflictDescriptor(SVNConflictDescriptor conflictDescriptor) {
        this.conflictDescriptor = conflictDescriptor;
    }

    public void setResumed(boolean resumed) {
        this.resumed = resumed;
    }

    public void setUnblock(boolean unblock) {
        this.unblock = unblock;
    }

    public void setErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
    }

    public void setResources(IResource[] resources) {
        this.resources = resources;
    }

    public int getResolution() {
        return this.resolution;
    }

    public void setMyValue(String myValue) {
        this.myValue = myValue;
    }

    public void setIncomingValue(String incomingValue) {
        this.incomingValue = incomingValue;
    }

    public String getValueToUse() {
        return this.valueToUse;
    }

    public void setTextConflicts(boolean textConflicts) {
        this.textConflicts = textConflicts;
    }

    public void setPropertyConflicts(boolean propertyConflicts) {
        this.propertyConflicts = propertyConflicts;
    }

    public void setTreeConflicts(boolean treeConflicts) {
        this.treeConflicts = treeConflicts;
    }
}

