/*
 * Decompiled with CFR 0.152.
 */
package com.collabnet.subversion.merge.actions;

import com.collabnet.subversion.merge.Activator;
import com.collabnet.subversion.merge.MergeOutput;
import com.collabnet.subversion.merge.Messages;
import com.collabnet.subversion.merge.UndoMergeOperation;
import com.collabnet.subversion.merge.views.MergeResultsView;
import com.collabnet.subversion.merge.wizards.DialogWizard;
import com.collabnet.subversion.merge.wizards.MergeWizardDialog;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.actions.ActionDelegate;
import org.tigris.subversion.subclipse.ui.actions.RevertAction;

public class UndoMergeAction
extends ActionDelegate {
    private IStructuredSelection fSelection;

    public void run(IAction action) {
        DialogWizard dialogWizard = new DialogWizard(4);
        MergeWizardDialog dialog = new MergeWizardDialog(Display.getDefault().getActiveShell(), (IWizard)dialogWizard, true);
        if (dialog.open() == 1) {
            return;
        }
        final ArrayList<IResource> resources = new ArrayList<IResource>();
        ArrayList<MergeOutput> mergeOutputs = new ArrayList<MergeOutput>();
        for (Object object : this.fSelection) {
            if (!(object instanceof MergeOutput)) continue;
            MergeOutput mergeOutput = (MergeOutput)object;
            mergeOutputs.add(mergeOutput);
            IResource resource = mergeOutput.getResource();
            resources.add(resource);
        }
        final IResource[] resourceArray = new IResource[resources.size()];
        resources.toArray(resourceArray);
        UndoMergeOperation undoMergeOperation = new UndoMergeOperation((IWorkbenchPart)MergeResultsView.getView(), resourceArray);
        try {
            undoMergeOperation.run();
        }
        catch (Exception e) {
            Activator.handleError(Messages.UndoMergeAction_error, e);
            MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)Messages.UndoMergeAction_title, (String)e.getMessage());
            return;
        }
        for (MergeOutput mergeOutput : mergeOutputs) {
            mergeOutput.delete();
        }
        MergeResultsView.getView().refresh();
        dialogWizard = new DialogWizard(5);
        dialog = new MergeWizardDialog(Display.getDefault().getActiveShell(), (IWizard)dialogWizard, true);
        if (dialog.open() == 1) {
            return;
        }
        RevertAction revertAction = new RevertAction();
        revertAction.setShowNothingToRevertMessage(false);
        IStructuredSelection selection = new IStructuredSelection(){

            public Object getFirstElement() {
                return resourceArray[0];
            }

            public Iterator iterator() {
                return this.toList().iterator();
            }

            public int size() {
                return resourceArray.length;
            }

            public Object[] toArray() {
                return resourceArray;
            }

            public List toList() {
                return resources;
            }

            public boolean isEmpty() {
                return resources.isEmpty();
            }
        };
        revertAction.selectionChanged(null, (ISelection)selection);
        revertAction.run(null);
    }

    public void selectionChanged(IAction action, ISelection sel) {
        if (sel instanceof IStructuredSelection) {
            this.fSelection = (IStructuredSelection)sel;
        }
    }
}

