/*
 * Decompiled with CFR 0.152.
 */
package com.collabnet.subversion.merge;

import com.collabnet.subversion.merge.Activator;
import com.collabnet.subversion.merge.ConflictResolution;
import com.collabnet.subversion.merge.Messages;
import com.collabnet.subversion.merge.actions.MergeEditConflictsAction;
import com.collabnet.subversion.merge.editors.ExternalFileEditorInput;
import com.collabnet.subversion.merge.editors.FileNode;
import com.collabnet.subversion.merge.wizards.DialogWizard;
import com.collabnet.subversion.merge.wizards.MergeWizardDialog;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorRegistry;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.tigris.subversion.svnclientadapter.ISVNConflictResolver;
import org.tigris.subversion.svnclientadapter.SVNClientException;
import org.tigris.subversion.svnclientadapter.SVNConflictDescriptor;
import org.tigris.subversion.svnclientadapter.SVNConflictResult;

public class SVNConflictResolver
implements ISVNConflictResolver {
    private IResource resource;
    private int textHandling;
    private int binaryHandling;
    private int propertyHandling;
    private ArrayList conflictResolutions = new ArrayList();
    private volatile DialogWizard dialogWizard;
    private boolean finished;
    private int resolution;
    private IWorkbenchPart part;
    private File workingTempFile;
    private File mergeTempFile;
    private File mergedFile;
    private boolean wait = false;
    private ConflictResolution applyToAllTextResolution;
    private ConflictResolution applyToAllBinaryResolution;
    private ConflictResolution applyToAllPropertyResolution;

    public SVNConflictResolver(IResource resource, int textHandling, int binaryHandling, int propertyHandling) {
        this.resource = resource;
        this.textHandling = textHandling;
        this.binaryHandling = binaryHandling;
        this.propertyHandling = propertyHandling;
    }

    public SVNConflictResult resolve(SVNConflictDescriptor descrip) throws SVNClientException {
        if (descrip.getReason() == 0) {
            if (descrip.isBinary()) {
                int handling = descrip.getConflictKind() == 1 ? this.propertyHandling : this.binaryHandling;
                if (handling == 6) {
                    ConflictResolution conflictResolution = this.getConflictResolution(descrip);
                    this.conflictResolutions.add(conflictResolution);
                    return new SVNConflictResult(conflictResolution.getResolution(), descrip.getMergedPath());
                }
                this.conflictResolutions.add(new ConflictResolution(descrip, handling));
                return new SVNConflictResult(handling, descrip.getMergedPath());
            }
            int handling = descrip.getConflictKind() == 1 ? this.propertyHandling : this.textHandling;
            if (handling == 6) {
                ConflictResolution conflictResolution = this.getConflictResolution(descrip);
                this.conflictResolutions.add(conflictResolution);
                return new SVNConflictResult(conflictResolution.getResolution(), conflictResolution.getMergedPath());
            }
            this.conflictResolutions.add(new ConflictResolution(descrip, handling));
            return new SVNConflictResult(handling, descrip.getMergedPath());
        }
        return new SVNConflictResult(0, descrip.getMergedPath());
    }

    private ConflictResolution getConflictResolution(final SVNConflictDescriptor descrip) {
        ConflictResolution conflictResolution;
        block46: {
            this.wait = false;
            this.dialogWizard = null;
            conflictResolution = null;
            if (descrip.getConflictKind() == 1 && this.applyToAllPropertyResolution != null) {
                conflictResolution = new ConflictResolution(descrip, this.applyToAllPropertyResolution.getResolution());
            } else if (descrip.isBinary() && this.applyToAllBinaryResolution != null) {
                conflictResolution = new ConflictResolution(descrip, this.applyToAllBinaryResolution.getResolution());
            } else if (descrip.getConflictKind() != 1 && !descrip.isBinary() && this.applyToAllTextResolution != null) {
                conflictResolution = new ConflictResolution(descrip, this.applyToAllTextResolution.getResolution());
            }
            if (conflictResolution == null) {
                Display.getDefault().asyncExec(new Runnable(){

                    public void run() {
                        SVNConflictResolver.this.dialogWizard = new DialogWizard(1);
                        SVNConflictResolver.this.dialogWizard.setConflictDescriptor(descrip);
                        SVNConflictResolver.this.dialogWizard.setResources(new IResource[]{SVNConflictResolver.this.resource});
                        MergeWizardDialog dialog = new MergeWizardDialog(Display.getDefault().getActiveShell(), (IWizard)SVNConflictResolver.this.dialogWizard);
                        dialog.open();
                    }
                });
                while (this.dialogWizard == null || this.dialogWizard.getConflictResolution() == null) {
                    try {
                        Thread.sleep(10L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
                conflictResolution = this.dialogWizard.getConflictResolution();
                if (conflictResolution.isApplyToAll()) {
                    if (descrip.getConflictKind() == 1) {
                        this.applyToAllPropertyResolution = conflictResolution;
                    } else if (descrip.isBinary()) {
                        this.applyToAllBinaryResolution = conflictResolution;
                    } else {
                        this.applyToAllTextResolution = conflictResolution;
                    }
                }
            }
            try {
                File pathFile;
                if (conflictResolution.getResolution() == 20) {
                    this.finished = false;
                    this.workingTempFile = null;
                    pathFile = new File(descrip.getPath());
                    this.mergedFile = new File(descrip.getMergedPath());
                    try {
                        this.workingTempFile = this.createTempFile(pathFile);
                        this.copyFile(this.mergedFile, this.workingTempFile);
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    IFileStore fileStore = EFS.getLocalFileSystem().getStore((IPath)new Path(this.workingTempFile.getAbsolutePath()));
                    final IWorkbenchPage page = this.part.getSite().getPage();
                    ExternalFileEditorInput editorInput = new ExternalFileEditorInput(fileStore);
                    String editorId = this.getEditorId(fileStore);
                    Display.getDefault().asyncExec(new Runnable((IEditorInput)editorInput, editorId){
                        private final /* synthetic */ IEditorInput val$editorInput;
                        private final /* synthetic */ String val$editorId;
                        {
                            this.val$editorInput = iEditorInput;
                            this.val$editorId = string;
                        }

                        public void run() {
                            try {
                                final IEditorPart editorPart = page.openEditor(this.val$editorInput, this.val$editorId);
                                if (editorPart == null) {
                                    SVNConflictResolver.this.resolution = 0;
                                    SVNConflictResolver.this.finished = true;
                                } else {
                                    IPartListener2 closeListener = new IPartListener2(){

                                        public void partClosed(IWorkbenchPartReference partRef) {
                                            if (partRef.getPart(false) == editorPart) {
                                                SVNConflictResolver.this.finishEditing();
                                            }
                                        }

                                        public void partActivated(IWorkbenchPartReference partRef) {
                                        }

                                        public void partBroughtToTop(IWorkbenchPartReference partRef) {
                                        }

                                        public void partDeactivated(IWorkbenchPartReference partRef) {
                                        }

                                        public void partHidden(IWorkbenchPartReference partRef) {
                                        }

                                        public void partInputChanged(IWorkbenchPartReference partRef) {
                                        }

                                        public void partOpened(IWorkbenchPartReference partRef) {
                                        }

                                        public void partVisible(IWorkbenchPartReference partRef) {
                                        }
                                    };
                                    page.addPartListener(closeListener);
                                }
                            }
                            catch (PartInitException e) {
                                e.printStackTrace();
                            }
                        }
                    });
                    while (!this.finished) {
                        try {
                            Thread.sleep(1000L);
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                    conflictResolution = new ConflictResolution(descrip, this.resolution);
                    if (!conflictResolution.isResolved()) {
                        if (descrip.getConflictKind() == 1) {
                            this.applyToAllPropertyResolution = null;
                        } else if (descrip.isBinary()) {
                            this.applyToAllBinaryResolution = null;
                        } else {
                            this.applyToAllTextResolution = null;
                        }
                    }
                }
                if (conflictResolution.getResolution() != 21) break block46;
                pathFile = new File(descrip.getPath());
                File conflictNewFile = new File(descrip.getTheirPath());
                File conflictWorkingFile = new File(descrip.getMyPath());
                if (descrip.getConflictKind() == 1 && descrip.getMergedPath() == null) {
                    try {
                        final String theirValue = this.getPropertyValue(conflictNewFile);
                        final String myValue = this.getPropertyValue(conflictWorkingFile);
                        this.dialogWizard = null;
                        Display.getDefault().asyncExec(new Runnable(){

                            public void run() {
                                SVNConflictResolver.this.dialogWizard = new DialogWizard(10);
                                SVNConflictResolver.this.dialogWizard.setConflictDescriptor(descrip);
                                SVNConflictResolver.this.dialogWizard.setMyValue(myValue);
                                SVNConflictResolver.this.dialogWizard.setIncomingValue(theirValue);
                                SVNConflictResolver.this.dialogWizard.setResources(new IResource[]{SVNConflictResolver.this.resource});
                                MergeWizardDialog dialog = new MergeWizardDialog(Display.getDefault().getActiveShell(), (IWizard)SVNConflictResolver.this.dialogWizard);
                                dialog.open();
                            }
                        });
                        while (this.dialogWizard == null || this.dialogWizard.getValueToUse() == null) {
                        }
                        String valueToUse = this.dialogWizard.getValueToUse();
                        if (!this.dialogWizard.isConflictResolved()) {
                            conflictResolution = new ConflictResolution(descrip, 0);
                            return conflictResolution;
                        }
                        this.mergeTempFile = this.createTempFile(pathFile);
                        this.setPropertyValue(this.mergeTempFile, valueToUse);
                        conflictResolution = new ConflictResolution(descrip, 6);
                        conflictResolution.setMergedPath(this.mergeTempFile.getAbsolutePath());
                        return conflictResolution;
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                this.workingTempFile = null;
                this.mergeTempFile = null;
                File mergedFile = descrip.getMergedPath() == null ? new File(descrip.getPath()) : new File(descrip.getMergedPath());
                try {
                    this.workingTempFile = this.createTempFile(pathFile);
                    this.copyFile(conflictWorkingFile, this.workingTempFile);
                    this.mergeTempFile = this.createTempFile(pathFile);
                    this.copyFile(mergedFile, this.mergeTempFile);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                File conflictOldFile = new File(descrip.getBasePath());
                final MergeEditConflictsAction editConflictsAction = new MergeEditConflictsAction(conflictNewFile, conflictOldFile, this.workingTempFile, mergedFile, pathFile.getName());
                Display.getDefault().asyncExec(new Runnable(){

                    public void run() {
                        editConflictsAction.run(null);
                    }
                });
                while (editConflictsAction.getMergeConflictsCompareInput() == null || !editConflictsAction.getMergeConflictsCompareInput().isFinished()) {
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
                if (editConflictsAction.getMergeConflictsCompareInput().isResolved()) {
                    conflictResolution = new ConflictResolution(descrip, editConflictsAction.getMergeConflictsCompareInput().getResolution());
                } else {
                    conflictResolution = new ConflictResolution(descrip, editConflictsAction.getMergeConflictsCompareInput().getResolution());
                    if (descrip.getConflictKind() == 1) {
                        this.applyToAllPropertyResolution = null;
                    } else if (descrip.isBinary()) {
                        this.applyToAllBinaryResolution = null;
                    } else {
                        this.applyToAllTextResolution = null;
                    }
                    try {
                        this.copyFile(this.mergeTempFile, mergedFile);
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
            catch (RuntimeException re) {
                conflictResolution = new ConflictResolution(descrip, 0);
                this.wait = true;
                Display.getDefault().asyncExec(new Runnable(){

                    public void run() {
                        Activator.handleError(Messages.SVNConflictResolver_handleConflictError, re);
                        MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)Messages.SVNConflictResolver_handleConflict, (String)(String.valueOf(Messages.SVNConflictResolver_conflictNotHandled) + re.getLocalizedMessage() + Messages.SVNConflictResolver_resolveLater));
                        re.printStackTrace();
                        SVNConflictResolver.this.wait = false;
                    }
                });
            }
        }
        while (this.wait) {
        }
        return conflictResolution;
    }

    private File createTempFile(File baseOnFile) throws IOException {
        FileNode fileNode = new FileNode(baseOnFile);
        File tempFile = File.createTempFile(fileNode.getPrefix(), "." + fileNode.getType());
        tempFile.deleteOnExit();
        return tempFile;
    }

    private String getEditorId(IFileStore file) {
        IWorkbench workbench = PlatformUI.getWorkbench();
        IEditorRegistry editorRegistry = workbench.getEditorRegistry();
        IEditorDescriptor descriptor = editorRegistry.getDefaultEditor(file.getName(), this.getContentType(file));
        if (descriptor == null && editorRegistry.isSystemInPlaceEditorAvailable(file.getName())) {
            descriptor = editorRegistry.findEditor("org.eclipse.ui.systemInPlaceEditor");
        }
        if (descriptor == null && editorRegistry.isSystemExternalEditorAvailable(file.getName())) {
            descriptor = editorRegistry.findEditor("org.eclipse.ui.systemExternalEditor");
        }
        if (descriptor != null) {
            return descriptor.getId();
        }
        return "org.eclipse.ui.DefaultTextEditor";
    }

    /*
     * Unable to fully structure code
     */
    private IContentType getContentType(IFileStore fileStore) {
        if (fileStore == null) {
            return null;
        }
        stream = null;
        stream = fileStore.openInputStream(0, null);
        var4_3 = Platform.getContentTypeManager().findContentTypeFor(stream, fileStore.getName());
        try {
            if (stream != null) {
                stream.close();
            }
        }
        catch (IOException v0) {}
        return var4_3;
        catch (IOException v1) {
            ** try [egrp 2[TRYBLOCK] [5 : 49->50)] { 
lbl15:
            // 2 sources

            while (true) {
                try {
                    if (stream != null) {
                        stream.close();
                    }
                }
                catch (IOException v2) {}
                return null;
            }
        }
        catch (CoreException v3) {
            ** continue;
lbl-1000:
            // 3 sources

            {
                catch (Throwable var3_4) {
                    try {
                        if (stream != null) {
                            stream.close();
                        }
                    }
                    catch (IOException v4) {}
                    throw var3_4;
                }
            }
        }
    }

    private void finishEditing() {
        DialogWizard dialogWizard = new DialogWizard(3);
        MergeWizardDialog dialog = new MergeWizardDialog(Display.getDefault().getActiveShell(), (IWizard)dialogWizard);
        dialog.open();
        try {
            this.copyFile(this.workingTempFile, this.mergedFile);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.resolution = dialogWizard.getResolution();
        this.finished = true;
    }

    public ConflictResolution[] getConflictResolutions() {
        ConflictResolution[] conflictResolutionArray = new ConflictResolution[this.conflictResolutions.size()];
        this.conflictResolutions.toArray(conflictResolutionArray);
        return conflictResolutionArray;
    }

    public int getTextHandling() {
        return this.textHandling;
    }

    public int getBinaryHandling() {
        return this.binaryHandling;
    }

    public int getResolvedConflictCount(int conflictKind) {
        if (this.textHandling == 0 && this.binaryHandling == 0) {
            return 0;
        }
        int resolvedConflicts = 0;
        for (ConflictResolution conflictResolution : this.conflictResolutions) {
            if (conflictResolution.getResolution() == 0 || conflictResolution.getConflictDescriptor().getConflictKind() != conflictKind) continue;
            ++resolvedConflicts;
        }
        return resolvedConflicts;
    }

    public void setPart(IWorkbenchPart part) {
        this.part = part;
    }

    private void copyFile(File fromFile, File toFile) throws IOException {
        FileInputStream from = null;
        FileOutputStream to = null;
        try {
            int bytes_read;
            from = new FileInputStream(fromFile);
            to = new FileOutputStream(toFile);
            byte[] buffer = new byte[4096];
            while ((bytes_read = from.read(buffer)) != -1) {
                to.write(buffer, 0, bytes_read);
            }
        }
        catch (Throwable throwable) {
            if (from != null) {
                try {
                    from.close();
                }
                catch (IOException iOException) {}
            }
            if (to != null) {
                try {
                    to.close();
                }
                catch (IOException iOException) {}
            }
            throw throwable;
        }
        if (from != null) {
            try {
                from.close();
            }
            catch (IOException iOException) {}
        }
        if (to != null) {
            try {
                to.close();
            }
            catch (IOException iOException) {}
        }
    }

    private String getPropertyValue(File propertyFile) throws IOException {
        StringBuffer fileData = new StringBuffer();
        BufferedReader reader = new BufferedReader(new FileReader(propertyFile));
        char[] buf = new char[1024];
        int numRead = 0;
        while ((numRead = reader.read(buf)) != -1) {
            String readData = String.valueOf(buf, 0, numRead);
            fileData.append(readData);
            buf = new char[1024];
        }
        reader.close();
        return fileData.toString();
    }

    private void setPropertyValue(File propertyFile, String value) throws IOException {
        FileOutputStream out = new FileOutputStream(propertyFile);
        PrintStream p = new PrintStream(out);
        p.print(value);
        p.close();
    }

    public static String getResolutionDescription(String resolution) {
        if (resolution == null || resolution.trim().length() == 0 || resolution.equals("0")) {
            return "Unresolved";
        }
        if (resolution.equals("Y")) {
            return "Resolution unknown";
        }
        int res = Integer.parseInt(resolution);
        switch (res) {
            case 1: {
                return "Base version used";
            }
            case 2: {
                return "Incoming version used";
            }
            case 3: {
                return "Local version used";
            }
            case 4: {
                return "Incoming version used";
            }
            case 5: {
                return "Local version used";
            }
            case 6: {
                return "Merged version used";
            }
        }
        return "Unresolved";
    }
}

