local OVALE, Ovale = ...
local OvaleScripts = Ovale.OvaleScripts

do
	local name = "nerien_priest_holy"
	local desc = "[6.2] Nerien: Holy"
	local code = [[
###
### Nerien's holy priest script.
###

Include(ovale_common)
Include(ovale_trinkets_mop)
Include(ovale_trinkets_wod)
Include(ovale_priest_spells)

AddCheckBox(opt_potion_mana ItemName(draenic_mana_potion) default specialization=holy)

AddFunction HolyUsePotionMana
{
	if CheckBoxOn(opt_potion_mana) Item(draenic_mana_potion usable=1)
}

AddFunction HolyAoeActions
{
	# Use PoM when Divine Insight procs.
	if BuffPresent(divine_insight_buff) Spell(prayer_of_mending)

	# Cast CoH and PoM on cooldown.
	Spell(circle_of_healing)
	Spell(prayer_of_mending)

	# AoE filler.
	Spell(prayer_of_healing)
}

AddFunction HolyCdActions
{
	if ManaPercent() <= 75 HolyUsePotionMana()
	if not Talent(mindbender_talent) and ManaPercent() < 80 Spell(shadowfiend)
	if ManaPercent() < 90 Spell(arcane_torrent_mana)
	Spell(lightwell)
	Spell(blood_fury_sp)
	Spell(berserking)
	if Talent(power_infusion_talent) Spell(power_infusion)
	Spell(divine_hymn)
}

AddFunction HolyMainActions
{
	# Maintain Renew on the tank.
	if BuffCountOnAny(renew_buff) == 0 Spell(renew)
	# Refresh Renew on the tank using Holy Word: Serenity.
	if Stance(priest_chakra_serenity) Spell(holy_word)

	# Use PoM when Divine Insight procs.
	if BuffPresent(divine_insight_buff) Spell(prayer_of_mending)
	# Use Flash Heal when Surge of Light procs.
	if BuffPresent(surge_of_light_buff) Spell(flash_heal)
	# Use PoM on cooldown.
	Spell(prayer_of_mending)
	# Use Heal at 2 stacks of Serendipity.
	if BuffStacks(serendipity_buff) >= 2 and ManaPercent() > 40 Spell(heal)

	# Single-target filler.
	if Stance(priest_chakra_sanctuary) Spell(renew)
	Spell(heal)
}

AddFunction HolyPrecombatMainActions
{
	if not BuffPresent(stamina_buff any=1) Spell(power_word_fortitude)
	# Default to Chakra: Sanctuary for raid healing.
	if not Stance(priest_chakra_sanctuary) and not Stance(priest_chakra_serenity) Spell(chakra_sanctuary)
	# PoM and Renew the tank.
	Spell(prayer_of_mending)
	if BuffCountOnAny(renew_buff) == 0 Spell(renew)
}

AddFunction HolyPrecombatCdActions
{
	unless not BuffPresent(stamina_buff any=1) and Spell(power_word_fortitude)
		or not Stance(priest_chakra_sanctuary) and not Stance(priest_chakra_serenity) and Spell(chakra_sanctuary)
	{
		Spell(lightwell)
	}
}

AddFunction HolyShortCdActions
{
	if Talent(power_word_solace_talent) Spell(power_word_solace)
	if Talent(mindbender_talent) and ManaPercent() < 80 Spell(mindbender)
	if Talent(halo_talent) Spell(halo_heal)
	if Talent(divine_star_talent) Spell(divine_star_heal)
	if Talent(cascade_talent) Spell(cascade_heal)
	if Stance(priest_chakra_sanctuary) Spell(holy_word)
}

### Holy icons.

AddCheckBox(opt_priest_holy_aoe L(AOE) default specialization=holy)

AddIcon checkbox=opt_priest_holy_aoe help=shortcd specialization=holy
{
	HolyShortCdActions()
}

AddIcon help=main specialization=holy
{
	if not InCombat() HolyPrecombatMainActions()
	HolyMainActions()
}

AddIcon checkbox=opt_priest_holy_aoe help=aoe specialization=holy
{
	if not InCombat() HolyPrecombatMainActions()
	HolyAoeActions()
}

AddIcon help=cd specialization=holy
{
	if not InCombat() HolyPrecombatCdActions()
	HolyCdActions()
}
]]
	OvaleScripts:RegisterScript("PRIEST", "holy", name, desc, code, "script")
end

-- THE REST OF THIS FILE IS AUTOMATICALLY GENERATED.
-- ANY CHANGES MADE BELOW THIS POINT WILL BE LOST.

do
	local name = "simulationcraft_priest_shadow_t18m"
	local desc = "[7.0] SimulationCraft: Priest_Shadow_T18M"
	local code = [[
# Based on SimulationCraft profile "Priest_Shadow_T18M".
#	class=priest
#	spec=shadow
#	talents=1133231

Include(ovale_common)
Include(ovale_trinkets_mop)
Include(ovale_trinkets_wod)
Include(ovale_priest_spells)

AddCheckBox(opt_potion_intellect ItemName(draenic_intellect_potion) default specialization=shadow)
AddCheckBox(opt_legendary_ring_intellect ItemName(legendary_ring_intellect) default specialization=shadow)

AddFunction ShadowUsePotionIntellect
{
	if CheckBoxOn(opt_potion_intellect) and target.Classification(worldboss) Item(draenic_intellect_potion usable=1)
}

### actions.default

AddFunction ShadowDefaultMainActions
{
	#call_action_list,name=vf,if=buff.voidform.up
	if BuffPresent(voidform_buff) ShadowVfMainActions()
	#call_action_list,name=main
	ShadowMainMainActions()
}

AddFunction ShadowDefaultCdActions
{
	#use_item,slot=finger1
	if CheckBoxOn(opt_legendary_ring_intellect) Item(legendary_ring_intellect usable=1)
}

### actions.main

AddFunction ShadowMainMainActions
{
	#void_eruption
	Spell(void_eruption)
	#mindbender,if=talent.mindbender.enabled&set_bonus.tier18_2pc
	if Talent(mindbender_talent) and ArmorSetBonus(T18 2) Spell(mindbender)
	#shadow_word_death
	Spell(shadow_word_death)
	#mind_blast
	Spell(mind_blast)
	#shadow_word_pain,if=!ticking,cycle_targets=1
	if not target.DebuffPresent(shadow_word_pain_debuff) Spell(shadow_word_pain)
	#vampiric_touch,if=!ticking,cycle_targets=1
	if not target.DebuffPresent(vampiric_touch_debuff) Spell(vampiric_touch)
	#shadow_word_void
	Spell(shadow_word_void)
	#shadow_crash,if=talent.shadow_crash.enabled
	if Talent(shadow_crash_talent) Spell(shadow_crash)
	#shadowfiend,if=!talent.mindbender.enabled
	if not Talent(mindbender_talent) Spell(shadowfiend)
	#mind_flay,if=!talent.mind_spike.enabled,interrupt=1,chain=1
	if not Talent(mind_spike_talent) Spell(mind_flay)
	#mind_spike,if=talent.mind_spike.enabled
	if Talent(mind_spike_talent) Spell(mind_spike)
	#shadow_word_pain
	Spell(shadow_word_pain)
}

### actions.precombat

AddFunction ShadowPrecombatMainActions
{
	#mind_blast
	Spell(mind_blast)
}

AddFunction ShadowPrecombatCdActions
{
	#flask,type=greater_draenic_intellect_flask
	#food,type=pickled_eel
	#snapshot_stats
	#potion,name=draenic_intellect
	ShadowUsePotionIntellect()
}

AddFunction ShadowPrecombatCdPostConditions
{
	Spell(mind_blast)
}

### actions.vf

AddFunction ShadowVfMainActions
{
	#surrender_to_madness,if=talent.surrender_to_madness.enabled&insanity>=25&(cooldown.void_bolt.up|cooldown.void_torrent.up)&target.time_to_die<120
	if Talent(surrender_to_madness_talent) and FIXME_insanity >= 25 and { not SpellCooldown(void_bolt) > 0 or not SpellCooldown(void_torrent) > 0 } and target.TimeToDie() < 120 Spell(surrender_to_madness)
	#power_infusion,if=buff.voidform.stack>=10
	if BuffStacks(voidform_buff) >= 10 Spell(power_infusion)
	#berserking,if=buff.voidform.stack>10
	if BuffStacks(voidform_buff) > 10 Spell(berserking)
	#dispersion
	Spell(dispersion)
	#void_torrent,if=buff.voidform.stack>=10
	if BuffStacks(voidform_buff) >= 10 Spell(void_torrent)
	#void_bolt,if=dot.shadow_word_pain.remains<3.5*gcd,cycle_targets=1
	if target.DebuffRemaining(shadow_word_pain_debuff) < 3.5 * GCD() Spell(void_bolt)
	#void_bolt
	Spell(void_bolt)
	#mind_blast
	Spell(mind_blast)
	#mindbender,if=talent.mindbender.enabled
	if Talent(mindbender_talent) Spell(mindbender)
	#shadow_word_death
	Spell(shadow_word_death)
	#shadow_word_void
	Spell(shadow_word_void)
	#shadowfiend,if=!talent.mindbender.enabled
	if not Talent(mindbender_talent) Spell(shadowfiend)
	#shadow_word_pain,if=!ticking,cycle_targets=1
	if not target.DebuffPresent(shadow_word_pain_debuff) Spell(shadow_word_pain)
	#vampiric_touch,if=!ticking,cycle_targets=1
	if not target.DebuffPresent(vampiric_touch_debuff) Spell(vampiric_touch)
	#shadow_crash,if=talent.shadow_crash.enabled
	if Talent(shadow_crash_talent) Spell(shadow_crash)
	#mind_flay,if=!talent.mind_spike.enabled,interrupt=1,chain=1
	if not Talent(mind_spike_talent) Spell(mind_flay)
	#mind_spike,if=talent.mind_spike.enabled
	if Talent(mind_spike_talent) Spell(mind_spike)
	#shadow_word_pain
	Spell(shadow_word_pain)
}

### Shadow icons.

AddCheckBox(opt_priest_shadow_aoe L(AOE) default specialization=shadow)

AddIcon enemies=1 help=main specialization=shadow
{
	if not InCombat() ShadowPrecombatMainActions()
	ShadowDefaultMainActions()
}

AddIcon checkbox=opt_priest_shadow_aoe help=aoe specialization=shadow
{
	if not InCombat() ShadowPrecombatMainActions()
	ShadowDefaultMainActions()
}

AddIcon checkbox=!opt_priest_shadow_aoe enemies=1 help=cd specialization=shadow
{
	if not InCombat() ShadowPrecombatCdActions()
	unless not InCombat() and ShadowPrecombatCdPostConditions()
	{
		ShadowDefaultCdActions()
	}
}

AddIcon checkbox=opt_priest_shadow_aoe help=cd specialization=shadow
{
	if not InCombat() ShadowPrecombatCdActions()
	unless not InCombat() and ShadowPrecombatCdPostConditions()
	{
		ShadowDefaultCdActions()
	}
}

### Required symbols
# berserking
# dispersion
# draenic_intellect_potion
# legendary_ring_intellect
# mind_blast
# mind_flay
# mind_spike
# mind_spike_talent
# mindbender
# mindbender_talent
# power_infusion
# shadow_crash
# shadow_crash_talent
# shadow_word_death
# shadow_word_pain
# shadow_word_pain_debuff
# shadow_word_void
# shadowfiend
# surrender_to_madness
# surrender_to_madness_talent
# vampiric_touch
# vampiric_touch_debuff
# void_bolt
# void_eruption
# void_torrent
# voidform_buff
]]
	OvaleScripts:RegisterScript("PRIEST", "shadow", name, desc, code, "script")
end
