local OVALE, Ovale = ...
local OvaleScripts = Ovale.OvaleScripts

-- THE REST OF THIS FILE IS AUTOMATICALLY GENERATED.
-- ANY CHANGES MADE BELOW THIS POINT WILL BE LOST.

do
	local name = "simulationcraft_mage_arcane_t18m"
	local desc = "[7.0] SimulationCraft: Mage_Arcane_T18M"
	local code = [[
# Based on SimulationCraft profile "Mage_Arcane_T18M".
#	class=mage
#	spec=arcane
#	talents=3003222

Include(ovale_common)
Include(ovale_trinkets_mop)
Include(ovale_trinkets_wod)
Include(ovale_mage_spells)

AddCheckBox(opt_interrupt L(interrupt) default specialization=arcane)
AddCheckBox(opt_potion_intellect ItemName(draenic_intellect_potion) default specialization=arcane)
AddCheckBox(opt_time_warp SpellName(time_warp) specialization=arcane)

AddFunction ArcaneUsePotionIntellect
{
	if CheckBoxOn(opt_potion_intellect) and target.Classification(worldboss) Item(draenic_intellect_potion usable=1)
}

AddFunction ArcaneInterruptActions
{
	if CheckBoxOn(opt_interrupt) and not target.IsFriend() and target.IsInterruptible()
	{
		Spell(counterspell)
		if not target.Classification(worldboss)
		{
			Spell(arcane_torrent_mana)
			if target.InRange(quaking_palm) Spell(quaking_palm)
		}
	}
}

### actions.default

AddFunction ArcaneDefaultMainActions
{
	#stop_burn_phase,if=prev_gcd.evocation&burn_phase_duration>gcd.max
	if PreviousGCDSpell(evocation) and GetStateDuration(burn_phase) > GCD() and GetState(burn_phase) > 0 SetState(burn_phase 0)
	#time_warp,if=target.health.pct<25|time>5
	if { target.HealthPercent() < 25 or TimeInCombat() > 5 } and CheckBoxOn(opt_time_warp) and DebuffExpires(burst_haste_debuff any=1) Spell(time_warp)
	#rune_of_power,if=buff.rune_of_power.remains<2*spell_haste
	if TotemRemaining(rune_of_power) < 2 * { 100 / { 100 + SpellHaste() } } Spell(rune_of_power)
	#mirror_image
	Spell(mirror_image)
}

AddFunction ArcaneDefaultShortCdActions
{
	#stop_burn_phase,if=prev_gcd.evocation&burn_phase_duration>gcd.max
	if PreviousGCDSpell(evocation) and GetStateDuration(burn_phase) > GCD() and GetState(burn_phase) > 0 SetState(burn_phase 0)
}

AddFunction ArcaneDefaultCdActions
{
	#counterspell,if=target.debuff.casting.react
	if target.IsInterruptible() ArcaneInterruptActions()
	#stop_burn_phase,if=prev_gcd.evocation&burn_phase_duration>gcd.max
	if PreviousGCDSpell(evocation) and GetStateDuration(burn_phase) > GCD() and GetState(burn_phase) > 0 SetState(burn_phase 0)
}

### actions.precombat

AddFunction ArcanePrecombatMainActions
{
	#flask,type=greater_draenic_intellect_flask
	#food,type=buttered_sturgeon
	#snapshot_stats
	#rune_of_power
	Spell(rune_of_power)
	#mirror_image
	Spell(mirror_image)
	#arcane_blast
	Spell(arcane_blast)
}

AddFunction ArcanePrecombatShortCdPostConditions
{
	Spell(rune_of_power) or Spell(mirror_image) or Spell(arcane_blast)
}

AddFunction ArcanePrecombatCdActions
{
	unless Spell(rune_of_power) or Spell(mirror_image)
	{
		#potion,name=draenic_intellect
		ArcaneUsePotionIntellect()
	}
}

AddFunction ArcanePrecombatCdPostConditions
{
	Spell(rune_of_power) or Spell(mirror_image) or Spell(arcane_blast)
}

### Arcane icons.

AddCheckBox(opt_mage_arcane_aoe L(AOE) default specialization=arcane)

AddIcon checkbox=!opt_mage_arcane_aoe enemies=1 help=shortcd specialization=arcane
{
	unless not InCombat() and ArcanePrecombatShortCdPostConditions()
	{
		ArcaneDefaultShortCdActions()
	}
}

AddIcon checkbox=opt_mage_arcane_aoe help=shortcd specialization=arcane
{
	unless not InCombat() and ArcanePrecombatShortCdPostConditions()
	{
		ArcaneDefaultShortCdActions()
	}
}

AddIcon enemies=1 help=main specialization=arcane
{
	if not InCombat() ArcanePrecombatMainActions()
	ArcaneDefaultMainActions()
}

AddIcon checkbox=opt_mage_arcane_aoe help=aoe specialization=arcane
{
	if not InCombat() ArcanePrecombatMainActions()
	ArcaneDefaultMainActions()
}

AddIcon checkbox=!opt_mage_arcane_aoe enemies=1 help=cd specialization=arcane
{
	if not InCombat() ArcanePrecombatCdActions()
	unless not InCombat() and ArcanePrecombatCdPostConditions()
	{
		ArcaneDefaultCdActions()
	}
}

AddIcon checkbox=opt_mage_arcane_aoe help=cd specialization=arcane
{
	if not InCombat() ArcanePrecombatCdActions()
	unless not InCombat() and ArcanePrecombatCdPostConditions()
	{
		ArcaneDefaultCdActions()
	}
}

### Required symbols
# arcane_blast
# arcane_torrent_mana
# counterspell
# draenic_intellect_potion
# evocation
# mirror_image
# quaking_palm
# rune_of_power
# time_warp
]]
	OvaleScripts:RegisterScript("MAGE", "arcane", name, desc, code, "script")
end

do
	local name = "simulationcraft_mage_fire_t18m"
	local desc = "[7.0] SimulationCraft: Mage_Fire_T18M"
	local code = [[
# Based on SimulationCraft profile "Mage_Fire_T18M".
#	class=mage
#	spec=fire
#	talents=3003322

Include(ovale_common)
Include(ovale_trinkets_mop)
Include(ovale_trinkets_wod)
Include(ovale_mage_spells)

AddCheckBox(opt_interrupt L(interrupt) default specialization=fire)
AddCheckBox(opt_potion_intellect ItemName(draenic_intellect_potion) default specialization=fire)
AddCheckBox(opt_legendary_ring_intellect ItemName(legendary_ring_intellect) default specialization=fire)
AddCheckBox(opt_time_warp SpellName(time_warp) specialization=fire)

AddFunction FireUsePotionIntellect
{
	if CheckBoxOn(opt_potion_intellect) and target.Classification(worldboss) Item(draenic_intellect_potion usable=1)
}

AddFunction FireInterruptActions
{
	if CheckBoxOn(opt_interrupt) and not target.IsFriend() and target.IsInterruptible()
	{
		Spell(counterspell)
		if not target.Classification(worldboss)
		{
			Spell(arcane_torrent_mana)
			if target.InRange(quaking_palm) Spell(quaking_palm)
		}
	}
}

### actions.default

AddFunction FireDefaultMainActions
{
	#time_warp,if=target.health.pct<25|time=0
	if { target.HealthPercent() < 25 or TimeInCombat() == 0 } and CheckBoxOn(opt_time_warp) and DebuffExpires(burst_haste_debuff any=1) Spell(time_warp)
	#call_action_list,name=combustion_phase,if=cooldown.combustion.remains=0&buff.hot_streak.up|buff.combustion.up
	if not SpellCooldown(combustion) > 0 and BuffPresent(hot_streak_buff) or BuffPresent(combustion_buff) FireCombustionPhaseMainActions()
	#call_action_list,name=comb_prep,if=cooldown.combustion.remains<6&cooldown.flame_on.remains<6
	if SpellCooldown(combustion) < 6 and SpellCooldown(flame_on) < 6 FireCombPrepMainActions()
	#call_action_list,name=single_target
	FireSingleTargetMainActions()
}

AddFunction FireDefaultCdActions
{
	#counterspell,if=target.debff.casting.react
	if FIXME_target.debff.casting.react FireInterruptActions()

	unless { target.HealthPercent() < 25 or TimeInCombat() == 0 } and CheckBoxOn(opt_time_warp) and DebuffExpires(burst_haste_debuff any=1) and Spell(time_warp)
	{
		#call_action_list,name=combustion_phase,if=cooldown.combustion.remains=0&buff.hot_streak.up|buff.combustion.up
		if not SpellCooldown(combustion) > 0 and BuffPresent(hot_streak_buff) or BuffPresent(combustion_buff) FireCombustionPhaseCdActions()
	}
}

### actions.active_talents

AddFunction FireActiveTalentsMainActions
{
	#dragons_breath,if=equipped.132863
	if HasEquippedItem(132863) Spell(dragons_breath)
}

### actions.comb_prep

AddFunction FireCombPrepMainActions
{
	#fire_blast,if=buff.heating_up.up
	if BuffPresent(heating_up_buff) Spell(fire_blast)
	#fireball
	Spell(fireball)
}

### actions.combustion_phase

AddFunction FireCombustionPhaseMainActions
{
	#combustion
	Spell(combustion)
	#blood_fury
	Spell(blood_fury_sp)
	#berserking
	Spell(berserking)
	#arcane_torrent
	Spell(arcane_torrent_mana)
	#call_action_list,name=active_talents
	FireActiveTalentsMainActions()
	#pyroblast,if=buff.hot_streak.up
	if BuffPresent(hot_streak_buff) Spell(pyroblast)
	#fire_blast,if=!prev_off_gcd.fire_blast
	if not PreviousOffGCDSpell(fire_blast) Spell(fire_blast)
	#scorch,if=target.health.pct<=25&equipped.132454
	if target.HealthPercent() <= 25 and HasEquippedItem(132454) Spell(scorch)
	#fireball
	Spell(fireball)
}

AddFunction FireCombustionPhaseCdActions
{
	unless Spell(combustion)
	{
		#use_item,slot=finger2
		if CheckBoxOn(opt_legendary_ring_intellect) Item(legendary_ring_intellect usable=1)
	}
}

### actions.precombat

AddFunction FirePrecombatMainActions
{
	#flask,type=greater_draenic_intellect_flask
	#food,type=pickled_eel
	#snapshot_stats
	#rune_of_power
	Spell(rune_of_power)
	#mirror_image
	Spell(mirror_image)
	#pyroblast,if=!talent.mirror_image.enabled|!talent.rune_of_power.enabled
	if not Talent(mirror_image_talent) or not Talent(rune_of_power_talent) Spell(pyroblast)
}

AddFunction FirePrecombatCdActions
{
	unless Spell(rune_of_power) or Spell(mirror_image)
	{
		#potion,name=draenic_intellect
		FireUsePotionIntellect()
	}
}

AddFunction FirePrecombatCdPostConditions
{
	Spell(rune_of_power) or Spell(mirror_image) or { not Talent(mirror_image_talent) or not Talent(rune_of_power_talent) } and Spell(pyroblast)
}

### actions.single_target

AddFunction FireSingleTargetMainActions
{
	#pyroblast,if=buff.hot_streak.up&buff.hot_streak.remains<action.fireball.execute_time
	if BuffPresent(hot_streak_buff) and BuffRemaining(hot_streak_buff) < ExecuteTime(fireball) Spell(pyroblast)
	#pyroblast,if=buff.hot_streak.up
	if BuffPresent(hot_streak_buff) Spell(pyroblast)
	#fire_blast,if=buff.hot_streak.down&buff.heating_up.up
	if BuffExpires(hot_streak_buff) and BuffPresent(heating_up_buff) Spell(fire_blast)
	#call_action_list,name=active_talents
	FireActiveTalentsMainActions()
	#scorch,if=target.health.pct<=25&equipped.132454
	if target.HealthPercent() <= 25 and HasEquippedItem(132454) Spell(scorch)
}

### Fire icons.

AddCheckBox(opt_mage_fire_aoe L(AOE) default specialization=fire)

AddIcon enemies=1 help=main specialization=fire
{
	if not InCombat() FirePrecombatMainActions()
	FireDefaultMainActions()
}

AddIcon checkbox=opt_mage_fire_aoe help=aoe specialization=fire
{
	if not InCombat() FirePrecombatMainActions()
	FireDefaultMainActions()
}

AddIcon checkbox=!opt_mage_fire_aoe enemies=1 help=cd specialization=fire
{
	if not InCombat() FirePrecombatCdActions()
	unless not InCombat() and FirePrecombatCdPostConditions()
	{
		FireDefaultCdActions()
	}
}

AddIcon checkbox=opt_mage_fire_aoe help=cd specialization=fire
{
	if not InCombat() FirePrecombatCdActions()
	unless not InCombat() and FirePrecombatCdPostConditions()
	{
		FireDefaultCdActions()
	}
}

### Required symbols
# 132454
# 132863
# arcane_torrent_mana
# berserking
# blood_fury_sp
# combustion
# combustion_buff
# counterspell
# draenic_intellect_potion
# dragons_breath
# fire_blast
# fireball
# flame_on
# heating_up_buff
# hot_streak_buff
# legendary_ring_intellect
# mirror_image
# mirror_image_talent
# pyroblast
# quaking_palm
# rune_of_power
# rune_of_power_talent
# scorch
# time_warp
]]
	OvaleScripts:RegisterScript("MAGE", "fire", name, desc, code, "script")
end

do
	local name = "simulationcraft_mage_frost_t18m"
	local desc = "[7.0] SimulationCraft: Mage_Frost_T18M"
	local code = [[
# Based on SimulationCraft profile "Mage_Frost_T18M".
#	class=mage
#	spec=frost
#	talents=3003222

Include(ovale_common)
Include(ovale_trinkets_mop)
Include(ovale_trinkets_wod)
Include(ovale_mage_spells)

AddCheckBox(opt_interrupt L(interrupt) default specialization=frost)
AddCheckBox(opt_potion_intellect ItemName(draenic_intellect_potion) default specialization=frost)
AddCheckBox(opt_legendary_ring_intellect ItemName(legendary_ring_intellect) default specialization=frost)
AddCheckBox(opt_time_warp SpellName(time_warp) specialization=frost)

AddFunction FrostUsePotionIntellect
{
	if CheckBoxOn(opt_potion_intellect) and target.Classification(worldboss) Item(draenic_intellect_potion usable=1)
}

AddFunction FrostInterruptActions
{
	if CheckBoxOn(opt_interrupt) and not target.IsFriend() and target.IsInterruptible()
	{
		Spell(counterspell)
		if not target.Classification(worldboss)
		{
			Spell(arcane_torrent_mana)
			if target.InRange(quaking_palm) Spell(quaking_palm)
		}
	}
}

### actions.default

AddFunction FrostDefaultMainActions
{
	#time_warp,if=target.health.pct<25|time>0
	if { target.HealthPercent() < 25 or TimeInCombat() > 0 } and CheckBoxOn(opt_time_warp) and DebuffExpires(burst_haste_debuff any=1) Spell(time_warp)
	#rune_of_power,if=(charges_fractional>=2)|(buff.icy_veins.up&!talent.ray_of_frost.enabled)|(cooldown.icy_veins.remains>target.time_to_die)|cooldown.ray_of_frost.remains=0
	if Charges(rune_of_power count=0) >= 2 or BuffPresent(icy_veins_buff) and not Talent(ray_of_frost_talent) or SpellCooldown(icy_veins) > target.TimeToDie() or not SpellCooldown(ray_of_frost) > 0 Spell(rune_of_power)
	#call_action_list,name=water_jet,if=prev_off_gcd.water_jet|debuff.water_jet.remains>0
	if PreviousOffGCDSpell(water_elemental_water_jet) or target.DebuffRemaining(water_elemental_water_jet_debuff) > 0 FrostWaterJetMainActions()
	#call_action_list,name=single_target
	FrostSingleTargetMainActions()
}

AddFunction FrostDefaultCdActions
{
	#counterspell,if=target.debuff.casting.react
	if target.IsInterruptible() FrostInterruptActions()

	unless { target.HealthPercent() < 25 or TimeInCombat() > 0 } and CheckBoxOn(opt_time_warp) and DebuffExpires(burst_haste_debuff any=1) and Spell(time_warp) or { Charges(rune_of_power count=0) >= 2 or BuffPresent(icy_veins_buff) and not Talent(ray_of_frost_talent) or SpellCooldown(icy_veins) > target.TimeToDie() or not SpellCooldown(ray_of_frost) > 0 } and Spell(rune_of_power)
	{
		unless { PreviousOffGCDSpell(water_elemental_water_jet) or target.DebuffRemaining(water_elemental_water_jet_debuff) > 0 } and FrostWaterJetCdPostConditions()
		{
			#call_action_list,name=single_target
			FrostSingleTargetCdActions()
		}
	}
}

### actions.active_talents

AddFunction FrostActiveTalentsMainActions
{
	#ray_of_frost,if=buff.rune_of_power.up|!talent.rune_of_power.enabled
	if BuffPresent(rune_of_power_buff) or not Talent(rune_of_power_talent) Spell(ray_of_frost)
	#ice_nova
	Spell(ice_nova)
	#frozen_touch,if=buff.fingers_of_frost.stack=0
	if BuffStacks(fingers_of_frost_buff) == 0 Spell(frozen_touch)
	#glacial_spike
	Spell(glacial_spike)
	#comet_storm
	Spell(comet_storm)
}

### actions.cooldowns

AddFunction FrostCooldownsMainActions
{
	#icy_veins
	Spell(icy_veins)
	#blood_fury
	Spell(blood_fury_sp)
	#berserking
	Spell(berserking)
	#arcane_torrent
	Spell(arcane_torrent_mana)
}

AddFunction FrostCooldownsCdActions
{
	unless Spell(icy_veins)
	{
		#use_item,slot=finger2
		if CheckBoxOn(opt_legendary_ring_intellect) Item(legendary_ring_intellect usable=1)
	}
}

### actions.init_water_jet

AddFunction FrostInitWaterJetMainActions
{
	#frostbolt
	Spell(frostbolt)
}

### actions.precombat

AddFunction FrostPrecombatMainActions
{
	#flask,type=greater_draenic_intellect_flask
	#food,type=salty_squid_roll
	#water_elemental
	if not pet.Present() Spell(water_elemental)
	#snapshot_stats
	#rune_of_power
	Spell(rune_of_power)
	#mirror_image
	Spell(mirror_image)
	#frostbolt,if=!talent.frost_bomb.enabled
	if not Talent(frost_bomb_talent) Spell(frostbolt)
	#frost_bomb
	Spell(frost_bomb)
}

AddFunction FrostPrecombatCdActions
{
	unless not pet.Present() and Spell(water_elemental) or Spell(rune_of_power) or Spell(mirror_image)
	{
		#potion,name=draenic_intellect
		FrostUsePotionIntellect()
	}
}

AddFunction FrostPrecombatCdPostConditions
{
	not pet.Present() and Spell(water_elemental) or Spell(rune_of_power) or Spell(mirror_image) or not Talent(frost_bomb_talent) and Spell(frostbolt) or Spell(frost_bomb)
}

### actions.single_target

AddFunction FrostSingleTargetMainActions
{
	#call_action_list,name=cooldowns
	FrostCooldownsMainActions()
	#ice_lance,if=(buff.fingers_of_frost.react&(buff.fingers_of_frost.remains<action.frostbolt.execute_time|buff.fingers_of_frost.remains<buff.fingers_of_frost.react*gcd.max))|prev_gcd.flurry
	if BuffPresent(fingers_of_frost_buff) and { BuffRemaining(fingers_of_frost_buff) < ExecuteTime(frostbolt) or BuffRemaining(fingers_of_frost_buff) < BuffStacks(fingers_of_frost_buff) * GCD() } or PreviousGCDSpell(flurry) Spell(ice_lance)
	#flurry,if=buff.brain_freeze.react&(buff.brain_freeze.remains<action.frostbolt.execute_time|(buff.fingers_of_frost.react=0&debuff.water_jet.remains=0))
	if BuffPresent(brain_freeze_buff) and { BuffRemaining(brain_freeze_buff) < ExecuteTime(frostbolt) or BuffStacks(fingers_of_frost_buff) == 0 and not target.DebuffRemaining(water_elemental_water_jet_debuff) > 0 } Spell(flurry)
	#ice_lance,if=buff.fingers_of_frost.react>(artifact.icy_hand.enabled)|prev_gcd.ebonbolt
	if BuffStacks(fingers_of_frost_buff) > PlayerBuffPresent(icy_hand) or PreviousGCDSpell(ebonbolt) Spell(ice_lance)
	#ice_lance,if=buff.shatterlance.up
	if HasTrinket(t18_class_trinket) and PreviousGCDSpell(frostbolt) Spell(ice_lance)
	#call_action_list,name=active_talents
	FrostActiveTalentsMainActions()
	#call_action_list,name=init_water_jet,if=!talent.lonely_winter.enabled&pet.water_elemental.cooldown.water_jet.remains<=gcd.max&buff.fingers_of_frost.react<2+artifact.icy_hand.enabled&!dot.frozen_orb.ticking
	if not Talent(lonely_winter_talent) and SpellCooldown(water_elemental_water_jet) <= GCD() and BuffStacks(fingers_of_frost_buff) < 2 + PlayerBuffPresent(icy_hand) and not SpellCooldown(frozen_orb) > SpellCooldownDuration(frozen_orb) - 10 FrostInitWaterJetMainActions()
	#frozen_orb,if=buff.fingers_of_frost.stack<2+artifact.icy_hand.enabled
	if BuffStacks(fingers_of_frost_buff) < 2 + PlayerBuffPresent(icy_hand) Spell(frozen_orb)
	#blizzard,if=talent.arctic_gale.enabled
	if Talent(arctic_gale_talent) Spell(blizzard)
	#ice_lance,if=!talent.frost_bomb.enabled&buff.fingers_of_frost.react&(!talent.thermal_void.enabled|cooldown.icy_veins.remains>8)
	if not Talent(frost_bomb_talent) and BuffPresent(fingers_of_frost_buff) and { not Talent(thermal_void_talent) or SpellCooldown(icy_veins) > 8 } Spell(ice_lance)
	#frostbolt
	Spell(frostbolt)
}

AddFunction FrostSingleTargetCdActions
{
	#call_action_list,name=cooldowns
	FrostCooldownsCdActions()
}

### actions.water_jet

AddFunction FrostWaterJetMainActions
{
	#frostbolt,if=prev_off_gcd.water_jet
	if PreviousOffGCDSpell(water_elemental_water_jet) Spell(frostbolt)
	#ice_lance,if=buff.fingers_of_frost.react>=2+artifact.icy_hand.enabled&action.frostbolt.in_flight
	if BuffStacks(fingers_of_frost_buff) >= 2 + PlayerBuffPresent(icy_hand) and InFlightToTarget(frostbolt) Spell(ice_lance)
	#frostbolt,if=debuff.water_jet.remains>cast_time+travel_time
	if target.DebuffRemaining(water_elemental_water_jet_debuff) > CastTime(frostbolt) + TravelTime(frostbolt) Spell(frostbolt)
}

AddFunction FrostWaterJetCdPostConditions
{
	PreviousOffGCDSpell(water_elemental_water_jet) and Spell(frostbolt) or BuffStacks(fingers_of_frost_buff) >= 2 + PlayerBuffPresent(icy_hand) and InFlightToTarget(frostbolt) and Spell(ice_lance) or target.DebuffRemaining(water_elemental_water_jet_debuff) > CastTime(frostbolt) + TravelTime(frostbolt) and Spell(frostbolt)
}

### Frost icons.

AddCheckBox(opt_mage_frost_aoe L(AOE) default specialization=frost)

AddIcon enemies=1 help=main specialization=frost
{
	if not InCombat() FrostPrecombatMainActions()
	FrostDefaultMainActions()
}

AddIcon checkbox=opt_mage_frost_aoe help=aoe specialization=frost
{
	if not InCombat() FrostPrecombatMainActions()
	FrostDefaultMainActions()
}

AddIcon checkbox=!opt_mage_frost_aoe enemies=1 help=cd specialization=frost
{
	if not InCombat() FrostPrecombatCdActions()
	unless not InCombat() and FrostPrecombatCdPostConditions()
	{
		FrostDefaultCdActions()
	}
}

AddIcon checkbox=opt_mage_frost_aoe help=cd specialization=frost
{
	if not InCombat() FrostPrecombatCdActions()
	unless not InCombat() and FrostPrecombatCdPostConditions()
	{
		FrostDefaultCdActions()
	}
}

### Required symbols
# arcane_torrent_mana
# arctic_gale_talent
# berserking
# blizzard
# blood_fury_sp
# brain_freeze_buff
# comet_storm
# counterspell
# draenic_intellect_potion
# ebonbolt
# fingers_of_frost_buff
# flurry
# frost_bomb
# frost_bomb_talent
# frostbolt
# frozen_orb
# frozen_touch
# glacial_spike
# ice_lance
# ice_nova
# icy_hand
# icy_veins
# icy_veins_buff
# legendary_ring_intellect
# lonely_winter_talent
# mirror_image
# quaking_palm
# ray_of_frost
# ray_of_frost_talent
# rune_of_power
# rune_of_power_buff
# rune_of_power_talent
# t18_class_trinket
# thermal_void_talent
# time_warp
# water_elemental
# water_elemental_water_jet
# water_elemental_water_jet_debuff
]]
	OvaleScripts:RegisterScript("MAGE", "frost", name, desc, code, "script")
end
