--[[--------------------------------------------------------------------
    Copyright (C) 2014 Johnny C. Lam.
    See the file LICENSE.txt for copying permission.
--]]--------------------------------------------------------------------

local OVALE, Ovale = ...

local rawset = rawset
local setmetatable = setmetatable
local tostring = tostring

local L = nil
do
	-- Default value is the key itself.
	local MT = {
		__index = function(self, key)
			local value = tostring(key)
			rawset(self, key, value)
			return value
		end,
	}
	L = setmetatable({}, MT)
	Ovale.L = L
end

-- THE REST OF THIS FILE IS AUTOMATICALLY GENERATED.
-- ANY CHANGES MADE BELOW THIS POINT WILL BE LOST.
-- UPDATE TRANSLATIONS AT:
--     http://wow.curseforge.com/addons/ovale/localization

local locale = GetLocale()

if locale == "deDE" then

L["Affichage numérique"] = "Numerische Anzeige"
L["Affiche les deux prochains sorts et pas uniquement le suivant"] = "Zeige zwei Fähigkeiten und nicht nur eine"
L["Affiche le temps de recharge sous forme numérique"] = "Zeige die verbleibende Zeit in numerischer Form"
L["Afficher la fenêtre"] = "Ovale anzeigen"
L["Afficher les raccourcis clavier dans le coin inférieur gauche des icônes"] = "Zeige Tastaturkürzel in der linken unteren Ecke des Icons"
L["aoe"] = "Flächenschaden"
L["AOE"] = "Flächenschaden"
L["Apparence"] = "Aussehen"
-- L["arcane_mage_burn_phase"] = ""
L["Aura lag"] = "Aura-Verzögerung"
L["Blood"] = "Blut"
L["buff"] = "Stärkungszauber"
L["Cacher bouton vide"] = "Leere Buttons ausblenden"
L["Cacher dans les véhicules"] = "In Fahrzeugen ausblenden"
L["Cacher la fenêtre"] = "Ovale ausblenden"
L["Cacher si cible amicale ou morte"] = "Ausblenden bei freundlichem oder totem Ziel"
L["Caractère de portée"] = "Reichweitenanzeige"
L["cd"] = [=[Fähigkeit mit langer Abklingzeit.
So bald wie möglich benutzen oder für besondere Phasen aufheben.]=]
L["Ce caractère est affiché dans un coin de l'icône pour indiquer si la cible est à portée"] = "Dieser Text wird auf dem Icon angezeigt, um anzuzeigen ob das Ziel in Reichweite ist"
L["Click to select the script."] = "Anklicken, um das Skript auszuwählen"
L["Cliquer pour afficher/cacher les options"] = "Klicken, um Optionen anzuzeigen/zu verbergen"
L["Code"] = "Code"
L["Copier sur Script personnalisé"] = "In eigenes Skript kopieren"
L["Correction de la latence"] = "Latenzkorrektur"
L["Debug aura"] = "Aura-Management nachverfolgen"
L["Debug compile"] = "Wenn das Skript übersetzt wird, nachverfolgen"
L["Debug enemies"] = "Feinderkennung nachverfolgen"
L["Debug GUID"] = "Änderungen in der UnitID/GUID-Paarung nachverfolgen"
L["Debug missing spells"] = "Warnen, wenn eine bekannte Spell-ID benutzt wird, die nicht im Zauberbuch vorhanden ist."
L["Debug unknown spells"] = "Warnen, wenn eine unbekannte Spell-ID im Skript verwendet wird."
L["Décalage horizontal des options"] = "Optionen horizontal verschieben"
L["Décalage vertical des options"] = "Optionen vertikal verschieben"
L["Défilement"] = "Scrollend"
L["Ecraser le Script personnalisé préexistant?"] = "Existierendes eigenes Skript überschreiben?"
L["En combat uniquement"] = "Nur im Kampf anzeigen"
L["Flash brightness"] = "Aufblitz-Leuchtkraft" -- Needs review
L["Flash size"] = "Aufblitz-Größe" -- Needs review
L["Flash spells"] = "Aufblitzende Zauber" -- Needs review
L["Flash spells on action bars when they are ready to be cast. Requires SpellFlashCore"] = "Aufblitzende Zauber in der Aktionsleiste, wenn sie zur Nutzung bereit sind. Benötigt SpellFlashCore." -- Needs review
L["Flash threshold"] = "Aufblitz-Schwellenwert" -- Needs review
L["Focus"] = "Fokus"
L["Groupe d'icônes"] = "Icon-Gruppe"
L["Icône"] = "Icon"
L["Ignorer les clics souris"] = "Mausklicks ignorieren"
L["Illuminer l'icône"] = "Icon hervorheben"
L["Illuminer l'icône quand la technique doit être spammée"] = "Icon hervorheben, wenn Fähigkeit gespammt werden sollte"
L["Illuminer l'icône quand le temps de recharge est écoulé"] = "Icon blinken lassen, wenn die Fähigkeit bereit ist"
L["interrupt"] = "Unterbrechungen" -- Needs review
L["Interrupts"] = "Unterbrechungen" -- Needs review
L["Inverser la boîte à cocher "] = "Checkbox umschalten"
L["Lag (in milliseconds) between when an spell is cast and when the affected aura is applied or removed"] = "Verzögerung (in Millisekunden) zwischen Auslösen des Zaubers und dem Zeitpunkt, wenn der Effekt eintritt oder entfernt wird"
L["La taille des icônes"] = "Die Icongröße"
L["La taille des petites icônes"] = "Die Größe der kleinen Icons"
L["La taille des polices"] = "Die Schriftgröße"
L["Les icônes se déplacent"] = "Die Icons scrollen"
L["Long cooldown abilities"] = "Fähigkeiten mit langer Abklingzeit" -- Needs review
L["main"] = "Hauptangriff"
L["Main attack"] = "Hauptangriff"
L["mana"] = "Managewinn"
L["Marge entre deux icônes"] = "Abstand zwischen den Icons"
L["moving"] = "Angriffe während der Bewegung"
L["multidot"] = "Schaden über Zeit auf mehreren Zielen"
L["None"] = "Nichts"
L["not_in_melee_range"] = "nicht in Nahkampfreichweite"
L["offgcd"] = [=[Fähigkeit ohne globalem Cooldown.
Neben dem Hauptangriff benutzen.]=]
-- L["Only count a mob as an enemy if it is directly affected by a player's spells."] = ""
-- L["Only count tagged enemies"] = ""
L["Opacité des icônes"] = "Undurchsichtigkeit der Icons"
L["Opacité des options"] = "Undurchsichtigkeit der Optionen"
L["Options"] = "Auswahl"
-- L["Overrides"] = ""
L["predict"] = "vorhersagen"
L["Prédictif"] = "Zwei Fähigkeiten"
L["Raccourcis clavier"] = "Tastaturkürzel"
L["Right-Click for options."] = "Rechts-Klick für Optionen"
L["Script"] = "Skript"
L["Script défaut"] = "Standard Script" -- Needs review
L["Script personnalisé"] = "Eigenes Skript"
L["shortcd"] = [=[Fähigkeiten mit kurzer Abklingzeit
Benutzen, sobald sie bereit sind.]=]
L["Short cooldown abilities"] = "Fähigkeiten mit kurzer Abklingzeit" -- Needs review
L["Show hidden"] = "zeige versteckte"
L["Show minimap icon"] = "Zeige Symbol an der Minikarte" -- Needs review
L["Show the icon of the next spell to cast"] = "Zeige das Icon der nächsten zu benutzenden Fähigkeit"
L["showwait"] = "Zeige das Warte-Icon"
L["Si cible uniquement"] = "nur mit Ziel"
-- L["SIMULATIONCRAFT_OVERRIDES_DESCRIPTION"] = ""
-- L["SimulationCraft Profile"] = ""
L["summon_pet"] = "Begleiter beschwören"
L["Taille des icônes"] = "Icongröße"
L["Taille des petites icônes"] = "Größe der kleinen Icons"
L["Taille des polices"] = "Schriftgröße"
L["Taille du second icône"] = "Größe des zweiten Icons"
L["The contents of a SimulationCraft profile."] = "Der Inhalt eines SimulationCraft Profils." -- Needs review
-- L["The script translated from the SimulationCraft profile."] = ""
L["Time (in milliseconds) to begin flashing the spell to use before it is ready."] = "Beginnzeit (ms) des Aufblitzens eines Zaubers, bevor er benutzbar wird." -- Needs review
L["Verrouiller position"] = "Position sperren"
L["Vertical"] = "Vertikal"
L["Visibilité"] = "Sichtbarkeit"

elseif locale == "enUS" then

L["Affichage numérique"] = "Numeric display"
L["Affiche les deux prochains sorts et pas uniquement le suivant"] = "Display two abilities and not only one"
L["Affiche le temps de recharge sous forme numérique"] = "Show the remaining time in numerical form"
L["Afficher la fenêtre"] = "Show Ovale"
L["Afficher les raccourcis clavier dans le coin inférieur gauche des icônes"] = "Show keyboard shortcuts in the icon bottom-left corner"
L["aoe"] = [=[Attack multiple targets.
Adapts to the total number of enemies.]=]
L["AOE"] = "Multiple-targets rotation"
L["Apparence"] = "Appearance"
L["arcane_mage_burn_phase"] = "Suggest Burn actions"
L["Aura lag"] = "Aura lag"
L["Blood"] = "Blood"
L["buff"] = "Buffs"
L["Cacher bouton vide"] = "Hide empty buttons"
L["Cacher dans les véhicules"] = "Hide in vehicles"
L["Cacher la fenêtre"] = "Hide Ovale"
L["Cacher si cible amicale ou morte"] = "Hide if friendly or dead target"
L["Caractère de portée"] = "Range indicator"
L["cd"] = [=[Long cooldown abilities.
Cast as soon as possible or for increased-damage phases.]=]
L["Ce caractère est affiché dans un coin de l'icône pour indiquer si la cible est à portée"] = "This text is displayed on the icon to show if the target is in range"
L["Click to select the script."] = "Click to select the script."
L["Cliquer pour afficher/cacher les options"] = "Click to hide/show options"
L["Code"] = "Code"
L["Copier sur Script personnalisé"] = "Copy to custom script"
L["Correction de la latence"] = "Latency correction"
L["Debug aura"] = "Track aura management."
L["Debug compile"] = "Track when the script is compiled."
L["Debug enemies"] = "Track enemy detection."
L["Debug GUID"] = "Track changes to the UnitID/GUID pairings."
L["Debug missing spells"] = "Warn if a known spell ID is used that is missing from the spellbook."
L["Debug unknown spells"] = "Warn if an unknown spell ID is used in the script."
L["Décalage horizontal des options"] = "Options horizontal shift"
L["Décalage vertical des options"] = "Options vertical shift"
L["Défilement"] = "Scrolling"
L["Ecraser le Script personnalisé préexistant?"] = "Overwrite existing custom script?"
L["En combat uniquement"] = "Show in combat only"
L["Flash brightness"] = "Flash brightness"
L["Flash size"] = "Flash size"
L["Flash spells"] = "Flash spells"
L["Flash spells on action bars when they are ready to be cast. Requires SpellFlashCore"] = "Flash spells on action bars when they are ready to be cast. Requires SpellFlashCore"
L["Flash threshold"] = "Flash threshold"
L["Focus"] = "Focus"
L["Groupe d'icônes"] = "Icon group"
L["Icône"] = "Icon"
L["Ignorer les clics souris"] = "Ignore mouse clicks"
L["Illuminer l'icône"] = "Highlight icon"
L["Illuminer l'icône quand la technique doit être spammée"] = "Hightlight icon when ability should be spammed"
L["Illuminer l'icône quand le temps de recharge est écoulé"] = "Flash the icon when the ability is ready"
L["interrupt"] = "Interrupts"
L["Interrupts"] = "Interrupts"
L["Inverser la boîte à cocher "] = "Toggle check box"
L["Lag (in milliseconds) between when an spell is cast and when the affected aura is applied or removed"] = "Lag (in milliseconds) between when an spell is cast and when the affected aura is applied or removed"
L["La taille des icônes"] = "The icons scale"
L["La taille des petites icônes"] = "The small icons scale"
L["La taille des polices"] = "The font scale"
L["Les icônes se déplacent"] = "Scroll the icons"
L["Long cooldown abilities"] = "Long cooldown abilities"
L["main"] = "Main attack"
L["Main attack"] = "Main attack"
L["mana"] = "Mana gain"
L["Marge entre deux icônes"] = "Margin between icons"
L["moving"] = "Attacks to use while moving"
L["multidot"] = "Damage-over-time on multiple targets"
L["None"] = "None"
L["not_in_melee_range"] = "Not in melee range"
L["offgcd"] = [=[Out of global cooldown ability.
Cast alongside your main attack.]=]
L["Only count a mob as an enemy if it is directly affected by a player's spells."] = "Only count a mob as an enemy if it is directly affected by a player's spells."
L["Only count tagged enemies"] = "Only count tagged enemies"
L["Opacité des icônes"] = "Icons opacity"
L["Opacité des options"] = "Options opacity"
L["Options"] = "Options"
L["Overrides"] = "Overrides"
L["predict"] = "Next non-filler attack."
L["Prédictif"] = "Two abilities"
L["Raccourcis clavier"] = "Keyboard shortcuts"
L["Right-Click for options."] = "Right-Click for options."
L["Script"] = "Script"
L["Script défaut"] = "Default script"
L["Script personnalisé"] = "Custom script"
L["shortcd"] = [=[Short cooldown abilities.
Cast as soon as possible.]=]
L["Short cooldown abilities"] = "Short cooldown abilities"
L["Show hidden"] = "Show hidden"
L["Show minimap icon"] = "Show minimap icon"
L["Show the icon of the next spell to cast"] = "Show the icon of the next spell to cast"
L["showwait"] = "Show the wait icon"
L["Si cible uniquement"] = "If has target"
L["SIMULATIONCRAFT_OVERRIDES_DESCRIPTION"] = "Script code inserted immediately after Include() script statements to override standard definitions, e.g., |cFFFFFF00SpellInfo(tigers_fury tag=main)|r"
L["SimulationCraft Profile"] = "SimulationCraft Profile"
L["summon_pet"] = "Summon pet."
L["Taille des icônes"] = "Icon scale"
L["Taille des petites icônes"] = "Small icon scale"
L["Taille des polices"] = "Font scale"
L["Taille du second icône"] = "Second icon size"
L["The contents of a SimulationCraft profile."] = "The contents of a SimulationCraft profile."
L["The script translated from the SimulationCraft profile."] = "The script translated from the SimulationCraft profile."
L["Time (in milliseconds) to begin flashing the spell to use before it is ready."] = "Time (in milliseconds) to begin flashing the spell to use before it is ready."
L["Verrouiller position"] = "Lock position"
L["Vertical"] = "Vertical"
L["Visibilité"] = "Visibility"

elseif locale == "esES" then

L["Affichage numérique"] = "Visualización numérica"
L["Affiche les deux prochains sorts et pas uniquement le suivant"] = "Mostrar dos habilidades y no solo una"
L["Affiche le temps de recharge sous forme numérique"] = "Ver tiempo restante de forma numérica"
L["Afficher la fenêtre"] = "Mostrar Ovale"
L["Afficher les raccourcis clavier dans le coin inférieur gauche des icônes"] = "Mostrar atajo de teclado en la esquina inferior izquierda del icono"
L["aoe"] = [=[Atacar a múltiples objetivos.
Se adapta al número total de enemigos.]=]
L["AOE"] = "Rotación multi-target"
L["Apparence"] = "Apariencia"
L["arcane_mage_burn_phase"] = "Acción de daño rápido sugerida"
L["Aura lag"] = "Retardo de aura"
L["Blood"] = "Sangre"
L["buff"] = "Buffos"
L["Cacher bouton vide"] = "Ocultar botones vacios"
L["Cacher dans les véhicules"] = "Ocultar en vehiculo"
L["Cacher la fenêtre"] = "Ocultar Ovale"
L["Cacher si cible amicale ou morte"] = "Ocultar si el objetivo es aliado o está muerto"
L["Caractère de portée"] = "Indicador de distancia" -- Needs review
L["cd"] = [=[Habilidades con largo cooldown.
Utilízalas lo antes posible para fases que requieran mucho daño.]=]
L["Ce caractère est affiché dans un coin de l'icône pour indiquer si la cible est à portée"] = "Este texto se muestra sobre el icono si el objetivo está a rango"
L["Click to select the script."] = "Haz clic para seleccionar el script"
L["Cliquer pour afficher/cacher les options"] = "Click para Ocultar/ver opciones"
L["Code"] = "Código" -- Needs review
L["Copier sur Script personnalisé"] = "Copiar al script personalizado"
L["Correction de la latence"] = "Correción de latencia"
L["Debug aura"] = "Comprobar gestión de auras."
L["Debug compile"] = "Comprobar cuándo el script se compila."
L["Debug enemies"] = "Comprobar la detección de enemigos."
L["Debug GUID"] = "COmprobar cambios en el emparejamiento UnitID/GUID."
L["Debug missing spells"] = "Avisar si falta algún ID de hechizo del libro de hechizos."
L["Debug unknown spells"] = "Avisar si se utiliza algún ID de hechizo desconocido en el script."
L["Décalage horizontal des options"] = "Desplazamiento horizontal de las opciones"
L["Décalage vertical des options"] = "Desplazamiento vertical de las opciones"
L["Défilement"] = "rueda de desclazamiento"
L["Ecraser le Script personnalisé préexistant?"] = "¿Deseas sobreescribir el script personalizado actual?"
L["En combat uniquement"] = "Mostrar sólo en combate"
L["Flash brightness"] = "Brillo del destello"
L["Flash size"] = "Tamaño del destello"
L["Flash spells"] = "Destello de hechizos"
L["Flash spells on action bars when they are ready to be cast. Requires SpellFlashCore"] = "Activar destello de hechizos en las barras de acción cuando éstos están listos para ser utilizados. Requiere SpellFleshCore"
L["Flash threshold"] = "Umbral del destello"
L["Focus"] = "Foco"
L["Groupe d'icônes"] = "Grupo de iconos"
L["Icône"] = "Icono"
L["Ignorer les clics souris"] = "Ignorar las pulsaciones del ratón"
L["Illuminer l'icône"] = "Iluminar el icono"
L["Illuminer l'icône quand la technique doit être spammée"] = "Iluminar el icono cuando la habilidad debe ser utilizada repetidamente"
L["Illuminer l'icône quand le temps de recharge est écoulé"] = "Iluminar el icono cuando la habilidad esta lista"
L["interrupt"] = "interrumpir"
L["Interrupts"] = "interrupciones"
L["Inverser la boîte à cocher "] = "Activar/desactivar la caja de selección"
L["Lag (in milliseconds) between when an spell is cast and when the affected aura is applied or removed"] = "Retraso (en milisegundos) entre el lanzamiento de un hechizo y el momento en que el aura correspondiente es aplicada"
L["La taille des icônes"] = "Tamaño de los iconos"
L["La taille des petites icônes"] = "Tamaño de los iconos pequeños"
L["La taille des polices"] = "Tamaño del texto"
L["Les icônes se déplacent"] = "Los iconos pueden desplazarse"
L["Long cooldown abilities"] = "Cooldowns largos"
L["main"] = "principal"
L["Main attack"] = "Ataque Principal"
L["mana"] = "maná"
L["Marge entre deux icônes"] = "Separación entre los iconos"
L["moving"] = "Ataques a utilizar en situaciones de movimiento"
L["multidot"] = "DOTs en múltiples objetivos"
L["None"] = "Nada"
L["not_in_melee_range"] = "Fuera del rango de melé"
L["offgcd"] = "Habilidad fuera del cooldown global"
-- L["Only count a mob as an enemy if it is directly affected by a player's spells."] = ""
-- L["Only count tagged enemies"] = ""
L["Opacité des icônes"] = "Opacidad de los iconos"
L["Opacité des options"] = "Opacidad de las opciones"
L["Options"] = "Opciones"
L["Overrides"] = "Forzados"
L["predict"] = "predecir"
L["Prédictif"] = "Dos habilidades"
L["Raccourcis clavier"] = "Accesos directos de teclado"
L["Right-Click for options."] = "Pulsar con el botón derecho para mostrar opciones"
L["Script"] = "Script"
L["Script défaut"] = "Script por defecto"
L["Script personnalisé"] = "Script personalizado"
L["shortcd"] = "cd corto"
L["Short cooldown abilities"] = "Habilidades de cooldown corto"
L["Show hidden"] = "Mostrar ocultos"
L["Show minimap icon"] = "Mostrar el icono del minimapa"
L["Show the icon of the next spell to cast"] = "Mostrar el icono del siguiente hechizo a lanzar"
L["showwait"] = "mostrar el icono de pausa"
L["Si cible uniquement"] = "Si hay objetivo" -- Needs review
L["SIMULATIONCRAFT_OVERRIDES_DESCRIPTION"] = "Utilizar el código insertado inmediatamente después de las sentencias Include() para forzar las definiciones estándar, p.e. |cFFFFFF00SpellInfo(tigers_fury tag=main)|r"
L["SimulationCraft Profile"] = "Perfil de SimulationCraft"
L["summon_pet"] = "Invocar mascota"
L["Taille des icônes"] = "Tamaño de los iconos"
L["Taille des petites icônes"] = "Tamaño de los iconos pequeños"
L["Taille des polices"] = "Tamaño del texto"
L["Taille du second icône"] = "Tamaño del segundo icono" -- Needs review
L["The contents of a SimulationCraft profile."] = "Los contenidos del perfil de SimulationCraft"
L["The script translated from the SimulationCraft profile."] = "El script traducido del perfil de SimulationCraft"
L["Time (in milliseconds) to begin flashing the spell to use before it is ready."] = "Tiempo de antelación(en milisegundos) para que comience el destello de un hechizo antes de que esté listo"
L["Verrouiller position"] = "Bloquear posición"
L["Vertical"] = "Vertical" -- Needs review
L["Visibilité"] = "Visibilidad"

elseif locale == "esMX" then

L["Affichage numérique"] = "Visualización numérica"
L["Affiche les deux prochains sorts et pas uniquement le suivant"] = "Mostrar dos habilidades y no solo una"
L["Affiche le temps de recharge sous forme numérique"] = "Ver tiempo restante de forma numérica"
L["Afficher la fenêtre"] = "Mostrar Ovale"
L["Afficher les raccourcis clavier dans le coin inférieur gauche des icônes"] = "Mostrar atajo de teclado en la esquina inferior izquierda del icono"
L["aoe"] = [=[Atacar a múltiples objetivos.
Se adapta al número total de enemigos.]=] -- Needs review
L["AOE"] = "Rotación multi-target"
L["Apparence"] = "Apariencia"
L["arcane_mage_burn_phase"] = "Acción de daño rápido sugerida"
L["Aura lag"] = "Retardo de aura" -- Needs review
L["Blood"] = "Sangre"
L["buff"] = "Buffs" -- Needs review
L["Cacher bouton vide"] = "Ocultar botones vacíos"
L["Cacher dans les véhicules"] = "Ocultar en vehículo"
L["Cacher la fenêtre"] = "Ocultar Ovale"
L["Cacher si cible amicale ou morte"] = "Ocultar si el objetivo es aliado o está muerto"
L["Caractère de portée"] = "Indicador de distancia"
L["cd"] = [=[Habilidades con cooldown largo.
Utilízalas lo antes posible o para fases que requieran mucho daño.]=] -- Needs review
L["Ce caractère est affiché dans un coin de l'icône pour indiquer si la cible est à portée"] = "Este texto se muestra sobre el icono si el objetivo está en el rango"
L["Click to select the script."] = "Haz clic para seleccionar el script." -- Needs review
L["Cliquer pour afficher/cacher les options"] = "Click para ocultar/ver opciones"
L["Code"] = "Código"
L["Copier sur Script personnalisé"] = "Copiar al script personalizado" -- Needs review
L["Correction de la latence"] = "Correción de latencia"
L["Debug aura"] = "Comprobar gestión de auras." -- Needs review
L["Debug compile"] = "Comprobar cuando el script se compila." -- Needs review
L["Debug enemies"] = "Comprobar la detección de enemigos." -- Needs review
L["Debug GUID"] = "Comprobar cambios en el emparejamiento UnitID/GUID." -- Needs review
L["Debug missing spells"] = "Avisar si falta algún ID de hechizo del libro de hechizos." -- Needs review
L["Debug unknown spells"] = "Avisar si se utiliza algún ID de hechizo desconocido en el script." -- Needs review
L["Décalage horizontal des options"] = "Desplazamiento horizontal de las opciones" -- Needs review
L["Décalage vertical des options"] = "Desplazamiento vertical de las opciones" -- Needs review
L["Défilement"] = "Rueda de desplazamiento"
L["Ecraser le Script personnalisé préexistant?"] = "¿Deseas sobrescribir el script personalizado actual?" -- Needs review
L["En combat uniquement"] = "Mostrar sólo en combate"
L["Flash brightness"] = "Brillo del destello"
L["Flash size"] = "Tamaño del destello"
L["Flash spells"] = "Destello del hechizo"
L["Flash spells on action bars when they are ready to be cast. Requires SpellFlashCore"] = "Activar destello de hechizos en las barras de acción cuando éstos están listos para ser utilizados. Requiere SpellFleshCore" -- Needs review
L["Flash threshold"] = "Umbral del destello"
L["Focus"] = "Foco"
L["Groupe d'icônes"] = "Grupo de iconos" -- Needs review
L["Icône"] = "Icono" -- Needs review
L["Ignorer les clics souris"] = "Ignorar las pulsaciones del ratón"
L["Illuminer l'icône"] = "Iluminar el icono"
L["Illuminer l'icône quand la technique doit être spammée"] = "Iluminar el icono cuando la habilidad debe ser utilizada repetidamente"
L["Illuminer l'icône quand le temps de recharge est écoulé"] = "Iluminar el icono cuando la habilidad está lista"
L["interrupt"] = "Interrupciones"
L["Interrupts"] = "Interrupciones"
L["Inverser la boîte à cocher "] = "Activar/desactivar la caja de selección"
L["Lag (in milliseconds) between when an spell is cast and when the affected aura is applied or removed"] = "Retraso (en milisegundos) entre el lanzamiento de un hechizo y el momento en que el aura correspondiente es aplicada o removida" -- Needs review
L["La taille des icônes"] = "Tamaño de los iconos"
L["La taille des petites icônes"] = "Tamaño de los iconos pequeños"
L["La taille des polices"] = "Tamaño del texto"
L["Les icônes se déplacent"] = "Los iconos pueden desplazarse"
L["Long cooldown abilities"] = "Cooldowns largos"
L["main"] = "Ataque principal" -- Needs review
L["Main attack"] = "Ataque Principal"
L["mana"] = "Aumento de maná" -- Needs review
L["Marge entre deux icônes"] = "Separación entre los iconos"
L["moving"] = "Ataques a utilizar en situaciones de movimiento" -- Needs review
L["multidot"] = "DOTs en múltiples objetivos" -- Needs review
L["None"] = "Nada" -- Needs review
L["not_in_melee_range"] = "Fuera del rango de melé" -- Needs review
L["offgcd"] = "Habilidad fuera del cooldown global" -- Needs review
-- L["Only count a mob as an enemy if it is directly affected by a player's spells."] = ""
-- L["Only count tagged enemies"] = ""
L["Opacité des icônes"] = "Opacidad de los iconos" -- Needs review
L["Opacité des options"] = "Opacidad de las opciones" -- Needs review
L["Options"] = "Opciones" -- Needs review
L["Overrides"] = "Forzados"
L["predict"] = "Siguiente ataque no de relleno." -- Needs review
L["Prédictif"] = "Dos habilidades" -- Needs review
L["Raccourcis clavier"] = "Atajos del teclado" -- Needs review
L["Right-Click for options."] = "Pulsar con el botón derecho para mostrar opciones." -- Needs review
L["Script"] = "Script" -- Needs review
L["Script défaut"] = "Script por defecto"
L["Script personnalisé"] = "Script personalizado" -- Needs review
L["shortcd"] = [=[Habilidades de cooldown corto.
Lánzalas tan pronto sea posible.]=] -- Needs review
L["Short cooldown abilities"] = "Habilidades de cooldown corto"
L["Show hidden"] = "Mostrar scripts ocultos" -- Needs review
L["Show minimap icon"] = "Mostrar el icono del minimapa" -- Needs review
L["Show the icon of the next spell to cast"] = "Mostrar el icono del siguiente hechizo a lanzar" -- Needs review
L["showwait"] = "Mostrar el icono de pausa" -- Needs review
L["Si cible uniquement"] = "Si hay objetivo" -- Needs review
L["SIMULATIONCRAFT_OVERRIDES_DESCRIPTION"] = "Utilizar el código insertado inmediatamente después de las sentencias Include() para forzar las definiciones estándar, ej: |cFFFFFF00SpellInfo(tigers_fury tag=main)|r"
L["SimulationCraft Profile"] = "Perfil de SimulationCraft"
L["summon_pet"] = "Invocar mascota." -- Needs review
L["Taille des icônes"] = "Tamaño de los iconos" -- Needs review
L["Taille des petites icônes"] = "Tamaño de los iconos pequeños" -- Needs review
L["Taille des polices"] = "Tamaño del texto" -- Needs review
L["Taille du second icône"] = "Tamaño del segundo icono" -- Needs review
L["The contents of a SimulationCraft profile."] = "Contenidos del perfil de SimulationCraft"
L["The script translated from the SimulationCraft profile."] = "Script traducido del perfil de SimulationCraft"
L["Time (in milliseconds) to begin flashing the spell to use before it is ready."] = "Tiempo de antelación (en milisegundos) para que comience el destello de un hechizo antes de que esté listo"
L["Verrouiller position"] = "Bloquear posición" -- Needs review
L["Vertical"] = "Vertical" -- Needs review
L["Visibilité"] = "Visibilidad" -- Needs review

elseif locale == "frFR" then

L["Affichage numérique"] = "Affichage numérique"
L["Affiche les deux prochains sorts et pas uniquement le suivant"] = "Affiche les deux prochains sorts et pas uniquement le suivant"
L["Affiche le temps de recharge sous forme numérique"] = "Affiche le temps de recharge sous forme numérique"
L["Afficher la fenêtre"] = "Afficher la fenêtre"
L["Afficher les raccourcis clavier dans le coin inférieur gauche des icônes"] = "Afficher les raccourcis clavier dans le coin inférieur gauche des icônes"
L["aoe"] = "Attaque multi-cible" -- Needs review
L["AOE"] = "rotation Multicible" -- Needs review
L["Apparence"] = "Apparence"
-- L["arcane_mage_burn_phase"] = ""
L["Aura lag"] = "latence de l'Aura" -- Needs review
L["Blood"] = "Saignement"
L["buff"] = "Améliorations"
L["Cacher bouton vide"] = "Cacher bouton vide"
L["Cacher dans les véhicules"] = "Cacher dans les véhicules"
L["Cacher la fenêtre"] = "Cacher la fenêtre"
L["Cacher si cible amicale ou morte"] = "Cacher si cible amicale ou morte"
L["Caractère de portée"] = "Caractère de portée"
L["cd"] = [=[Techniques à longs temps de recharge.
Lancer dès que possible ou conserver pour les phases de dégâts amplifiés.]=]
L["Ce caractère est affiché dans un coin de l'icône pour indiquer si la cible est à portée"] = "Ce caractère est affiché dans un coin de l'icône pour indiquer si la cible est à portée"
L["Click to select the script."] = "cliquez pour sélectionner le script." -- Needs review
L["Cliquer pour afficher/cacher les options"] = "Cliquer pour afficher/cacher les options"
L["Code"] = "Code"
L["Copier sur Script personnalisé"] = "Copier sur Script personnalisé"
L["Correction de la latence"] = "Correction de la latence"
L["Debug aura"] = "Suivre la gestion des auras."
L["Debug compile"] = "Suivre lorsque le script est compilé."
L["Debug enemies"] = "Suivre la détection des ennemis."
L["Debug GUID"] = "Suivre les changements des paires de UnitID et GUID."
L["Debug missing spells"] = "Prévenir si le ID d'un sort qui n'est pas dans le livre de sorts est utilisé."
L["Debug unknown spells"] = "Prévenir si le ID d'un sort inconnu est utilisé dans le script."
L["Décalage horizontal des options"] = "Décalage horizontal des options"
L["Décalage vertical des options"] = "Décalage vertical des options"
L["Défilement"] = "Défilement"
L["Ecraser le Script personnalisé préexistant?"] = "Ecraser le Script personnalisé préexistant?"
L["En combat uniquement"] = "En combat uniquement"
L["Flash brightness"] = "Luminosité du flash" -- Needs review
L["Flash size"] = "Taille du flash" -- Needs review
L["Flash spells"] = "Flash du sort" -- Needs review
-- L["Flash spells on action bars when they are ready to be cast. Requires SpellFlashCore"] = ""
-- L["Flash threshold"] = ""
L["Focus"] = "Focus"
L["Groupe d'icônes"] = "Groupe d'icônes"
L["Icône"] = "Icône"
L["Ignorer les clics souris"] = "Ignorer les clics souris"
L["Illuminer l'icône"] = "Illuminer l'icône"
L["Illuminer l'icône quand la technique doit être spammée"] = "Illuminer l'icône quand la technique doit être spammée"
L["Illuminer l'icône quand le temps de recharge est écoulé"] = "Illuminer l'icône quand le temps de recharge est écoulé"
-- L["interrupt"] = ""
L["Interrupts"] = "Interrupts" -- Needs review
L["Inverser la boîte à cocher "] = "Inverser la boîte à cocher "
L["Lag (in milliseconds) between when an spell is cast and when the affected aura is applied or removed"] = "Latence (en milliseconde) quand un sort est lancé et quand une aura est appliqué ou retiré." -- Needs review
L["La taille des icônes"] = "La taille des icônes"
L["La taille des petites icônes"] = "La taille des petites icônes"
L["La taille des polices"] = "La taille des polices"
L["Les icônes se déplacent"] = "Les icônes se déplacent"
L["Long cooldown abilities"] = "Techniques à longs temps de recharge" -- Needs review
L["main"] = "Attaque principale"
L["Main attack"] = "Attaque principale" -- Needs review
L["mana"] = "Regain de mana"
L["Marge entre deux icônes"] = "Marge entre deux icônes"
L["moving"] = "Attaques à utiliser en mouvement"
L["multidot"] = "Multicible pour DoTs"
L["None"] = "Aucun"
L["not_in_melee_range"] = "Pas à distance pour corps à corps" -- Needs review
L["offgcd"] = [=[Attaque hors temps de recharge globale.
Lancer en parallèle de l'attaque principale.]=]
-- L["Only count a mob as an enemy if it is directly affected by a player's spells."] = ""
-- L["Only count tagged enemies"] = ""
L["Opacité des icônes"] = "Opacité des icônes"
L["Opacité des options"] = "Opacité des options"
L["Options"] = "Options"
-- L["Overrides"] = ""
-- L["predict"] = ""
L["Prédictif"] = "Deux sorts"
L["Raccourcis clavier"] = "Raccourcis clavier"
L["Right-Click for options."] = "clique droit pour les options" -- Needs review
L["Script"] = "Script"
L["Script défaut"] = "Script défaut" -- Needs review
L["Script personnalisé"] = "Script personnalisé"
L["shortcd"] = [=[Compétence à court temps de recharge.
Lancer dès que possible.]=]
L["Short cooldown abilities"] = "Compétence à court temps de recharge" -- Needs review
-- L["Show hidden"] = ""
L["Show minimap icon"] = "montrer l'icone de la minimap" -- Needs review
L["Show the icon of the next spell to cast"] = "Affiche l'icône du prochain sort à lancer"
L["showwait"] = "Montrer l'icône d'attente"
L["Si cible uniquement"] = "Si cible uniquement"
-- L["SIMULATIONCRAFT_OVERRIDES_DESCRIPTION"] = ""
-- L["SimulationCraft Profile"] = ""
L["summon_pet"] = "Invoquer familier" -- Needs review
L["Taille des icônes"] = "Taille des icônes"
L["Taille des petites icônes"] = "Taille des petites icônes"
L["Taille des polices"] = "Taille des polices"
L["Taille du second icône"] = "Taille du second icône"
-- L["The contents of a SimulationCraft profile."] = ""
-- L["The script translated from the SimulationCraft profile."] = ""
-- L["Time (in milliseconds) to begin flashing the spell to use before it is ready."] = ""
L["Verrouiller position"] = "Verrouiller position"
L["Vertical"] = "Vertical"
L["Visibilité"] = "Visibilité"

elseif locale == "itIT" then

L["Affichage numérique"] = "Esposizione Numerica"
L["Affiche les deux prochains sorts et pas uniquement le suivant"] = "Espone due abilita' e non solo una"
L["Affiche le temps de recharge sous forme numérique"] = "Mostra il tempo rimanente in forma numerica"
L["Afficher la fenêtre"] = "Mostra Ovale"
L["Afficher les raccourcis clavier dans le coin inférieur gauche des icônes"] = "Mostra le scorciatoie da tastiera nell'icona in basso a sinistra"
L["aoe"] = "Attacchi a Bersaglio Multiplo"
L["AOE"] = "AdE"
L["Apparence"] = "Apparenza"
-- L["arcane_mage_burn_phase"] = ""
L["Aura lag"] = "Aura lag"
L["Blood"] = "Sangue"
L["buff"] = "Benefici"
L["Cacher bouton vide"] = "Nascondi bottoni vuoti"
L["Cacher dans les véhicules"] = "Nascondi nei veicoli"
L["Cacher la fenêtre"] = "Nascondi Ovale"
L["Cacher si cible amicale ou morte"] = "Nascondi se il bersaglio e' amico o morto"
L["Caractère de portée"] = "Indicatori distanza"
L["cd"] = [=[Abilita' con cooldown lungo.
Lanciare quando possibile o mantenere per moltiplicare i danni un specifiche fasi.]=]
L["Ce caractère est affiché dans un coin de l'icône pour indiquer si la cible est à portée"] = "Questo testo e' mostrato sull'icona per mostrare se il bersaglio e' nel raggio d'azione"
L["Click to select the script."] = "Clicca per selezionare lo script."
L["Cliquer pour afficher/cacher les options"] = "Premere per nascondere/mostrare le opzioni"
L["Code"] = "Codice"
L["Copier sur Script personnalisé"] = "Copia in script personalizzato"
L["Correction de la latence"] = "Correzione Latenza"
L["Debug aura"] = "Debug aura"
L["Debug compile"] = "Debug compilazione"
L["Debug enemies"] = "Debug nemici"
L["Debug GUID"] = "Debug GUID"
L["Debug missing spells"] = "Debug instantesimi mancanti"
L["Debug unknown spells"] = "Debug Incantesimi sconosciuti"
L["Décalage horizontal des options"] = "Opzioni spostamento orizzontare"
L["Décalage vertical des options"] = "Opzioni spostamento verticale"
L["Défilement"] = "Scorrimento"
L["Ecraser le Script personnalisé préexistant?"] = "Sovrascrivere lo script personalizzato esistente ?"
L["En combat uniquement"] = "Mostra solo in combattimento"
L["Flash brightness"] = "Mostra luminosità" -- Needs review
L["Flash size"] = "Mostra grandezza" -- Needs review
L["Flash spells"] = "Mostra incantesimi" -- Needs review
-- L["Flash spells on action bars when they are ready to be cast. Requires SpellFlashCore"] = ""
-- L["Flash threshold"] = ""
L["Focus"] = "Focus"
L["Groupe d'icônes"] = "Gruppo d'Icone"
L["Icône"] = "Icona"
L["Ignorer les clics souris"] = "Ignora pressioni mouse"
L["Illuminer l'icône"] = "Evidenzia icona"
L["Illuminer l'icône quand la technique doit être spammée"] = "Evidenzia icona quando l'abilita' dovrebbe essere spammata"
L["Illuminer l'icône quand le temps de recharge est écoulé"] = "Illumina l'icona quando l'abilita' e' pronta"
L["interrupt"] = "Interrompi" -- Needs review
L["Interrupts"] = "Interrompi" -- Needs review
L["Inverser la boîte à cocher "] = "Inverti spunta"
L["Lag (in milliseconds) between when an spell is cast and when the affected aura is applied or removed"] = "Lag (in millisecondi) tra quando un incantesimo è lanciato e quando l'aura d'effetto è applicata o rimossa"
L["La taille des icônes"] = "La scala dell'icona"
L["La taille des petites icônes"] = "La scala dell'icona piccola"
L["La taille des polices"] = "La scala del carattere"
L["Les icônes se déplacent"] = "Scorri le icone"
L["Long cooldown abilities"] = "Abilita' con cooldown lungo" -- Needs review
L["main"] = "Attacco Principale"
L["Main attack"] = "Attacco Principale" -- Needs review
L["mana"] = "Guadagno Mana"
L["Marge entre deux icônes"] = "Margine tra le icone"
L["moving"] = "in movimento"
L["multidot"] = "Danni a Tempo su bersagli multipli"
L["None"] = "Nessuno"
L["not_in_melee_range"] = "non in mischia"
L["offgcd"] = [=[Abilita' fuori dal Cooldown globale.
Da lanciare assieme agli attacchi principali.]=]
-- L["Only count a mob as an enemy if it is directly affected by a player's spells."] = ""
-- L["Only count tagged enemies"] = ""
L["Opacité des icônes"] = "Opacita' icone"
L["Opacité des options"] = "Opzioni di opacita'"
L["Options"] = "Opzioni"
-- L["Overrides"] = ""
L["predict"] = "predizione"
L["Prédictif"] = "Due abilita'"
L["Raccourcis clavier"] = "Scorciatoie da tastiera"
L["Right-Click for options."] = "Click-Destro per opzioni."
L["Script"] = "Script"
-- L["Script défaut"] = ""
L["Script personnalisé"] = "Script Personalizzato"
L["shortcd"] = "recupero corto"
L["Short cooldown abilities"] = "Recupero corto" -- Needs review
L["Show hidden"] = "Mostra nascosti"
L["Show minimap icon"] = "Mostra icona minimappa" -- Needs review
L["Show the icon of the next spell to cast"] = "Descrizione Add-on"
L["showwait"] = "mostra aspetta"
L["Si cible uniquement"] = "Se si ha un bersaglio"
-- L["SIMULATIONCRAFT_OVERRIDES_DESCRIPTION"] = ""
-- L["SimulationCraft Profile"] = ""
L["summon_pet"] = "evoca pet"
L["Taille des icônes"] = "Scala icone"
L["Taille des petites icônes"] = "Scala piccole icone"
L["Taille des polices"] = "Scala caratteri"
L["Taille du second icône"] = "Dimensione seconda icona"
-- L["The contents of a SimulationCraft profile."] = ""
-- L["The script translated from the SimulationCraft profile."] = ""
-- L["Time (in milliseconds) to begin flashing the spell to use before it is ready."] = ""
L["Verrouiller position"] = "Blocca Posizione"
L["Vertical"] = "Verticale"
L["Visibilité"] = "Visibilità"

elseif locale == "koKR" then

L["Affichage numérique"] = "숫자 표시"
L["Affiche les deux prochains sorts et pas uniquement le suivant"] = "두번째 능력을 표시합니다."
L["Affiche le temps de recharge sous forme numérique"] = "숫자 형태로 남은 시간을 표시합니다."
L["Afficher la fenêtre"] = "Ovale 표시"
L["Afficher les raccourcis clavier dans le coin inférieur gauche des icônes"] = "아이콘 좌측 하단 코너에 단축키를 표시합니다."
L["aoe"] = "다중 대상 공격" -- Needs review
L["AOE"] = "AOE" -- Needs review
L["Apparence"] = "외형"
-- L["arcane_mage_burn_phase"] = ""
-- L["Aura lag"] = ""
L["Blood"] = "Blood"
L["buff"] = "버프"
L["Cacher bouton vide"] = "빈 버튼 숨김"
L["Cacher dans les véhicules"] = "차량 탑승시 숨김"
L["Cacher la fenêtre"] = "Ovale 숨김"
L["Cacher si cible amicale ou morte"] = "우호적 대상이나 죽은 대상 선택시 숨김"
L["Caractère de portée"] = "범위 지시기"
L["cd"] = [=[긴 재사용 대기시간 능력입니다.
Cast as soon as possible or keep for multiplied damage phases.]=]
L["Ce caractère est affiché dans un coin de l'icône pour indiquer si la cible est à portée"] = "이 문자는 대상이 범위에 있을때 아이콘에 표시됩니다."
-- L["Click to select the script."] = ""
L["Cliquer pour afficher/cacher les options"] = "클릭시 옵션 숨김/표시"
L["Code"] = "코드"
-- L["Copier sur Script personnalisé"] = ""
L["Correction de la latence"] = "대기시간 수정"
-- L["Debug aura"] = ""
-- L["Debug compile"] = ""
-- L["Debug enemies"] = ""
-- L["Debug GUID"] = ""
-- L["Debug missing spells"] = ""
-- L["Debug unknown spells"] = ""
L["Décalage horizontal des options"] = "가로 간격"
L["Décalage vertical des options"] = "세로 간격"
L["Défilement"] = "스크룰"
-- L["Ecraser le Script personnalisé préexistant?"] = ""
L["En combat uniquement"] = "전투 상태일때만 표시"
L["Flash brightness"] = "번쩍임 밝기" -- Needs review
L["Flash size"] = "번쩍임 크기" -- Needs review
L["Flash spells"] = "주문 번쩍임" -- Needs review
-- L["Flash spells on action bars when they are ready to be cast. Requires SpellFlashCore"] = ""
-- L["Flash threshold"] = ""
L["Focus"] = "주시 대상"
-- L["Groupe d'icônes"] = ""
-- L["Icône"] = ""
L["Ignorer les clics souris"] = "마우스 클릭 무시"
L["Illuminer l'icône"] = "아이콘 강조"
L["Illuminer l'icône quand la technique doit être spammée"] = "Hightlight icon when ability should be spammed"
L["Illuminer l'icône quand le temps de recharge est écoulé"] = "능력이 준비되면 아이콘을 반짝입니다."
-- L["interrupt"] = ""
-- L["Interrupts"] = ""
L["Inverser la boîte à cocher "] = "체크 박스 토글"
-- L["Lag (in milliseconds) between when an spell is cast and when the affected aura is applied or removed"] = ""
L["La taille des icônes"] = "아이콘 크기"
L["La taille des petites icônes"] = "작은 아이콘의 크기를 설정합니다."
L["La taille des polices"] = "폰크 크기"
L["Les icônes se déplacent"] = "아이콘 스크룰"
L["Long cooldown abilities"] = "긴 재사용 대기시간 능력입니다" -- Needs review
L["main"] = "Main Attack"
-- L["Main attack"] = ""
L["mana"] = "마나 획득"
L["Marge entre deux icônes"] = "아이콘 간격"
-- L["moving"] = ""
L["multidot"] = "Damage Over Time on multiple targets"
L["None"] = "None"
-- L["not_in_melee_range"] = ""
L["offgcd"] = [=[전역 재사용 대기시간 능력입니다.
Cast alongside your Main Attack.]=]
-- L["Only count a mob as an enemy if it is directly affected by a player's spells."] = ""
-- L["Only count tagged enemies"] = ""
L["Opacité des icônes"] = "아이콘 투명도"
L["Opacité des options"] = "투명도 옵션을 설정합니다."
-- L["Options"] = ""
-- L["Overrides"] = ""
-- L["predict"] = ""
L["Prédictif"] = "두번째 능력"
L["Raccourcis clavier"] = "키보드 단축키"
-- L["Right-Click for options."] = ""
-- L["Script"] = ""
-- L["Script défaut"] = ""
-- L["Script personnalisé"] = ""
-- L["shortcd"] = ""
-- L["Short cooldown abilities"] = ""
-- L["Show hidden"] = ""
-- L["Show minimap icon"] = ""
-- L["Show the icon of the next spell to cast"] = ""
-- L["showwait"] = ""
L["Si cible uniquement"] = "만약 대상이 있다면"
-- L["SIMULATIONCRAFT_OVERRIDES_DESCRIPTION"] = ""
-- L["SimulationCraft Profile"] = ""
-- L["summon_pet"] = ""
L["Taille des icônes"] = "아이콘 크기"
L["Taille des petites icônes"] = "작은 아이콘 크기"
L["Taille des polices"] = "폰트 크기"
L["Taille du second icône"] = "두번째 아이콘 크기"
-- L["The contents of a SimulationCraft profile."] = ""
-- L["The script translated from the SimulationCraft profile."] = ""
-- L["Time (in milliseconds) to begin flashing the spell to use before it is ready."] = ""
L["Verrouiller position"] = "위치 잠금"
L["Vertical"] = "수직선"
-- L["Visibilité"] = ""

elseif locale == "ptBR" then

L["Affichage numérique"] = "Mostrar números"
L["Affiche les deux prochains sorts et pas uniquement le suivant"] = "Mostrar duas habilidades e não apenas uma"
L["Affiche le temps de recharge sous forme numérique"] = "Mostrar o tempo restante de forma numérica"
L["Afficher la fenêtre"] = "Mostrar Ovale"
L["Afficher les raccourcis clavier dans le coin inférieur gauche des icônes"] = "Mostrar atalhos do teclado canto inferior esquerdo do ícone"
L["aoe"] = "Atacar alvos múltiplos" -- Needs review
L["AOE"] = "AOE" -- Needs review
L["Apparence"] = "Aparência"
-- L["arcane_mage_burn_phase"] = ""
-- L["Aura lag"] = ""
L["Blood"] = "Sangue"
L["buff"] = "Buffs"
L["Cacher bouton vide"] = "Esconder botões vazios"
L["Cacher dans les véhicules"] = "Esconder em veículos"
L["Cacher la fenêtre"] = "Esconder Ovale"
L["Cacher si cible amicale ou morte"] = "Esconder se o alvo for amigável ou morto"
L["Caractère de portée"] = "Indicador de alcance"
L["cd"] = [=[Habilidades de cooldown longo.
Use assim que possível ou espere por fases com dano maior.]=]
L["Ce caractère est affiché dans un coin de l'icône pour indiquer si la cible est à portée"] = "Este texto é mostrado no ícone para apontar se o alvo está no alcance"
-- L["Click to select the script."] = ""
L["Cliquer pour afficher/cacher les options"] = "Clique para mostrar/esconder opções"
L["Code"] = "Código"
-- L["Copier sur Script personnalisé"] = ""
L["Correction de la latence"] = "Correção de latência"
-- L["Debug aura"] = ""
-- L["Debug compile"] = ""
-- L["Debug enemies"] = ""
-- L["Debug GUID"] = ""
-- L["Debug missing spells"] = ""
-- L["Debug unknown spells"] = ""
L["Décalage horizontal des options"] = "Opções de mudança horizontal"
L["Décalage vertical des options"] = "Opções de mduança vertical"
L["Défilement"] = "Rolagem"
-- L["Ecraser le Script personnalisé préexistant?"] = ""
L["En combat uniquement"] = "Mostrar só em combate"
L["Flash brightness"] = "Intensidade do brilho" -- Needs review
L["Flash size"] = "Tamanho do brilho" -- Needs review
L["Flash spells"] = "Brilho do feitiço" -- Needs review
-- L["Flash spells on action bars when they are ready to be cast. Requires SpellFlashCore"] = ""
-- L["Flash threshold"] = ""
L["Focus"] = "Foco"
-- L["Groupe d'icônes"] = ""
-- L["Icône"] = ""
L["Ignorer les clics souris"] = "Ignorar cliques do mouse"
L["Illuminer l'icône"] = "Iluminar ícone"
L["Illuminer l'icône quand la technique doit être spammée"] = "Iluminar ícone quando habilidade deverá ser spamada"
L["Illuminer l'icône quand le temps de recharge est écoulé"] = "Iluminar ícone quando habilidade estiver pronta"
-- L["interrupt"] = ""
-- L["Interrupts"] = ""
L["Inverser la boîte à cocher "] = "Alternar checar caixa"
-- L["Lag (in milliseconds) between when an spell is cast and when the affected aura is applied or removed"] = ""
L["La taille des icônes"] = "Escala dos ícones"
L["La taille des petites icônes"] = "Escala dos ícones pequenos"
L["La taille des polices"] = "Escala da fonte"
L["Les icônes se déplacent"] = "Rolar os ícones"
L["Long cooldown abilities"] = "Habilidades de cooldown longo" -- Needs review
L["main"] = "Ataque principal"
L["Main attack"] = "Ataque principal" -- Needs review
L["mana"] = "Ganho de mana"
L["Marge entre deux icônes"] = "Margem entre ícones"
-- L["moving"] = ""
L["multidot"] = "Dano Através do Tempo em múltiplos alvos"
L["None"] = "Nenhum"
-- L["not_in_melee_range"] = ""
L["offgcd"] = [=[Habilidade fora do cooldown global.
Use junto do seu Ataque Principal.]=]
-- L["Only count a mob as an enemy if it is directly affected by a player's spells."] = ""
-- L["Only count tagged enemies"] = ""
L["Opacité des icônes"] = "Opacidade dos ícones"
L["Opacité des options"] = "Opacidade das opções"
-- L["Options"] = ""
-- L["Overrides"] = ""
-- L["predict"] = ""
L["Prédictif"] = "Duas habilidades"
L["Raccourcis clavier"] = "Atalhos do teclado"
-- L["Right-Click for options."] = ""
-- L["Script"] = ""
-- L["Script défaut"] = ""
-- L["Script personnalisé"] = ""
-- L["shortcd"] = ""
-- L["Short cooldown abilities"] = ""
-- L["Show hidden"] = ""
-- L["Show minimap icon"] = ""
-- L["Show the icon of the next spell to cast"] = ""
-- L["showwait"] = ""
L["Si cible uniquement"] = "Se tiver alvo"
-- L["SIMULATIONCRAFT_OVERRIDES_DESCRIPTION"] = ""
-- L["SimulationCraft Profile"] = ""
-- L["summon_pet"] = ""
L["Taille des icônes"] = "Escala do ícone"
L["Taille des petites icônes"] = "Escala do ícone pequeno"
L["Taille des polices"] = "Escala da fonte"
L["Taille du second icône"] = "Tamanho do segundo ícone"
-- L["The contents of a SimulationCraft profile."] = ""
-- L["The script translated from the SimulationCraft profile."] = ""
-- L["Time (in milliseconds) to begin flashing the spell to use before it is ready."] = ""
L["Verrouiller position"] = "Travar posição"
L["Vertical"] = "Vertical"
-- L["Visibilité"] = ""

elseif locale == "ruRU" then

L["Affichage numérique"] = "Цифровой дисплей"
L["Affiche les deux prochains sorts et pas uniquement le suivant"] = "Показать две способности вместо одной"
L["Affiche le temps de recharge sous forme numérique"] = "Показать отсчет времени в цифровой форме"
L["Afficher la fenêtre"] = "Показать Ovale"
L["Afficher les raccourcis clavier dans le coin inférieur gauche des icônes"] = "Показывать сочетания клавиш в левом нижнем углу"
L["aoe"] = "Атака нескольких противников"
L["AOE"] = "Приоритет при атаке нескольких противников"
L["Apparence"] = "Внешний вид"
L["arcane_mage_burn_phase"] = "Предложить взрывные действия" -- Needs review
L["Aura lag"] = "Задержка ауры"
L["Blood"] = "Кровь"
L["buff"] = "Баффы"
L["Cacher bouton vide"] = "Скрыть пустые кнопки"
L["Cacher dans les véhicules"] = "Скрывать на транспорте"
L["Cacher la fenêtre"] = "Скрыть Ovale"
L["Cacher si cible amicale ou morte"] = "Скрывать если союзник или цель мертва"
L["Caractère de portée"] = "Индикатор дистанции"
L["cd"] = [=[Способности с большим кулдауном (временем восстановления). 
Использовать сразу, как только возможно или придерживать для фаз повышенного урона.]=]
L["Ce caractère est affiché dans un coin de l'icône pour indiquer si la cible est à portée"] = "Этот текст показывается на иконке если цель в радиусе досягаемости"
L["Click to select the script."] = "Клик для выбора скрипта"
L["Cliquer pour afficher/cacher les options"] = "Нажмите, чтобы скрыть/показать опции"
L["Code"] = "Код"
L["Copier sur Script personnalisé"] = "Скопировать в Пользовательский скрипт"
L["Correction de la latence"] = "Коррекция задержки"
L["Debug aura"] = "Отслеживать управление аурами."
L["Debug compile"] = "Отслеживать компиляцию скрипта."
L["Debug enemies"] = "Отслеживать появление противников."
L["Debug GUID"] = "Отслеживать изменения в парах UnitID/GUID."
L["Debug missing spells"] = "Предупреждать, если используется ID заклинания отсутствующего в книге заклинаний"
L["Debug unknown spells"] = "Предупреждать о неизвестном ID заклинания в скрипте."
L["Décalage horizontal des options"] = "Горизонтальное смещение опций"
L["Décalage vertical des options"] = "Вертикальное смещение опций"
L["Défilement"] = "Прокрутка (Скроллинг)"
L["Ecraser le Script personnalisé préexistant?"] = "Перезаписать существующий Пользовательский скрипт?"
L["En combat uniquement"] = "Показывать только в бою"
L["Flash brightness"] = "Яркость подсветки"
L["Flash size"] = "Размер подсветки"
L["Flash spells"] = "Подсветка умения"
L["Flash spells on action bars when they are ready to be cast. Requires SpellFlashCore"] = "Подсвечивать способности, на панели умений, когда они готовы. Требуется SpellFlashCore"
L["Flash threshold"] = "Преддверие вспышкой"
L["Focus"] = "Фокус"
L["Groupe d'icônes"] = "Группа иконок"
L["Icône"] = "Иконка"
L["Ignorer les clics souris"] = "Игнорировать клики мыши"
L["Illuminer l'icône"] = "Подсветка иконок"
L["Illuminer l'icône quand la technique doit être spammée"] = "Подсвечивать иконки когда способность должна \"спамиться\""
L["Illuminer l'icône quand le temps de recharge est écoulé"] = "Мигать когда способность готова"
L["interrupt"] = "Прерывания"
L["Interrupts"] = "Прерывания"
L["Inverser la boîte à cocher "] = "Переключить флажок"
L["Lag (in milliseconds) between when an spell is cast and when the affected aura is applied or removed"] = "Задержка (в милисекундах) между произнесением заклинания и применением/пропаданием ауры"
L["La taille des icônes"] = "Размер иконок"
L["La taille des petites icônes"] = "Размер маленьких иконок"
L["La taille des polices"] = "Размер шрифта"
L["Les icônes se déplacent"] = "Переместить иконки"
L["Long cooldown abilities"] = "Способности с большим кулдауном"
L["main"] = "Основная атака"
L["Main attack"] = "Основная атака"
L["mana"] = "Мана (очки маны)"
L["Marge entre deux icônes"] = "Расстояние между иконками"
L["moving"] = "Атаки, используемые при движении"
L["multidot"] = "ДОТы на нескольких целях"
L["None"] = "Нет"
L["not_in_melee_range"] = "Вне радиуса ближней атаки"
L["offgcd"] = [=[Не участвуют в глобальном КД.
Активируются вне зависимости от Ваших атак.
]=]
-- L["Only count a mob as an enemy if it is directly affected by a player's spells."] = ""
-- L["Only count tagged enemies"] = ""
L["Opacité des icônes"] = "Прозрачность иконок"
L["Opacité des options"] = "Прозрачность настроек"
L["Options"] = "Опции"
L["Overrides"] = "Перезаписанные" -- Needs review
L["predict"] = "Следующая не \"заполняющая\" атака."
L["Prédictif"] = "Две способности"
L["Raccourcis clavier"] = "Горячие клавиши"
L["Right-Click for options."] = "Правая кнопка для настроек"
L["Script"] = "Скрипт"
L["Script défaut"] = "Скрипт по умолчанию" -- Needs review
L["Script personnalisé"] = "Пользовательский скрипт"
L["shortcd"] = [=[Способности с малым временем восстановления.
Используются так часто, как только возможно.]=]
L["Short cooldown abilities"] = "Способности с малым временем восстановления"
L["Show hidden"] = "показать скрытые скрипты"
L["Show minimap icon"] = "Показать иконку на миникарте"
L["Show the icon of the next spell to cast"] = "Показывать иконку следующего произносимого заклинания"
L["showwait"] = "Показывать иконку ожидания"
L["Si cible uniquement"] = "Если выбрана цель"
L["SIMULATIONCRAFT_OVERRIDES_DESCRIPTION"] = "Код скрипта вставляется сразу после выражения Include() для перезаписи стандартных определений, например  |cFFFFFF00SpellInfo(tigers_fury tag=main)|r" -- Needs review
L["SimulationCraft Profile"] = "Профайл SimulationCraft" -- Needs review
L["summon_pet"] = "Призвать питомца."
L["Taille des icônes"] = "Размер иконки"
L["Taille des petites icônes"] = "Масштаб маленькой иконки"
L["Taille des polices"] = "Размер шрифта"
L["Taille du second icône"] = "Размер второй иконки"
L["The contents of a SimulationCraft profile."] = "Содержимре профайла SimulationCraft" -- Needs review
L["The script translated from the SimulationCraft profile."] = "Преобразованный скрипт из профайла SimulationCraft" -- Needs review
L["Time (in milliseconds) to begin flashing the spell to use before it is ready."] = "Время (в миллисекундах) за которое, до готовности, способность подсветится."
L["Verrouiller position"] = "Блокировка позиции"
L["Vertical"] = "Вертикально"
L["Visibilité"] = "Показывать"

elseif locale == "zhCN" then

L["Affichage numérique"] = "数字显示"
L["Affiche les deux prochains sorts et pas uniquement le suivant"] = "显示下2个需要释放的技能而不仅是1个"
L["Affiche le temps de recharge sous forme numérique"] = "用数字显示剩余时间"
L["Afficher la fenêtre"] = "显示Ovale"
L["Afficher les raccourcis clavier dans le coin inférieur gauche des icônes"] = "在图标左下角显示快捷键"
L["aoe"] = "多目标攻击" -- Needs review
L["AOE"] = "AOE输出循环"
L["Apparence"] = "环境"
-- L["arcane_mage_burn_phase"] = ""
L["Aura lag"] = "触发与移除效果延迟" -- Needs review
L["Blood"] = "鲜血"
L["buff"] = "增益"
L["Cacher bouton vide"] = "隐藏空按钮的背景"
L["Cacher dans les véhicules"] = "使用载具时隐藏"
L["Cacher la fenêtre"] = "隐藏Ovale"
L["Cacher si cible amicale ou morte"] = "当目标是友方或已死亡时隐藏"
L["Caractère de portée"] = "距离显示"
L["cd"] = [=[长CD的爆发技能与物品。
卡CD使用或在boss增伤阶段使用。]=]
L["Ce caractère est affiché dans un coin de l'icône pour indiquer si la cible est à portée"] = "显示在技能图标上的符号以检测与目标的距离"
L["Click to select the script."] = "点击以选取脚本"
L["Cliquer pour afficher/cacher les options"] = "点击来隐藏/显示选项"
L["Code"] = "代码"
L["Copier sur Script personnalisé"] = "复制到自定义脚本"
L["Correction de la latence"] = "延迟修正"
L["Debug aura"] = "追踪光环管理."
L["Debug compile"] = "追踪已编译脚本."
L["Debug enemies"] = "追踪敌人侦测."
L["Debug GUID"] = "追踪UnitID/GUID配对变化."
L["Debug missing spells"] = "使用的已知法术ID在法术书中无法找到时提醒."
L["Debug unknown spells"] = "脚本中使用了未知的法术ID时提醒."
L["Décalage horizontal des options"] = "选项水平移位"
L["Décalage vertical des options"] = "选项垂直移位"
L["Défilement"] = "滑动动画显示下一个技能"
L["Ecraser le Script personnalisé préexistant?"] = "覆盖已存在的自定义脚本?"
L["En combat uniquement"] = "仅在战斗中显示"
L["Flash brightness"] = "闪光亮度"
L["Flash size"] = "闪光尺寸"
L["Flash spells"] = "法术闪光"
L["Flash spells on action bars when they are ready to be cast. Requires SpellFlashCore"] = "当技能冷却结束时显示闪光效果。需要插件SpellFLashCore"
L["Flash threshold"] = "闪光阈值" -- Needs review
L["Focus"] = "焦点"
L["Groupe d'icônes"] = "图标分组"
L["Icône"] = "图标"
L["Ignorer les clics souris"] = "忽略鼠标点击"
L["Illuminer l'icône"] = "高亮显示图标"
L["Illuminer l'icône quand la technique doit être spammée"] = "当技能应重复使用时高亮显示图标"
L["Illuminer l'icône quand le temps de recharge est écoulé"] = "技能就绪时闪烁图标"
L["interrupt"] = "打断施法"
L["Interrupts"] = "打断施法"
L["Inverser la boîte à cocher "] = "开启/关闭选择框"
L["Lag (in milliseconds) between when an spell is cast and when the affected aura is applied or removed"] = "释放一个技能与其触发/移除效果之间的延迟" -- Needs review
L["La taille des icônes"] = "图标大小"
L["La taille des petites icônes"] = "小型图标大小"
L["La taille des polices"] = "字体大小"
L["Les icônes se déplacent"] = "滚动图标"
L["Long cooldown abilities"] = "长CD的技能与物品" -- Needs review
L["main"] = "主要攻击技能"
L["Main attack"] = "主要攻击技能" -- Needs review
L["mana"] = "法力获取"
L["Marge entre deux icônes"] = "图标间距"
L["moving"] = "移动中使用攻击"
L["multidot"] = "多目标持续伤害"
L["None"] = "无"
L["not_in_melee_range"] = "脱离近战范围"
L["offgcd"] = [=[无公共冷却的技能与物品
可以在你使用主攻技能的同时使用。]=]
-- L["Only count a mob as an enemy if it is directly affected by a player's spells."] = ""
-- L["Only count tagged enemies"] = ""
L["Opacité des icônes"] = "图标透明度"
L["Opacité des options"] = "选项透明度"
L["Options"] = "选项"
-- L["Overrides"] = ""
L["predict"] = "下一个非填充性技能。"
L["Prédictif"] = "两个技能" -- Needs review
L["Raccourcis clavier"] = "快捷键"
L["Right-Click for options."] = "右键点击打开选项"
L["Script"] = "脚本"
L["Script défaut"] = "默认脚本" -- Needs review
L["Script personnalisé"] = "自定义脚本"
L["shortcd"] = [=[短CD技能.
卡CD使用]=]
L["Short cooldown abilities"] = "短CD技能"
L["Show hidden"] = "显示隐藏的脚本"
L["Show minimap icon"] = "在小地图上显示图标"
L["Show the icon of the next spell to cast"] = "显示下一个需要施放的技能的图标"
L["showwait"] = "显示等待图标"
L["Si cible uniquement"] = "当目标存在时"
-- L["SIMULATIONCRAFT_OVERRIDES_DESCRIPTION"] = ""
-- L["SimulationCraft Profile"] = ""
L["summon_pet"] = "召唤宠物。"
L["Taille des icônes"] = "图标大小"
L["Taille des petites icônes"] = "小型图标大小"
L["Taille des polices"] = "字体大小"
L["Taille du second icône"] = "第二图标大小"
-- L["The contents of a SimulationCraft profile."] = ""
-- L["The script translated from the SimulationCraft profile."] = ""
L["Time (in milliseconds) to begin flashing the spell to use before it is ready."] = "在技能冷却时间结束之前开始闪光的提前量（毫秒）" -- Needs review
L["Verrouiller position"] = "锁定位置"
L["Vertical"] = "垂直"
L["Visibilité"] = "可见设置"

elseif locale == "zhTW" then

L["Affichage numérique"] = "顯示數字"
L["Affiche les deux prochains sorts et pas uniquement le suivant"] = "顯示兩排技能圖示"
L["Affiche le temps de recharge sous forme numérique"] = "技能剩餘時間以數字顯示"
L["Afficher la fenêtre"] = "顯示窗口"
L["Afficher les raccourcis clavier dans le coin inférieur gauche des icônes"] = "顯示快捷列左下角的超出距離提醒圖示"
L["aoe"] = [=[AOE 範圍攻擊
根據敵人的總數來選擇。]=] -- Needs review
L["AOE"] = "AOE 範圍攻擊"
L["Apparence"] = "框架外觀設定"
L["arcane_mage_burn_phase"] = "奧法暴衝階段" -- Needs review
L["Aura lag"] = "增益/減益效果延遲"
L["Blood"] = "血量"
L["buff"] = "提示能施放的增益法術"
L["Cacher bouton vide"] = "隱藏空的按鈕"
L["Cacher dans les véhicules"] = "使用載具時隱藏"
L["Cacher la fenêtre"] = "隱藏窗口"
L["Cacher si cible amicale ou morte"] = "隱藏友好或已死亡的目標"
L["Caractère de portée"] = "範圍提醒"
L["cd"] = [=[冷卻時間長的技能 (大招)
盡快施放，或在爆發期使用。]=]
L["Ce caractère est affiché dans un coin de l'icône pour indiquer si la cible est à portée"] = "自訂一段文字，如果目標是在範圍內，這段文字會在圖示上顯示提醒你。"
L["Click to select the script."] = "左鍵選擇腳本。"
L["Cliquer pour afficher/cacher les options"] = "點擊隱藏/顯示選項"
L["Code"] = "腳本"
L["Copier sur Script personnalisé"] = "複製到自訂腳本"
L["Correction de la latence"] = "延遲校正"
L["Debug aura"] = "追蹤光環管理" -- Needs review
L["Debug compile"] = "追蹤已編譯腳本" -- Needs review
L["Debug enemies"] = "追蹤敵人偵測" -- Needs review
L["Debug GUID"] = "追蹤UnitID/GUID配對變化" -- Needs review
L["Debug missing spells"] = "使用的已知法術ID在法術書中無法找到時提醒" -- Needs review
L["Debug unknown spells"] = "腳本中使用了未知法術ID時提醒" -- Needs review
L["Décalage horizontal des options"] = "水平移動框架"
L["Décalage vertical des options"] = "垂直移動框架"
L["Défilement"] = "滾動圖示"
L["Ecraser le Script personnalisé préexistant?"] = "是否覆寫已存在自訂腳本?"
L["En combat uniquement"] = "只在戰鬥中顯示"
L["Flash brightness"] = "閃爍亮度"
L["Flash size"] = "閃爍尺寸"
L["Flash spells"] = "法術閃爍"
L["Flash spells on action bars when they are ready to be cast. Requires SpellFlashCore"] = "法術能使用時，閃爍技能列中的圖示。需要 SpellFlashCore。"
L["Flash threshold"] = "閃爍條件"
L["Focus"] = "專注目標"
L["Groupe d'icônes"] = "圖示群組"
L["Icône"] = "圖示"
L["Ignorer les clics souris"] = "忽略滑鼠點擊"
L["Illuminer l'icône"] = "高亮度顯示圖示邊框"
L["Illuminer l'icône quand la technique doit être spammée"] = "技能能使用時高亮度顯示圖示邊框"
L["Illuminer l'icône quand le temps de recharge est écoulé"] = "圖示變亮時，表示技能可以使用。"
L["interrupt"] = "斷法技能"
L["Interrupts"] = "斷法技能"
L["Inverser la boîte à cocher "] = "開啟/關閉選擇框"
L["Lag (in milliseconds) between when an spell is cast and when the affected aura is applied or removed"] = "法術施放後和受到光環影響之間的延遲時間 (毫秒)"
L["La taille des icônes"] = "調整圖示大小"
L["La taille des petites icônes"] = "調整小圖示大小"
L["La taille des polices"] = "調整字體大小"
L["Les icônes se déplacent"] = "圖示以滾動方式顯示"
L["Long cooldown abilities"] = "冷卻時間長的大招"
L["main"] = "主要攻擊"
L["Main attack"] = "主要攻擊"
L["mana"] = "法力獲得"
L["Marge entre deux icônes"] = "圖示間距"
L["moving"] = "移動時可使用的攻擊技能"
L["multidot"] = "對多個目標的持續性傷害 DOT"
L["None"] = "無"
L["not_in_melee_range"] = "超出近戰範圍指示"
L["offgcd"] = [=[不受共用冷卻時間影響的技能
和主要攻擊技能一起施放。]=]
L["Only count a mob as an enemy if it is directly affected by a player's spells."] = "計算直接受到玩家法術影響的敵人。"
L["Only count tagged enemies"] = "只有直接受影響的敵人"
L["Opacité des icônes"] = "圖示透明度"
L["Opacité des options"] = "選項透明度"
L["Options"] = "選項"
-- L["Overrides"] = ""
L["predict"] = "下一個非填補攻擊。" -- Needs review
L["Prédictif"] = "預測"
L["Raccourcis clavier"] = "顯示快捷鍵"
L["Right-Click for options."] = "右鍵開啟選項。"
L["Script"] = "腳本"
L["Script défaut"] = "預設腳本"
L["Script personnalisé"] = "自訂腳本"
L["shortcd"] = [=[冷卻時間短的技能
儘快施放，或卡GCD、無招可放時使用。]=]
L["Short cooldown abilities"] = "冷卻時間短的技能"
L["Show hidden"] = "顯示隱藏的腳本"
L["Show minimap icon"] = "顯示小地圖按鈕"
L["Show the icon of the next spell to cast"] = "顯示下一個要施放的技能圖示"
L["showwait"] = "顯示等待圖示"
L["Si cible uniquement"] = "有目標才顯示"
-- L["SIMULATIONCRAFT_OVERRIDES_DESCRIPTION"] = ""
L["SimulationCraft Profile"] = "SimulationCraft 設定檔"
L["summon_pet"] = "召喚寵物。"
L["Taille des icônes"] = "圖示大小"
L["Taille des petites icônes"] = "小圖示大小"
L["Taille des polices"] = "字體大小"
L["Taille du second icône"] = "第二圖示大小"
L["The contents of a SimulationCraft profile."] = "SimulationCraft 設定檔內容。"
L["The script translated from the SimulationCraft profile."] = "依據 SimulationCraft 設定檔轉譯的腳本。"
L["Time (in milliseconds) to begin flashing the spell to use before it is ready."] = "法術能夠使用前，多久開始閃爍 (毫秒)"
L["Verrouiller position"] = "鎖定圖示位置"
L["Vertical"] = "垂直圖示"
L["Visibilité"] = "可見性設定" -- Needs review

end
