local f = CreateFrame"Frame"
local dropdown, dropdownInit = CreateFrame( "Frame", "RunevolutionLDBDD", nil, "UIDropDownMenuTemplate" )
local player, tipshown = UnitName"player"
local tipshown, config, days, chars, classes, f1, f2, f3
local t, sorted, defaultClass = {}, {}, { r=1, g=.8, b=0 }
local ByValue = function(a,b) return a.money > b.money end
local ByName = function(a,b) return a.name < b.name end
local othersMoney, session, today = 0

local block = LibStub("LibDataBroker-1.1"):NewDataObject("RunevolutionLDB", {
	type = "data source",
	icon = "Interface\\Icons\\Spell_Shadow_DeathAndDecay",
	OnLeave = function()
		--GameTooltipTextLeft1:SetFont( f1, f2, f3 )
		--GameTooltipTextRight1:SetFont( f1, f2, f3 )
		tipshown = nil
		return GameTooltip:Hide()
	end,
	OnClick = function(self, button)
		if button == "RightButton" then
			GameTooltip:Hide()
			UIDropDownMenu_Initialize( dropdown, dropdownInit, "MENU" )
			return ToggleDropDownMenu( 1, nil, dropdown, self, 0, 0)
        elseif button == "LeftButton" then
            -- toggle config mode
            RunevolutionConfigMode = not RunevolutionConfigMode
		end
	end
})


block.OnEnter = function(self)
	tipshown = self
	local showBelow = select(2, self:GetCenter()) > UIParent:GetHeight()/2
	GameTooltip:SetOwner( self, "ANCHOR_NONE" )
	GameTooltip:SetPoint( showBelow and "TOP" or "BOTTOM", self, showBelow and "BOTTOM" or "TOP" )

	GameTooltip:AddLine( "Runevolution" )
	GameTooltip:AddLine( "|cFFFFFF66Left-click: Toggle configuration mode on/off" )
	GameTooltip:AddLine( "|cFFFFFF66Right-click: Options menu" )
	

	--f1, f2, f3 = GameTooltipTextLeft1:GetFont()
	--GameTooltipTextLeft1:SetFont( GameTooltipTextLeft2:GetFont() )
	--GameTooltipTextRight1:SetFont( GameTooltipTextLeft2:GetFont() )
	return GameTooltip:Show()
end

local function OnEvent(self, event, addon)
	block.text = "Runevolution"
	--return IsLoggedIn() and OnEvent(nil, "")
end

f:SetScript( "OnEvent", OnEvent )

f:RegisterEvent"ADDON_LOADED"
f:RegisterEvent"PLAYER_LOGIN"

local options = {
	{ text = "Runevolution "..Runevolution_version , isTitle = true },
	{ text = "Track Diseases" },
	{ text = "Show Runic Power" }
}

function RunevolutionLDB_DD_OnClick(this)
    --message( this.value )
    
    if this.value == "Show out-of-combat" then
        RunevolutionData.show_ooc = not RunevolutionData.show_ooc
    end
    
    if this.value == "Show Diseases" then
        RunevolutionData.show_diseases = not RunevolutionData.show_diseases
    end
    
    if this.value == "Show Others' Diseases" then
        RunevolutionData.show_all_diseases = not RunevolutionData.show_all_diseases
    end
    
    if this.value == "Diseases on top" then
        RunevolutionData.diseases_up = not RunevolutionData.diseases_up
    end
    
    if this.value == "Hide Blizzard runes" then
        RunevolutionData.hide_bliz = not RunevolutionData.hide_bliz
        if RunevolutionData.hide_bliz then
            RuneFrame:Hide()
        else
            RuneFrame:Show()
        end
    end
    
    if this.value == "Show runic power" then
        RunevolutionData.show_rp = not RunevolutionData.show_rp
    end
    
    if this.value == "Stationary runic power" then
        RunevolutionData.fix_rp = not RunevolutionData.fix_rp
    end
    
    if this.value == "Stationary runes" then
        RunevolutionData.static = not RunevolutionData.static
    end
    
    local resized = false
    if this.value == "Small runes" then
        RunevolutionData.runesize = 16
        resized = true
    end
    if this.value == "Medium runes" then
        RunevolutionData.runesize = 24
        resized = true
    end
    if this.value == "Large runes" then
        RunevolutionData.runesize = 32
        resized = true
    end
    if resized then
        Runevolution_resizeall()
    end
    
    if this.value == "mode:standard" then
        RunevolutionData.coordset = "standard"
    end
    if this.value == "mode:standardcompact" then
        RunevolutionData.coordset = "standardcompact"
    end
    if this.value == "mode:vertical2" then
        RunevolutionData.coordset = "vertical2"
    end
    if this.value == "mode:vertical2compact" then
        RunevolutionData.coordset = "vertical2compact"
    end
    if this.value == "mode:custom" then
        RunevolutionData.coordset = "custom"
    end
    
    if this.value == "texture:default" then
        RunevolutionData.runetextures = "default"
    end
    if this.value == "texture:DKI" then
        RunevolutionData.runetextures = "DKI"
    end
    if this.value == "texture:glossy" then
        RunevolutionData.runetextures = "glossy"
    end
    
end

dropdownInit = function(self, level)

    --[[RunevolutionData = {
    loc = { x=0 , y=-100 },
    runesize = 24,
    cooldowndistance = 5,
    show_ooc = true,
    show_rp = true,
    show_back = true,
    fix_rp = false,
    show_diseases = false,
    diseases_up = false,
    hide_bliz = false,
    show_all_diseases = false,
    static = false,
    coordset = "standard",
    REversion = Runevolution_version   -- version mark for pref updating
    }]]--

	level = level or 1
	local info = UIDropDownMenu_CreateInfo()
	
	info.text = "Runevolution "..Runevolution_version
    info.isTitle = true
    info.value = -1
    info.func = function(self) RunevolutionLDB_DD_OnClick(self) end
    info.owner = self:GetParent()
    info.checked = nil
    info.icon = nil
    UIDropDownMenu_AddButton(info, level)
    
    info.isTitle = nil
    info.disabled = nil
    
    info.text = "Show out-of-combat"
    info.value = "Show out-of-combat"
    info.func = function(self) RunevolutionLDB_DD_OnClick(self) end
    info.owner = self:GetParent()
    info.checked = RunevolutionData.show_ooc
    info.icon = nil
    UIDropDownMenu_AddButton(info, level)
    
    info.text = "Show Diseases"
    info.value = "Show Diseases"
    info.func = function(self) RunevolutionLDB_DD_OnClick(self) end
    info.owner = self:GetParent()
    info.checked = RunevolutionData.show_diseases
    info.icon = nil
    UIDropDownMenu_AddButton(info, level)
    
    info.text = "Show Others' Diseases"
    info.value = "Show Others' Diseases"
    info.func = function(self) RunevolutionLDB_DD_OnClick(self) end
    info.owner = self:GetParent()
    info.checked = RunevolutionData.show_all_diseases
    info.icon = nil
    UIDropDownMenu_AddButton(info, level)
    
    info.text = "Diseases on top"
    info.value = "Diseases on top"
    info.func = function(self) RunevolutionLDB_DD_OnClick(self) end
    info.owner = self:GetParent()
    info.checked = RunevolutionData.diseases_up
    info.icon = nil
    UIDropDownMenu_AddButton(info, level)
    
    info.text = "Hide Blizzard runes"
    info.value = "Hide Blizzard runes"
    info.func = function(self) RunevolutionLDB_DD_OnClick(self) end
    info.owner = self:GetParent()
    info.checked = RunevolutionData.hide_bliz
    info.icon = nil
    UIDropDownMenu_AddButton(info, level)
    
    info.text = "Show runic power"
    info.value = "Show runic power"
    info.func = function(self) RunevolutionLDB_DD_OnClick(self) end
    info.owner = self:GetParent()
    info.checked = RunevolutionData.show_rp
    info.icon = nil
    UIDropDownMenu_AddButton(info, level)
    
    info.text = "Stationary runic power"
    info.value = "Stationary runic power"
    info.func = function(self) RunevolutionLDB_DD_OnClick(self) end
    info.owner = self:GetParent()
    info.checked = RunevolutionData.fix_rp
    info.icon = nil
    UIDropDownMenu_AddButton(info, level)
    
    info.text = "Stationary runes"
    info.value = "Stationary runes"
    info.func = function(self) RunevolutionLDB_DD_OnClick(self) end
    info.owner = self:GetParent()
    info.checked = RunevolutionData.static
    info.icon = nil
    UIDropDownMenu_AddButton(info, level)
    
    info.text = "Rune Size"
    info.isTitle = true
    info.value = -1
    info.func = function(self) RunevolutionLDB_DD_OnClick(self) end
    info.owner = self:GetParent()
    info.checked = nil
    info.icon = nil
    UIDropDownMenu_AddButton(info, level)
    
    info.isTitle = nil
    info.disabled = nil
    
    info.text = "Small runes"
    info.value = "Small runes"
    info.func = function(self) RunevolutionLDB_DD_OnClick(self) end
    info.owner = self:GetParent()
    info.checked = false
    if RunevolutionData.runesize == 16 then
        info.checked = true
    end
    info.icon = nil
    UIDropDownMenu_AddButton(info, level)
    
    info.text = "Medium runes"
    info.value = "Medium runes"
    info.func = function(self) RunevolutionLDB_DD_OnClick(self) end
    info.owner = self:GetParent()
    info.checked = false
    if RunevolutionData.runesize == 24 then
        info.checked = true
    end
    info.icon = nil
    UIDropDownMenu_AddButton(info, level)
    
    info.text = "Large runes"
    info.value = "Large runes"
    info.func = function(self) RunevolutionLDB_DD_OnClick(self) end
    info.owner = self:GetParent()
    info.checked = false
    if RunevolutionData.runesize == 32 then
        info.checked = true
    end
    info.icon = nil
    UIDropDownMenu_AddButton(info, level)
    
    info.text = "Runevolution Modes"
    info.isTitle = true
    info.value = -1
    info.func = function(self) RunevolutionLDB_DD_OnClick(self) end
    info.owner = self:GetParent()
    info.checked = nil
    info.icon = nil
    UIDropDownMenu_AddButton(info, level)
    
    info.isTitle = nil
    info.disabled = nil
    
    local mode = "standard"
    info.text = "Horizontal"
    info.value = "mode:"..mode
    info.func = function(self) RunevolutionLDB_DD_OnClick(self) end
    info.owner = self:GetParent()
    local check = false
    if RunevolutionData.coordset == mode then
        check = true
    end
    info.checked = check
    info.icon = nil
    UIDropDownMenu_AddButton(info, level)
    
    local mode = "standardcompact"
    info.text = "Horizontal compact"
    info.value = "mode:"..mode
    info.func = function(self) RunevolutionLDB_DD_OnClick(self) end
    info.owner = self:GetParent()
    local check = false
    if RunevolutionData.coordset == mode then
        check = true
    end
    info.checked = check
    info.icon = nil
    UIDropDownMenu_AddButton(info, level)
    
    local mode = "vertical2"
    info.text = "Vertical"
    info.value = "mode:"..mode
    info.func = function(self) RunevolutionLDB_DD_OnClick(self) end
    info.owner = self:GetParent()
    local check = false
    if RunevolutionData.coordset == mode then
        check = true
    end
    info.checked = check
    info.icon = nil
    UIDropDownMenu_AddButton(info, level)
    
    local mode = "vertical2compact"
    info.text = "Vertical compact"
    info.value = "mode:"..mode
    info.func = function(self) RunevolutionLDB_DD_OnClick(self) end
    info.owner = self:GetParent()
    local check = false
    if RunevolutionData.coordset == mode then
        check = true
    end
    info.checked = check
    info.icon = nil
    UIDropDownMenu_AddButton(info, level)
    
    local mode = "custom"
    info.text = "Custom layout"
    info.value = "mode:"..mode
    info.func = function(self) RunevolutionLDB_DD_OnClick(self) end
    info.owner = self:GetParent()
    local check = false
    if RunevolutionData.coordset == mode then
        check = true
    end
    info.checked = check
    info.icon = nil
    UIDropDownMenu_AddButton(info, level)
    
    info.text = "Rune Textures"
    info.isTitle = true
    info.value = -1
    info.func = function(self) RunevolutionLDB_DD_OnClick(self) end
    info.owner = self:GetParent()
    info.checked = nil
    info.icon = nil
    UIDropDownMenu_AddButton(info, level)
    
    info.isTitle = nil
    info.disabled = nil
    
    local mode = "default"
    info.text = "Default"
    info.value = "texture:"..mode
    info.func = function(self) RunevolutionLDB_DD_OnClick(self) end
    info.owner = self:GetParent()
    local check = false
    if RunevolutionData.runetextures == mode then
        check = true
    end
    info.checked = check
    info.icon = nil
    UIDropDownMenu_AddButton(info, level)
    
    local mode = "DKI"
    info.text = "DKI"
    info.value = "texture:"..mode
    info.func = function(self) RunevolutionLDB_DD_OnClick(self) end
    info.owner = self:GetParent()
    local check = false
    if RunevolutionData.runetextures == mode then
        check = true
    end
    info.checked = check
    info.icon = nil
    UIDropDownMenu_AddButton(info, level)
    
    local mode = "glossy"
    info.text = "Glossy"
    info.value = "texture:"..mode
    info.func = function(self) RunevolutionLDB_DD_OnClick(self) end
    info.owner = self:GetParent()
    local check = false
    if RunevolutionData.runetextures == mode then
        check = true
    end
    info.checked = check
    info.icon = nil
    UIDropDownMenu_AddButton(info, level)
    
end