-- Runevolution

-- globals

Runevolution_version = "v1.5.1"

-- saved variables, per character
RunevolutionData = {
    loc = { x=0 , y=-100 },
    runesize = 32,
    cooldowndistance = 5,
    show_ooc = true,
    show_rp = true,
    show_back = true,
    fix_rp = true,
    show_diseases = true,
    diseases_up = false,
    hide_bliz = false,
    show_all_diseases = false,
    static = false,
    coordset = "standard",
    runetextures = "default",
    custommode = {},
    cooldownshidden = {},
    REversion = Runevolution_version   -- version mark for pref updating
}
-----符文Textures
RunevolutionRuneTextures = {

    ["default"] = {
        ["death"] = "Interface\\Addons\\Runevolution\\Death.blp",
        ["deathoff"] = "Interface\\Addons\\Runevolution\\Death-Off.blp",
        ["deathback"] = "Interface\\Addons\\Runevolution\\Death-back.blp"
    },
    ["glossy"] = {
        ["death"] = "Interface\\Addons\\Runevolution\\textures\\GlossyDeath.blp",
        ["deathoff"] = "Interface\\Addons\\Runevolution\\Death-Off.blp",
        ["deathback"] = "Interface\\Addons\\Runevolution\\Death-back.blp"
    },
    ["DKI"] = {
        ["death"] = "Interface\\Addons\\Runevolution\\textures\\DKIDeath.blp",
        ["deathoff"] = "Interface\\Addons\\Runevolution\\textures\\DKIDeath-off.blp",
        ["deathback"] = "Interface\\Addons\\Runevolution\\textures\\DKIDeath-back.blp"
    }
    
}

RunevolutionDiseaseList = {
	------------------------邪恶------------------------
	-----恶性瘟疫
	["Virulent Plague"] = { unit="target" , type="debuff" , id=191587 , pos=-1 , icon="ability_creature_disease_02" , 				defaultvisibility=false },
	-----溃烂之伤
	["Festering Wound"] = { unit="target" , 	type="debuff" , id=194310 , pos=-2 , icon="spell_yorsahj_bloodboil_purpleoil" , 	defaultvisibility=false },
	------爆发
	["Outbreak"] = { unit="target" , 	type="debuff" , id=196782 , pos=-3 , icon="spell_deathvortex" , 	defaultvisibility=false },
	------窒息
	["Asphyxiate"] = { unit="target" , 	type="debuff" , id=108194 , pos=-4 , icon="ability_deathknight_asphixiate" , 	defaultvisibility=false },
	
	["Epidemic"] = { unit="player" , 	type="spell" , id=207317 , pos=1 , icon="spell_deathknight_unholypresence" , 	defaultvisibility=true },
	--------------------------冰霜---------------------------
	------冰霜瘟疫
    ["Frost Fever"] = { unit="target" , type="debuff" , id=55095 , pos=-1 , icon="spell_deathknight_frostfever" , defaultvisibility=false },
	--------------------------鲜血---------------------------
	------血之瘟疫
    ["Blood Plague"] = { unit="target" , type="debuff" , id=55078 , pos=-1 , icon="spell_deathknight_bloodplague" , defaultvisibility=false },
	------白骨之盾
	["Bone Shield"] = { unit="player" , type="buff" , id=195181 , pos=1 , icon="ability_deathknight_boneshield" , defaultvisibility=true },
	------吸血鬼之血
	["Vampiric Blood"] = { unit="player" , type="buff" , id=55233 , pos=2 , icon="spell_shadow_lifedrain" , defaultvisibility=true },
	["Blood Boil"] = { unit="player" , 	type="spell" , id=50842 , pos=1 , icon="spell_deathknight_bloodboil" , 	defaultvisibility=true }
	

}

local RunevolutionDiseaseLocalizer = {
	["Virulent Plague"] = { ["de"]="Virulent Plague" , ["fr"]="Force impie" , ["es"]="Fuerza impía" , ["zh"]="恶性瘟疫" , ["ko"]="부정의 힘" },
	["Festering Wound"] = { ["de"]="Virulent Plague" , ["fr"]="Force impie" , ["es"]="Fuerza impía" , ["zh"]="溃烂之伤" , ["ko"]="부정의 힘" },
	["Outbreak"] = { ["de"]="Virulent Plague" , ["fr"]="Force impie" , ["es"]="Fuerza impía" , ["zh"]="爆发" , ["ko"]="부정의 힘" },
	["Asphyxiate"] = { ["de"]="Virulent Plague" , ["fr"]="Force impie" , ["es"]="Fuerza impía" , ["zh"]="窒息" , ["ko"]="부정의 힘" },
	["Frost Fever"] = { ["de"]="Virulent Plague" , ["fr"]="Force impie" , ["es"]="Fuerza impía" , ["zh"]="冰霜瘟疫" , ["ko"]="부정의 힘" },
	["Blood Plague"] = { ["de"]="Virulent Plague" , ["fr"]="Force impie" , ["es"]="Fuerza impía" , ["zh"]="血之瘟疫" , ["ko"]="부정의 힘" },
	["Bone Shield"] = { ["de"]="Virulent Plague" , ["fr"]="Force impie" , ["es"]="Fuerza impía" , ["zh"]="白骨之盾" , ["ko"]="부정의 힘" },
	["Vampiric Blood"] = { ["de"]="Virulent Plague" , ["fr"]="Force impie" , ["es"]="Fuerza impía" , ["zh"]="吸血鬼之血" , ["ko"]="부정의 힘" },
	["Epidemic"] = { ["de"]="Virulent Plague" , ["fr"]="Force impie" , ["es"]="Fuerza impía" , ["zh"]="传染" , ["ko"]="부정의 힘" },
}

RunevolutionFrames = {}
RunevolutionTextures = {}

-- relative positions of runes at start
local RunevolutionXOffset = {
    [1] = -6,
    [2] = -5,
    [3] = -1,
    [4] = -2,
    [5] = -4,
    [6] = -3
}
local RunevolutionYOffset = {
    [1] = 0,
    [2] = 0,
    [3] = 0,
    [4] = 0,
    [5] = 0,
    [6] = 0
}
local RunevolutionTimeReady = {
    [1] = 1,
    [2] = 2,
    [3] = 3,
    [4] = 4,
    [5] = 5,
    [6] = 6
}

-- v2
-- coordinates allow for arbitrary rune paths
-- each pair of x,y coords corresponds to an x-offset
-- e.g. x-offset = -1 takes the [-1] pair of coordinates
-- when a rune is between x offsets, position is linear interpolation of neighboring positions
RunevolutionCoordinates = {
    ["custom"] = RunevolutionData.custommode,
    ["standard"] = {
        -- ready rune positions
        [-6] = {-6,0},
        [-5] = {-5,0},
        [-4] = {-4,0},
        [-3] = {-3,0},
        [-2] = {-2,0},
        [-1] = {-1,0},
        -- cooling rune positions
        [0] = {0,0},
        [1] = {1,0},
        [2] = {2,0},
        [3] = {3,0},
        [4] = {4,0},
        [5] = {5,0},
        [6] = {6,0},
        [7] = {7,0},
        [8] = {8,0},
        [9] = {9,0},
        [10] = {10,0},
        ["offsetaxis"] = {0,1}, -- direction to offset runes (x or y axis)
        ["offsetcoords"] = { {0.4,-0.4} , {0,0.8,-0.8} },
        ["rpoffset"] = {-1,0},
        ["rpfix"] = {0,1},
        ["newready"] = -1, -- absolute position of newly ready rune
        ["shiftready"] = -1 -- shift ready runes to left
    },
    ["standardcompact"] = {
        -- ready rune positions
        [-6] = {-3,-1},
        [-5] = {-2,-1},
        [-4] = {-1,-1},
        [-3] = {-3,0},
        [-2] = {-2,0},
        [-1] = {-1,0},
        -- cooling rune positions
        [0] = {0,0},
        [1] = {1,0},
        [2] = {2,0},
        [3] = {3,0},
        [4] = {4,0},
        [5] = {5,0},
        [6] = {6,0},
        [7] = {7,0},
        [8] = {8,0},
        [9] = {9,0},
        [10] = {10,0},
        ["offsetaxis"] = {0,1}, -- direction to offset runes (x or y axis)
        ["offsetcoords"] = { {0.4,-0.4} , {0,0.8,-0.8} },
        ["rpoffset"] = {-1,0},
        ["rpfix"] = {0,1},
        ["newready"] = -1, -- absolute position of newly ready rune
        ["shiftready"] = -1 -- shift ready runes to left
    },
    --[[["circle"] = {
        -- ready rune positions
        [-6] = {-6,0},
        [-5] = {-5,0.5},
        [-4] = {-4,1},
        [-3] = {-3,1},
        [-2] = {-2,0.5},
        [-1] = {-1,0},
        -- cooling rune positions
        [0] = {0,-1},
        [1] = {-1,-1.25},
        [2] = {-1.5,-1.5},
        [3] = {-2,-1.5},
        [4] = {-2.5,-2},
        [5] = {-3,-2.5},
        [6] = {-3.5,-2},
        [7] = {-4,-1.5},
        [8] = {-4.5,-1.5},
        [9] = {-5,-1.25},
        [10] = {-6,-1},
        ["offsetaxis"] = {0,1}, -- direction to offset runes (x or y axis)
        ["offsetcoords"] = { {0.4,-0.4} , {0,0.8,-0.8} },
        ["rpoffset"] = {-1,0},
        ["newready"] = -1, -- absolute position of newly ready rune
        ["shiftready"] = -1 -- shift ready runes to left
    },
    ["leftjustify"] = {
        -- ready rune positions
        [-6] = {-1,0},
        [-5] = {-2,0},
        [-4] = {-3,0},
        [-3] = {-4,0},
        [-2] = {-5,0},
        [-1] = {-6,0},
        -- cooling rune positions
        [0] = {0,0},
        [1] = {1,0},
        [2] = {2,0},
        [3] = {3,0},
        [4] = {4,0},
        [5] = {5,0},
        [6] = {6,0},
        [7] = {7,0},
        [8] = {8,0},
        [9] = {9,0},
        [10] = {10,0},
        ["newready"] = "right", -- position freshly ready runes at first empty right hand position
        ["shiftready"] = 0 -- no shift for runes already off cooldown
    },
    ["verticallong"] = {
        -- ready rune positions
        [-6] = {0,-6},
        [-5] = {0,-5},
        [-4] = {0,-4},
        [-3] = {0,-3},
        [-2] = {0,-2},
        [-1] = {0,-1},
        -- cooling rune positions
        [0] = {0,0},
        [1] = {0,1},
        [2] = {0,2},
        [3] = {0,3},
        [4] = {0,4},
        [5] = {0,5},
        [6] = {0,6},
        [7] = {0,7},
        [8] = {0,8},
        [9] = {0,9},
        [10] = {0,10},
        ["offsetaxis"] = {1,0}, -- direction to offset runes (x or y axis)
        ["offsetcoords"] = { {0.4,-0.4} , {0,0.8,-0.8} },
        ["rpoffset"] = {0,-1},
        ["rpfix"] = {0,1},
        ["newready"] = -1, -- absolute position of newly ready rune
        ["shiftready"] = -1 -- shift ready runes to left
    },]]--
    ["vertical2"] = {
        -- ready rune positions
        [-6] = {0,5},
        [-5] = {0,4},
        [-4] = {0,3},
        [-3] = {0,2},
        [-2] = {0,1},
        [-1] = {0,0},
        -- cooling rune positions
        [0] = {1,0},
        [1] = {1,1},
        [2] = {1,2},
        [3] = {1,3},
        [4] = {1,4},
        [5] = {1,5},
        [6] = {1,6},
        [7] = {1,7},
        [8] = {1,8},
        [9] = {1,9},
        [10] = {1,10},
        ["offsetaxis"] = {1,0},
        ["offsetcoords"] = { {0,0.8} , {0,0.8,1.6} },
        ["rpoffset"] = {0,1},
        ["rpfix"] = {0,-1},
        ["newready"] = -1, -- absolute position of newly ready rune
        ["shiftready"] = -1 -- shift ready runes to left
    },
    ["vertical2compact"] = {
        -- ready rune positions
        [-6] = {-1,2},
        [-5] = {-1,1},
        [-4] = {-1,0},
        [-3] = {0,2},
        [-2] = {0,1},
        [-1] = {0,0},
        -- cooling rune positions
        [0] = {1,0},
        [1] = {1,1},
        [2] = {1,2},
        [3] = {1,3},
        [4] = {1,4},
        [5] = {1,5},
        [6] = {1,6},
        [7] = {1,7},
        [8] = {1,8},
        [9] = {1,9},
        [10] = {1,10},
        ["offsetaxis"] = {1,0},
        ["offsetcoords"] = { {0,0.8} , {0,0.8,1.6} },
        ["rpoffset"] = {0,1},
        ["rpfix"] = {0,-1},
        ["newready"] = -1, -- absolute position of newly ready rune
        ["shiftready"] = -1 -- shift ready runes to left
    }
}


for k,v in pairs( RunevolutionDiseaseList ) do
    RunevolutionXOffset[k] = 0
    RunevolutionYOffset[k] = -1
end

RunevolutionPulseDuration = 1/2 -- time in seconds it takes for pulse animation to finish
RunevolutionPulseFactor = 1.5 -- initial scale multiplier of pulse
RunevolutionPulseList = { -- animation times on pulse
    [1] = 0,
    [2] = 0,
    [3] = 0,
    [4] = 0,
    [5] = 0,
    [6] = 0,
    ['rp'] = 0,
    ['Blood Plague'] = 0,
    ['Frost Fever'] = 0
}
RunevolutionFlashList = {} -- pulsing alpha, to indicate diseases near expiring

local RunevolutionTimeReady = {}

RunevolutionHBtimer = 0 -- kluge for timing Howling Blast, until they fix it

RunevolutionConfigMode = false

-- Initialize

function Runevolution_OnLoad(self)

    local _,engClass = UnitClass("player")
    if engClass ~= "DEATHKNIGHT" then
        return
    end

    -- register events
    
    --- initialization events
    self:RegisterEvent("PLAYER_ENTERING_WORLD")
    self:RegisterEvent("VARIABLES_LOADED")
    
    -- rune events
    --this:RegisterEvent("RUNE_POWER_UPDATE")
    --this:RegisterEvent("RUNE_TYPE_UPDATE")
    
    -- kluge Howling Blast event, so we can time cooldown until they fix the tooltip
    --this:RegisterEvent("UNIT_SPELLCAST_SUCCEEDED")
	
	-- options init
	SlashCmdList["RUNEV"] = Runevolution_Options
	SLASH_RUNEV1 = "/runev"

end

-- slash handler
function Runevolution_Options(msg)
    
    local param;
    msg,param = strsplit(" ",msg,2);
    
    if msg == "x" then
        RunevolutionData.loc["x"] = tonumber(param)
        RunevolutionParentContainer:ClearAllPoints()
        RunevolutionParentContainer:SetPoint( "CENTER" , RunevolutionData.loc["x"] , RunevolutionData.loc["y"] )
        Runevolution_UpdateRunePositions()
    elseif msg == "y" then
        RunevolutionData.loc["y"] = tonumber(param)
        RunevolutionParentContainer:ClearAllPoints()
        RunevolutionParentContainer:SetPoint( "CENTER" , RunevolutionData.loc["x"] , RunevolutionData.loc["y"] )
        Runevolution_UpdateRunePositions()
    elseif msg == "cooldown" then
        RunevolutionData.cooldowndistance = min(param,10)
        if RunevolutionData.cooldowndistance < 1 then RunevolutionData.cooldowndistance = 1 end
        Runevolution_UpdateRunePositions()
    elseif msg == "size" then
        RunevolutionData.runesize = tonumber(param)
        Runevolution_resizeall()
    elseif msg == "reset" then
        Runevolution_AttemptReset()
        Runevolution_UpdateRuneTypes()
        Runevolution_UpdateRunePositions()
    elseif msg == "order" then
        local order = { strsplit( "," , param ) }
        for i = 1,6 do
            local _,_,ready = GetRuneCooldown( i )
            if ready then
                RunevolutionXOffset[ i ] = -7 + tonumber( order[ i ] )
            end
        end
        Runevolution_UpdateRuneTypes()
        Runevolution_UpdateRunePositions()
    elseif msg == "showooc" then
        RunevolutionData.show_ooc = not RunevolutionData.show_ooc
    elseif msg == "showrp" then
        RunevolutionData.show_rp = not RunevolutionData.show_rp
    elseif msg == "showback" then
        RunevolutionData.show_back = not RunevolutionData.show_back
        for i = 7,12 do
            if RunevolutionData.show_back then
                RunevolutionFrames[i]:Show()
            else
                RunevolutionFrames[i]:Hide()
            end
        end
    elseif msg == "fixrp" then
        RunevolutionData.fix_rp = not RunevolutionData.fix_rp
        Runevolution_UpdateRunePositions()
    elseif msg == "diseases" then
        RunevolutionData.show_diseases = not RunevolutionData.show_diseases
    elseif msg == "diseasepos" then
        RunevolutionData.diseases_up = not RunevolutionData.diseases_up
    elseif msg == "hidebliz" then
        RunevolutionData.hide_bliz = not RunevolutionData.hide_bliz
        if RunevolutionData.hide_bliz then
            RuneFrame:Hide()
        else
            RuneFrame:Show()
        end
    elseif msg == "alldiseases" then
        RunevolutionData.show_all_diseases = not RunevolutionData.show_all_diseases
    elseif msg == "static" then
        RunevolutionData.static = not RunevolutionData.static
    elseif msg == "dh" then
        -- calculate avoidance that would be same as this much added health
        -- da = (dh (1 - a ))/(dh + h)
        local dh = tonumber( param )
        local h = UnitHealth("player")
    elseif msg == "mode" then
        if RunevolutionCoordinates[ param ] then
            RunevolutionData.coordset = tostring(param)
        else
            reprint("Available rune animation modes:")
            for k,v in pairs(RunevolutionCoordinates) do
                reprint("  "..k)
            end
            reprint("  custom")
            reprint("Type '/runev mode modename' to set.")
            reprint("Current mode is "..tostring(RunevolutionData.coordset)..".")
        end
    elseif msg=="config" then
        -- toggle drag anchors
        RunevolutionConfigMode = not RunevolutionConfigMode
    elseif msg=="textures" then
        -- change texture set
        if RunevolutionRuneTextures[ tostring(param) ] then
            RunevolutionData.runetextures = tostring(param)
        else
            reprint("Available rune textures:")
            for k,v in pairs(RunevolutionRuneTextures) do
                reprint(k)
            end
            reprint("Type '/runev textures name' to set.")
            reprint("Current texture set is "..tostring(RunevolutionData.runetextures)..".")
        end
    else
        -- print help
        reprint("Runevolution "..Runevolution_version.." commands: (current values)")
        reprint("    /runev config : toggle configuration mode")
        reprint("    /runev x # : adjust x position ("..RunevolutionData.loc["x"]..")" )
        reprint("    /runev y # : adjust y position ("..RunevolutionData.loc["y"]..")" )
        reprint("    /runev cooldown # : cooldown length in rune widths ("..RunevolutionData.cooldowndistance..")" )
        reprint("    /runev size # : pixel size of runes ("..RunevolutionData.runesize..")" )
        reprint("    /runev showooc : toggle out-of-combat visibility of runes ("..tostring(RunevolutionData.show_ooc)..")" )
        reprint("    /runev showrp : toggle visibility of runic power ("..tostring(RunevolutionData.show_rp)..")" )
        reprint("    /runev showback : toggle rune backgrounds ("..tostring(RunevolutionData.show_back)..")" )
        reprint("    /runev fixrp : toggle fixed/floating runic power ("..tostring(RunevolutionData.fix_rp)..")" )
        reprint("    /runev diseases : toggle showing diseases on target ("..tostring(RunevolutionData.show_diseases)..")" )
        reprint("    /runev diseasepos : toggle position of diseases, up or down ("..tostring(RunevolutionData.diseases_up)..")" )
        reprint("    /runev alldiseases : show diseases cast by others ("..tostring(RunevolutionData.show_all_diseases)..")" )
        reprint("    /runev static : toggle static mode ("..tostring(RunevolutionData.static)..")" )
        reprint("    /runev reset : reset the order of runes")
        reprint("    /runev order #,#,#,#,#,# : set order of runes; 1=far left, 6=far right")
        reprint("    /runev hidebliz : hide the default built-in rune frame")
        reprint("    /runev mode : set rune animation mode ("..tostring(RunevolutionData.coordset)..")")
        reprint("    /runev textures : set rune textures ("..tostring(RunevolutionData.runetextures)..")")
    end

end

function reprint(x)
    if x then DEFAULT_CHAT_FRAME:AddMessage("|cffffff00"..x) end
end

function Runevolution_RUNE_POWER_UPDATE( runenum , ready )
    --reprint( event.." : "..tostring(params[1]).." / "..tostring(params[2]) )
    
    --local params = { select(1,...) }
    --local runenum = params[1]
    --local ready = params[2]
    
    if runenum < 7 then
        if ready then
            -- a real rune that just became ready
            
            if not RunevolutionData.static then
                -- drift mode
                
                if RunevolutionCoordinates[ RunevolutionData.coordset ][ "shiftready" ] == -1 then
                    -- move all currently ready runes LEFT one place
                    for i = 1,6 do
                        if RunevolutionXOffset[i] < 0 then
                            RunevolutionXOffset[i] = RunevolutionXOffset[i] - 1
                        end
                    end
                elseif RunevolutionCoordinates[ RunevolutionData.coordset ][ "shiftready" ] == 1 then
                    -- move all currently ready runes RIGHT one place
                    for i = 1,6 do
                        if RunevolutionXOffset[i] < 0 then
                            RunevolutionXOffset[i] = RunevolutionXOffset[i] + 1
                        end
                    end
                end
                
                if type(RunevolutionCoordinates[ RunevolutionData.coordset ][ "newready" ]) == "number" then
                    -- absolute position
                    RunevolutionXOffset[ runenum ] = RunevolutionCoordinates[ RunevolutionData.coordset ][ "newready" ]
                    RunevolutionYOffset[ runenum ] = 0 -- be sure to reset any vertical stagger
                elseif RunevolutionCoordinates[ RunevolutionData.coordset ][ "newready" ] == "right" then
                    -- find first open rune spot and place it there
                    local firstopen = min( RunevolutionXOffset[1] , RunevolutionXOffset[2] , RunevolutionXOffset[3] , RunevolutionXOffset[4] , RunevolutionXOffset[5] , RunevolutionXOffset[6] ) - 1
                    if firstopen < -6 then firstopen = -6 end
                    RunevolutionXOffset[ runenum ] = firstopen
                    RunevolutionYOffset[ runenum ] = 0 -- be sure to reset any vertical stagger
                end
                
            else
                -- static mode, leave in place
            end
            RunevolutionPulseList[ runenum ] = RunevolutionPulseDuration -- pulse it
        else
            -- a rune just got used
            local t = RunevolutionXOffset[ runenum ]
            -- position rune to far right
            
            if not RunevolutionData.static then
                RunevolutionXOffset[ runenum ] = RunevolutionData.cooldowndistance -- start cooldown
            else
                -- static mode
                -- move used rune to right end of six runes
                -- shift others left one place, if were to right of rune we just used
                for i = 1,6 do
                    if RunevolutionXOffset[i] > RunevolutionXOffset[ runenum ] then
                        RunevolutionXOffset[i] = RunevolutionXOffset[i] - 1
                    end
                end
                RunevolutionXOffset[ runenum ] = -1 -- far right position
            end
            
            -- check for another rune near that same cooldown position
            -- if so, stagger the runes vertically
            for i = 1,6 do
                if i ~= runenum and abs(RunevolutionXOffset[ i ] - RunevolutionXOffset[ runenum ]) < 1/2 then
                    RunevolutionYOffset[ runenum ] = -0.3
                    RunevolutionYOffset[ i ] = 0.3
                end
            end
            
            if not RunevolutionData.static then
                -- move all ready runes that were left of this one to the right one place
                for i = 1,6 do
                    if RunevolutionXOffset[i] < t then
                        RunevolutionXOffset[i] = RunevolutionXOffset[i] + 1
                    end
                end
            end
            
        end
        
        Runevolution_UpdateRuneTypes()
        Runevolution_UpdateRunePositions()
        
    end
end

-- event handler
RunevolutionRuneUpdateQueue = {}
function Runevolution_OnEvent(self,event,...)

    local params = { select(1,...) }

    if event == "RUNE_POWER_UPDATE" then
        
        table.insert( RunevolutionRuneUpdateQueue , {params[1],params[2]} )
        --Runevolution_RUNE_POWER_UPDATE(...)
        
    elseif event=="RUNE_TYPE_UPDATE" then
    
        Runevolution_UpdateRuneTypes()
    
    elseif event == "PLAYER_ENTERING_WORLD" then

        -- nothing here yet
        --reprint("PLAYER_ENTERING_WORLD")
        
        Runevolution_UpdateRuneTypes()
        
        -- confirm that disease icons are loaded
        for k,v in pairs( RunevolutionDiseaseList ) do
            local name, rank, icon, cost, isFunnel, powerType, castTime, minRange, maxRange 
= GetSpellInfo( v.id or k )
            if v.icon then
                icon = "Interface\\Icons\\"..v.icon
            end
            RunevolutionTextures[k]:SetTexture( icon )
            RunevolutionPulseList[ k ] = 0
            RunevolutionXOffset[ k ] = 0 -- init cooldown/disease positions
        end
        
        if RunevolutionData.hide_bliz then
            RuneFrame:Hide()
        else
            RuneFrame:Show()
        end
        
        Runevolution_AttemptReset() -- fix for mussed runes after death
        
    elseif event == "UNIT_SPELLCAST_SUCCEEDED" then
    
        -- kluge for Howling Blast timing
        local unitID,spellName,spellRank = select(1,...)
    	if ( unitID == "player" and spellName == "Howling Blast" ) then
            -- start cooldown timer
            RunevolutionHBtimer = 5 -- 5 seconds until it's ready again
    	end
        
    elseif event == "VARIABLES_LOADED" then
                
        -- initialize
        --reprint("VARIABLES_LOADED")
        
        if RunevolutionData.REversion == "v1.0.0" then
            -- add new prefs for v1.0.1
            RunevolutionData.show_ooc = true
            RunevolutionData.REversion = "v1.0.1"
        end
        
        if RunevolutionData.REversion == "v1.0.1" then
            -- add new prefs for v1.0.2
            RunevolutionData.show_rp = true
            RunevolutionData.REversion = "v1.0.2"
        end
        
        if RunevolutionData.REversion == "v1.0.2" or RunevolutionData.REversion == "v1.0.3" then
            -- add new prefs for v1.0.4
            RunevolutionData.show_back = true
            RunevolutionData.fix_rp = false
            RunevolutionData.REversion = "v1.0.4"
        end
        
        if RunevolutionData.REversion == "v1.0.4" then
            -- add new prefs for v1.0.5
            RunevolutionData.show_diseases = false
            RunevolutionData.REversion = "v1.0.5"
        end
        
        if RunevolutionData.REversion == "v1.0.5" then
            -- add new prefs for v1.0.6
            RunevolutionData.diseases_up = false
            RunevolutionData.REversion = "v1.0.6"
        end
        
        if RunevolutionData.REversion == "v1.0.6" then
            -- add new prefs for v1.0.7
            RunevolutionData.hide_bliz = false
            RunevolutionData.show_all_diseases = false
            RunevolutionData.REversion = "v1.0.7"
        end
        
        if RunevolutionData.REversion == "v1.0.7" then
            -- add new prefs for v1.0.8
            RunevolutionData.static = false
            RunevolutionData.REversion = "v1.0.8"
        end
        
        if not RunevolutionData.coordset then
            RunevolutionData.coordset = "standard"
            RunevolutionData.REversion = "v1.2.0"
        end
        
        if RunevolutionData.REversion == "v1.0.8" then
            RunevolutionData.coordset = "standard"
            RunevolutionData.REversion = "v1.2.0"
        end
        
        if RunevolutionData.REversion == "v1.2.0" then
            RunevolutionData.runetextures = "default"
            RunevolutionData.REversion = "v1.3.0"
        end 
        
        local fPopCustom = false
        if not RunevolutionData.custommode then 
            fPopCustom = true
        elseif not RunevolutionData.custommode[ "Blood Plague" ] then
            fPopCustom = true
        end
        if fPopCustom then
            -- populate custom animation mode with standard layout
            RunevolutionData.custommode = {
                [-6] = {-6,0},
                [-5] = {-5,0},
                [-4] = {-4,0},
                [-3] = {-3,0},
                [-2] = {-2,0},
                [-1] = {-1,0},
                [0] = {0,0},
                [1] = {1,0},
                [2] = {2,0},
                [3] = {3,0},
                [4] = {4,0},
                [5] = {5,0},
                [6] = {6,0},
                [7] = {7,0},
                [8] = {8,0},
                [9] = {9,0},
                [10] = {10,0},
                ["offsetaxis"] = {0,1},
                ["offsetcoords"] = { {0.4,-0.4} , {0,0.8,-0.8} },
                ["rpoffset"] = {-1,0},
                ["rpfix"] = {0,1},
                ["newready"] = -1, 
                ["shiftready"] = -1 
            }
        end
        for k,v in pairs( RunevolutionDiseaseList ) do
            if not RunevolutionData.custommode[ k ] then
                RunevolutionData.custommode[ k ] = {v.pos,1,"top"}
            end
        end
        
        -- check cooldown entries in prefs
        if not RunevolutionData.cooldownshidden then
            RunevolutionData.cooldownshidden = {}
            for k,v in pairs( RunevolutionDiseaseList ) do
                if not RunevolutionData.cooldownshidden[k] then
                    RunevolutionData.cooldownshidden[k] = v.defaultvisibility
                end
            end
        end
        
        -- make sure location is in correct format
        if not RunevolutionData.loc["a1"] then
            RunevolutionData.loc = { ["a1"]="CENTER" , ["a2"]="CENTER" , ["x"]=0 , ["y"]=0 }
        end
        
        -- make sure custom layout is copied to coordinate table
        RunevolutionCoordinates["custom"] = RunevolutionData.custommode
        
        Runevolution_CreateFrames()
        
    end

end


-- make the frames from stored settings
RunevolutionFrameMark = nil
RunevolutionFrameMarkTexture = nil
RunevolutionParentContainer = nil
RunevolutionFrameRP = nil
RunevolutionFrameRPText = nil
function Runevolution_CreateFrames()

    -- get object for parent frame
    RunevolutionParentContainer = CreateFrame("Frame" , "RunevolutionFrameContainer" , UIParent )
    RunevolutionParentContainer:SetFrameStrata("HIGH")
    RunevolutionParentContainer:SetWidth( 25 )
    RunevolutionParentContainer:SetHeight( 25 )
    --RunevolutionParentContainer:SetPoint( "CENTER" , RunevolutionData.loc["x"] , RunevolutionData.loc["y"] )
    RunevolutionParentContainer:SetPoint( RunevolutionData.loc["a1"] , RunevolutionData.loc["f"] , RunevolutionData.loc["a2"] , RunevolutionData.loc["x"] , RunevolutionData.loc["y"] )
    RunevolutionParentContainer:Show()
    RunevolutionParentContainer.texture = RunevolutionParentContainer:CreateTexture(nil,"BACKGROUND")
    RunevolutionParentContainer.texture:SetBlendMode( "BLEND" )
    RunevolutionParentContainer.texture:SetAllPoints( RunevolutionParentContainer )
    RunevolutionParentContainer.texture:SetTexture("Interface\\Buttons\\WHITE8X8")
    RunevolutionParentContainer.texture:SetVertexColor(1,0,0,0)

    -- make a frame and texture for each rune
    for i = 1,6 do
        -- parent frame
        RunevolutionFrames[i] = CreateFrame("Frame" , "RunevolutionFrame"..i , RunevolutionParentContainer )
        RunevolutionFrames[i]:SetFrameStrata("LOW")
        -- texture
        RunevolutionTextures[i] = RunevolutionFrames[i]:CreateTexture(nil,"BACKGROUND")
        --RunevolutionTextures[i]:SetBlendMode( "ADD" )
        RunevolutionTextures[i]:SetBlendMode( "BLEND" )
        RunevolutionTextures[i]:SetAllPoints( RunevolutionFrames[i] )
        
        RunevolutionFrames[i]:SetWidth( RunevolutionData.runesize )
        RunevolutionFrames[i]:SetHeight( RunevolutionData.runesize )
        
        RunevolutionFrames[i]:SetPoint( "CENTER" , RunevolutionXOffset[i]*RunevolutionData.runesize , 0 )
        RunevolutionFrames[i]:Show()
        
        -- text
        RunevolutionFrames[i].text = RunevolutionFrames[i]:CreateFontString( "RunevolutionFrameRuneString"..i )
        RunevolutionFrames[i].text:SetFont("Fonts\\ZYKai_T.TTF", RunevolutionData.runesize/1.5 , "OUTLINE")
        RunevolutionFrames[i].text:SetPoint("CENTER" , RunevolutionFrames[i] , "CENTER" , 0 , 0)
        RunevolutionFrames[i].text:SetText( "|cFFFFFFFF10" )
        RunevolutionFrames[i].text:Hide() -- hide until rune is on cooldown
        
        -- custom layout anchor
        RunevolutionFrames["anchor-"..i] = CreateFrame("Frame" , "RunevolutionAnchor-"..i , RunevolutionParentContainer )
        RunevolutionFrames["anchor-"..i]:SetFrameStrata("HIGH")
        RunevolutionFrames["anchor-"..i].texture = RunevolutionFrames["anchor-"..i]:CreateTexture(nil,"BACKGROUND")
        RunevolutionFrames["anchor-"..i].texture:SetTexture("Interface\\BUTTONS\\CheckButtonHilight.blp")
        RunevolutionFrames["anchor-"..i].texture:SetBlendMode( "ADD" )
        RunevolutionFrames["anchor-"..i].texture:SetAllPoints( RunevolutionFrames["anchor-"..i] )
        RunevolutionFrames["anchor-"..i]:SetWidth( RunevolutionData.runesize )
        RunevolutionFrames["anchor-"..i]:SetHeight( RunevolutionData.runesize )
        RunevolutionFrames["anchor-"..i]:SetPoint( "CENTER" , RunevolutionFrames[i] , "CENTER" , 0 , 0 )
        RunevolutionFrames["anchor-"..i]:Hide()
        local xy = RunevolutionData.custommode[-i]
        RunevolutionFrames["anchor-"..i]:ClearAllPoints()
        RunevolutionFrames["anchor-"..i]:SetPoint( "CENTER" , xy[1]*RunevolutionData.runesize , xy[2]*RunevolutionData.runesize )
        RunevolutionFrames["anchor-"..i].runeindex = -i -- need this number later for updating custom layout
        -- text
        RunevolutionFrames["anchor-"..i].text = RunevolutionFrames["anchor-"..i]:CreateFontString( "RunevolutionFrameRuneAnchorString-"..i )
        RunevolutionFrames["anchor-"..i].text:SetFont("Fonts\\ZYKai_T.TTF", RunevolutionData.runesize/2 , "OUTLINE")
        RunevolutionFrames["anchor-"..i].text:SetPoint("CENTER" , RunevolutionFrames["anchor-"..i] , "CENTER" , 0 , 0)
        RunevolutionFrames["anchor-"..i].text:SetText( "|cFFFFFFFFR"..i )
        RunevolutionFrames["anchor-"..i].text:Show()
        RunevolutionFrames["anchor-"..i].helptext = "Ready rune "..i
    end
    
    -- make cooldown path anchors
    for i = 1,10 do
        -- custom layout anchor
        RunevolutionFrames["anchor"..i] = CreateFrame("Frame" , "RunevolutionAnchor"..i , RunevolutionParentContainer )
        RunevolutionFrames["anchor"..i]:SetFrameStrata("HIGH")
        RunevolutionFrames["anchor"..i].texture = RunevolutionFrames["anchor"..i]:CreateTexture(nil,"BACKGROUND")
        RunevolutionFrames["anchor"..i].texture:SetTexture("Interface\\BUTTONS\\CheckButtonHilight.blp")
        RunevolutionFrames["anchor"..i].texture:SetBlendMode( "ADD" )
        RunevolutionFrames["anchor"..i].texture:SetAllPoints( RunevolutionFrames["anchor"..i] )
        RunevolutionFrames["anchor"..i]:SetWidth( RunevolutionData.runesize )
        RunevolutionFrames["anchor"..i]:SetHeight( RunevolutionData.runesize )
        RunevolutionFrames["anchor"..i]:SetPoint( "CENTER" , RunevolutionFrames[i] , "CENTER" , 0 , 0 )
        RunevolutionFrames["anchor"..i]:Hide()
        local xy = RunevolutionData.custommode[i]
        RunevolutionFrames["anchor"..i]:ClearAllPoints()
        RunevolutionFrames["anchor"..i]:SetPoint( "CENTER" , xy[1]*RunevolutionData.runesize , xy[2]*RunevolutionData.runesize )
        RunevolutionFrames["anchor"..i].runeindex = i -- need this number later for updating custom layout
        -- text
        RunevolutionFrames["anchor"..i].text = RunevolutionFrames["anchor"..i]:CreateFontString( "RunevolutionFrameRuneAnchorString"..i )
        RunevolutionFrames["anchor"..i].text:SetFont("Fonts\\ZYKai_T.TTF", RunevolutionData.runesize/2.5 , "OUTLINE")
        RunevolutionFrames["anchor"..i].text:SetPoint("CENTER" , RunevolutionFrames["anchor"..i] , "CENTER" , 0 , 0)
        RunevolutionFrames["anchor"..i].text:SetText( "|cFFFFFFFF"..i )
        RunevolutionFrames["anchor"..i].text:Show()
        RunevolutionFrames["anchor"..i].helptext = "Cooldown path markers"
    end
    
    -- runic power fixed position anchor
        local i = "rpfix"
        RunevolutionFrames["anchor"..i] = CreateFrame("Frame" , "RunevolutionAnchor"..i , RunevolutionParentContainer )
        RunevolutionFrames["anchor"..i]:SetFrameStrata("HIGH")
        RunevolutionFrames["anchor"..i].texture = RunevolutionFrames["anchor"..i]:CreateTexture(nil,"BACKGROUND")
        RunevolutionFrames["anchor"..i].texture:SetTexture("Interface\\BUTTONS\\CheckButtonHilight.blp")
        RunevolutionFrames["anchor"..i].texture:SetBlendMode( "ADD" )
        RunevolutionFrames["anchor"..i].texture:SetAllPoints( RunevolutionFrames["anchor"..i] )
        RunevolutionFrames["anchor"..i]:SetWidth( RunevolutionData.runesize )
        RunevolutionFrames["anchor"..i]:SetHeight( RunevolutionData.runesize )
        RunevolutionFrames["anchor"..i]:SetPoint( "CENTER" , RunevolutionFrames[i] , "CENTER" , 0 , 0 )
        RunevolutionFrames["anchor"..i]:Hide()
        local xy = RunevolutionData.custommode[i]
        RunevolutionFrames["anchor"..i]:ClearAllPoints()
        RunevolutionFrames["anchor"..i]:SetPoint( "CENTER" , xy[1]*RunevolutionData.runesize , xy[2]*RunevolutionData.runesize )
        RunevolutionFrames["anchor"..i].runeindex = i -- need this number later for updating custom layout
        -- text
        RunevolutionFrames["anchor"..i].text = RunevolutionFrames["anchor"..i]:CreateFontString( "RunevolutionFrameRuneAnchorString"..i )
        RunevolutionFrames["anchor"..i].text:SetFont("Fonts\\ZYKai_T.TTF", RunevolutionData.runesize/2.5 , "OUTLINE")
        RunevolutionFrames["anchor"..i].text:SetPoint("CENTER" , RunevolutionFrames["anchor"..i] , "CENTER" , 0 , 0)
        RunevolutionFrames["anchor"..i].text:SetText( "|cFFFFFFFF"..i )
        RunevolutionFrames["anchor"..i].text:Show()
        RunevolutionFrames["anchor"..i].helptext = "Runic power"
        
    -- offset axis anchor
        local i = "offsetaxis"
        RunevolutionFrames["anchor"..i] = CreateFrame("Frame" , "RunevolutionAnchor"..i , RunevolutionParentContainer )
        RunevolutionFrames["anchor"..i]:SetFrameStrata("HIGH")
        RunevolutionFrames["anchor"..i].texture = RunevolutionFrames["anchor"..i]:CreateTexture(nil,"BACKGROUND")
        RunevolutionFrames["anchor"..i].texture:SetTexture("Interface\\BUTTONS\\CheckButtonHilight.blp")
        RunevolutionFrames["anchor"..i].texture:SetBlendMode( "ADD" )
        RunevolutionFrames["anchor"..i].texture:SetAllPoints( RunevolutionFrames["anchor"..i] )
        RunevolutionFrames["anchor"..i]:SetWidth( RunevolutionData.runesize )
        RunevolutionFrames["anchor"..i]:SetHeight( RunevolutionData.runesize )
        RunevolutionFrames["anchor"..i]:SetPoint( "CENTER" , RunevolutionFrames[i] , "CENTER" , 0 , 0 )
        RunevolutionFrames["anchor"..i]:Hide()
        local xy = RunevolutionData.custommode[i]
        RunevolutionFrames["anchor"..i]:ClearAllPoints()
        RunevolutionFrames["anchor"..i]:SetPoint( "CENTER" , xy[1]*RunevolutionData.runesize , xy[2]*RunevolutionData.runesize )
        RunevolutionFrames["anchor"..i].runeindex = i -- need this number later for updating custom layout
        -- text
        RunevolutionFrames["anchor"..i].text = RunevolutionFrames["anchor"..i]:CreateFontString( "RunevolutionFrameRuneAnchorString"..i )
        RunevolutionFrames["anchor"..i].text:SetFont("Fonts\\ZYKai_T.TTF", RunevolutionData.runesize/2.5 , "OUTLINE")
        RunevolutionFrames["anchor"..i].text:SetPoint("CENTER" , RunevolutionFrames["anchor"..i] , "CENTER" , 0 , 0)
        RunevolutionFrames["anchor"..i].text:SetText( "|cFFFFFFFF".."axis" )
        RunevolutionFrames["anchor"..i].text:Show()
        RunevolutionFrames["anchor"..i].helptext = "The axis along which close cooling runes are spread apart"
    
    -- make background shadows
    for i = 7,12 do
        -- parent frame
        RunevolutionFrames[i] = CreateFrame("Frame" , "RunevolutionFrame"..i , RunevolutionFrames[i-6] )
        RunevolutionFrames[i]:SetFrameStrata( "BACKGROUND" )
        -- texture
        RunevolutionTextures[i] = RunevolutionFrames[i]:CreateTexture(nil,"BACKGROUND")
        RunevolutionTextures[i]:SetBlendMode( "BLEND" )
        RunevolutionTextures[i]:SetAllPoints( RunevolutionFrames[i] )
        --RunevolutionTextures[i]:SetVertexColor( 1 , 0 , 0 )
        
        RunevolutionFrames[i]:SetWidth( RunevolutionData.runesize )
        RunevolutionFrames[i]:SetHeight( RunevolutionData.runesize )
        
        RunevolutionFrames[i]:SetPoint( "CENTER" , RunevolutionFrames[i-6] , "CENTER" , 0 , 0 )
        RunevolutionFrames[i]:Show()
        if not RunevolutionData.show_back then
            RunevolutionFrames[i]:Hide()
        end
    end
    
    -- make disease trackers
    for k,v in pairs( RunevolutionDiseaseList ) do
        Runevolution_CreateCooldownIcon( k )
    end
    
    -- make help window
    RunevolutionFrames["help"] = CreateFrame("Frame","RunevolutionFrameHelp" , RunevolutionParentContainer )
    RunevolutionFrames["help"]:SetFrameStrata("LOW")
    RunevolutionFrames["help"].texture = RunevolutionFrames["help"]:CreateTexture(nil,"BACKGROUND")
    RunevolutionFrames["help"].texture:SetBlendMode( "BLEND" )
    RunevolutionFrames["help"].texture:SetAllPoints( RunevolutionFrames["help"] )
    RunevolutionFrames["help"]:SetWidth( 400 )
    RunevolutionFrames["help"]:SetHeight( 32 * 2 )
    RunevolutionFrames["help"]:SetPoint( "CENTER" , 0 , 6*32 )
    RunevolutionFrames["help"].texture:SetTexture( 0 , 0 , 0 , .75 )
    RunevolutionFrames["help"]:Hide()
    -- text
        RunevolutionFrames["help"].text = RunevolutionFrames["help"]:CreateFontString( "RunevolutionFrameRuneAnchorString"..i )
        RunevolutionFrames["help"].text:SetFont("Fonts\\ZYKai_T.TTF", 24/2 , "OUTLINE")
        RunevolutionFrames["help"].text:SetPoint("CENTER" , RunevolutionFrames["help"] , "CENTER" , 0 , 0)
        RunevolutionFrames["help"].text:SetText( "|cFFFFFFCC".."Drag anchors to arrange. Shift-drag disables snap to grid." )
        RunevolutionFrames["help"].text:Show()
    
    -- make end-of-cooldown marker
    RunevolutionFrameMark = CreateFrame("Frame","RunevolutionFrameMark" , RunevolutionParentContainer )
    RunevolutionFrameMark:SetFrameStrata("LOW")
    RunevolutionFrameMarkTexture = RunevolutionFrameMark:CreateTexture(nil,"BACKGROUND")
    RunevolutionFrameMarkTexture:SetBlendMode( "BLEND" )
    RunevolutionFrameMarkTexture:SetAllPoints( RunevolutionFrameMark )
    RunevolutionFrameMark:SetWidth( 4 )
    RunevolutionFrameMark:SetHeight( RunevolutionData.runesize )
    RunevolutionFrameMark:SetPoint( "CENTER" , 0 - RunevolutionData.runesize/2 , 0 )
    RunevolutionFrameMarkTexture:SetTexture( 1 , 1 , 1 , .75 )
    RunevolutionFrameMark:Hide()
    
    -- make runic power indicator
    RunevolutionFrameRP = CreateFrame("Frame","RunevolutionFrameRP" , RunevolutionParentContainer )
    RunevolutionFrameRP:SetFrameStrata("LOW")
    RunevolutionFrameRP:SetWidth( 4 )
    RunevolutionFrameRP:SetHeight( 4 )
    RunevolutionFrameRP:SetPoint( "CENTER" , 0 , 0 )
    RunevolutionFrameRP:Show()
    
    RunevolutionFrameRPText = RunevolutionFrameRP:CreateFontString( "RunevolutionFrameRPString" )
	--RunevolutionFrameRPText:SetFontObject("GameFontNormal")
	RunevolutionFrameRPText:SetFont("Fonts\\ZYKai_T.TTF", RunevolutionData.runesize/1.5 , "OUTLINE")
	RunevolutionFrameRPText:SetPoint("CENTER" , RunevolutionFrameRP , "CENTER" , -7*RunevolutionData.runesize , 0)
	RunevolutionFrameRPText:SetText( "|cFF00B8F5100" )
	
	--[[ kluge for timing Howling Blast
	RunevolutionXOffset[ "Howling Blast" ] = 1
	RunevolutionYOffset[ "Howling Blast" ] = 1
	Runevolution_CreateCooldownIcon( "Howling Blast" )
	RunevolutionFrames["Howling Blast"]:ClearAllPoints()
	RunevolutionFrames["Howling Blast"]:SetPoint( "CENTER" , RunevolutionData.loc["x"] + RunevolutionXOffset["Howling Blast"]*RunevolutionData.runesize , RunevolutionData.loc["y"] + RunevolutionYOffset["Howling Blast"]*RunevolutionData.runesize )
	RunevolutionFrames["Howling Blast"].text:ClearAllPoints()
	RunevolutionFrames["Howling Blast"].text:SetPoint("BOTTOM" , RunevolutionFrames["Howling Blast"] , "TOP" , 0 , 0) ]]--
    
    -- set initial textures
    Runevolution_UpdateRuneTypes()
    Runevolution_UpdateRunePositions()
    

end

function Runevolution_CreateCooldownIcon( cooldownname )

    local iconsizefactor = 0.8 -- shrink the blizz icons a bit
    RunevolutionFrames[cooldownname] = CreateFrame("Frame" , "RunevolutionFrameCooldown"..cooldownname , RunevolutionParentContainer )
    RunevolutionFrames[cooldownname]:SetFrameStrata( "BACKGROUND" )
    RunevolutionTextures[cooldownname] = RunevolutionFrames[cooldownname]:CreateTexture(nil,"BACKGROUND")
    RunevolutionTextures[cooldownname]:SetBlendMode( "BLEND" )
    RunevolutionTextures[cooldownname]:SetAllPoints( RunevolutionFrames[cooldownname] )
    --local name, rank, icon, cost, isFunnel, powerType, castTime, minRange, maxRange = GetSpellInfo( cooldownname )
    local name, rank, icon, cost, isFunnel, powerType, castTime, minRange, maxRange = GetSpellInfo( RunevolutionDiseaseList[cooldownname].id or cooldownname )
    RunevolutionTextures[cooldownname]:SetTexture( icon )
    RunevolutionFrames[cooldownname]:SetWidth( RunevolutionData.runesize * iconsizefactor )
    RunevolutionFrames[cooldownname]:SetHeight( RunevolutionData.runesize * iconsizefactor )
    RunevolutionFrames[cooldownname]:SetPoint( "CENTER" , 0 + RunevolutionXOffset[cooldownname]*RunevolutionData.runesize , 0 )
    RunevolutionFrames[cooldownname]:Hide()
    
    RunevolutionFrames[cooldownname].text = RunevolutionFrames[cooldownname]:CreateFontString( "RunevolutionFrameString"..cooldownname )
	--RunevolutionFrameRPText:SetFontObject("GameFontNormal")
	RunevolutionFrames[cooldownname].text:SetFont("Fonts\\ZYKai_T.TTF", RunevolutionData.runesize/2 , "OUTLINE")
	RunevolutionFrames[cooldownname].text:SetPoint("TOP" , RunevolutionFrames[cooldownname] , "BOTTOM" , 0 , 0)
	RunevolutionFrames[cooldownname].text:SetText( "|cFFFFFFFF11s" )
	
	-- disease custom placement anchor
    local i = cooldownname
    RunevolutionFrames["anchor"..i] = CreateFrame("Frame" , "RunevolutionAnchor"..i , RunevolutionParentContainer )
    RunevolutionFrames["anchor"..i]:SetFrameStrata("HIGH")
    RunevolutionFrames["anchor"..i].texture = RunevolutionFrames["anchor"..i]:CreateTexture(nil,"BACKGROUND")
    RunevolutionFrames["anchor"..i].texture:SetTexture("Interface\\BUTTONS\\CheckButtonHilight.blp")
    RunevolutionFrames["anchor"..i].texture:SetBlendMode( "ADD" )
    RunevolutionFrames["anchor"..i].texture:SetAllPoints( RunevolutionFrames["anchor"..i] )
    RunevolutionFrames["anchor"..i]:SetWidth( RunevolutionData.runesize )
    RunevolutionFrames["anchor"..i]:SetHeight( RunevolutionData.runesize )
    RunevolutionFrames["anchor"..i]:SetPoint( "CENTER" , RunevolutionFrames[i] , "CENTER" , 0 , 0 )
    RunevolutionFrames["anchor"..i]:Hide()
    local xy = RunevolutionData.custommode[i]
    if not xy then
        xy = {-4,1,"top"}
    end
    RunevolutionFrames["anchor"..i]:ClearAllPoints()
    RunevolutionFrames["anchor"..i]:SetPoint( "CENTER" , xy[1]*RunevolutionData.runesize , xy[2]*RunevolutionData.runesize )
    RunevolutionFrames["anchor"..i].runeindex = i -- need this number later for updating custom layout
    -- text
    RunevolutionFrames["anchor"..i].text = RunevolutionFrames["anchor"..i]:CreateFontString( "RunevolutionFrameRuneAnchorString"..i )
    RunevolutionFrames["anchor"..i].text:SetFont("Fonts\\ZYKai_T.TTF", RunevolutionData.runesize/2.5 , "OUTLINE")
    RunevolutionFrames["anchor"..i].text:SetPoint("CENTER" , RunevolutionFrames["anchor"..i] , "CENTER" , 0 , 0)
    RunevolutionFrames["anchor"..i].text:SetText( "|cFFFFFFFF".." " )
    RunevolutionFrames["anchor"..i].text:Show()
    RunevolutionFrames["anchor"..i].helptext = i.."\nRight-click to rotate timer. Shift-right-click to show/hide."
    
end


function Runevolution_UpdateRuneTypes()
    -- sets rune types
    for i = 1,6 do
        --local rtype = GetRuneType( i )
		
        local _,_,ready = GetRuneCooldown( i ) 
        local texture = nil
        local textname = ""
        --if rtype == 1 then
         --   textname = "blood"
        --elseif rtype == 2 then
        --    textname = "unholy"
        --elseif rtype == 3 then
        --    textname = "frost"
        --elseif rtype == 4 then
            textname = "death"
        --end
        local backtexture = textname.."back"
        if not ready then
            textname = textname.."off"
        end
        texture = RunevolutionRuneTextures[ RunevolutionData.runetextures ][ textname ]
        RunevolutionTextures[i]:SetTexture( texture )
        RunevolutionTextures[i+6]:SetTexture( RunevolutionRuneTextures[ RunevolutionData.runetextures ][ backtexture ] )
    end
end

local x,y
local x1,y1,x2,y2
local up,down
function Runevolution_Offset2Coords(ox,oy)
    -- translates x and y offsets into screen coordinate offsets, using current animation mode
    --local x,y
    if RunevolutionCoordinates[RunevolutionData.coordset][ ox ] then
        -- exact x offset in set, so retrieve coordinates
        x = RunevolutionCoordinates[RunevolutionData.coordset][ ox ][1]
        y = RunevolutionCoordinates[RunevolutionData.coordset][ ox ][2]
    else
        -- no exact match, so get two closest coord pairs and interpolate position
        up = math.ceil( ox )
        down = math.floor( ox )
        
        if RunevolutionCoordinates[RunevolutionData.coordset][ up ] then
            x1 = RunevolutionCoordinates[RunevolutionData.coordset][ up ][1]
            y1 = RunevolutionCoordinates[RunevolutionData.coordset][ up ][2]
        else
            x1 = nil
            y1 = nil
        end
        if RunevolutionCoordinates[RunevolutionData.coordset][ down ] then
            x2 = RunevolutionCoordinates[RunevolutionData.coordset][ down ][1]
            y2 = RunevolutionCoordinates[RunevolutionData.coordset][ down ][2]
        else
            x2 = nil
            y2 = nil
        end
        if (x1 and x2) or (y1 and y2) then -- interpolate
            local dmax = abs( up - down )
            local d = abs( up - ox )
            local p = d / dmax -- proportion of distance from up offset
            if not y2 then y2 = y1 end
            if not x2 then x2 = x1 end
            if not y1 then y1 = y2 end
            if not x1 then x1 = x2 end
            x = p*x2 + (1-p)*x1 -- if on up offset, x = x1
            y = p*y2 + (1-p)*y1
        else
            -- at least one coordinate missing, so use the one we have by itself
            if x1 then
                x = x1
                y = y1
            else
                x = x2
                y = y2
            end
        end
    end
    if not x then x=0 end
    if not y then y=0 end
    
    -- check for y offset
    if oy ~= 0 then
        if not oy then oy = 0 end
        local offsetAxis = RunevolutionCoordinates[RunevolutionData.coordset]["offsetaxis"]
        x = x + offsetAxis[1] * oy
        y = y + offsetAxis[2] * oy
    end
    
    return x,y
end

local offsetAxis
function Runevolution_UpdateRunePositions()
    
    offsetAxis = RunevolutionCoordinates[RunevolutionData.coordset]["offsetaxis"]
    x = 0
    y = 0
    
    for i = 1,6 do
        Runevolution_StaggerNeighbors(i)
    end
    for i = 1,6 do
        
        x,y = Runevolution_Offset2Coords(RunevolutionXOffset[i],RunevolutionYOffset[i])
        
        RunevolutionFrames[i]:ClearAllPoints()
        RunevolutionFrames[i]:SetPoint( "CENTER" , 0 + x*RunevolutionData.runesize , 0 + y*RunevolutionData.runesize )
    end
    
end

--local closerunes = {}
local isclose = {false,false,false,false,false,false}
local numclose = 0
function Runevolution_StaggerNeighbors(i)
    -- sets Y offset so positioning function can later stagger runes by it
    
    --local closerunes = nil
    --closerunes = {}
    numclose = 0
    if RunevolutionXOffset[i] > 0 and RunevolutionYOffset[i] == 0 then
        for j=1,6 do
            if RunevolutionXOffset[j] > 0 and i ~= j then
                if abs( RunevolutionXOffset[i] - RunevolutionXOffset[j] ) < 1/3 then
                    --table.insert( closerunes , j )
                    numclose = numclose + 1
                    isclose[j] = true
                else
                    isclose[j] = false
                end
                isclose[i] = false
            end
        end
        if numclose > 0 then
            if numclose == 2 then
                -- 3 runes close to one another
                --reprint( i.."/"..closerunes[1].."/"..closerunes[2] )
                local offsetcoords = RunevolutionCoordinates[RunevolutionData.coordset]["offsetcoords"][2]
                
                RunevolutionYOffset[i] = offsetcoords[1]
                local count = 1
                for i,v in ipairs( isclose ) do
                    if v then
                        count = count + 1
                        RunevolutionYOffset[ i ] = offsetcoords[ count ]
                    end
                end
                --RunevolutionYOffset[ closerunes[1] ] = offsetcoords[2]
                --RunevolutionYOffset[ closerunes[2] ] = offsetcoords[3]
                
            elseif numclose == 1 then
                -- 2 runes close to one another
                local offsetcoords = RunevolutionCoordinates[RunevolutionData.coordset]["offsetcoords"][1]
                RunevolutionYOffset[i] = offsetcoords[1]
                for i,v in ipairs( isclose ) do
                    if v then
                        RunevolutionYOffset[ i ] = offsetcoords[ 2 ]
                    end
                end
                --RunevolutionYOffset[ closerunes[1] ] = offsetcoords[2]
                
            end
        end
    end

end


function Runevolution_AttemptReset()
    Runevolution_UpdateRuneTypes()
    local j = -1
    for i = 1,6 do
        local _,_,ready = GetRuneCooldown(i)
        if ready then
            RunevolutionXOffset[i] = j
            j = j - 1
        else
            RunevolutionXOffset[i] = RunevolutionData.cooldowndistance
        end
    end
    Runevolution_UpdateRunePositions()
end

function Runevolution_Sort( t )
    -- takes table t with rune indexes as keys and ready times as values
    -- returns new table with just indexes, in order of ready times
    local nt = nil
    nt = {}
    local n = 0
    for k,v in pairs( t ) do
        n = n + 1
        nt[k] = n
    end
    
    local fChange = true
    local temp
    while fChange do
        fChange = false
        for k,v in pairs( t ) do
            for kk,vv in pairs( t ) do
                if k ~= kk then
                    if v > vv then
                        if nt[k] > nt[kk] then
                            temp = nt[k]
                            nt[k] = nt[kk]
                            nt[kk] = temp
                            fChange = true
                        end
                    elseif v < vv then
                        if nt[k] < nt[kk] then
                            temp = nt[k]
                            nt[k] = nt[kk]
                            nt[kk] = temp
                            fChange = true
                        end
                    end
                end
            end
        end
    end -- while
    return nt
end

local RunevolutionRPPulsedFlag = false
local runevreadyrunes = {true,true,true,true,true,true}
RunevolutionTimer = 0
RunevolutionTimer2 = 0
local fJustUsed={}
RunevolutionFlagDead = false
function Runevolution_OnUpdate(self,elapsed)

    local _,engClass = UnitClass("player")
    if engClass ~= "DEATHKNIGHT" then
        return
    end

    --[[RunevolutionTimer = RunevolutionTimer + elapsed
    RunevolutionTimer2 = RunevolutionTimer2 + elapsed
    if RunevolutionTimer < 0.01 then
        return
    else
        RunevolutionTimer = 0
    end
    
    if RunevolutionTimer2 > 30 then
        --collectgarbage()
        RunevolutionTimer2 = 0
    end]]
    
    if UnitIsDeadOrGhost("player") then
        RunevolutionParentContainer:Hide()
        RunevolutionFlagDead = true
        return
    elseif RunevolutionFlagDead then
        RunevolutionFlagDead = false
        Runevolution_AttemptReset()
    end
    
    -- new rune updating engine, just uses continuous updating, ignoring events
    for i = 1,6 do
        fJustUsed[i] = false
        local _,_,ready = GetRuneCooldown(i)
        
        if ready then
            if RunevolutionYOffset[i] ~= 0 then
                RunevolutionYOffset[i] = 0
            end
            if runevreadyrunes[i] then
                -- rune i is ready and was ready last update
                -- do nothing
            else
                -- rune i is ready but was not ready last update
                -- give it a new x-offset
                local prevX = RunevolutionXOffset[i]
                RunevolutionXOffset[i] = -1 -- always in the most recent position
                -- clear any y-offset
                RunevolutionYOffset[i] = 0
                -- now shift others left
                if not RunevolutionData.static then
                    for j=1,6 do
                        if i~=j and RunevolutionXOffset[j] < 0 then
                            RunevolutionXOffset[j] = RunevolutionXOffset[j] - 1
                            RunevolutionYOffset[j] = 0 -- to be sure
                        end
                    end
                else
                    -- in static mode, have to care about previous position of rune that just came off cooldown and shift only those that were right of it
                    for j=1,6 do
                        if i~=j and RunevolutionXOffset[j] < 0 and RunevolutionXOffset[j] > prevX then
                            RunevolutionXOffset[j] = RunevolutionXOffset[j] - 1
                            RunevolutionYOffset[j] = 0
                        end
                    end
                end
                -- mark for pulse
                RunevolutionPulseList[ i ] = RunevolutionPulseDuration
                --RunevolutionPulseList[ i ] = 2.5
            end
        else -- cooling down
            if runevreadyrunes[i] then
                -- cooling but was ready last update
                -- mark it for cooling
                fJustUsed[i] = true
                local prevX = RunevolutionXOffset[i]
                if not RunevolutionData.static then
                    RunevolutionXOffset[i] = 10
                else
                    -- static mode so move to far left
                    RunevolutionXOffset[i] = -6
                end
                -- now squeeze together other ready runes
                for j = 1,6 do
                    if i~=j then
                        if runevreadyrunes[j] or RunevolutionData.static then
                            -- if ready rune was to left of just-used rune, shift right
                            if RunevolutionXOffset[j] < prevX then
                                RunevolutionXOffset[j] = RunevolutionXOffset[j] + 1
                                RunevolutionYOffset[j] = 0
                            end
                        end
                    end
                end
            end
        end
        
        -- update ready table
        runevreadyrunes[i] = ready
    end

    -- position cooling runes
    local fAnyReady = false
    local fAnyCooldown = false
    for i = 1,6 do
        if RunevolutionXOffset[i] > 0 or RunevolutionData.static then
            -- rune possibly on cooldown
            local start,duration,ready = GetRuneCooldown(i)
            if not ready then
            
                fAnyCooldown = true
                local remaining = max( duration - ( GetTime() - start ) , 0.01 )
                
                if fJustUsed[i] then
                    --print(remaining)
                end
                
                if not RunevolutionData.static then
                    -- drift
                    RunevolutionXOffset[i] = remaining/10 * RunevolutionData.cooldowndistance
                    
                else
                    -- static mode
                    local thetext = string.format( "%d" , remaining+1 )
                   --local rtype = GetRuneType( i )
                    local color = "FFFFFF"
                    --if rtype == 1 then
                        -- blood
                    --    color = "FF0000"
                    --elseif rtype == 2 then
                        -- unholy
                    --    color = "008000"
                    --elseif rtype == 3 then
                        -- frost
                    --    color = "00FFFF"
                    --elseif rtype == 4 then
                        -- death
                        color = "8CBAE0"
                    --end
                    RunevolutionFrames[i].text:SetText( "|cFF"..color..thetext )
                    RunevolutionFrames[i].text:Show()
                end
                
            else
                -- rune marked for cooldown, but somehow is ready now
                if not RunevolutionData.static then Runevolution_AttemptReset() end
                RunevolutionFrames[i].text:Hide()
                fAnyReady = true
            end
        else
            -- ready rune
            fAnyReady = true
        end
    end -- for i = 1,6
    
    
    
    -- redraw
    Runevolution_UpdateRunePositions()
    Runevolution_UpdateRuneTypes()
    
    
    
    -- hide/show end-of-cooldown marker bar
    if (fAnyReady or RunevolutionData.static or RunevolutionData.fix_rp) and not RunevolutionConfigMode then
        RunevolutionFrameMark:Hide()
    else
        RunevolutionFrameMark:Show()
    end
    
    
    
    -- pulse animation
    local anypulse = false
    for i = 1,6 do
        if RunevolutionPulseList[i] > 0 then
            anypulse = true
            RunevolutionPulseList[i] = RunevolutionPulseList[i] - elapsed
            if RunevolutionPulseList[i] < 0 then RunevolutionPulseList[i] = 0 end
            local zoom = 1 + RunevolutionPulseList[i]/RunevolutionPulseDuration * (RunevolutionPulseFactor - 1)
            --local zoom = 1 + RunevolutionPulseList[i]/2.5 * (RunevolutionPulseFactor - 1)
            RunevolutionFrames[i]:SetWidth( RunevolutionData.runesize * zoom )
            RunevolutionFrames[i]:SetHeight( RunevolutionData.runesize * zoom )
            
            RunevolutionFrames[i+6]:SetWidth( RunevolutionData.runesize * zoom )
            RunevolutionFrames[i+6]:SetHeight( RunevolutionData.runesize * zoom )
        end
    end
    if RunevolutionPulseList['rp'] > 0 then
        anypulse = true
        RunevolutionPulseList['rp'] = RunevolutionPulseList['rp'] - elapsed
        if RunevolutionPulseList['rp'] < 0 then 
            RunevolutionPulseList['rp'] = 0
        end
        local zoom = 1 + RunevolutionPulseList['rp']/RunevolutionPulseDuration * (RunevolutionPulseFactor - 1)
        RunevolutionFrameRPText:SetFont("Fonts\\ZYKai_T.TTF", zoom * RunevolutionData.runesize/1.5 , "OUTLINE")
    end
    
    
    
    if not RunevolutionData.show_rp then
        RunevolutionFrameRP:Hide()
    else
        -- update runic power
        local rp = UnitPower("player")
        if rp < UnitPowerMax("player") then
            RunevolutionFrameRPText:SetText( "|cFF00B8F5"..rp )
            RunevolutionRPPulsedFlag = false
        else
            RunevolutionFrameRPText:SetText( "|cFFDD55FF"..rp ) -- purple at max runic power
            -- check for pulse animation
            if RunevolutionPulseList['rp'] == 0 and not RunevolutionRPPulsedFlag then
                -- animation not running, so start it
                RunevolutionPulseList['rp'] = RunevolutionPulseDuration
                RunevolutionRPPulsedFlag = true
            end
        end
        RunevolutionFrameRPText:ClearAllPoints()
        local maxleft = -6
        if not RunevolutionData.fix_rp then
            maxleft = min( -1,RunevolutionXOffset[1],RunevolutionXOffset[2],RunevolutionXOffset[3],RunevolutionXOffset[4],RunevolutionXOffset[5],RunevolutionXOffset[6] )
        end
        if maxleft < -6 then maxleft = -6 end
        if maxleft > -1 then maxleft = -1 end
        local x = RunevolutionCoordinates[ RunevolutionData.coordset ][ maxleft ][1]
        local y = RunevolutionCoordinates[ RunevolutionData.coordset ][ maxleft ][2]
        local offx = RunevolutionCoordinates[ RunevolutionData.coordset ]["rpoffset"][1]
        local offy = RunevolutionCoordinates[ RunevolutionData.coordset ]["rpoffset"][2]
        -- fixed position
        if RunevolutionData.fix_rp then
            x = RunevolutionCoordinates[ RunevolutionData.coordset ][ "rpfix" ][1]
            y = RunevolutionCoordinates[ RunevolutionData.coordset ][ "rpfix" ][2]
            offx = 0
            offy = 0
        end
        RunevolutionFrameRPText:SetPoint("CENTER" , RunevolutionFrameRP , "CENTER" , (x+offx)*RunevolutionData.runesize , (y+offy)*RunevolutionData.runesize )
        RunevolutionFrameRP:Show()
    end
    
    
    
    -- update diseases on target
    for k,v in pairs( RunevolutionDiseaseList ) do
        Runevolution_UpdateDiseaseIcon( k )
        
        -- pulse animations
        if RunevolutionPulseList[ k ] > 0 then
            anypulse = true
            RunevolutionPulseList[ k ] = RunevolutionPulseList[ k ] - elapsed
            if RunevolutionPulseList[k] < 0 then RunevolutionPulseList[k] = 0 end
            local zoom = 1 + RunevolutionPulseList[k]/RunevolutionPulseDuration * (RunevolutionPulseFactor - 1)
            RunevolutionFrames[k]:SetWidth( RunevolutionData.runesize * zoom * 0.8 )
            RunevolutionFrames[k]:SetHeight( RunevolutionData.runesize * zoom * 0.8 )
        end
        
        -- flashing alpha disease animations
        -- uses sin-wave shape
        if RunevolutionFlashList[ k ] then
            if RunevolutionFrames[ k ]:IsShown() then
                local rate = 3
                local y = math.sin( GetTime()*rate ) * 0.35 + 0.65  -- scaled to 0.3,1 interval
                RunevolutionFrames[k]:SetAlpha( y )
            end
        end
    end
    
    
    
    -- check for out-of-combat or config mode
    if InCombatLockdown() or RunevolutionData.show_ooc or fAnyCooldown or anypulse or RunevolutionConfigMode then
        RunevolutionParentContainer:Show()
    else
        RunevolutionParentContainer:Hide()
    end
    
    
    
    -- config mode
    if RunevolutionConfigMode then
        
        --if not RunevolutionFrameMark:IsVisible() then
            RunevolutionFrameMark:Show()
            --[[RunevolutionParentContainer:SetBackdrop( { 
                bgFile = "Interface\\Buttons\\WHITE8X8",
                edgeFile = nil, tile = false, tileSize = 16, edgeSize = 24, 
                insets = { left = 5, right = 5, top = 5, bottom = 5 }
	           })]]
            --RunevolutionParentContainer.texture:SetVertexColor(1,0,0,0.7)
            RunevolutionParentContainer:EnableMouse(true)
            RunevolutionParentContainer:RegisterForDrag("LeftButton")
            RunevolutionParentContainer:SetMovable(true)
            RunevolutionParentContainer:SetToplevel(true)
        --end
        
        if not RunevolutionParentContainer:GetScript("OnMouseDown") then
            RunevolutionParentContainer:SetScript("OnMouseDown",function(self,arg1)
            if ( arg1 == "LeftButton" ) then
                    self:StartMoving()
                end
            end)
            RunevolutionParentContainer:SetScript("OnMouseUp",function(self,arg1)
                if ( arg1 == "LeftButton" ) then
                    self:StopMovingOrSizing()
                    -- readjust help window
                    local _,_,_,x,y = RunevolutionParentContainer:GetPoint(1)
                    if y > 0 then
                        y = -1
                    else
                        y = 1
                    end
                    RunevolutionFrames["help"]:SetPoint( "CENTER" , 0 , y*6*32 )
                end
            end)
            
        end
	   
	    local rate = 3
        local y = math.sin( GetTime()*rate ) * 0.35 + 0.65  -- scaled to 0.3,1 interval
        RunevolutionParentContainer.texture:SetVertexColor(y,0,0,0.7)
        
        -- check for custom layout and enable anchors in case
        if RunevolutionData.coordset == "custom" then
            RunevolutionFrames["help"]:Show()
            for i=1,6 do
                Runevolution_UpdateCustomAnchor(-i)
            end
            for i=1,10 do
                if RunevolutionData.cooldowndistance >= i then
                    Runevolution_UpdateCustomAnchor(i)
                else
                    RunevolutionFrames["anchor"..i]:Hide()
                end
            end
            Runevolution_UpdateCustomAnchor("rpfix")
            Runevolution_UpdateCustomAnchor("offsetaxis")
            for k,v in pairs( RunevolutionDiseaseList ) do
                Runevolution_UpdateCustomAnchor(k)
            end 
        elseif RunevolutionFrames["anchor-1"]:IsVisible() then
            RunevolutionFrames["help"]:Hide()
            -- not custom but need to hide anchors
            for i=1,6 do
                RunevolutionFrames["anchor-"..i]:Hide()
                RunevolutionFrames["anchor-"..i]:EnableMouse(false)
                RunevolutionFrames["anchor-"..i]:SetMovable(false)
            end
            for i=1,10 do
                RunevolutionFrames["anchor"..i]:Hide()
            end
            RunevolutionFrames["anchor".."rpfix"]:Hide()
            RunevolutionFrames["anchor".."offsetaxis"]:Hide()
            for k,v in pairs( RunevolutionDiseaseList ) do
                RunevolutionFrames["anchor"..k]:Hide()
            end 
        end
        
    elseif RunevolutionParentContainer:IsMovable() or RunevolutionFrames["anchor-1"]:IsVisible() then
        -- hide anchors
        RunevolutionParentContainer.texture:SetVertexColor(1,0,0,0)
        RunevolutionFrames["help"]:Hide()
        RunevolutionParentContainer:SetMovable(false)
        RunevolutionParentContainer:EnableMouse(false)
        if RunevolutionFrames["anchor-1"]:IsVisible() then
            for i=1,6 do
                RunevolutionFrames["anchor-"..i]:Hide()
            end
            for i=1,10 do
                RunevolutionFrames["anchor"..i]:Hide()
            end
            RunevolutionFrames["anchor".."rpfix"]:Hide()
            RunevolutionFrames["anchor".."offsetaxis"]:Hide()
            for k,v in pairs( RunevolutionDiseaseList ) do
                RunevolutionFrames["anchor"..k]:Hide()
            end 
        end
        -- save screen location
        local a1,f,a2,x,y = RunevolutionParentContainer:GetPoint(1)
        RunevolutionData.loc["x"] = x
        RunevolutionData.loc["y"] = y
        RunevolutionData.loc["f"] = f
        RunevolutionData.loc["a1"] = a1
        RunevolutionData.loc["a2"] = a2
    end
        
end

function Runevolution_UpdateCustomAnchor( i )
    RunevolutionFrames["anchor"..i]:Show()
    RunevolutionFrames["anchor"..i]:EnableMouse(true)
    RunevolutionFrames["anchor"..i]:RegisterForDrag("LeftButton")
    RunevolutionFrames["anchor"..i]:SetMovable(true)
    RunevolutionFrames["anchor"..i]:SetToplevel(true)
    if not RunevolutionFrames["anchor"..i]:GetScript("OnMouseDown") then
        RunevolutionFrames["anchor"..i]:SetAlpha(1/2)
        RunevolutionFrames["anchor"..i]:SetScript("OnMouseDown",function(self,arg1)
            if ( arg1 == "LeftButton" ) then
                self:StartMoving()
            end
            if ( arg1 == "RightButton" and self.runeindex ) then
                -- rotate the timer, if a disease icon
                if IsShiftKeyDown() then
                    -- shift-right-click => toggle hidden
                    RunevolutionData.cooldownshidden[self.runeindex] = not RunevolutionData.cooldownshidden[self.runeindex]
                elseif RunevolutionDiseaseList[ self.runeindex ] then
                    if not RunevolutionCoordinates[RunevolutionData.coordset][self.runeindex] then
                        RunevolutionCoordinates[RunevolutionData.coordset][self.runeindex] = {-4,1,"top"}
                    end
                    local oldpos = RunevolutionCoordinates[RunevolutionData.coordset][self.runeindex][3]
                    local newpos = "top"
                    if oldpos == "top" then
                        newpos = "right"
                    elseif oldpos == "right" then
                        newpos = "bottom"
                    elseif oldpos == "bottom" then
                        newpos = "left"
                    elseif oldpos == "left" then
                        newpos = "top"
                    end
                    RunevolutionCoordinates[RunevolutionData.coordset][self.runeindex][3] = newpos
                end
            end
        end)
        RunevolutionFrames["anchor"..i]:SetScript("OnMouseUp",function(self,arg1)
            if ( arg1 == "LeftButton" ) then
                self:StopMovingOrSizing()
                local a1,f,a2,x,y = self:GetPoint(1)
                print( table.concat( {a1,tostring(f),a2,x,y} , "," ) )
                -- snap into place?
                x,y = Runevolution_xy2grid( x , y , not IsShiftKeyDown() , a1 )
                if not x then
                    -- no result, so get old coordinates
                    x = RunevolutionData.custommode[self.runeindex][1]
                    y = RunevolutionData.custommode[self.runeindex][2]
                end
                --RunevolutionData.custommode[this.runeindex] = {x,y}
                if not RunevolutionData.custommode[self.runeindex] then
                    RunevolutionData.custommode[self.runeindex] = {x,y,"top"}
                end
                RunevolutionData.custommode[self.runeindex][1] = x
                RunevolutionData.custommode[self.runeindex][2] = y
                RunevolutionFrames["anchor"..self.runeindex]:ClearAllPoints()
                RunevolutionFrames["anchor"..self.runeindex]:SetPoint( "CENTER" , RunevolutionFrameContainer , "CENTER" , x*RunevolutionData.runesize , y*RunevolutionData.runesize )
            end
        end)
        RunevolutionFrames["anchor"..i]:SetScript("OnEnter",function(self)
            self:SetAlpha(1)
            self:SetWidth( RunevolutionData.runesize * 1.1 )
            self:SetHeight( RunevolutionData.runesize * 1.1 )
            self.text:SetFont("Fonts\\ZYKai_T.TTF", RunevolutionData.runesize/2 * 1.1 , "OUTLINE")
            -- show help window\
            if self.helptext then
                RunevolutionFrames["help"].text:SetText( "|cFFFFFFCC"..self.helptext )
                RunevolutionFrames["help"]:Show()
            end
        end)
        RunevolutionFrames["anchor"..i]:SetScript("OnLeave",function(self)
            self:SetAlpha(1/2)
            self:SetWidth( RunevolutionData.runesize )
            self:SetHeight( RunevolutionData.runesize )
            self.text:SetFont("Fonts\\ZYKai_T.TTF", RunevolutionData.runesize/2 , "OUTLINE")
            if self.helptext then
                RunevolutionFrames["help"].text:SetText( "|cFFFFFFCC".."Drag anchors to arrange. Shift-drag disables snap to grid." )
                RunevolutionFrames["help"]:Show()
            end
            
        end)
    end -- set scripts
end

local disease_times = {}
local expirationTime, isMine
local remaining
function Runevolution_UpdateDiseaseIcon( disease )

    if not RunevolutionData.show_diseases then
        RunevolutionFrames[disease]:Hide()
        return
    end
    
    -- check if hidden
    if RunevolutionData.cooldownshidden[ disease ] and not RunevolutionConfigMode then
        RunevolutionFrames[disease]:Hide()
        return
    end

    -- fetch target and type info
    local dtype = RunevolutionDiseaseList[ disease ].type
    local dunit = RunevolutionDiseaseList[ disease ].unit
	local spellid = RunevolutionDiseaseList[ disease ].id
    local icon = nil

    if UnitExists( dunit ) or RunevolutionConfigMode then
        
        expirationTime, isMine, icon, count = Runevolution_GetExpireTime( disease , dunit , dtype , icon )

        -- check if icon not yet set
        if not RunevolutionTextures[ disease ]:GetTexture() and icon then
            if RunevolutionDiseaseList[ disease ].icon then
                icon = "Interface\\Icons\\"..RunevolutionDiseaseList[ disease ].icon
            end
            RunevolutionTextures[ disease ]:SetTexture(icon)
        end
        
        if expirationTime == 0 then expirationTime = nil end
        
        if not isMine and not RunevolutionData.show_all_diseases then
            expirationTime = nil -- don't show anything if disease isn't player's and setting off
        end
        
        -- check for config mode
        if RunevolutionConfigMode then
            expirationTime = GetTime() + 5
            disease_times[disease] = GetTime() + 6
            isMine = true
        end
        
        if expirationTime then
            -- target has debuff, so update position
            remaining = expirationTime - ( GetTime() )
            -- see if it has been recently refreshed and pulse if so
            if disease_times[ disease ] then
                if disease_times[ disease ] < remaining then
                    RunevolutionPulseList[ disease ] = RunevolutionPulseDuration
                end
            else
                RunevolutionPulseList[ disease ] = RunevolutionPulseDuration
            end 
            disease_times[ disease ] = remaining
            if true then
                -- more than 10 seconds to go, so fix under ready runes and label with duration
                
                local fstring = ""
				if count ~= nil and count ~= 0 then
					fstring = string.format( "%d" , remaining ).."s\n"..count
				else
					fstring = string.format( "%d" , remaining ).."s"
				end
                if remaining > 60 then
                    fstring = string.format( "%d" , remaining/60 + 1 ).."m"
                end
				
				if dtype == "spell" and count ~= nil then
					fstring = string.format( "%d" , remaining ).."s\n"..count
                end
				
                RunevolutionFrames[disease].text:SetText( "|cFFFFFFFF"..fstring )
                
                local top = true
                if not RunevolutionData.diseases_up then
                    top = false
                end
                
                
                
                -- anchor the time remaining text in the correct place
                if not RunevolutionFrames[disease].text:IsVisible() or RunevolutionConfigMode then
                    local offsetAxis = RunevolutionCoordinates[RunevolutionData.coordset]["offsetaxis"]
                    local textAnchor = "BOTTOM"
                    local parentAnchor = "TOP"
                    if top then
                        RunevolutionYOffset[disease] = 1
                        if offsetAxis[2] == 1 then
                            textAnchor = "BOTTOM"
                            parentAnchor = "TOP"
                        elseif offsetAxis[1] == 1 then
                            textAnchor = "LEFT"
                            parentAnchor = "RIGHT"
                        end
                    else
                        RunevolutionYOffset[disease] = -1
                        if offsetAxis[2] == 1 then
                            textAnchor = "TOP"
                            parentAnchor = "BOTTOM"
                        elseif offsetAxis[1] == 1 then
                            textAnchor = "RIGHT"
                            parentAnchor = "LEFT"
                        end
                    end
                    if RunevolutionCoordinates[RunevolutionData.coordset][disease] then
                        -- there is a custom placement entry, so get text placement from it
                        if RunevolutionCoordinates[RunevolutionData.coordset][disease][3] == "top" then
                            textAnchor = "BOTTOM"
                            parentAnchor = "TOP"
                        end
                        if RunevolutionCoordinates[RunevolutionData.coordset][disease][3] == "bottom" then
                            textAnchor = "TOP"
                            parentAnchor = "BOTTOM"
                        end
                        if RunevolutionCoordinates[RunevolutionData.coordset][disease][3] == "left" then
                            textAnchor = "RIGHT"
                            parentAnchor = "LEFT"
                        end
                        if RunevolutionCoordinates[RunevolutionData.coordset][disease][3] == "right" then
                            textAnchor = "LEFT"
                            parentAnchor = "RIGHT"
                        end
                    end
                    RunevolutionFrames[disease].text:ClearAllPoints()
                    RunevolutionFrames[disease].text:SetPoint( textAnchor , RunevolutionFrames[disease] , parentAnchor , 0 , 0)
                end
                
                -- pull x offset for positioning
                RunevolutionXOffset[disease] = RunevolutionDiseaseList[ disease ].pos
                if RunevolutionCoordinates[RunevolutionData.coordset][disease] then
                    RunevolutionXOffset[disease] = RunevolutionCoordinates[RunevolutionData.coordset][disease][1]
                    RunevolutionYOffset[disease] = RunevolutionCoordinates[RunevolutionData.coordset][disease][2]
                end
                
                -- pulse when close to expire
                local startflash = 6
                if remaining < startflash and not RunevolutionFlashList[ disease ] then
                    RunevolutionFlashList[ disease ] = 0 -- initiate animation
                elseif remaining > startflash then
                    RunevolutionFlashList[ disease ] = nil
                end
                
                -- show
                if not RunevolutionFrames[disease]:IsVisible() or RunevolutionConfigMode then
                    RunevolutionFrames[disease].text:Show()
                    local x,y = Runevolution_Offset2Coords( RunevolutionXOffset[disease] , RunevolutionYOffset[disease] )
                    if RunevolutionData.coordset == "custom" then
                        x,y = RunevolutionXOffset[disease] , RunevolutionYOffset[disease]
                    end
                    RunevolutionFrames[disease]:ClearAllPoints()
                    RunevolutionFrames[disease]:SetPoint( "CENTER" , 0 + x*RunevolutionData.runesize , 0 + y*RunevolutionData.runesize )
                    RunevolutionFrames[disease]:Show()
                end
                
                -- fade, if debuff not ours
                if dtype == "debuff" and not isMine then
                    RunevolutionFrames[disease]:SetAlpha( 0.5 )
                    RunevolutionFrames[disease].text:Hide()
                else
                    RunevolutionFrames[disease]:SetAlpha( 1 )
                    RunevolutionFrames[disease].text:Show()
                end
				
				
                
                -- fade if config mode and cooldown hidden
                if RunevolutionData.cooldownshidden[ disease ] and RunevolutionConfigMode then
                    RunevolutionFrames[disease]:SetAlpha( 0.5 )
                    --RunevolutionFrames[disease].text:Hide()
                    RunevolutionFrames[disease].text:SetText( "|cFFFFFFFF".."off" )
                    RunevolutionFlashList[ disease ] = nil
                end
                
            end
            
            
        else
            -- no expiration time, but check if a spell/ability. if so, we show it on left when it's ready for use
            RunevolutionFlashList[ disease ] = nil -- make sure flash is turned off
            if dtype == "spell" then
                
                -- reorder, if necessary
                if RunevolutionXOffset[disease] >= 0 then -- needs to come off cooling position
                    local oldpos = RunevolutionXOffset[disease]
                    RunevolutionXOffset[disease] = 3
                    for v,vv in pairs( RunevolutionDiseaseList ) do
                        if v ~= disease and vv.type == "spell" then
                            -- another cooldown possibly up, so stack them
                            if RunevolutionXOffset[ v ] < 0 then
                                RunevolutionXOffset[disease] = RunevolutionXOffset[disease] - 1
                            end
                            -- shift other spells left, if still on cooldown
                            if RunevolutionXOffset[ v ] > oldpos then
                                RunevolutionXOffset[ v ] = RunevolutionXOffset[ v ] - 1
                            end
                        end
                    end
                    -- init pulse animation
                    RunevolutionPulseList[ disease ] = RunevolutionPulseDuration
                end -- if offset >= 0
                
                RunevolutionFrames[disease]:ClearAllPoints()
                RunevolutionFrames[disease]:SetPoint( "CENTER" , 0 + RunevolutionXOffset[disease]*RunevolutionData.runesize , 0 + RunevolutionYOffset[disease]*RunevolutionData.runesize )
                RunevolutionFrames[disease]:Show()
                RunevolutionFrames[disease].text:Hide()
				
				local index = FindSpellBookSlotBySpellID(spellid)
				if index == nil then
					RunevolutionFrames[disease]:Hide()
				end
                
            else
                -- mark that this disease is not positioned and hide it
                if RunevolutionXOffset[disease] < 0 then
                    -- reposition other diseases
                    for k,v in pairs( RunevolutionDiseaseList ) do
                        if k ~= disease and v.type ~= "spell" and RunevolutionXOffset[k] < RunevolutionXOffset[disease] then
                            RunevolutionXOffset[k] = RunevolutionXOffset[k] + 1
                        end
                    end
                end
                RunevolutionXOffset[disease] = 0
                RunevolutionFrames[disease]:Hide()
                
            end
        end
        
    else
        RunevolutionFrames[disease]:Hide()
    end
    
end

function Runevolution_GetExpireTime( disease , dunit , dtype )
    local start , name, rank, icon, count, debuffType, duration, expirationTime, caster, isStealable , isMine
    
    --print(disease)
    
    expirationTime = nil
    isMine = nil
    local id = RunevolutionDiseaseList[ disease ].id
    if not id then id = disease end
    local diseasename = GetSpellInfo( id ) -- localize the name
    if diseasename then
        disease = diseasename
    end
    if string.sub(GetLocale(),1,2) ~= "en" and RunevolutionDiseaseLocalizer[disease] then
        local lName = RunevolutionDiseaseLocalizer[ disease ][ string.sub(GetLocale(),1,2) ]
        if lName then
            disease = lName
        end
    end
    
    if dtype == "debuff" then
        name, rank, icon, count, debuffType, duration, expirationTime, caster, isStealable  =  UnitDebuff( dunit , disease )
        if caster=="player" then isMine = true end
    end
    
    if dtype == "spell" then
        start, duration, a = GetSpellCooldown( diseasename , BOOKTYPE_SPELL )
        if disease == "Blood Tap" then
            --reprint( start.."/"..duration )
        end
		
		local toal = 0
		count,toal,duration,start = GetSpellCharges(diseasename)
		--expirationTime = duration

		if count == nil or toal == nil or count >= toal then
			start = 0
		end
        if start ~= nil and start ~= 0 then
            expirationTime = start + duration
            isMine = true
        end
        if start == 0 or count == nil then
            expirationTime = nil
        end
        
        -- finally check if cooldown from global cooldown only, by checking Blood Strike
        local bsStart = GetSpellCooldown( "Blood Strike" , BOOKTYPE_SPELL )
        
        --reprint( tostring(bsStart).."/"..tostring(start) )
        
        if bsStart then
            if bsStart == start then
                -- global cooldown triggered
                expirationTime = nil
            end
        end
    end
    
    if dtype == "buff" then
        --print(disease)
        name, rank, icon, count, debuffType, duration, expirationTime, caster, isStealable = UnitBuff( dunit , disease )
        if caster=="player" then isMine = true end
    end
    
    return expirationTime, isMine, icon, count
end

function Runevolution_xy2grid(x,y,snap,anchor)
    -- translate a screen coordinate (relative to parent anchor) into rune grid offsets
    local a1,f,a2,px,py = RunevolutionParentContainer:GetPoint(1)
    print( table.concat( {a1,tostring(f),a2,px,py} , "," ) )
    
    if anchor then
        if anchor ~= a1 then return nil,nil end
    end
    
    local nx = (x-px)/RunevolutionData.runesize
    local ny = (y-py)/RunevolutionData.runesize
    if snap then
        -- snap to grid
        nx = runevround(nx)
        ny = runevround(ny)
    end
    return nx,ny
end

function runevround(num, idp)
  local mult = 10^(idp or 0)
  return math.floor(num * mult + 0.5) / mult
end

function Runevolution_resizeall()
    for i = 1,6 do
        -- runes
        Runevolution_resizeFrame( RunevolutionFrames[i] )
        -- shadows
        Runevolution_resizeFrame( RunevolutionFrames[i+6] )
        -- anchors
        Runevolution_resizeFrame( RunevolutionFrames["anchor-"..i] )
    end
    for i = 1,10 do
        Runevolution_resizeFrame( RunevolutionFrames["anchor"..i] )
    end
    Runevolution_resizeFrame( RunevolutionFrames["anchorrpfix"] )
    Runevolution_resizeFrame( RunevolutionFrames["anchoroffsetaxis"] )
    for k,v in pairs( RunevolutionDiseaseList ) do
        RunevolutionFrames[k]:SetWidth( RunevolutionData.runesize * 0.8 )
        RunevolutionFrames[k]:SetHeight( RunevolutionData.runesize * 0.8 )
        RunevolutionFrames[k].text:SetFont("Fonts\\ZYKai_T.TTF", RunevolutionData.runesize/2 , "OUTLINE")
        Runevolution_resizeFrame( RunevolutionFrames["anchor"..k] )
    end
    RunevolutionFrameRPText:SetFont("Fonts\\ZYKai_T.TTF", RunevolutionData.runesize/1.5 , "OUTLINE")
    Runevolution_UpdateRunePositions()
end

function Runevolution_resizeFrame( f )
    f:SetWidth( RunevolutionData.runesize )
    f:SetHeight( RunevolutionData.runesize )
    if f.text then
        f.text:SetFont("Fonts\\ZYKai_T.TTF", RunevolutionData.runesize/2 , "OUTLINE")
    end
    if f.runeindex then
        local xy = RunevolutionData.custommode[ f.runeindex ]
        f:ClearAllPoints()
        f:SetPoint( "CENTER" , xy[1]*RunevolutionData.runesize , xy[2]*RunevolutionData.runesize )
    end
end