local addon, ns = ...
local cfg = ns.cfg
local panel = CreateFrame("Frame", nil, UIParent)
panel:SetFrameStrata("BACKGROUND")

if cfg.Positions == true then
    local Stat = CreateFrame("Frame")
    Stat:EnableMouse(true)
    local Text  = panel:CreateFontString(nil, "OVERLAY")
    Text:SetFont(unpack(cfg.Fonts))
    Text:SetPoint(unpack(cfg.PositionsPoint))
	Stat:SetAllPoints(Text)

	local colorT = {
		sanctuary = {SANCTUARY_TERRITORY, {0.41,0.8,0.94}};
		arena = {FREE_FOR_ALL_TERRITORY, {1,0.1,0.1}};
		friendly = {FACTION_CONTROLLED_TERRITORY, {0.1,1,0.1}};
		hostile = {FACTION_CONTROLLED_TERRITORY, {1,0.1,0.1}};
		contested = {CONTESTED_TERRITORY, {1,0.7,0}};
		combat = {COMBAT_ZONE, {1,0.1,0.1}};
		neutral = {format(FACTION_CONTROLLED_TERRITORY,FACTION_STANDING_LABEL4), {1,0.93,0.76}}
	}

	local coordX, coordY = 0, 0
	local function formatCoords() return format("%.1f, %.1f", coordX*100, coordY*100) end

	local function OnEvent()
		subzone, zone, pvp = GetSubZoneText(), GetZoneText(), {GetZonePVPInfo()}
		if not pvp[1] then pvp[1] = "neutral" end
		local r,g,b = unpack(colorT[pvp[1]][2])
		Text:SetText((subzone ~= "") and subzone or zone)
		Text:SetTextColor(r,g,b)
	end

	Stat:RegisterEvent("ZONE_CHANGED")
	Stat:RegisterEvent("ZONE_CHANGED_INDOORS")
	Stat:RegisterEvent("ZONE_CHANGED_NEW_AREA")
	Stat:RegisterEvent("PLAYER_ENTERING_WORLD")
	Stat:SetScript("OnEvent", OnEvent)

	Stat:SetScript("OnEnter",function(self)
		GameTooltip:SetOwner(self, "ANCHOR_BOTTOM", 0, -20)
		GameTooltip:ClearLines()
		GameTooltip:AddLine(format("%s |cffffffff(%s)", zone, formatCoords()), 0,.6,1, 1,1,1)
		if pvp[1] and not IsInInstance() then
			local r,g,b = unpack(colorT[pvp[1]][2])
			if subzone and subzone ~= zone then 
				GameTooltip:AddLine(" ")
				GameTooltip:AddLine(subzone,r,g,b)
			end
			GameTooltip:AddLine(format(colorT[pvp[1]][1], pvp[3] or ""), r,g,b)
		end

		GameTooltip:AddDoubleLine(" ", "--------------", 1,1,1, .5,.5,.5)
		GameTooltip:AddDoubleLine(" ", infoL["WorldMap"], 1,1,1, .6,.8,1)
		GameTooltip:AddDoubleLine(" ", infoL["Send My Pos"], 1,1,1, .6,.8,1)
		GameTooltip:Show()
	end)
	Stat:SetScript("OnLeave", GameTooltip_Hide)
	Stat:SetScript("OnMouseUp", function(_, btn)
		if btn == "LeftButton" then
			ToggleFrame(WorldMapFrame)
		else
			ChatFrame_OpenChat(format("%s: %s (%s)", infoL["My Position"], zone, formatCoords()), chatFrame)
		end
	end)
	Stat:SetScript("OnUpdate", function() coordX, coordY = GetPlayerMapPosition("player") end)
end