 -- 特别感谢 zork 的 rChat

----------------------------- -- 特别感谢 zork 的 rChat
------- CONFIG
local hide_chatframe_backgrounds = true   -- 隐藏聊天框背景 (true/false) (隐藏/显示)
local hide_chattab_backgrounds = true     -- 隐藏聊天标签背景 (true/false) (隐藏/显示)
local BorderColor = {r=0, g=0, b=0, a=0}  -- 输入框边框颜色/透明度 (a是透明度,白色请改成 {r=1, g=1, b=1, a=0.8})
local showchattime = false                -- 显示时间戳 (true/false) (显示时间/显示"★")
local ShortChannel = true                 -- 精简公共频道 (true/false) (精简/不精简)

-- add more chat font sizes
  for i = 1, 23 do  CHAT_FONT_HEIGHTS[i] = i+7  end

--战网好友上线框
BNToastFrame:HookScript("OnShow", function(self)	self:SetScale(0.9) self:ClearAllPoints() self:SetPoint("BOTTOMLEFT", ChatFrame1Tab, "TOPLEFT", 0, 3)	end)

  
  
-- 打开输入框回到上次对话 (1/0 = On/Off)
ChatTypeInfo["SAY"].sticky  = 1; -- 说
ChatTypeInfo["PARTY"].sticky 	= 1; -- 小队
ChatTypeInfo["GUILD"].sticky 	= 1; -- 公会
ChatTypeInfo["WHISPER"].sticky 	= 1; -- 密语
ChatTypeInfo["BN_WHISPER"].sticky   = 1; -- 战网好友密语
ChatTypeInfo["RAID"].sticky 	= 1; -- 团队
ChatTypeInfo["OFFICER"].sticky 	= 1; -- 官员
ChatTypeInfo["CHANNEL"].sticky 	= 1; -- 频道
ChatTypeInfo["INSTANCE_CHAT"].sticky 	= 1;      -- 副本

-- 聊天标签
CHAT_FRAME_FADE_OUT_TIME = 0 -- 聊天窗口褪色时间
CHAT_TAB_HIDE_DELAY = 0      -- 聊天标签弹出延时
CHAT_FRAME_TAB_NORMAL_MOUSEOVER_ALPHA = 0.6   -- 鼠标停留时,标签透明度
CHAT_FRAME_TAB_NORMAL_NOMOUSE_ALPHA = 0       -- 鼠标离开时,标签透明度 (修改这里能一直显示)
CHAT_FRAME_TAB_SELECTED_MOUSEOVER_ALPHA = 1   -- 鼠标停留时,选择标签时透明度
CHAT_FRAME_TAB_SELECTED_NOMOUSE_ALPHA = 0     -- 鼠标离开时,选择标签时透明度
CHAT_FRAME_TAB_ALERTING_MOUSEOVER_ALPHA = 0.6 -- 鼠标停留时,标签闪动时透明度
CHAT_FRAME_TAB_ALERTING_NOMOUSE_ALPHA = 0     -- 鼠标离开时,标签闪动时透明度


------- FUNCTIONS
  local function skinChat(self)
    if not self or (self and self.skinApplied) then return end

    local name = self:GetName()

    --chat frame resizing
    self:SetClampRectInsets(0, 0, 0, 0)
    self:SetMaxResize(UIParent:GetWidth(), UIParent:GetHeight())
    self:SetMinResize(100, 50)

    --fix the buttonframe
    local frame = _G[name.."ButtonFrame"]
    frame:Hide()
    frame:HookScript("OnShow", frame.Hide)

    --editbox skinning
    _G[name.."EditBoxLeft"]:Hide()
    _G[name.."EditBoxMid"]:Hide()
    _G[name.."EditBoxRight"]:Hide()
    local eb = _G[name.."EditBox"]
    eb:SetAltArrowKeyMode(false)
    eb:ClearAllPoints()
    eb:SetPoint("BOTTOM",self,"TOP",0,22)
    eb:SetPoint("LEFT",self,-5,0)
    eb:SetPoint("RIGHT",self,10,0)
    ChatFrame1EditBoxLanguage:SetPoint('LEFT', editbox, 'RIGHT', -5, 0) --输入框语言按钮位置

    self.skinApplied = true
  end

------- CALL
local tabs = {"Left", "Middle", "Right", "SelectedLeft", "SelectedRight", "SelectedMiddle",}--, "Glow"
    
  --chat skinning
  for i = 1, NUM_CHAT_WINDOWS do
if hide_chattab_backgrounds then     -- 聊天标签背景
    for index, value in pairs(tabs) do _G['ChatFrame'..i..'Tab'..value]:SetTexture(nil) end
end
if hide_chatframe_backgrounds then    -- 聊天框背景
    for g = 1, #CHAT_FRAME_TEXTURES do _G["ChatFrame"..i..CHAT_FRAME_TEXTURES[g]]:SetTexture(nil) end
end
    skinChat(_G["ChatFrame"..i])
  end

  --skin temporary chats
  hooksecurefunc("FCF_OpenTemporaryWindow", function()
    for _, chatFrameName in pairs(CHAT_FRAMES) do if (_G[chatFrameName].isTemporary) then skinChat(_G[chatFrameName]) end end
  end)

  --combat log custom hider
  local function fixStuffOnLogin()
    for i = 1, NUM_CHAT_WINDOWS do
      local name = "ChatFrame"..i
      local tab = _G[name.."Tab"]
    end
    CombatLogQuickButtonFrame_Custom:HookScript("OnShow", CombatLogQuickButtonFrame_Custom.Hide)
    CombatLogQuickButtonFrame_Custom:Hide()
    CombatLogQuickButtonFrame_Custom:SetHeight(0)
  end

  local a = CreateFrame("Frame")
  a:RegisterEvent("PLAYER_LOGIN")
  a:SetScript("OnEvent", fixStuffOnLogin)
  
  ----Shift至底部/顶部
FloatingChatFrame_OnMouseScroll = function(self, dir)
  if(dir > 0) then if(IsShiftKeyDown()) then self:ScrollToTop() else self:ScrollUp() end
  else if(IsShiftKeyDown()) then self:ScrollToBottom() else self:ScrollDown() end
  end
end

----==============================精简聊天频道,可修改汉字自定义==========================----
if (GetLocale() == "zhCN") then
  --公会
  CHAT_GUILD_GET = "|Hchannel:GUILD|h[公会]|h %s: "
  CHAT_OFFICER_GET = "|Hchannel:OFFICER|h[官员]|h %s: "  
  --团队
  CHAT_RAID_GET = "|Hchannel:RAID|h[团队]|h %s: "
  CHAT_RAID_WARNING_GET = "[通知] %s: "
  CHAT_RAID_LEADER_GET = "|Hchannel:RAID|h[团长]|h %s: " 
  --队伍
  CHAT_PARTY_GET = "|Hchannel:PARTY|h[队伍]|h %s: "
  CHAT_PARTY_LEADER_GET =  "|Hchannel:PARTY|h[队长]|h %s: "
  CHAT_PARTY_GUIDE_GET =  "|Hchannel:PARTY|h[向导]:|h %s: "
  --战场
  CHAT_BATTLEGROUND_GET = "|Hchannel:BATTLEGROUND|h[战场]|h %s: "
  CHAT_BATTLEGROUND_LEADER_GET = "|Hchannel:BATTLEGROUND|h[领袖]|h %s: "
  --密语  
  CHAT_WHISPER_INFORM_GET = "发送给%s: "
  CHAT_WHISPER_GET = "%s悄悄话: "
  CHAT_BN_WHISPER_INFORM_GET = "发送给%s "
  CHAT_BN_WHISPER_GET = "悄悄话%s "
  --说 / 喊
  CHAT_SAY_GET = "%s: "
  CHAT_YELL_GET = "%s: "  
  --flags
  CHAT_FLAG_AFK = "[暂离] "
  CHAT_FLAG_DND = "[勿扰] "
  CHAT_FLAG_GM = "[GM] "

elseif GetLocale() == "zhTW" then
  --公会
  CHAT_GUILD_GET = "|Hchannel:GUILD|h[公會]|h %s: "
  CHAT_OFFICER_GET = "|Hchannel:OFFICER|h[官員]|h %s: "  
  --团队
  CHAT_RAID_GET = "|Hchannel:RAID|h[團隊]|h %s: "
  CHAT_RAID_WARNING_GET = "[通知] %s: "
  CHAT_RAID_LEADER_GET = "|Hchannel:RAID|h[團長]|h %s: "
  --队伍
  CHAT_PARTY_GET = "|Hchannel:PARTY|h[隊伍]|h %s: "
  CHAT_PARTY_LEADER_GET =  "|Hchannel:PARTY|h[隊長]|h %s: "
  CHAT_PARTY_GUIDE_GET =  "|Hchannel:PARTY|h[向導]:|h %s: "
  --战场
  CHAT_BATTLEGROUND_GET = "|Hchannel:BATTLEGROUND|h[戰場]|h %s: "
  CHAT_BATTLEGROUND_LEADER_GET = "|Hchannel:BATTLEGROUND|h[領袖]|h %s: "
  --密语  
  CHAT_WHISPER_INFORM_GET = "發送給%s: "
  CHAT_WHISPER_GET = "%s悄悄話: "
  CHAT_BN_WHISPER_INFORM_GET = "發送給%s "
  CHAT_BN_WHISPER_GET = "悄悄話%s "
  --说 / 喊
  CHAT_SAY_GET = "%s: "
  CHAT_YELL_GET = "%s: "  
  --flags
  CHAT_FLAG_AFK = "[暫離] "
  CHAT_FLAG_DND = "[勿擾] "
  CHAT_FLAG_GM = "[GM] "
  
else
  --guild
  CHAT_GUILD_GET = "|Hchannel:GUILD|hG|h %s "
  CHAT_OFFICER_GET = "|Hchannel:OFFICER|hO|h %s "
  --raid
  CHAT_RAID_GET = "|Hchannel:RAID|hR|h %s "
  CHAT_RAID_WARNING_GET = "RW %s "
  CHAT_RAID_LEADER_GET = "|Hchannel:RAID|hRL|h %s "
  --party
  CHAT_PARTY_GET = "|Hchannel:PARTY|hP|h %s "
  CHAT_PARTY_LEADER_GET =  "|Hchannel:PARTY|hPL|h %s "
  CHAT_PARTY_GUIDE_GET =  "|Hchannel:PARTY|hPG|h %s "
  --instance
  CHAT_INSTANCE_CHAT_GET = "|Hchannel:Battleground|hI.|h %s: "
  CHAT_INSTANCE_CHAT_LEADER_GET = "|Hchannel:Battleground|hIL.|h %s: "
  --battle
  CHAT_BATTLEGROUND_GET = "|Hchannel:BATTLEGROUND|hB|h %s "
  CHAT_BATTLEGROUND_LEADER_GET = "|Hchannel:BATTLEGROUND|hBL|h %s " 
  --whisper  
  CHAT_WHISPER_INFORM_GET = "to %s "
  CHAT_WHISPER_GET = "from %s "
  CHAT_BN_WHISPER_INFORM_GET = "to %s "
  CHAT_BN_WHISPER_GET = "from %s "
  --say / yell
  CHAT_SAY_GET = "%s "
  CHAT_YELL_GET = "%s "
  --flags
  CHAT_FLAG_AFK = "[AFK] "
  CHAT_FLAG_DND = "[DND] "
  CHAT_FLAG_GM = "[GM] "
end

--================================公共频道和自定义频道精简================================--
local gsub = _G.string.gsub
local newAddMsg = {}
local chn, rplc
  if (GetLocale() == "zhCN") then  ---国服
	rplc = { "[%1综合]", "[%1交易]", "[%1防务]", "[%1组队]", "[%1世界]", "[%1招募]", "[%1大脚]", "[%1自定义]", } 
  elseif (GetLocale() == "zhTW") then  ---台服
	rplc = { "[%1綜合]", "[%1貿易]", "[%1防務]", "[%1組隊]", "[%1世界]", "[%1招募]", "[%1自定义]", } 
	else       
	rplc = { "[GEN]", "[TR]", "[WD]", "[LD]", "[LFG]", "[GR]", "[BFC]", "[CL]", }      -- 英文缩写
 end
        
	chn = { "%[%d+%. General.-%]", "%[%d+%. Trade.-%]", "%[%d+%. LocalDefense.-%]", "%[%d+%. LookingForGroup%]", "%[%d+%. WorldDefense%]", "%[%d+%. GuildRecruitment.-%]", "%[%d+%. CustomChannel.-%]", }

	if (GetLocale() == "zhCN") then
		chn[1] = "%[%d+%. 综合.-%]"
		chn[2] = "%[%d+%. 交易.-%]"
		chn[3] = "%[%d+%. 本地防务.-%]"
		chn[4] = "%[%d+%. 寻求组队%]"
    chn[5] = "%[%d+%. 世界防务%]"	
		chn[6] = "%[%d+%. 公会招募.-%]"
    chn[7] = "%[%d+%. 大脚世界频道.-%]"
    chn[8] = "%[%d+%. 自定义频道.-%]"   -- 请修改频道名对应你游戏里的频道
  elseif (GetLocale() == "zhTW") then
		chn[1] = "%[%d+%. 綜合.-%]"
		chn[2] = "%[%d+%. 貿易.-%]"
	  chn[3] = "%[%d+%. 本地防務.-%]"
		chn[4] = "%[%d+%. 尋求組隊%]"
    chn[5] = "%[%d+%. 世界防務%]"	
		chn[6] = "%[%d+%. 公會招募.-%]"
    chn[7] = "%[%d+%. 自定义频道.-%]"   -- 请修改频道名对应你游戏里的频道
	else
		chn[1] = "%[%d+%. General.-%]"
		chn[2] = "%[%d+%. Trade.-%]"
		chn[3] = "%[%d+%. LocalDefense.-%]"
		chn[4] = "%[%d+%. LookingForGroup%]"
		chn[5] = "%[%d+%. WorldDefense%]"
		chn[6] = "%[%d+%. GuildRecruitment.-%]"
    chn[7] = "%[%d+%. CustomChannel.-%]"   -- 自定义频道英文名随便填写
	end
	
local function AddMessage(frame, text, ...)
	for i = 1, 7 do text = gsub(text, chn[i], rplc[i]) end	 -- 对应上面几个频道
	text = gsub(text, "%[(%d0?)%. .-%]", "%1.") 
	return newAddMsg[frame:GetName()](frame, text, ...)
end

if ShortChannel then
	for i = 1, 5 do
		if i ~= 2 then newAddMsg[format("%s%d", "ChatFrame", i)] = _G[format("%s%d", "ChatFrame", i)].AddMessage
			_G[format("%s%d", "ChatFrame", i)].AddMessage = AddMessage
		end
	end
end

local origSetItemRef = SetItemRef
SetItemRef = function(link, text, button)
  if IsAltKeyDown() and string.sub(link, 1, 6) == "player" then InviteUnit(string.match(link, "player:([^:]+)")) return nil end
  return origSetItemRef(link,text,button)
end

--TabChangeChannel 按TAB切換頻道.==--
function ChatEdit_CustomTabPressed(self)
	if strsub(tostring(self:GetText()), 1, 1) == '/' then return end
	local chatType = self:GetAttribute('chatType')
	local inParty = GetNumSubgroupMembers() > 0
	local inInstance = IsInGroup(LE_PARTY_CATEGORY_INSTANCE) and IsInInstance()
	local inRaid = GetNumGroupMembers() > 0 and IsInRaid()
	local inGuild = IsInGuild()
	local isOfficer = CanEditOfficerNote()
	local setType
	if chatType == 'SAY' then
		setType = inParty and 'PARTY' or inInstance and 'INSTANCE_CHAT' or inRaid and 'RAID' or inGuild and 'GUILD' or isOfficer and 'OFFICER'
	elseif chatType == 'WHISPER' then
		setType = inParty and 'PARTY' or inInstance and 'INSTANCE_CHAT' or inRaid and 'RAID' or inGuild and 'GUILD' or isOfficer and 'OFFICER'
	elseif chatType == 'BN_WHISPER' then
		setType = inParty and 'PARTY' or inInstance and 'INSTANCE_CHAT' or inRaid and 'RAID' or inGuild and 'GUILD' or isOfficer and 'OFFICER'
	elseif chatType == 'PARTY' then
		setType = inInstance and 'INSTANCE_CHAT' or inRaid and 'RAID' or inGuild and 'GUILD' or isOfficer and 'OFFICER' or 'SAY'
	elseif chatType == 'INSTANCE_CHAT' then
		setType = inGuild and 'GUILD' or isOfficer and 'OFFICER' or 'SAY'
	elseif chatType == 'RAID' then
		setType = inGuild and 'GUILD' or isOfficer and 'OFFICER' or 'SAY'
	elseif chatType == 'GUILD' then
		setType = isOfficer and 'OFFICER' or 'SAY'
	elseif chatType == 'OFFICER' then
		setType = 'SAY'
	elseif chatType == 'CHANNEL' then
		setType = inParty and 'PARTY' or inInstance and 'INSTANCE_CHAT' or inRaid and 'RAID' or inGuild and 'GUILD' or isOfficer and 'OFFICER' or 'SAY'
	end
	if setType then self:SetAttribute('chatType', setType) ChatEdit_UpdateHeader(self) else return end
end


-------------------------------------
-- 聊天信息複製-- Author:M
-------------------------------------

--注意規則順序, button(LeftButton/RightButton)可以指定鼠標左右鍵使用不同的邏輯
local rules = {
    --!!这两条不要更改
    { pat = "|c%x+|HChatCopy|h.-|h|r",      repl = "" },   --去掉本插件定義的鏈接
    { pat = "|c%x%x%x%x%x%x%x%x(.-)|r",     repl = "%1" }, --替換所有顔色值
    --以下為左鍵特有
    { pat = "|Hchannel:.-|h.-|h",           repl = "", button = "LeftButton" }, --(L)去掉頻道文字
    { pat = "|Hplayer:.-|h.-|h" .. ":",     repl = "", button = "LeftButton" }, --(L)去掉發言玩家名字
    { pat = "|Hplayer:.-|h.-|h" .. "：",    repl = "", button = "LeftButton" }, --(L)去掉發言玩家名字
    { pat = "|HBNplayer:.-|h.-|h" .. ":",   repl = "", button = "LeftButton" }, --(L)去掉戰網發言玩家名字
    { pat = "|HBNplayer:.-|h.-|h" .. "：",  repl = "", button = "LeftButton" }, --(L)去掉戰網發言玩家名字
    --以下為右鍵特有
    { pat = "|Hchannel:.-|h(.-)|h",         repl = "%1", button = "RightButton" }, --(R)留下頻道文字
    { pat = "|Hplayer:.-|h(.-)|h",          repl = "%1", button = "RightButton" }, --(R)留下發言玩家名字
    { pat = "|HBNplayer:.-|h(.-)|h",        repl = "%1", button = "RightButton" }, --(R)留下戰網發言玩家名字
    --!!这三條不要更改
    { pat = "|H.-|h(.-)|h",                 repl = "%1" },  --替換所有超連接
    { pat = "|TInterface\\TargetingFrame\\UI%-RaidTargetingIcon_(%d):0|t", repl = "{rt%1}" },
    { pat = "|T.-|t",                       repl = "" },    --替換所有素材
    { pat = "^%s+",                         repl = "" },    --去掉空格
}

--替換字符
local function clearMessage(msg, button)
    for _, rule in ipairs(rules) do
        if (not rule.button or rule.button == button) then
            msg = msg:gsub(rule.pat, rule.repl)
        end
    end
    return msg
end

--顯示信息
local function showMessage(msg, button)
    local editBox = ChatEdit_ChooseBoxForSend()
    msg = clearMessage(msg, button)
    ChatEdit_ActivateChat(editBox)
    editBox:SetText(editBox:GetText() .. msg)
    editBox:HighlightText()
end

--獲取複製的信息
local function getMessage(...)
    local object
    for i = 1, select("#", ...) do
        object = select(i, ...)
        if (object:IsObjectType("FontString") and MouseIsOver(object)) then
            return object:GetText()
        end
    end
    return ""
end

--HACK
local _SetItemRef = SetItemRef

SetItemRef = function(link, text, button, chatFrame)
    if (link:sub(1,8) == "ChatCopy") then
        local msg = getMessage(chatFrame.FontStringContainer:GetRegions())
        return showMessage(msg, button)
    end
    _SetItemRef(link, text, button, chatFrame)
end

--HACK
local function AddMessage(self, text, ...)
    if (type(text) ~= "string") then
        text = tostring(text)
    end
    text = format("|cff68ccef|HChatCopy|h%s|h|r %s", ">", text)
    self.OrigAddMessage(self, text, ...)
end

local chatFrame

for i = 1, NUM_CHAT_WINDOWS do
    chatFrame = _G["ChatFrame" .. i]
    if (chatFrame) then
        chatFrame.OrigAddMessage = chatFrame.AddMessage
        chatFrame.AddMessage = AddMessage
    end
end

----------------------------------------------------------------------------------------
------------------------------------------------------------------------------------
local hooks = {}
local blacklist = {
	SPELL_FAILED_NO_COMBO_POINTS,   -- That ability requires combo points
	SPELL_FAILED_TARGETS_DEAD,      -- Your target is dead
	SPELL_FAILED_SPELL_IN_PROGRESS, -- Another action is in progress
	SPELL_FAILED_TARGET_AURASTATE,  -- You can't do that yet. (TargetAura)
	SPELL_FAILED_CASTER_AURASTATE,  -- You can't do that yet. (CasterAura)
	SPELL_FAILED_NO_ENDURANCE,      -- Not enough endurance
	SPELL_FAILED_BAD_TARGETS,       -- Invalid target
	SPELL_FAILED_NOT_MOUNTED,       -- You are mounted
	SPELL_FAILED_NOT_ON_TAXI,       -- You are in flight
	SPELL_FAILED_NOT_INFRONT,       -- You must be in front of your target
	SPELL_FAILED_NOT_IN_CONTROL,    -- You are not in control of your actions
	SPELL_FAILED_MOVING,            -- Can't do that while moving
	ERR_ATTACK_FLEEING,				-- Can't attack while fleeing.
	ERR_ITEM_COOLDOWN,				-- Item is not ready yet.
	ERR_GENERIC_NO_TARGET,          -- You have no target.
	ERR_ABILITY_COOLDOWN,           -- Ability is not ready yet.
	ERR_OUT_OF_ENERGY,              -- Not enough energy
	ERR_NO_ATTACK_TARGET,           -- There is nothing to attack.
	ERR_SPELL_COOLDOWN,             -- Spell is not ready yet. (Spell)
	ERR_OUT_OF_RAGE,                -- Not enough rage.
	ERR_INVALID_ATTACK_TARGET,      -- You cannot attack that target.
	ERR_OUT_OF_MANA,                -- Not enough mana
	ERR_NOEMOTEWHILERUNNING,        -- You can't do that while moving!
	OUT_OF_ENERGY,                  -- Not enough energy.
}

hooks["UIErrorsFrame_AddMessage"] = UIErrorsFrame.AddMessage
UIErrorsFrame.AddMessage = function(...)
	for k,v in ipairs(blacklist) do
		if v==arg1 then return end
	end
	hooks["UIErrorsFrame_AddMessage"](...)
end

---------------------------------密语语音提示---------------------------

local WhisperSoundTip = CreateFrame("Frame")

local soundfile = tostring("Interface\\AddOns\\ShiGuang\\bChat\\Whisper.ogg")

function WhisperSoundTip:CHAT_MSG_WHISPER()
		PlaySoundFile(soundfile)
end

WhisperSoundTip:SetScript("OnEvent",function(self, event, ...)
	if self[event] then self[event](self, ...)
	else self:UnregisterEvent(event) end
end
)
WhisperSoundTip:RegisterEvent("CHAT_MSG_WHISPER")

-- 隐藏聊天菜单按钮(鼠标划过右上角显示)
--ChatFrameMenuButton:Hide()
--ChatFrameMenuButton:SetScript("OnShow", kill)
 ChatFrameMenuButton:SetScale(0.85)  --按钮缩放
 ChatFrameMenuButton:SetAlpha(0.8)  --刚进游戏时按钮透明度(鼠标经过1次后显示鼠标离开时透明度)
 ChatFrameMenuButton:ClearAllPoints()
 ChatFrameMenuButton:SetPoint("BOTTOMLEFT",ChatFrame1,"BOTTOMLEFT",-11138,-33) --位置  X15
 ChatFrameMenuButton:SetScript('OnEnter', function(self) self:SetAlpha(1) end) --鼠标进入时透明度
 ChatFrameMenuButton:SetScript('OnLeave', function(self) self:SetAlpha(0.8) end) --鼠标离开时透明度
 
-- 社交按钮(鼠标划过左上角显示)
QuickJoinToastButton:Hide()
QuickJoinToastButton:SetScript("OnShow", kill)
 --[[QuickJoinToastButton:SetScale(0.8) --按钮缩放
 QuickJoinToastButton:SetAlpha(0.001) --刚进游戏时按钮透明度(鼠标经过1次后显示鼠标离开时透明度)
 QuickJoinToastButton:ClearAllPoints()
 QuickJoinToastButton:SetPoint("BOTTOMLEFT",ChatFrame1,"BOTTOMLEFT",-11138,-32) --位置
 QuickJoinToastButton:SetScript('OnEnter', function(self) self:SetAlpha(1) end) --鼠标进入时透明度
 QuickJoinToastButton:SetScript('OnLeave', function(self) self:SetAlpha(0.001) end) --鼠标离开时透明度]]

-- 隐藏翻页按钮(不在最后一行右下角显示翻页至底按钮)
local updateBottomButton = function(frame)
	local button = frame.buttonFrame.bottomButton
	if frame:AtBottom() then button:Hide() else button:Show() end
end
local bottomButtonClick = function(button)
	local frame = button:GetParent()
	frame:ScrollToBottom()
	updateBottomButton(frame)
end
	for i = 1, NUM_CHAT_WINDOWS do
		local frame = _G["ChatFrame" .. i]
		ChatFrame_RemoveMessageGroup(frame, "CHANNEL")  ----------关闭进出频道提示
		frame:HookScript("OnShow", updateBottomButton)
		frame.buttonFrame:Hide()
		frame.buttonFrame.bottomButton:SetParent(frame)
		frame.buttonFrame.bottomButton:SetPoint("BOTTOMRIGHT", frame, "BOTTOMRIGHT", 5, 5)
		frame.buttonFrame.bottomButton:SetScript("OnClick", bottomButtonClick)
		frame.buttonFrame.bottomButton:SetAlpha(0.8)
    frame.buttonFrame.bottomButton:SetScale(0.7)
		updateBottomButton(frame)
    frame.buttonFrame.upButton.Show = frame.buttonFrame.upButton.Hide 
    frame.buttonFrame.upButton:Hide()
    frame.buttonFrame.downButton.Show = frame.buttonFrame.downButton.Hide 
    frame.buttonFrame.downButton:Hide()
    frame.buttonFrame.minimizeButton:SetScale(.7)   
    frame.buttonFrame.minimizeButton:ClearAllPoints()
    frame.buttonFrame.minimizeButton:SetPoint('TOPRIGHT', frame, 'TOPRIGHT', 5, 5)
    frame.buttonFrame.minimizeButton:SetScript('OnEnter', function(self) self:SetAlpha(1) end)
    frame.buttonFrame.minimizeButton:SetScript('OnLeave', function(self) self:SetAlpha(0) end)
	end
	hooksecurefunc("FloatingChatFrame_OnMouseScroll", updateBottomButton)
	
	
-----------------Chatchannelbar----- 属性通报 ----------------------------------------
-- 本地化专精
function Talent()
	local SpecName = GetSpecialization() and select(2, GetSpecializationInfo(GetSpecialization())) or "无"
	return SpecName
end
-- 格式化血量
function HealText()
local HP = UnitHealthMax("player");
	if HP > 1e4 then return format('%.2f万',HP/1e4)
	else return HP end
end
-- 基础属性
function BaseInfo()
	local BaseStat = ""	
		BaseStat = BaseStat..("[%s] "):format(Talent())
		--BaseStat = BaseStat..("%s "):format(UnitClass("player"))
		BaseStat = BaseStat..("< %.1f/%.1f > "):format(GetAverageItemLevel())
		BaseStat = BaseStat..("血量:%s "):format(HealText())
	return BaseStat
end
-- 输出属性(9 = 暴击 12 = 溅射 17 = 吸血 18 = 急速 21 = 闪避 26 = 精通 29 = 装备+自身全能 31 = 装备全能)
-- by图图
function DpsInfo()
    local DpsStat={"", "", ""}
    local specAttr={
        --纯力敏智属性职业
        WARRIOR={1,1,1},
        DEATHKNIGHT={1,1,1},
        ROGUE={2,2,2},
        HUNTER={2,2,2},
        MAGE={3,3,3},
        WARLOCK={3,3,3},
        PRIEST={3,3,3},
        --混合力敏智属性职业
        SHAMAN={3,2,3},
        MONK={2,3,2},
        DRUID={3,2,2,3},
        PALADIN={3,1,1},
        DEMONHUNTER={2,1}
    }
	local specId = GetSpecialization()
	local classCN,classEnName = UnitClass("player")
    local classSpecArr = specAttr[classEnName]
    DpsStat[1] = ("力量:%s "):format(UnitStat("player", 1))
    DpsStat[2] = ("敏捷:%s "):format(UnitStat("player", 2))
    DpsStat[3] = ("智力:%s "):format(UnitStat("player", 4))
	return DpsStat[classSpecArr[specId]]
end
-- 坦克属性
function TankInfo()
	local TankStat = ""
		TankStat = TankStat..("耐力:%s "):format(UnitStat("player", 3))
		TankStat = TankStat..("护甲:%s "):format(UnitArmor("player"))
		TankStat = TankStat..("闪避:%.2f%% "):format(GetDodgeChance())
		TankStat = TankStat..("招架:%.2f%% "):format(GetParryChance())
		TankStat = TankStat..("格挡:%.2f%% "):format(GetBlockChance())
	return TankStat
end
-- 治疗属性
function HealInfo()
	local HealStat = ""
		--HealStat = HealStat..("精神:%s "):format(UnitStat("player", 5))
		HealStat = HealStat..("法力回复:%d "):format(GetManaRegen()*5)
	return HealStat
end
-- 增强属性
function MoreInfo()
	local MoreStat = ""
		MoreStat = MoreStat..("急速:%.2f%% "):format(GetMeleeHaste())
		MoreStat = MoreStat..("爆击:%.2f%% "):format(GetCritChance())
		MoreStat = MoreStat..("精通:%.2f%% "):format(GetMasteryEffect())
		--MoreStat = MoreStat..("溅射:%.2f%% "):format(GetMultistrike())
		MoreStat = MoreStat..("吸血:%s "):format(GetCombatRating(17))
		--MoreStat = MoreStat..("溅射:%.2f%% "):format(GetCombatRating(12))
		--MoreStat = MoreStat..("全能:%.2f%% "):format(GetCombatRating(29))
	return MoreStat
end
-- 属性收集
function StatReport()
	if UnitLevel("player") < 10 then return BaseInfo() end
	local StatInfo = ""
	local Role = GetSpecializationRole(GetSpecialization())
	if Role == "HEALER" then
		StatInfo = StatInfo..BaseInfo()..DpsInfo()..HealInfo()..MoreInfo()
	elseif Role == "TANK" then
		StatInfo = StatInfo..BaseInfo()..DpsInfo()..TankInfo()..MoreInfo()
	else
		StatInfo = StatInfo..BaseInfo()..DpsInfo()..MoreInfo()
	end
	return StatInfo
end


-- Nevo_Chatbar主框体 --
local chatFrame = SELECTED_DOCK_FRAME
local editBox = chatFrame.editBox
COLORSCHEME_BORDER   = { 0.3,0.3,0.3,1 }

local chatbar = CreateFrame("Frame", "chatbar", UIParent)
chatbar:SetWidth(210) -- 主框体宽度
chatbar:SetHeight(21) -- 主框体高度
chatbar:SetPoint("BOTTOMRIGHT",_G["ChatFrame1"],"BOTTOMRIGHT",-43,-10) -- 锚点,想移动位置的改这里

-- Roll --
local roll = CreateFrame("Button", "rollMacro", UIParent, "SecureActionButtonTemplate")
roll:SetParent(chatbar)
roll:SetAttribute("type", "macro")
roll:SetAttribute("macrotext", "/roll")
roll:SetWidth(21)
roll:SetHeight(21)
roll:SetPoint("LEFT",chatbar,"LEFT",25,-12)
rollText = roll:CreateFontString("roll", "OVERLAY")
rollText:SetFont(STANDARD_TEXT_FONT, 15, "THINOUTLINE")
rollText:SetJustifyH("CENTER")
rollText:SetWidth(25)
rollText:SetHeight(25)
rollText:SetText("掷")
rollText:SetPoint("CENTER", 0, 0)
rollText:SetTextColor(123/255, 88/255, 255/255)
--roll.t = roll:CreateTexture()
--roll.t:SetAllPoints()
--roll.t:SetWidth(25)
--roll.t:SetHeight(25)
--roll.t:SetTexture("Interface\\Buttons\\UI-GroupLoot-Dice-Up")

-- StatReport --
local StatReportOut = CreateFrame("Button", "StatReportOutMacro", UIParent, "SecureActionButtonTemplate")
StatReportOut:SetParent(chatbar)
StatReportOut:SetAttribute("type", "macro")
StatReportOut:SetAttribute("macrotext", "/run ChatFrame_OpenChat(StatReport())")
StatReportOut:SetWidth(21)
StatReportOut:SetHeight(21)
StatReportOut:SetPoint("LEFT",roll,"RIGHT",0,0)
StatReportOutText = StatReportOut:CreateFontString("StatReportOut", "OVERLAY")
StatReportOutText:SetFont(STANDARD_TEXT_FONT, 15, "THINOUTLINE")
StatReportOutText:SetJustifyH("CENTER")
StatReportOutText:SetWidth(25)
StatReportOutText:SetHeight(25)
StatReportOutText:SetText("报")
StatReportOutText:SetPoint("CENTER", 0, 0)
StatReportOutText:SetTextColor(30/255, 144/255, 255/255)
--StatReportOut.t = StatReportOut:CreateTexture()
--StatReportOut.t:SetAllPoints()
--StatReportOut.t:SetWidth(25)
--StatReportOut.t:SetHeight(25)
--StatReportOut.t:SetTexture("Interface\\Buttons\\UI-GroupLoot-Dice-Up")

-- "喊(/y)" --
local ChannelYell = CreateFrame("Button", "ChannelYell", UIParent)
ChannelYell:SetParent(chatbar)
ChannelYell:SetWidth(21) 
ChannelYell:SetHeight(21) 
ChannelYell:SetPoint("LEFT",StatReportOut,"RIGHT",0,0) 
ChannelYell:RegisterForClicks("AnyUp")
ChannelYell:SetScript("OnClick", function() ChannelYell_OnClick() end)
ChannelYellText = ChannelYell:CreateFontString("ChannelYellText", "OVERLAY")
ChannelYellText:SetFont(STANDARD_TEXT_FONT, 15, "THINOUTLINE")
ChannelYellText:SetJustifyH("CENTER")
ChannelYellText:SetWidth(25)
ChannelYellText:SetHeight(25)
ChannelYellText:SetText("喊")
ChannelYellText:SetPoint("CENTER", 0, 0)
ChannelYellText:SetTextColor(255/255, 64/255, 64/255)
function ChannelYell_OnClick() ChatFrame_OpenChat("/y ", chatFrame) end

-- "说(/s)" --
local ChannelSay = CreateFrame("Button", "ChannelSay", UIParent)
ChannelSay:SetParent(chatbar)
ChannelSay:SetWidth(21)  -- 按钮宽度
ChannelSay:SetHeight(21)  -- 按钮高度
ChannelSay:SetPoint("LEFT",ChannelYell,"RIGHT",0,0)   -- 锚点
ChannelSay:RegisterForClicks("AnyUp")
ChannelSay:SetScript("OnClick", function() ChannelSay_OnClick() end)
ChannelSayText = ChannelSay:CreateFontString("ChannelSayText", "OVERLAY")
ChannelSayText:SetFont(STANDARD_TEXT_FONT, 15, "THINTHINOUTLINE") -- 字体设置
ChannelSayText:SetJustifyH("CENTER")
ChannelSayText:SetWidth(25)
ChannelSayText:SetHeight(25)
ChannelSayText:SetText("说") -- 显示的文字
ChannelSayText:SetPoint("CENTER", 0, 0)
ChannelSayText:SetTextColor(1,1,1) -- 颜色
function ChannelSay_OnClick() ChatFrame_OpenChat("/s ", chatFrame) end

-- "队伍(/p)" --
local ChannelParty = CreateFrame("Button", "ChannelParty", UIParent)
ChannelParty:SetParent(chatbar)
ChannelParty:SetWidth(21) 
ChannelParty:SetHeight(21) 
ChannelParty:SetPoint("LEFT",ChannelSay,"RIGHT",0,0) 
ChannelParty:RegisterForClicks("AnyUp")
ChannelParty:SetScript("OnClick", function() ChannelParty_OnClick() end)
ChannelPartyText = ChannelParty:CreateFontString("ChannelPartyText", "OVERLAY")
ChannelPartyText:SetFont(STANDARD_TEXT_FONT, 15, "THINOUTLINE")
ChannelPartyText:SetJustifyH("CENTER")
ChannelPartyText:SetWidth(25)
ChannelPartyText:SetHeight(25)
ChannelPartyText:SetText("队")
ChannelPartyText:SetPoint("CENTER", 0, 0)
ChannelPartyText:SetTextColor(170/255, 170/255, 255/255)
function ChannelParty_OnClick() ChatFrame_OpenChat("/p ", chatFrame) end

-- "团队通告(/rw)" --
local ChannelRaidWarns = CreateFrame("Button", "ChannelRaidWarns", UIParent)
ChannelRaidWarns:SetParent(chatbar)
ChannelRaidWarns:SetWidth(21) 
ChannelRaidWarns:SetHeight(21) 
ChannelRaidWarns:SetPoint("LEFT",ChannelParty,"RIGHT",0,0) 
ChannelRaidWarns:RegisterForClicks("AnyUp")
ChannelRaidWarns:SetScript("OnClick", function() ChannelRaidWarns_OnClick() end)
ChannelRaidWarnsText = ChannelRaidWarns:CreateFontString("ChannelRaidWarnsText", "OVERLAY")
ChannelRaidWarnsText:SetFont(STANDARD_TEXT_FONT, 15, "THINOUTLINE")
ChannelRaidWarnsText:SetJustifyH("CENTER")
ChannelRaidWarnsText:SetWidth(25)
ChannelRaidWarnsText:SetHeight(25)
ChannelRaidWarnsText:SetText("通")
ChannelRaidWarnsText:SetPoint("CENTER", 0, 0)
ChannelRaidWarnsText:SetTextColor(255/255, 69/255, 0) 
function ChannelRaidWarns_OnClick() ChatFrame_OpenChat("/rw ", chatFrame) end

-- "团队(/raid)" --
local ChannelRaid = CreateFrame("Button", "ChannelRaid", UIParent)
ChannelRaid:SetParent(chatbar)
ChannelRaid:SetWidth(21) 
ChannelRaid:SetHeight(21) 
ChannelRaid:SetPoint("LEFT",ChannelRaidWarns,"RIGHT",0,0) 
ChannelRaid:RegisterForClicks("AnyUp")
ChannelRaid:SetScript("OnClick", function() ChannelRaid_OnClick() end)
ChannelRaidText = ChannelRaid:CreateFontString("ChannelRaidText", "OVERLAY")
ChannelRaidText:SetFont(STANDARD_TEXT_FONT, 15, "THINOUTLINE")
ChannelRaidText:SetJustifyH("CENTER")
ChannelRaidText:SetWidth(25)
ChannelRaidText:SetHeight(25)
ChannelRaidText:SetText("团")
ChannelRaidText:SetPoint("CENTER", 0, 0)
ChannelRaidText:SetTextColor(255/255, 127/255, 0)
function ChannelRaid_OnClick() ChatFrame_OpenChat("/raid ", chatFrame) end

-- "副本(/i)" --
local ChannelBattleGround = CreateFrame("Button", "ChannelBattleGround", UIParent)
ChannelBattleGround:SetParent(chatbar)
ChannelBattleGround:SetWidth(21) 
ChannelBattleGround:SetHeight(21) 
ChannelBattleGround:SetPoint("LEFT",ChannelRaid,"RIGHT",0,0) 
ChannelBattleGround:RegisterForClicks("AnyUp")
ChannelBattleGround:SetScript("OnClick", function() ChannelBattleGround_OnClick() end)
ChannelBattleGroundText = ChannelBattleGround:CreateFontString("ChannelBattleGroundText", "OVERLAY")
ChannelBattleGroundText:SetFont(STANDARD_TEXT_FONT, 15, "THINOUTLINE")
ChannelBattleGroundText:SetJustifyH("CENTER")
ChannelBattleGroundText:SetWidth(25)
ChannelBattleGroundText:SetHeight(25)
ChannelBattleGroundText:SetText("副")
ChannelBattleGroundText:SetPoint("CENTER", 0, 0)
ChannelBattleGroundText:SetTextColor(255/255, 127/255, 0)
function ChannelBattleGround_OnClick() ChatFrame_OpenChat("/i ", chatFrame) end

-- "公会(/g)" --
local ChannelGuild = CreateFrame("Button", "ChannelGuild", UIParent)
ChannelGuild:SetParent(chatbar)
ChannelGuild:SetWidth(21) 
ChannelGuild:SetHeight(21) 
ChannelGuild:SetPoint("LEFT",ChannelBattleGround,"RIGHT",0,0) 
ChannelGuild:RegisterForClicks("AnyUp")
ChannelGuild:SetScript("OnClick", function() ChannelGuild_OnClick() end)
ChannelGuildText = ChannelGuild:CreateFontString("ChannelGuildText", "OVERLAY")
ChannelGuildText:SetFont(STANDARD_TEXT_FONT, 15, "THINOUTLINE")
ChannelGuildText:SetJustifyH("CENTER")
ChannelGuildText:SetWidth(25)
ChannelGuildText:SetHeight(25)
ChannelGuildText:SetText("公")
ChannelGuildText:SetPoint("CENTER", 0, 0)
ChannelGuildText:SetTextColor(64/255, 255/255, 64/255)
function ChannelGuild_OnClick() ChatFrame_OpenChat("/g ", chatFrame) end

-- 加入/离开大脚世界频道
if GetLocale() == "zhCN" then
local BF = CreateFrame("Button", "BF", UIParent)
BF:SetParent(chatbar)
BF:SetWidth(21) 
BF:SetHeight(21) 
BF:SetPoint("LEFT",ChannelGuild,"RIGHT",0,0)
BF:RegisterForClicks("AnyUp")
BF:RegisterEvent("PLAYER_LOGIN")
BF:RegisterEvent("CHANNEL_UI_UPDATE") 
BF:SetScript("OnEvent", function()
	local channels, BFname, inWorldChannel, order = {GetChannelList()}, "大脚世界频道"
	for i = 1, #channels do
		if channels[i] == BFname then
			inWorldChannel = true
			order = channels[i-1]
		end
	end
	BF:SetScript("OnMouseUp", function(self, button)
		if inWorldChannel then
			if button == "RightButton" then
				LeaveChannelByName(BFname)
				print("<<<|cffFF7F50"..QUIT.."世界頻道|r")
				inWorldChannel = false
			else
				ChatFrame_OpenChat("/"..order, chatFrame)
			end
		else
			JoinPermanentChannel(BFname,nil,1)
			ChatFrame_AddChannel(ChatFrame1,BFname)
			print(">>>|cff00C957"..JOIN.."世界頻道|r")
			inWorldChannel = true
		end
	end)
end)

BFText = BF:CreateFontString("BFText", "OVERLAY")
BFText:SetFont(STANDARD_TEXT_FONT, 15, "THINOUTLINE")
BFText:SetJustifyH("CENTER")
BFText:SetWidth(25)
BFText:SetHeight(25)
BFText:SetText("世")
BFText:SetPoint("CENTER", 0, 0)
BFText:SetTextColor(255/255, 200/255, 150/255)
end

-------------------------------------------
-----------     ChatEmote     ----------
-------------------------------------------
local math,table,string,pairs,type,select,tonumber,floor,unpack=math,table,string,pairs,type,select,tonumber,floor,unpack
local _

local GameTooltip=GameTooltip
local GetCurrentResolution=GetCurrentResolution
local GetScreenResolutions=GetScreenResolutions
local ChatEdit_ChooseBoxForSend=ChatEdit_ChooseBoxForSend

local Emote_Panel_STRING_1="表情面板"
local Emote_Panel_STRING_2="<按住Ctrl拖动>"
local Locale={
    ["Angel"]="天使",
    ["Angry"]="生气",
    ["Biglaugh"]="大笑",
    ["Clap"]="鼓掌",
    ["Cool"]="酷",
    ["Cry"]="哭",
    ["Cute"]="可爱",
    ["Despise"]="鄙视",
    ["Dreamsmile"]="美梦",
    ["Embarras"]="尴尬",
    ["Evil"]="邪恶",
    ["Excited"]="兴奋",
    ["Faint"]="晕",
    ["Fight"]="打架",
    ["Flu"]="流感",
    ["Freeze"]="呆",
    ["Frown"]="皱眉",
    ["Greet"]="致敬",
    ["Grimace"]="鬼脸",
    ["Growl"]="龇牙",
    ["Happy"]="开心",
    ["Heart"]="心",
    ["Horror"]="恐惧",
    ["Ill"]="生病",
    ["Innocent"]="无辜",
    ["Kongfu"]="功夫",
    ["Love"]="花痴",
    ["Mail"]="邮件",
    ["Makeup"]="化妆",
    ["Mario"]="马里奥",
    ["Meditate"]="沉思",
    ["Miserable"]="可怜",
    ["Okay"]="好",
    ["Pretty"]="漂亮",
    ["Puke"]="吐",
    ["Shake"]="握手",
    ["Shout"]="喊",
    ["Silent"]="闭嘴",
    ["Shy"]="害羞",
    ["Sleep"]="睡觉",
    ["Smile"]="微笑",
    ["Suprise"]="吃惊",
    ["Surrender"]="失败",
    ["Sweat"]="流汗",
    ["Tear"]="流泪",
    ["Tears"]="悲剧",
    ["Think"]="想",
    ["Titter"]="偷笑",
    ["Ugly"]="猥琐",
    ["Victory"]="胜利",
    ["Volunteer"]="雷锋",
    ["Wronged"]="委屈",
	 ["rt1"]="星星", 
	 ["rt2"]="大饼", 
	 ["rt3"]="菱形", 
	 ["rt4"]="三角", 
	 ["rt5"]="月亮", 
	 ["rt6"]="方块", 
	 ["rt7"]="叉叉", 
	 ["rt8"]="骷髅", 
}
------------------------------------------------------------------------------------------------
local Emote_CallButton
local Emote_Index2Path={}
local Emote_IconTable={}
Emote_IconSize=0.9
local Emote_IconTable={
		{Locale["rt1"],"Interface\\TargetingFrame\\UI-RaidTargetingIcon_1"},
        {Locale["rt2"],"Interface\\TargetingFrame\\UI-RaidTargetingIcon_2"},
        {Locale["rt3"],"Interface\\TargetingFrame\\UI-RaidTargetingIcon_3"},
        {Locale["rt4"],"Interface\\TargetingFrame\\UI-RaidTargetingIcon_4"},
        {Locale["rt5"],"Interface\\TargetingFrame\\UI-RaidTargetingIcon_5"},
        {Locale["rt6"],"Interface\\TargetingFrame\\UI-RaidTargetingIcon_6"},
        {Locale["rt7"],"Interface\\TargetingFrame\\UI-RaidTargetingIcon_7"},
        {Locale["rt8"],"Interface\\TargetingFrame\\UI-RaidTargetingIcon_8"},
        {Locale["Angel"],"Interface\\AddOns\\bChat\\icon\\angel.blp"},
        {Locale["Angry"],"Interface\\AddOns\\bChat\\icon\\angry.blp"},
        {Locale["Biglaugh"],"Interface\\AddOns\\bChat\\icon\\biglaugh.blp"},
        {Locale["Clap"],"Interface\\AddOns\\bChat\\icon\\clap.blp"},
        {Locale["Cool"],"Interface\\AddOns\\bChat\\icon\\cool.blp"},
        {Locale["Cry"],"Interface\\AddOns\\bChat\\icon\\cry.blp"},
        {Locale["Cute"],"Interface\\AddOns\\bChat\\icon\\cutie.blp"},
        {Locale["Despise"],"Interface\\AddOns\\bChat\\icon\\despise.blp"},
        {Locale["Dreamsmile"],"Interface\\AddOns\\bChat\\icon\\dreamsmile.blp"},
        {Locale["Embarras"],"Interface\\AddOns\\bChat\\icon\\embarrass.blp"},
        {Locale["Evil"],"Interface\\AddOns\\bChat\\icon\\evil.blp"},
        {Locale["Excited"],"Interface\\AddOns\\bChat\\icon\\excited.blp"},
        {Locale["Faint"],"Interface\\AddOns\\bChat\\icon\\faint.blp"},
        {Locale["Fight"],"Interface\\AddOns\\bChat\\icon\\fight.blp"},
        {Locale["Flu"],"Interface\\AddOns\\bChat\\icon\\flu.blp"},
        {Locale["Freeze"],"Interface\\AddOns\\bChat\\icon\\freeze.blp"},
        {Locale["Frown"],"Interface\\AddOns\\bChat\\icon\\frown.blp"},
        {Locale["Greet"],"Interface\\AddOns\\bChat\\icon\\greet.blp"},
        {Locale["Grimace"],"Interface\\AddOns\\bChat\\icon\\grimace.blp"},
        {Locale["Growl"],"Interface\\AddOns\\bChat\\icon\\growl.blp"},
        {Locale["Happy"],"Interface\\AddOns\\bChat\\icon\\happy.blp"},
        {Locale["Heart"],"Interface\\AddOns\\bChat\\icon\\heart.blp"},
        {Locale["Horror"],"Interface\\AddOns\\bChat\\icon\\horror.blp"},
        {Locale["Ill"],"Interface\\AddOns\\bChat\\icon\\ill.blp"},
        {Locale["Innocent"],"Interface\\AddOns\\bChat\\icon\\innocent.blp"},
        {Locale["Kongfu"],"Interface\\AddOns\\bChat\\icon\\kongfu.blp"},
        {Locale["Love"],"Interface\\AddOns\\bChat\\icon\\love.blp"},
        {Locale["Mail"],"Interface\\AddOns\\bChat\\icon\\mail.blp"},
        {Locale["Makeup"],"Interface\\AddOns\\bChat\\icon\\makeup.blp"},
        {Locale["Mario"],"Interface\\AddOns\\bChat\\icon\\mario.blp"},
        {Locale["Meditate"],"Interface\\AddOns\\bChat\\icon\\meditate.blp"},
        {Locale["Miserable"],"Interface\\AddOns\\bChat\\icon\\miserable.blp"},
        {Locale["Okay"],"Interface\\AddOns\\bChat\\icon\\okay.blp"},
        {Locale["Pretty"],"Interface\\AddOns\\bChat\\icon\\pretty.blp"},
        {Locale["Puke"],"Interface\\AddOns\\bChat\\icon\\puke.blp"},
        {Locale["Shake"],"Interface\\AddOns\\bChat\\icon\\shake.blp"},
        {Locale["Shout"],"Interface\\AddOns\\bChat\\icon\\shout.blp"},
        {Locale["Silent"],"Interface\\AddOns\\bChat\\icon\\shuuuu.blp"},
        {Locale["Shy"],"Interface\\AddOns\\bChat\\icon\\shy.blp"},
        {Locale["Sleep"],"Interface\\AddOns\\bChat\\icon\\sleep.blp"},
        {Locale["Smile"],"Interface\\AddOns\\bChat\\icon\\smile.blp"},
        {Locale["Suprise"],"Interface\\AddOns\\bChat\\icon\\suprise.blp"},
        {Locale["Surrender"],"Interface\\AddOns\\bChat\\icon\\surrender.blp"},
        {Locale["Sweat"],"Interface\\AddOns\\bChat\\icon\\sweat.blp"},
        {Locale["Tear"],"Interface\\AddOns\\bChat\\icon\\tear.blp"},
        {Locale["Tears"],"Interface\\AddOns\\bChat\\icon\\tears.blp"},
        {Locale["Think"],"Interface\\AddOns\\bChat\\icon\\think.blp"},
        {Locale["Titter"],"Interface\\AddOns\\bChat\\icon\\titter.blp"},
        {Locale["Ugly"],"Interface\\AddOns\\bChat\\icon\\ugly.blp"},
        {Locale["Victory"],"Interface\\AddOns\\bChat\\icon\\victory.blp"},
        {Locale["Volunteer"],"Interface\\AddOns\\bChat\\icon\\volunteer.blp"},
        {Locale["Wronged"],"Interface\\AddOns\\bChat\\icon\\wronged.blp"},
    }

local Emote_ICON_TAG_LIST={
        {strlower(ICON_TAG_RAID_TARGET_STAR1),"Interface\\TargetingFrame\\UI-RaidTargetingIcon_1"},
        {strlower(ICON_TAG_RAID_TARGET_STAR2),"Interface\\TargetingFrame\\UI-RaidTargetingIcon_1"},
        {strlower(ICON_TAG_RAID_TARGET_CIRCLE1),"Interface\\TargetingFrame\\UI-RaidTargetingIcon_2"},
        {strlower(ICON_TAG_RAID_TARGET_CIRCLE2),"Interface\\TargetingFrame\\UI-RaidTargetingIcon_2"},
        {strlower(ICON_TAG_RAID_TARGET_DIAMOND1),"Interface\\TargetingFrame\\UI-RaidTargetingIcon_3"},
        {strlower(ICON_TAG_RAID_TARGET_DIAMOND2),"Interface\\TargetingFrame\\UI-RaidTargetingIcon_3"},
        {strlower(ICON_TAG_RAID_TARGET_TRIANGLE1),"Interface\\TargetingFrame\\UI-RaidTargetingIcon_4"},
        {strlower(ICON_TAG_RAID_TARGET_TRIANGLE2),"Interface\\TargetingFrame\\UI-RaidTargetingIcon_4"},
        {strlower(ICON_TAG_RAID_TARGET_MOON1),"Interface\\TargetingFrame\\UI-RaidTargetingIcon_5"},
        {strlower(ICON_TAG_RAID_TARGET_MOON2),"Interface\\TargetingFrame\\UI-RaidTargetingIcon_5"},
        {strlower(ICON_TAG_RAID_TARGET_SQUARE1),"Interface\\TargetingFrame\\UI-RaidTargetingIcon_6"},
        {strlower(ICON_TAG_RAID_TARGET_SQUARE2),"Interface\\TargetingFrame\\UI-RaidTargetingIcon_6"},
        {strlower(ICON_TAG_RAID_TARGET_CROSS1),"Interface\\TargetingFrame\\UI-RaidTargetingIcon_7"},
        {strlower(ICON_TAG_RAID_TARGET_CROSS2),"Interface\\TargetingFrame\\UI-RaidTargetingIcon_7"},
        {strlower(ICON_TAG_RAID_TARGET_SKULL1),"Interface\\TargetingFrame\\UI-RaidTargetingIcon_8"},
        {strlower(ICON_TAG_RAID_TARGET_SKULL2),"Interface\\TargetingFrame\\UI-RaidTargetingIcon_8"},
        {strlower(RAID_TARGET_1),"Interface\\TargetingFrame\\UI-RaidTargetingIcon_1"},
        {strlower(RAID_TARGET_2),"Interface\\TargetingFrame\\UI-RaidTargetingIcon_2"},
        {strlower(RAID_TARGET_3),"Interface\\TargetingFrame\\UI-RaidTargetingIcon_3"},
        {strlower(RAID_TARGET_4),"Interface\\TargetingFrame\\UI-RaidTargetingIcon_4"},
        {strlower(RAID_TARGET_5),"Interface\\TargetingFrame\\UI-RaidTargetingIcon_5"},
        {strlower(RAID_TARGET_6),"Interface\\TargetingFrame\\UI-RaidTargetingIcon_6"},
        {strlower(RAID_TARGET_7),"Interface\\TargetingFrame\\UI-RaidTargetingIcon_7"},
        {strlower(RAID_TARGET_8),"Interface\\TargetingFrame\\UI-RaidTargetingIcon_8"},
    }
	for k,v in pairs(Emote_ICON_TAG_LIST) do
		Emote_Index2Path["{"..v[1].."}"]=v[2]
 	end

	for k,v in pairs(Emote_IconTable) do
  	    Emote_Index2Path["{"..v[1].."}"]=v[2]
 	end
------------------------------------------------------------------------------------------------
local function IconSize(f)
 	local _,font=f:GetFont()
  local h = GetScreenHeight();
 	font=Emote_IconSize*font*h/500
 	font=floor(font)
 	return font
end
------------------------------------------------------------------------------------------------
local function Emote_SendChatMessage_Filter(text)
	for s in string.gmatch(text,"\124T([^:]+):%d+\124t") do
  		local index
		for k,v in pairs(Emote_Index2Path) do
		    if v==s then
			    index=k
			end
		end
		if index then
   			text=string.gsub(text,"(\124T[^:]+:%d+\124t)",index,1)
  		end
 	end
 	return text
end

local function Emote_AddMessage_Filter(self,text)
	for s in string.gmatch(text,"({[^}]+})") do
  		if (Emote_Index2Path[s]) then text=string.gsub(text,s,"\124T"..Emote_Index2Path[s] ..":"..IconSize(self).."\124t",1) end
 	end return text
end

local _xSendChatMessage=SendChatMessage
local _xBNSendWhisper=BNSendWhisper
local _xBNSendConversationMessage=BNSendConversationMessage
	for i=1,NUM_CHAT_WINDOWS do
		if i~=2 then
			local f=getglobal("ChatFrame"..i)
			f._xAddMessage=f.AddMessage
			f.AddMessage=function(self,text,...)
			        text=Emote_AddMessage_Filter(self,text) self:_xAddMessage(text,...)
			    end
		end
	end
	_xSendChatMessage=SendChatMessage
	_G["SendChatMessage"]=function(text,...) text=Emote_SendChatMessage_Filter(text) _xSendChatMessage(text,...) end
	_xBNSendWhisper=BNSendWhisper
	_G["BNSendWhisper"]=function(presenceID,text) text=Emote_SendChatMessage_Filter(text) _xBNSendWhisper(presenceID,text) end
	_xBNSendConversationMessage=BNSendConversationMessage
	_G["BNSendConversationMessage"]=function(target,text) text=Emote_SendChatMessage_Filter(text) _xBNSendConversationMessage(target,text) end

 	Emote_CallButton=CreateFrame("Button","Emote_CallButton",UIParent)
 	Emote_CallButton:SetWidth(21)
 	Emote_CallButton:SetHeight(21)
 	--Emote_CallButton:SetNormalTexture("Interface\\AddOns\\ShiGuang\\media\\icon\\text_nor_icon")
 	--Emote_CallButton:SetPushedTexture("Interface\\AddOns\\ShiGuang\\media\\icon\\text_push_icon")
 	--Emote_CallButton:SetHighlightTexture("Interface\\Buttons\\CheckButtonHilight")
 	--Emote_CallButton:GetHighlightTexture():SetBlendMode("ADD")
 	Emote_CallButton.text = Emote_CallButton:CreateFontString(nil, 'OVERLAY')
	Emote_CallButton.text:SetFont(STANDARD_TEXT_FONT, 15, "OUTLINE")
	Emote_CallButton.text:SetPoint("CENTER", 0, 0)
	Emote_CallButton.text:SetText("表情")
	Emote_CallButton.text:SetTextColor(23/255, 132/255, 209/255)	
	Emote_CallButton:SetAlpha(0.8)
	Emote_CallButton:SetFrameLevel(32)
	Emote_CallButton:SetMovable(true)
	Emote_CallButton:EnableMouse(true)
	Emote_CallButton:RegisterForClicks("LeftButtonUp","RightButtonUp")
 	Emote_CallButton:RegisterForDrag("LeftButton","RightButton")
	Emote_CallButton:ClearAllPoints()
 	Emote_CallButton:SetPoint("RIGHT",roll,"LEFT",-12,0)
 	Emote_CallButton:SetScript("OnClick",function(self) if Emote_IconPanel:IsShown() then Emote_IconPanel:Hide() else Emote_IconPanel:Show() end if GameTooltip:GetOwner()==self then GameTooltip:Hide() end end)
 	Emote_CallButton:SetScript("OnDragStart",function(self) if self:IsMovable() and IsControlKeyDown() then self:StartMoving() end end)
 	Emote_CallButton:SetScript("OnDragStop",function(self) if self:IsMovable() then self:StopMovingOrSizing()  end  end)
 	Emote_CallButton:SetScript("OnEnter",function(self) GameTooltip:SetOwner(self,"ANCHOR_TOPRIGHT")  GameTooltip:AddLine(Emote_Panel_STRING_1)  GameTooltip:AddLine(Emote_Panel_STRING_2) GameTooltip:AddLine(Emote_Panel_STRING_3) GameTooltip:Show() Emote_IconPanel.isCounting=nil end)
 	Emote_CallButton:SetScript("OnLeave",function(self) if GameTooltip:GetOwner()==self then GameTooltip:Hide() end Emote_IconPanel.showTimer=1.0 Emote_IconPanel.isCounting=1 end)
	Emote_CallButton:Show()

	Emote_IconPanel=CreateFrame("Frame","Emote_IconPanel",UIParent)
  	Emote_IconPanel:SetWidth(260)
 	Emote_IconPanel:SetHeight(160)
 	Emote_IconPanel:SetFrameLevel(32)
 	Emote_IconPanel:SetMovable(true)
 	Emote_IconPanel:EnableMouse(true)
 	Emote_IconPanel:Hide()
 	Emote_IconPanel:ClearAllPoints()
 	Emote_IconPanel:SetPoint("BOTTOMLEFT",Emote_CallButton,"TOPRIGHT",0,0)
 	Emote_IconPanel:SetBackdrop({bgFile="Interface\\Tooltips\\UI-Tooltip-Background",edgeFile="Interface\\Tooltips\\UI-Tooltip-Border",tile=true,tileSize=12,edgeSize=7,insets={left=4,right=4,top=4,bottom=4}})
 	Emote_IconPanel:SetBackdropColor(0,0,0)
 	Emote_IconPanel.showTimer=0
 	Emote_IconPanel:SetScript("OnUpdate",function(self,elapsed)
									if (not self.isCounting) then return
                  elseif (self.showTimer<=0) then
                                     self:Hide()
                                     self.showTimer=nil
                                     self.isCounting=nil
                   else self.showTimer=self.showTimer-elapsed end
								   end)
 	Emote_IconPanel:SetScript("OnEnter",function(self) self.isCounting=nil end)
 	Emote_IconPanel:SetScript("OnLeave",function(self) self.showTimer=1.0 self.isCounting=1 end)
	Emote_IconPanel.IconList={}
	Emote_IconPanel:SetScript("OnShow",function(self) for k,v in pairs(self.IconList) do v:Show() end end)
	Emote_IconPanel:SetScript("OnHide",function(self) for k,v in pairs(self.IconList) do v:Hide() end end)

 	local px=1
 	local py=1
 	for k,v in pairs(Emote_IconTable) do
		local b=CreateFrame("Button","Emote_Icon"..k,Emote_IconPanel)
    	b:Hide()
     	b:Show()
 	    b:EnableMouse(true)
 	    b:SetWidth(23)
 	    b:SetHeight(23)
 	    b.text=v[1]
 	    b.texture=v[2]
 	    b:SetNormalTexture(v[2])
 	    b:SetHighlightTexture("Interface\\Buttons\\UI-Common-MouseHilight")
 	    b:GetHighlightTexture():SetBlendMode("ADD")
 	    b:SetFrameLevel(35)
 	    b:ClearAllPoints()
		b.parent=Emote_IconPanel
 	    b:SetPoint("TOPLEFT",Emote_IconPanel,"TOPLEFT",(px-1)*25+5,(1-py)*25-5)
 	    b:SetScript("OnClick",function(self)
                                    local editBox=ChatEdit_ChooseBoxForSend()
                                    editBox:Show()
                                    editBox:SetFocus()
                                    editBox:Insert("\124T"..self.texture..":"..IconSize(SELECTED_CHAT_FRAME).."\124t")
                                    self.parent:Hide()
                                  end)
 	    b:SetScript("OnEnter",function(self)
                                    GameTooltip:SetOwner(self.parent,"ANCHOR_TOPLEFT")
                                    GameTooltip:SetText(self.text)
                                    GameTooltip:Show()
									self.parent.isCounting=nil
                                 end)
 	    b:SetScript("OnLeave",function(self)
                                    if GameTooltip:GetOwner()==self.parent then GameTooltip:Hide() end
                                    self.parent.showTimer=1.0
                                    self.parent.isCounting=1
								end)

  	    Emote_IconPanel.IconList[k]=b
  	    px=px+1
  	    if px>=11 then
   	    	px=1
   		    py=py+1
  	    end
 	end

	Locale=nil
	Emote_IconTable=nil
	Emote_ICON_TAG_LIST=nil


--[[--------------------------------------------------------------------
	ChatLinkTooltips	Written by Junxx EU-Khaz'goroth <addons@colordesigns.de>
----------------------------------------------------------------------]]
local supportedType = { item = true, achievement = true, spell = true, quest = true, enchant = true, glyph = true, unit = true, talent = true, }
local CompareShowing

local ChatLinkTooltips = CreateFrame("Frame")
ChatLinkTooltips:RegisterEvent("MODIFIER_STATE_CHANGED")
ChatLinkTooltips:SetScript("OnEvent", function(self, event, key, state)
	if CompareShowing and (key == "LSHIFT" or key == "RSHIFT") and not GameTooltip:IsEquippedItem() then
		if state == 1 then
			GameTooltip_ShowCompareItem(GameTooltip)
		else
			ShoppingTooltip1:Hide()
			ShoppingTooltip2:Hide()
		end
	end
end)
local function OnHyperlinkEnter(self, linkData, link)
	local linkType = strmatch(linkData, "^([^:]+)")
	if linkType and supportedType[linkType] then
		GameTooltip:SetOwner(self, "ANCHOR_TOPLEFT")
		GameTooltip:SetHyperlink(linkData)
		CompareShowing = true
	end
end
local function OnHyperlinkLeave(self, linkData, link)
	GameTooltip:Hide()
	CompareShowing = nil
end
for i = 1, NUM_CHAT_WINDOWS do
	local frame = _G["ChatFrame"..i]
	frame:SetScript("OnHyperlinkEnter", OnHyperlinkEnter)
	frame:SetScript("OnHyperlinkLeave", OnHyperlinkLeave)
end


--[[--------------------------------------------------------------------
align
----------------------------------------------------------------------]]
SLASH_EA1 = "/align"
local AlignFrame
SlashCmdList["EA"] = function()
	if AlignFrame then
		AlignFrame:Hide()
		AlignFrame = nil		
	else
		AlignFrame = CreateFrame('Frame', nil, UIParent) 
		AlignFrame:SetAllPoints(UIParent)
		local AlignWide = GetScreenWidth() / 64
		local AlignHeight = GetScreenHeight() / 36
		for i = 0, 64 do
			local AlignTFrame = AlignFrame:CreateTexture(nil, 'BACKGROUND')
			if i == 32 then AlignTFrame:SetColorTexture(1, 0, 0, 0.5) else AlignTFrame:SetColorTexture(0, 0, 0, 0.5) end
			AlignTFrame:SetPoint('TOPLEFT', AlignFrame, 'TOPLEFT', i * AlignWide - 1, 0)
			AlignTFrame:SetPoint('BOTTOMRIGHT', AlignFrame, 'BOTTOMLEFT', i * AlignWide + 1, 0)
		end
		for i = 0, 36 do
			local AlignTFrame = AlignFrame:CreateTexture(nil, 'BACKGROUND')
			if i == 18 then AlignTFrame:SetColorTexture(1, 0, 0, 0.5)
			else AlignTFrame:SetColorTexture(0, 0, 0, 0.5) end
			AlignTFrame:SetPoint('TOPLEFT', AlignFrame, 'TOPLEFT', 0, -i * AlignHeight + 1)
			AlignTFrame:SetPoint('BOTTOMRIGHT', AlignFrame, 'TOPRIGHT', 0, -i * AlignHeight - 1)
		end	
	end
end

--[[--------------------------------------------------------------------
SlashIn
----------------------------------------------------------------------]]
local addonName, SlashIn = ...
LibStub("AceTimer-3.0"):Embed(SlashIn)

local print = print
local tonumber = tonumber
local MacroEditBox = MacroEditBox
local MacroEditBox_OnEvent = MacroEditBox:GetScript("OnEvent")

local function OnCallback(command) MacroEditBox_OnEvent(MacroEditBox, "EXECUTE_CHAT_LINE", command) end

SLASH_SLASHIN_IN1 = "/in"
SLASH_SLASHIN_IN2 = "/slashin"

function SlashCmdList.SLASHIN_IN(msg)
	local secs, command = msg:match("^([^%s]+)%s+(.*)$")
	secs = tonumber(secs)
	if (not secs) or (#command == 0) then
		print("usage:\n /in <seconds> <command>")
		print("example:\n /in 1.5 /say hi")
	else
		SlashIn:ScheduleTimer(OnCallback, secs, command)
	end
end


-------------------------------------ChatAtFriends.lua
-- 輸入框首字@可快捷密好友
-------------------------------------

--職業顔色值
local LOCAL_CLASS_INFO = {}

do
    local localClass, class
    for i = 1, GetNumClasses() do
        localClass, class = GetClassInfo(i)
        LOCAL_CLASS_INFO[localClass] = RAID_CLASS_COLORS[class] or NORMAL_FONT_COLOR
        LOCAL_CLASS_INFO[localClass].class = class
    end
end
--按鈕數量
local numButton = 16
--創建信息框
do
    local function onclick(self)
        local parent = self:GetParent()
        local editBox = ChatEdit_GetLastActiveWindow()
        if (self.dataIsBNet) then
            editBox:SetAttribute("chatType", "BN_WHISPER")
            editBox:SetAttribute("tellTarget", self.dataBName)
        else
            editBox:SetAttribute("chatType", "WHISPER")
            editBox:SetAttribute("tellTarget", self.dataName)
        end
        ChatEdit_UpdateHeader(editBox)
        editBox:SetText(strsub(editBox:GetText(),parent.editPos+1))
        parent:Hide()
    end
    local function createButton(parent, index)
        local button = CreateFrame("Button", "ChatAtFriendsFrameButton"..index, parent)
        button:SetHighlightTexture("Interface\\Buttons\\UI-Common-MouseHilight", "ADD")
        button:SetID(index)
        button:SetHeight(26)
        button:SetWidth(128)
        button:SetScript("OnClick", onclick)
        if (index == 1) then
            button:SetPoint("TOP", parent, "TOP", 2, -12)
        else
            button:SetPoint("TOP", _G["ChatAtFriendsFrameButton"..(index-1)], "BOTTOM", 0, -6)
        end
        button.icon = button:CreateTexture(nil, "BORDER")
        button.icon:SetSize(20, 20)
        button.icon:SetPoint("LEFT", 8, 0)
        button.icon:SetTexture("Interface\\TargetingFrame\\UI-Classes-Circles")
        button.name = button:CreateFontString(nil, "ARTWORK")
        button.name:SetFont(UNIT_NAME_FONT, 13, "OUTLINE")
        button.name:SetPoint("TOPLEFT", button, "TOPLEFT", 30, 0)
        button.name:SetJustifyH("LEFT")
        button.name:SetSize(90, 18)
        button.area = button:CreateFontString(nil, "ARTWORK")
        button.area:SetFont(GameFontNormal:GetFont(), 9, "NORMAL")
        button.area:SetPoint("BOTTOMLEFT", button, "BOTTOMLEFT", 30, 0)
        button.area:SetJustifyH("LEFT")
        button.area:SetSize(90, 12)
        button.area:SetTextColor(1, 0.82, 0, 0.8)
        button.level = button:CreateFontString(nil, "ARTWORK")
        button.level:SetFont(GameFontNormal:GetFont(), 9, "OUTLINE")
        button.level:SetPoint("LEFT", -2, -6)
        button.level:SetSize(40, 40)
        button.level:SetTextColor(1, 0.82, 0)
    end
    local frame = CreateFrame("Frame", "ChatAtFriendsFrame", UIParent)
    frame:Hide()
    frame:SetClampedToScreen(true)
    frame:SetFrameStrata("DIALOG")
    frame:SetSize(136, 500)
    frame:SetBackdrop({
        bgFile   = "Interface\\Tooltips\\UI-Tooltip-Background",
        edgeFile = "Interface\\Tooltips\\UI-Tooltip-Border", tile = true, tileSize = 8, edgeSize = 8,
        insets   = { left = 2, right = 2, top = 2, bottom = 2 }
    })
    frame:SetBackdropColor(0, 0, 0)
    frame:SetBackdropBorderColor(1, 1, 1, 0.8)
    for i = 1, numButton do createButton(frame, i) end
end
--獲取好友信息
local function ListFriends(text)
    local friends = {}
    local accountName, bnetIDGameAccount, client
    local name, level, class, area, faction, _
    --本服好友
    local numWoWTotal, numWoWOnline = GetNumFriends()
    if (numWoWOnline > 0) then
        faction = UnitFactionGroup("player")
        for id = 1, numWoWOnline do
            name, level, class, area = GetFriendInfo(id)
            tinsert(friends, { name = name, level = level, class = class, area = area, faction = faction, isBNet = false, })
        end
    end
    --戰網好友
    local numBNetTotal, numBNetOnline = BNGetNumFriends()
    if (numBNetOnline > 0) then
        for id = 1, numBNetOnline do
            _, accountName, _, _, _, bnetIDGameAccount, client = BNGetFriendInfo(id)
            if (client == "WoW" and bnetIDGameAccount) then
                _, name, _, _, _, faction, _, class, _, area, level = BNGetGameAccountInfo(bnetIDGameAccount)
                tinsert(friends, { bname = accountName, name = name, level = level, class = class, area = area, faction = faction, isBNet = true, })
            end
        end
    end
    --好友太多的話自動啓用關鍵字匹配
    if (#friends > numButton) then
        text = text:gsub("@", "")
        if (text ~= "") then
            local t = {}
            for _, v in ipairs(friends) do
                if (strfind(v.name, text)) then
                    tinsert(t, v)
                end
            end
            if (#t > 0) then friends = t end
        end
    end

    return friends
end
--顯示好友信息框
local function ChatAtFriendsFrame_Show(self, text)
    local friends = ListFriends(text)
    local faction = UnitFactionGroup("player")
    local position = self.GetCursorPosition and self:GetCursorPosition() or 0
    local button, info
    local index = 1
    if (#friends == 0) then return ChatAtFriendsFrame:Hide() end
    while (friends[index] and index <= numButton) do
        info = LOCAL_CLASS_INFO[friends[index].class]
        button = _G["ChatAtFriendsFrameButton"..index]
        button.name:SetText(friends[index].name)
        button.area:SetText(friends[index].area)
        button.level:SetText(friends[index].level)
		button.name:SetTextColor(info.r, info.g, info.b)
        if (faction == friends[index].faction) then
            button.icon:SetTexture("Interface\\TargetingFrame\\UI-Classes-Circles")
            button.icon:SetTexCoord(unpack(CLASS_ICON_TCOORDS[info.class]))
        else
            button.icon:SetTexture("Interface\\TargetingFrame\\UI-PVP-"..friends[index].faction)
            button.icon:SetTexCoord(0, 44/64, 0, 44/64)
        end
        button.dataName = friends[index].name
        button.dataIsBNet = friends[index].isBNet
        button.dataBName = friends[index].bname
        button:Show()
        index = index + 1
    end
    ChatAtFriendsFrame:SetHeight((index-1)*32+20)
    while (_G["ChatAtFriendsFrameButton"..index]) do
        _G["ChatAtFriendsFrameButton"..index]:Hide()
        index = index + 1
    end
    ChatAtFriendsFrame.editPos = position
    ChatAtFriendsFrame:SetPoint("BOTTOMLEFT", self, "TOPLEFT", position*8+40, -4)
    ChatAtFriendsFrame:Show()
end
--隱藏好友信息框
local function ChatAtFriendsFrame_Hide() ChatAtFriendsFrame:Hide() end
--功能附到聊天框 多于3字不顯示
hooksecurefunc("ChatEdit_OnTextChanged", function(self, userInput)
    local text = self:GetText()
    if (userInput) then
        if (strfind(text, "^%s*@%w-") and self:GetUTF8CursorPosition() <= 4) then
            ChatAtFriendsFrame_Show(self, text)
        else
            ChatAtFriendsFrame_Hide()
        end
    end
end)
hooksecurefunc("ChatEdit_OnEditFocusLost", function(self) ChatAtFriendsFrame_Hide() end)
hooksecurefunc("ChatEdit_OnEscapePressed", function(self) ChatAtFriendsFrame_Hide() end)