/*
 * Decompiled with CFR 0.152.
 */
package cpw.mods.fml.common.patcher;

import LZMA.LzmaInputStream;
import com.google.common.base.Joiner;
import com.google.common.base.Throwables;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ListMultimap;
import com.google.common.io.ByteArrayDataInput;
import com.google.common.io.ByteStreams;
import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.common.patcher.ClassPatch;
import cpw.mods.fml.relauncher.FMLRelaunchLog;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.repackage.com.nothome.delta.GDiffPatcher;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Locale;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import java.util.jar.JarOutputStream;
import java.util.jar.Pack200;
import java.util.logging.Level;
import java.util.regex.Pattern;

public class ClassPatchManager {
    public static final ClassPatchManager INSTANCE = new ClassPatchManager();
    private GDiffPatcher patcher = new GDiffPatcher();
    private ListMultimap<String, ClassPatch> patches;

    private ClassPatchManager() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] applyPatch(String name, String mappedName, byte[] inputData) {
        if (this.patches == null) {
            return inputData;
        }
        List list = this.patches.get((Object)name);
        if (list.isEmpty()) {
            return inputData;
        }
        for (ClassPatch patch : list) {
            if (!patch.targetClassName.equals(mappedName)) {
                FMLLog.warning("Binary patch found %s for wrong class %s", patch.targetClassName, mappedName);
            }
            if (!(patch.existsAtTarget || inputData != null && inputData.length != 0)) {
                inputData = new byte[]{};
            } else if (!patch.existsAtTarget) {
                FMLLog.warning("Patcher expecting empty class data file for %s, but received non-empty", patch.targetClassName);
            }
            GDiffPatcher gDiffPatcher = this.patcher;
            synchronized (gDiffPatcher) {
                try {
                    inputData = this.patcher.patch(inputData, patch.patch);
                }
                catch (IOException e) {
                    FMLLog.log(Level.SEVERE, e, "Encountered problem runtime patching class %s", name);
                }
            }
        }
        FMLLog.fine("Successfully applied runtime patches for %s", mappedName);
        return inputData;
    }

    public void setup(Side side) {
        JarInputStream jis;
        Pattern binpatchMatcher = Pattern.compile(String.format("binpatch/%s/.*.binpatch", side.toString().toLowerCase(Locale.ENGLISH)));
        try {
            InputStream binpatchesCompressed = this.getClass().getResourceAsStream("/binpatches.pack.lzma");
            if (binpatchesCompressed == null) {
                FMLRelaunchLog.log(Level.SEVERE, "The binary patch set is missing. Things are probably about to go very wrong.", new Object[0]);
                return;
            }
            LzmaInputStream binpatchesDecompressed = new LzmaInputStream(binpatchesCompressed);
            ByteArrayOutputStream jarBytes = new ByteArrayOutputStream();
            JarOutputStream jos = new JarOutputStream(jarBytes);
            Pack200.newUnpacker().unpack((InputStream)binpatchesDecompressed, jos);
            jis = new JarInputStream(new ByteArrayInputStream(jarBytes.toByteArray()));
        }
        catch (Exception e) {
            FMLRelaunchLog.log(Level.SEVERE, e, "Error occurred reading binary patches. Problems may occur", new Object[0]);
            throw Throwables.propagate((Throwable)e);
        }
        this.patches = ArrayListMultimap.create();
        while (true) {
            try {
                JarEntry entry;
                while ((entry = jis.getNextJarEntry()) != null) {
                    if (binpatchMatcher.matcher(entry.getName()).matches()) {
                        ClassPatch cp = this.readPatch(entry, jis);
                        if (cp == null) continue;
                        this.patches.put((Object)cp.sourceClassName, (Object)cp);
                        continue;
                    }
                    jis.closeEntry();
                }
            }
            catch (IOException e) {
                continue;
            }
            break;
        }
        FMLLog.fine("Read %d binary patches", this.patches.size());
        FMLLog.fine("Patch list :\n\t%s", Joiner.on((String)"\t\n").join(this.patches.asMap().entrySet()));
    }

    private ClassPatch readPatch(JarEntry patchEntry, JarInputStream jis) {
        ByteArrayDataInput input;
        FMLLog.finest("Reading patch data from %s", patchEntry.getName());
        try {
            input = ByteStreams.newDataInput((byte[])ByteStreams.toByteArray((InputStream)jis));
        }
        catch (IOException e) {
            FMLLog.log(Level.WARNING, e, "Unable to read binpatch file %s - ignoring", patchEntry.getName());
            return null;
        }
        String name = input.readUTF();
        String sourceClassName = input.readUTF();
        String targetClassName = input.readUTF();
        boolean exists = input.readBoolean();
        int patchLength = input.readInt();
        byte[] patchBytes = new byte[patchLength];
        input.readFully(patchBytes);
        return new ClassPatch(name, sourceClassName, targetClassName, exists, patchBytes);
    }
}

