/*
 * Decompiled with CFR 0.152.
 */
package cpw.mods.fml.client.registry;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.ObjectArrays;
import cpw.mods.fml.client.registry.ISimpleBlockRenderingHandler;
import java.util.List;
import java.util.Map;

public class RenderingRegistry {
    private static final RenderingRegistry INSTANCE = new RenderingRegistry();
    private int nextRenderId = 40;
    private Map<Integer, ISimpleBlockRenderingHandler> blockRenderers = Maps.newHashMap();
    private List<EntityRendererInfo> entityRenderers = Lists.newArrayList();

    public static int addNewArmourRendererPrefix(String armor) {
        bgj.l = (String[])ObjectArrays.concat((Object[])bgj.l, (Object)armor);
        return bgj.l.length - 1;
    }

    public static void registerEntityRenderingHandler(Class<? extends nk> entityClass, bgb renderer) {
        RenderingRegistry.instance().entityRenderers.add(new EntityRendererInfo(entityClass, renderer));
    }

    public static void registerBlockHandler(ISimpleBlockRenderingHandler handler) {
        RenderingRegistry.instance().blockRenderers.put(handler.getRenderId(), handler);
    }

    public static void registerBlockHandler(int renderId, ISimpleBlockRenderingHandler handler) {
        RenderingRegistry.instance().blockRenderers.put(renderId, handler);
    }

    public static int getNextAvailableRenderId() {
        return RenderingRegistry.instance().nextRenderId++;
    }

    @Deprecated
    public static int addTextureOverride(String fileToOverride, String fileToAdd) {
        return -1;
    }

    public static void addTextureOverride(String path, String overlayPath, int index) {
    }

    @Deprecated
    public static int getUniqueTextureIndex(String path) {
        return -1;
    }

    @Deprecated
    public static RenderingRegistry instance() {
        return INSTANCE;
    }

    public boolean renderWorldBlock(bfg renderer, aca world, int x2, int y, int z, aqs block, int modelId) {
        if (!this.blockRenderers.containsKey(modelId)) {
            return false;
        }
        ISimpleBlockRenderingHandler bri = this.blockRenderers.get(modelId);
        return bri.renderWorldBlock(world, x2, y, z, block, modelId, renderer);
    }

    public void renderInventoryBlock(bfg renderer, aqs block, int metadata, int modelID) {
        if (!this.blockRenderers.containsKey(modelID)) {
            return;
        }
        ISimpleBlockRenderingHandler bri = this.blockRenderers.get(modelID);
        bri.renderInventoryBlock(block, metadata, modelID, renderer);
    }

    public boolean renderItemAsFull3DBlock(int modelId) {
        ISimpleBlockRenderingHandler bri = this.blockRenderers.get(modelId);
        return bri != null && bri.shouldRender3DInInventory();
    }

    public void loadEntityRenderers(Map<Class<? extends nk>, bgb> rendererMap) {
        for (EntityRendererInfo info : this.entityRenderers) {
            rendererMap.put(info.target, info.renderer);
            info.renderer.a(bga.a);
        }
    }

    private static class EntityRendererInfo {
        private Class<? extends nk> target;
        private bgb renderer;

        public EntityRendererInfo(Class<? extends nk> target, bgb renderer) {
            this.target = target;
            this.renderer = renderer;
        }
    }
}

