PrefabFiles = {
	"kyoko",
	"kyoko_none",
	"kyokospear",
	"summonkyoko",
	"clonekyokospear",
}

Assets = {
    Asset( "IMAGE", "images/saveslot_portraits/kyoko.tex" ),
    Asset( "ATLAS", "images/saveslot_portraits/kyoko.xml" ),

    Asset( "IMAGE", "images/selectscreen_portraits/kyoko.tex" ),
    Asset( "ATLAS", "images/selectscreen_portraits/kyoko.xml" ),
	
    Asset( "IMAGE", "images/selectscreen_portraits/kyoko_silho.tex" ),
    Asset( "ATLAS", "images/selectscreen_portraits/kyoko_silho.xml" ),

    Asset( "IMAGE", "bigportraits/kyoko.tex" ),
    Asset( "ATLAS", "bigportraits/kyoko.xml" ),
	
	Asset( "IMAGE", "images/map_icons/kyoko.tex" ),
	Asset( "ATLAS", "images/map_icons/kyoko.xml" ),
	
	Asset( "IMAGE", "images/avatars/avatar_kyoko.tex" ),
    Asset( "ATLAS", "images/avatars/avatar_kyoko.xml" ),
	
	Asset( "IMAGE", "images/avatars/avatar_ghost_kyoko.tex" ),
    Asset( "ATLAS", "images/avatars/avatar_ghost_kyoko.xml" ),
	
	Asset( "IMAGE", "images/names_kyoko.tex" ),
    Asset( "ATLAS", "images/names_kyoko.xml" ),
	
    Asset( "IMAGE", "bigportraits/kyoko_none.tex" ),
    Asset( "ATLAS", "bigportraits/kyoko_none.xml" ),
	
	Asset( "ATLAS", "images/hud/kyokotab.xml" ),
	Asset( "IMAGE", "images/hud/kyokotab.tex" ),

}

local require = GLOBAL.require
local STRINGS = GLOBAL.STRINGS
local resolvefilepath = GLOBAL.resolvefilepath

local Ingredient = GLOBAL.Ingredient
local RECIPETABS = GLOBAL.RECIPETABS
local Recipe = GLOBAL.Recipe
local TECH = GLOBAL.TECH
local STRINGS = GLOBAL.STRINGS

local SITCOMMAND = GLOBAL.Action(4, true, true, 10,	false, false, nil)
local SITCOMMAND_CANCEL = GLOBAL.Action(4, true, true, 10, false, false, nil)

STRINGS.RECIPE_DESC.SUMMONKYOKO = "I can summon myself!" 
STRINGS.RECIPE_DESC.KYOKOSPEAR = "Need a pointier stick?" 


GLOBAL.STRINGS.NAMES.SUMMONKYOKO = "Kyoko's Phantom"
GLOBAL.STRINGS.NAMES.CLONEKYOKOSPEAR = "Scorpion Spear"
GLOBAL.STRINGS.NAMES.KYOKOSPEAR = "Kyoko's Spear"

GLOBAL.STRINGS.CHARACTERS.GENERIC.DESCRIBE.SUMMONKYOKO = "Is she as hot-headed as the real one?"
GLOBAL.STRINGS.CHARACTERS.GENERIC.DESCRIBE.CLONEKYOKOSPEAR = "For a certain magical, yet, abrasive girl."
GLOBAL.STRINGS.CHARACTERS.GENERIC.DESCRIBE.KYOKOSPEAR = "For a certain magical, yet, abrasive girl."

AddMinimapAtlas("images/inventoryimages/summonkyoko.xml")
	
AddReplicableComponent("followersitcommand")

SITCOMMAND.id = "SITCOMMAND"
SITCOMMAND.str = "Order to Stay"
SITCOMMAND.fn = function(act)
	local targ = act.target
	if targ and targ.components.followersitcommand then
		act.doer.components.locomotor:Stop()
		act.doer.components.talker:Say("On guard!")
		targ.components.followersitcommand:SetStaying(true)
		targ.components.followersitcommand:RememberSitPos("currentstaylocation", GLOBAL.Point(targ.Transform:GetWorldPosition())) 
		return true
	end
end
AddAction(SITCOMMAND)

SITCOMMAND_CANCEL.id = "SITCOMMAND_CANCEL"
SITCOMMAND_CANCEL.str = "Order to Follow"
SITCOMMAND_CANCEL.fn = function(act)
	local targ = act.target
	if targ and targ.components.followersitcommand then
		act.doer.components.locomotor:Stop()
		act.doer.components.talker:Say("By my side!")
		targ.components.followersitcommand:SetStaying(false)
		return true
	end
end
AddAction(SITCOMMAND_CANCEL)

AddComponentAction("SCENE", "followersitcommand", function(inst, doer, actions, rightclick)
	if rightclick and inst.replica.followersitcommand then
		if not inst.replica.followersitcommand:IsCurrentlyStaying() then
			table.insert(actions, GLOBAL.ACTIONS.SITCOMMAND)
		else
			table.insert(actions, GLOBAL.ACTIONS.SITCOMMAND_CANCEL)
		end
	end
end)

-- add tradable component to various gear
function HF_addtradablecomponenttoprefab(inst)
	if not inst.components.tradable then
		inst:AddComponent("tradable")
	end
end
AddPrefabPostInit("clonekyokospear", HF_addtradablecomponenttoprefab)
AddPrefabPostInit("axe", HF_addtradablecomponenttoprefab)
AddPrefabPostInit("goldenaxe", HF_addtradablecomponenttoprefab)
AddPrefabPostInit("armor_sanity", HF_addtradablecomponenttoprefab)
AddPrefabPostInit("umbrella", HF_addtradablecomponenttoprefab)
AddPrefabPostInit("grass_umbrella", HF_addtradablecomponenttoprefab)
AddPrefabPostInit("hambat", HF_addtradablecomponenttoprefab)
AddPrefabPostInit("spear", HF_addtradablecomponenttoprefab)
AddPrefabPostInit("tentaclespike", HF_addtradablecomponenttoprefab)
AddPrefabPostInit("nightsword", HF_addtradablecomponenttoprefab)
AddPrefabPostInit("torch", HF_addtradablecomponenttoprefab)
AddPrefabPostInit("armorwood", HF_addtradablecomponenttoprefab)
AddPrefabPostInit("pickaxe", HF_addtradablecomponenttoprefab)
AddPrefabPostInit("goldenpickaxe", HF_addtradablecomponenttoprefab)
AddPrefabPostInit("blowdart_sleep", HF_addtradablecomponenttoprefab)
AddPrefabPostInit("blowdart_fire", HF_addtradablecomponenttoprefab)
AddPrefabPostInit("blowdart_pipe", HF_addtradablecomponenttoprefab)
AddPrefabPostInit("boomerang", HF_addtradablecomponenttoprefab)
AddPrefabPostInit("ice_projectile", HF_addtradablecomponenttoprefab)
AddPrefabPostInit("fire_projectile", HF_addtradablecomponenttoprefab)
AddPrefabPostInit("fishingrod", HF_addtradablecomponenttoprefab)
AddPrefabPostInit("bugnet", HF_addtradablecomponenttoprefab)
AddPrefabPostInit("hammer", HF_addtradablecomponenttoprefab)
AddPrefabPostInit("shovel", HF_addtradablecomponenttoprefab)
AddPrefabPostInit("goldenshovel", HF_addtradablecomponenttoprefab)
AddPrefabPostInit("pitchfork", HF_addtradablecomponenttoprefab)
AddPrefabPostInit("cane", HF_addtradablecomponenttoprefab)
AddPrefabPostInit("armormarble", HF_addtradablecomponenttoprefab)
AddPrefabPostInit("armorgrass", HF_addtradablecomponenttoprefab)
AddPrefabPostInit("sweatervest", HF_addtradablecomponenttoprefab)
AddPrefabPostInit("trunkvest_summer", HF_addtradablecomponenttoprefab)
AddPrefabPostInit("trunkvest_winter", HF_addtradablecomponenttoprefab)
AddPrefabPostInit("armorsnurtleshell", HF_addtradablecomponenttoprefab)
AddPrefabPostInit("lighter", HF_addtradablecomponenttoprefab)
AddPrefabPostInit("nightlight", HF_addtradablecomponenttoprefab)
AddPrefabPostInit("batbat", HF_addtradablecomponenttoprefab)
AddPrefabPostInit("lucy", HF_addtradablecomponenttoprefab)
AddPrefabPostInit("bluegem", HF_addtradablecomponenttoprefab)
AddPrefabPostInit("redgem", HF_addtradablecomponenttoprefab)
AddPrefabPostInit("armorruins", HF_addtradablecomponenttoprefab)
AddPrefabPostInit("armorslurper", HF_addtradablecomponenttoprefab)
AddPrefabPostInit("multitool_axe_pickaxe", HF_addtradablecomponenttoprefab)
AddPrefabPostInit("ruins_bat", HF_addtradablecomponenttoprefab)
-- DLC
AddPrefabPostInit("spear_wathgrithr", HF_addtradablecomponenttoprefab)
AddPrefabPostInit("beargervest", HF_addtradablecomponenttoprefab)
AddPrefabPostInit("armordragonfly", HF_addtradablecomponenttoprefab)

AddComponentPostInit("moisture", function(self)
	local old = self.GetMoistureRate
	self.GetMoistureRate = function(self)
		local oldvalue = old(self)
		local x, y, z = self.inst.Transform:GetWorldPosition()
		local ents = GLOBAL.TheSim:FindEntities(x, y, z, 4, {'sheltercarrier'})
		for k, v in pairs(ents) do 
			if v.components.inventory:GetEquippedItem(GLOBAL.EQUIPSLOTS.HANDS) and 
			v.components.inventory:GetEquippedItem(GLOBAL.EQUIPSLOTS.HANDS).prefab == "umbrella" then
				return 0
			end
			if v.components.inventory:GetEquippedItem(GLOBAL.EQUIPSLOTS.HANDS) and 
			v.components.inventory:GetEquippedItem(GLOBAL.EQUIPSLOTS.HANDS).prefab == "grass_umbrella" then
				return oldvalue * 0.5
			end
		end
		return oldvalue
	end
end)

local comb_rep = GLOBAL.require "components/combat_replica"
local old_IsAlly = comb_rep.IsAlly
function comb_rep:IsAlly(guy,...)
	if guy:HasTag("summonkyoko") then
		return true
	end
	return old_IsAlly(self,guy,...)
end

local kyokotab = AddRecipeTab( "Kyoko's Tab", 999, "images/hud/kyokotab.xml", "kyokotab.tex", "kyoko_builder")

AddRecipe("summonkyoko",
{GLOBAL.Ingredient(GLOBAL.CHARACTER_INGREDIENT.SANITY, 50)},
kyokotab, TECH.NONE,
nil, nil, nil, nil, "kyoko_builder",
"images/inventoryimages/summonkyoko.xml", "summonkyoko.tex")

AddRecipe("kyokospear",
{GLOBAL.Ingredient(GLOBAL.CHARACTER_INGREDIENT.SANITY, 20)},
kyokotab, TECH.NONE,
nil, nil, nil, nil, "kyoko_builder",
"images/inventoryimages/kyokospear.xml", "kyokospear.tex")

-- The character select screen lines
STRINGS.CHARACTER_TITLES.kyoko = "The Abrasive Veteran"
STRINGS.CHARACTER_NAMES.kyoko = "Kyoko"
STRINGS.CHARACTER_DESCRIPTIONS.kyoko = "*A Veteran Fighter\n*Summons Phantoms\n*Has a Large Appetite"
STRINGS.CHARACTER_QUOTES.kyoko = "\"Don't waste food. I'll kill you.\""

-- Custom speech strings
STRINGS.CHARACTERS.KYOKO = require "speech_kyoko"

-- The character's name as appears in-game 
STRINGS.NAMES.KYOKO = "Kyoko"

-- The default responses of examining the character
STRINGS.CHARACTERS.GENERIC.DESCRIBE.KYOKO = 
{
	GENERIC = "It's Kyoko!",
	ATTACKER = "That Kyoko looks shifty...",
	MURDERER = "Murderer!",
	REVIVER = "Kyoko, friend of ghosts.",
	GHOST = "Kyoko could use a heart.",
}


AddMinimapAtlas("images/map_icons/kyoko.xml")

-- Add mod character to mod character list. Also specify a gender. Possible genders are MALE, FEMALE, ROBOT, NEUTRAL, and PLURAL.
AddModCharacter("kyoko", "FEMALE")

