/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.asm;

import java.io.IOException;
import java.io.InputStream;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.Attribute;
import org.objectweb.asm.ByteVector;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.Context;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.Handle;
import org.objectweb.asm.Item;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.MethodWriter;
import org.objectweb.asm.Opcodes;
import org.objectweb.asm.Type;

public class ClassReader {
    public static final int SKIP_CODE = 1;
    public static final int SKIP_DEBUG = 2;
    public static final int SKIP_FRAMES = 4;
    public static final int EXPAND_FRAMES = 8;
    public final byte[] b;
    private final int[] a;
    private final String[] c;
    private final int d;
    public final int header;

    public ClassReader(byte[] byArray) {
        this(byArray, 0, byArray.length);
    }

    public ClassReader(byte[] byArray, int n2, int n3) {
        this.b = byArray;
        if (this.readShort(n2 + 6) > 51) {
            throw new IllegalArgumentException();
        }
        this.a = new int[this.readUnsignedShort(n2 + 8)];
        int n4 = this.a.length;
        this.c = new String[n4];
        int n5 = 0;
        int n6 = n2 + 10;
        for (int i2 = 1; i2 < n4; ++i2) {
            int n7;
            this.a[i2] = n6 + 1;
            switch (byArray[n6]) {
                case 3: 
                case 4: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 18: {
                    n7 = 5;
                    break;
                }
                case 5: 
                case 6: {
                    n7 = 9;
                    ++i2;
                    break;
                }
                case 1: {
                    n7 = 3 + this.readUnsignedShort(n6 + 1);
                    if (n7 <= n5) break;
                    n5 = n7;
                    break;
                }
                case 15: {
                    n7 = 4;
                    break;
                }
                default: {
                    n7 = 3;
                }
            }
            n6 += n7;
        }
        this.d = n5;
        this.header = n6;
    }

    public int getAccess() {
        return this.readUnsignedShort(this.header);
    }

    public String getClassName() {
        return this.readClass(this.header + 2, new char[this.d]);
    }

    public String getSuperName() {
        return this.readClass(this.header + 4, new char[this.d]);
    }

    public String[] getInterfaces() {
        int n2 = this.header + 6;
        int n3 = this.readUnsignedShort(n2);
        String[] stringArray = new String[n3];
        if (n3 > 0) {
            char[] cArray = new char[this.d];
            for (int i2 = 0; i2 < n3; ++i2) {
                stringArray[i2] = this.readClass(n2 += 2, cArray);
            }
        }
        return stringArray;
    }

    void a(ClassWriter classWriter) {
        int n2;
        char[] cArray = new char[this.d];
        int n3 = this.a.length;
        Item[] itemArray = new Item[n3];
        for (n2 = 1; n2 < n3; ++n2) {
            int n4;
            int n5 = this.a[n2];
            byte by = this.b[n5 - 1];
            Item item = new Item(n2);
            switch (by) {
                case 9: 
                case 10: 
                case 11: {
                    int n6 = this.a[this.readUnsignedShort(n5 + 2)];
                    item.a(by, this.readClass(n5, cArray), this.readUTF8(n6, cArray), this.readUTF8(n6 + 2, cArray));
                    break;
                }
                case 3: {
                    item.a(this.readInt(n5));
                    break;
                }
                case 4: {
                    item.a(Float.intBitsToFloat(this.readInt(n5)));
                    break;
                }
                case 12: {
                    item.a(by, this.readUTF8(n5, cArray), this.readUTF8(n5 + 2, cArray), null);
                    break;
                }
                case 5: {
                    item.a(this.readLong(n5));
                    ++n2;
                    break;
                }
                case 6: {
                    item.a(Double.longBitsToDouble(this.readLong(n5)));
                    ++n2;
                    break;
                }
                case 1: {
                    String string = this.c[n2];
                    if (string == null) {
                        n5 = this.a[n2];
                        string = this.c[n2] = this.a(n5 + 2, this.readUnsignedShort(n5), cArray);
                    }
                    item.a(by, string, null, null);
                    break;
                }
                case 15: {
                    n4 = this.a[this.readUnsignedShort(n5 + 1)];
                    int n6 = this.a[this.readUnsignedShort(n4 + 2)];
                    item.a(20 + this.readByte(n5), this.readClass(n4, cArray), this.readUTF8(n6, cArray), this.readUTF8(n6 + 2, cArray));
                    break;
                }
                case 18: {
                    if (classWriter.A == null) {
                        this.a(classWriter, itemArray, cArray);
                    }
                    int n6 = this.a[this.readUnsignedShort(n5 + 2)];
                    item.a(this.readUTF8(n6, cArray), this.readUTF8(n6 + 2, cArray), this.readUnsignedShort(n5));
                    break;
                }
                default: {
                    item.a(by, this.readUTF8(n5, cArray), null, null);
                }
            }
            n4 = item.j % itemArray.length;
            item.k = itemArray[n4];
            itemArray[n4] = item;
        }
        n2 = this.a[1] - 1;
        classWriter.d.putByteArray(this.b, n2, this.header - n2);
        classWriter.e = itemArray;
        classWriter.f = (int)(0.75 * (double)n3);
        classWriter.c = n3;
    }

    private void a(ClassWriter classWriter, Item[] itemArray, char[] cArray) {
        int n2;
        int n3;
        int n4 = this.a();
        boolean bl = false;
        for (n3 = this.readUnsignedShort(n4); n3 > 0; --n3) {
            String string = this.readUTF8(n4 + 2, cArray);
            if ("BootstrapMethods".equals(string)) {
                bl = true;
                break;
            }
            n4 += 6 + this.readInt(n4 + 4);
        }
        if (!bl) {
            return;
        }
        n3 = this.readUnsignedShort(n4 + 8);
        int n5 = n4 + 10;
        for (n2 = 0; n2 < n3; ++n2) {
            int n6 = n5 - n4 - 10;
            int n7 = this.readConst(this.readUnsignedShort(n5), cArray).hashCode();
            for (int i2 = this.readUnsignedShort(n5 + 2); i2 > 0; --i2) {
                n7 ^= this.readConst(this.readUnsignedShort(n5 + 4), cArray).hashCode();
                n5 += 2;
            }
            n5 += 4;
            Item item = new Item(n2);
            item.a(n6, n7 & Integer.MAX_VALUE);
            int n8 = item.j % itemArray.length;
            item.k = itemArray[n8];
            itemArray[n8] = item;
        }
        n2 = this.readInt(n4 + 4);
        ByteVector byteVector = new ByteVector(n2 + 62);
        byteVector.putByteArray(this.b, n4 + 10, n2 - 2);
        classWriter.z = n3;
        classWriter.A = byteVector;
    }

    public ClassReader(InputStream inputStream) throws IOException {
        this(ClassReader.a(inputStream, false));
    }

    public ClassReader(String string) throws IOException {
        this(ClassReader.a(ClassLoader.getSystemResourceAsStream(string.replace('.', '/') + ".class"), true));
    }

    private static byte[] a(InputStream inputStream, boolean bl) throws IOException {
        if (inputStream == null) {
            throw new IOException("Class not found");
        }
        try {
            byte[] byArray = new byte[inputStream.available()];
            int n2 = 0;
            while (true) {
                byte[] byArray2;
                int n3;
                if ((n3 = inputStream.read(byArray, n2, byArray.length - n2)) == -1) {
                    byte[] byArray3;
                    if (n2 < byArray.length) {
                        byArray3 = new byte[n2];
                        System.arraycopy(byArray, 0, byArray3, 0, n2);
                        byArray = byArray3;
                    }
                    byArray3 = byArray;
                    return byArray3;
                }
                if ((n2 += n3) != byArray.length) continue;
                int n4 = inputStream.read();
                if (n4 < 0) {
                    byArray2 = byArray;
                    return byArray2;
                }
                byArray2 = new byte[byArray.length + 1000];
                System.arraycopy(byArray, 0, byArray2, 0, n2);
                byArray2[n2++] = (byte)n4;
                byArray = byArray2;
            }
        }
        finally {
            if (bl) {
                inputStream.close();
            }
        }
    }

    public void accept(ClassVisitor classVisitor, int n2) {
        this.accept(classVisitor, new Attribute[0], n2);
    }

    public void accept(ClassVisitor classVisitor, Attribute[] attributeArray, int n2) {
        int n3;
        int n4 = this.header;
        char[] cArray = new char[this.d];
        Context context = new Context();
        context.a = attributeArray;
        context.b = n2;
        context.c = cArray;
        int n5 = this.readUnsignedShort(n4);
        String string = this.readClass(n4 + 2, cArray);
        String string2 = this.readClass(n4 + 4, cArray);
        String[] stringArray = new String[this.readUnsignedShort(n4 + 6)];
        n4 += 8;
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            stringArray[i2] = this.readClass(n4, cArray);
            n4 += 2;
        }
        String string3 = null;
        String string4 = null;
        String string5 = null;
        String string6 = null;
        String string7 = null;
        String string8 = null;
        int n6 = 0;
        int n7 = 0;
        int n8 = 0;
        Attribute attribute = null;
        n4 = this.a();
        for (n3 = this.readUnsignedShort(n4); n3 > 0; --n3) {
            String string9 = this.readUTF8(n4 + 2, cArray);
            if ("SourceFile".equals(string9)) {
                string4 = this.readUTF8(n4 + 8, cArray);
            } else if ("InnerClasses".equals(string9)) {
                n8 = n4 + 8;
            } else if ("EnclosingMethod".equals(string9)) {
                string6 = this.readClass(n4 + 8, cArray);
                int n9 = this.readUnsignedShort(n4 + 10);
                if (n9 != 0) {
                    string7 = this.readUTF8(this.a[n9], cArray);
                    string8 = this.readUTF8(this.a[n9] + 2, cArray);
                }
            } else if ("Signature".equals(string9)) {
                string3 = this.readUTF8(n4 + 8, cArray);
            } else if ("RuntimeVisibleAnnotations".equals(string9)) {
                n6 = n4 + 8;
            } else if ("Deprecated".equals(string9)) {
                n5 |= 0x20000;
            } else if ("Synthetic".equals(string9)) {
                n5 |= 0x41000;
            } else if ("SourceDebugExtension".equals(string9)) {
                int n10 = this.readInt(n4 + 4);
                string5 = this.a(n4 + 8, n10, new char[n10]);
            } else if ("RuntimeInvisibleAnnotations".equals(string9)) {
                n7 = n4 + 8;
            } else if ("BootstrapMethods".equals(string9)) {
                int[] nArray = new int[this.readUnsignedShort(n4 + 8)];
                int n11 = n4 + 10;
                for (int i3 = 0; i3 < nArray.length; ++i3) {
                    nArray[i3] = n11;
                    n11 += 2 + this.readUnsignedShort(n11 + 2) << 1;
                }
                context.d = nArray;
            } else {
                Attribute attribute2 = this.a(attributeArray, string9, n4 + 8, this.readInt(n4 + 4), cArray, -1, null);
                if (attribute2 != null) {
                    attribute2.a = attribute;
                    attribute = attribute2;
                }
            }
            n4 += 6 + this.readInt(n4 + 4);
        }
        classVisitor.visit(this.readInt(this.a[1] - 7), n5, string, string3, string2, stringArray);
        if ((n2 & 2) == 0 && (string4 != null || string5 != null)) {
            classVisitor.visitSource(string4, string5);
        }
        if (string6 != null) {
            classVisitor.visitOuterClass(string6, string7, string8);
        }
        if (n6 != 0) {
            int n12 = n6 + 2;
            for (n3 = this.readUnsignedShort(n6); n3 > 0; --n3) {
                n12 = this.a(n12 + 2, cArray, true, classVisitor.visitAnnotation(this.readUTF8(n12, cArray), true));
            }
        }
        if (n7 != 0) {
            int n13 = n7 + 2;
            for (n3 = this.readUnsignedShort(n7); n3 > 0; --n3) {
                n13 = this.a(n13 + 2, cArray, true, classVisitor.visitAnnotation(this.readUTF8(n13, cArray), false));
            }
        }
        while (attribute != null) {
            Attribute attribute3 = attribute.a;
            attribute.a = null;
            classVisitor.visitAttribute(attribute);
            attribute = attribute3;
        }
        if (n8 != 0) {
            n3 = n8 + 2;
            for (int i4 = this.readUnsignedShort(n8); i4 > 0; --i4) {
                classVisitor.visitInnerClass(this.readClass(n3, cArray), this.readClass(n3 + 2, cArray), this.readUTF8(n3 + 4, cArray), this.readUnsignedShort(n3 + 6));
                n3 += 8;
            }
        }
        n4 = this.header + 10 + 2 * stringArray.length;
        for (n3 = this.readUnsignedShort(n4 - 2); n3 > 0; --n3) {
            n4 = this.a(classVisitor, context, n4);
        }
        for (n3 = this.readUnsignedShort((n4 += 2) - 2); n3 > 0; --n3) {
            n4 = this.b(classVisitor, context, n4);
        }
        classVisitor.visitEnd();
    }

    private int a(ClassVisitor classVisitor, Context context, int n2) {
        int n3;
        char[] cArray = context.c;
        int n4 = this.readUnsignedShort(n2);
        String string = this.readUTF8(n2 + 2, cArray);
        String string2 = this.readUTF8(n2 + 4, cArray);
        n2 += 6;
        String string3 = null;
        int n5 = 0;
        int n6 = 0;
        Object object = null;
        Attribute attribute = null;
        for (int i2 = this.readUnsignedShort(n2); i2 > 0; --i2) {
            String string4 = this.readUTF8(n2 + 2, cArray);
            if ("ConstantValue".equals(string4)) {
                n3 = this.readUnsignedShort(n2 + 8);
                object = n3 == 0 ? null : this.readConst(n3, cArray);
            } else if ("Signature".equals(string4)) {
                string3 = this.readUTF8(n2 + 8, cArray);
            } else if ("Deprecated".equals(string4)) {
                n4 |= 0x20000;
            } else if ("Synthetic".equals(string4)) {
                n4 |= 0x41000;
            } else if ("RuntimeVisibleAnnotations".equals(string4)) {
                n5 = n2 + 8;
            } else if ("RuntimeInvisibleAnnotations".equals(string4)) {
                n6 = n2 + 8;
            } else {
                Attribute attribute2 = this.a(context.a, string4, n2 + 8, this.readInt(n2 + 4), cArray, -1, null);
                if (attribute2 != null) {
                    attribute2.a = attribute;
                    attribute = attribute2;
                }
            }
            n2 += 6 + this.readInt(n2 + 4);
        }
        n2 += 2;
        FieldVisitor fieldVisitor = classVisitor.visitField(n4, string, string2, string3, object);
        if (fieldVisitor == null) {
            return n2;
        }
        if (n5 != 0) {
            n3 = n5 + 2;
            for (int i3 = this.readUnsignedShort(n5); i3 > 0; --i3) {
                n3 = this.a(n3 + 2, cArray, true, fieldVisitor.visitAnnotation(this.readUTF8(n3, cArray), true));
            }
        }
        if (n6 != 0) {
            n3 = n6 + 2;
            for (int i4 = this.readUnsignedShort(n6); i4 > 0; --i4) {
                n3 = this.a(n3 + 2, cArray, true, fieldVisitor.visitAnnotation(this.readUTF8(n3, cArray), false));
            }
        }
        while (attribute != null) {
            Attribute attribute3 = attribute.a;
            attribute.a = null;
            fieldVisitor.visitAttribute(attribute);
            attribute = attribute3;
        }
        fieldVisitor.visitEnd();
        return n2;
    }

    private int b(ClassVisitor classVisitor, Context context, int n2) {
        int n3;
        Object object;
        char[] cArray = context.c;
        int n4 = this.readUnsignedShort(n2);
        String string = this.readUTF8(n2 + 2, cArray);
        String string2 = this.readUTF8(n2 + 4, cArray);
        n2 += 6;
        int n5 = 0;
        int n6 = 0;
        String[] stringArray = null;
        String string3 = null;
        int n7 = 0;
        int n8 = 0;
        int n9 = 0;
        int n10 = 0;
        int n11 = 0;
        int n12 = n2;
        Attribute attribute = null;
        for (int i2 = this.readUnsignedShort(n2); i2 > 0; --i2) {
            object = this.readUTF8(n2 + 2, cArray);
            if ("Code".equals(object)) {
                if ((context.b & 1) == 0) {
                    n5 = n2 + 8;
                }
            } else if ("Exceptions".equals(object)) {
                stringArray = new String[this.readUnsignedShort(n2 + 8)];
                n6 = n2 + 10;
                for (n3 = 0; n3 < stringArray.length; ++n3) {
                    stringArray[n3] = this.readClass(n6, cArray);
                    n6 += 2;
                }
            } else if ("Signature".equals(object)) {
                string3 = this.readUTF8(n2 + 8, cArray);
            } else if ("Deprecated".equals(object)) {
                n4 |= 0x20000;
            } else if ("RuntimeVisibleAnnotations".equals(object)) {
                n7 = n2 + 8;
            } else if ("AnnotationDefault".equals(object)) {
                n9 = n2 + 8;
            } else if ("Synthetic".equals(object)) {
                n4 |= 0x41000;
            } else if ("RuntimeInvisibleAnnotations".equals(object)) {
                n8 = n2 + 8;
            } else if ("RuntimeVisibleParameterAnnotations".equals(object)) {
                n10 = n2 + 8;
            } else if ("RuntimeInvisibleParameterAnnotations".equals(object)) {
                n11 = n2 + 8;
            } else {
                Attribute attribute2 = this.a(context.a, (String)object, n2 + 8, this.readInt(n2 + 4), cArray, -1, null);
                if (attribute2 != null) {
                    attribute2.a = attribute;
                    attribute = attribute2;
                }
            }
            n2 += 6 + this.readInt(n2 + 4);
        }
        n2 += 2;
        MethodVisitor methodVisitor = classVisitor.visitMethod(n4, string, string2, string3, stringArray);
        if (methodVisitor == null) {
            return n2;
        }
        if (methodVisitor instanceof MethodWriter) {
            object = (MethodWriter)methodVisitor;
            if (((MethodWriter)object).b.M == this && string3 == ((MethodWriter)object).g) {
                n3 = 0;
                if (stringArray == null) {
                    n3 = ((MethodWriter)object).j == 0 ? 1 : 0;
                } else if (stringArray.length == ((MethodWriter)object).j) {
                    n3 = 1;
                    for (int i3 = stringArray.length - 1; i3 >= 0; --i3) {
                        if (((MethodWriter)object).k[i3] == this.readUnsignedShort(n6 -= 2)) continue;
                        n3 = 0;
                        break;
                    }
                }
                if (n3 != 0) {
                    ((MethodWriter)object).h = n12;
                    ((MethodWriter)object).i = n2 - n12;
                    return n2;
                }
            }
        }
        if (n9 != 0) {
            object = methodVisitor.visitAnnotationDefault();
            this.a(n9, cArray, null, (AnnotationVisitor)object);
            if (object != null) {
                ((AnnotationVisitor)object).visitEnd();
            }
        }
        if (n7 != 0) {
            n3 = n7 + 2;
            for (int i4 = this.readUnsignedShort(n7); i4 > 0; --i4) {
                n3 = this.a(n3 + 2, cArray, true, methodVisitor.visitAnnotation(this.readUTF8(n3, cArray), true));
            }
        }
        if (n8 != 0) {
            n3 = n8 + 2;
            for (int i5 = this.readUnsignedShort(n8); i5 > 0; --i5) {
                n3 = this.a(n3 + 2, cArray, true, methodVisitor.visitAnnotation(this.readUTF8(n3, cArray), false));
            }
        }
        if (n10 != 0) {
            this.a(n10, string2, cArray, true, methodVisitor);
        }
        if (n11 != 0) {
            this.a(n11, string2, cArray, false, methodVisitor);
        }
        while (attribute != null) {
            Attribute attribute3 = attribute.a;
            attribute.a = null;
            methodVisitor.visitAttribute(attribute);
            attribute = attribute3;
        }
        if (n5 != 0) {
            context.e = n4;
            context.f = string;
            context.g = string2;
            methodVisitor.visitCode();
            this.a(methodVisitor, context, n5);
        }
        methodVisitor.visitEnd();
        return n2;
    }

    private void a(MethodVisitor methodVisitor, Context context, int n2) {
        int n3;
        int n4;
        Object object;
        int n5;
        int n6;
        byte[] byArray = this.b;
        char[] cArray = context.c;
        int n7 = this.readUnsignedShort(n2);
        int n8 = this.readUnsignedShort(n2 + 2);
        int n9 = this.readInt(n2 + 4);
        int n10 = n2 += 8;
        int n11 = n2 + n9;
        Label[] labelArray = new Label[n9 + 2];
        this.readLabel(n9 + 1, labelArray);
        block29: while (n2 < n11) {
            n6 = n2 - n10;
            int n12 = byArray[n2] & 0xFF;
            switch (ClassWriter.a[n12]) {
                case 0: 
                case 4: {
                    ++n2;
                    continue block29;
                }
                case 9: {
                    this.readLabel(n6 + this.readShort(n2 + 1), labelArray);
                    n2 += 3;
                    continue block29;
                }
                case 10: {
                    this.readLabel(n6 + this.readInt(n2 + 1), labelArray);
                    n2 += 5;
                    continue block29;
                }
                case 17: {
                    n12 = byArray[n2 + 1] & 0xFF;
                    if (n12 == 132) {
                        n2 += 6;
                        continue block29;
                    }
                    n2 += 4;
                    continue block29;
                }
                case 14: {
                    int n13;
                    n2 = n2 + 4 - (n6 & 3);
                    this.readLabel(n6 + this.readInt(n2), labelArray);
                    for (n13 = this.readInt(n2 + 8) - this.readInt(n2 + 4) + 1; n13 > 0; --n13) {
                        this.readLabel(n6 + this.readInt(n2 + 12), labelArray);
                        n2 += 4;
                    }
                    n2 += 12;
                    continue block29;
                }
                case 15: {
                    int n13;
                    n2 = n2 + 4 - (n6 & 3);
                    this.readLabel(n6 + this.readInt(n2), labelArray);
                    for (n13 = this.readInt(n2 + 4); n13 > 0; --n13) {
                        this.readLabel(n6 + this.readInt(n2 + 12), labelArray);
                        n2 += 8;
                    }
                    n2 += 8;
                    continue block29;
                }
                case 1: 
                case 3: 
                case 11: {
                    n2 += 2;
                    continue block29;
                }
                case 2: 
                case 5: 
                case 6: 
                case 12: 
                case 13: {
                    n2 += 3;
                    continue block29;
                }
                case 7: 
                case 8: {
                    n2 += 5;
                    continue block29;
                }
            }
            n2 += 4;
        }
        for (n6 = this.readUnsignedShort(n2); n6 > 0; --n6) {
            Label label = this.readLabel(this.readUnsignedShort(n2 + 2), labelArray);
            Label label2 = this.readLabel(this.readUnsignedShort(n2 + 4), labelArray);
            Label label3 = this.readLabel(this.readUnsignedShort(n2 + 6), labelArray);
            String string = this.readUTF8(this.a[this.readUnsignedShort(n2 + 8)], cArray);
            methodVisitor.visitTryCatchBlock(label, label2, label3, string);
            n2 += 8;
        }
        n2 += 2;
        n6 = 0;
        int n14 = 0;
        boolean bl = true;
        boolean bl2 = (context.b & 8) != 0;
        int n15 = 0;
        int n16 = 0;
        int n17 = 0;
        Context context2 = null;
        Attribute attribute = null;
        for (n5 = this.readUnsignedShort(n2); n5 > 0; --n5) {
            int n18;
            object = this.readUTF8(n2 + 2, cArray);
            if ("LocalVariableTable".equals(object)) {
                if ((context.b & 2) == 0) {
                    n6 = n2 + 8;
                    n4 = n2;
                    for (n3 = this.readUnsignedShort(n2 + 8); n3 > 0; --n3) {
                        n18 = this.readUnsignedShort(n4 + 10);
                        if (labelArray[n18] == null) {
                            this.readLabel((int)n18, (Label[])labelArray).a |= 1;
                        }
                        if (labelArray[n18 += this.readUnsignedShort(n4 + 12)] == null) {
                            this.readLabel((int)n18, (Label[])labelArray).a |= 1;
                        }
                        n4 += 10;
                    }
                }
            } else if ("LocalVariableTypeTable".equals(object)) {
                n14 = n2 + 8;
            } else if ("LineNumberTable".equals(object)) {
                if ((context.b & 2) == 0) {
                    n4 = n2;
                    for (n3 = this.readUnsignedShort(n2 + 8); n3 > 0; --n3) {
                        n18 = this.readUnsignedShort(n4 + 10);
                        if (labelArray[n18] == null) {
                            this.readLabel((int)n18, (Label[])labelArray).a |= 1;
                        }
                        labelArray[n18].b = this.readUnsignedShort(n4 + 12);
                        n4 += 4;
                    }
                }
            } else if ("StackMapTable".equals(object)) {
                if ((context.b & 4) == 0) {
                    n15 = n2 + 10;
                    n16 = this.readInt(n2 + 4);
                    n17 = this.readUnsignedShort(n2 + 8);
                }
            } else if ("StackMap".equals(object)) {
                if ((context.b & 4) == 0) {
                    bl = false;
                    n15 = n2 + 10;
                    n16 = this.readInt(n2 + 4);
                    n17 = this.readUnsignedShort(n2 + 8);
                }
            } else {
                for (n3 = 0; n3 < context.a.length; ++n3) {
                    Attribute attribute2;
                    if (!context.a[n3].type.equals(object) || (attribute2 = context.a[n3].read(this, n2 + 8, this.readInt(n2 + 4), cArray, n10 - 8, labelArray)) == null) continue;
                    attribute2.a = attribute;
                    attribute = attribute2;
                }
            }
            n2 += 6 + this.readInt(n2 + 4);
        }
        n2 += 2;
        if (n15 != 0) {
            context2 = context;
            context2.h = -1;
            context2.i = 0;
            context2.j = 0;
            context2.k = 0;
            context2.m = 0;
            context2.l = new Object[n8];
            context2.n = new Object[n7];
            if (bl2) {
                this.a(context);
            }
            for (n5 = n15; n5 < n15 + n16 - 2; ++n5) {
                int n19;
                if (byArray[n5] != 8 || (n19 = this.readUnsignedShort(n5 + 1)) < 0 || n19 >= n9 || (byArray[n10 + n19] & 0xFF) != 187) continue;
                this.readLabel(n19, labelArray);
            }
        }
        n2 = n10;
        block38: while (n2 < n11) {
            n5 = n2 - n10;
            object = labelArray[n5];
            if (object != null) {
                methodVisitor.visitLabel((Label)object);
                if ((context.b & 2) == 0 && ((Label)object).b > 0) {
                    methodVisitor.visitLineNumber(((Label)object).b, (Label)object);
                }
            }
            while (context2 != null && (context2.h == n5 || context2.h == -1)) {
                if (context2.h != -1) {
                    if (!bl || bl2) {
                        methodVisitor.visitFrame(-1, context2.j, context2.l, context2.m, context2.n);
                    } else {
                        methodVisitor.visitFrame(context2.i, context2.k, context2.l, context2.m, context2.n);
                    }
                }
                if (n17 > 0) {
                    n15 = this.a(n15, bl, bl2, labelArray, context2);
                    --n17;
                    continue;
                }
                context2 = null;
            }
            n3 = byArray[n2] & 0xFF;
            switch (ClassWriter.a[n3]) {
                case 0: {
                    methodVisitor.visitInsn(n3);
                    ++n2;
                    continue block38;
                }
                case 4: {
                    if (n3 > 54) {
                        methodVisitor.visitVarInsn(54 + ((n3 -= 59) >> 2), n3 & 3);
                    } else {
                        methodVisitor.visitVarInsn(21 + ((n3 -= 26) >> 2), n3 & 3);
                    }
                    ++n2;
                    continue block38;
                }
                case 9: {
                    methodVisitor.visitJumpInsn(n3, labelArray[n5 + this.readShort(n2 + 1)]);
                    n2 += 3;
                    continue block38;
                }
                case 10: {
                    methodVisitor.visitJumpInsn(n3 - 33, labelArray[n5 + this.readInt(n2 + 1)]);
                    n2 += 5;
                    continue block38;
                }
                case 17: {
                    n3 = byArray[n2 + 1] & 0xFF;
                    if (n3 == 132) {
                        methodVisitor.visitIincInsn(this.readUnsignedShort(n2 + 2), this.readShort(n2 + 4));
                        n2 += 6;
                        continue block38;
                    }
                    methodVisitor.visitVarInsn(n3, this.readUnsignedShort(n2 + 2));
                    n2 += 4;
                    continue block38;
                }
                case 14: {
                    n2 = n2 + 4 - (n5 & 3);
                    n4 = n5 + this.readInt(n2);
                    int n20 = this.readInt(n2 + 4);
                    int n21 = this.readInt(n2 + 8);
                    Label[] labelArray2 = new Label[n21 - n20 + 1];
                    n2 += 12;
                    for (int i2 = 0; i2 < labelArray2.length; ++i2) {
                        labelArray2[i2] = labelArray[n5 + this.readInt(n2)];
                        n2 += 4;
                    }
                    methodVisitor.visitTableSwitchInsn(n20, n21, labelArray[n4], labelArray2);
                    continue block38;
                }
                case 15: {
                    n2 = n2 + 4 - (n5 & 3);
                    n4 = n5 + this.readInt(n2);
                    int n22 = this.readInt(n2 + 4);
                    int[] nArray = new int[n22];
                    Label[] labelArray3 = new Label[n22];
                    n2 += 8;
                    for (int i3 = 0; i3 < n22; ++i3) {
                        nArray[i3] = this.readInt(n2);
                        labelArray3[i3] = labelArray[n5 + this.readInt(n2 + 4)];
                        n2 += 8;
                    }
                    methodVisitor.visitLookupSwitchInsn(labelArray[n4], nArray, labelArray3);
                    continue block38;
                }
                case 3: {
                    methodVisitor.visitVarInsn(n3, byArray[n2 + 1] & 0xFF);
                    n2 += 2;
                    continue block38;
                }
                case 1: {
                    methodVisitor.visitIntInsn(n3, byArray[n2 + 1]);
                    n2 += 2;
                    continue block38;
                }
                case 2: {
                    methodVisitor.visitIntInsn(n3, this.readShort(n2 + 1));
                    n2 += 3;
                    continue block38;
                }
                case 11: {
                    methodVisitor.visitLdcInsn(this.readConst(byArray[n2 + 1] & 0xFF, cArray));
                    n2 += 2;
                    continue block38;
                }
                case 12: {
                    methodVisitor.visitLdcInsn(this.readConst(this.readUnsignedShort(n2 + 1), cArray));
                    n2 += 3;
                    continue block38;
                }
                case 6: 
                case 7: {
                    n4 = this.a[this.readUnsignedShort(n2 + 1)];
                    String string = this.readClass(n4, cArray);
                    n4 = this.a[this.readUnsignedShort(n4 + 2)];
                    String string2 = this.readUTF8(n4, cArray);
                    String string3 = this.readUTF8(n4 + 2, cArray);
                    if (n3 < 182) {
                        methodVisitor.visitFieldInsn(n3, string, string2, string3);
                    } else {
                        methodVisitor.visitMethodInsn(n3, string, string2, string3);
                    }
                    if (n3 == 185) {
                        n2 += 5;
                        continue block38;
                    }
                    n2 += 3;
                    continue block38;
                }
                case 8: {
                    n4 = this.a[this.readUnsignedShort(n2 + 1)];
                    int n23 = context.d[this.readUnsignedShort(n4)];
                    Handle handle = (Handle)this.readConst(this.readUnsignedShort(n23), cArray);
                    int n24 = this.readUnsignedShort(n23 + 2);
                    Object[] objectArray = new Object[n24];
                    n23 += 4;
                    for (int i4 = 0; i4 < n24; ++i4) {
                        objectArray[i4] = this.readConst(this.readUnsignedShort(n23), cArray);
                        n23 += 2;
                    }
                    n4 = this.a[this.readUnsignedShort(n4 + 2)];
                    String string = this.readUTF8(n4, cArray);
                    String string4 = this.readUTF8(n4 + 2, cArray);
                    methodVisitor.visitInvokeDynamicInsn(string, string4, handle, objectArray);
                    n2 += 5;
                    continue block38;
                }
                case 5: {
                    methodVisitor.visitTypeInsn(n3, this.readClass(n2 + 1, cArray));
                    n2 += 3;
                    continue block38;
                }
                case 13: {
                    methodVisitor.visitIincInsn(byArray[n2 + 1] & 0xFF, byArray[n2 + 2]);
                    n2 += 3;
                    continue block38;
                }
            }
            methodVisitor.visitMultiANewArrayInsn(this.readClass(n2 + 1, cArray), byArray[n2 + 3] & 0xFF);
            n2 += 4;
        }
        if (labelArray[n9] != null) {
            methodVisitor.visitLabel(labelArray[n9]);
        }
        if ((context.b & 2) == 0 && n6 != 0) {
            int[] nArray = null;
            if (n14 != 0) {
                n2 = n14 + 2;
                nArray = new int[this.readUnsignedShort(n14) * 3];
                int n25 = nArray.length;
                while (n25 > 0) {
                    nArray[--n25] = n2 + 6;
                    nArray[--n25] = this.readUnsignedShort(n2 + 8);
                    nArray[--n25] = this.readUnsignedShort(n2);
                    n2 += 10;
                }
            }
            n2 = n6 + 2;
            for (int i5 = this.readUnsignedShort(n6); i5 > 0; --i5) {
                n3 = this.readUnsignedShort(n2);
                n4 = this.readUnsignedShort(n2 + 2);
                int n26 = this.readUnsignedShort(n2 + 8);
                String string = null;
                if (nArray != null) {
                    for (int i6 = 0; i6 < nArray.length; i6 += 3) {
                        if (nArray[i6] != n3 || nArray[i6 + 1] != n26) continue;
                        string = this.readUTF8(nArray[i6 + 2], cArray);
                        break;
                    }
                }
                methodVisitor.visitLocalVariable(this.readUTF8(n2 + 4, cArray), this.readUTF8(n2 + 6, cArray), string, labelArray[n3], labelArray[n3 + n4], n26);
                n2 += 10;
            }
        }
        while (attribute != null) {
            Attribute attribute3 = attribute.a;
            attribute.a = null;
            methodVisitor.visitAttribute(attribute);
            attribute = attribute3;
        }
        methodVisitor.visitMaxs(n7, n8);
    }

    private void a(int n2, String string, char[] cArray, boolean bl, MethodVisitor methodVisitor) {
        AnnotationVisitor annotationVisitor;
        int n3;
        int n4 = this.b[n2++] & 0xFF;
        int n5 = Type.getArgumentTypes(string).length - n4;
        for (n3 = 0; n3 < n5; ++n3) {
            annotationVisitor = methodVisitor.visitParameterAnnotation(n3, "Ljava/lang/Synthetic;", false);
            if (annotationVisitor == null) continue;
            annotationVisitor.visitEnd();
        }
        while (n3 < n4 + n5) {
            int n6 = this.readUnsignedShort(n2);
            n2 += 2;
            while (n6 > 0) {
                annotationVisitor = methodVisitor.visitParameterAnnotation(n3, this.readUTF8(n2, cArray), bl);
                n2 = this.a(n2 + 2, cArray, true, annotationVisitor);
                --n6;
            }
            ++n3;
        }
    }

    private int a(int n2, char[] cArray, boolean bl, AnnotationVisitor annotationVisitor) {
        int n3 = this.readUnsignedShort(n2);
        n2 += 2;
        if (bl) {
            while (n3 > 0) {
                n2 = this.a(n2 + 2, cArray, this.readUTF8(n2, cArray), annotationVisitor);
                --n3;
            }
        } else {
            while (n3 > 0) {
                n2 = this.a(n2, cArray, null, annotationVisitor);
                --n3;
            }
        }
        if (annotationVisitor != null) {
            annotationVisitor.visitEnd();
        }
        return n2;
    }

    private int a(int n2, char[] cArray, String string, AnnotationVisitor annotationVisitor) {
        if (annotationVisitor == null) {
            switch (this.b[n2] & 0xFF) {
                case 101: {
                    return n2 + 5;
                }
                case 64: {
                    return this.a(n2 + 3, cArray, true, null);
                }
                case 91: {
                    return this.a(n2 + 1, cArray, false, null);
                }
            }
            return n2 + 3;
        }
        block5 : switch (this.b[n2++] & 0xFF) {
            case 68: 
            case 70: 
            case 73: 
            case 74: {
                annotationVisitor.visit(string, this.readConst(this.readUnsignedShort(n2), cArray));
                n2 += 2;
                break;
            }
            case 66: {
                annotationVisitor.visit(string, new Byte((byte)this.readInt(this.a[this.readUnsignedShort(n2)])));
                n2 += 2;
                break;
            }
            case 90: {
                annotationVisitor.visit(string, this.readInt(this.a[this.readUnsignedShort(n2)]) == 0 ? Boolean.FALSE : Boolean.TRUE);
                n2 += 2;
                break;
            }
            case 83: {
                annotationVisitor.visit(string, new Short((short)this.readInt(this.a[this.readUnsignedShort(n2)])));
                n2 += 2;
                break;
            }
            case 67: {
                annotationVisitor.visit(string, new Character((char)this.readInt(this.a[this.readUnsignedShort(n2)])));
                n2 += 2;
                break;
            }
            case 115: {
                annotationVisitor.visit(string, this.readUTF8(n2, cArray));
                n2 += 2;
                break;
            }
            case 101: {
                annotationVisitor.visitEnum(string, this.readUTF8(n2, cArray), this.readUTF8(n2 + 2, cArray));
                n2 += 4;
                break;
            }
            case 99: {
                annotationVisitor.visit(string, Type.getType(this.readUTF8(n2, cArray)));
                n2 += 2;
                break;
            }
            case 64: {
                n2 = this.a(n2 + 2, cArray, true, annotationVisitor.visitAnnotation(string, this.readUTF8(n2, cArray)));
                break;
            }
            case 91: {
                int n3 = this.readUnsignedShort(n2);
                n2 += 2;
                if (n3 == 0) {
                    return this.a(n2 - 2, cArray, false, annotationVisitor.visitArray(string));
                }
                switch (this.b[n2++] & 0xFF) {
                    case 66: {
                        byte[] byArray = new byte[n3];
                        for (int i2 = 0; i2 < n3; ++i2) {
                            byArray[i2] = (byte)this.readInt(this.a[this.readUnsignedShort(n2)]);
                            n2 += 3;
                        }
                        annotationVisitor.visit(string, byArray);
                        --n2;
                        break block5;
                    }
                    case 90: {
                        boolean[] blArray = new boolean[n3];
                        for (int i3 = 0; i3 < n3; ++i3) {
                            blArray[i3] = this.readInt(this.a[this.readUnsignedShort(n2)]) != 0;
                            n2 += 3;
                        }
                        annotationVisitor.visit(string, blArray);
                        --n2;
                        break block5;
                    }
                    case 83: {
                        short[] sArray = new short[n3];
                        for (int i4 = 0; i4 < n3; ++i4) {
                            sArray[i4] = (short)this.readInt(this.a[this.readUnsignedShort(n2)]);
                            n2 += 3;
                        }
                        annotationVisitor.visit(string, sArray);
                        --n2;
                        break block5;
                    }
                    case 67: {
                        char[] cArray2 = new char[n3];
                        for (int i5 = 0; i5 < n3; ++i5) {
                            cArray2[i5] = (char)this.readInt(this.a[this.readUnsignedShort(n2)]);
                            n2 += 3;
                        }
                        annotationVisitor.visit(string, cArray2);
                        --n2;
                        break block5;
                    }
                    case 73: {
                        int[] nArray = new int[n3];
                        for (int i6 = 0; i6 < n3; ++i6) {
                            nArray[i6] = this.readInt(this.a[this.readUnsignedShort(n2)]);
                            n2 += 3;
                        }
                        annotationVisitor.visit(string, nArray);
                        --n2;
                        break block5;
                    }
                    case 74: {
                        long[] lArray = new long[n3];
                        for (int i7 = 0; i7 < n3; ++i7) {
                            lArray[i7] = this.readLong(this.a[this.readUnsignedShort(n2)]);
                            n2 += 3;
                        }
                        annotationVisitor.visit(string, lArray);
                        --n2;
                        break block5;
                    }
                    case 70: {
                        float[] fArray = new float[n3];
                        for (int i8 = 0; i8 < n3; ++i8) {
                            fArray[i8] = Float.intBitsToFloat(this.readInt(this.a[this.readUnsignedShort(n2)]));
                            n2 += 3;
                        }
                        annotationVisitor.visit(string, fArray);
                        --n2;
                        break block5;
                    }
                    case 68: {
                        double[] dArray = new double[n3];
                        for (int i9 = 0; i9 < n3; ++i9) {
                            dArray[i9] = Double.longBitsToDouble(this.readLong(this.a[this.readUnsignedShort(n2)]));
                            n2 += 3;
                        }
                        annotationVisitor.visit(string, dArray);
                        --n2;
                        break block5;
                    }
                }
                n2 = this.a(n2 - 3, cArray, false, annotationVisitor.visitArray(string));
            }
        }
        return n2;
    }

    private void a(Context context) {
        String string = context.g;
        Object[] objectArray = context.l;
        int n2 = 0;
        if ((context.e & 8) == 0) {
            objectArray[n2++] = "<init>".equals(context.f) ? Opcodes.UNINITIALIZED_THIS : this.readClass(this.header + 2, context.c);
        }
        int n3 = 1;
        block8: while (true) {
            int n4 = n3;
            switch (string.charAt(n3++)) {
                case 'B': 
                case 'C': 
                case 'I': 
                case 'S': 
                case 'Z': {
                    objectArray[n2++] = Opcodes.INTEGER;
                    continue block8;
                }
                case 'F': {
                    objectArray[n2++] = Opcodes.FLOAT;
                    continue block8;
                }
                case 'J': {
                    objectArray[n2++] = Opcodes.LONG;
                    continue block8;
                }
                case 'D': {
                    objectArray[n2++] = Opcodes.DOUBLE;
                    continue block8;
                }
                case '[': {
                    while (string.charAt(n3) == '[') {
                        ++n3;
                    }
                    if (string.charAt(n3) == 'L') {
                        ++n3;
                        while (string.charAt(n3) != ';') {
                            ++n3;
                        }
                    }
                    objectArray[n2++] = string.substring(n4, ++n3);
                    continue block8;
                }
                case 'L': {
                    while (string.charAt(n3) != ';') {
                        ++n3;
                    }
                    objectArray[n2++] = string.substring(n4 + 1, n3++);
                    continue block8;
                }
            }
            break;
        }
        context.j = n2;
    }

    private int a(int n2, boolean bl, boolean bl2, Label[] labelArray, Context context) {
        int n3;
        int n4;
        char[] cArray = context.c;
        if (bl) {
            n4 = this.b[n2++] & 0xFF;
        } else {
            n4 = 255;
            context.h = -1;
        }
        context.k = 0;
        if (n4 < 64) {
            n3 = n4;
            context.i = 3;
            context.m = 0;
        } else if (n4 < 128) {
            n3 = n4 - 64;
            n2 = this.a(context.n, 0, n2, cArray, labelArray);
            context.i = 4;
            context.m = 1;
        } else {
            n3 = this.readUnsignedShort(n2);
            n2 += 2;
            if (n4 == 247) {
                n2 = this.a(context.n, 0, n2, cArray, labelArray);
                context.i = 4;
                context.m = 1;
            } else if (n4 >= 248 && n4 < 251) {
                context.i = 2;
                context.k = 251 - n4;
                context.j -= context.k;
                context.m = 0;
            } else if (n4 == 251) {
                context.i = 3;
                context.m = 0;
            } else if (n4 < 255) {
                int n5 = bl2 ? context.j : 0;
                for (int i2 = n4 - 251; i2 > 0; --i2) {
                    n2 = this.a(context.l, n5++, n2, cArray, labelArray);
                }
                context.i = 1;
                context.k = n4 - 251;
                context.j += context.k;
                context.m = 0;
            } else {
                context.i = 0;
                int n6 = this.readUnsignedShort(n2);
                n2 += 2;
                context.k = n6;
                context.j = n6;
                int n7 = 0;
                while (n6 > 0) {
                    n2 = this.a(context.l, n7++, n2, cArray, labelArray);
                    --n6;
                }
                n6 = this.readUnsignedShort(n2);
                n2 += 2;
                context.m = n6;
                n7 = 0;
                while (n6 > 0) {
                    n2 = this.a(context.n, n7++, n2, cArray, labelArray);
                    --n6;
                }
            }
        }
        context.h += n3 + 1;
        this.readLabel(context.h, labelArray);
        return n2;
    }

    private int a(Object[] objectArray, int n2, int n3, char[] cArray, Label[] labelArray) {
        int n4 = this.b[n3++] & 0xFF;
        switch (n4) {
            case 0: {
                objectArray[n2] = Opcodes.TOP;
                break;
            }
            case 1: {
                objectArray[n2] = Opcodes.INTEGER;
                break;
            }
            case 2: {
                objectArray[n2] = Opcodes.FLOAT;
                break;
            }
            case 3: {
                objectArray[n2] = Opcodes.DOUBLE;
                break;
            }
            case 4: {
                objectArray[n2] = Opcodes.LONG;
                break;
            }
            case 5: {
                objectArray[n2] = Opcodes.NULL;
                break;
            }
            case 6: {
                objectArray[n2] = Opcodes.UNINITIALIZED_THIS;
                break;
            }
            case 7: {
                objectArray[n2] = this.readClass(n3, cArray);
                n3 += 2;
                break;
            }
            default: {
                objectArray[n2] = this.readLabel(this.readUnsignedShort(n3), labelArray);
                n3 += 2;
            }
        }
        return n3;
    }

    protected Label readLabel(int n2, Label[] labelArray) {
        if (labelArray[n2] == null) {
            labelArray[n2] = new Label();
        }
        return labelArray[n2];
    }

    private int a() {
        int n2;
        int n3;
        int n4 = this.header + 8 + this.readUnsignedShort(this.header + 6) * 2;
        for (n3 = this.readUnsignedShort(n4); n3 > 0; --n3) {
            for (n2 = this.readUnsignedShort(n4 + 8); n2 > 0; --n2) {
                n4 += 6 + this.readInt(n4 + 12);
            }
            n4 += 8;
        }
        for (n3 = this.readUnsignedShort(n4 += 2); n3 > 0; --n3) {
            for (n2 = this.readUnsignedShort(n4 + 8); n2 > 0; --n2) {
                n4 += 6 + this.readInt(n4 + 12);
            }
            n4 += 8;
        }
        return n4 + 2;
    }

    private Attribute a(Attribute[] attributeArray, String string, int n2, int n3, char[] cArray, int n4, Label[] labelArray) {
        for (int i2 = 0; i2 < attributeArray.length; ++i2) {
            if (!attributeArray[i2].type.equals(string)) continue;
            return attributeArray[i2].read(this, n2, n3, cArray, n4, labelArray);
        }
        return new Attribute(string).read(this, n2, n3, null, -1, null);
    }

    public int getItemCount() {
        return this.a.length;
    }

    public int getItem(int n2) {
        return this.a[n2];
    }

    public int getMaxStringLength() {
        return this.d;
    }

    public int readByte(int n2) {
        return this.b[n2] & 0xFF;
    }

    public int readUnsignedShort(int n2) {
        byte[] byArray = this.b;
        return (byArray[n2] & 0xFF) << 8 | byArray[n2 + 1] & 0xFF;
    }

    public short readShort(int n2) {
        byte[] byArray = this.b;
        return (short)((byArray[n2] & 0xFF) << 8 | byArray[n2 + 1] & 0xFF);
    }

    public int readInt(int n2) {
        byte[] byArray = this.b;
        return (byArray[n2] & 0xFF) << 24 | (byArray[n2 + 1] & 0xFF) << 16 | (byArray[n2 + 2] & 0xFF) << 8 | byArray[n2 + 3] & 0xFF;
    }

    public long readLong(int n2) {
        long l2 = this.readInt(n2);
        long l3 = (long)this.readInt(n2 + 4) & 0xFFFFFFFFL;
        return l2 << 32 | l3;
    }

    public String readUTF8(int n2, char[] cArray) {
        int n3 = this.readUnsignedShort(n2);
        if (n2 == 0 || n3 == 0) {
            return null;
        }
        String string = this.c[n3];
        if (string != null) {
            return string;
        }
        n2 = this.a[n3];
        this.c[n3] = this.a(n2 + 2, this.readUnsignedShort(n2), cArray);
        return this.c[n3];
    }

    private String a(int n2, int n3, char[] cArray) {
        int n4 = n2 + n3;
        byte[] byArray = this.b;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        while (n2 < n4) {
            int n8 = byArray[n2++];
            switch (n6) {
                case 0: {
                    if ((n8 &= 0xFF) < 128) {
                        cArray[n5++] = (char)n8;
                        break;
                    }
                    if (n8 < 224 && n8 > 191) {
                        n7 = (char)(n8 & 0x1F);
                        n6 = 1;
                        break;
                    }
                    n7 = (char)(n8 & 0xF);
                    n6 = 2;
                    break;
                }
                case 1: {
                    cArray[n5++] = (char)(n7 << 6 | n8 & 0x3F);
                    n6 = 0;
                    break;
                }
                case 2: {
                    n7 = (char)(n7 << 6 | n8 & 0x3F);
                    n6 = 1;
                }
            }
        }
        return new String(cArray, 0, n5);
    }

    public String readClass(int n2, char[] cArray) {
        return this.readUTF8(this.a[this.readUnsignedShort(n2)], cArray);
    }

    public Object readConst(int n2, char[] cArray) {
        int n3 = this.a[n2];
        switch (this.b[n3 - 1]) {
            case 3: {
                return new Integer(this.readInt(n3));
            }
            case 4: {
                return new Float(Float.intBitsToFloat(this.readInt(n3)));
            }
            case 5: {
                return new Long(this.readLong(n3));
            }
            case 6: {
                return new Double(Double.longBitsToDouble(this.readLong(n3)));
            }
            case 7: {
                return Type.getObjectType(this.readUTF8(n3, cArray));
            }
            case 8: {
                return this.readUTF8(n3, cArray);
            }
            case 16: {
                return Type.getMethodType(this.readUTF8(n3, cArray));
            }
        }
        int n4 = this.readByte(n3);
        int[] nArray = this.a;
        int n5 = nArray[this.readUnsignedShort(n3 + 1)];
        String string = this.readClass(n5, cArray);
        n5 = nArray[this.readUnsignedShort(n5 + 2)];
        String string2 = this.readUTF8(n5, cArray);
        String string3 = this.readUTF8(n5 + 2, cArray);
        return new Handle(n4, string, string2, string3);
    }
}

