/*
 * Decompiled with CFR 0.152.
 */
package jinngine.math;

import java.io.Serializable;
import jinngine.math.Matrix3;
import jinngine.math.Matrix4;
import jinngine.math.Vector3;

public final class Quaternion
implements Serializable {
    private static final long serialVersionUID = 1L;
    public final Vector3 v = new Vector3(1.0, 0.0, 0.0);
    public double s = 0.0;

    public Quaternion() {
    }

    public Quaternion(double s, Vector3 v) {
        this.s = s;
        this.v.assign(v);
    }

    public static Quaternion rotation(double theta, Vector3 n) {
        return new Quaternion(Math.cos(theta / 2.0), n.multiply(Math.sin(theta / 2.0)));
    }

    public Quaternion multiply(Quaternion q) {
        return new Quaternion(this.s * q.s - this.v.dot(q.v), q.v.multiply(this.s).add(this.v.multiply(q.s)).add(this.v.cross(q.v)));
    }

    public final void set(Quaternion qmark) {
        this.s = qmark.s;
        this.v.assign(qmark.v);
    }

    public static Quaternion sMultiply(Quaternion q1, Quaternion q2) {
        double new_s = q1.s * q2.s - q1.v.dot(q2.v);
        Vector3 new_v = q2.v.multiply(q1.s).add(q1.v.multiply(q2.s)).add(q1.v.cross(q2.v));
        q1.s = new_s;
        q1.v.assign(new_v);
        return q1;
    }

    public final void assign(double s, Vector3 v) {
        this.s = s;
        this.v.assign(v);
    }

    public final void assign(Quaternion q1) {
        this.s = q1.s;
        this.v.assign(q1.v);
    }

    public final void assign(Matrix3 m) {
        this.s = Math.sqrt(1.0 + m.a11 + m.a22 + m.a33) / 2.0;
        double w4 = 4.0 * this.s;
        this.v.x = (m.a32 - m.a23) / w4;
        this.v.y = (m.a13 - m.a31) / w4;
        this.v.z = (m.a21 - m.a12) / w4;
    }

    public Vector3 rotate(Vector3 v) {
        Quaternion vq = new Quaternion(0.0, v);
        Quaternion rotatet = this.multiply(vq).multiply(this.conjugate());
        return rotatet.v.copy();
    }

    public static final void applyRotation(Quaternion q, Vector3 v) {
        Vector3 vtemp = new Vector3(0.0, 0.0, 0.0);
        double s = -Vector3.dot(q.v, v);
        Vector3.multiply(v, q.s, vtemp);
        Vector3.crossProduct(q.v, v, v);
        Vector3.add(v, vtemp);
        vtemp.assign(Vector3.zero);
        Vector3.multiply(q.v, -1.0);
        Vector3.multiplyAndAdd(q.v, s, vtemp);
        Vector3.multiplyAndAdd(v, q.s, vtemp);
        Vector3.crossProduct(v, q.v, v);
        Vector3.add(v, vtemp);
        Vector3.multiply(q.v, -1.0);
    }

    public Quaternion add(Quaternion q) {
        return new Quaternion(this.s + q.s, this.v.add(q.v));
    }

    public static void add(Quaternion q, Quaternion a) {
        q.s += a.s;
        Vector3.add(q.v, a.v);
    }

    public Quaternion multiply(double a) {
        return new Quaternion(this.s * a, this.v.multiply(a));
    }

    public double norm() {
        return Math.sqrt(this.s * this.s + this.v.squaredNorm());
    }

    public Quaternion conjugate() {
        return new Quaternion(this.s, this.v.multiply(-1.0));
    }

    public static final void conjugate(Quaternion q) {
        Vector3.multiply(q.v, -1.0);
    }

    public static Matrix3 toRotationMatrix3(Quaternion q, Matrix3 R) {
        Vector3 v = q.v;
        double s = q.s;
        Matrix3.set(R, 1.0 - 2.0 * (v.y * v.y + v.z * v.z), 2.0 * v.x * v.y - 2.0 * s * v.z, 2.0 * s * v.y + 2.0 * v.x * v.z, 2.0 * v.x * v.y + 2.0 * s * v.z, 1.0 - 2.0 * (v.x * v.x + v.z * v.z), -2.0 * s * v.x + 2.0 * v.y * v.z, -2.0 * s * v.y + 2.0 * v.x * v.z, 2.0 * s * v.x + 2.0 * v.y * v.z, 1.0 - 2.0 * (v.x * v.x + v.y * v.y));
        return R;
    }

    public Matrix3 toRotationMatrix3() {
        return Quaternion.toRotationMatrix3(this, new Matrix3());
    }

    public Matrix4 rotationMatrix4() {
        Matrix4 M = new Matrix4();
        Vector3 v = this.v;
        double s = this.s;
        M.a11 = 1.0 - 2.0 * (v.y * v.y + v.z * v.z);
        M.a12 = 2.0 * v.x * v.y - 2.0 * s * v.z;
        M.a13 = 2.0 * s * v.y + 2.0 * v.x * v.z;
        M.a21 = 2.0 * v.x * v.y + 2.0 * s * v.z;
        M.a22 = 1.0 - 2.0 * (v.x * v.x + v.z * v.z);
        M.a23 = -2.0 * s * v.x + 2.0 * v.y * v.z;
        M.a31 = -2.0 * s * v.y + 2.0 * v.x * v.z;
        M.a32 = 2.0 * s * v.x + 2.0 * v.y * v.z;
        M.a33 = 1.0 - 2.0 * (v.x * v.x + v.y * v.y);
        M.a44 = 1.0;
        return M;
    }

    public void normalize() {
        double l = Math.sqrt(this.s * this.s + this.v.x * this.v.x + this.v.y * this.v.y + this.v.z * this.v.z);
        this.s /= l;
        this.v.x /= l;
        this.v.y /= l;
        this.v.z /= l;
    }

    public Quaternion copy() {
        return new Quaternion(this.s, this.v);
    }

    public final double dot(Quaternion q) {
        return this.v.dot(q.v) + this.s * q.s;
    }

    public final Quaternion interpolate(Quaternion q2, double t) {
        Quaternion qa = this;
        Quaternion qb = q2;
        double theta = Math.acos(qa.dot(qb));
        if (Math.abs(theta) < 1.0E-7) {
            return this;
        }
        return qa.multiply(Math.sin((1.0 - t) * theta)).add(qb.multiply(Math.sin(t * theta))).multiply(1.0 / Math.sin(theta));
    }

    public static final Vector3 anguarVelocity(Quaternion q0, Quaternion q1) {
        Quaternion q0inv = new Quaternion(q0.s, q0.v.multiply(-1.0)).multiply(1.0 / q0.dot(q0));
        Quaternion r = q0inv.multiply(q1);
        double sinomeganormhalf = r.v.norm();
        if (sinomeganormhalf < 1.0E-7) {
            return new Vector3();
        }
        Vector3 n = r.v.multiply(1.0 / sinomeganormhalf);
        double omegaNorm = Math.asin(sinomeganormhalf) * 2.0;
        return n.multiply(omegaNorm);
    }

    public static final Quaternion orientation(Vector3 unit) {
        Vector3 i = Vector3.i;
        double theta = Math.acos(i.dot(unit));
        Vector3 v = i.cross(unit);
        System.out.println("rotation axis is");
        v.print();
        System.out.println("and angle is " + theta);
        return Quaternion.rotation(theta, v);
    }

    public void Print() {
        System.out.println("[ " + this.s);
        this.v.print();
        System.out.println("]");
    }
}

