/*
 * Decompiled with CFR 0.152.
 */
package com.flansmod.common.teams;

import com.flansmod.common.FlansMod;
import com.flansmod.common.PlayerData;
import com.flansmod.common.PlayerHandler;
import com.flansmod.common.driveables.ItemPlane;
import com.flansmod.common.driveables.ItemVehicle;
import com.flansmod.common.guns.BulletType;
import com.flansmod.common.guns.GunType;
import com.flansmod.common.guns.ItemAAGun;
import com.flansmod.common.guns.ItemBullet;
import com.flansmod.common.guns.ItemGun;
import com.flansmod.common.network.PacketTeamInfo;
import com.flansmod.common.teams.EntityGunItem;
import com.flansmod.common.teams.Gametype;
import com.flansmod.common.teams.GametypeCTF;
import com.flansmod.common.teams.GametypeConquest;
import com.flansmod.common.teams.GametypeDM;
import com.flansmod.common.teams.GametypeNerf;
import com.flansmod.common.teams.GametypeTDM;
import com.flansmod.common.teams.ITeamBase;
import com.flansmod.common.teams.ITeamObject;
import com.flansmod.common.teams.ItemOpStick;
import com.flansmod.common.teams.ItemTeamArmour;
import com.flansmod.common.teams.PlayerClass;
import com.flansmod.common.teams.Team;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.PlayerEvent;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.passive.EntityHorse;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S18PacketEntityTeleport;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.util.EntityDamageSource;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.MathHelper;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.WorldSettings;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.player.EntityInteractEvent;
import net.minecraftforge.event.entity.player.EntityItemPickupEvent;
import net.minecraftforge.event.entity.player.PlayerDropsEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.world.ChunkDataEvent;
import net.minecraftforge.event.world.WorldEvent;

public class TeamsManager {
    public static boolean useRotation = false;
    public static boolean explosions = true;
    public static boolean driveablesBreakBlocks = true;
    public static boolean bombsEnabled = true;
    public static boolean bulletsEnabled = true;
    public static boolean forceAdventureMode = true;
    public static boolean canBreakGuns = true;
    public static boolean canBreakGlass = true;
    public static boolean armourDrops = true;
    public static boolean vehiclesNeedFuel = true;
    public static int weaponDrops = 1;
    public static int mgLife = 0;
    public static int planeLife = 0;
    public static int vehicleLife = 0;
    public static int mechaLove = 0;
    public static int aaLife = 0;
    public Gametype currentGametype;
    public TeamsMap currentMap;
    public Team[] teams;
    public static TeamsManager instance;
    public List<ITeamBase> bases;
    public List<ITeamObject> objects;
    public List<TeamsMap> maps;
    private int nextBaseID = 1;
    private long time;
    public List<RotationEntry> rotation;
    public int currentRotationEntry;

    public TeamsManager() {
        instance = this;
        MinecraftForge.EVENT_BUS.register((Object)this);
        this.bases = new ArrayList<ITeamBase>();
        this.objects = new ArrayList<ITeamObject>();
        this.maps = new ArrayList<TeamsMap>();
        this.maps.add(TeamsMap.def);
        this.rotation = new ArrayList<RotationEntry>();
        this.currentMap = TeamsMap.def;
        new GametypeTDM();
        new GametypeConquest();
        new GametypeDM();
        new GametypeCTF();
        new GametypeNerf();
    }

    public void reset() {
        this.currentGametype = null;
        this.currentMap = TeamsMap.def;
        this.teams = null;
        this.bases = new ArrayList<ITeamBase>();
        this.objects = new ArrayList<ITeamObject>();
        this.maps = new ArrayList<TeamsMap>();
        this.maps.add(TeamsMap.def);
        this.rotation = new ArrayList<RotationEntry>();
    }

    public static TeamsManager getInstance() {
        return instance;
    }

    public void tick() {
        if (this.currentGametype != null) {
            this.currentGametype.tick();
        }
        ++this.time;
        if (this.time % 40L == 0L) {
            FlansMod.INSTANCE.getPacketHandler().sendToAll(new PacketTeamInfo());
        }
        for (ITeamBase base : this.bases) {
            base.tick();
        }
        for (ITeamObject object : this.objects) {
            object.tick();
        }
        for (Object obj : MinecraftServer.func_71276_C().func_71203_ab().field_72404_b) {
            EntityPlayerMP player = (EntityPlayerMP)obj;
            PlayerData data = PlayerHandler.getPlayerData((EntityPlayer)player);
            if (data.spawnDelay != 0) continue;
            WorldServer world = (WorldServer)player.field_70170_p;
            world.func_73039_n().func_151247_a((Entity)player, (Packet)new S18PacketEntityTeleport((Entity)player));
        }
    }

    public void switchToNextGametype() {
        PlayerHandler.roundEnded();
        this.currentRotationEntry = (this.currentRotationEntry + 1) % this.rotation.size();
        RotationEntry entry = this.rotation.get(this.currentRotationEntry);
        if (this.currentGametype != null && this.currentGametype != entry.gametype) {
            this.currentGametype.stopGametype();
        }
        this.currentGametype = entry.gametype;
        this.currentMap = entry.map;
        this.teams = entry.teams;
        this.currentGametype.initGametype();
    }

    public EntityPlayerMP getPlayer(String username) {
        return MinecraftServer.func_71276_C().func_71203_ab().func_72361_f(username);
    }

    public static void log(String s) {
        FlansMod.log("Teams Info : " + s);
    }

    public static void messagePlayer(EntityPlayerMP player, String s) {
        player.func_146105_b((IChatComponent)new ChatComponentText(s));
    }

    public static void messageAll(String s) {
        FlansMod.log("Teams Announcement : " + s);
        for (EntityPlayerMP player : MinecraftServer.func_71276_C().func_71203_ab().field_72404_b) {
            player.func_146105_b((IChatComponent)new ChatComponentText(s));
        }
    }

    @SubscribeEvent
    public void onPlayerUpdate(EntityInteractEvent event) {
        if (event.entityPlayer.field_71071_by.func_70448_g() != null && event.entityPlayer.field_71071_by.func_70448_g().func_77973_b() instanceof ItemOpStick) {
            ((ItemOpStick)event.entityPlayer.field_71071_by.func_70448_g().func_77973_b()).clickedEntity(event.entityPlayer.field_70170_p, event.entityPlayer, event.target);
        }
    }

    @SubscribeEvent
    public void onEntityHurt(LivingAttackEvent event) {
        if (event.entity instanceof EntityPlayerMP && this.currentGametype != null && !this.currentGametype.playerAttacked((EntityPlayerMP)event.entity, event.source)) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onEntityKilled(LivingDeathEvent event) {
        if (event.entity instanceof EntityPlayerMP && this.currentGametype != null) {
            ItemStack stack;
            Entity entity;
            EntityPlayerMP killed = (EntityPlayerMP)event.entity;
            this.currentGametype.playerKilled(killed, event.source);
            if (event.source instanceof EntityDamageSource && (entity = event.source.func_76364_f()) instanceof EntityPlayer && (stack = ((EntityPlayer)entity).func_71045_bC()) != null && stack.func_77973_b() != null && stack.func_77973_b() instanceof ItemGun) {
                TeamsManager.messageAll("flanDeath." + ((ItemGun)stack.func_77973_b()).type.shortName + "." + PlayerHandler.getPlayerData((EntityPlayer)killed).team.textColour + event.entity.func_70005_c_() + "." + PlayerHandler.getPlayerData((EntityPlayer)((EntityPlayer)entity)).team.textColour + entity.func_145782_y());
            }
        }
    }

    @SubscribeEvent
    public void entityJoinedWorld(EntityJoinWorldEvent event) {
        if (event.entity instanceof ITeamBase) {
            this.registerBase((ITeamBase)event.entity);
        }
        if (event.entity instanceof ITeamObject) {
            this.objects.add((ITeamObject)event.entity);
        }
    }

    @SubscribeEvent
    public void playerInteracted(PlayerInteractEvent event) {
        if (event.action == PlayerInteractEvent.Action.LEFT_CLICK_BLOCK && !event.entityPlayer.field_71075_bZ.field_75099_e) {
            event.setCanceled(true);
            return;
        }
        if (event.entityPlayer.field_70170_p.field_72995_K) {
            return;
        }
        TileEntity te = event.entityPlayer.field_70170_p.func_147438_o(event.x, event.y, event.z);
        if (te != null) {
            ItemStack currentItem = event.entityPlayer.func_71045_bC();
            if (currentItem != null && currentItem.func_77973_b() != null && currentItem.func_77973_b() instanceof ItemOpStick) {
                if (te instanceof ITeamObject) {
                    ((ItemOpStick)currentItem.func_77973_b()).clickedObject(event.entityPlayer.field_70170_p, (EntityPlayerMP)event.entityPlayer, (ITeamObject)te);
                }
                if (te instanceof ITeamBase) {
                    ((ItemOpStick)currentItem.func_77973_b()).clickedBase(event.entityPlayer.field_70170_p, (EntityPlayerMP)event.entityPlayer, (ITeamBase)te);
                }
            } else if (this.currentGametype != null) {
                if (te instanceof ITeamObject) {
                    this.currentGametype.objectClickedByPlayer((ITeamObject)te, (EntityPlayerMP)event.entityPlayer);
                }
                if (te instanceof ITeamBase) {
                    this.currentGametype.baseClickedByPlayer((ITeamBase)te, (EntityPlayerMP)event.entityPlayer);
                }
            }
        }
    }

    @SubscribeEvent
    public void playerDrops(PlayerDropsEvent event) {
        ItemStack stack;
        ArrayList<EntityItem> dropsToThrow = new ArrayList<EntityItem>();
        if (weaponDrops == 2) {
            for (EntityItem entity : event.drops) {
                stack = entity.func_92059_d();
                if (stack == null || stack.func_77973_b() == null || !(stack.func_77973_b() instanceof ItemGun)) continue;
                EntityGunItem gunEntity = new EntityGunItem(entity);
                stack.field_77994_a = 0;
                boolean alreadyAdded = false;
                for (EntityItem check : dropsToThrow) {
                    if (((ItemGun)stack.func_77973_b()).type != ((ItemGun)check.func_92059_d().func_77973_b()).type) continue;
                    alreadyAdded = true;
                }
                if (alreadyAdded) continue;
                event.entityPlayer.field_70170_p.func_72838_d((Entity)gunEntity);
                dropsToThrow.add(gunEntity);
            }
        }
        for (EntityItem entity : dropsToThrow) {
            EntityGunItem gunEntity = (EntityGunItem)entity;
            GunType gunType = ((ItemGun)gunEntity.func_92059_d().func_77973_b()).type;
            for (EntityItem ammoEntity : event.drops) {
                BulletType bulletType;
                ItemStack ammoItemstack = ammoEntity.func_92059_d();
                if (ammoItemstack == null || !(ammoItemstack.func_77973_b() instanceof ItemBullet) || !gunType.isAmmo(bulletType = ((ItemBullet)ammoItemstack.func_77973_b()).type)) continue;
                gunEntity.ammoStacks.add(ammoItemstack.func_77946_l());
                ammoItemstack.field_77994_a = 0;
            }
        }
        for (EntityItem entity : event.drops) {
            stack = entity.func_92059_d();
            if (stack == null || stack.func_77973_b() == null || stack.field_77994_a <= 0) continue;
            if (stack.func_77973_b() instanceof ItemGun || stack.func_77973_b() instanceof ItemPlane || stack.func_77973_b() instanceof ItemVehicle || stack.func_77973_b() instanceof ItemAAGun || stack.func_77973_b() instanceof ItemBullet) {
                if (weaponDrops == 1) continue;
                dropsToThrow.add(entity);
                continue;
            }
            if (!(stack.func_77973_b() instanceof ItemTeamArmour) || armourDrops) continue;
            dropsToThrow.add(entity);
        }
        event.drops.removeAll(dropsToThrow);
    }

    @SubscribeEvent
    public void playerLoot(EntityItemPickupEvent event) {
        PlayerData data = PlayerHandler.getPlayerData(event.entityPlayer);
        if (data != null && data.team == Team.spectators) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void chunkLoaded(ChunkDataEvent event) {
        Chunk chunk = event.getChunk();
        for (List list : chunk.field_76645_j) {
            for (Entity entity : list) {
                if (entity instanceof ITeamBase) {
                    this.bases.add((ITeamBase)entity);
                    if (((ITeamBase)entity).getID() > this.nextBaseID) {
                        FlansMod.log("Loaded base with ID higher than the supposed highest ID. Adjusted highest ID");
                        this.nextBaseID = ((ITeamBase)entity).getID();
                    }
                }
                if (!(entity instanceof ITeamObject)) continue;
                this.objects.add((ITeamObject)entity);
            }
        }
    }

    @SubscribeEvent
    public void worldData(WorldEvent event) {
        if (event.world.field_72995_K) {
            return;
        }
        if (event instanceof WorldEvent.Load) {
            this.loadPerWorldData((Event)event, event.world);
            this.savePerWorldData((Event)event, event.world);
        }
        if (event instanceof WorldEvent.Save) {
            this.savePerWorldData((Event)event, event.world);
        }
    }

    private void loadPerWorldData(Event event, World world) {
        this.reset();
        File file = new File(FMLCommonHandler.instance().getSide().isClient() ? "saves/" + MinecraftServer.func_71276_C().func_71221_J() : MinecraftServer.func_71276_C().func_71270_I(), "teams.dat");
        if (!this.checkFileExists(file)) {
            return;
        }
        try {
            int i;
            NBTTagCompound tags = CompressedStreamTools.func_74794_a((DataInput)new DataInputStream(new FileInputStream(file)));
            this.nextBaseID = tags.func_74762_e("NextBaseID");
            for (i = 0; i < tags.func_74762_e("NumMaps"); ++i) {
                String shortName = tags.func_74779_i("MapShortName " + i);
                if (shortName.equals("default")) continue;
                this.maps.add(new TeamsMap(shortName, tags.func_74779_i("MapName " + i)));
            }
            this.currentMap = this.getTeamsMap(tags.func_74779_i("Map"));
            this.currentGametype = Gametype.getGametype(tags.func_74779_i("Gametype"));
            if (this.currentGametype != null) {
                this.currentGametype.initGametype();
                this.currentGametype.readFromNBT(tags);
                this.teams = new Team[this.currentGametype.numTeamsRequired];
                for (i = 0; i < this.teams.length; ++i) {
                    this.teams[i] = Team.getTeam(tags.func_74779_i("Team " + i));
                }
            }
            int rotationSize = tags.func_74762_e("RotationSize");
            for (int i2 = 0; i2 < rotationSize; ++i2) {
                TeamsMap map = this.getTeamsMap(tags.func_74779_i("RotationMap " + i2));
                Gametype gametype = Gametype.getGametype(tags.func_74779_i("RotationGametype " + i2));
                int nTeams = tags.func_74762_e("RotationTeams " + i2);
                Team[] demTeams = new Team[nTeams];
                for (int j = 0; j < nTeams; ++j) {
                    demTeams[j] = Team.getTeam(tags.func_74779_i("RotationTeam " + i2 + " " + j));
                }
                if (map == null || gametype == null) continue;
                this.rotation.add(new RotationEntry(map, gametype, demTeams));
            }
            useRotation = tags.func_74767_n("UseRotation");
            bombsEnabled = tags.func_74767_n("Bombs");
            bulletsEnabled = tags.func_74767_n("Bullets");
            explosions = tags.func_74767_n("Explosions");
            forceAdventureMode = tags.func_74767_n("ForceAdventure");
            canBreakGuns = tags.func_74767_n("CanBreakGuns");
            canBreakGlass = tags.func_74767_n("CanBreakGlass");
            armourDrops = tags.func_74767_n("ArmourDrops");
            weaponDrops = tags.func_74762_e("WeaponDrops");
            vehiclesNeedFuel = tags.func_74767_n("NeedFuel");
            mgLife = tags.func_74762_e("MGLife");
            aaLife = tags.func_74762_e("AALife");
            vehicleLife = tags.func_74762_e("VehicleLife");
            mechaLove = tags.func_74762_e("MechaLove");
            planeLife = tags.func_74762_e("PlaneLife");
            driveablesBreakBlocks = tags.func_74767_n("BreakBlocks");
        }
        catch (Exception e) {
            FlansMod.log("Failed to load from teams.dat");
            e.printStackTrace();
        }
    }

    private void savePerWorldData(Event event, World world) {
        File file = new File(FMLCommonHandler.instance().getSide().isClient() ? "saves/" + MinecraftServer.func_71276_C().func_71221_J() : MinecraftServer.func_71276_C().func_71270_I(), "teams.dat");
        this.checkFileExists(file);
        try {
            NBTTagCompound tags = new NBTTagCompound();
            tags.func_74768_a("NextBaseID", this.nextBaseID);
            tags.func_74768_a("NumMaps", this.maps.size());
            if (this.maps != null) {
                for (int i = 0; i < this.maps.size(); ++i) {
                    if (this.maps.get(i) == null) continue;
                    tags.func_74778_a("MapShortName " + i, this.maps.get((int)i).shortName);
                    tags.func_74778_a("MapName " + i, this.maps.get((int)i).name);
                }
            }
            if (this.currentMap != null) {
                tags.func_74778_a("Map", this.currentMap.shortName);
            }
            tags.func_74778_a("Gametype", this.currentGametype == null ? "None" : this.currentGametype.shortName);
            for (Gametype gametype : Gametype.gametypes) {
                gametype.saveToNBT(tags);
            }
            if (this.teams != null) {
                for (int i = 0; i < this.teams.length; ++i) {
                    if (this.teams[i] == null) continue;
                    tags.func_74778_a("Team " + i, this.teams[i].shortName);
                }
            }
            if (this.rotation != null) {
                tags.func_74768_a("RotationSize", this.rotation.size());
                for (int i = 0; i < this.rotation.size(); ++i) {
                    RotationEntry entry = this.rotation.get(i);
                    if (entry == null) continue;
                    tags.func_74778_a("RotationMap " + i, entry.map.shortName);
                    tags.func_74778_a("RotationGametype " + i, entry.gametype.shortName);
                    tags.func_74768_a("RotationTeams " + i, entry.teams.length);
                    for (int j = 0; j < entry.teams.length; ++j) {
                        tags.func_74778_a("RotationTeam " + i + " " + j, entry.teams[j].shortName);
                    }
                }
            } else {
                tags.func_74768_a("RotationSize", 0);
            }
            tags.func_74757_a("UseRotation", useRotation);
            tags.func_74757_a("Bombs", bombsEnabled);
            tags.func_74757_a("Bullets", bulletsEnabled);
            tags.func_74757_a("Explosions", explosions);
            tags.func_74757_a("ForceAdventure", forceAdventureMode);
            tags.func_74757_a("CanBreakGuns", canBreakGuns);
            tags.func_74757_a("CanBreakGlass", canBreakGlass);
            tags.func_74757_a("ArmourDrops", armourDrops);
            tags.func_74768_a("WeaponDrops", weaponDrops);
            tags.func_74757_a("NeedFuel", vehiclesNeedFuel);
            tags.func_74768_a("MGLife", mgLife);
            tags.func_74768_a("AALife", aaLife);
            tags.func_74768_a("VehicleLife", vehicleLife);
            tags.func_74768_a("MechaLove", mechaLove);
            tags.func_74768_a("PlaneLife", planeLife);
            tags.func_74757_a("BreakBlocks", driveablesBreakBlocks);
            CompressedStreamTools.func_74800_a((NBTTagCompound)tags, (DataOutput)new DataOutputStream(new FileOutputStream(file)));
        }
        catch (Exception e) {
            FlansMod.log("Failed to save to teams.dat");
        }
    }

    private boolean checkFileExists(File file) {
        if (!file.exists()) {
            try {
                file.createNewFile();
            }
            catch (Exception e) {
                FlansMod.log("Failed to create file");
                FlansMod.log(file.getAbsolutePath());
            }
            return false;
        }
        return true;
    }

    public ITeamBase getBase(int ID) {
        for (ITeamBase base : this.bases) {
            if (base.getID() != ID) continue;
            return base;
        }
        return null;
    }

    public void registerBase(ITeamBase base) {
        if (base.getID() == 0) {
            base.setID(this.nextBaseID++);
        }
        this.bases.add(base);
    }

    public void registerObject(ITeamObject obj) {
        this.objects.add(obj);
    }

    @SubscribeEvent
    public void onPlayerLogin(PlayerEvent.PlayerLoggedInEvent event) {
        EntityPlayer player = event.player;
        if (player instanceof EntityPlayerMP) {
            EntityPlayerMP playerMP = (EntityPlayerMP)player;
            if (this.currentGametype != null) {
                this.currentGametype.playerJoined(playerMP);
            }
        }
    }

    @SubscribeEvent
    public void onPlayerLogout(PlayerEvent.PlayerLoggedOutEvent event) {
        for (Team team : Team.teams) {
            team.removePlayer(event.player);
        }
    }

    @SubscribeEvent
    public void onPlayerRespawn(PlayerEvent.PlayerRespawnEvent event) {
        this.onPlayerRespawn(event.player);
    }

    public void onPlayerRespawn(EntityPlayer player) {
        if (this.currentGametype != null) {
            EntityPlayerMP playerMP = (EntityPlayerMP)player;
            PlayerData data = PlayerHandler.getPlayerData((EntityPlayer)playerMP);
            if (playerMP != null && data != null && data.team == Team.spectators && MinecraftServer.func_71276_C().func_71203_ab().func_72353_e(playerMP.func_70005_c_())) {
                return;
            }
            Vec3 spawnPoint = this.currentGametype.getSpawnPoint(playerMP);
            if (spawnPoint != null) {
                player.func_71063_a(new ChunkCoordinates(MathHelper.func_76128_c((double)spawnPoint.field_72450_a), MathHelper.func_76128_c((double)spawnPoint.field_72448_b) + 1, MathHelper.func_76128_c((double)spawnPoint.field_72449_c)), true);
                data.setSpawn(spawnPoint.field_72450_a, spawnPoint.field_72448_b, spawnPoint.field_72449_c, 5);
                playerMP.func_70012_b(spawnPoint.field_72450_a, spawnPoint.field_72448_b, spawnPoint.field_72449_c, 0.0f, 0.0f);
                if (data.playerClass != null && data.playerClass.horse) {
                    EntityHorse horse = new EntityHorse(playerMP.field_70170_p);
                    NBTTagCompound tags = new NBTTagCompound();
                    horse.func_70109_d(tags);
                    tags.func_74757_a("Tame", true);
                    tags.func_74768_a("Temper", 0);
                    tags.func_74778_a("OwnerName", playerMP.func_70005_c_());
                    tags.func_74782_a("SaddleItem", (NBTBase)new ItemStack(Items.field_151141_av).func_77955_b(new NBTTagCompound()));
                    tags.func_74768_a("Type", 0);
                    tags.func_74768_a("Variant", 0);
                    horse.func_70020_e(tags);
                    horse.func_70107_b(playerMP.field_70165_t, playerMP.field_70163_u, playerMP.field_70161_v);
                    playerMP.field_70170_p.func_72838_d((Entity)horse);
                    playerMP.func_70078_a((Entity)horse);
                }
                if (forceAdventureMode && player.field_71075_bZ.field_75099_e) {
                    player.func_71033_a(WorldSettings.GameType.ADVENTURE);
                }
                this.resetInventory(player);
            }
            this.currentGametype.playerRespawned((EntityPlayerMP)player);
        }
    }

    public void forceRespawn(EntityPlayerMP player) {
        player.field_71071_by.field_70460_b = new ItemStack[4];
        player.field_71071_by.field_70462_a = new ItemStack[36];
        player.func_70691_i(9001.0f);
        if (forceAdventureMode && player.field_71075_bZ.field_75099_e) {
            player.func_71033_a(WorldSettings.GameType.ADVENTURE);
        }
        this.onPlayerRespawn((EntityPlayer)player);
    }

    public void playerSelectedTeam(EntityPlayerMP player, String teamName) {
        Team previousTeam = Gametype.getPlayerData((EntityPlayerMP)player).team;
        if (previousTeam != null && previousTeam.shortName.equals(teamName)) {
            Gametype.sendClassMenuToPlayer(player);
            return;
        }
        Team team = null;
        for (Team t : this.teams) {
            if (t == null || !t.shortName.equals(teamName)) continue;
            team = t;
        }
        if (teamName.equals(Team.spectators.shortName)) {
            team = Team.spectators;
        }
        if (team == null) {
            team = Team.spectators;
        }
        if (team != null && this.currentGametype != null) {
            PlayerHandler.getPlayerData((EntityPlayer)player).team = team;
            boolean canJoinTeam = this.currentGametype.playerChoseTeam(player, team, previousTeam);
            if (canJoinTeam) {
                team.addPlayer((EntityPlayer)player);
                TeamsManager.messageAll(player.func_70005_c_() + " joined \u00a7" + team.textColour + team.name);
            } else {
                player.func_145747_a((IChatComponent)new ChatComponentText("You may not pick that team"));
                Gametype.sendTeamsMenuToPlayer(player);
            }
        }
        if (team == Team.spectators) {
            PlayerHandler.getPlayerData((EntityPlayer)player).newPlayerClass = null;
            PlayerHandler.getPlayerData((EntityPlayer)player).playerClass = null;
            this.resetInventory((EntityPlayer)player);
            player.field_71075_bZ.field_75101_c = true;
        } else {
            player.field_71075_bZ.field_75101_c = false;
        }
    }

    public void playerSelectedClass(EntityPlayerMP player, String className) {
        Team team = PlayerHandler.getPlayerData((EntityPlayer)player).team;
        if (team == null) {
            return;
        }
        PlayerClass playerClass = null;
        for (PlayerClass pc : team.classes) {
            if (!pc.shortName.equals(className)) continue;
            playerClass = pc;
        }
        if (playerClass != null) {
            if (this.currentGametype != null) {
                this.currentGametype.playerChoseClass(player, playerClass);
            }
            PlayerHandler.getPlayerData((EntityPlayer)player).playerClass = playerClass;
        }
    }

    public void resetInventory(EntityPlayer player) {
        Team team = PlayerHandler.getPlayerData((EntityPlayer)player).team;
        PlayerClass playerClass = PlayerHandler.getPlayerData(player).getPlayerClass();
        if (team == null) {
            return;
        }
        player.field_71071_by.field_70460_b = new ItemStack[4];
        player.field_71071_by.field_70462_a = new ItemStack[36];
        if (team.hat != null) {
            player.field_71071_by.field_70460_b[3] = team.hat.func_77946_l();
        }
        if (team.chest != null) {
            player.field_71071_by.field_70460_b[2] = team.chest.func_77946_l();
        }
        if (team.legs != null) {
            player.field_71071_by.field_70460_b[1] = team.legs.func_77946_l();
        }
        if (team.shoes != null) {
            player.field_71071_by.field_70460_b[0] = team.shoes.func_77946_l();
        }
        if (playerClass == null) {
            return;
        }
        for (ItemStack stack : playerClass.startingItems) {
            player.field_71071_by.func_70441_a(stack.func_77946_l());
        }
        for (int i = 0; i < player.field_71071_by.func_70302_i_(); ++i) {
            ItemStack stack;
            stack = player.field_71071_by.func_70301_a(i);
            if (stack == null || !(stack.func_77973_b() instanceof ItemGun)) continue;
            ((ItemGun)stack.func_77973_b()).reload(stack, player.field_70170_p, player, true);
        }
    }

    public boolean areTeamsValid() {
        if (this.teams == null) {
            return false;
        }
        for (Team t : this.teams) {
            if (t != null) continue;
            return false;
        }
        return true;
    }

    public TeamsMap getTeamsMap(String s) {
        for (TeamsMap map : this.maps) {
            if (!map.shortName.equals(s)) continue;
            return map;
        }
        return null;
    }

    public static class RotationEntry {
        public TeamsMap map;
        public Gametype gametype;
        public Team[] teams;

        public RotationEntry(TeamsMap m, Gametype g, Team[] t) {
            this.map = m;
            this.gametype = g;
            this.teams = t;
        }
    }

    public static class TeamsMap {
        public static TeamsMap def = new TeamsMap("default", "Default");
        public String name;
        public String shortName;

        public TeamsMap(String s1, String s2) {
            this.shortName = s1;
            this.name = s2;
        }
    }
}

