/*
 * Decompiled with CFR 0.152.
 */
package com.flansmod.common.teams;

import com.flansmod.common.PlayerData;
import com.flansmod.common.teams.Gametype;
import com.flansmod.common.teams.ITeamBase;
import com.flansmod.common.teams.ITeamObject;
import com.flansmod.common.teams.PlayerClass;
import com.flansmod.common.teams.Team;
import com.flansmod.common.teams.TeamsManager;
import java.util.ArrayList;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.Vec3;

public class GametypeTDM
extends Gametype {
    public boolean friendlyFire = false;
    public boolean autoBalance = true;
    public int scoreLimit = 25;
    public int newRoundTimer = 0;
    public int time;
    public int autoBalanceInterval = 1200;

    public GametypeTDM() {
        super("Team Deathmatch", "TDM", 2);
    }

    @Override
    public void initGametype() {
        this.startNewRound();
    }

    @Override
    public void teamsSet() {
        this.startNewRound();
    }

    @Override
    public void stopGametype() {
        super.stopGametype();
        GametypeTDM.resetScores();
    }

    @Override
    public void tick() {
        --this.newRoundTimer;
        if (this.newRoundTimer == 0) {
            if (TeamsManager.useRotation) {
                TeamsManager.getInstance().switchToNextGametype();
                return;
            }
            this.startNewRound();
        }
        if (GametypeTDM.teamsManager.teams != null) {
            for (Team team : GametypeTDM.teamsManager.teams) {
                if (team == null || team.score < this.scoreLimit || this.newRoundTimer >= 0) continue;
                TeamsManager.messageAll("\u00a7" + team.textColour + team.name + "\u00a7f won!");
                this.newRoundTimer = 200;
                TeamsManager.messageAll("\u00a7fThe next round will start in 10 seconds");
                this.time = -300;
            }
        }
        ++this.time;
        if (this.autoBalance && this.time % this.autoBalanceInterval == this.autoBalanceInterval - 200 && this.needAutobalance()) {
            TeamsManager.messageAll("\u00a7fAutobalancing teams...");
        }
        if (this.autoBalance && this.time % this.autoBalanceInterval == 0 && this.needAutobalance()) {
            this.autobalance();
        }
    }

    public boolean needAutobalance() {
        int membersTeamB;
        if (GametypeTDM.teamsManager.teams == null || GametypeTDM.teamsManager.teams[0] == null || GametypeTDM.teamsManager.teams[1] == null) {
            return false;
        }
        int membersTeamA = GametypeTDM.teamsManager.teams[0].members.size();
        return Math.abs(membersTeamA - (membersTeamB = GametypeTDM.teamsManager.teams[1].members.size())) > 1;
    }

    public void autobalance() {
        int i;
        int membersTeamB;
        if (GametypeTDM.teamsManager.teams == null || GametypeTDM.teamsManager.teams[0] == null || GametypeTDM.teamsManager.teams[1] == null) {
            return;
        }
        int membersTeamA = GametypeTDM.teamsManager.teams[0].members.size();
        if (membersTeamA - (membersTeamB = GametypeTDM.teamsManager.teams[1].members.size()) > 1) {
            for (i = 0; i < (membersTeamA - membersTeamB) / 2; ++i) {
                GametypeTDM.sendClassMenuToPlayer(this.getPlayer(GametypeTDM.teamsManager.teams[1].addPlayer(GametypeTDM.teamsManager.teams[0].removeWorstPlayer())));
            }
        }
        if (membersTeamB - membersTeamA > 1) {
            for (i = 0; i < (membersTeamB - membersTeamA) / 2; ++i) {
                GametypeTDM.sendClassMenuToPlayer(this.getPlayer(GametypeTDM.teamsManager.teams[0].addPlayer(GametypeTDM.teamsManager.teams[1].removeWorstPlayer())));
            }
        }
    }

    @Override
    public void playerJoined(EntityPlayerMP player) {
        GametypeTDM.sendTeamsMenuToPlayer(player);
    }

    @Override
    public boolean playerChoseTeam(EntityPlayerMP player, Team team, Team previousTeam) {
        int membersOnBothTeams;
        int membersOnTeamTheyDontWantToJoin;
        int membersOnTeamTheyWantToJoin;
        if (GametypeTDM.teamsManager.teams == null || GametypeTDM.teamsManager.teams[0] == null || GametypeTDM.teamsManager.teams[1] == null) {
            return false;
        }
        if (team == Team.spectators) {
            return true;
        }
        if (this.autoBalance && (membersOnTeamTheyWantToJoin = team.members.size()) > (membersOnTeamTheyDontWantToJoin = (membersOnBothTeams = GametypeTDM.teamsManager.teams[0].members.size() + GametypeTDM.teamsManager.teams[1].members.size()) - membersOnTeamTheyWantToJoin)) {
            return false;
        }
        if (previousTeam != null && previousTeam != Team.spectators && previousTeam != team && GametypeTDM.isAValidTeam(previousTeam, true)) {
            ++GametypeTDM.getPlayerData((EntityPlayerMP)player).deaths;
            --GametypeTDM.getPlayerData((EntityPlayerMP)player).score;
            GametypeTDM.getPlayerData((EntityPlayerMP)player).playerClass = null;
            GametypeTDM.getPlayerData((EntityPlayerMP)player).newPlayerClass = null;
        }
        GametypeTDM.sendClassMenuToPlayer(player);
        if (team != previousTeam) {
            teamsManager.forceRespawn(player);
        }
        return true;
    }

    @Override
    public boolean playerChoseClass(EntityPlayerMP player, PlayerClass playerClass) {
        Team team = GametypeTDM.getPlayerData((EntityPlayerMP)player).team;
        if (!team.classes.contains(playerClass)) {
            return false;
        }
        GametypeTDM.getPlayerData((EntityPlayerMP)player).newPlayerClass = playerClass;
        if (GametypeTDM.getPlayerData((EntityPlayerMP)player).playerClass == null) {
            teamsManager.resetInventory((EntityPlayer)player);
        } else {
            player.func_145747_a((IChatComponent)new ChatComponentText("You will respawn with the " + playerClass.name.toLowerCase() + " class"));
        }
        return true;
    }

    @Override
    public void playerQuit(EntityPlayerMP player) {
    }

    @Override
    public boolean playerAttacked(EntityPlayerMP player, DamageSource source) {
        if (GametypeTDM.getPlayerData(player) == null || GametypeTDM.getPlayerData((EntityPlayerMP)player).team == null) {
            return false;
        }
        if (this.newRoundTimer > 0) {
            return false;
        }
        EntityPlayerMP attacker = GametypeTDM.getPlayerFromDamageSource(source);
        if (attacker != null) {
            if (GametypeTDM.getPlayerData(attacker) == null || GametypeTDM.getPlayerData((EntityPlayerMP)attacker).team == null) {
                return false;
            }
            if (GametypeTDM.getPlayerData((EntityPlayerMP)attacker).team == Team.spectators) {
                return false;
            }
            if (GametypeTDM.getPlayerData((EntityPlayerMP)player).team == GametypeTDM.getPlayerData((EntityPlayerMP)attacker).team) {
                return this.friendlyFire;
            }
        }
        return GametypeTDM.getPlayerData((EntityPlayerMP)player).team != Team.spectators;
    }

    @Override
    public void playerKilled(EntityPlayerMP player, DamageSource source) {
        EntityPlayerMP attacker = GametypeTDM.getPlayerFromDamageSource(source);
        if (attacker != null) {
            if (attacker == player) {
                --GametypeTDM.getPlayerData((EntityPlayerMP)player).score;
            } else {
                GametypeTDM.givePoints(attacker, 1);
                ++GametypeTDM.getPlayerData((EntityPlayerMP)attacker).kills;
            }
        } else {
            --GametypeTDM.getPlayerData((EntityPlayerMP)player).score;
        }
        ++GametypeTDM.getPlayerData((EntityPlayerMP)player).deaths;
    }

    @Override
    public void baseAttacked(ITeamBase base, DamageSource source) {
    }

    @Override
    public void objectAttacked(ITeamObject object, DamageSource source) {
    }

    @Override
    public void baseClickedByPlayer(ITeamBase base, EntityPlayerMP player) {
    }

    @Override
    public void objectClickedByPlayer(ITeamObject object, EntityPlayerMP player) {
    }

    @Override
    public Vec3 getSpawnPoint(EntityPlayerMP player) {
        PlayerData data = GametypeTDM.getPlayerData(player);
        ArrayList<ITeamObject> validSpawnPoints = new ArrayList<ITeamObject>();
        if (data.team == null) {
            return null;
        }
        for (int j = 0; j < data.team.bases.size(); ++j) {
            ITeamBase base = data.team.bases.get(j);
            if (base.getMap() != GametypeTDM.teamsManager.currentMap) continue;
            for (int i = 0; i < base.getObjects().size(); ++i) {
                if (!base.getObjects().get(i).isSpawnPoint()) continue;
                validSpawnPoints.add(base.getObjects().get(i));
            }
        }
        if (validSpawnPoints.size() > 0) {
            ITeamObject spawnPoint = (ITeamObject)validSpawnPoints.get(rand.nextInt(validSpawnPoints.size()));
            return Vec3.func_72443_a((double)spawnPoint.getPosX(), (double)spawnPoint.getPosY(), (double)spawnPoint.getPosZ());
        }
        return null;
    }

    @Override
    public void playerRespawned(EntityPlayerMP player) {
    }

    @Override
    public boolean setVariable(String variable, String value) {
        if (variable.toLowerCase().equals("scorelimit")) {
            this.scoreLimit = Integer.parseInt(value);
            return true;
        }
        if (variable.toLowerCase().equals("friendlyfire")) {
            this.friendlyFire = Boolean.parseBoolean(value);
            return true;
        }
        if (variable.toLowerCase().equals("autobalance")) {
            this.autoBalance = Boolean.parseBoolean(value);
            return true;
        }
        return false;
    }

    @Override
    public void readFromNBT(NBTTagCompound tags) {
        this.scoreLimit = tags.func_74762_e("TDMScoreLimit");
        this.friendlyFire = tags.func_74767_n("TDMFriendlyFire");
        this.autoBalance = tags.func_74767_n("TDMAutoBalance");
    }

    @Override
    public void saveToNBT(NBTTagCompound tags) {
        tags.func_74768_a("TDMScoreLimit", this.scoreLimit);
        tags.func_74757_a("TDMFriendlyFire", this.friendlyFire);
        tags.func_74757_a("TDMAutoBalance", this.autoBalance);
    }

    @Override
    public boolean sortScoreboardByTeam() {
        return true;
    }
}

