/*
 * Decompiled with CFR 0.152.
 */
package com.flansmod.common.guns;

import com.flansmod.common.FlansMod;
import com.flansmod.common.types.InfoType;
import com.flansmod.common.types.TypeFile;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.model.ModelBase;
import net.minecraft.item.Item;

public class BulletType
extends InfoType {
    public Object model;
    public float fallSpeed = 1.0f;
    public int damageVsLiving = 1;
    public int damageVsDriveable = 1;
    public int explosion = 0;
    public boolean explodeOnImpact = false;
    public int fuse = 0;
    public int flak = 0;
    public int fire = 0;
    public String dropItemOnReload = null;
    public String dropItemOnShoot = null;
    public String dropItemOnHit = null;
    public boolean breaksGlass = false;
    public boolean penetratesEntities = false;
    public boolean penetratesBlocks = false;
    public String trailParticles = "smoke";
    public String flakParticles = "largesmoke";
    public boolean smokeTrail = false;
    public boolean isBomb = false;
    public boolean isShell = false;
    public float hitBoxSize = 0.5f;
    public String hitSound;
    public int roundsPerItem = 1;
    public int maxStackSize = 1;
    public static List<BulletType> bullets = new ArrayList<BulletType>();
    public boolean hasLight = false;

    public BulletType(TypeFile file) {
        super(file);
        this.texture = "defaultBullet";
        bullets.add(this);
    }

    @Override
    protected void read(String[] split, TypeFile file) {
        super.read(split, file);
        try {
            if (split[0].equals("Model")) {
                this.model = FlansMod.proxy.loadModel(split[1], this.shortName, ModelBase.class);
            }
            if (split[0].equals("Texture")) {
                this.texture = split[1];
            }
            if (split[0].equals("FallSpeed")) {
                this.fallSpeed = Float.parseFloat(split[1]);
            }
            if (split[0].equals("Damage") || split[0].equals("DamageVsLiving") || split[0].equals("DamageVsPlayer")) {
                this.damageVsLiving = Integer.parseInt(split[1]);
            }
            if (split[0].equals("DamageVsVehicles")) {
                this.damageVsDriveable = Integer.parseInt(split[1]);
            }
            if (split[0].equals("Explosion")) {
                this.explosion = Integer.parseInt(split[1]);
            }
            if (split[0].equals("FlakParticles")) {
                this.flak = Integer.parseInt(split[1]);
            }
            if (split[0].equals("Fire")) {
                this.fire = Integer.parseInt(split[1]);
            }
            if (split[0].equals("ExpodeOnImpact")) {
                this.explodeOnImpact = Boolean.parseBoolean(split[1].toLowerCase());
            }
            if (split[0].equals("Fuse")) {
                this.fuse = Integer.parseInt(split[1]);
            }
            if (split[0].equals("BreaksGlass")) {
                this.breaksGlass = Boolean.parseBoolean(split[1].toLowerCase());
            }
            if (split[0].equals("HitBoxSize")) {
                this.hitBoxSize = Float.parseFloat(split[1]);
            }
            if (split[0].equals("HitSound")) {
                this.hitSound = split[1];
            }
            if (split[0].equals("Penetrates")) {
                this.penetratesEntities = Boolean.parseBoolean(split[1].toLowerCase());
            }
            if (split[0].equals("SmokeTrail")) {
                this.smokeTrail = Boolean.parseBoolean(split[1].toLowerCase());
            }
            if (split[0].equals("RoundsPerItem")) {
                this.roundsPerItem = Integer.parseInt(split[1]);
            }
            if (split[0].equals("MaxStackSize")) {
                this.maxStackSize = Integer.parseInt(split[1]);
            }
            if (split[0].equals("Bomb")) {
                this.isBomb = Boolean.parseBoolean(split[1].toLowerCase());
            }
            if (split[0].equals("Shell")) {
                this.isShell = Boolean.parseBoolean(split[1].toLowerCase());
            }
            if (split[0].equals("DropItemOnShoot")) {
                this.dropItemOnShoot = split[1];
            }
            if (split[0].equals("DropItemOnReload")) {
                this.dropItemOnReload = split[1];
            }
            if (split[0].equals("DropItemOnHit")) {
                this.dropItemOnHit = split[1];
            }
            if (split[0].equals("HasLight")) {
                this.hasLight = Boolean.parseBoolean(split[1].toLowerCase());
            }
        }
        catch (Exception e) {
            System.out.println("Reading bullet file failed.");
            e.printStackTrace();
        }
    }

    public static BulletType getBullet(String s) {
        for (BulletType bullet : bullets) {
            if (!bullet.shortName.equals(s)) continue;
            return bullet;
        }
        return null;
    }

    public static BulletType getBullet(Item item) {
        for (BulletType bullet : bullets) {
            if (bullet.item != item) continue;
            return bullet;
        }
        return null;
    }

    @Override
    public void reloadModel() {
        this.model = FlansMod.proxy.loadModel(this.modelString, this.shortName, ModelBase.class);
    }
}

