﻿U1RegisterAddon("Mapster", {
    title = "地图增强",
    defaultEnable = 1,
    secure = 1,
    
    tags = { TAG_MAPQUEST },
    icon = [[Interface\Icons\INV_Misc_Map02]],
    desc = "增强世界地图的功能：`- 支持地图框体的缩放及移动`- 支持地图全开`- 支持显示鼠标位置坐标`- 可以改变团员图标的大小`- 可以直接选择副本地图``设置命令：/mapster",

    -------- Options --------
    {
        text = "配置选项",
        callback = function(cfg, v, loading) SlashCmdList["ACECONSOLE_MAPSTER"]("") end,
    },

  --  {
  --      text = "重置所有控制台设定",
  --      callback = function(cfg, v, loading)
  --          MapsterDB = nil; ReloadUI();
  --          NPCMarkMappingDB = nil; ReloadUI();
  --          NPCMarkDB = nil; ReloadUI();
  --          MapMarkHide = nil; ReloadUI();
   --     end,
  --  },
});

U1RegisterAddon("AngryKeystones", {
    title = "大秘计时增强",
    defaultEnable = 1,
    tags = { TAG_GOOD, TAG_MAPQUEST },
    icon = [[Interface\Icons\INV_Misc_Key_13]],
    desc = "说明`显示大秘境的时间消耗情况。取代之前的GottaGoFast",
    nopic = 1,

    {
        text = "配置选项",
        callback = function(cfg, v, loading)
            SlashCmdList.AngryKeystones("")
        end
    }
});

U1RegisterAddon("AtlasLoot", { 
    title = "副本掉落查询",
    tags = {TAG_ITEM, TAG_BIG, },
    minimap = "LibDBIcon10_AtlasLoot",
    defaultEnable = 0,

    author = "Hegarol",
    desc = "显示副本中的首领与小怪可能掉落的物品，并且可以查询各种声望、战场、兑换物的奖励物品等。`快捷命令：/al 或 /atlasloot``|cff00d100本插件下的子模块全部开启即可，会自动加载需要的部分|r",
    icon = [[Interface\Icons\INV_Box_01]],

    --children = {"^AtlasLoot$", "AtlasLoot_.*"}, --AtlasLootReverse, AtlasLoot_Tooltip

    {
        type="button",
        text="开启主界面",
        tip="快捷命令`/al 或 /atlasloot",
        callback = function() AtlasLoot.SlashCommands:Run("") end
    },
    {
        type="button",
        text="配置选项",
        callback = function() AtlasLoot.SlashCommands:Run("options") end
    },
});

U1RegisterAddon("AtlasLoot_WarlordsofDraenor", {title = "德拉诺之王数据",});

U1RegisterAddon("AtlasLoot_Legion", {title = "军团再临数据",});

U1RegisterAddon("AtlasLoot_Collections", {title = "收藏品数据",});
U1RegisterAddon("AtlasLoot_PvP", {title = "PvP装备数据",});
U1RegisterAddon("AtlasLoot_Factions", {title = "声望奖励物品数据",});
U1RegisterAddon("AtlasLoot_Crafting", {title = "商业制造物品数据",});
U1RegisterAddon("AtlasLoot_WorldEvents", {title = "世界事件数据",});

U1RegisterAddon("AtlasLoot_Classic", {title = "经典旧世数据",});
U1RegisterAddon("AtlasLoot_BurningCrusade", {title = "燃烧的远征数据",});
U1RegisterAddon("AtlasLoot_WrathoftheLichKing", {title = "巫妖王之怒数据",});
U1RegisterAddon("AtlasLoot_Cataclysm", {title = "大地的裂变数据",});
U1RegisterAddon("AtlasLoot_MistsofPandaria", {title = "熊猫人之谜数据",});

U1RegisterAddon("AtlasLoot_Options", {title = "配置界面",});


U1RegisterAddon("Auctionator", {
    title = "拍卖助手",
    defaultEnable = 1,

    tags = { TAG_TRADING },
    icon = [[Interface\Icons\INV_Misc_Coin_02]],
    desc = "在拍卖行界面中增加|cffffffff'竞标助手'|r和|cffffffff'拍卖助手'|r两个扩展页，在'竞标助手'中可以搜索要购买的物品及数量后，批量购买（需多次点击确认）；拍卖时可以自动比价，并根据预设的压价方案（百分比或固定值）进行压价。`此外还可保存物品的拍卖价格并显示在鼠标提示中。``配置的快捷命令：`/Auctionator",
    pics = 2,

    --toggle = function(name, info, enable, justload) end,
    {
        text = "配置选项",
        tip = "快捷命令`/Auctionator",
        callback = function(cfg, v, loading) CoreIOF_OTC(AuctionLite.optionFrames.sell) end,
    },
});

U1RegisterAddon("BlizzMove", {
    title = "面板移动",
    desc = "移动系统的界面框体，支持几乎所有的系统面板，如拍卖行、法术书、好友公会等等，并且支持按住SHIFT拖动玩家能量界面，例如骑士圣能、死骑符文、萨满图腾、鹌鹑日蚀、术士灵魂碎片。` `按住Ctrl点击任意面板可以设置是否保存面板位置；Ctrl+Alt+Shift点击可以重置为默认位置；在面板上按住Ctrl并滚动鼠标滚轮可以缩放面板大小。",
    secure = 1,
    load = "LOGIN",
    defaultEnable = 1,

    tags = { TAG_INTERFACE, TAG_CHAT, TAG_DEV },
    icon = [[Interface\Icons\INV_Gizmo_GoblinBoomBox_01]],
    ------- Options --------
    {
        var = "powerbar",
        text = "允许移动职业能量界面",
        tip = "说明`（拖动需要按住SHIFT键）是否允许移动各职业特有的能量界面，包括骑士圣能、死骑符文、萨满图腾、鹌鹑日蚀、术士灵魂碎片，此选项可能会与一些职业专用插件冲突，所以请在遇到问题时关闭。",
        reload = 1,
        default = 1,
        --删除Callback是因为初始DB的情况无法处理，只能用U1GetCfgValue
    },
    {
        var = "movecastbar",
        text = "允许移动施法条",
        tip = "说明`允许移动施法条，施法条出现的时候，用鼠标拖动就可以移了，建议炉石的时候移。注意，开启此选项后，鼠标将无法透过施法条点击，另外此选项可能跟某些插件冲突，导致找不到施法条，请关闭并重载界面。",
        reload = 1,
    },
    {
        text = "重置所有面板位置",
        callback = function(cfg, v, loading)
            BlizzMove_ResetDB();
        end,
    },
});
U1RegisterAddon("CompactRaid", {
    title = "团队框架",
    defaultEnable = 1,
    load = "NORMAL",
    optionsAfterLogin = 1,
    tags = { TAG_RAID, TAG_BIG },
    icon = [[Interface\Icons\Achievement_BG_3flagcap_nodeaths]],
    desc = "美化和增强暴雪自带的团队框架，与GIRD功能重复，建议开启后关闭GRID",
    nopic = 1,

});

U1RegisterAddon("DBM-Core", {
    title = "首领模块DBM",
    defaultEnable = 1,
    load = "NORMAL", --很奇怪的问题, DBM-Core.lua:1142
    minimap = "DBMMinimapButton",
    frames = {"DBMMinimapButton"},
    tags = { TAG_RAID, TAG_BIG },
    icon = [[Interface\Icons\INV_Helmet_06]],
    desc = "DBM是一款强大的老牌首领报警插件，让你在RAID副本中游刃有余。可以在屏幕上显示各种计时条，BOSS血量、警报信息等；团长使用时还可以自动对怪物标记团队目标。同时提供距离监视模块，可以选择文字框架和雷达框架。``注：各个子模块不要手工启用/停用，会根据当前副本自动加载。",
    pics = 3,

    --设置语音包默认值, /run DBM_AllSavedOptions=nil;U1DB.configs["dbm-core/voice"]=nil;ReloadUI()
    --[[ 不需要这里设置，因为增加了一个选项
    runBeforeLoad = function(info, name)
        DBM.DefaultOptions.CountdownVoice = "VP:Yike"
        DBM.DefaultOptions.ChosenVoicePack = "Yike"
    end,
    ]]

    iconTip = "$title`显示距离提示窗",
    iconFunc = function()
        if DBM.RangeCheck:IsShown() then DBM.RangeCheck:Hide() else DBM.RangeCheck:Show() end
    end,
    --children = {"^DBM%-*"},

    --[------ Options --------
    {
        var="range",
        text="显示DBM距离提示窗",
        tip="说明`显示一个窗口显示和其他团员之间的距离。右键点击窗口可以设置距离、雷达模式等选项。",
        callback = function(cfg, v, loading) if(v)then DBM.RangeCheck:Show(nil, nil, true) else DBM.RangeCheck:Hide(true) end end,
    },
    {
        var="voice",
        text="使用额外语音包",
        default = 1,
        tip="说明`使用额外的语音提示，一般使用夏一可普通话女声。",
        getvalue = function() return DBM.Options.ChosenVoicePack == "Yike" end,
        callback = function(cfg, v, loading)
            if (v) then
                if DBM.Options.ChosenVoicePack == "None" then
                    DBM.Options.ChosenVoicePack = "Yike"
                    DBM.Options.CountdownVoice = "VP:Yike"
                end
            else
                if DBM.Options.ChosenVoicePack == "Yike" then
                    DBM.Options.ChosenVoicePack = "None"
                end
            end
        end,
    },--
    --[[
    {
        var="movie",
        text="禁用所有过场电影",
        getvalue = function() return DBM.Options.DisableCinematics end,
        callback = function(cfg, v, loading) DBM.Options.DisableCinematics = not not v end,
    },
    ]]
    {
        text="测试计时条",
        callback = function(cfg, v, loading) DBM:DemoMode() end,
    },
    {
        text="配置选项",
        callback = function(cfg, v, loading) SlashCmdList["DEADLYBOSSMODS"]("") end,
    },
    --]]
});

--可以考虑加一个属性, hideAndDisable
--模块插件必须设置成protected否则加载DBM时如果模块未启用，则无法显示选项
U1RegisterAddon("DBM-StatusBarTimers", { title = "状态条计时器", load = "NORMAL", protected = nil, defaultEnable = 1, hide = 1, });
U1RegisterAddon("DBM-GUI", { title = "配置选项模块", });
U1RegisterAddon("DBM-DefaultSkin", { title = "默认皮肤", load = "NORMAL" });
U1RegisterAddon("DBM-Brawlers", { title = '搏击俱乐部', });
U1RegisterAddon("DBM-DMF", { title = '暗月马戏团', });
U1RegisterAddon("DBM-WorldEvents", { title = "世界事件模块", });

--军团再临
U1RegisterAddon("DBM-BrokenIsles", { title = 'DBM:破碎群岛', protected = 1});
U1RegisterAddon("DBM-EmeraldNightmare", { title = "DBM:翡翠梦魇", protected = 1 });
U1RegisterAddon("DBM-Nighthold", { title = "DBM:暗夜要塞", protected = 1 });
U1RegisterAddon("DBM-Party-Legion", { title = "DBM:军团5人本", protected = 1 });

U1RegisterAddon("DBM-VPYike", { title = "夏一可語音包", load = "NORMAL", protected = 1 });

--第三方开发的
U1RegisterAddon("DBM-SpellTimers", { title = "冷却监控", load = "NORMAL", defaultEnable = 0 });
U1RegisterAddon("DBM-PvP", { title = "PVP模块", });
U1RegisterAddon("DBM-ProvingGrounds", { title = "白虎寺试炼场", });
--U1RegisterAddon("DBM-RaidLeadTools", { title = "团长工具箱", });

CoreDependCall("DBM-GUI", function()
    table.insert(UISpecialFrames, "DBM_GUI_OptionsFrame")
end)
U1RegisterAddon("Decursive", {
    title = "一键驱散",
    defaultEnable = 0,
    load = "LOGIN",

    tags = { TAG_RAID, TAG_CLASS, TAG_MAGE, TAG_PALADIN, TAG_PRIEST, TAG_SHAMAN, TAG_DRUID, TAG_MONK },
    icon = [[Interface\Icons\inv_misc_cat_trinket05]],
    desc = "方便驱散自身和队友负面状态的插件。启用后会在屏幕右侧显示一个个小方格，如果对应的团员中了可驱散的状态，会用显著的颜色标示，点击即可驱散该状态。`框体的左上角有一个小方块可以用来拖动位置及打开设置菜单等。`插件有很多命令，都是以dcr开头的：`/dcr`/dcrshow`/dcrreset`/dcrshoworder 等等",

    toggle = function(name, info, enable, justload)
        if not justload then
            if enable then
                SlashCmdList["ACECONSOLE_DCR"]("enable");
            else
                SlashCmdList["ACECONSOLE_DCR"]("disable");
                StaticPopup1:Hide()
            end
        end
    end,
    -------- Options --------
    {
        text = "运行命令/dcrshow",
        callback = function(cfg, v, loading) SlashCmdList["ACECONSOLE_DCRSHOW"]() end,
    },
    {
        text = "配置选项",
        tip = "快捷命令`/decursive",
        callback = function(cfg, v, loading) SlashCmdList["ACECONSOLE_DECURSIVE"]() end,
    },
    --]]
});

U1RegisterAddon("EN_UnitFrames", {
    title = "系统头像增强", });
U1RegisterAddon("Fizzle", {
    title = "装备耐久",
    defaultEnable = 1,
    load = "LOGIN",
    tags = { TAG_ITEM },
    nopic = true,
    icon = [[Interface\Icons\INV_BLACKSMITH_ANVIL]],
    desc = "边框品质着色、人物界面耐久度显示。",
});

U1RegisterAddon("FriendsMenuXP", {
    title = "玩家菜单增强",
    defaultEnable = 1,
    secure = 1, --secure button
    --parent = "163UI_Chat",
    
    tags = { TAG_CHAT },
    icon = [[Interface\Icons\Achievement_Reputation_04]],
    desc = "增强聊天链接的右键菜单`* alt点击链接邀请入队`* shift点击查询详请`* ctrl点击选为目标(非战斗)`* 支持好友、工会、团队面板`* 支持玩家头像下方的附加选项。``同时提供团队面板中点击团员按钮选择为目标的功能修复。",

    author = "|cffcd1a1c[网易原创]|r",
});

U1RegisterAddon("GarrisonMissionManager", {
    title = "要塞任务管家",
    defaultEnable = 1,
    loadWith = "Blizzard_GarrisonUI",
    nolodbutton = 1,

    tags = { TAG_GARRISON, },
    icon = [[Interface\Icons\Garrison_GreenWeaponUpgrade]],
    desc = "帮助你选择最优配置来进行要塞追随者任务。",
    nopic = 1,
});
U1RegisterAddon("MasterPlanA", {
    title = "要塞任务大师",
    defaultEnable = 1,

    tags = { TAG_GARRISON },
    icon = [[Interface\Icons\UI_Promotion_Garrisons]],
    desc = "修改并简化追随者任务面板的操作。",
    nopic = true,
});

U1RegisterAddon("MasterPlan", {
    protected = 1,
    hide = 1,
    loadWith = "Blizzard_GarrisonUI",
    nolodbutton = 1,
});
U1RegisterAddon("MeetingStone", {
    title = "集合石",
    tags = { TAG_GOOD, TAG_RAID, TAG_BIG },
    icon = [[Interface\AddOns\MeetingStone\Media\Logo]],
    nopic = 1,
	defaultEnable = 1,
    load="NORMAL" , --有人反馈说有问题，先这么搞了
    desc = "【集合石组团】你还在为上线不知道做什么而郁闷么，你还在为身在鬼服组不到队伍而烦恼么，你还在为组个团要等1个多小时纠结么，那么就让我们一起“集合石插件”吧！跨区服组队无需手动添加战网实名好友，“只要你敢申请，我就敢组你”，重燃你的游戏热情，让鬼服的玩家重生，让漫长的等待成为历史。大家一起鉴证史上最强大的组队插件——友团插件！现在就点击小地图或顶部信息条内的按钮寻找团队吧！",

});

U1RegisterAddon("MerchantEx", {
    title = "自动修理贩卖",
    defaultEnable = 1,
    optionsAfterVar = 1,

    tags = { TAG_TRADING, },
    icon = [[Interface\Icons\INV_GIZMO_MANAPOTIONPACK]],
    desc = "商人助手插件，在商人面板右上有设置按钮，提供自动出售灰色物品、自动修理、自动购入施法材料等功能。`快捷命令：/merchantex",

    --toggle = function(name, info, enable, justload) end,

    ---[[------ Options --------
    {
        var = "repair",
        default = 1,
        text = "自动修理",
        getvalue = function() return MerchantExDB.option.repair end,
        callback = function(cfg, v, loading) MerchantExDB.option.repair = v end,
        {
            var = "guild",
            default = 1,
            text = "尽可能使用公会资金",
            getvalue = function() return MerchantExDB.option.guild end,
            callback = function(cfg, v, loading) MerchantExDB.option.guild = v end,
        }
    },
    {
        var = "sell",
        default = 1,
        text = "自动出售灰色物品",
        tip = "说明`可进一步设置要出售的白色物品, 请通过配置选项增加列表",
        getvalue = function() return MerchantExDB.option.sell end,
        callback = function(cfg, v, loading) MerchantExDB.option.sell = v end,
        {
            var = "details",
            default = nil,
            text = "显示出售物品列表",
            getvalue = function() return MerchantExDB.option.details end,
            callback = function(cfg, v, loading) MerchantExDB.option.details = v end,
        }
    },
    {
        var = "buy",
        default = 1,
        text = "自动补购材料",
        tip = "说明`请通过配置选项设置需要购买的材料及数量",
        getvalue = function() return MerchantExDB.option.buy end,
        callback = function(cfg, v, loading) MerchantExDB.option.buy = v end,
    },
    {
        text = "配置选项",
        tip = "快捷命令`/merchantex",
        callback = function(cfg, v, loading) SlashCmdList["MERCHANTEX"]() end,
    },

    --]]
});

U1RegisterAddon("OmniCC", {
    title = "技能冷却计时",
    defaultEnable = 1,
    load = "LOGIN",

    tags = { TAG_COMBATINFO },
    icon = [[Interface\Icons\INV_Qiraj_JewelGlyphed]],
    desc = "给所有的技能冷却动画添加文字显示及冷却后的效果。",
    nopic = 1,

    {
        text="配置选项",
        callback = function(cfg, v, loading)
            SlashCmdList["OmniCC"]()
        end,
    },
});

U1RegisterAddon("Postal", {
    title = "邮件增强",
    defaultEnable = 1,

    tags = { TAG_TRADING },
    icon = [[Interface\Icons\INV_Letter_06]],
    desc = "强化邮箱面板功能，支持批量收取全部邮件、计算所有邮件的金币收入总和、自动填写收件人等等功能。``在邮箱面板的右上角有设置菜单。",

    -------- Options --------
    {
        text = "配置选项",
        callback = function(cfg, v, loading)
            if Postal_DropDownMenu.initialize ~= Postal.Menu then
                CloseDropDownMenus()
                Postal_DropDownMenu.initialize = Postal.Menu
            end
            ToggleDropDownMenu(1, nil, Postal_DropDownMenu, Minimap:GetName(), 0, 0)
        end,
    },
    --]]
});

U1RegisterAddon("SimpleRaidTargetIcons", {
    title = "快速标记助手",
    defaultEnable = 1,
    --optionsAfterVar = 1,

    tags = { TAG_RAID },
    icon = [[Interface\Icons\Ability_Xaril_MasterPoisoner_White]],
    desc = "双击任意单位或者目标头像，会弹出圆形排列的标记按钮，可用来快速标记团队目标。`也可按住Ctrl键（可配置）单击鼠标进行标记。`运行'/srti'，可开启配置界面。",

    --author = "|cffcd1a1c[网易原创]|r",
    --modifier = "|cffcd1a1c[网易]|r",

    --toggle = function(name, info, enable, justload) end,

    {
        text = "配置选项",
        tip = "快捷命令`/srti",
        callback = function(cfg, v, loading) SlashCmdList["SRTI"]("") end,
    },
    --[[------ Options --------
    {
        var = "",
        default = "",
        text = "",
        callback = function(cfg, v, loading) end,
    },
    --]]
});

U1RegisterAddon("Skada", {
    title = "伤害统计",
    tags = { TAG_RAID },
	defaultEnable = 1,
    icon = [[Interface\ICONS\Spell_Lightning_LightningBolt01]],
    desc = "老牌的伤害统计插件，可以用来统计DPS、治疗量、驱散次数、承受伤害、死亡记录等等，是团队不可缺少的数据分析工具。支持图形化显示、信息广播等功能。",
	minimap = "LibDBIcon10_Skada",
    load = "NORMAL",
    nopic = 1,

    runBeforeLoad = function()
        local def = Skada.defaults.profile.windows[1]
        def.barwidth = 240
        def.background.height = 150
        def.point = "BOTTOMRIGHT"
        def.x = -100
        def.y = 1
    end,

    {
        var = "chinese_number",
        text = "数值缩写为万/亿",
        default = 1,
        callback = function(cfg, v, loading)
            if loading then
                Skada.originFormatNumber = Skada.FormatNumber
                function Skada:FormatNumber(number)
                    if number and self.db.profile.numberformat == 1 then
                        if U1GetCfgValue("Skada", "chinese_number") then
                            if number <= 9999 then
                                return n2s(number, nil, true);
                            elseif number <= 999999 then
                                return f2s(number/1e4, 1).."万"
                            elseif number <= 99999999 then
                                return n2s(number/1e4, nil, true).."万"
                            else
                                return f2s(number/1e8, 2).."亿"
                            end
                        end
                    end
                    return Skada:originFormatNumber(number)
                end
            end
        end
    },

    {
        type = 'button', 
        text = '配置模块', 
        callback = function() 
            InterfaceOptionsFrame_OpenToCategory("Skada")
            InterfaceOptionsFrame_OpenToCategory("Skada")
        end 
    }, 
});

U1RegisterAddon("SkadaFriendlyFire", { title = "Skada模块-友军误伤", load = "LATER" });
U1RegisterAddon("TellMeWhen", {
    title = "综合技能状态",
    defaultEnable = 0,
    load = "NORMAL",

    tags = { TAG_BIG, TAG_COMBATINFO },
    icon = [[Interface\Icons\INV_Jewelry_Ring_ZulGurub_02]],
    nopic = 1,

    toggle = function(name, info, enable, justload)
        return true
    end,

    {
        text = "切换锁定/解锁",
        tip = "快捷命令:`/tmw",
        callback = function()
            TMW:SlashCommand("")
        end
    },

    {
        text = "TMW选项",
        tip = "快捷命令:`/tmw options",
        callback = function()
            TMW:SlashCommand("options")
        end
    },
});

U1RegisterAddon("TellMeWhen_Options", { parent = "TellMeWhen", hide = 1, protected = 1 })

U1RegisterAddon("tullaRange", {
    title = "技能超距提示",
    defaultEnable = 1,

    tags = { TAG_COMBATINFO },
    icon = [[Interface\Icons\Ability_Rogue_FindWeakness]],
    desc = "动作条技能距离提示插件，当你的法术或技能超出距离或者没有足够的法力值时，将该动作条按钮着色，颜色可以修改为你想要的任意颜色，在界面选项的插件里进行设置。",
    nopic = 1,

    {
        text="配置选项",
        callback = function(cfg, v, loading)
            InterfaceOptionsFrame_Show()
            InterfaceOptionsFrame_OpenToCategory("tullaRange")
        end,
    },
});

U1RegisterAddon("WorldQuestsList", {
    title = "世界任务列表",
    tags = { TAG_GOOD, TAG_MAPQUEST },
    desc = "在世界地图右侧显示当前地图上的世界任务，并提供排序和过滤功能。",
    load = "LATER",
    defaultEnable = 1,
    nopic = 1,
    icon = [[Interface\Icons\INV_Inscription_ArmorScroll02]],
});

U1RegisterAddon("ArtifactPathFinder", { title = "神器加点", });
U1RegisterAddon("EncounterJournalPlus_InstanceInfo", { title = "副本完成情况", });
U1RegisterAddon("BagBrother", {
    title = "离线背包查看",
    defaultEnable = 1,
    load = "NORMAL",
    nopic = true,

    tags = {TAG_ITEM},
    
    desc = "在本机同帐号下记录所有银行内物品信息供离线查看。",
    icon = [[Interface\Icons\INV_Misc_Bag_14]],
})
U1RegisterAddon("!BugGrabber", { title = "错误收集", });
U1RegisterAddon("BugSack", { title = "屏蔽错误提示", });
U1RegisterAddon("CombatAlert", { title = "进战斗进提示", });
U1RegisterAddon("Combuctor", { title = "背包参数", });
U1RegisterAddon("Combuctor_Sets", { title = "设置背包", });
U1RegisterAddon("MBB", { title = "小地图按钮", });
U1RegisterAddon("SexyMap", { title = "性感小地图", });
U1RegisterAddon("TinyInspect", { title = "角色信息增强", });
U1RegisterAddon("oUF", { title = "oUF头像",
    desc = "聊天框，输入调用命令：/ouf，可以对头像进行设置。第一次使用，头像名字和施法条出现问号（？？？),请/ouf，调出头像设置平台，选择【字体】——随便选择一款字体即可。",
});
U1RegisterAddon("Castbars", { title = "施法条", });
U1RegisterAddon("ChatFilter", { title = "聊天过滤", });
U1RegisterAddon("TidyPlates", {
    title = "血条美化",
    defaultEnable = 0,
    load = "NORMAL",
    optionsAfterLogin = 1,
    minimap = "LibDBIcon10_TidyPlatesIcon",

    tags = { TAG_INTERFACE, TAG_BIG, },
    desc = "強大到爆的多功能姓名版美化插件。``设置口令：/tidyplates",
    nopic = 1,

    toggle = function(name, info, enable, justload)
        if justload and IsLoggedIn() then
            for i, frame in ipairs(C_NamePlate.GetNamePlates()) do
                Export163_OnNewNameplate(frame)
            end
        end
        return true
    end,

    {
        text = "配置选项",
        callback = function(cfg, v, loading) slash_TidyPlates() end
    },
    {
        text = "重置所有控制台设定",
        callback = function(cfg, v, loading)
            TidyPlatesOptions = nil;
            TidyPlatesHubCache = nil;
            TidyPlatesHubGlobal = nil;
            TidyPlatesHubSettings = nil;
            TidyPlatesWidgetData = nil; 
            ReloadUI();
        end,
    },

});

U1RegisterAddon("TidyPlatesWidgets", { protected = 1, load = "NORMAL" })
U1RegisterAddon("TidyPlatesHub", { protected = 1, load = "NORMAL" , });
U1RegisterAddon("FreebTip", { title = "鼠标提示", });


--- Custom Register AddOns' Config
-- Create a folder "!!!EaseAddOnConfigs" in Interface\AddOns, and copy this file there.
-- You can also create multiple config-files and include them from !!!EaseAddOnConfigs/MyConfigs.xml (need to be created manually)
-- The optional properties in U1RegisterAddon is listed in _CfgExample.lua
U1RegisterAddon("Recount", {
    title = "Damage Meters",
    tags = {"My Favorites"},
    icon = "Interface\\ICONS\\ACHIEVEMENT_GUILDPERK_FASTTRACK_RANK2",
    desc = "Write your own descriptions here, or leave nil for default addon notes.",

    {
        type = "checkbox",
        var = "show",
        lower = true,
        text = "Toggle Main Window",
        default = true,
        callback = function(cfg, v, loading)             
            if(v) then
                Recount.MainWindow:Show();
                Recount:RefreshMainWindow();
            else
                Recount.MainWindow:Hide();
            end
        end,
        {
            type = "button",
            text = "Test Button",
            callback = function() print("Hello World") end
        },
    },
    {
        type = "text",
        text = "Text Title Example",
        {
            var = "var1",
            type = "drop",
            var = "var1",
            text = "DropDown Example",
            default = 2,
            options = {"Caption1", "value1", "Caption2", 2, },
            callback = function(cfg, v, loading) print(cfg.text, v) end,
        },
        {
            var = "var2",
            type = "radio",
            text = "Radio Box Example",
            cols = 2,
            default = function() return U1PlayerClass == "WARRIOR" and 100 or "value2" end,
            options = {"Caption1", 100, "Caption2", "value2", },
            callback = function(cfg, v, loading) print(cfg.text, v) end,
        },
        {
            var = "var3",
            type = "checklist",
            text = "CheckBox List Example",
            default = { ["value1"] = true, ["value2"] = true, },
            options = {"Caption1", "value1", "Caption2", "value2", },
            callback = function(cfg, v, loading) print(cfg.text) dump(v) end,
        },
        {
            var = "var4",
            type = "spin",
            text = "SpinBox Example",
            range = {1, 100, 5},
            default = 50,
            callback = function(cfg, v, loading) print(cfg.text, v) end,
        },
    },
})