
---------------------------------
-- 物品信息庫 Author: M
---------------------------------

local MAJOR, MINOR = "LibItemInfo.7000", 1
local lib = LibStub:NewLibrary(MAJOR, MINOR)

if not lib then return end

--物品等級匹配規則
local ItemLevelPattern = gsub(ITEM_LEVEL, "%%d", "(%%d+)")

--Toolip
local tooltip = CreateFrame("GameTooltip", "LibItemLevelTooltip1", UIParent, "GameTooltipTemplate")
local unittip = CreateFrame("GameTooltip", "LibItemLevelTooltip2", UIParent, "GameTooltipTemplate")
tooltip:SetOwner(UIParent, "ANCHOR_NONE")
unittip:SetOwner(UIParent, "ANCHOR_NONE")

--物品是否本地化
function lib:hasLocally(ItemID)
    if (not ItemID or ItemID == "" or ItemID == "0") then return true end
    return select(10, GetItemInfo(tonumber(ItemID)))
end

--物品是否本地化
function lib:itemLocally(ItemLink)
    local id, gem1, gem2, gem3 = string.match(ItemLink, "item:(%d+):[^:]*:(%d-):(%d-):(%d-):")
    return (self:hasLocally(id) and self:hasLocally(gem1) and self:hasLocally(gem2) and self:hasLocally(gem3))
end

--獲取TIP中的屬性信息
function lib:GetStatsViaTooltip(tip, stats)
    if (type(stats) == "table") then
        local line, text, r, g, b, statValue, statName
        for i = 2, tip:NumLines() do
            line = _G[tip:GetName().."TextLeft" .. i]
            text = line:GetText() or ""
            r, g, b = line:GetTextColor()
            statValue, statName = string.match(text, "%+([0-9,]+)([^%+%|]+)")
            if (statValue and statName) then
                statName = strtrim(statName)
                statName = statName:gsub("與$", "")
                statName = statName:gsub("和$", "")
                statName = statName:gsub("and$", "")
                statValue = statValue:gsub(",","")
                statValue = tonumber(statValue) or 0
                if (not stats[statName]) then
                    stats[statName] = { value = statValue, r = r, g = g, b = b }
                else
                    stats[statName].value = stats[statName].value + statValue
                end
            end
        end
    end
    return stats
end

--獲取物品實際等級信息
function lib:GetItemInfo(ItemLink, stats)
    if (not ItemLink or ItemLink == "") then
        return 0, 0
    end
    if (not string.match(ItemLink, "item:%d+:")) then
        return -1, 0
    end
    if (not self:itemLocally(ItemLink)) then
        return 1, 0
    end
    tooltip:ClearLines()
    tooltip:SetHyperlink(ItemLink)
    local text, level
    for i = 2, 5 do
        text = _G[tooltip:GetName().."TextLeft" .. i]:GetText() or ""
        level = string.match(text, ItemLevelPattern)
        if (level) then break end
    end
    self:GetStatsViaTooltip(tooltip, stats)
    return 0, tonumber(level) or 0, GetItemInfo(ItemLink)
end

--獲取UNIT物品實際等級信息
function lib:GetUnitItemInfo(unit, index, stats)
    if (not UnitExists(unit)) then return 1, 0 end
    unittip:ClearLines()
    unittip:SetInventoryItem(unit, index)
    local ItemLink = select(2, unittip:GetItem())
    if (not ItemLink or ItemLink == "") then
        return 0, 0
    end
    if (not self:itemLocally(ItemLink)) then
        return 1, 0
    end
    local text, level
    for i = 2, 5 do
        text = _G[unittip:GetName().."TextLeft" .. i]:GetText() or ""
        level = string.match(text, ItemLevelPattern)
        if (level) then break end
    end
    self:GetStatsViaTooltip(unittip, stats)
    return 0, tonumber(level) or 0, GetItemInfo(ItemLink)
end

--獲取UNIT的裝備等級
function lib:GetUnitItemLevel(unit, stats)
    local total, counts = 0, 0
    local _, count, level
    for i = 1, 15 do
        if (i ~= 4) then
            count, level = self:GetUnitItemInfo(unit, i, stats)
            total = total + level
            counts = counts + count
        end
    end
    local mcount, mlevel, mquality, mslot, ocount, olevel, oquality, oslot
    mcount, mlevel, _, _, mquality, _, _, _, _, _, mslot = self:GetUnitItemInfo(unit, 16, stats)
    ocount, olevel, _, _, oquality, _, _, _, _, _, oslot = self:GetUnitItemInfo(unit, 17, stats)
    counts = counts + mcount + ocount
    --[神器]最高x2 [雙-雙 雙-X X-雙]最高x2
    if (mquality == 6 or oslot == "INVTYPE_2HWEAPON" or mslot == "INVTYPE_2HWEAPON" or mslot == "INVTYPE_RANGED" or mslot == "INVTYPE_RANGEDRIGHT") then 
        total = total + max(mlevel, olevel) * 2
    else
        total = total + mlevel + olevel
    end
    return counts, total/(16-counts), total
end
