
-------------------------------------
-- 小隊隊友装备等级 Author: M
-------------------------------------

local LibSchedule = LibStub:GetLibrary("LibSchedule.7000")
local LibItemInfo = LibStub:GetLibrary("LibItemInfo.7000")

local members, numMembers = {}, 0

--計算並打印隊伍裝備等級
local function BroadcastPartyItemLevel()
    local color
    DEFAULT_CHAT_FRAME:AddMessage(string.rep("-", 40), 1, 0.8, 0)
    for _, v in pairs(members) do
        color = RAID_CLASS_COLORS[v.class] or NORMAL_FONT_COLOR
        DEFAULT_CHAT_FRAME:AddMessage(format("<%s%s> %3d |c%s%s|r", PARTY, ITEM_LEVEL_ABBR, v.level, color.colorStr, v.name), 1, 0.8, 0)
    end
    DEFAULT_CHAT_FRAME:AddMessage(string.rep("-", 40), 1, 0.8, 0)
    table.wipe(members)
end

--(隊列)讀取隊友裝備等級
function GetPartyItemLevel(id)
    local unit = "party" .. id
    local guid = UnitGUID(unit)
    if (not guid or members[guid] or not CanInspect(unit)) then return end
    NotifyInspect(unit)
    LibSchedule:AddTask({
        name      = UnitName(unit),
        class     = select(2,UnitClass(unit)),
        identity  = guid,
        elasped   = 0.5,
        expired   = GetTime() + 4,
        onTimeout = function(self) table.wipe(members) end,
        onExecute = function(self)
            local unknownCount, equippedLevel = LibItemInfo:GetUnitItemLevel(unit)
            if (unknownCount == 0 and equippedLevel > 0) then
                members[self.identity] = {name=self.name,class=self.class,level=equippedLevel}
                if (UnitExists("party"..(id+1))) then
                    GetPartyItemLevel(id+1)
                else
                    BroadcastPartyItemLevel()
                end
                return true
            end
        end,
    })
end

--隊友增加時才處理
local frame = CreateFrame("Frame", nil, UIParent)
frame:RegisterEvent("GROUP_ROSTER_UPDATE")
frame:SetScript("OnEvent", function(self, event, ...)
    if (event == "GROUP_ROSTER_UPDATE" and not IsInRaid()) then
        local numCurrent = GetNumSubgroupMembers()
        if (numCurrent ~= numMembers) then
            if (numCurrent > numMembers) then
                --隊伍成立瞬間,部分隊友顯示是離綫,所以要用Task模式
                LibSchedule:AddTask({
                    identity  = "AllUnitIsConnected",
                    elasped   = 1,
                    begined   = GetTime() + 2,
                    expired   = GetTime() + 16,
                    onExecute = function(self)
                        local done = true
                        for i = 1, numCurrent do
                            if (not UnitIsConnected("party"..i)) then
                                done = false
                                break
                            end
                        end
                        if (done) then
                            GetPartyItemLevel(1)
                            return true
                        end
                    end,
                })
            end
            numMembers = GetNumSubgroupMembers()
        end
    end
end)
