
-------------------------------------
-- 鼠标滑过显示装等和天赋 Author: M
-------------------------------------

local LibSchedule = LibStub:GetLibrary("LibSchedule.7000")
local LibItemInfo = LibStub:GetLibrary("LibItemInfo.7000")

--更新周期
local updateElapsed = 300

--臨時緩存
local InspectDB = {}

--最近一次的鼠標GUID
local currentGUID

--讀取或存儲
local function InspectDBFactory(guid, itemLevel, specName)
    if (not InspectDB[guid]) then
        InspectDB[guid] = { lvl = itemLevel, spec = specName, t = time() + updateElapsed }
    elseif (eqlevel and eqlevel > 0) then
        InspectDB[guid].lvl  = eqlevel
        InspectDB[guid].spec = specName
        InspectDB[guid].t    = time() + updateElapsed
    end
    if (InspectDB[guid].t < time()) then
        return false
    end
    return InspectDB[guid].lvl, InspectDB[guid].spec
end

--檢查數據(3秒内同guid防止多次發送)
local function needsUpdate(guid)
    if (not InspectDB[guid]) then
        InspectDB[guid] = { t = time() + 3 }
        return true
    end
    if (InspectDB[guid].t < time()) then
        return true
    end
end

--获取天赋专精
local function GetUnitSpec(unit)
    if (UnitLevel(unit) > 10) then
        local specID, specName = GetInspectSpecialization(unit)
        if (specID and specID > 0) then
            specName = select(2, GetSpecializationInfoByID(specID))
        end
        return specName
    end
end

--顯示到Tooltip
local LevelLabel = STAT_AVERAGE_ITEM_LEVEL .. ": "
local SpecLabel  = TALENT .. SPECIALIZATION .. ": "
local function appendToGameTooltip(guid, itemLevel, specName)
    local _, unit = GameTooltip:GetUnit()
    if (not unit or UnitGUID(unit) ~= guid) then return end
    
    local line, text, levelLine, specLine
    for i = 2, GameTooltip:NumLines() do
        line = _G["GameTooltipTextLeft" .. i]
        text = line:GetText()
        if (text and strfind(text, LevelLabel)) then
            levelLine = line
        elseif (text and strfind(text, SpecLabel)) then
            specLine = line
        end
    end

    --物品等级
    if (itemLevel) then
        text = "|cffffeeaa" .. LevelLabel .. "|cffffffff" .. itemLevel
        if (levelLine) then
            levelLine:SetText(text)
        else
            GameTooltip:AddLine(text)
        end
    end

    --天赋专精
    if (specName) then
        text = "|cffffeeaa" .. SpecLabel .. "|cffffffff" .. specName
        if (specLine) then
            specLine:SetText(text)
        else
            GameTooltip:AddLine(text)
        end
    end
    
    GameTooltip:Show()
end

--事件處理
local frame = CreateFrame("Frame", nil, UIParent)
frame:RegisterEvent("INSPECT_READY")
frame:RegisterEvent("UPDATE_MOUSEOVER_UNIT")
frame:SetScript("OnEvent", function(self, event, arg1, ...)
    --鼠標滑過
    if (event == "UPDATE_MOUSEOVER_UNIT" and CanInspect("mouseover")) then
        if (InspectFrame and InspectFrame.unit) then return end
        if (UnitIsDeadOrGhost("player") or UnitOnTaxi("player")) then return end
        currentGUID = UnitGUID("mouseover")
        if (needsUpdate(UnitGUID("mouseover"))) then
            return NotifyInspect("mouseover")
        end
        local itemLevel, specName = InspectDBFactory(currentGUID)
        if (itemLevel) then
            appendToGameTooltip(currentGUID, floor(itemLevel), specName)
        end
    --回調處理
    elseif (event == "INSPECT_READY" and arg1 == UnitGUID("mouseover")) then
        LibSchedule:AddTask({
            identity  = arg1,
            timer     = 0.1,
            elasped   = 0.5,
            expired   = GetTime() + 3,
            onStart   = function(self) appendToGameTooltip(self.identity, "...") end,
            onTimeout = function(self) appendToGameTooltip(self.identity, "Failed") end,
            onExecute = function(self)
                if (UnitGUID("mouseover") ~= self.identity) then return end
                local unknownCount, itemLevel = LibItemInfo:GetUnitItemLevel("mouseover")
                if (unknownCount == 0) then
                    local specName = GetUnitSpec("mouseover")
                    InspectDBFactory(self.identity, itemLevel, specName)
                    appendToGameTooltip(self.identity, floor(itemLevel), specName)
                    return true
                end
            end,
        })
    end
end)
