
-------------------------------------
--觀察目標裝備屬性統計
-- @Author: M
-- @DepandsOn: Inspect.lua
-------------------------------------

local LibItemInfo = LibStub:GetLibrary("LibItemInfo.7000")

function ShowInspectItemStatsFrame(frame, unit)
    if (not frame.expandButton) then
        local expandButton = CreateFrame("Button", nil, frame)
        expandButton:SetSize(12, 12)
        expandButton:SetPoint("TOPRIGHT", -5, -5)
        expandButton:SetNormalTexture("Interface\\Cursor\\Item")
        expandButton:GetNormalTexture():SetTexCoord(12/32, 0, 0, 12/32)
        expandButton:SetScript("OnClick", function(self)
            ToggleFrame(frame.statsFrame)
            if (frame.statsFrame:IsShown()) then
                ShowInspectItemStatsFrame(frame, unit)
            end
        end)
        frame.expandButton = expandButton
    end
    if (not frame.statsFrame) then
        local statsFrame = CreateFrame("Frame", nil, frame, "InsetFrameTemplate3")
        statsFrame:SetSize(187, 157)
        statsFrame:SetPoint("TOPLEFT", frame, "TOPRIGHT", 0, -1)
        for i = 1, 20 do
            statsFrame["stat"..i] = CreateFrame("FRAME", nil, statsFrame, "CharacterStatFrameTemplate")
            statsFrame["stat"..i]:EnableMouse(false)
            statsFrame["stat"..i]:SetPoint("TOPLEFT", 0, -17*i+13)
            statsFrame["stat"..i].Background:SetVertexColor(0, 0, 0)
            statsFrame["stat"..i].Value:SetPoint("RIGHT", -60, 0)
            statsFrame["stat"..i].PlayerValue = statsFrame["stat"..i]:CreateFontString(nil, "ARTWORK", "GameFontHighlightSmall")
            statsFrame["stat"..i].PlayerValue:SetPoint("LEFT", statsFrame["stat"..i].Value, "RIGHT", 8, 0)
            statsFrame["stat"..i].PlayerValue:SetJustifyH("LEFT")
        end
        statsFrame:Hide()
        frame.statsFrame = statsFrame
    end
    if (not frame.statsFrame:IsShown()) then return end
    local inspectStats, playerStats = {}, {}
    local _, inspectItemLevel = LibItemInfo:GetUnitItemLevel(unit, inspectStats)
    local _, playerItemLevel  = LibItemInfo:GetUnitItemLevel("player", playerStats)
    local index = 1
    frame.statsFrame["stat"..index].PlayerValue:SetText(format(">%s<", YOU))
    frame.statsFrame["stat"..index].PlayerValue:SetTextColor(1, 0.82, 0)
    frame.statsFrame["stat"..index]:Show()
    index = index + 1
    frame.statsFrame["stat"..index].Label:SetText(STAT_AVERAGE_ITEM_LEVEL)
    frame.statsFrame["stat"..index].Value:SetText(format("%.1f",inspectItemLevel))
    frame.statsFrame["stat"..index].PlayerValue:SetText(format("%.1f",playerItemLevel))
    frame.statsFrame["stat"..index]:Show()
    index = index + 1
    for k, v in pairs(inspectStats) do
        if (v.r + v.g + v.b < 1.2) then
            frame.statsFrame["stat"..index].Label:SetText(k)
            frame.statsFrame["stat"..index].Label:SetTextColor(v.r, v.g, v.b)
            frame.statsFrame["stat"..index].Value:SetText(v.value)
            frame.statsFrame["stat"..index].Value:SetTextColor(v.r, v.g, v.b)
            frame.statsFrame["stat"..index].PlayerValue:SetText(playerStats[k] and playerStats[k].value or "-")
            frame.statsFrame["stat"..index].PlayerValue:SetTextColor(v.r, v.g, v.b)
            frame.statsFrame["stat"..index]:Show()
            index = index + 1
        end
    end
    for k, v in pairs(playerStats) do
        if (not inspectStats[k] and v.r + v.g + v.b < 1.2) then
            frame.statsFrame["stat"..index].Label:SetText(k)
            frame.statsFrame["stat"..index].Label:SetTextColor(v.r, v.g, v.b)
            frame.statsFrame["stat"..index].Value:SetText("-")
            frame.statsFrame["stat"..index].Value:SetTextColor(v.r, v.g, v.b)
            frame.statsFrame["stat"..index].PlayerValue:SetText(v.value)
            frame.statsFrame["stat"..index].PlayerValue:SetTextColor(v.r, v.g, v.b)
            frame.statsFrame["stat"..index]:Show()
            index = index + 1
        end
    end
    for k, v in pairs(inspectStats) do
        if (v.r + v.g + v.b > 1.2) then
            frame.statsFrame["stat"..index].Label:SetText(k)
            frame.statsFrame["stat"..index].Label:SetTextColor(1, 0.82, 0)
            frame.statsFrame["stat"..index].Value:SetText(v.value)
            frame.statsFrame["stat"..index].Value:SetTextColor(v.r, v.g, v.b)
            if (playerStats[k]) then
                frame.statsFrame["stat"..index].PlayerValue:SetText(playerStats[k].value)
                frame.statsFrame["stat"..index].PlayerValue:SetTextColor(playerStats[k].r, playerStats[k].g, playerStats[k].b)
            else
                frame.statsFrame["stat"..index].PlayerValue:SetText("-")
            end
            frame.statsFrame["stat"..index]:Show()
            index = index + 1
        end
    end
    for k, v in pairs(playerStats) do
        if (not inspectStats[k] and v.r + v.g + v.b > 1.2) then
            frame.statsFrame["stat"..index].Label:SetText(k)
            frame.statsFrame["stat"..index].Label:SetTextColor(1, 0.82, 0)
            frame.statsFrame["stat"..index].Value:SetText("-")
            frame.statsFrame["stat"..index].Value:SetTextColor(v.r, v.g, v.b)
            frame.statsFrame["stat"..index].PlayerValue:SetText(v.value)
            frame.statsFrame["stat"..index].PlayerValue:SetTextColor(v.r, v.g, v.b)
            frame.statsFrame["stat"..index]:Show()
            index = index + 1
        end
    end
    frame.statsFrame:SetHeight(index*17-10)
    while (frame.statsFrame["stat"..index]) do
        frame.statsFrame["stat"..index]:Hide()
        index = index + 1
    end
end

hooksecurefunc("ShowInspectItemListFrame", function(unit, parent, itemLevel)
    local frame = parent.inspectFrame
    if (not frame) then return end
    if (unit == "player") then return end
    ShowInspectItemStatsFrame(frame, unit)
end)
