/*******************************************************************************
 * Copyright 2011 See AUTHORS file.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 ******************************************************************************/

package com.badlogic.gdx.tests.g3d.shadows.system.classical;

import com.badlogic.gdx.graphics.g3d.Renderable;
import com.badlogic.gdx.graphics.g3d.Shader;
import com.badlogic.gdx.graphics.g3d.utils.BaseShaderProvider;
import com.badlogic.gdx.utils.GdxRuntimeException;

/** @author realitix */
public class Pass2ShaderProvider extends BaseShaderProvider {
	public final Pass2Shader.Config config;

	public Pass2ShaderProvider (final Pass2Shader.Config config) {
		if (config == null) throw new GdxRuntimeException("Pass2ShaderProvider needs config");
		this.config = config;
	}

	@Override
	protected Shader createShader (final Renderable renderable) {
		return new Pass2Shader(renderable, config);
	}
}
