/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (http://www.swig.org).
 * Version 3.0.10
 *
 * This file is not intended to be easily readable and contains a number of
 * coding conventions designed to improve portability and efficiency. Do not make
 * changes to this file unless you know what you are doing--modify the SWIG
 * interface file instead.
 * ----------------------------------------------------------------------------- */


#ifndef SWIGJAVA
#define SWIGJAVA
#endif

#define SWIG_DIRECTORS


#ifdef __cplusplus
/* SwigValueWrapper is described in swig.swg */
template<typename T> class SwigValueWrapper {
  struct SwigMovePointer {
    T *ptr;
    SwigMovePointer(T *p) : ptr(p) { }
    ~SwigMovePointer() { delete ptr; }
    SwigMovePointer& operator=(SwigMovePointer& rhs) { T* oldptr = ptr; ptr = 0; delete oldptr; ptr = rhs.ptr; rhs.ptr = 0; return *this; }
  } pointer;
  SwigValueWrapper& operator=(const SwigValueWrapper<T>& rhs);
  SwigValueWrapper(const SwigValueWrapper<T>& rhs);
public:
  SwigValueWrapper() : pointer(0) { }
  SwigValueWrapper& operator=(const T& t) { SwigMovePointer tmp(new T(t)); pointer = tmp; return *this; }
  operator T&() const { return *pointer.ptr; }
  T *operator&() { return pointer.ptr; }
};

template <typename T> T SwigValueInit() {
  return T();
}
#endif

/* -----------------------------------------------------------------------------
 *  This section contains generic SWIG labels for method/variable
 *  declarations/attributes, and other compiler dependent labels.
 * ----------------------------------------------------------------------------- */

/* template workaround for compilers that cannot correctly implement the C++ standard */
#ifndef SWIGTEMPLATEDISAMBIGUATOR
# if defined(__SUNPRO_CC) && (__SUNPRO_CC <= 0x560)
#  define SWIGTEMPLATEDISAMBIGUATOR template
# elif defined(__HP_aCC)
/* Needed even with `aCC -AA' when `aCC -V' reports HP ANSI C++ B3910B A.03.55 */
/* If we find a maximum version that requires this, the test would be __HP_aCC <= 35500 for A.03.55 */
#  define SWIGTEMPLATEDISAMBIGUATOR template
# else
#  define SWIGTEMPLATEDISAMBIGUATOR
# endif
#endif

/* inline attribute */
#ifndef SWIGINLINE
# if defined(__cplusplus) || (defined(__GNUC__) && !defined(__STRICT_ANSI__))
#   define SWIGINLINE inline
# else
#   define SWIGINLINE
# endif
#endif

/* attribute recognised by some compilers to avoid 'unused' warnings */
#ifndef SWIGUNUSED
# if defined(__GNUC__)
#   if !(defined(__cplusplus)) || (__GNUC__ > 3 || (__GNUC__ == 3 && __GNUC_MINOR__ >= 4))
#     define SWIGUNUSED __attribute__ ((__unused__))
#   else
#     define SWIGUNUSED
#   endif
# elif defined(__ICC)
#   define SWIGUNUSED __attribute__ ((__unused__))
# else
#   define SWIGUNUSED
# endif
#endif

#ifndef SWIG_MSC_UNSUPPRESS_4505
# if defined(_MSC_VER)
#   pragma warning(disable : 4505) /* unreferenced local function has been removed */
# endif
#endif

#ifndef SWIGUNUSEDPARM
# ifdef __cplusplus
#   define SWIGUNUSEDPARM(p)
# else
#   define SWIGUNUSEDPARM(p) p SWIGUNUSED
# endif
#endif

/* internal SWIG method */
#ifndef SWIGINTERN
# define SWIGINTERN static SWIGUNUSED
#endif

/* internal inline SWIG method */
#ifndef SWIGINTERNINLINE
# define SWIGINTERNINLINE SWIGINTERN SWIGINLINE
#endif

/* exporting methods */
#if defined(__GNUC__)
#  if (__GNUC__ >= 4) || (__GNUC__ == 3 && __GNUC_MINOR__ >= 4)
#    ifndef GCC_HASCLASSVISIBILITY
#      define GCC_HASCLASSVISIBILITY
#    endif
#  endif
#endif

#ifndef SWIGEXPORT
# if defined(_WIN32) || defined(__WIN32__) || defined(__CYGWIN__)
#   if defined(STATIC_LINKED)
#     define SWIGEXPORT
#   else
#     define SWIGEXPORT __declspec(dllexport)
#   endif
# else
#   if defined(__GNUC__) && defined(GCC_HASCLASSVISIBILITY)
#     define SWIGEXPORT __attribute__ ((visibility("default")))
#   else
#     define SWIGEXPORT
#   endif
# endif
#endif

/* calling conventions for Windows */
#ifndef SWIGSTDCALL
# if defined(_WIN32) || defined(__WIN32__) || defined(__CYGWIN__)
#   define SWIGSTDCALL __stdcall
# else
#   define SWIGSTDCALL
# endif
#endif

/* Deal with Microsoft's attempt at deprecating C standard runtime functions */
#if !defined(SWIG_NO_CRT_SECURE_NO_DEPRECATE) && defined(_MSC_VER) && !defined(_CRT_SECURE_NO_DEPRECATE)
# define _CRT_SECURE_NO_DEPRECATE
#endif

/* Deal with Microsoft's attempt at deprecating methods in the standard C++ library */
#if !defined(SWIG_NO_SCL_SECURE_NO_DEPRECATE) && defined(_MSC_VER) && !defined(_SCL_SECURE_NO_DEPRECATE)
# define _SCL_SECURE_NO_DEPRECATE
#endif

/* Deal with Apple's deprecated 'AssertMacros.h' from Carbon-framework */
#if defined(__APPLE__) && !defined(__ASSERT_MACROS_DEFINE_VERSIONS_WITHOUT_UNDERSCORES)
# define __ASSERT_MACROS_DEFINE_VERSIONS_WITHOUT_UNDERSCORES 0
#endif

/* Intel's compiler complains if a variable which was never initialised is
 * cast to void, which is a common idiom which we use to indicate that we
 * are aware a variable isn't used.  So we just silence that warning.
 * See: https://github.com/swig/swig/issues/192 for more discussion.
 */
#ifdef __INTEL_COMPILER
# pragma warning disable 592
#endif


/* Fix for jlong on some versions of gcc on Windows */
#if defined(__GNUC__) && !defined(__INTEL_COMPILER)
  typedef long long __int64;
#endif

/* Fix for jlong on 64-bit x86 Solaris */
#if defined(__x86_64)
# ifdef _LP64
#   undef _LP64
# endif
#endif

#include <jni.h>
#include <stdlib.h>
#include <string.h>


/* Support for throwing Java exceptions */
typedef enum {
  SWIG_JavaOutOfMemoryError = 1, 
  SWIG_JavaIOException, 
  SWIG_JavaRuntimeException, 
  SWIG_JavaIndexOutOfBoundsException,
  SWIG_JavaArithmeticException,
  SWIG_JavaIllegalArgumentException,
  SWIG_JavaNullPointerException,
  SWIG_JavaDirectorPureVirtual,
  SWIG_JavaUnknownError
} SWIG_JavaExceptionCodes;

typedef struct {
  SWIG_JavaExceptionCodes code;
  const char *java_exception;
} SWIG_JavaExceptions_t;


static void SWIGUNUSED SWIG_JavaThrowException(JNIEnv *jenv, SWIG_JavaExceptionCodes code, const char *msg) {
  jclass excep;
  static const SWIG_JavaExceptions_t java_exceptions[] = {
    { SWIG_JavaOutOfMemoryError, "java/lang/OutOfMemoryError" },
    { SWIG_JavaIOException, "java/io/IOException" },
    { SWIG_JavaRuntimeException, "java/lang/RuntimeException" },
    { SWIG_JavaIndexOutOfBoundsException, "java/lang/IndexOutOfBoundsException" },
    { SWIG_JavaArithmeticException, "java/lang/ArithmeticException" },
    { SWIG_JavaIllegalArgumentException, "java/lang/IllegalArgumentException" },
    { SWIG_JavaNullPointerException, "java/lang/NullPointerException" },
    { SWIG_JavaDirectorPureVirtual, "java/lang/RuntimeException" },
    { SWIG_JavaUnknownError,  "java/lang/UnknownError" },
    { (SWIG_JavaExceptionCodes)0,  "java/lang/UnknownError" }
  };
  const SWIG_JavaExceptions_t *except_ptr = java_exceptions;

  while (except_ptr->code != code && except_ptr->code)
    except_ptr++;

  jenv->ExceptionClear();
  excep = jenv->FindClass(except_ptr->java_exception);
  if (excep)
    jenv->ThrowNew(excep, msg);
}


/* Contract support */

#define SWIG_contract_assert(nullreturn, expr, msg) if (!(expr)) {SWIG_JavaThrowException(jenv, SWIG_JavaIllegalArgumentException, msg); return nullreturn; } else

/* -----------------------------------------------------------------------------
 * director_common.swg
 *
 * This file contains support for director classes which is common between
 * languages.
 * ----------------------------------------------------------------------------- */

/*
  Use -DSWIG_DIRECTOR_STATIC if you prefer to avoid the use of the
  'Swig' namespace. This could be useful for multi-modules projects.
*/
#ifdef SWIG_DIRECTOR_STATIC
/* Force anonymous (static) namespace */
#define Swig
#endif
/* -----------------------------------------------------------------------------
 * director.swg
 *
 * This file contains support for director classes so that Java proxy
 * methods can be called from C++.
 * ----------------------------------------------------------------------------- */

#if defined(DEBUG_DIRECTOR_OWNED) || defined(DEBUG_DIRECTOR_EXCEPTION)
#include <iostream>
#endif

#include <exception>

namespace Swig {

  /* Java object wrapper */
  class JObjectWrapper {
  public:
    JObjectWrapper() : jthis_(NULL), weak_global_(true) {
    }

    ~JObjectWrapper() {
      jthis_ = NULL;
      weak_global_ = true;
    }

    bool set(JNIEnv *jenv, jobject jobj, bool mem_own, bool weak_global) {
      if (!jthis_) {
        weak_global_ = !mem_own; // hold as weak global if explicitly requested or not owned
        if (jobj)
          jthis_ = weak_global_ ? jenv->NewWeakGlobalRef(jobj) : jenv->NewGlobalRef(jobj);
#if defined(DEBUG_DIRECTOR_OWNED)
        std::cout << "JObjectWrapper::set(" << jobj << ", " << (weak_global ? "weak_global" : "global_ref") << ") -> " << jthis_ << std::endl;
#endif
        return true;
      } else {
#if defined(DEBUG_DIRECTOR_OWNED)
        std::cout << "JObjectWrapper::set(" << jobj << ", " << (weak_global ? "weak_global" : "global_ref") << ") -> already set" << std::endl;
#endif
        return false;
      }
    }

    jobject get(JNIEnv *jenv) const {
#if defined(DEBUG_DIRECTOR_OWNED)
      std::cout << "JObjectWrapper::get(";
      if (jthis_)
        std::cout << jthis_;
      else
        std::cout << "null";
      std::cout << ") -> return new local ref" << std::endl;
#endif
      return (jthis_ ? jenv->NewLocalRef(jthis_) : jthis_);
    }

    void release(JNIEnv *jenv) {
#if defined(DEBUG_DIRECTOR_OWNED)
      std::cout << "JObjectWrapper::release(" << jthis_ << "): " << (weak_global_ ? "weak global ref" : "global ref") << std::endl;
#endif
      if (jthis_) {
        if (weak_global_) {
          if (jenv->IsSameObject(jthis_, NULL) == JNI_FALSE)
            jenv->DeleteWeakGlobalRef((jweak)jthis_);
        } else
          jenv->DeleteGlobalRef(jthis_);
      }

      jthis_ = NULL;
      weak_global_ = true;
    }

    /* Only call peek if you know what you are doing wrt to weak/global references */
    jobject peek() {
      return jthis_;
    }

    /* Java proxy releases ownership of C++ object, C++ object is now
       responsible for destruction (creates NewGlobalRef to pin Java proxy) */
    void java_change_ownership(JNIEnv *jenv, jobject jself, bool take_or_release) {
      if (take_or_release) {  /* Java takes ownership of C++ object's lifetime. */
        if (!weak_global_) {
          jenv->DeleteGlobalRef(jthis_);
          jthis_ = jenv->NewWeakGlobalRef(jself);
          weak_global_ = true;
        }
      } else {
	/* Java releases ownership of C++ object's lifetime */
        if (weak_global_) {
          jenv->DeleteWeakGlobalRef((jweak)jthis_);
          jthis_ = jenv->NewGlobalRef(jself);
          weak_global_ = false;
        }
      }
    }

  private:
    /* pointer to Java object */
    jobject jthis_;
    /* Local or global reference flag */
    bool weak_global_;
  };

  /* Local JNI reference deleter */
  class LocalRefGuard {
    JNIEnv *jenv_;
    jobject jobj_;

    // non-copyable
    LocalRefGuard(const LocalRefGuard &);
    LocalRefGuard &operator=(const LocalRefGuard &);
  public:
    LocalRefGuard(JNIEnv *jenv, jobject jobj): jenv_(jenv), jobj_(jobj) {}
    ~LocalRefGuard() {
      if (jobj_)
        jenv_->DeleteLocalRef(jobj_);
    }
  };

  /* director base class */
  class Director {
    /* pointer to Java virtual machine */
    JavaVM *swig_jvm_;

  protected:
#if defined (_MSC_VER) && (_MSC_VER<1300)
    class JNIEnvWrapper;
    friend class JNIEnvWrapper;
#endif
    /* Utility class for managing the JNI environment */
    class JNIEnvWrapper {
      const Director *director_;
      JNIEnv *jenv_;
      int env_status;
    public:
      JNIEnvWrapper(const Director *director) : director_(director), jenv_(0), env_status(0) {
#if defined(__ANDROID__)
        JNIEnv **jenv = &jenv_;
#else
        void **jenv = (void **)&jenv_;
#endif
        env_status = director_->swig_jvm_->GetEnv((void **)&jenv_, JNI_VERSION_1_2);
#if defined(SWIG_JAVA_ATTACH_CURRENT_THREAD_AS_DAEMON)
        // Attach a daemon thread to the JVM. Useful when the JVM should not wait for
        // the thread to exit upon shutdown. Only for jdk-1.4 and later.
        director_->swig_jvm_->AttachCurrentThreadAsDaemon(jenv, NULL);
#else
        director_->swig_jvm_->AttachCurrentThread(jenv, NULL);
#endif
      }
      ~JNIEnvWrapper() {
#if !defined(SWIG_JAVA_NO_DETACH_CURRENT_THREAD)
        // Some JVMs, eg jdk-1.4.2 and lower on Solaris have a bug and crash with the DetachCurrentThread call.
        // However, without this call, the JVM hangs on exit when the thread was not created by the JVM and creates a memory leak.
        if (env_status == JNI_EDETACHED)
          director_->swig_jvm_->DetachCurrentThread();
#endif
      }
      JNIEnv *getJNIEnv() const {
        return jenv_;
      }
    };

    /* Java object wrapper */
    JObjectWrapper swig_self_;

    /* Disconnect director from Java object */
    void swig_disconnect_director_self(const char *disconn_method) {
      JNIEnvWrapper jnienv(this) ;
      JNIEnv *jenv = jnienv.getJNIEnv() ;
      jobject jobj = swig_self_.get(jenv);
      LocalRefGuard ref_deleter(jenv, jobj);
#if defined(DEBUG_DIRECTOR_OWNED)
      std::cout << "Swig::Director::disconnect_director_self(" << jobj << ")" << std::endl;
#endif
      if (jobj && jenv->IsSameObject(jobj, NULL) == JNI_FALSE) {
        jmethodID disconn_meth = jenv->GetMethodID(jenv->GetObjectClass(jobj), disconn_method, "()V");
        if (disconn_meth) {
#if defined(DEBUG_DIRECTOR_OWNED)
          std::cout << "Swig::Director::disconnect_director_self upcall to " << disconn_method << std::endl;
#endif
          jenv->CallVoidMethod(jobj, disconn_meth);
        }
      }
    }

  public:
    Director(JNIEnv *jenv) : swig_jvm_((JavaVM *) NULL), swig_self_() {
      /* Acquire the Java VM pointer */
      jenv->GetJavaVM(&swig_jvm_);
    }

    virtual ~Director() {
      JNIEnvWrapper jnienv(this) ;
      JNIEnv *jenv = jnienv.getJNIEnv() ;
      swig_self_.release(jenv);
    }

    bool swig_set_self(JNIEnv *jenv, jobject jself, bool mem_own, bool weak_global) {
      return swig_self_.set(jenv, jself, mem_own, weak_global);
    }

    jobject swig_get_self(JNIEnv *jenv) const {
      return swig_self_.get(jenv);
    }

    // Change C++ object's ownership, relative to Java
    void swig_java_change_ownership(JNIEnv *jenv, jobject jself, bool take_or_release) {
      swig_self_.java_change_ownership(jenv, jself, take_or_release);
    }
  };

  // Zero initialized bool array
  template<size_t N> class BoolArray {
    bool array_[N];
  public:
    BoolArray() {
      memset(array_, 0, sizeof(array_));
    }
    bool& operator[](size_t n) {
      return array_[n];
    }
    bool operator[](size_t n) const {
      return array_[n];
    }
  };

  // Utility classes and functions for exception handling.

  // Simple holder for a Java string during exception handling, providing access to a c-style string
  class JavaString {
  public:
    JavaString(JNIEnv *jenv, jstring jstr) : jenv_(jenv), jstr_(jstr), cstr_(0) {
      if (jenv_ && jstr_)
	cstr_ = (const char *) jenv_->GetStringUTFChars(jstr_, NULL);
    }

    ~JavaString() {
      if (jenv_ && jstr_ && cstr_)
	jenv_->ReleaseStringUTFChars(jstr_, cstr_);
    }

    const char *c_str(const char *null_string = "null JavaString") const {
      return cstr_ ? cstr_ : null_string;
    }

  private:
    // non-copyable
    JavaString(const JavaString &);
    JavaString &operator=(const JavaString &);

    JNIEnv *jenv_;
    jstring jstr_;
    const char *cstr_;
  };

  // Helper class to extract the exception message from a Java throwable
  class JavaExceptionMessage {
  public:
    JavaExceptionMessage(JNIEnv *jenv, jthrowable throwable) : message_(jenv, exceptionMessageFromThrowable(jenv, throwable)) {
    }

    const char *message() const {
      return message_.c_str("Could not get exception message in JavaExceptionMessage");
    }

  private:
    // non-copyable
    JavaExceptionMessage(const JavaExceptionMessage &);
    JavaExceptionMessage &operator=(const JavaExceptionMessage &);

    // Get exception message by calling Java method Throwable.getMessage()
    static jstring exceptionMessageFromThrowable(JNIEnv *jenv, jthrowable throwable) {
      jstring jmsg = NULL;
      if (jenv && throwable) {
	jenv->ExceptionClear(); // Cannot invoke methods with any pending exceptions
	jclass throwclz = jenv->GetObjectClass(throwable);
	if (throwclz) {
	  // All Throwable classes have a getMessage() method, so call it to extract the exception message
	  jmethodID getMessageMethodID = jenv->GetMethodID(throwclz, "getMessage", "()Ljava/lang/String;");
	  if (getMessageMethodID)
	    jmsg = (jstring)jenv->CallObjectMethod(throwable, getMessageMethodID);
	}
	if (jmsg == NULL && jenv->ExceptionCheck())
	  jenv->ExceptionClear();
      }
      return jmsg;
    }

    JavaString message_;
  };

  // C++ Exception class for handling Java exceptions thrown during a director method Java upcall
  class DirectorException : public std::exception {
  public:

    // Construct exception from a Java throwable
    DirectorException(JNIEnv *jenv, jthrowable throwable) : classname_(0), msg_(0) {

      // Call Java method Object.getClass().getName() to obtain the throwable's class name (delimited by '/')
      if (throwable) {
	jclass throwclz = jenv->GetObjectClass(throwable);
	if (throwclz) {
	  jclass clzclz = jenv->GetObjectClass(throwclz);
	  if (clzclz) {
	    jmethodID getNameMethodID = jenv->GetMethodID(clzclz, "getName", "()Ljava/lang/String;");
	    if (getNameMethodID) {
	      jstring jstr_classname = (jstring)(jenv->CallObjectMethod(throwclz, getNameMethodID));
              // Copy strings, since there is no guarantee that jenv will be active when handled
              if (jstr_classname) {
                JavaString jsclassname(jenv, jstr_classname);
                const char *classname = jsclassname.c_str(0);
                if (classname)
                  classname_ = copypath(classname);
              }
	    }
	  }
	}
      }

      JavaExceptionMessage exceptionmsg(jenv, throwable);
      msg_ = copystr(exceptionmsg.message());
    }

    // More general constructor for handling as a java.lang.RuntimeException
    DirectorException(const char *msg) : classname_(0), msg_(copystr(msg ? msg : "Unspecified DirectorException message")) {
    }

    ~DirectorException() throw() {
      delete[] classname_;
      delete[] msg_;
    }

    const char *what() const throw() {
      return msg_;
    }

    // Reconstruct and raise/throw the Java Exception that caused the DirectorException
    // Note that any error in the JNI exception handling results in a Java RuntimeException
    void raiseJavaException(JNIEnv *jenv) const {
      if (jenv) {
	jenv->ExceptionClear();

	jmethodID ctorMethodID = 0;
	jclass throwableclass = 0;
        if (classname_) {
          throwableclass = jenv->FindClass(classname_);
          if (throwableclass)
            ctorMethodID = jenv->GetMethodID(throwableclass, "<init>", "(Ljava/lang/String;)V");
	}

	if (ctorMethodID) {
	  jenv->ThrowNew(throwableclass, what());
	} else {
	  SWIG_JavaThrowException(jenv, SWIG_JavaRuntimeException, what());
	}
      }
    }

  private:
    static char *copypath(const char *srcmsg) {
      char *target = copystr(srcmsg);
      for (char *c=target; *c; ++c) {
        if ('.' == *c)
          *c = '/';
      }
      return target;
    }

    static char *copystr(const char *srcmsg) {
      char *target = 0;
      if (srcmsg) {
	size_t msglen = strlen(srcmsg) + 1;
	target = new char[msglen];
	strncpy(target, srcmsg, msglen);
      }
      return target;
    }

    const char *classname_;
    const char *msg_;
  };

  // Helper method to determine if a Java throwable matches a particular Java class type
  SWIGINTERN inline bool ExceptionMatches(JNIEnv *jenv, jthrowable throwable, const char *classname) {
    bool matches = false;

    if (throwable && jenv && classname) {
      // Exceptions need to be cleared for correct behavior.
      // The caller of ExceptionMatches should restore pending exceptions if desired -
      // the caller already has the throwable.
      jenv->ExceptionClear();

      jclass clz = jenv->FindClass(classname);
      if (clz) {
	jclass classclz = jenv->GetObjectClass(clz);
	jmethodID isInstanceMethodID = jenv->GetMethodID(classclz, "isInstance", "(Ljava/lang/Object;)Z");
	if (isInstanceMethodID) {
	  matches = jenv->CallBooleanMethod(clz, isInstanceMethodID, throwable) != 0;
	}
      }

#if defined(DEBUG_DIRECTOR_EXCEPTION)
      if (jenv->ExceptionCheck()) {
        // Typically occurs when an invalid classname argument is passed resulting in a ClassNotFoundException
        JavaExceptionMessage exc(jenv, jenv->ExceptionOccurred());
        std::cout << "Error: ExceptionMatches: class '" << classname << "' : " << exc.message() << std::endl;
      }
#endif
    }
    return matches;
  }
}

namespace Swig {
  namespace {
    jclass jclass_CollisionJNI = NULL;
    jmethodID director_method_ids[72];
  }
}

#if defined(SWIG_NOINCLUDE) || defined(SWIG_NOARRAYS)


static int SWIG_JavaArrayInBool (JNIEnv *jenv, jboolean **jarr, bool **carr, jbooleanArray input);
static void SWIG_JavaArrayArgoutBool (JNIEnv *jenv, jboolean *jarr, bool *carr, jbooleanArray input);
static jbooleanArray SWIG_JavaArrayOutBool (JNIEnv *jenv, bool *result, jsize sz);


static int SWIG_JavaArrayInSchar (JNIEnv *jenv, jbyte **jarr, signed char **carr, jbyteArray input);
static void SWIG_JavaArrayArgoutSchar (JNIEnv *jenv, jbyte *jarr, signed char *carr, jbyteArray input);
static jbyteArray SWIG_JavaArrayOutSchar (JNIEnv *jenv, signed char *result, jsize sz);


static int SWIG_JavaArrayInUchar (JNIEnv *jenv, jshort **jarr, unsigned char **carr, jshortArray input);
static void SWIG_JavaArrayArgoutUchar (JNIEnv *jenv, jshort *jarr, unsigned char *carr, jshortArray input);
static jshortArray SWIG_JavaArrayOutUchar (JNIEnv *jenv, unsigned char *result, jsize sz);


static int SWIG_JavaArrayInShort (JNIEnv *jenv, jshort **jarr, short **carr, jshortArray input);
static void SWIG_JavaArrayArgoutShort (JNIEnv *jenv, jshort *jarr, short *carr, jshortArray input);
static jshortArray SWIG_JavaArrayOutShort (JNIEnv *jenv, short *result, jsize sz);


static int SWIG_JavaArrayInUshort (JNIEnv *jenv, jint **jarr, unsigned short **carr, jintArray input);
static void SWIG_JavaArrayArgoutUshort (JNIEnv *jenv, jint *jarr, unsigned short *carr, jintArray input);
static jintArray SWIG_JavaArrayOutUshort (JNIEnv *jenv, unsigned short *result, jsize sz);


static int SWIG_JavaArrayInInt (JNIEnv *jenv, jint **jarr, int **carr, jintArray input);
static void SWIG_JavaArrayArgoutInt (JNIEnv *jenv, jint *jarr, int *carr, jintArray input);
static jintArray SWIG_JavaArrayOutInt (JNIEnv *jenv, int *result, jsize sz);


static int SWIG_JavaArrayInUint (JNIEnv *jenv, jlong **jarr, unsigned int **carr, jlongArray input);
static void SWIG_JavaArrayArgoutUint (JNIEnv *jenv, jlong *jarr, unsigned int *carr, jlongArray input);
static jlongArray SWIG_JavaArrayOutUint (JNIEnv *jenv, unsigned int *result, jsize sz);


static int SWIG_JavaArrayInLong (JNIEnv *jenv, jint **jarr, long **carr, jintArray input);
static void SWIG_JavaArrayArgoutLong (JNIEnv *jenv, jint *jarr, long *carr, jintArray input);
static jintArray SWIG_JavaArrayOutLong (JNIEnv *jenv, long *result, jsize sz);


static int SWIG_JavaArrayInUlong (JNIEnv *jenv, jlong **jarr, unsigned long **carr, jlongArray input);
static void SWIG_JavaArrayArgoutUlong (JNIEnv *jenv, jlong *jarr, unsigned long *carr, jlongArray input);
static jlongArray SWIG_JavaArrayOutUlong (JNIEnv *jenv, unsigned long *result, jsize sz);


static int SWIG_JavaArrayInLonglong (JNIEnv *jenv, jlong **jarr, jlong **carr, jlongArray input);
static void SWIG_JavaArrayArgoutLonglong (JNIEnv *jenv, jlong *jarr, jlong *carr, jlongArray input);
static jlongArray SWIG_JavaArrayOutLonglong (JNIEnv *jenv, jlong *result, jsize sz);


static int SWIG_JavaArrayInFloat (JNIEnv *jenv, jfloat **jarr, float **carr, jfloatArray input);
static void SWIG_JavaArrayArgoutFloat (JNIEnv *jenv, jfloat *jarr, float *carr, jfloatArray input);
static jfloatArray SWIG_JavaArrayOutFloat (JNIEnv *jenv, float *result, jsize sz);


static int SWIG_JavaArrayInDouble (JNIEnv *jenv, jdouble **jarr, double **carr, jdoubleArray input);
static void SWIG_JavaArrayArgoutDouble (JNIEnv *jenv, jdouble *jarr, double *carr, jdoubleArray input);
static jdoubleArray SWIG_JavaArrayOutDouble (JNIEnv *jenv, double *result, jsize sz);


#else


/* bool[] support */
static int SWIG_JavaArrayInBool (JNIEnv *jenv, jboolean **jarr, bool **carr, jbooleanArray input) {
  int i;
  jsize sz;
  if (!input) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null array");
    return 0;
  }
  sz = jenv->GetArrayLength(input);
  *jarr = jenv->GetBooleanArrayElements(input, 0);
  if (!*jarr)
    return 0; 
  *carr = new bool[sz]; 
  if (!*carr) {
    SWIG_JavaThrowException(jenv, SWIG_JavaOutOfMemoryError, "array memory allocation failed");
    return 0;
  }
  for (i=0; i<sz; i++)
    (*carr)[i] = ((*jarr)[i] != 0);
  return 1;
}

static void SWIG_JavaArrayArgoutBool (JNIEnv *jenv, jboolean *jarr, bool *carr, jbooleanArray input) {
  int i;
  jsize sz = jenv->GetArrayLength(input);
  for (i=0; i<sz; i++)
    jarr[i] = (jboolean)carr[i];
  jenv->ReleaseBooleanArrayElements(input, jarr, 0);
}

static jbooleanArray SWIG_JavaArrayOutBool (JNIEnv *jenv, bool *result, jsize sz) {
  jboolean *arr;
  int i;
  jbooleanArray jresult = jenv->NewBooleanArray(sz);
  if (!jresult)
    return NULL;
  arr = jenv->GetBooleanArrayElements(jresult, 0);
  if (!arr)
    return NULL;
  for (i=0; i<sz; i++)
    arr[i] = (jboolean)result[i];
  jenv->ReleaseBooleanArrayElements(jresult, arr, 0);
  return jresult;
}


/* signed char[] support */
static int SWIG_JavaArrayInSchar (JNIEnv *jenv, jbyte **jarr, signed char **carr, jbyteArray input) {
  int i;
  jsize sz;
  if (!input) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null array");
    return 0;
  }
  sz = jenv->GetArrayLength(input);
  *jarr = jenv->GetByteArrayElements(input, 0);
  if (!*jarr)
    return 0; 
  *carr = new signed char[sz]; 
  if (!*carr) {
    SWIG_JavaThrowException(jenv, SWIG_JavaOutOfMemoryError, "array memory allocation failed");
    return 0;
  }
  for (i=0; i<sz; i++)
    (*carr)[i] = (signed char)(*jarr)[i];
  return 1;
}

static void SWIG_JavaArrayArgoutSchar (JNIEnv *jenv, jbyte *jarr, signed char *carr, jbyteArray input) {
  int i;
  jsize sz = jenv->GetArrayLength(input);
  for (i=0; i<sz; i++)
    jarr[i] = (jbyte)carr[i];
  jenv->ReleaseByteArrayElements(input, jarr, 0);
}

static jbyteArray SWIG_JavaArrayOutSchar (JNIEnv *jenv, signed char *result, jsize sz) {
  jbyte *arr;
  int i;
  jbyteArray jresult = jenv->NewByteArray(sz);
  if (!jresult)
    return NULL;
  arr = jenv->GetByteArrayElements(jresult, 0);
  if (!arr)
    return NULL;
  for (i=0; i<sz; i++)
    arr[i] = (jbyte)result[i];
  jenv->ReleaseByteArrayElements(jresult, arr, 0);
  return jresult;
}


/* unsigned char[] support */
static int SWIG_JavaArrayInUchar (JNIEnv *jenv, jshort **jarr, unsigned char **carr, jshortArray input) {
  int i;
  jsize sz;
  if (!input) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null array");
    return 0;
  }
  sz = jenv->GetArrayLength(input);
  *jarr = jenv->GetShortArrayElements(input, 0);
  if (!*jarr)
    return 0; 
  *carr = new unsigned char[sz]; 
  if (!*carr) {
    SWIG_JavaThrowException(jenv, SWIG_JavaOutOfMemoryError, "array memory allocation failed");
    return 0;
  }
  for (i=0; i<sz; i++)
    (*carr)[i] = (unsigned char)(*jarr)[i];
  return 1;
}

static void SWIG_JavaArrayArgoutUchar (JNIEnv *jenv, jshort *jarr, unsigned char *carr, jshortArray input) {
  int i;
  jsize sz = jenv->GetArrayLength(input);
  for (i=0; i<sz; i++)
    jarr[i] = (jshort)carr[i];
  jenv->ReleaseShortArrayElements(input, jarr, 0);
}

static jshortArray SWIG_JavaArrayOutUchar (JNIEnv *jenv, unsigned char *result, jsize sz) {
  jshort *arr;
  int i;
  jshortArray jresult = jenv->NewShortArray(sz);
  if (!jresult)
    return NULL;
  arr = jenv->GetShortArrayElements(jresult, 0);
  if (!arr)
    return NULL;
  for (i=0; i<sz; i++)
    arr[i] = (jshort)result[i];
  jenv->ReleaseShortArrayElements(jresult, arr, 0);
  return jresult;
}


/* short[] support */
static int SWIG_JavaArrayInShort (JNIEnv *jenv, jshort **jarr, short **carr, jshortArray input) {
  int i;
  jsize sz;
  if (!input) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null array");
    return 0;
  }
  sz = jenv->GetArrayLength(input);
  *jarr = jenv->GetShortArrayElements(input, 0);
  if (!*jarr)
    return 0; 
  *carr = new short[sz]; 
  if (!*carr) {
    SWIG_JavaThrowException(jenv, SWIG_JavaOutOfMemoryError, "array memory allocation failed");
    return 0;
  }
  for (i=0; i<sz; i++)
    (*carr)[i] = (short)(*jarr)[i];
  return 1;
}

static void SWIG_JavaArrayArgoutShort (JNIEnv *jenv, jshort *jarr, short *carr, jshortArray input) {
  int i;
  jsize sz = jenv->GetArrayLength(input);
  for (i=0; i<sz; i++)
    jarr[i] = (jshort)carr[i];
  jenv->ReleaseShortArrayElements(input, jarr, 0);
}

static jshortArray SWIG_JavaArrayOutShort (JNIEnv *jenv, short *result, jsize sz) {
  jshort *arr;
  int i;
  jshortArray jresult = jenv->NewShortArray(sz);
  if (!jresult)
    return NULL;
  arr = jenv->GetShortArrayElements(jresult, 0);
  if (!arr)
    return NULL;
  for (i=0; i<sz; i++)
    arr[i] = (jshort)result[i];
  jenv->ReleaseShortArrayElements(jresult, arr, 0);
  return jresult;
}


/* unsigned short[] support */
static int SWIG_JavaArrayInUshort (JNIEnv *jenv, jint **jarr, unsigned short **carr, jintArray input) {
  int i;
  jsize sz;
  if (!input) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null array");
    return 0;
  }
  sz = jenv->GetArrayLength(input);
  *jarr = jenv->GetIntArrayElements(input, 0);
  if (!*jarr)
    return 0; 
  *carr = new unsigned short[sz]; 
  if (!*carr) {
    SWIG_JavaThrowException(jenv, SWIG_JavaOutOfMemoryError, "array memory allocation failed");
    return 0;
  }
  for (i=0; i<sz; i++)
    (*carr)[i] = (unsigned short)(*jarr)[i];
  return 1;
}

static void SWIG_JavaArrayArgoutUshort (JNIEnv *jenv, jint *jarr, unsigned short *carr, jintArray input) {
  int i;
  jsize sz = jenv->GetArrayLength(input);
  for (i=0; i<sz; i++)
    jarr[i] = (jint)carr[i];
  jenv->ReleaseIntArrayElements(input, jarr, 0);
}

static jintArray SWIG_JavaArrayOutUshort (JNIEnv *jenv, unsigned short *result, jsize sz) {
  jint *arr;
  int i;
  jintArray jresult = jenv->NewIntArray(sz);
  if (!jresult)
    return NULL;
  arr = jenv->GetIntArrayElements(jresult, 0);
  if (!arr)
    return NULL;
  for (i=0; i<sz; i++)
    arr[i] = (jint)result[i];
  jenv->ReleaseIntArrayElements(jresult, arr, 0);
  return jresult;
}


/* int[] support */
static int SWIG_JavaArrayInInt (JNIEnv *jenv, jint **jarr, int **carr, jintArray input) {
  int i;
  jsize sz;
  if (!input) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null array");
    return 0;
  }
  sz = jenv->GetArrayLength(input);
  *jarr = jenv->GetIntArrayElements(input, 0);
  if (!*jarr)
    return 0; 
  *carr = new int[sz]; 
  if (!*carr) {
    SWIG_JavaThrowException(jenv, SWIG_JavaOutOfMemoryError, "array memory allocation failed");
    return 0;
  }
  for (i=0; i<sz; i++)
    (*carr)[i] = (int)(*jarr)[i];
  return 1;
}

static void SWIG_JavaArrayArgoutInt (JNIEnv *jenv, jint *jarr, int *carr, jintArray input) {
  int i;
  jsize sz = jenv->GetArrayLength(input);
  for (i=0; i<sz; i++)
    jarr[i] = (jint)carr[i];
  jenv->ReleaseIntArrayElements(input, jarr, 0);
}

static jintArray SWIG_JavaArrayOutInt (JNIEnv *jenv, int *result, jsize sz) {
  jint *arr;
  int i;
  jintArray jresult = jenv->NewIntArray(sz);
  if (!jresult)
    return NULL;
  arr = jenv->GetIntArrayElements(jresult, 0);
  if (!arr)
    return NULL;
  for (i=0; i<sz; i++)
    arr[i] = (jint)result[i];
  jenv->ReleaseIntArrayElements(jresult, arr, 0);
  return jresult;
}


/* unsigned int[] support */
static int SWIG_JavaArrayInUint (JNIEnv *jenv, jlong **jarr, unsigned int **carr, jlongArray input) {
  int i;
  jsize sz;
  if (!input) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null array");
    return 0;
  }
  sz = jenv->GetArrayLength(input);
  *jarr = jenv->GetLongArrayElements(input, 0);
  if (!*jarr)
    return 0; 
  *carr = new unsigned int[sz]; 
  if (!*carr) {
    SWIG_JavaThrowException(jenv, SWIG_JavaOutOfMemoryError, "array memory allocation failed");
    return 0;
  }
  for (i=0; i<sz; i++)
    (*carr)[i] = (unsigned int)(*jarr)[i];
  return 1;
}

static void SWIG_JavaArrayArgoutUint (JNIEnv *jenv, jlong *jarr, unsigned int *carr, jlongArray input) {
  int i;
  jsize sz = jenv->GetArrayLength(input);
  for (i=0; i<sz; i++)
    jarr[i] = (jlong)carr[i];
  jenv->ReleaseLongArrayElements(input, jarr, 0);
}

static jlongArray SWIG_JavaArrayOutUint (JNIEnv *jenv, unsigned int *result, jsize sz) {
  jlong *arr;
  int i;
  jlongArray jresult = jenv->NewLongArray(sz);
  if (!jresult)
    return NULL;
  arr = jenv->GetLongArrayElements(jresult, 0);
  if (!arr)
    return NULL;
  for (i=0; i<sz; i++)
    arr[i] = (jlong)result[i];
  jenv->ReleaseLongArrayElements(jresult, arr, 0);
  return jresult;
}


/* long[] support */
static int SWIG_JavaArrayInLong (JNIEnv *jenv, jint **jarr, long **carr, jintArray input) {
  int i;
  jsize sz;
  if (!input) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null array");
    return 0;
  }
  sz = jenv->GetArrayLength(input);
  *jarr = jenv->GetIntArrayElements(input, 0);
  if (!*jarr)
    return 0; 
  *carr = new long[sz]; 
  if (!*carr) {
    SWIG_JavaThrowException(jenv, SWIG_JavaOutOfMemoryError, "array memory allocation failed");
    return 0;
  }
  for (i=0; i<sz; i++)
    (*carr)[i] = (long)(*jarr)[i];
  return 1;
}

static void SWIG_JavaArrayArgoutLong (JNIEnv *jenv, jint *jarr, long *carr, jintArray input) {
  int i;
  jsize sz = jenv->GetArrayLength(input);
  for (i=0; i<sz; i++)
    jarr[i] = (jint)carr[i];
  jenv->ReleaseIntArrayElements(input, jarr, 0);
}

static jintArray SWIG_JavaArrayOutLong (JNIEnv *jenv, long *result, jsize sz) {
  jint *arr;
  int i;
  jintArray jresult = jenv->NewIntArray(sz);
  if (!jresult)
    return NULL;
  arr = jenv->GetIntArrayElements(jresult, 0);
  if (!arr)
    return NULL;
  for (i=0; i<sz; i++)
    arr[i] = (jint)result[i];
  jenv->ReleaseIntArrayElements(jresult, arr, 0);
  return jresult;
}


/* unsigned long[] support */
static int SWIG_JavaArrayInUlong (JNIEnv *jenv, jlong **jarr, unsigned long **carr, jlongArray input) {
  int i;
  jsize sz;
  if (!input) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null array");
    return 0;
  }
  sz = jenv->GetArrayLength(input);
  *jarr = jenv->GetLongArrayElements(input, 0);
  if (!*jarr)
    return 0; 
  *carr = new unsigned long[sz]; 
  if (!*carr) {
    SWIG_JavaThrowException(jenv, SWIG_JavaOutOfMemoryError, "array memory allocation failed");
    return 0;
  }
  for (i=0; i<sz; i++)
    (*carr)[i] = (unsigned long)(*jarr)[i];
  return 1;
}

static void SWIG_JavaArrayArgoutUlong (JNIEnv *jenv, jlong *jarr, unsigned long *carr, jlongArray input) {
  int i;
  jsize sz = jenv->GetArrayLength(input);
  for (i=0; i<sz; i++)
    jarr[i] = (jlong)carr[i];
  jenv->ReleaseLongArrayElements(input, jarr, 0);
}

static jlongArray SWIG_JavaArrayOutUlong (JNIEnv *jenv, unsigned long *result, jsize sz) {
  jlong *arr;
  int i;
  jlongArray jresult = jenv->NewLongArray(sz);
  if (!jresult)
    return NULL;
  arr = jenv->GetLongArrayElements(jresult, 0);
  if (!arr)
    return NULL;
  for (i=0; i<sz; i++)
    arr[i] = (jlong)result[i];
  jenv->ReleaseLongArrayElements(jresult, arr, 0);
  return jresult;
}


/* jlong[] support */
static int SWIG_JavaArrayInLonglong (JNIEnv *jenv, jlong **jarr, jlong **carr, jlongArray input) {
  int i;
  jsize sz;
  if (!input) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null array");
    return 0;
  }
  sz = jenv->GetArrayLength(input);
  *jarr = jenv->GetLongArrayElements(input, 0);
  if (!*jarr)
    return 0; 
  *carr = new jlong[sz]; 
  if (!*carr) {
    SWIG_JavaThrowException(jenv, SWIG_JavaOutOfMemoryError, "array memory allocation failed");
    return 0;
  }
  for (i=0; i<sz; i++)
    (*carr)[i] = (jlong)(*jarr)[i];
  return 1;
}

static void SWIG_JavaArrayArgoutLonglong (JNIEnv *jenv, jlong *jarr, jlong *carr, jlongArray input) {
  int i;
  jsize sz = jenv->GetArrayLength(input);
  for (i=0; i<sz; i++)
    jarr[i] = (jlong)carr[i];
  jenv->ReleaseLongArrayElements(input, jarr, 0);
}

static jlongArray SWIG_JavaArrayOutLonglong (JNIEnv *jenv, jlong *result, jsize sz) {
  jlong *arr;
  int i;
  jlongArray jresult = jenv->NewLongArray(sz);
  if (!jresult)
    return NULL;
  arr = jenv->GetLongArrayElements(jresult, 0);
  if (!arr)
    return NULL;
  for (i=0; i<sz; i++)
    arr[i] = (jlong)result[i];
  jenv->ReleaseLongArrayElements(jresult, arr, 0);
  return jresult;
}


/* float[] support */
static int SWIG_JavaArrayInFloat (JNIEnv *jenv, jfloat **jarr, float **carr, jfloatArray input) {
  int i;
  jsize sz;
  if (!input) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null array");
    return 0;
  }
  sz = jenv->GetArrayLength(input);
  *jarr = jenv->GetFloatArrayElements(input, 0);
  if (!*jarr)
    return 0; 
  *carr = new float[sz]; 
  if (!*carr) {
    SWIG_JavaThrowException(jenv, SWIG_JavaOutOfMemoryError, "array memory allocation failed");
    return 0;
  }
  for (i=0; i<sz; i++)
    (*carr)[i] = (float)(*jarr)[i];
  return 1;
}

static void SWIG_JavaArrayArgoutFloat (JNIEnv *jenv, jfloat *jarr, float *carr, jfloatArray input) {
  int i;
  jsize sz = jenv->GetArrayLength(input);
  for (i=0; i<sz; i++)
    jarr[i] = (jfloat)carr[i];
  jenv->ReleaseFloatArrayElements(input, jarr, 0);
}

static jfloatArray SWIG_JavaArrayOutFloat (JNIEnv *jenv, float *result, jsize sz) {
  jfloat *arr;
  int i;
  jfloatArray jresult = jenv->NewFloatArray(sz);
  if (!jresult)
    return NULL;
  arr = jenv->GetFloatArrayElements(jresult, 0);
  if (!arr)
    return NULL;
  for (i=0; i<sz; i++)
    arr[i] = (jfloat)result[i];
  jenv->ReleaseFloatArrayElements(jresult, arr, 0);
  return jresult;
}


/* double[] support */
static int SWIG_JavaArrayInDouble (JNIEnv *jenv, jdouble **jarr, double **carr, jdoubleArray input) {
  int i;
  jsize sz;
  if (!input) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null array");
    return 0;
  }
  sz = jenv->GetArrayLength(input);
  *jarr = jenv->GetDoubleArrayElements(input, 0);
  if (!*jarr)
    return 0; 
  *carr = new double[sz]; 
  if (!*carr) {
    SWIG_JavaThrowException(jenv, SWIG_JavaOutOfMemoryError, "array memory allocation failed");
    return 0;
  }
  for (i=0; i<sz; i++)
    (*carr)[i] = (double)(*jarr)[i];
  return 1;
}

static void SWIG_JavaArrayArgoutDouble (JNIEnv *jenv, jdouble *jarr, double *carr, jdoubleArray input) {
  int i;
  jsize sz = jenv->GetArrayLength(input);
  for (i=0; i<sz; i++)
    jarr[i] = (jdouble)carr[i];
  jenv->ReleaseDoubleArrayElements(input, jarr, 0);
}

static jdoubleArray SWIG_JavaArrayOutDouble (JNIEnv *jenv, double *result, jsize sz) {
  jdouble *arr;
  int i;
  jdoubleArray jresult = jenv->NewDoubleArray(sz);
  if (!jresult)
    return NULL;
  arr = jenv->GetDoubleArrayElements(jresult, 0);
  if (!arr)
    return NULL;
  for (i=0; i<sz; i++)
    arr[i] = (jdouble)result[i];
  jenv->ReleaseDoubleArrayElements(jresult, arr, 0);
  return jresult;
}


#endif


#include <gdx/common/jniHelpers.h>


#include <stdint.h>


#include <gdx/linearmath/mathtypes.h>
#include <LinearMath/btVector3.h>
#include <LinearMath/btQuaternion.h>
#include <LinearMath/btMatrix3x3.h>
#include <LinearMath/btTransform.h>


#include <BulletCollision/NarrowPhaseCollision/btDiscreteCollisionDetectorInterface.h>



	/* Gets a global ref to the temp class.  Do not release this. */
	SWIGINTERN inline jclass gdx_getTempClassVector3(JNIEnv * jenv) {
	  static jclass cls = NULL;
	  if (cls == NULL) {
		cls = (jclass) jenv->NewGlobalRef(jenv->FindClass("com/badlogic/gdx/physics/bullet/linearmath/LinearMath"));
	  }
	  return cls;
	}
	
	SWIGINTERN inline jobject gdx_takePoolObjectVector3(JNIEnv * jenv, const char * poolName) {
	  jclass tempClass = gdx_getTempClassVector3(jenv);
	  
	  static jfieldID poolField = NULL;
	  if (poolField == NULL) {
		poolField = jenv->GetStaticFieldID(tempClass, poolName, "Lcom/badlogic/gdx/utils/Pool;");
	  }
	  
	  jobject poolObject = jenv->GetStaticObjectField(tempClass, poolField);
	  jclass poolClass = jenv->GetObjectClass(poolObject);
	  
	  static jmethodID obtainMethod = NULL;
	  if (obtainMethod == NULL) {
		obtainMethod = (jmethodID) jenv->GetMethodID(poolClass, "obtain", "()Ljava/lang/Object;");
	  }
	  
	  jobject ret = jenv->CallObjectMethod(poolObject, obtainMethod);
	
	  jenv->DeleteLocalRef(poolObject);
	  jenv->DeleteLocalRef(poolClass);
	
	  return ret;
	}
	
	SWIGINTERN inline void gdx_releasePoolObjectVector3(JNIEnv * jenv, const char * poolName, jobject obj) {
	  jclass tempClass = gdx_getTempClassVector3(jenv);
	  
	  static jfieldID poolField = NULL;
	  if (poolField == NULL) {
		poolField = jenv->GetStaticFieldID(tempClass, poolName, "Lcom/badlogic/gdx/utils/Pool;");
	  }
	  
	  jobject poolObject = jenv->GetStaticObjectField(tempClass, poolField);
	  jclass poolClass = jenv->GetObjectClass(poolObject);
	  
	  static jmethodID freeMethod = NULL;
	  if (freeMethod == NULL) {
		freeMethod = (jmethodID) jenv->GetMethodID(poolClass, "free", "(Ljava/lang/Object;)V");
	  }
	  
	  jenv->CallVoidMethod(poolObject, freeMethod, obj);
	  
	  jenv->DeleteLocalRef(poolObject);
	  jenv->DeleteLocalRef(poolClass);
	  jenv->DeleteLocalRef(obj);
	}
	
	/*
	 * A simple RAII wrapper to release jobjects we obtain from pools in 
	 * directorin typemaps.  SWIG doesn't have hooks to release them after
	 * they're used. 
	 */
	class gdxPoolAutoReleaseVector3 {
	private:
	  JNIEnv * jenv;
	  const char * poolName;
	  jobject obj;
	public:
	  gdxPoolAutoReleaseVector3(JNIEnv * jenv, const char * poolName, jobject obj) : 
		jenv(jenv), poolName(poolName), obj(obj) { };
	  virtual ~gdxPoolAutoReleaseVector3() {
		gdx_releasePoolObjectVector3(this->jenv, this->poolName, this->obj);
	  };
	};


	
// Workaround for some strange swig behaviour


	/* Gets a global ref to the temp class's Return Vector3.  Do not release this. */ 
	SWIGINTERN inline jobject gdx_getReturnVector3(JNIEnv * jenv) {
	  static jobject ret = NULL;
	  if (ret == NULL) {
	    jclass tempClass = gdx_getTempClassVector3(jenv);
	    jfieldID field = jenv->GetStaticFieldID(tempClass, "staticVector3", "Lcom/badlogic/gdx/math/Vector3;");
	    ret = jenv->NewGlobalRef(jenv->GetStaticObjectField(tempClass, field));
	  }
	  return ret;
	}
	
	/* Sets the data in the Bullet type from the Gdx type. */
	SWIGINTERN inline void gdx_setbtVector3FromVector3(JNIEnv * jenv, btVector3 & target, jobject source) {
		Vector3_to_btVector3(jenv, target, source);
	}

	SWIGINTERN inline void gdx_setbtVector3FromVector3(JNIEnv * jenv, btVector3 * target, jobject source) {
		gdx_setbtVector3FromVector3(jenv, *target, source);
	}

	/* Sets the data in the Gdx type from the Bullet type. */
	SWIGINTERN inline void gdx_setVector3FrombtVector3(JNIEnv * jenv, jobject target, const btVector3 & source) {
		btVector3_to_Vector3(jenv, target, source);
	}

	SWIGINTERN inline void gdx_setVector3FrombtVector3(JNIEnv * jenv, jobject target, const btVector3 * source) {
		gdx_setVector3FrombtVector3(jenv, target, *source);
	}

	/*
	 * RAII wrapper to commit changes made to a local btVector3 back to Vector3
	 */
	class gdxAutoCommitVector3 {
	private:
	  JNIEnv * jenv;
	  jobject jVector3;
	  btVector3 & cbtVector3;
	public:
	  gdxAutoCommitVector3(JNIEnv * jenv, jobject jVector3, btVector3 & cbtVector3) : 
	    jenv(jenv), jVector3(jVector3), cbtVector3(cbtVector3) { };
	  gdxAutoCommitVector3(JNIEnv * jenv, jobject jVector3, btVector3 * cbtVector3) : 
	    jenv(jenv), jVector3(jVector3), cbtVector3(*cbtVector3) { };
	  virtual ~gdxAutoCommitVector3() {
	    gdx_setVector3FrombtVector3(this->jenv, this->jVector3, this->cbtVector3);
	  };
	};

	class gdxAutoCommitbtVector3AndReleaseVector3 {
	private:
	  JNIEnv * jenv;
	  jobject jVector3;
	  btVector3 & cbtVector3;
	  const char * poolName;
	public:
	  gdxAutoCommitbtVector3AndReleaseVector3(JNIEnv * jenv, jobject jVector3, btVector3 & cbtVector3, const char *poolName) : 
	    jenv(jenv), jVector3(jVector3), cbtVector3(cbtVector3), poolName(poolName) { };
	  gdxAutoCommitbtVector3AndReleaseVector3(JNIEnv * jenv, jobject jVector3, btVector3 * cbtVector3, const char *poolName) : 
	    jenv(jenv), jVector3(jVector3), cbtVector3(*cbtVector3), poolName(poolName) { };
	  virtual ~gdxAutoCommitbtVector3AndReleaseVector3() {
	    gdx_setbtVector3FromVector3(this->jenv, this->cbtVector3, this->jVector3);
	    gdx_releasePoolObjectVector3(this->jenv, this->poolName, this->jVector3);
	  };
	};


#include <BulletCollision/BroadphaseCollision/btBroadphaseProxy.h>


#include <BulletCollision/BroadphaseCollision/btBroadphaseInterface.h>


#include <BulletCollision/BroadphaseCollision/btQuantizedBvh.h>


#include <BulletCollision/BroadphaseCollision/btSimpleBroadphase.h>


#include <BulletCollision/BroadphaseCollision/btMultiSapBroadphase.h>
void btMultiSapBroadphase::quicksort(btBroadphasePairArray& a, int lo, int hi)
{
}


#include <BulletCollision/BroadphaseCollision/btCollisionAlgorithm.h>


#include <BulletCollision/BroadphaseCollision/btOverlappingPairCallback.h>


#include <BulletCollision/BroadphaseCollision/btAxisSweep3.h>


#include <BulletCollision/BroadphaseCollision/btDispatcher.h>


#include <BulletCollision/BroadphaseCollision/btOverlappingPairCache.h>


	// Inline (cached) method to retrieve the type's jclass
	SWIGINTERN inline jclass &gdx_getClassbtBroadphasePair(JNIEnv * const &jenv) {
		static jclass cls = NULL;
		if (cls == NULL)
			cls = (jclass) jenv->NewGlobalRef(jenv->FindClass("com/badlogic/gdx/physics/bullet/collision/btBroadphasePair"));
		return cls;
	}
	
	// Inline method to get the termporary instance
	SWIGINTERN inline jobject gdx_getTempbtBroadphasePair(JNIEnv * jenv, void *cPtr, bool ownMem) {
	  static jobject ret = NULL;
	  jclass &clazz = gdx_getClassbtBroadphasePair(jenv);
	  if (ret == NULL) {
	    jfieldID field = jenv->GetStaticFieldID(clazz, "temp", "Lcom/badlogic/gdx/physics/bullet/collision/btBroadphasePair;");
	    ret = jenv->NewGlobalRef(jenv->GetStaticObjectField(clazz, field));
	  }
	  
	  static jmethodID reuseMethod = NULL;
	  if (reuseMethod == NULL)
		  reuseMethod = (jmethodID) jenv->GetMethodID(clazz, "reset", "(JZ)V");
	  
	  long ptr;
	  *(const void **)&ptr = cPtr;
	  jenv->CallVoidMethod(ret, reuseMethod, ptr, (jboolean)ownMem);
	  return ret;
	}

	// Inline method to obtain an instance from the pool
	SWIGINTERN inline jobject gdx_obtainbtBroadphasePair(JNIEnv * jenv, jclass clazz, void *cPtr, bool ownMem) {
		static jmethodID obtainMethod = NULL;
		if (obtainMethod == NULL)
			obtainMethod = (jmethodID) jenv->GetStaticMethodID(clazz, "obtain", "(JZ)Lcom/badlogic/gdx/physics/bullet/collision/btBroadphasePair;");
		
		long ptr;
		*(const void **)&ptr = cPtr; 
		jobject ret = jenv->CallStaticObjectMethod(clazz, obtainMethod, ptr, (jboolean)ownMem);
		
		return ret;
	}
	
	// Inline method to free an instance from the pool
	SWIGINTERN inline void gdx_freebtBroadphasePair(JNIEnv * jenv, const jclass clazz, const jobject obj) {
		static jmethodID freeMethod = NULL;
		if (freeMethod == NULL)
			freeMethod = (jmethodID) jenv->GetStaticMethodID(clazz, "free", "(Lcom/badlogic/gdx/physics/bullet/collision/btBroadphasePair;)V");
		
		jenv->CallStaticVoidMethod(clazz, freeMethod, obj);
		
		jenv->DeleteLocalRef(obj);
	}
	
	// Simple raii class to auto free the instance from the pool 
	class gdxAutoFreebtBroadphasePair {
	private:
		JNIEnv * jenv;
		jobject jbtBroadphasePair;
		jclass jclazz;
	public:
		gdxAutoFreebtBroadphasePair(JNIEnv * jenv, jclass jclazz, jobject jbtBroadphasePair) : 
			jenv(jenv), jbtBroadphasePair(jbtBroadphasePair), jclazz(jclazz) { }
		virtual ~gdxAutoFreebtBroadphasePair() {
			gdx_freebtBroadphasePair(this->jenv, this->jclazz, this->jbtBroadphasePair);
		}
	};


#include <BulletCollision/CollisionShapes/btCollisionShape.h>



	/* Gets a global ref to the temp class.  Do not release this. */
	SWIGINTERN inline jclass gdx_getTempClassMatrix4(JNIEnv * jenv) {
	  static jclass cls = NULL;
	  if (cls == NULL) {
		cls = (jclass) jenv->NewGlobalRef(jenv->FindClass("com/badlogic/gdx/physics/bullet/linearmath/LinearMath"));
	  }
	  return cls;
	}
	
	SWIGINTERN inline jobject gdx_takePoolObjectMatrix4(JNIEnv * jenv, const char * poolName) {
	  jclass tempClass = gdx_getTempClassMatrix4(jenv);
	  
	  static jfieldID poolField = NULL;
	  if (poolField == NULL) {
		poolField = jenv->GetStaticFieldID(tempClass, poolName, "Lcom/badlogic/gdx/utils/Pool;");
	  }
	  
	  jobject poolObject = jenv->GetStaticObjectField(tempClass, poolField);
	  jclass poolClass = jenv->GetObjectClass(poolObject);
	  
	  static jmethodID obtainMethod = NULL;
	  if (obtainMethod == NULL) {
		obtainMethod = (jmethodID) jenv->GetMethodID(poolClass, "obtain", "()Ljava/lang/Object;");
	  }
	  
	  jobject ret = jenv->CallObjectMethod(poolObject, obtainMethod);
	
	  jenv->DeleteLocalRef(poolObject);
	  jenv->DeleteLocalRef(poolClass);
	
	  return ret;
	}
	
	SWIGINTERN inline void gdx_releasePoolObjectMatrix4(JNIEnv * jenv, const char * poolName, jobject obj) {
	  jclass tempClass = gdx_getTempClassMatrix4(jenv);
	  
	  static jfieldID poolField = NULL;
	  if (poolField == NULL) {
		poolField = jenv->GetStaticFieldID(tempClass, poolName, "Lcom/badlogic/gdx/utils/Pool;");
	  }
	  
	  jobject poolObject = jenv->GetStaticObjectField(tempClass, poolField);
	  jclass poolClass = jenv->GetObjectClass(poolObject);
	  
	  static jmethodID freeMethod = NULL;
	  if (freeMethod == NULL) {
		freeMethod = (jmethodID) jenv->GetMethodID(poolClass, "free", "(Ljava/lang/Object;)V");
	  }
	  
	  jenv->CallVoidMethod(poolObject, freeMethod, obj);
	  
	  jenv->DeleteLocalRef(poolObject);
	  jenv->DeleteLocalRef(poolClass);
	  jenv->DeleteLocalRef(obj);
	}
	
	/*
	 * A simple RAII wrapper to release jobjects we obtain from pools in 
	 * directorin typemaps.  SWIG doesn't have hooks to release them after
	 * they're used. 
	 */
	class gdxPoolAutoReleaseMatrix4 {
	private:
	  JNIEnv * jenv;
	  const char * poolName;
	  jobject obj;
	public:
	  gdxPoolAutoReleaseMatrix4(JNIEnv * jenv, const char * poolName, jobject obj) : 
		jenv(jenv), poolName(poolName), obj(obj) { };
	  virtual ~gdxPoolAutoReleaseMatrix4() {
		gdx_releasePoolObjectMatrix4(this->jenv, this->poolName, this->obj);
	  };
	};


	
// Workaround for some strange swig behaviour


	/* Gets a global ref to the temp class's Return Matrix4.  Do not release this. */ 
	SWIGINTERN inline jobject gdx_getReturnMatrix4(JNIEnv * jenv) {
	  static jobject ret = NULL;
	  if (ret == NULL) {
	    jclass tempClass = gdx_getTempClassMatrix4(jenv);
	    jfieldID field = jenv->GetStaticFieldID(tempClass, "staticMatrix4", "Lcom/badlogic/gdx/math/Matrix4;");
	    ret = jenv->NewGlobalRef(jenv->GetStaticObjectField(tempClass, field));
	  }
	  return ret;
	}
	
	/* Sets the data in the Bullet type from the Gdx type. */
	SWIGINTERN inline void gdx_setbtTransformFromMatrix4(JNIEnv * jenv, btTransform & target, jobject source) {
		Matrix4_to_btTransform(jenv, target, source);
	}

	SWIGINTERN inline void gdx_setbtTransformFromMatrix4(JNIEnv * jenv, btTransform * target, jobject source) {
		gdx_setbtTransformFromMatrix4(jenv, *target, source);
	}

	/* Sets the data in the Gdx type from the Bullet type. */
	SWIGINTERN inline void gdx_setMatrix4FrombtTransform(JNIEnv * jenv, jobject target, const btTransform & source) {
		btTransform_to_Matrix4(jenv, target, source);
	}

	SWIGINTERN inline void gdx_setMatrix4FrombtTransform(JNIEnv * jenv, jobject target, const btTransform * source) {
		gdx_setMatrix4FrombtTransform(jenv, target, *source);
	}

	/*
	 * RAII wrapper to commit changes made to a local btTransform back to Matrix4
	 */
	class gdxAutoCommitMatrix4 {
	private:
	  JNIEnv * jenv;
	  jobject jMatrix4;
	  btTransform & cbtTransform;
	public:
	  gdxAutoCommitMatrix4(JNIEnv * jenv, jobject jMatrix4, btTransform & cbtTransform) : 
	    jenv(jenv), jMatrix4(jMatrix4), cbtTransform(cbtTransform) { };
	  gdxAutoCommitMatrix4(JNIEnv * jenv, jobject jMatrix4, btTransform * cbtTransform) : 
	    jenv(jenv), jMatrix4(jMatrix4), cbtTransform(*cbtTransform) { };
	  virtual ~gdxAutoCommitMatrix4() {
	    gdx_setMatrix4FrombtTransform(this->jenv, this->jMatrix4, this->cbtTransform);
	  };
	};

	class gdxAutoCommitbtTransformAndReleaseMatrix4 {
	private:
	  JNIEnv * jenv;
	  jobject jMatrix4;
	  btTransform & cbtTransform;
	  const char * poolName;
	public:
	  gdxAutoCommitbtTransformAndReleaseMatrix4(JNIEnv * jenv, jobject jMatrix4, btTransform & cbtTransform, const char *poolName) : 
	    jenv(jenv), jMatrix4(jMatrix4), cbtTransform(cbtTransform), poolName(poolName) { };
	  gdxAutoCommitbtTransformAndReleaseMatrix4(JNIEnv * jenv, jobject jMatrix4, btTransform * cbtTransform, const char *poolName) : 
	    jenv(jenv), jMatrix4(jMatrix4), cbtTransform(*cbtTransform), poolName(poolName) { };
	  virtual ~gdxAutoCommitbtTransformAndReleaseMatrix4() {
	    gdx_setbtTransformFromMatrix4(this->jenv, this->cbtTransform, this->jMatrix4);
	    gdx_releasePoolObjectMatrix4(this->jenv, this->poolName, this->jMatrix4);
	  };
	};


#include <BulletCollision/CollisionShapes/btConvexShape.h>


#include <BulletCollision/CollisionShapes/btConvexInternalShape.h>


#include <BulletCollision/CollisionShapes/btPolyhedralConvexShape.h>


#include <BulletCollision/CollisionShapes/btConcaveShape.h>


#include <BulletCollision/CollisionShapes/btTriangleCallback.h>


#include <BulletCollision/CollisionShapes/btTriangleInfoMap.h>


#include <BulletCollision/CollisionShapes/btStaticPlaneShape.h>


#include <BulletCollision/CollisionShapes/btHeightfieldTerrainShape.h>

SWIGINTERN btHeightfieldTerrainShape *new_btHeightfieldTerrainShape__SWIG_0(int heightStickWidth,int heightStickLength,float const *heightfieldData,btScalar heightScale,btScalar minHeight,btScalar maxHeight,int upAxis,bool flipQuadEdges){
		return new btHeightfieldTerrainShape(heightStickWidth, heightStickLength, (void *)heightfieldData, heightScale, minHeight, maxHeight, upAxis, PHY_FLOAT, flipQuadEdges);
	}
SWIGINTERN btHeightfieldTerrainShape *new_btHeightfieldTerrainShape__SWIG_1(int heightStickWidth,int heightStickLength,short const *heightfieldData,btScalar heightScale,btScalar minHeight,btScalar maxHeight,int upAxis,bool flipQuadEdges){
		return new btHeightfieldTerrainShape(heightStickWidth, heightStickLength, (void *)heightfieldData, heightScale, minHeight, maxHeight, upAxis, PHY_SHORT, flipQuadEdges);
	}

#include <BulletCollision/CollisionShapes/btTriangleMeshShape.h>


#include <BulletCollision/CollisionShapes/btBvhTriangleMeshShape.h>

SWIGINTERN btBvhTriangleMeshShape *new_btBvhTriangleMeshShape__SWIG_0(bool dummy,btStridingMeshInterface *meshInterface,bool useQuantizedAabbCompression,bool buildBvh=true){
		return new btBvhTriangleMeshShape(meshInterface, useQuantizedAabbCompression, buildBvh);
	}
SWIGINTERN btBvhTriangleMeshShape *new_btBvhTriangleMeshShape__SWIG_2(bool dummy,btStridingMeshInterface *meshInterface,bool useQuantizedAabbCompression,btVector3 const &bvhAabbMin,btVector3 const &bvhAabbMax,bool buildBvh=true){
		return new btBvhTriangleMeshShape(meshInterface, useQuantizedAabbCompression, bvhAabbMin, bvhAabbMax, buildBvh);
	}

#include <BulletCollision/CollisionShapes/btBoxShape.h>


#include <BulletCollision/CollisionShapes/btCapsuleShape.h>


#include <BulletCollision/CollisionShapes/btBox2dShape.h>


#include <BulletCollision/CollisionShapes/btCollisionMargin.h>


#include <BulletCollision/CollisionShapes/btTriangleShape.h>


#include <BulletCollision/CollisionShapes/btSphereShape.h>


#include <BulletCollision/CollisionShapes/btStridingMeshInterface.h>


#include <BulletCollision/CollisionShapes/btMinkowskiSumShape.h>


#include <BulletCollision/CollisionShapes/btConvexPolyhedron.h>


#include <BulletCollision/CollisionShapes/btOptimizedBvh.h>


#include <BulletCollision/CollisionShapes/btTriangleBuffer.h>


#include <BulletCollision/CollisionShapes/btTriangleIndexVertexArray.h>

SWIGINTERN void btIndexedMesh_setTriangleIndexBase(btIndexedMesh *self,short *data){
		self->m_triangleIndexBase = (unsigned char*)data;
	}
SWIGINTERN void btIndexedMesh_setVertexBase(btIndexedMesh *self,float *data){
		self->m_vertexBase = (unsigned char*)data;
	}
SWIGINTERN void btIndexedMesh_setVertices(btIndexedMesh *self,float *vertices,int sizeInBytesOfEachVertex,int vertexCount,int positionOffsetInBytes){
		unsigned char *data = (unsigned char *)vertices;
		self->m_vertexBase = &(data[positionOffsetInBytes]);
		self->m_vertexStride = sizeInBytesOfEachVertex;
		self->m_numVertices = vertexCount;
		self->m_vertexType = PHY_FLOAT;
	}
SWIGINTERN void btIndexedMesh_setIndices(btIndexedMesh *self,short *indices,int indexOffset,int indexCount){
		self->m_triangleIndexBase = (unsigned char*)&(indices[indexOffset]);
		self->m_triangleIndexStride = 3 * sizeof(short);
		self->m_numTriangles = indexCount / 3;
		self->m_indexType = PHY_SHORT;
	}

#include <BulletCollision/CollisionShapes/btMaterial.h>


#include <BulletCollision/CollisionShapes/btScaledBvhTriangleMeshShape.h>


#include <BulletCollision/CollisionShapes/btShapeHull.h>

SWIGINTERN btVector3 const &btShapeHull_getVertex(btShapeHull *self,int idx){
        return (self->getVertexPointer()[idx]);
    }
SWIGINTERN int btShapeHull_getIndex(btShapeHull *self,int idx){
        return self->getIndexPointer()[idx];
    }

#include <BulletCollision/CollisionShapes/btConvexHullShape.h>

SWIGINTERN btConvexHullShape *new_btConvexHullShape__SWIG_4(btShapeHull const *hull){
		btConvexHullShape *result = new btConvexHullShape(); 
		for (int i = 0; i < hull->numVertices(); i++) {
			result->addPoint(hull->getVertexPointer()[i]);
		}		
		return result;
	}

#include <BulletCollision/CollisionShapes/btTriangleIndexVertexMaterialArray.h>


#include <BulletCollision/CollisionShapes/btCylinderShape.h>


#include <BulletCollision/CollisionShapes/btTriangleMesh.h>


#include <BulletCollision/CollisionShapes/btConeShape.h>


#include <BulletCollision/CollisionShapes/btConvexTriangleMeshShape.h>


#include <BulletCollision/CollisionShapes/btEmptyShape.h>


#include <BulletCollision/CollisionShapes/btMultimaterialTriangleMeshShape.h>


#include <BulletCollision/CollisionShapes/btTetrahedronShape.h>


#include <BulletCollision/CollisionShapes/btUniformScalingShape.h>


#include <BulletCollision/CollisionShapes/btConvexPointCloudShape.h>


#include <BulletCollision/CollisionShapes/btConvex2dShape.h>


#include <BulletCollision/CollisionDispatch/btCollisionObject.h>
#include <gdx/collision/GdxCollisionObjectBridge.h>

SWIGINTERN void btCollisionObject_internalSetGdxBridge(btCollisionObject *self,GdxCollisionObjectBridge *bridge){
		self->setUserPointer(bridge);
	}
SWIGINTERN GdxCollisionObjectBridge *btCollisionObject_internalGetGdxBridge(btCollisionObject *self){
		return (GdxCollisionObjectBridge *)(self->getUserPointer());
	}
SWIGINTERN void btCollisionObject_getAnisotropicFriction__SWIG_1(btCollisionObject *self,btVector3 &out){
		out = self->getAnisotropicFriction();
	}
SWIGINTERN void btCollisionObject_getWorldTransform__SWIG_2(btCollisionObject *self,btTransform &out){
		out = self->getWorldTransform();
	}
SWIGINTERN void btCollisionObject_getInterpolationWorldTransform__SWIG_2(btCollisionObject *self,btTransform &out){
		out = self->getInterpolationWorldTransform();
	}
SWIGINTERN void btCollisionObject_getInterpolationLinearVelocity__SWIG_1(btCollisionObject *self,btVector3 &out){
		out = self->getInterpolationLinearVelocity();
	}
SWIGINTERN void btCollisionObject_getInterpolationAngularVelocity__SWIG_1(btCollisionObject *self,btVector3 &out){
		out = self->getInterpolationAngularVelocity();
	}

#include <BulletCollision/BroadphaseCollision/btDbvt.h>

SWIGINTERN btDbvtNode *btDbvtNode_getChild(btDbvtNode *self,int const &index){
		return self->childs[index];
	}
SWIGINTERN btDbvtNode *btDbvtNode_getChild0(btDbvtNode *self){
		return self->childs[0];
	}
SWIGINTERN btDbvtNode *btDbvtNode_getChild1(btDbvtNode *self){
		return self->childs[1];
	}
SWIGINTERN btBroadphaseProxy *btDbvtNode_getDataAsProxy(btDbvtNode *self){
	    return (btBroadphaseProxy*)self->data;
	}
SWIGINTERN btCollisionObject *btDbvtNode_getDataAsProxyClientObject(btDbvtNode *self){
	    return (self->isleaf()) ? (btCollisionObject*)((btBroadphaseProxy*)self->data)->m_clientObject : NULL;
	}
SWIGINTERN void btDbvt_collideKDOP__SWIG_1(btDbvtNode const *root,btScalar const *normals,btScalar const *offsets,int count,btDbvt::ICollide &policy){
		btDbvt::collideKDOP(root, (btVector3*)normals, offsets, count, policy);
	}
SWIGINTERN void btDbvt_collideOCL__SWIG_2(btDbvtNode const *root,btScalar const *normals,btScalar const *offsets,btVector3 const &sortaxis,int count,btDbvt::ICollide &policy,bool fullsort=true){
		btDbvt::collideOCL(root, (btVector3*)normals, offsets, sortaxis, count, policy, fullsort);
	}

#include <BulletCollision/BroadphaseCollision/btDbvtBroadphase.h>

SWIGINTERN btDbvt *btDbvtBroadphase_getSet(btDbvtBroadphase *self,int const &index){
		return &(self->m_sets[index]);
	}
SWIGINTERN btDbvt *btDbvtBroadphase_getSet0(btDbvtBroadphase *self){
		return &(self->m_sets[0]);
	}
SWIGINTERN btDbvt *btDbvtBroadphase_getSet1(btDbvtBroadphase *self){
		return &(self->m_sets[1]);
	}

#include <BulletCollision/CollisionShapes/btCompoundShape.h>


#include <BulletCollision/CollisionDispatch/btCollisionObjectWrapper.h>
#include <gdx/collision/CollisionObjectWrapper.h>


#include <BulletCollision/CollisionDispatch/btEmptyCollisionAlgorithm.h>


#include <BulletCollision/CollisionDispatch/btActivatingCollisionAlgorithm.h>


#include <BulletCollision/CollisionDispatch/btConvexConcaveCollisionAlgorithm.h>


#include <BulletCollision/CollisionDispatch/btConvexPlaneCollisionAlgorithm.h>



	/* Gets a global ref to the temp class.  Do not release this. */
	SWIGINTERN inline jclass gdx_getTempClassQuaternion(JNIEnv * jenv) {
	  static jclass cls = NULL;
	  if (cls == NULL) {
		cls = (jclass) jenv->NewGlobalRef(jenv->FindClass("com/badlogic/gdx/physics/bullet/linearmath/LinearMath"));
	  }
	  return cls;
	}
	
	SWIGINTERN inline jobject gdx_takePoolObjectQuaternion(JNIEnv * jenv, const char * poolName) {
	  jclass tempClass = gdx_getTempClassQuaternion(jenv);
	  
	  static jfieldID poolField = NULL;
	  if (poolField == NULL) {
		poolField = jenv->GetStaticFieldID(tempClass, poolName, "Lcom/badlogic/gdx/utils/Pool;");
	  }
	  
	  jobject poolObject = jenv->GetStaticObjectField(tempClass, poolField);
	  jclass poolClass = jenv->GetObjectClass(poolObject);
	  
	  static jmethodID obtainMethod = NULL;
	  if (obtainMethod == NULL) {
		obtainMethod = (jmethodID) jenv->GetMethodID(poolClass, "obtain", "()Ljava/lang/Object;");
	  }
	  
	  jobject ret = jenv->CallObjectMethod(poolObject, obtainMethod);
	
	  jenv->DeleteLocalRef(poolObject);
	  jenv->DeleteLocalRef(poolClass);
	
	  return ret;
	}
	
	SWIGINTERN inline void gdx_releasePoolObjectQuaternion(JNIEnv * jenv, const char * poolName, jobject obj) {
	  jclass tempClass = gdx_getTempClassQuaternion(jenv);
	  
	  static jfieldID poolField = NULL;
	  if (poolField == NULL) {
		poolField = jenv->GetStaticFieldID(tempClass, poolName, "Lcom/badlogic/gdx/utils/Pool;");
	  }
	  
	  jobject poolObject = jenv->GetStaticObjectField(tempClass, poolField);
	  jclass poolClass = jenv->GetObjectClass(poolObject);
	  
	  static jmethodID freeMethod = NULL;
	  if (freeMethod == NULL) {
		freeMethod = (jmethodID) jenv->GetMethodID(poolClass, "free", "(Ljava/lang/Object;)V");
	  }
	  
	  jenv->CallVoidMethod(poolObject, freeMethod, obj);
	  
	  jenv->DeleteLocalRef(poolObject);
	  jenv->DeleteLocalRef(poolClass);
	  jenv->DeleteLocalRef(obj);
	}
	
	/*
	 * A simple RAII wrapper to release jobjects we obtain from pools in 
	 * directorin typemaps.  SWIG doesn't have hooks to release them after
	 * they're used. 
	 */
	class gdxPoolAutoReleaseQuaternion {
	private:
	  JNIEnv * jenv;
	  const char * poolName;
	  jobject obj;
	public:
	  gdxPoolAutoReleaseQuaternion(JNIEnv * jenv, const char * poolName, jobject obj) : 
		jenv(jenv), poolName(poolName), obj(obj) { };
	  virtual ~gdxPoolAutoReleaseQuaternion() {
		gdx_releasePoolObjectQuaternion(this->jenv, this->poolName, this->obj);
	  };
	};


	
// Workaround for some strange swig behaviour


	/* Gets a global ref to the temp class's Return Quaternion.  Do not release this. */ 
	SWIGINTERN inline jobject gdx_getReturnQuaternion(JNIEnv * jenv) {
	  static jobject ret = NULL;
	  if (ret == NULL) {
	    jclass tempClass = gdx_getTempClassQuaternion(jenv);
	    jfieldID field = jenv->GetStaticFieldID(tempClass, "staticQuaternion", "Lcom/badlogic/gdx/math/Quaternion;");
	    ret = jenv->NewGlobalRef(jenv->GetStaticObjectField(tempClass, field));
	  }
	  return ret;
	}
	
	/* Sets the data in the Bullet type from the Gdx type. */
	SWIGINTERN inline void gdx_setbtQuaternionFromQuaternion(JNIEnv * jenv, btQuaternion & target, jobject source) {
		Quaternion_to_btQuaternion(jenv, target, source);
	}

	SWIGINTERN inline void gdx_setbtQuaternionFromQuaternion(JNIEnv * jenv, btQuaternion * target, jobject source) {
		gdx_setbtQuaternionFromQuaternion(jenv, *target, source);
	}

	/* Sets the data in the Gdx type from the Bullet type. */
	SWIGINTERN inline void gdx_setQuaternionFrombtQuaternion(JNIEnv * jenv, jobject target, const btQuaternion & source) {
		btQuaternion_to_Quaternion(jenv, target, source);
	}

	SWIGINTERN inline void gdx_setQuaternionFrombtQuaternion(JNIEnv * jenv, jobject target, const btQuaternion * source) {
		gdx_setQuaternionFrombtQuaternion(jenv, target, *source);
	}

	/*
	 * RAII wrapper to commit changes made to a local btQuaternion back to Quaternion
	 */
	class gdxAutoCommitQuaternion {
	private:
	  JNIEnv * jenv;
	  jobject jQuaternion;
	  btQuaternion & cbtQuaternion;
	public:
	  gdxAutoCommitQuaternion(JNIEnv * jenv, jobject jQuaternion, btQuaternion & cbtQuaternion) : 
	    jenv(jenv), jQuaternion(jQuaternion), cbtQuaternion(cbtQuaternion) { };
	  gdxAutoCommitQuaternion(JNIEnv * jenv, jobject jQuaternion, btQuaternion * cbtQuaternion) : 
	    jenv(jenv), jQuaternion(jQuaternion), cbtQuaternion(*cbtQuaternion) { };
	  virtual ~gdxAutoCommitQuaternion() {
	    gdx_setQuaternionFrombtQuaternion(this->jenv, this->jQuaternion, this->cbtQuaternion);
	  };
	};

	class gdxAutoCommitbtQuaternionAndReleaseQuaternion {
	private:
	  JNIEnv * jenv;
	  jobject jQuaternion;
	  btQuaternion & cbtQuaternion;
	  const char * poolName;
	public:
	  gdxAutoCommitbtQuaternionAndReleaseQuaternion(JNIEnv * jenv, jobject jQuaternion, btQuaternion & cbtQuaternion, const char *poolName) : 
	    jenv(jenv), jQuaternion(jQuaternion), cbtQuaternion(cbtQuaternion), poolName(poolName) { };
	  gdxAutoCommitbtQuaternionAndReleaseQuaternion(JNIEnv * jenv, jobject jQuaternion, btQuaternion * cbtQuaternion, const char *poolName) : 
	    jenv(jenv), jQuaternion(jQuaternion), cbtQuaternion(*cbtQuaternion), poolName(poolName) { };
	  virtual ~gdxAutoCommitbtQuaternionAndReleaseQuaternion() {
	    gdx_setbtQuaternionFromQuaternion(this->jenv, this->cbtQuaternion, this->jQuaternion);
	    gdx_releasePoolObjectQuaternion(this->jenv, this->poolName, this->jQuaternion);
	  };
	};


#include <BulletCollision/CollisionDispatch/btCompoundCompoundCollisionAlgorithm.h>


#include <BulletCollision/CollisionDispatch/btCollisionConfiguration.h>


#include <BulletCollision/CollisionDispatch/btDefaultCollisionConfiguration.h>


#include <BulletCollision/CollisionDispatch/btManifoldResult.h>


#include <BulletCollision/CollisionDispatch/btHashedSimplePairCache.h>


#include <BulletCollision/CollisionDispatch/btSphereSphereCollisionAlgorithm.h>


#include <BulletCollision/CollisionDispatch/btBoxBoxCollisionAlgorithm.h>


#include <BulletCollision/CollisionDispatch/btCollisionCreateFunc.h>


#include <BulletCollision/CollisionDispatch/btBox2dBox2dCollisionAlgorithm.h>


#include <BulletCollision/CollisionDispatch/btUnionFind.h>


#include <BulletCollision/CollisionDispatch/btSphereTriangleCollisionAlgorithm.h>


#include <BulletCollision/CollisionDispatch/btSimulationIslandManager.h>


#include <BulletCollision/CollisionDispatch/btGhostObject.h>


#include <BulletCollision/CollisionDispatch/btCollisionWorld.h>

SWIGINTERN void btCollisionWorld_ClosestRayResultCallback_getRayFromWorld(btCollisionWorld::ClosestRayResultCallback *self,btVector3 &out){
		out = self->m_rayFromWorld;
	}
SWIGINTERN void btCollisionWorld_ClosestRayResultCallback_setRayFromWorld(btCollisionWorld::ClosestRayResultCallback *self,btVector3 const &value){
		self->m_rayFromWorld = value;
	}
SWIGINTERN void btCollisionWorld_ClosestRayResultCallback_getRayToWorld(btCollisionWorld::ClosestRayResultCallback *self,btVector3 &out){
		out = self->m_rayToWorld;
	}
SWIGINTERN void btCollisionWorld_ClosestRayResultCallback_setRayToWorld(btCollisionWorld::ClosestRayResultCallback *self,btVector3 const &value){
		self->m_rayToWorld = value;
	}
SWIGINTERN void btCollisionWorld_ClosestRayResultCallback_getHitNormalWorld(btCollisionWorld::ClosestRayResultCallback *self,btVector3 &out){
		out = self->m_hitNormalWorld;
	}
SWIGINTERN void btCollisionWorld_ClosestRayResultCallback_setHitNormalWorld(btCollisionWorld::ClosestRayResultCallback *self,btVector3 const &value){
		self->m_hitNormalWorld = value;
	}
SWIGINTERN void btCollisionWorld_ClosestRayResultCallback_getHitPointWorld(btCollisionWorld::ClosestRayResultCallback *self,btVector3 &out){
		out = self->m_hitPointWorld;
	}
SWIGINTERN void btCollisionWorld_ClosestRayResultCallback_setHitPointWorld(btCollisionWorld::ClosestRayResultCallback *self,btVector3 const &value){
		self->m_hitPointWorld = value;
	}
SWIGINTERN void btCollisionWorld_AllHitsRayResultCallback_getRayFromWorld(btCollisionWorld::AllHitsRayResultCallback *self,btVector3 &out){
		out = self->m_rayFromWorld;
	}
SWIGINTERN void btCollisionWorld_AllHitsRayResultCallback_setRayFromWorld(btCollisionWorld::AllHitsRayResultCallback *self,btVector3 const &value){
		self->m_rayFromWorld = value;
	}
SWIGINTERN void btCollisionWorld_AllHitsRayResultCallback_getRayToWorld(btCollisionWorld::AllHitsRayResultCallback *self,btVector3 &out){
		out = self->m_rayToWorld;
	}
SWIGINTERN void btCollisionWorld_AllHitsRayResultCallback_setRayToWorld(btCollisionWorld::AllHitsRayResultCallback *self,btVector3 const &value){
		self->m_rayToWorld = value;
	}
SWIGINTERN void btCollisionWorld_LocalConvexResult_getHitNormalLocal(btCollisionWorld::LocalConvexResult *self,btVector3 &out){
		out = self->m_hitNormalLocal;
	}
SWIGINTERN void btCollisionWorld_LocalConvexResult_setHitNormalLocal(btCollisionWorld::LocalConvexResult *self,btVector3 const &value){
		self->m_hitNormalLocal = value;
	}
SWIGINTERN void btCollisionWorld_LocalConvexResult_getHitPointLocal(btCollisionWorld::LocalConvexResult *self,btVector3 &out){
		out = self->m_hitPointLocal;
	}
SWIGINTERN void btCollisionWorld_LocalConvexResult_setHitPointLocal(btCollisionWorld::LocalConvexResult *self,btVector3 const &value){
		self->m_hitPointLocal = value;
	}
SWIGINTERN void btCollisionWorld_ClosestConvexResultCallback_getConvexFromWorld(btCollisionWorld::ClosestConvexResultCallback *self,btVector3 &out){
		out = self->m_convexFromWorld;
	}
SWIGINTERN void btCollisionWorld_ClosestConvexResultCallback_setRayFromWorld(btCollisionWorld::ClosestConvexResultCallback *self,btVector3 const &value){
		self->m_convexFromWorld = value;
	}
SWIGINTERN void btCollisionWorld_ClosestConvexResultCallback_getConvexToWorld(btCollisionWorld::ClosestConvexResultCallback *self,btVector3 &out){
		out = self->m_convexToWorld;
	}
SWIGINTERN void btCollisionWorld_ClosestConvexResultCallback_setConvexToWorld(btCollisionWorld::ClosestConvexResultCallback *self,btVector3 const &value){
		self->m_convexToWorld = value;
	}
SWIGINTERN void btCollisionWorld_ClosestConvexResultCallback_getHitNormalWorld(btCollisionWorld::ClosestConvexResultCallback *self,btVector3 &out){
		out = self->m_hitNormalWorld;
	}
SWIGINTERN void btCollisionWorld_ClosestConvexResultCallback_setHitNormalWorld(btCollisionWorld::ClosestConvexResultCallback *self,btVector3 const &value){
		self->m_hitNormalWorld = value;
	}
SWIGINTERN void btCollisionWorld_ClosestConvexResultCallback_getHitPointWorld(btCollisionWorld::ClosestConvexResultCallback *self,btVector3 &out){
		out = self->m_hitPointWorld;
	}
SWIGINTERN void btCollisionWorld_ClosestConvexResultCallback_setHitPointWorld(btCollisionWorld::ClosestConvexResultCallback *self,btVector3 const &value){
		self->m_hitPointWorld = value;
	}

#include <gdx/collision/ClosestNotMeConvexResultCallback.h>


#include <gdx/collision/ClosestNotMeRayResultCallback.h>


#include <BulletCollision/CollisionDispatch/btConvex2dConvex2dAlgorithm.h>


#include <BulletCollision/CollisionDispatch/btBoxBoxDetector.h>


#include <BulletCollision/CollisionDispatch/btSphereBoxCollisionAlgorithm.h>


#include <BulletCollision/CollisionDispatch/btCollisionDispatcher.h>


#include <BulletCollision/CollisionDispatch/btConvexConvexAlgorithm.h>


#include <BulletCollision/CollisionDispatch/SphereTriangleDetector.h>


#include <BulletCollision/CollisionDispatch/btInternalEdgeUtility.h>


#include <BulletCollision/CollisionDispatch/btCompoundCollisionAlgorithm.h>


#include <BulletCollision/NarrowPhaseCollision/btConvexCast.h>


#include <BulletCollision/NarrowPhaseCollision/btSubSimplexConvexCast.h>


#include <BulletCollision/NarrowPhaseCollision/btPolyhedralContactClipping.h>


#include <BulletCollision/NarrowPhaseCollision/btPersistentManifold.h>


#include <BulletCollision/NarrowPhaseCollision/btGjkPairDetector.h>


#include <BulletCollision/NarrowPhaseCollision/btConvexPenetrationDepthSolver.h>


#include <BulletCollision/NarrowPhaseCollision/btMinkowskiPenetrationDepthSolver.h>


#include <BulletCollision/NarrowPhaseCollision/btGjkConvexCast.h>


#include <BulletCollision/NarrowPhaseCollision/btManifoldPoint.h>

SWIGINTERN int btManifoldPoint_getUserValue(btManifoldPoint *self){
		int result;
		*(const void **)&result = self->m_userPersistentData;
		return result;
	}
SWIGINTERN void btManifoldPoint_setUserValue(btManifoldPoint *self,int value){
		self->m_userPersistentData = (void*)value;
	}
SWIGINTERN void btManifoldPoint_getLocalPointA(btManifoldPoint *self,btVector3 &out){
		out = self->m_localPointA;
	}
SWIGINTERN void btManifoldPoint_setLocalPointA(btManifoldPoint *self,btVector3 const &value){
		self->m_localPointA = value;
	}
SWIGINTERN void btManifoldPoint_getLocalPointB(btManifoldPoint *self,btVector3 &out){
		out = self->m_localPointB;
	}
SWIGINTERN void btManifoldPoint_setLocalPointB(btManifoldPoint *self,btVector3 const &value){
		self->m_localPointB = value;
	}
SWIGINTERN void btManifoldPoint_getPositionWorldOnA(btManifoldPoint *self,btVector3 &out){
		out = self->m_positionWorldOnA;
	}
SWIGINTERN void btManifoldPoint_setPositionWorldOnA(btManifoldPoint *self,btVector3 const &value){
		self->m_positionWorldOnA = value;
	}
SWIGINTERN void btManifoldPoint_getPositionWorldOnB(btManifoldPoint *self,btVector3 &out){
		out = self->m_positionWorldOnB;
	}
SWIGINTERN void btManifoldPoint_setPositionWorldOnB(btManifoldPoint *self,btVector3 const &value){
		self->m_positionWorldOnB = value;
	}
SWIGINTERN void btManifoldPoint_getNormalWorldOnB(btManifoldPoint *self,btVector3 &out){
		out = self->m_normalWorldOnB;
	}
SWIGINTERN void btManifoldPoint_setNormalWorldOnB(btManifoldPoint *self,btVector3 const &value){
		self->m_normalWorldOnB = value;
	}
SWIGINTERN void btManifoldPoint_getLateralFrictionDir1(btManifoldPoint *self,btVector3 &out){
		out = self->m_lateralFrictionDir1;
	}
SWIGINTERN void btManifoldPoint_setLateralFrictionDir1(btManifoldPoint *self,btVector3 const &value){
		self->m_lateralFrictionDir1 = value;
	}
SWIGINTERN void btManifoldPoint_getLateralFrictionDir2(btManifoldPoint *self,btVector3 &out){
		out = self->m_lateralFrictionDir2;
	}
SWIGINTERN void btManifoldPoint_setLateralFrictionDir2(btManifoldPoint *self,btVector3 const &value){
		self->m_lateralFrictionDir2 = value;
	}

#include <BulletCollision/NarrowPhaseCollision/btContinuousConvexCollision.h>


#include <BulletCollision/NarrowPhaseCollision/btRaycastCallback.h>


#include <BulletCollision/NarrowPhaseCollision/btGjkEpa2.h>


#include <BulletCollision/NarrowPhaseCollision/btGjkEpaPenetrationDepthSolver.h>


#include <BulletCollision/NarrowPhaseCollision/btPointCollector.h>


#include <BulletCollision/NarrowPhaseCollision/btSimplexSolverInterface.h>


#include <BulletCollision/NarrowPhaseCollision/btVoronoiSimplexSolver.h>


#include <BulletCollision/CollisionShapes/btMultiSphereShape.h>


	btVector3* Vector3ArrayToBtVector3Array(JNIEnv * jenv, jobjectArray source) {
		static jfieldID xField = NULL, yField = NULL, zField = NULL;
		jint len = jenv->GetArrayLength(source);
		if (len <= 0)
			return NULL;
			
		btVector3* result = new btVector3[len];
			
		if (xField == NULL) {
			jobject vec = jenv->GetObjectArrayElement(source, 0);
			jclass sc = jenv->GetObjectClass(vec);
			xField = jenv->GetFieldID(sc, "x", "F");
			yField = jenv->GetFieldID(sc, "y", "F");
			zField = jenv->GetFieldID(sc, "z", "F");
			jenv->DeleteLocalRef(sc);
		}
		
		for (int i = 0; i < len; i++) {
			jobject vec = jenv->GetObjectArrayElement(source, i);
			result[i].setValue(jenv->GetFloatField(vec, xField), jenv->GetFloatField(vec, yField), jenv->GetFloatField(vec, zField));
		}
		return result;
	}
	
	class gdxAutoDeleteBtVector3Array {
	private:
	  btVector3* array;
	public:
	  gdxAutoDeleteBtVector3Array(btVector3* arr) : 
	    array(arr) { }
	  virtual ~gdxAutoDeleteBtVector3Array() {
		  if (array != NULL)
			  delete[] array;
	  }
	};


#include <gdx/collision/CustomCollisionDispatcher.h>


#include <gdx/collision/ContactListener.h>
bool custom_ContactListener_setEvents(ContactListener *listener);

SWIGINTERN bool ContactListener_setEvents(ContactListener *self){
		return custom_ContactListener_setEvents(self);
	}

#include <gdx/collision/ContactCache.h>

 /*SWIG_JavaArrayArgout##Bool(jenv, jarr$argnum, (bool *)$1, $input);*/ 
 /*SWIG_JavaArrayArgout##Schar(jenv, jarr$argnum, (signed char *)$1, $input);*/ 
 /*SWIG_JavaArrayArgout##Uchar(jenv, jarr$argnum, (unsigned char *)$1, $input);*/ 
 /*SWIG_JavaArrayArgout##Short(jenv, jarr$argnum, (short *)$1, $input);*/ 
 /*SWIG_JavaArrayArgout##Ushort(jenv, jarr$argnum, (unsigned short *)$1, $input);*/ 
 /*SWIG_JavaArrayArgout##Int(jenv, jarr$argnum, (int *)$1, $input);*/ 
 /*SWIG_JavaArrayArgout##Uint(jenv, jarr$argnum, (unsigned int *)$1, $input);*/ 
 /*SWIG_JavaArrayArgout##Long(jenv, jarr$argnum, (long *)$1, $input);*/ 
 /*SWIG_JavaArrayArgout##Ulong(jenv, jarr$argnum, (unsigned long *)$1, $input);*/ 
 /*SWIG_JavaArrayArgout##Longlong(jenv, jarr$argnum, (long long *)$1, $input);*/ 
 /*SWIG_JavaArrayArgout##Float(jenv, jarr$argnum, (float *)$1, $input);*/ 
 /*SWIG_JavaArrayArgout##Double(jenv, jarr$argnum, (double *)$1, $input);*/ 
SWIGINTERN btBroadphasePair *btAlignedObjectArray_Sl_btBroadphasePair_Sg__at(btAlignedObjectArray< btBroadphasePair > *self,int n){
		return &(self->at(n));
	}
SWIGINTERN int btAlignedObjectArray_Sl_btBroadphasePair_Sg__getCollisionObjects(btAlignedObjectArray< btBroadphasePair > *self,int result[],int max,int other){
		static btManifoldArray marr;
		const int n = self->size();
		int count = 0;
		int obj0, obj1;
		for (int i = 0; i < n; i++) {
			const btBroadphasePair& collisionPair = (*self)[i];
			if (collisionPair.m_algorithm) {
				marr.resize(0);
				collisionPair.m_algorithm->getAllContactManifolds(marr);
				const int s = marr.size();
				for (int j = 0; j < s; j++) {
					btPersistentManifold *manifold = marr[j];
					if (manifold->getNumContacts() > 0) {
						*(const btCollisionObject **)&obj0 = manifold->getBody0();
						*(const btCollisionObject **)&obj1 = manifold->getBody1();
						if (obj0 == other)
							result[count++] = obj1;
						else if (obj1 == other)
							result[count++] = obj0;
						else continue;
						if (count >= max)
							return count;
					}
				}
			}
		}
		return count;
	}
SWIGINTERN int btAlignedObjectArray_Sl_btBroadphasePair_Sg__getCollisionObjectsValue(btAlignedObjectArray< btBroadphasePair > *self,int result[],int max,int other){
		static btManifoldArray marr;
		const int n = self->size();
		int count = 0;
		int obj0, obj1;
		for (int i = 0; i < n; i++) {
			const btBroadphasePair& collisionPair = (*self)[i];
			if (collisionPair.m_algorithm) {
				marr.resize(0);
				collisionPair.m_algorithm->getAllContactManifolds(marr);
				const int s = marr.size();
				for (int j = 0; j < s; j++) {
					btPersistentManifold *manifold = marr[j];
					if (manifold->getNumContacts() > 0) {
						*(const btCollisionObject **)&obj0 = manifold->getBody0();
						*(const btCollisionObject **)&obj1 = manifold->getBody1();
						if (obj0 == other)
							result[count++] = ((GdxCollisionObjectBridge*)manifold->getBody1()->getUserPointer())->userValue;
						else if (obj1 == other)
							result[count++] = ((GdxCollisionObjectBridge*)manifold->getBody0()->getUserPointer())->userValue;
						else continue;
						if (count >= max)
							return count;
					}
				}
			}
		}
		return count;
	}

#include <BulletCollision/Gimpact/btQuantization.h>


#include <BulletCollision/Gimpact/btBoxCollision.h>



	/* Gets a global ref to the temp class.  Do not release this. */
	SWIGINTERN inline jclass gdx_getTempClassMatrix3(JNIEnv * jenv) {
	  static jclass cls = NULL;
	  if (cls == NULL) {
		cls = (jclass) jenv->NewGlobalRef(jenv->FindClass("com/badlogic/gdx/physics/bullet/linearmath/LinearMath"));
	  }
	  return cls;
	}
	
	SWIGINTERN inline jobject gdx_takePoolObjectMatrix3(JNIEnv * jenv, const char * poolName) {
	  jclass tempClass = gdx_getTempClassMatrix3(jenv);
	  
	  static jfieldID poolField = NULL;
	  if (poolField == NULL) {
		poolField = jenv->GetStaticFieldID(tempClass, poolName, "Lcom/badlogic/gdx/utils/Pool;");
	  }
	  
	  jobject poolObject = jenv->GetStaticObjectField(tempClass, poolField);
	  jclass poolClass = jenv->GetObjectClass(poolObject);
	  
	  static jmethodID obtainMethod = NULL;
	  if (obtainMethod == NULL) {
		obtainMethod = (jmethodID) jenv->GetMethodID(poolClass, "obtain", "()Ljava/lang/Object;");
	  }
	  
	  jobject ret = jenv->CallObjectMethod(poolObject, obtainMethod);
	
	  jenv->DeleteLocalRef(poolObject);
	  jenv->DeleteLocalRef(poolClass);
	
	  return ret;
	}
	
	SWIGINTERN inline void gdx_releasePoolObjectMatrix3(JNIEnv * jenv, const char * poolName, jobject obj) {
	  jclass tempClass = gdx_getTempClassMatrix3(jenv);
	  
	  static jfieldID poolField = NULL;
	  if (poolField == NULL) {
		poolField = jenv->GetStaticFieldID(tempClass, poolName, "Lcom/badlogic/gdx/utils/Pool;");
	  }
	  
	  jobject poolObject = jenv->GetStaticObjectField(tempClass, poolField);
	  jclass poolClass = jenv->GetObjectClass(poolObject);
	  
	  static jmethodID freeMethod = NULL;
	  if (freeMethod == NULL) {
		freeMethod = (jmethodID) jenv->GetMethodID(poolClass, "free", "(Ljava/lang/Object;)V");
	  }
	  
	  jenv->CallVoidMethod(poolObject, freeMethod, obj);
	  
	  jenv->DeleteLocalRef(poolObject);
	  jenv->DeleteLocalRef(poolClass);
	  jenv->DeleteLocalRef(obj);
	}
	
	/*
	 * A simple RAII wrapper to release jobjects we obtain from pools in 
	 * directorin typemaps.  SWIG doesn't have hooks to release them after
	 * they're used. 
	 */
	class gdxPoolAutoReleaseMatrix3 {
	private:
	  JNIEnv * jenv;
	  const char * poolName;
	  jobject obj;
	public:
	  gdxPoolAutoReleaseMatrix3(JNIEnv * jenv, const char * poolName, jobject obj) : 
		jenv(jenv), poolName(poolName), obj(obj) { };
	  virtual ~gdxPoolAutoReleaseMatrix3() {
		gdx_releasePoolObjectMatrix3(this->jenv, this->poolName, this->obj);
	  };
	};


	
// Workaround for some strange swig behaviour


	/* Gets a global ref to the temp class's Return Matrix3.  Do not release this. */ 
	SWIGINTERN inline jobject gdx_getReturnMatrix3(JNIEnv * jenv) {
	  static jobject ret = NULL;
	  if (ret == NULL) {
	    jclass tempClass = gdx_getTempClassMatrix3(jenv);
	    jfieldID field = jenv->GetStaticFieldID(tempClass, "staticMatrix3", "Lcom/badlogic/gdx/math/Matrix3;");
	    ret = jenv->NewGlobalRef(jenv->GetStaticObjectField(tempClass, field));
	  }
	  return ret;
	}
	
	/* Sets the data in the Bullet type from the Gdx type. */
	SWIGINTERN inline void gdx_setbtMatrix3x3FromMatrix3(JNIEnv * jenv, btMatrix3x3 & target, jobject source) {
		Matrix3_to_btMatrix3(jenv, target, source);
	}

	SWIGINTERN inline void gdx_setbtMatrix3x3FromMatrix3(JNIEnv * jenv, btMatrix3x3 * target, jobject source) {
		gdx_setbtMatrix3x3FromMatrix3(jenv, *target, source);
	}

	/* Sets the data in the Gdx type from the Bullet type. */
	SWIGINTERN inline void gdx_setMatrix3FrombtMatrix3x3(JNIEnv * jenv, jobject target, const btMatrix3x3 & source) {
		btMatrix3_to_Matrix3(jenv, target, source);
	}

	SWIGINTERN inline void gdx_setMatrix3FrombtMatrix3x3(JNIEnv * jenv, jobject target, const btMatrix3x3 * source) {
		gdx_setMatrix3FrombtMatrix3x3(jenv, target, *source);
	}

	/*
	 * RAII wrapper to commit changes made to a local btMatrix3x3 back to Matrix3
	 */
	class gdxAutoCommitMatrix3 {
	private:
	  JNIEnv * jenv;
	  jobject jMatrix3;
	  btMatrix3x3 & cbtMatrix3x3;
	public:
	  gdxAutoCommitMatrix3(JNIEnv * jenv, jobject jMatrix3, btMatrix3x3 & cbtMatrix3x3) : 
	    jenv(jenv), jMatrix3(jMatrix3), cbtMatrix3x3(cbtMatrix3x3) { };
	  gdxAutoCommitMatrix3(JNIEnv * jenv, jobject jMatrix3, btMatrix3x3 * cbtMatrix3x3) : 
	    jenv(jenv), jMatrix3(jMatrix3), cbtMatrix3x3(*cbtMatrix3x3) { };
	  virtual ~gdxAutoCommitMatrix3() {
	    gdx_setMatrix3FrombtMatrix3x3(this->jenv, this->jMatrix3, this->cbtMatrix3x3);
	  };
	};

	class gdxAutoCommitbtMatrix3x3AndReleaseMatrix3 {
	private:
	  JNIEnv * jenv;
	  jobject jMatrix3;
	  btMatrix3x3 & cbtMatrix3x3;
	  const char * poolName;
	public:
	  gdxAutoCommitbtMatrix3x3AndReleaseMatrix3(JNIEnv * jenv, jobject jMatrix3, btMatrix3x3 & cbtMatrix3x3, const char *poolName) : 
	    jenv(jenv), jMatrix3(jMatrix3), cbtMatrix3x3(cbtMatrix3x3), poolName(poolName) { };
	  gdxAutoCommitbtMatrix3x3AndReleaseMatrix3(JNIEnv * jenv, jobject jMatrix3, btMatrix3x3 * cbtMatrix3x3, const char *poolName) : 
	    jenv(jenv), jMatrix3(jMatrix3), cbtMatrix3x3(*cbtMatrix3x3), poolName(poolName) { };
	  virtual ~gdxAutoCommitbtMatrix3x3AndReleaseMatrix3() {
	    gdx_setbtMatrix3x3FromMatrix3(this->jenv, this->cbtMatrix3x3, this->jMatrix3);
	    gdx_releasePoolObjectMatrix3(this->jenv, this->poolName, this->jMatrix3);
	  };
	};


#include <BulletCollision/Gimpact/btClipPolygon.h>


#include <BulletCollision/Gimpact/btGeometryOperations.h>


#include <BulletCollision/Gimpact/btTriangleShapeEx.h>


#include <BulletCollision/Gimpact/btGImpactBvh.h>


#include <BulletCollision/Gimpact/btGImpactQuantizedBvh.h>


#include <BulletCollision/Gimpact/btGImpactShape.h>


#include <BulletCollision/Gimpact/btContactProcessing.h>


#include <BulletCollision/Gimpact/btGenericPoolAllocator.h>


#include <BulletCollision/Gimpact/btGImpactCollisionAlgorithm.h>


#include <BulletCollision/Gimpact/btGImpactMassUtil.h>


#include <BulletCollision/Gimpact/btGImpactMassUtil.h>



/* ---------------------------------------------------
 * C++ director class methods
 * --------------------------------------------------- */

#include "collision_wrap.h"

SwigDirector_btBroadphaseAabbCallback::SwigDirector_btBroadphaseAabbCallback(JNIEnv *jenv) : btBroadphaseAabbCallback(), Swig::Director(jenv) {
}

SwigDirector_btBroadphaseAabbCallback::~SwigDirector_btBroadphaseAabbCallback() {
  swig_disconnect_director_self("swigDirectorDisconnect");
}


bool SwigDirector_btBroadphaseAabbCallback::process(btBroadphaseProxy const *proxy) {
  bool c_result = SwigValueInit< bool >() ;
  jboolean jresult = 0 ;
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  jlong jproxy = 0 ;
  
  if (!swig_override[0]) {
    SWIG_JavaThrowException(JNIEnvWrapper(this).getJNIEnv(), SWIG_JavaDirectorPureVirtual, "Attempted to invoke pure virtual method btBroadphaseAabbCallback::process.");
    return c_result;
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    *((btBroadphaseProxy **)&jproxy) = (btBroadphaseProxy *) proxy; 
    jresult = (jboolean) jenv->CallStaticBooleanMethod(Swig::jclass_CollisionJNI, Swig::director_method_ids[0], swigjobj, jproxy);
    jthrowable swigerror = jenv->ExceptionOccurred();
    if (swigerror) {
      jenv->ExceptionClear();
      throw Swig::DirectorException(jenv, swigerror);
    }
    
    c_result = jresult ? true : false; 
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object in btBroadphaseAabbCallback::process ");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
  return c_result;
}

void SwigDirector_btBroadphaseAabbCallback::swig_connect_director(JNIEnv *jenv, jobject jself, jclass jcls, bool swig_mem_own, bool weak_global) {
  static struct {
    const char *mname;
    const char *mdesc;
    jmethodID base_methid;
  } methods[] = {
    {
      "process", "(Lcom/badlogic/gdx/physics/bullet/collision/btBroadphaseProxy;)Z", NULL 
    }
  };
  
  static jclass baseclass = 0 ;
  
  if (swig_set_self(jenv, jself, swig_mem_own, weak_global)) {
    if (!baseclass) {
      baseclass = jenv->FindClass("com/badlogic/gdx/physics/bullet/collision/btBroadphaseAabbCallback");
      if (!baseclass) return;
      baseclass = (jclass) jenv->NewGlobalRef(baseclass);
    }
    bool derived = (jenv->IsSameObject(baseclass, jcls) ? false : true);
    for (int i = 0; i < 1; ++i) {
      if (!methods[i].base_methid) {
        methods[i].base_methid = jenv->GetMethodID(baseclass, methods[i].mname, methods[i].mdesc);
        if (!methods[i].base_methid) return;
      }
      swig_override[i] = false;
      if (derived) {
        jmethodID methid = jenv->GetMethodID(jcls, methods[i].mname, methods[i].mdesc);
        swig_override[i] = (methid != methods[i].base_methid);
        jenv->ExceptionClear();
      }
    }
  }
}


SwigDirector_btBroadphaseRayCallback::SwigDirector_btBroadphaseRayCallback(JNIEnv *jenv) : btBroadphaseRayCallback(), Swig::Director(jenv) {
}

SwigDirector_btBroadphaseRayCallback::~SwigDirector_btBroadphaseRayCallback() {
  swig_disconnect_director_self("swigDirectorDisconnect");
}


bool SwigDirector_btBroadphaseRayCallback::process(btBroadphaseProxy const *proxy) {
  bool c_result = SwigValueInit< bool >() ;
  jboolean jresult = 0 ;
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  jlong jproxy = 0 ;
  
  if (!swig_override[0]) {
    SWIG_JavaThrowException(JNIEnvWrapper(this).getJNIEnv(), SWIG_JavaDirectorPureVirtual, "Attempted to invoke pure virtual method btBroadphaseRayCallback::process.");
    return c_result;
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    *((btBroadphaseProxy **)&jproxy) = (btBroadphaseProxy *) proxy; 
    jresult = (jboolean) jenv->CallStaticBooleanMethod(Swig::jclass_CollisionJNI, Swig::director_method_ids[1], swigjobj, jproxy);
    jthrowable swigerror = jenv->ExceptionOccurred();
    if (swigerror) {
      jenv->ExceptionClear();
      throw Swig::DirectorException(jenv, swigerror);
    }
    
    c_result = jresult ? true : false; 
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object in btBroadphaseRayCallback::process ");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
  return c_result;
}

void SwigDirector_btBroadphaseRayCallback::swig_connect_director(JNIEnv *jenv, jobject jself, jclass jcls, bool swig_mem_own, bool weak_global) {
  static struct {
    const char *mname;
    const char *mdesc;
    jmethodID base_methid;
  } methods[] = {
    {
      "process", "(Lcom/badlogic/gdx/physics/bullet/collision/btBroadphaseProxy;)Z", NULL 
    }
  };
  
  static jclass baseclass = 0 ;
  
  if (swig_set_self(jenv, jself, swig_mem_own, weak_global)) {
    if (!baseclass) {
      baseclass = jenv->FindClass("com/badlogic/gdx/physics/bullet/collision/btBroadphaseRayCallback");
      if (!baseclass) return;
      baseclass = (jclass) jenv->NewGlobalRef(baseclass);
    }
    bool derived = (jenv->IsSameObject(baseclass, jcls) ? false : true);
    for (int i = 0; i < 1; ++i) {
      if (!methods[i].base_methid) {
        methods[i].base_methid = jenv->GetMethodID(baseclass, methods[i].mname, methods[i].mdesc);
        if (!methods[i].base_methid) return;
      }
      swig_override[i] = false;
      if (derived) {
        jmethodID methid = jenv->GetMethodID(jcls, methods[i].mname, methods[i].mdesc);
        swig_override[i] = (methid != methods[i].base_methid);
        jenv->ExceptionClear();
      }
    }
  }
}


SwigDirector_btNodeOverlapCallback::SwigDirector_btNodeOverlapCallback(JNIEnv *jenv) : btNodeOverlapCallback(), Swig::Director(jenv) {
}

SwigDirector_btNodeOverlapCallback::~SwigDirector_btNodeOverlapCallback() {
  swig_disconnect_director_self("swigDirectorDisconnect");
}


void SwigDirector_btNodeOverlapCallback::processNode(int subPart, int triangleIndex) {
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  jint jsubPart  ;
  jint jtriangleIndex  ;
  
  if (!swig_override[0]) {
    SWIG_JavaThrowException(JNIEnvWrapper(this).getJNIEnv(), SWIG_JavaDirectorPureVirtual, "Attempted to invoke pure virtual method btNodeOverlapCallback::processNode.");
    return;
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    jsubPart = (jint) subPart;
    jtriangleIndex = (jint) triangleIndex;
    jenv->CallStaticVoidMethod(Swig::jclass_CollisionJNI, Swig::director_method_ids[2], swigjobj, jsubPart, jtriangleIndex);
    jthrowable swigerror = jenv->ExceptionOccurred();
    if (swigerror) {
      jenv->ExceptionClear();
      throw Swig::DirectorException(jenv, swigerror);
    }
    
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object in btNodeOverlapCallback::processNode ");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
}

void SwigDirector_btNodeOverlapCallback::swig_connect_director(JNIEnv *jenv, jobject jself, jclass jcls, bool swig_mem_own, bool weak_global) {
  static struct {
    const char *mname;
    const char *mdesc;
    jmethodID base_methid;
  } methods[] = {
    {
      "processNode", "(II)V", NULL 
    }
  };
  
  static jclass baseclass = 0 ;
  
  if (swig_set_self(jenv, jself, swig_mem_own, weak_global)) {
    if (!baseclass) {
      baseclass = jenv->FindClass("com/badlogic/gdx/physics/bullet/collision/btNodeOverlapCallback");
      if (!baseclass) return;
      baseclass = (jclass) jenv->NewGlobalRef(baseclass);
    }
    bool derived = (jenv->IsSameObject(baseclass, jcls) ? false : true);
    for (int i = 0; i < 1; ++i) {
      if (!methods[i].base_methid) {
        methods[i].base_methid = jenv->GetMethodID(baseclass, methods[i].mname, methods[i].mdesc);
        if (!methods[i].base_methid) return;
      }
      swig_override[i] = false;
      if (derived) {
        jmethodID methid = jenv->GetMethodID(jcls, methods[i].mname, methods[i].mdesc);
        swig_override[i] = (methid != methods[i].base_methid);
        jenv->ExceptionClear();
      }
    }
  }
}


SwigDirector_btOverlappingPairCallback::SwigDirector_btOverlappingPairCallback(JNIEnv *jenv) : btOverlappingPairCallback(), Swig::Director(jenv) {
}

SwigDirector_btOverlappingPairCallback::~SwigDirector_btOverlappingPairCallback() {
  swig_disconnect_director_self("swigDirectorDisconnect");
}


btBroadphasePair *SwigDirector_btOverlappingPairCallback::addOverlappingPair(btBroadphaseProxy *proxy0, btBroadphaseProxy *proxy1) {
  btBroadphasePair *c_result = 0 ;
  jlong jresult = 0 ;
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  jlong jproxy0 = 0 ;
  jlong jproxy1 = 0 ;
  
  if (!swig_override[0]) {
    SWIG_JavaThrowException(JNIEnvWrapper(this).getJNIEnv(), SWIG_JavaDirectorPureVirtual, "Attempted to invoke pure virtual method btOverlappingPairCallback::addOverlappingPair.");
    return c_result;
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    *((btBroadphaseProxy **)&jproxy0) = (btBroadphaseProxy *) proxy0; 
    *((btBroadphaseProxy **)&jproxy1) = (btBroadphaseProxy *) proxy1; 
    jresult = (jlong) jenv->CallStaticLongMethod(Swig::jclass_CollisionJNI, Swig::director_method_ids[3], swigjobj, jproxy0, jproxy1);
    jthrowable swigerror = jenv->ExceptionOccurred();
    if (swigerror) {
      jenv->ExceptionClear();
      throw Swig::DirectorException(jenv, swigerror);
    }
    
    c_result = *(btBroadphasePair **)&jresult; 
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object in btOverlappingPairCallback::addOverlappingPair ");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
  return c_result;
}

void *SwigDirector_btOverlappingPairCallback::removeOverlappingPair(btBroadphaseProxy *proxy0, btBroadphaseProxy *proxy1, btDispatcher *dispatcher) {
  void *c_result = 0 ;
  jlong jresult = 0 ;
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  jlong jproxy0 = 0 ;
  jlong jproxy1 = 0 ;
  jlong jdispatcher = 0 ;
  
  if (!swig_override[1]) {
    SWIG_JavaThrowException(JNIEnvWrapper(this).getJNIEnv(), SWIG_JavaDirectorPureVirtual, "Attempted to invoke pure virtual method btOverlappingPairCallback::removeOverlappingPair.");
    return c_result;
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    *((btBroadphaseProxy **)&jproxy0) = (btBroadphaseProxy *) proxy0; 
    *((btBroadphaseProxy **)&jproxy1) = (btBroadphaseProxy *) proxy1; 
    *((btDispatcher **)&jdispatcher) = (btDispatcher *) dispatcher; 
    jresult = (jlong) jenv->CallStaticLongMethod(Swig::jclass_CollisionJNI, Swig::director_method_ids[4], swigjobj, jproxy0, jproxy1, jdispatcher);
    jthrowable swigerror = jenv->ExceptionOccurred();
    if (swigerror) {
      jenv->ExceptionClear();
      throw Swig::DirectorException(jenv, swigerror);
    }
    
    c_result = (void *)jresult; 
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object in btOverlappingPairCallback::removeOverlappingPair ");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
  return c_result;
}

void SwigDirector_btOverlappingPairCallback::removeOverlappingPairsContainingProxy(btBroadphaseProxy *proxy0, btDispatcher *dispatcher) {
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  jlong jproxy0 = 0 ;
  jlong jdispatcher = 0 ;
  
  if (!swig_override[2]) {
    SWIG_JavaThrowException(JNIEnvWrapper(this).getJNIEnv(), SWIG_JavaDirectorPureVirtual, "Attempted to invoke pure virtual method btOverlappingPairCallback::removeOverlappingPairsContainingProxy.");
    return;
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    *((btBroadphaseProxy **)&jproxy0) = (btBroadphaseProxy *) proxy0; 
    *((btDispatcher **)&jdispatcher) = (btDispatcher *) dispatcher; 
    jenv->CallStaticVoidMethod(Swig::jclass_CollisionJNI, Swig::director_method_ids[5], swigjobj, jproxy0, jdispatcher);
    jthrowable swigerror = jenv->ExceptionOccurred();
    if (swigerror) {
      jenv->ExceptionClear();
      throw Swig::DirectorException(jenv, swigerror);
    }
    
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object in btOverlappingPairCallback::removeOverlappingPairsContainingProxy ");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
}

void SwigDirector_btOverlappingPairCallback::swig_connect_director(JNIEnv *jenv, jobject jself, jclass jcls, bool swig_mem_own, bool weak_global) {
  static struct {
    const char *mname;
    const char *mdesc;
    jmethodID base_methid;
  } methods[] = {
    {
      "addOverlappingPair", "(Lcom/badlogic/gdx/physics/bullet/collision/btBroadphaseProxy;Lcom/badlogic/gdx/physics/bullet/collision/btBroadphaseProxy;)Lcom/badlogic/gdx/physics/bullet/collision/btBroadphasePair;", NULL 
    },
    {
      "removeOverlappingPair", "(Lcom/badlogic/gdx/physics/bullet/collision/btBroadphaseProxy;Lcom/badlogic/gdx/physics/bullet/collision/btBroadphaseProxy;Lcom/badlogic/gdx/physics/bullet/collision/btDispatcher;)J", NULL 
    },
    {
      "removeOverlappingPairsContainingProxy", "(Lcom/badlogic/gdx/physics/bullet/collision/btBroadphaseProxy;Lcom/badlogic/gdx/physics/bullet/collision/btDispatcher;)V", NULL 
    }
  };
  
  static jclass baseclass = 0 ;
  
  if (swig_set_self(jenv, jself, swig_mem_own, weak_global)) {
    if (!baseclass) {
      baseclass = jenv->FindClass("com/badlogic/gdx/physics/bullet/collision/btOverlappingPairCallback");
      if (!baseclass) return;
      baseclass = (jclass) jenv->NewGlobalRef(baseclass);
    }
    bool derived = (jenv->IsSameObject(baseclass, jcls) ? false : true);
    for (int i = 0; i < 3; ++i) {
      if (!methods[i].base_methid) {
        methods[i].base_methid = jenv->GetMethodID(baseclass, methods[i].mname, methods[i].mdesc);
        if (!methods[i].base_methid) return;
      }
      swig_override[i] = false;
      if (derived) {
        jmethodID methid = jenv->GetMethodID(jcls, methods[i].mname, methods[i].mdesc);
        swig_override[i] = (methid != methods[i].base_methid);
        jenv->ExceptionClear();
      }
    }
  }
}


SwigDirector_btOverlapCallback::SwigDirector_btOverlapCallback(JNIEnv *jenv) : btOverlapCallback(), Swig::Director(jenv) {
}

SwigDirector_btOverlapCallback::~SwigDirector_btOverlapCallback() {
  swig_disconnect_director_self("swigDirectorDisconnect");
}


bool SwigDirector_btOverlapCallback::processOverlap(btBroadphasePair &pair) {
  bool c_result = SwigValueInit< bool >() ;
  jboolean jresult = 0 ;
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  jobject jpair = 0 ;
  
  if (!swig_override[0]) {
    SWIG_JavaThrowException(JNIEnvWrapper(this).getJNIEnv(), SWIG_JavaDirectorPureVirtual, "Attempted to invoke pure virtual method btOverlapCallback::processOverlap.");
    return c_result;
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    jclass jcpair = gdx_getClassbtBroadphasePair(jenv);
    jpair = gdx_obtainbtBroadphasePair(jenv, jcpair, (void*)&pair, false);
    gdxAutoFreebtBroadphasePair autoRelease_jpair(jenv, jcpair, jpair);
    jresult = (jboolean) jenv->CallStaticBooleanMethod(Swig::jclass_CollisionJNI, Swig::director_method_ids[6], swigjobj, jpair);
    jthrowable swigerror = jenv->ExceptionOccurred();
    if (swigerror) {
      jenv->ExceptionClear();
      throw Swig::DirectorException(jenv, swigerror);
    }
    
    c_result = jresult ? true : false; 
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object in btOverlapCallback::processOverlap ");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
  return c_result;
}

void SwigDirector_btOverlapCallback::swig_connect_director(JNIEnv *jenv, jobject jself, jclass jcls, bool swig_mem_own, bool weak_global) {
  static struct {
    const char *mname;
    const char *mdesc;
    jmethodID base_methid;
  } methods[] = {
    {
      "processOverlap", "(Lcom/badlogic/gdx/physics/bullet/collision/btBroadphasePair;)Z", NULL 
    }
  };
  
  static jclass baseclass = 0 ;
  
  if (swig_set_self(jenv, jself, swig_mem_own, weak_global)) {
    if (!baseclass) {
      baseclass = jenv->FindClass("com/badlogic/gdx/physics/bullet/collision/btOverlapCallback");
      if (!baseclass) return;
      baseclass = (jclass) jenv->NewGlobalRef(baseclass);
    }
    bool derived = (jenv->IsSameObject(baseclass, jcls) ? false : true);
    for (int i = 0; i < 1; ++i) {
      if (!methods[i].base_methid) {
        methods[i].base_methid = jenv->GetMethodID(baseclass, methods[i].mname, methods[i].mdesc);
        if (!methods[i].base_methid) return;
      }
      swig_override[i] = false;
      if (derived) {
        jmethodID methid = jenv->GetMethodID(jcls, methods[i].mname, methods[i].mdesc);
        swig_override[i] = (methid != methods[i].base_methid);
        jenv->ExceptionClear();
      }
    }
  }
}


SwigDirector_btOverlapFilterCallback::SwigDirector_btOverlapFilterCallback(JNIEnv *jenv) : btOverlapFilterCallback(), Swig::Director(jenv) {
}

SwigDirector_btOverlapFilterCallback::~SwigDirector_btOverlapFilterCallback() {
  swig_disconnect_director_self("swigDirectorDisconnect");
}


bool SwigDirector_btOverlapFilterCallback::needBroadphaseCollision(btBroadphaseProxy *proxy0, btBroadphaseProxy *proxy1) const {
  bool c_result = SwigValueInit< bool >() ;
  jboolean jresult = 0 ;
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  jlong jproxy0 = 0 ;
  jlong jproxy1 = 0 ;
  
  if (!swig_override[0]) {
    SWIG_JavaThrowException(JNIEnvWrapper(this).getJNIEnv(), SWIG_JavaDirectorPureVirtual, "Attempted to invoke pure virtual method btOverlapFilterCallback::needBroadphaseCollision.");
    return c_result;
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    *((btBroadphaseProxy **)&jproxy0) = (btBroadphaseProxy *) proxy0; 
    *((btBroadphaseProxy **)&jproxy1) = (btBroadphaseProxy *) proxy1; 
    jresult = (jboolean) jenv->CallStaticBooleanMethod(Swig::jclass_CollisionJNI, Swig::director_method_ids[7], swigjobj, jproxy0, jproxy1);
    jthrowable swigerror = jenv->ExceptionOccurred();
    if (swigerror) {
      jenv->ExceptionClear();
      throw Swig::DirectorException(jenv, swigerror);
    }
    
    c_result = jresult ? true : false; 
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object in btOverlapFilterCallback::needBroadphaseCollision ");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
  return c_result;
}

void SwigDirector_btOverlapFilterCallback::swig_connect_director(JNIEnv *jenv, jobject jself, jclass jcls, bool swig_mem_own, bool weak_global) {
  static struct {
    const char *mname;
    const char *mdesc;
    jmethodID base_methid;
  } methods[] = {
    {
      "needBroadphaseCollision", "(Lcom/badlogic/gdx/physics/bullet/collision/btBroadphaseProxy;Lcom/badlogic/gdx/physics/bullet/collision/btBroadphaseProxy;)Z", NULL 
    }
  };
  
  static jclass baseclass = 0 ;
  
  if (swig_set_self(jenv, jself, swig_mem_own, weak_global)) {
    if (!baseclass) {
      baseclass = jenv->FindClass("com/badlogic/gdx/physics/bullet/collision/btOverlapFilterCallback");
      if (!baseclass) return;
      baseclass = (jclass) jenv->NewGlobalRef(baseclass);
    }
    bool derived = (jenv->IsSameObject(baseclass, jcls) ? false : true);
    for (int i = 0; i < 1; ++i) {
      if (!methods[i].base_methid) {
        methods[i].base_methid = jenv->GetMethodID(baseclass, methods[i].mname, methods[i].mdesc);
        if (!methods[i].base_methid) return;
      }
      swig_override[i] = false;
      if (derived) {
        jmethodID methid = jenv->GetMethodID(jcls, methods[i].mname, methods[i].mdesc);
        swig_override[i] = (methid != methods[i].base_methid);
        jenv->ExceptionClear();
      }
    }
  }
}


SwigDirector_btTriangleCallback::SwigDirector_btTriangleCallback(JNIEnv *jenv) : btTriangleCallback(), Swig::Director(jenv) {
}

SwigDirector_btTriangleCallback::~SwigDirector_btTriangleCallback() {
  swig_disconnect_director_self("swigDirectorDisconnect");
}


void SwigDirector_btTriangleCallback::processTriangle(btVector3 *triangle, int partId, int triangleIndex) {
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  jlong jtriangle = 0 ;
  jint jpartId  ;
  jint jtriangleIndex  ;
  
  if (!swig_override[0]) {
    SWIG_JavaThrowException(JNIEnvWrapper(this).getJNIEnv(), SWIG_JavaDirectorPureVirtual, "Attempted to invoke pure virtual method btTriangleCallback::processTriangle.");
    return;
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    *((btVector3 **)&jtriangle) = (btVector3 *) triangle; 
    jpartId = (jint) partId;
    jtriangleIndex = (jint) triangleIndex;
    jenv->CallStaticVoidMethod(Swig::jclass_CollisionJNI, Swig::director_method_ids[8], swigjobj, jtriangle, jpartId, jtriangleIndex);
    jthrowable swigerror = jenv->ExceptionOccurred();
    if (swigerror) {
      jenv->ExceptionClear();
      throw Swig::DirectorException(jenv, swigerror);
    }
    
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object in btTriangleCallback::processTriangle ");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
}

void SwigDirector_btTriangleCallback::swig_connect_director(JNIEnv *jenv, jobject jself, jclass jcls, bool swig_mem_own, bool weak_global) {
  static struct {
    const char *mname;
    const char *mdesc;
    jmethodID base_methid;
  } methods[] = {
    {
      "processTriangle", "(Lcom/badlogic/gdx/physics/bullet/linearmath/btVector3;II)V", NULL 
    }
  };
  
  static jclass baseclass = 0 ;
  
  if (swig_set_self(jenv, jself, swig_mem_own, weak_global)) {
    if (!baseclass) {
      baseclass = jenv->FindClass("com/badlogic/gdx/physics/bullet/collision/btTriangleCallback");
      if (!baseclass) return;
      baseclass = (jclass) jenv->NewGlobalRef(baseclass);
    }
    bool derived = (jenv->IsSameObject(baseclass, jcls) ? false : true);
    for (int i = 0; i < 1; ++i) {
      if (!methods[i].base_methid) {
        methods[i].base_methid = jenv->GetMethodID(baseclass, methods[i].mname, methods[i].mdesc);
        if (!methods[i].base_methid) return;
      }
      swig_override[i] = false;
      if (derived) {
        jmethodID methid = jenv->GetMethodID(jcls, methods[i].mname, methods[i].mdesc);
        swig_override[i] = (methid != methods[i].base_methid);
        jenv->ExceptionClear();
      }
    }
  }
}


SwigDirector_btInternalTriangleIndexCallback::SwigDirector_btInternalTriangleIndexCallback(JNIEnv *jenv) : btInternalTriangleIndexCallback(), Swig::Director(jenv) {
}

SwigDirector_btInternalTriangleIndexCallback::~SwigDirector_btInternalTriangleIndexCallback() {
  swig_disconnect_director_self("swigDirectorDisconnect");
}


void SwigDirector_btInternalTriangleIndexCallback::internalProcessTriangleIndex(btVector3 *triangle, int partId, int triangleIndex) {
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  jlong jtriangle = 0 ;
  jint jpartId  ;
  jint jtriangleIndex  ;
  
  if (!swig_override[0]) {
    SWIG_JavaThrowException(JNIEnvWrapper(this).getJNIEnv(), SWIG_JavaDirectorPureVirtual, "Attempted to invoke pure virtual method btInternalTriangleIndexCallback::internalProcessTriangleIndex.");
    return;
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    *((btVector3 **)&jtriangle) = (btVector3 *) triangle; 
    jpartId = (jint) partId;
    jtriangleIndex = (jint) triangleIndex;
    jenv->CallStaticVoidMethod(Swig::jclass_CollisionJNI, Swig::director_method_ids[9], swigjobj, jtriangle, jpartId, jtriangleIndex);
    jthrowable swigerror = jenv->ExceptionOccurred();
    if (swigerror) {
      jenv->ExceptionClear();
      throw Swig::DirectorException(jenv, swigerror);
    }
    
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object in btInternalTriangleIndexCallback::internalProcessTriangleIndex ");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
}

void SwigDirector_btInternalTriangleIndexCallback::swig_connect_director(JNIEnv *jenv, jobject jself, jclass jcls, bool swig_mem_own, bool weak_global) {
  static struct {
    const char *mname;
    const char *mdesc;
    jmethodID base_methid;
  } methods[] = {
    {
      "internalProcessTriangleIndex", "(Lcom/badlogic/gdx/physics/bullet/linearmath/btVector3;II)V", NULL 
    }
  };
  
  static jclass baseclass = 0 ;
  
  if (swig_set_self(jenv, jself, swig_mem_own, weak_global)) {
    if (!baseclass) {
      baseclass = jenv->FindClass("com/badlogic/gdx/physics/bullet/collision/btInternalTriangleIndexCallback");
      if (!baseclass) return;
      baseclass = (jclass) jenv->NewGlobalRef(baseclass);
    }
    bool derived = (jenv->IsSameObject(baseclass, jcls) ? false : true);
    for (int i = 0; i < 1; ++i) {
      if (!methods[i].base_methid) {
        methods[i].base_methid = jenv->GetMethodID(baseclass, methods[i].mname, methods[i].mdesc);
        if (!methods[i].base_methid) return;
      }
      swig_override[i] = false;
      if (derived) {
        jmethodID methid = jenv->GetMethodID(jcls, methods[i].mname, methods[i].mdesc);
        swig_override[i] = (methid != methods[i].base_methid);
        jenv->ExceptionClear();
      }
    }
  }
}


SwigDirector_ICollide::SwigDirector_ICollide(JNIEnv *jenv) : btDbvt::ICollide(), Swig::Director(jenv) {
}

SwigDirector_ICollide::~SwigDirector_ICollide() {
  swig_disconnect_director_self("swigDirectorDisconnect");
}


void SwigDirector_ICollide::Process(btDbvtNode const *arg0, btDbvtNode const *arg1) {
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  jlong jarg0 = 0 ;
  jlong jarg1 = 0 ;
  
  if (!swig_override[0]) {
    btDbvt::ICollide::Process(arg0,arg1);
    return;
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    *((btDbvtNode **)&jarg0) = (btDbvtNode *) arg0; 
    *((btDbvtNode **)&jarg1) = (btDbvtNode *) arg1; 
    jenv->CallStaticVoidMethod(Swig::jclass_CollisionJNI, Swig::director_method_ids[10], swigjobj, jarg0, jarg1);
    jthrowable swigerror = jenv->ExceptionOccurred();
    if (swigerror) {
      jenv->ExceptionClear();
      throw Swig::DirectorException(jenv, swigerror);
    }
    
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object in btDbvt::ICollide::Process ");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
}

void SwigDirector_ICollide::Process(btDbvtNode const *arg0) {
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  jlong jarg0 = 0 ;
  
  if (!swig_override[1]) {
    btDbvt::ICollide::Process(arg0);
    return;
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    *((btDbvtNode **)&jarg0) = (btDbvtNode *) arg0; 
    jenv->CallStaticVoidMethod(Swig::jclass_CollisionJNI, Swig::director_method_ids[11], swigjobj, jarg0);
    jthrowable swigerror = jenv->ExceptionOccurred();
    if (swigerror) {
      jenv->ExceptionClear();
      throw Swig::DirectorException(jenv, swigerror);
    }
    
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object in btDbvt::ICollide::Process ");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
}

void SwigDirector_ICollide::Process(btDbvtNode const *n, btScalar arg1) {
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  jlong jn = 0 ;
  jfloat jarg1  ;
  
  if (!swig_override[2]) {
    btDbvt::ICollide::Process(n,arg1);
    return;
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    *((btDbvtNode **)&jn) = (btDbvtNode *) n; 
    jarg1 = (jfloat) arg1;
    jenv->CallStaticVoidMethod(Swig::jclass_CollisionJNI, Swig::director_method_ids[12], swigjobj, jn, jarg1);
    jthrowable swigerror = jenv->ExceptionOccurred();
    if (swigerror) {
      jenv->ExceptionClear();
      throw Swig::DirectorException(jenv, swigerror);
    }
    
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object in btDbvt::ICollide::Process ");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
}

bool SwigDirector_ICollide::Descent(btDbvtNode const *arg0) {
  bool c_result = SwigValueInit< bool >() ;
  jboolean jresult = 0 ;
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  jlong jarg0 = 0 ;
  
  if (!swig_override[3]) {
    return btDbvt::ICollide::Descent(arg0);
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    *((btDbvtNode **)&jarg0) = (btDbvtNode *) arg0; 
    jresult = (jboolean) jenv->CallStaticBooleanMethod(Swig::jclass_CollisionJNI, Swig::director_method_ids[13], swigjobj, jarg0);
    jthrowable swigerror = jenv->ExceptionOccurred();
    if (swigerror) {
      jenv->ExceptionClear();
      throw Swig::DirectorException(jenv, swigerror);
    }
    
    c_result = jresult ? true : false; 
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object in btDbvt::ICollide::Descent ");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
  return c_result;
}

bool SwigDirector_ICollide::AllLeaves(btDbvtNode const *arg0) {
  bool c_result = SwigValueInit< bool >() ;
  jboolean jresult = 0 ;
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  jlong jarg0 = 0 ;
  
  if (!swig_override[4]) {
    return btDbvt::ICollide::AllLeaves(arg0);
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    *((btDbvtNode **)&jarg0) = (btDbvtNode *) arg0; 
    jresult = (jboolean) jenv->CallStaticBooleanMethod(Swig::jclass_CollisionJNI, Swig::director_method_ids[14], swigjobj, jarg0);
    jthrowable swigerror = jenv->ExceptionOccurred();
    if (swigerror) {
      jenv->ExceptionClear();
      throw Swig::DirectorException(jenv, swigerror);
    }
    
    c_result = jresult ? true : false; 
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object in btDbvt::ICollide::AllLeaves ");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
  return c_result;
}

void SwigDirector_ICollide::swig_connect_director(JNIEnv *jenv, jobject jself, jclass jcls, bool swig_mem_own, bool weak_global) {
  static struct {
    const char *mname;
    const char *mdesc;
    jmethodID base_methid;
  } methods[] = {
    {
      "Process", "(Lcom/badlogic/gdx/physics/bullet/collision/btDbvtNode;Lcom/badlogic/gdx/physics/bullet/collision/btDbvtNode;)V", NULL 
    },
    {
      "Process", "(Lcom/badlogic/gdx/physics/bullet/collision/btDbvtNode;)V", NULL 
    },
    {
      "Process", "(Lcom/badlogic/gdx/physics/bullet/collision/btDbvtNode;F)V", NULL 
    },
    {
      "Descent", "(Lcom/badlogic/gdx/physics/bullet/collision/btDbvtNode;)Z", NULL 
    },
    {
      "AllLeaves", "(Lcom/badlogic/gdx/physics/bullet/collision/btDbvtNode;)Z", NULL 
    }
  };
  
  static jclass baseclass = 0 ;
  
  if (swig_set_self(jenv, jself, swig_mem_own, weak_global)) {
    if (!baseclass) {
      baseclass = jenv->FindClass("com/badlogic/gdx/physics/bullet/collision/ICollide");
      if (!baseclass) return;
      baseclass = (jclass) jenv->NewGlobalRef(baseclass);
    }
    bool derived = (jenv->IsSameObject(baseclass, jcls) ? false : true);
    for (int i = 0; i < 5; ++i) {
      if (!methods[i].base_methid) {
        methods[i].base_methid = jenv->GetMethodID(baseclass, methods[i].mname, methods[i].mdesc);
        if (!methods[i].base_methid) return;
      }
      swig_override[i] = false;
      if (derived) {
        jmethodID methid = jenv->GetMethodID(jcls, methods[i].mname, methods[i].mdesc);
        swig_override[i] = (methid != methods[i].base_methid);
        jenv->ExceptionClear();
      }
    }
  }
}


SwigDirector_btConvexTriangleCallback::SwigDirector_btConvexTriangleCallback(JNIEnv *jenv, btDispatcher *dispatcher, btCollisionObjectWrapper const *body0Wrap, btCollisionObjectWrapper const *body1Wrap, bool isSwapped) : btConvexTriangleCallback(dispatcher, body0Wrap, body1Wrap, isSwapped), Swig::Director(jenv) {
}

SwigDirector_btConvexTriangleCallback::~SwigDirector_btConvexTriangleCallback() {
  swig_disconnect_director_self("swigDirectorDisconnect");
}


void SwigDirector_btConvexTriangleCallback::processTriangle(btVector3 *triangle, int partId, int triangleIndex) {
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  jlong jtriangle = 0 ;
  jint jpartId  ;
  jint jtriangleIndex  ;
  
  if (!swig_override[0]) {
    btConvexTriangleCallback::processTriangle(triangle,partId,triangleIndex);
    return;
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    *((btVector3 **)&jtriangle) = (btVector3 *) triangle; 
    jpartId = (jint) partId;
    jtriangleIndex = (jint) triangleIndex;
    jenv->CallStaticVoidMethod(Swig::jclass_CollisionJNI, Swig::director_method_ids[15], swigjobj, jtriangle, jpartId, jtriangleIndex);
    jthrowable swigerror = jenv->ExceptionOccurred();
    if (swigerror) {
      jenv->ExceptionClear();
      throw Swig::DirectorException(jenv, swigerror);
    }
    
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object in btConvexTriangleCallback::processTriangle ");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
}

void SwigDirector_btConvexTriangleCallback::swig_connect_director(JNIEnv *jenv, jobject jself, jclass jcls, bool swig_mem_own, bool weak_global) {
  static struct {
    const char *mname;
    const char *mdesc;
    jmethodID base_methid;
  } methods[] = {
    {
      "processTriangle", "(Lcom/badlogic/gdx/physics/bullet/linearmath/btVector3;II)V", NULL 
    }
  };
  
  static jclass baseclass = 0 ;
  
  if (swig_set_self(jenv, jself, swig_mem_own, weak_global)) {
    if (!baseclass) {
      baseclass = jenv->FindClass("com/badlogic/gdx/physics/bullet/collision/btConvexTriangleCallback");
      if (!baseclass) return;
      baseclass = (jclass) jenv->NewGlobalRef(baseclass);
    }
    bool derived = (jenv->IsSameObject(baseclass, jcls) ? false : true);
    for (int i = 0; i < 1; ++i) {
      if (!methods[i].base_methid) {
        methods[i].base_methid = jenv->GetMethodID(baseclass, methods[i].mname, methods[i].mdesc);
        if (!methods[i].base_methid) return;
      }
      swig_override[i] = false;
      if (derived) {
        jmethodID methid = jenv->GetMethodID(jcls, methods[i].mname, methods[i].mdesc);
        swig_override[i] = (methid != methods[i].base_methid);
        jenv->ExceptionClear();
      }
    }
  }
}


SwigDirector_btGhostPairCallback::SwigDirector_btGhostPairCallback(JNIEnv *jenv) : btGhostPairCallback(), Swig::Director(jenv) {
}

SwigDirector_btGhostPairCallback::~SwigDirector_btGhostPairCallback() {
  swig_disconnect_director_self("swigDirectorDisconnect");
}


btBroadphasePair *SwigDirector_btGhostPairCallback::addOverlappingPair(btBroadphaseProxy *proxy0, btBroadphaseProxy *proxy1) {
  btBroadphasePair *c_result = 0 ;
  jlong jresult = 0 ;
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  jlong jproxy0 = 0 ;
  jlong jproxy1 = 0 ;
  
  if (!swig_override[0]) {
    return btGhostPairCallback::addOverlappingPair(proxy0,proxy1);
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    *((btBroadphaseProxy **)&jproxy0) = (btBroadphaseProxy *) proxy0; 
    *((btBroadphaseProxy **)&jproxy1) = (btBroadphaseProxy *) proxy1; 
    jresult = (jlong) jenv->CallStaticLongMethod(Swig::jclass_CollisionJNI, Swig::director_method_ids[16], swigjobj, jproxy0, jproxy1);
    jthrowable swigerror = jenv->ExceptionOccurred();
    if (swigerror) {
      jenv->ExceptionClear();
      throw Swig::DirectorException(jenv, swigerror);
    }
    
    c_result = *(btBroadphasePair **)&jresult; 
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object in btGhostPairCallback::addOverlappingPair ");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
  return c_result;
}

void *SwigDirector_btGhostPairCallback::removeOverlappingPair(btBroadphaseProxy *proxy0, btBroadphaseProxy *proxy1, btDispatcher *dispatcher) {
  void *c_result = 0 ;
  jlong jresult = 0 ;
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  jlong jproxy0 = 0 ;
  jlong jproxy1 = 0 ;
  jlong jdispatcher = 0 ;
  
  if (!swig_override[1]) {
    return btGhostPairCallback::removeOverlappingPair(proxy0,proxy1,dispatcher);
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    *((btBroadphaseProxy **)&jproxy0) = (btBroadphaseProxy *) proxy0; 
    *((btBroadphaseProxy **)&jproxy1) = (btBroadphaseProxy *) proxy1; 
    *((btDispatcher **)&jdispatcher) = (btDispatcher *) dispatcher; 
    jresult = (jlong) jenv->CallStaticLongMethod(Swig::jclass_CollisionJNI, Swig::director_method_ids[17], swigjobj, jproxy0, jproxy1, jdispatcher);
    jthrowable swigerror = jenv->ExceptionOccurred();
    if (swigerror) {
      jenv->ExceptionClear();
      throw Swig::DirectorException(jenv, swigerror);
    }
    
    c_result = (void *)jresult; 
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object in btGhostPairCallback::removeOverlappingPair ");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
  return c_result;
}

void SwigDirector_btGhostPairCallback::removeOverlappingPairsContainingProxy(btBroadphaseProxy *arg0, btDispatcher *arg1) {
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  jlong jarg0 = 0 ;
  jlong jarg1 = 0 ;
  
  if (!swig_override[2]) {
    btGhostPairCallback::removeOverlappingPairsContainingProxy(arg0,arg1);
    return;
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    *((btBroadphaseProxy **)&jarg0) = (btBroadphaseProxy *) arg0; 
    *((btDispatcher **)&jarg1) = (btDispatcher *) arg1; 
    jenv->CallStaticVoidMethod(Swig::jclass_CollisionJNI, Swig::director_method_ids[18], swigjobj, jarg0, jarg1);
    jthrowable swigerror = jenv->ExceptionOccurred();
    if (swigerror) {
      jenv->ExceptionClear();
      throw Swig::DirectorException(jenv, swigerror);
    }
    
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object in btGhostPairCallback::removeOverlappingPairsContainingProxy ");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
}

void SwigDirector_btGhostPairCallback::swig_connect_director(JNIEnv *jenv, jobject jself, jclass jcls, bool swig_mem_own, bool weak_global) {
  static struct {
    const char *mname;
    const char *mdesc;
    jmethodID base_methid;
  } methods[] = {
    {
      "addOverlappingPair", "(Lcom/badlogic/gdx/physics/bullet/collision/btBroadphaseProxy;Lcom/badlogic/gdx/physics/bullet/collision/btBroadphaseProxy;)Lcom/badlogic/gdx/physics/bullet/collision/btBroadphasePair;", NULL 
    },
    {
      "removeOverlappingPair", "(Lcom/badlogic/gdx/physics/bullet/collision/btBroadphaseProxy;Lcom/badlogic/gdx/physics/bullet/collision/btBroadphaseProxy;Lcom/badlogic/gdx/physics/bullet/collision/btDispatcher;)J", NULL 
    },
    {
      "removeOverlappingPairsContainingProxy", "(Lcom/badlogic/gdx/physics/bullet/collision/btBroadphaseProxy;Lcom/badlogic/gdx/physics/bullet/collision/btDispatcher;)V", NULL 
    }
  };
  
  static jclass baseclass = 0 ;
  
  if (swig_set_self(jenv, jself, swig_mem_own, weak_global)) {
    if (!baseclass) {
      baseclass = jenv->FindClass("com/badlogic/gdx/physics/bullet/collision/btGhostPairCallback");
      if (!baseclass) return;
      baseclass = (jclass) jenv->NewGlobalRef(baseclass);
    }
    bool derived = (jenv->IsSameObject(baseclass, jcls) ? false : true);
    for (int i = 0; i < 3; ++i) {
      if (!methods[i].base_methid) {
        methods[i].base_methid = jenv->GetMethodID(baseclass, methods[i].mname, methods[i].mdesc);
        if (!methods[i].base_methid) return;
      }
      swig_override[i] = false;
      if (derived) {
        jmethodID methid = jenv->GetMethodID(jcls, methods[i].mname, methods[i].mdesc);
        swig_override[i] = (methid != methods[i].base_methid);
        jenv->ExceptionClear();
      }
    }
  }
}


SwigDirector_RayResultCallback::SwigDirector_RayResultCallback(JNIEnv *jenv) : btCollisionWorld::RayResultCallback(), Swig::Director(jenv) {
}

SwigDirector_RayResultCallback::~SwigDirector_RayResultCallback() {
  swig_disconnect_director_self("swigDirectorDisconnect");
}


bool SwigDirector_RayResultCallback::needsCollision(btBroadphaseProxy *proxy0) const {
  bool c_result = SwigValueInit< bool >() ;
  jboolean jresult = 0 ;
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  jlong jproxy0 = 0 ;
  
  if (!swig_override[0]) {
    return btCollisionWorld::RayResultCallback::needsCollision(proxy0);
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    *((btBroadphaseProxy **)&jproxy0) = (btBroadphaseProxy *) proxy0; 
    jresult = (jboolean) jenv->CallStaticBooleanMethod(Swig::jclass_CollisionJNI, Swig::director_method_ids[19], swigjobj, jproxy0);
    jthrowable swigerror = jenv->ExceptionOccurred();
    if (swigerror) {
      jenv->ExceptionClear();
      throw Swig::DirectorException(jenv, swigerror);
    }
    
    c_result = jresult ? true : false; 
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object in btCollisionWorld::RayResultCallback::needsCollision ");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
  return c_result;
}

btScalar SwigDirector_RayResultCallback::addSingleResult(btCollisionWorld::LocalRayResult &rayResult, bool normalInWorldSpace) {
  btScalar c_result = SwigValueInit< btScalar >() ;
  jfloat jresult = 0 ;
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  jlong jrayResult = 0 ;
  jboolean jnormalInWorldSpace  ;
  
  if (!swig_override[1]) {
    SWIG_JavaThrowException(JNIEnvWrapper(this).getJNIEnv(), SWIG_JavaDirectorPureVirtual, "Attempted to invoke pure virtual method btCollisionWorld::RayResultCallback::addSingleResult.");
    return c_result;
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    *(btCollisionWorld::LocalRayResult **)&jrayResult = (btCollisionWorld::LocalRayResult *) &rayResult; 
    jnormalInWorldSpace = (jboolean) normalInWorldSpace;
    jresult = (jfloat) jenv->CallStaticFloatMethod(Swig::jclass_CollisionJNI, Swig::director_method_ids[20], swigjobj, jrayResult, jnormalInWorldSpace);
    jthrowable swigerror = jenv->ExceptionOccurred();
    if (swigerror) {
      jenv->ExceptionClear();
      throw Swig::DirectorException(jenv, swigerror);
    }
    
    c_result = (btScalar)jresult; 
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object in btCollisionWorld::RayResultCallback::addSingleResult ");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
  return c_result;
}

void SwigDirector_RayResultCallback::swig_connect_director(JNIEnv *jenv, jobject jself, jclass jcls, bool swig_mem_own, bool weak_global) {
  static struct {
    const char *mname;
    const char *mdesc;
    jmethodID base_methid;
  } methods[] = {
    {
      "needsCollision", "(Lcom/badlogic/gdx/physics/bullet/collision/btBroadphaseProxy;)Z", NULL 
    },
    {
      "addSingleResult", "(Lcom/badlogic/gdx/physics/bullet/collision/LocalRayResult;Z)F", NULL 
    }
  };
  
  static jclass baseclass = 0 ;
  
  if (swig_set_self(jenv, jself, swig_mem_own, weak_global)) {
    if (!baseclass) {
      baseclass = jenv->FindClass("com/badlogic/gdx/physics/bullet/collision/RayResultCallback");
      if (!baseclass) return;
      baseclass = (jclass) jenv->NewGlobalRef(baseclass);
    }
    bool derived = (jenv->IsSameObject(baseclass, jcls) ? false : true);
    for (int i = 0; i < 2; ++i) {
      if (!methods[i].base_methid) {
        methods[i].base_methid = jenv->GetMethodID(baseclass, methods[i].mname, methods[i].mdesc);
        if (!methods[i].base_methid) return;
      }
      swig_override[i] = false;
      if (derived) {
        jmethodID methid = jenv->GetMethodID(jcls, methods[i].mname, methods[i].mdesc);
        swig_override[i] = (methid != methods[i].base_methid);
        jenv->ExceptionClear();
      }
    }
  }
}


SwigDirector_ClosestRayResultCallback::SwigDirector_ClosestRayResultCallback(JNIEnv *jenv, btVector3 const &rayFromWorld, btVector3 const &rayToWorld) : btCollisionWorld::ClosestRayResultCallback(rayFromWorld, rayToWorld), Swig::Director(jenv) {
}

SwigDirector_ClosestRayResultCallback::~SwigDirector_ClosestRayResultCallback() {
  swig_disconnect_director_self("swigDirectorDisconnect");
}


bool SwigDirector_ClosestRayResultCallback::needsCollision(btBroadphaseProxy *proxy0) const {
  bool c_result = SwigValueInit< bool >() ;
  jboolean jresult = 0 ;
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  jlong jproxy0 = 0 ;
  
  if (!swig_override[0]) {
    return btCollisionWorld::RayResultCallback::needsCollision(proxy0);
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    *((btBroadphaseProxy **)&jproxy0) = (btBroadphaseProxy *) proxy0; 
    jresult = (jboolean) jenv->CallStaticBooleanMethod(Swig::jclass_CollisionJNI, Swig::director_method_ids[21], swigjobj, jproxy0);
    jthrowable swigerror = jenv->ExceptionOccurred();
    if (swigerror) {
      jenv->ExceptionClear();
      throw Swig::DirectorException(jenv, swigerror);
    }
    
    c_result = jresult ? true : false; 
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object in btCollisionWorld::ClosestRayResultCallback::needsCollision ");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
  return c_result;
}

btScalar SwigDirector_ClosestRayResultCallback::addSingleResult(btCollisionWorld::LocalRayResult &rayResult, bool normalInWorldSpace) {
  btScalar c_result = SwigValueInit< btScalar >() ;
  jfloat jresult = 0 ;
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  jlong jrayResult = 0 ;
  jboolean jnormalInWorldSpace  ;
  
  if (!swig_override[1]) {
    return btCollisionWorld::ClosestRayResultCallback::addSingleResult(rayResult,normalInWorldSpace);
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    *(btCollisionWorld::LocalRayResult **)&jrayResult = (btCollisionWorld::LocalRayResult *) &rayResult; 
    jnormalInWorldSpace = (jboolean) normalInWorldSpace;
    jresult = (jfloat) jenv->CallStaticFloatMethod(Swig::jclass_CollisionJNI, Swig::director_method_ids[22], swigjobj, jrayResult, jnormalInWorldSpace);
    jthrowable swigerror = jenv->ExceptionOccurred();
    if (swigerror) {
      jenv->ExceptionClear();
      throw Swig::DirectorException(jenv, swigerror);
    }
    
    c_result = (btScalar)jresult; 
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object in btCollisionWorld::ClosestRayResultCallback::addSingleResult ");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
  return c_result;
}

void SwigDirector_ClosestRayResultCallback::swig_connect_director(JNIEnv *jenv, jobject jself, jclass jcls, bool swig_mem_own, bool weak_global) {
  static struct {
    const char *mname;
    const char *mdesc;
    jmethodID base_methid;
  } methods[] = {
    {
      "needsCollision", "(Lcom/badlogic/gdx/physics/bullet/collision/btBroadphaseProxy;)Z", NULL 
    },
    {
      "addSingleResult", "(Lcom/badlogic/gdx/physics/bullet/collision/LocalRayResult;Z)F", NULL 
    }
  };
  
  static jclass baseclass = 0 ;
  
  if (swig_set_self(jenv, jself, swig_mem_own, weak_global)) {
    if (!baseclass) {
      baseclass = jenv->FindClass("com/badlogic/gdx/physics/bullet/collision/ClosestRayResultCallback");
      if (!baseclass) return;
      baseclass = (jclass) jenv->NewGlobalRef(baseclass);
    }
    bool derived = (jenv->IsSameObject(baseclass, jcls) ? false : true);
    for (int i = 0; i < 2; ++i) {
      if (!methods[i].base_methid) {
        methods[i].base_methid = jenv->GetMethodID(baseclass, methods[i].mname, methods[i].mdesc);
        if (!methods[i].base_methid) return;
      }
      swig_override[i] = false;
      if (derived) {
        jmethodID methid = jenv->GetMethodID(jcls, methods[i].mname, methods[i].mdesc);
        swig_override[i] = (methid != methods[i].base_methid);
        jenv->ExceptionClear();
      }
    }
  }
}


SwigDirector_AllHitsRayResultCallback::SwigDirector_AllHitsRayResultCallback(JNIEnv *jenv, btVector3 const &rayFromWorld, btVector3 const &rayToWorld) : btCollisionWorld::AllHitsRayResultCallback(rayFromWorld, rayToWorld), Swig::Director(jenv) {
}

SwigDirector_AllHitsRayResultCallback::~SwigDirector_AllHitsRayResultCallback() {
  swig_disconnect_director_self("swigDirectorDisconnect");
}


bool SwigDirector_AllHitsRayResultCallback::needsCollision(btBroadphaseProxy *proxy0) const {
  bool c_result = SwigValueInit< bool >() ;
  jboolean jresult = 0 ;
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  jlong jproxy0 = 0 ;
  
  if (!swig_override[0]) {
    return btCollisionWorld::RayResultCallback::needsCollision(proxy0);
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    *((btBroadphaseProxy **)&jproxy0) = (btBroadphaseProxy *) proxy0; 
    jresult = (jboolean) jenv->CallStaticBooleanMethod(Swig::jclass_CollisionJNI, Swig::director_method_ids[23], swigjobj, jproxy0);
    jthrowable swigerror = jenv->ExceptionOccurred();
    if (swigerror) {
      jenv->ExceptionClear();
      throw Swig::DirectorException(jenv, swigerror);
    }
    
    c_result = jresult ? true : false; 
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object in btCollisionWorld::AllHitsRayResultCallback::needsCollision ");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
  return c_result;
}

btScalar SwigDirector_AllHitsRayResultCallback::addSingleResult(btCollisionWorld::LocalRayResult &rayResult, bool normalInWorldSpace) {
  btScalar c_result = SwigValueInit< btScalar >() ;
  jfloat jresult = 0 ;
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  jlong jrayResult = 0 ;
  jboolean jnormalInWorldSpace  ;
  
  if (!swig_override[1]) {
    return btCollisionWorld::AllHitsRayResultCallback::addSingleResult(rayResult,normalInWorldSpace);
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    *(btCollisionWorld::LocalRayResult **)&jrayResult = (btCollisionWorld::LocalRayResult *) &rayResult; 
    jnormalInWorldSpace = (jboolean) normalInWorldSpace;
    jresult = (jfloat) jenv->CallStaticFloatMethod(Swig::jclass_CollisionJNI, Swig::director_method_ids[24], swigjobj, jrayResult, jnormalInWorldSpace);
    jthrowable swigerror = jenv->ExceptionOccurred();
    if (swigerror) {
      jenv->ExceptionClear();
      throw Swig::DirectorException(jenv, swigerror);
    }
    
    c_result = (btScalar)jresult; 
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object in btCollisionWorld::AllHitsRayResultCallback::addSingleResult ");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
  return c_result;
}

void SwigDirector_AllHitsRayResultCallback::swig_connect_director(JNIEnv *jenv, jobject jself, jclass jcls, bool swig_mem_own, bool weak_global) {
  static struct {
    const char *mname;
    const char *mdesc;
    jmethodID base_methid;
  } methods[] = {
    {
      "needsCollision", "(Lcom/badlogic/gdx/physics/bullet/collision/btBroadphaseProxy;)Z", NULL 
    },
    {
      "addSingleResult", "(Lcom/badlogic/gdx/physics/bullet/collision/LocalRayResult;Z)F", NULL 
    }
  };
  
  static jclass baseclass = 0 ;
  
  if (swig_set_self(jenv, jself, swig_mem_own, weak_global)) {
    if (!baseclass) {
      baseclass = jenv->FindClass("com/badlogic/gdx/physics/bullet/collision/AllHitsRayResultCallback");
      if (!baseclass) return;
      baseclass = (jclass) jenv->NewGlobalRef(baseclass);
    }
    bool derived = (jenv->IsSameObject(baseclass, jcls) ? false : true);
    for (int i = 0; i < 2; ++i) {
      if (!methods[i].base_methid) {
        methods[i].base_methid = jenv->GetMethodID(baseclass, methods[i].mname, methods[i].mdesc);
        if (!methods[i].base_methid) return;
      }
      swig_override[i] = false;
      if (derived) {
        jmethodID methid = jenv->GetMethodID(jcls, methods[i].mname, methods[i].mdesc);
        swig_override[i] = (methid != methods[i].base_methid);
        jenv->ExceptionClear();
      }
    }
  }
}


SwigDirector_ConvexResultCallback::SwigDirector_ConvexResultCallback(JNIEnv *jenv) : btCollisionWorld::ConvexResultCallback(), Swig::Director(jenv) {
}

SwigDirector_ConvexResultCallback::~SwigDirector_ConvexResultCallback() {
  swig_disconnect_director_self("swigDirectorDisconnect");
}


bool SwigDirector_ConvexResultCallback::needsCollision(btBroadphaseProxy *proxy0) const {
  bool c_result = SwigValueInit< bool >() ;
  jboolean jresult = 0 ;
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  jlong jproxy0 = 0 ;
  
  if (!swig_override[0]) {
    return btCollisionWorld::ConvexResultCallback::needsCollision(proxy0);
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    *((btBroadphaseProxy **)&jproxy0) = (btBroadphaseProxy *) proxy0; 
    jresult = (jboolean) jenv->CallStaticBooleanMethod(Swig::jclass_CollisionJNI, Swig::director_method_ids[25], swigjobj, jproxy0);
    jthrowable swigerror = jenv->ExceptionOccurred();
    if (swigerror) {
      jenv->ExceptionClear();
      throw Swig::DirectorException(jenv, swigerror);
    }
    
    c_result = jresult ? true : false; 
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object in btCollisionWorld::ConvexResultCallback::needsCollision ");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
  return c_result;
}

btScalar SwigDirector_ConvexResultCallback::addSingleResult(btCollisionWorld::LocalConvexResult &convexResult, bool normalInWorldSpace) {
  btScalar c_result = SwigValueInit< btScalar >() ;
  jfloat jresult = 0 ;
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  jlong jconvexResult = 0 ;
  jboolean jnormalInWorldSpace  ;
  
  if (!swig_override[1]) {
    SWIG_JavaThrowException(JNIEnvWrapper(this).getJNIEnv(), SWIG_JavaDirectorPureVirtual, "Attempted to invoke pure virtual method btCollisionWorld::ConvexResultCallback::addSingleResult.");
    return c_result;
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    *(btCollisionWorld::LocalConvexResult **)&jconvexResult = (btCollisionWorld::LocalConvexResult *) &convexResult; 
    jnormalInWorldSpace = (jboolean) normalInWorldSpace;
    jresult = (jfloat) jenv->CallStaticFloatMethod(Swig::jclass_CollisionJNI, Swig::director_method_ids[26], swigjobj, jconvexResult, jnormalInWorldSpace);
    jthrowable swigerror = jenv->ExceptionOccurred();
    if (swigerror) {
      jenv->ExceptionClear();
      throw Swig::DirectorException(jenv, swigerror);
    }
    
    c_result = (btScalar)jresult; 
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object in btCollisionWorld::ConvexResultCallback::addSingleResult ");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
  return c_result;
}

void SwigDirector_ConvexResultCallback::swig_connect_director(JNIEnv *jenv, jobject jself, jclass jcls, bool swig_mem_own, bool weak_global) {
  static struct {
    const char *mname;
    const char *mdesc;
    jmethodID base_methid;
  } methods[] = {
    {
      "needsCollision", "(Lcom/badlogic/gdx/physics/bullet/collision/btBroadphaseProxy;)Z", NULL 
    },
    {
      "addSingleResult", "(Lcom/badlogic/gdx/physics/bullet/collision/LocalConvexResult;Z)F", NULL 
    }
  };
  
  static jclass baseclass = 0 ;
  
  if (swig_set_self(jenv, jself, swig_mem_own, weak_global)) {
    if (!baseclass) {
      baseclass = jenv->FindClass("com/badlogic/gdx/physics/bullet/collision/ConvexResultCallback");
      if (!baseclass) return;
      baseclass = (jclass) jenv->NewGlobalRef(baseclass);
    }
    bool derived = (jenv->IsSameObject(baseclass, jcls) ? false : true);
    for (int i = 0; i < 2; ++i) {
      if (!methods[i].base_methid) {
        methods[i].base_methid = jenv->GetMethodID(baseclass, methods[i].mname, methods[i].mdesc);
        if (!methods[i].base_methid) return;
      }
      swig_override[i] = false;
      if (derived) {
        jmethodID methid = jenv->GetMethodID(jcls, methods[i].mname, methods[i].mdesc);
        swig_override[i] = (methid != methods[i].base_methid);
        jenv->ExceptionClear();
      }
    }
  }
}


SwigDirector_ClosestConvexResultCallback::SwigDirector_ClosestConvexResultCallback(JNIEnv *jenv, btVector3 const &convexFromWorld, btVector3 const &convexToWorld) : btCollisionWorld::ClosestConvexResultCallback(convexFromWorld, convexToWorld), Swig::Director(jenv) {
}

SwigDirector_ClosestConvexResultCallback::~SwigDirector_ClosestConvexResultCallback() {
  swig_disconnect_director_self("swigDirectorDisconnect");
}


bool SwigDirector_ClosestConvexResultCallback::needsCollision(btBroadphaseProxy *proxy0) const {
  bool c_result = SwigValueInit< bool >() ;
  jboolean jresult = 0 ;
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  jlong jproxy0 = 0 ;
  
  if (!swig_override[0]) {
    return btCollisionWorld::ConvexResultCallback::needsCollision(proxy0);
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    *((btBroadphaseProxy **)&jproxy0) = (btBroadphaseProxy *) proxy0; 
    jresult = (jboolean) jenv->CallStaticBooleanMethod(Swig::jclass_CollisionJNI, Swig::director_method_ids[27], swigjobj, jproxy0);
    jthrowable swigerror = jenv->ExceptionOccurred();
    if (swigerror) {
      jenv->ExceptionClear();
      throw Swig::DirectorException(jenv, swigerror);
    }
    
    c_result = jresult ? true : false; 
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object in btCollisionWorld::ClosestConvexResultCallback::needsCollision ");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
  return c_result;
}

btScalar SwigDirector_ClosestConvexResultCallback::addSingleResult(btCollisionWorld::LocalConvexResult &convexResult, bool normalInWorldSpace) {
  btScalar c_result = SwigValueInit< btScalar >() ;
  jfloat jresult = 0 ;
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  jlong jconvexResult = 0 ;
  jboolean jnormalInWorldSpace  ;
  
  if (!swig_override[1]) {
    return btCollisionWorld::ClosestConvexResultCallback::addSingleResult(convexResult,normalInWorldSpace);
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    *(btCollisionWorld::LocalConvexResult **)&jconvexResult = (btCollisionWorld::LocalConvexResult *) &convexResult; 
    jnormalInWorldSpace = (jboolean) normalInWorldSpace;
    jresult = (jfloat) jenv->CallStaticFloatMethod(Swig::jclass_CollisionJNI, Swig::director_method_ids[28], swigjobj, jconvexResult, jnormalInWorldSpace);
    jthrowable swigerror = jenv->ExceptionOccurred();
    if (swigerror) {
      jenv->ExceptionClear();
      throw Swig::DirectorException(jenv, swigerror);
    }
    
    c_result = (btScalar)jresult; 
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object in btCollisionWorld::ClosestConvexResultCallback::addSingleResult ");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
  return c_result;
}

void SwigDirector_ClosestConvexResultCallback::swig_connect_director(JNIEnv *jenv, jobject jself, jclass jcls, bool swig_mem_own, bool weak_global) {
  static struct {
    const char *mname;
    const char *mdesc;
    jmethodID base_methid;
  } methods[] = {
    {
      "needsCollision", "(Lcom/badlogic/gdx/physics/bullet/collision/btBroadphaseProxy;)Z", NULL 
    },
    {
      "addSingleResult", "(Lcom/badlogic/gdx/physics/bullet/collision/LocalConvexResult;Z)F", NULL 
    }
  };
  
  static jclass baseclass = 0 ;
  
  if (swig_set_self(jenv, jself, swig_mem_own, weak_global)) {
    if (!baseclass) {
      baseclass = jenv->FindClass("com/badlogic/gdx/physics/bullet/collision/ClosestConvexResultCallback");
      if (!baseclass) return;
      baseclass = (jclass) jenv->NewGlobalRef(baseclass);
    }
    bool derived = (jenv->IsSameObject(baseclass, jcls) ? false : true);
    for (int i = 0; i < 2; ++i) {
      if (!methods[i].base_methid) {
        methods[i].base_methid = jenv->GetMethodID(baseclass, methods[i].mname, methods[i].mdesc);
        if (!methods[i].base_methid) return;
      }
      swig_override[i] = false;
      if (derived) {
        jmethodID methid = jenv->GetMethodID(jcls, methods[i].mname, methods[i].mdesc);
        swig_override[i] = (methid != methods[i].base_methid);
        jenv->ExceptionClear();
      }
    }
  }
}


SwigDirector_ContactResultCallback::SwigDirector_ContactResultCallback(JNIEnv *jenv) : btCollisionWorld::ContactResultCallback(), Swig::Director(jenv) {
}

SwigDirector_ContactResultCallback::~SwigDirector_ContactResultCallback() {
  swig_disconnect_director_self("swigDirectorDisconnect");
}


bool SwigDirector_ContactResultCallback::needsCollision(btBroadphaseProxy *proxy0) const {
  bool c_result = SwigValueInit< bool >() ;
  jboolean jresult = 0 ;
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  jlong jproxy0 = 0 ;
  
  if (!swig_override[0]) {
    return btCollisionWorld::ContactResultCallback::needsCollision(proxy0);
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    *((btBroadphaseProxy **)&jproxy0) = (btBroadphaseProxy *) proxy0; 
    jresult = (jboolean) jenv->CallStaticBooleanMethod(Swig::jclass_CollisionJNI, Swig::director_method_ids[29], swigjobj, jproxy0);
    jthrowable swigerror = jenv->ExceptionOccurred();
    if (swigerror) {
      jenv->ExceptionClear();
      throw Swig::DirectorException(jenv, swigerror);
    }
    
    c_result = jresult ? true : false; 
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object in btCollisionWorld::ContactResultCallback::needsCollision ");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
  return c_result;
}

btScalar SwigDirector_ContactResultCallback::addSingleResult(btManifoldPoint &cp, btCollisionObjectWrapper const *colObj0Wrap, int partId0, int index0, btCollisionObjectWrapper const *colObj1Wrap, int partId1, int index1) {
  btScalar c_result = SwigValueInit< btScalar >() ;
  jfloat jresult = 0 ;
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  jlong jcp = 0 ;
  jlong jcolObj0Wrap = 0 ;
  jint jpartId0  ;
  jint jindex0  ;
  jlong jcolObj1Wrap = 0 ;
  jint jpartId1  ;
  jint jindex1  ;
  
  if (!swig_override[1]) {
    SWIG_JavaThrowException(JNIEnvWrapper(this).getJNIEnv(), SWIG_JavaDirectorPureVirtual, "Attempted to invoke pure virtual method btCollisionWorld::ContactResultCallback::addSingleResult.");
    return c_result;
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    *(btManifoldPoint **)&jcp = (btManifoldPoint *) &cp; 
    *((btCollisionObjectWrapper **)&jcolObj0Wrap) = (btCollisionObjectWrapper *) colObj0Wrap; 
    jpartId0 = (jint) partId0;
    jindex0 = (jint) index0;
    *((btCollisionObjectWrapper **)&jcolObj1Wrap) = (btCollisionObjectWrapper *) colObj1Wrap; 
    jpartId1 = (jint) partId1;
    jindex1 = (jint) index1;
    jresult = (jfloat) jenv->CallStaticFloatMethod(Swig::jclass_CollisionJNI, Swig::director_method_ids[30], swigjobj, jcp, jcolObj0Wrap, jpartId0, jindex0, jcolObj1Wrap, jpartId1, jindex1);
    jthrowable swigerror = jenv->ExceptionOccurred();
    if (swigerror) {
      jenv->ExceptionClear();
      throw Swig::DirectorException(jenv, swigerror);
    }
    
    c_result = (btScalar)jresult; 
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object in btCollisionWorld::ContactResultCallback::addSingleResult ");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
  return c_result;
}

void SwigDirector_ContactResultCallback::swig_connect_director(JNIEnv *jenv, jobject jself, jclass jcls, bool swig_mem_own, bool weak_global) {
  static struct {
    const char *mname;
    const char *mdesc;
    jmethodID base_methid;
  } methods[] = {
    {
      "needsCollision", "(Lcom/badlogic/gdx/physics/bullet/collision/btBroadphaseProxy;)Z", NULL 
    },
    {
      "addSingleResult", "(Lcom/badlogic/gdx/physics/bullet/collision/btManifoldPoint;Lcom/badlogic/gdx/physics/bullet/collision/btCollisionObjectWrapper;IILcom/badlogic/gdx/physics/bullet/collision/btCollisionObjectWrapper;II)F", NULL 
    }
  };
  
  static jclass baseclass = 0 ;
  
  if (swig_set_self(jenv, jself, swig_mem_own, weak_global)) {
    if (!baseclass) {
      baseclass = jenv->FindClass("com/badlogic/gdx/physics/bullet/collision/ContactResultCallback");
      if (!baseclass) return;
      baseclass = (jclass) jenv->NewGlobalRef(baseclass);
    }
    bool derived = (jenv->IsSameObject(baseclass, jcls) ? false : true);
    for (int i = 0; i < 2; ++i) {
      if (!methods[i].base_methid) {
        methods[i].base_methid = jenv->GetMethodID(baseclass, methods[i].mname, methods[i].mdesc);
        if (!methods[i].base_methid) return;
      }
      swig_override[i] = false;
      if (derived) {
        jmethodID methid = jenv->GetMethodID(jcls, methods[i].mname, methods[i].mdesc);
        swig_override[i] = (methid != methods[i].base_methid);
        jenv->ExceptionClear();
      }
    }
  }
}


SwigDirector_btTriangleRaycastCallback::SwigDirector_btTriangleRaycastCallback(JNIEnv *jenv, btVector3 const &from, btVector3 const &to, unsigned int flags) : btTriangleRaycastCallback(from, to, flags), Swig::Director(jenv) {
}

SwigDirector_btTriangleRaycastCallback::~SwigDirector_btTriangleRaycastCallback() {
  swig_disconnect_director_self("swigDirectorDisconnect");
}


void SwigDirector_btTriangleRaycastCallback::processTriangle(btVector3 *triangle, int partId, int triangleIndex) {
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  jlong jtriangle = 0 ;
  jint jpartId  ;
  jint jtriangleIndex  ;
  
  if (!swig_override[0]) {
    btTriangleRaycastCallback::processTriangle(triangle,partId,triangleIndex);
    return;
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    *((btVector3 **)&jtriangle) = (btVector3 *) triangle; 
    jpartId = (jint) partId;
    jtriangleIndex = (jint) triangleIndex;
    jenv->CallStaticVoidMethod(Swig::jclass_CollisionJNI, Swig::director_method_ids[31], swigjobj, jtriangle, jpartId, jtriangleIndex);
    jthrowable swigerror = jenv->ExceptionOccurred();
    if (swigerror) {
      jenv->ExceptionClear();
      throw Swig::DirectorException(jenv, swigerror);
    }
    
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object in btTriangleRaycastCallback::processTriangle ");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
}

btScalar SwigDirector_btTriangleRaycastCallback::reportHit(btVector3 const &hitNormalLocal, btScalar hitFraction, int partId, int triangleIndex) {
  btScalar c_result = SwigValueInit< btScalar >() ;
  jfloat jresult = 0 ;
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  jobject jhitNormalLocal = 0 ;
  jfloat jhitFraction  ;
  jint jpartId  ;
  jint jtriangleIndex  ;
  
  if (!swig_override[1]) {
    SWIG_JavaThrowException(JNIEnvWrapper(this).getJNIEnv(), SWIG_JavaDirectorPureVirtual, "Attempted to invoke pure virtual method btTriangleRaycastCallback::reportHit.");
    return c_result;
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    jhitNormalLocal = gdx_takePoolObjectVector3(jenv, "poolVector3");
    gdx_setVector3FrombtVector3(jenv, jhitNormalLocal, hitNormalLocal);
    gdxPoolAutoReleaseVector3 autoRelease_jhitNormalLocal(jenv, "poolVector3", jhitNormalLocal);
    jhitFraction = (jfloat) hitFraction;
    jpartId = (jint) partId;
    jtriangleIndex = (jint) triangleIndex;
    jresult = (jfloat) jenv->CallStaticFloatMethod(Swig::jclass_CollisionJNI, Swig::director_method_ids[32], swigjobj, jhitNormalLocal, jhitFraction, jpartId, jtriangleIndex);
    jthrowable swigerror = jenv->ExceptionOccurred();
    if (swigerror) {
      jenv->ExceptionClear();
      throw Swig::DirectorException(jenv, swigerror);
    }
    
    c_result = (btScalar)jresult; 
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object in btTriangleRaycastCallback::reportHit ");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
  return c_result;
}

void SwigDirector_btTriangleRaycastCallback::swig_connect_director(JNIEnv *jenv, jobject jself, jclass jcls, bool swig_mem_own, bool weak_global) {
  static struct {
    const char *mname;
    const char *mdesc;
    jmethodID base_methid;
  } methods[] = {
    {
      "processTriangle", "(Lcom/badlogic/gdx/physics/bullet/linearmath/btVector3;II)V", NULL 
    },
    {
      "reportHit", "(Lcom/badlogic/gdx/math/Vector3;FII)F", NULL 
    }
  };
  
  static jclass baseclass = 0 ;
  
  if (swig_set_self(jenv, jself, swig_mem_own, weak_global)) {
    if (!baseclass) {
      baseclass = jenv->FindClass("com/badlogic/gdx/physics/bullet/collision/btTriangleRaycastCallback");
      if (!baseclass) return;
      baseclass = (jclass) jenv->NewGlobalRef(baseclass);
    }
    bool derived = (jenv->IsSameObject(baseclass, jcls) ? false : true);
    for (int i = 0; i < 2; ++i) {
      if (!methods[i].base_methid) {
        methods[i].base_methid = jenv->GetMethodID(baseclass, methods[i].mname, methods[i].mdesc);
        if (!methods[i].base_methid) return;
      }
      swig_override[i] = false;
      if (derived) {
        jmethodID methid = jenv->GetMethodID(jcls, methods[i].mname, methods[i].mdesc);
        swig_override[i] = (methid != methods[i].base_methid);
        jenv->ExceptionClear();
      }
    }
  }
}


SwigDirector_btTriangleConvexcastCallback::SwigDirector_btTriangleConvexcastCallback(JNIEnv *jenv, btConvexShape const *convexShape, btTransform const &convexShapeFrom, btTransform const &convexShapeTo, btTransform const &triangleToWorld, btScalar const triangleCollisionMargin) : btTriangleConvexcastCallback(convexShape, convexShapeFrom, convexShapeTo, triangleToWorld, triangleCollisionMargin), Swig::Director(jenv) {
}

SwigDirector_btTriangleConvexcastCallback::~SwigDirector_btTriangleConvexcastCallback() {
  swig_disconnect_director_self("swigDirectorDisconnect");
}


void SwigDirector_btTriangleConvexcastCallback::processTriangle(btVector3 *triangle, int partId, int triangleIndex) {
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  jlong jtriangle = 0 ;
  jint jpartId  ;
  jint jtriangleIndex  ;
  
  if (!swig_override[0]) {
    btTriangleConvexcastCallback::processTriangle(triangle,partId,triangleIndex);
    return;
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    *((btVector3 **)&jtriangle) = (btVector3 *) triangle; 
    jpartId = (jint) partId;
    jtriangleIndex = (jint) triangleIndex;
    jenv->CallStaticVoidMethod(Swig::jclass_CollisionJNI, Swig::director_method_ids[33], swigjobj, jtriangle, jpartId, jtriangleIndex);
    jthrowable swigerror = jenv->ExceptionOccurred();
    if (swigerror) {
      jenv->ExceptionClear();
      throw Swig::DirectorException(jenv, swigerror);
    }
    
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object in btTriangleConvexcastCallback::processTriangle ");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
}

btScalar SwigDirector_btTriangleConvexcastCallback::reportHit(btVector3 const &hitNormalLocal, btVector3 const &hitPointLocal, btScalar hitFraction, int partId, int triangleIndex) {
  btScalar c_result = SwigValueInit< btScalar >() ;
  jfloat jresult = 0 ;
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  jobject jhitNormalLocal = 0 ;
  jobject jhitPointLocal = 0 ;
  jfloat jhitFraction  ;
  jint jpartId  ;
  jint jtriangleIndex  ;
  
  if (!swig_override[1]) {
    SWIG_JavaThrowException(JNIEnvWrapper(this).getJNIEnv(), SWIG_JavaDirectorPureVirtual, "Attempted to invoke pure virtual method btTriangleConvexcastCallback::reportHit.");
    return c_result;
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    jhitNormalLocal = gdx_takePoolObjectVector3(jenv, "poolVector3");
    gdx_setVector3FrombtVector3(jenv, jhitNormalLocal, hitNormalLocal);
    gdxPoolAutoReleaseVector3 autoRelease_jhitNormalLocal(jenv, "poolVector3", jhitNormalLocal);
    jhitPointLocal = gdx_takePoolObjectVector3(jenv, "poolVector3");
    gdx_setVector3FrombtVector3(jenv, jhitPointLocal, hitPointLocal);
    gdxPoolAutoReleaseVector3 autoRelease_jhitPointLocal(jenv, "poolVector3", jhitPointLocal);
    jhitFraction = (jfloat) hitFraction;
    jpartId = (jint) partId;
    jtriangleIndex = (jint) triangleIndex;
    jresult = (jfloat) jenv->CallStaticFloatMethod(Swig::jclass_CollisionJNI, Swig::director_method_ids[34], swigjobj, jhitNormalLocal, jhitPointLocal, jhitFraction, jpartId, jtriangleIndex);
    jthrowable swigerror = jenv->ExceptionOccurred();
    if (swigerror) {
      jenv->ExceptionClear();
      throw Swig::DirectorException(jenv, swigerror);
    }
    
    c_result = (btScalar)jresult; 
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object in btTriangleConvexcastCallback::reportHit ");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
  return c_result;
}

void SwigDirector_btTriangleConvexcastCallback::swig_connect_director(JNIEnv *jenv, jobject jself, jclass jcls, bool swig_mem_own, bool weak_global) {
  static struct {
    const char *mname;
    const char *mdesc;
    jmethodID base_methid;
  } methods[] = {
    {
      "processTriangle", "(Lcom/badlogic/gdx/physics/bullet/linearmath/btVector3;II)V", NULL 
    },
    {
      "reportHit", "(Lcom/badlogic/gdx/math/Vector3;Lcom/badlogic/gdx/math/Vector3;FII)F", NULL 
    }
  };
  
  static jclass baseclass = 0 ;
  
  if (swig_set_self(jenv, jself, swig_mem_own, weak_global)) {
    if (!baseclass) {
      baseclass = jenv->FindClass("com/badlogic/gdx/physics/bullet/collision/btTriangleConvexcastCallback");
      if (!baseclass) return;
      baseclass = (jclass) jenv->NewGlobalRef(baseclass);
    }
    bool derived = (jenv->IsSameObject(baseclass, jcls) ? false : true);
    for (int i = 0; i < 2; ++i) {
      if (!methods[i].base_methid) {
        methods[i].base_methid = jenv->GetMethodID(baseclass, methods[i].mname, methods[i].mdesc);
        if (!methods[i].base_methid) return;
      }
      swig_override[i] = false;
      if (derived) {
        jmethodID methid = jenv->GetMethodID(jcls, methods[i].mname, methods[i].mdesc);
        swig_override[i] = (methid != methods[i].base_methid);
        jenv->ExceptionClear();
      }
    }
  }
}


SwigDirector_CustomCollisionDispatcher::SwigDirector_CustomCollisionDispatcher(JNIEnv *jenv, btCollisionConfiguration *collisionConfiguration) : CustomCollisionDispatcher(collisionConfiguration), Swig::Director(jenv) {
}

SwigDirector_CustomCollisionDispatcher::~SwigDirector_CustomCollisionDispatcher() {
  swig_disconnect_director_self("swigDirectorDisconnect");
}


btPersistentManifold *SwigDirector_CustomCollisionDispatcher::getNewManifold(btCollisionObject const *b0, btCollisionObject const *b1) {
  return btCollisionDispatcher::getNewManifold(b0,b1);
}

void SwigDirector_CustomCollisionDispatcher::releaseManifold(btPersistentManifold *manifold) {
  btCollisionDispatcher::releaseManifold(manifold);
}

void SwigDirector_CustomCollisionDispatcher::clearManifold(btPersistentManifold *manifold) {
  btCollisionDispatcher::clearManifold(manifold);
}

bool SwigDirector_CustomCollisionDispatcher::needsCollision(btCollisionObject const *body0, btCollisionObject const *body1) {
  bool c_result = SwigValueInit< bool >() ;
  jboolean jresult = 0 ;
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  jlong jbody0 = 0 ;
  jlong jbody1 = 0 ;
  
  if (!swig_override[0]) {
    return CustomCollisionDispatcher::needsCollision(body0,body1);
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    *((btCollisionObject **)&jbody0) = (btCollisionObject *) body0; 
    *((btCollisionObject **)&jbody1) = (btCollisionObject *) body1; 
    jresult = (jboolean) jenv->CallStaticBooleanMethod(Swig::jclass_CollisionJNI, Swig::director_method_ids[35], swigjobj, jbody0, jbody1);
    jthrowable swigerror = jenv->ExceptionOccurred();
    if (swigerror) {
      jenv->ExceptionClear();
      throw Swig::DirectorException(jenv, swigerror);
    }
    
    c_result = jresult ? true : false; 
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object in CustomCollisionDispatcher::needsCollision ");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
  return c_result;
}

bool SwigDirector_CustomCollisionDispatcher::needsResponse(btCollisionObject const *body0, btCollisionObject const *body1) {
  bool c_result = SwigValueInit< bool >() ;
  jboolean jresult = 0 ;
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  jlong jbody0 = 0 ;
  jlong jbody1 = 0 ;
  
  if (!swig_override[1]) {
    return CustomCollisionDispatcher::needsResponse(body0,body1);
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    *((btCollisionObject **)&jbody0) = (btCollisionObject *) body0; 
    *((btCollisionObject **)&jbody1) = (btCollisionObject *) body1; 
    jresult = (jboolean) jenv->CallStaticBooleanMethod(Swig::jclass_CollisionJNI, Swig::director_method_ids[36], swigjobj, jbody0, jbody1);
    jthrowable swigerror = jenv->ExceptionOccurred();
    if (swigerror) {
      jenv->ExceptionClear();
      throw Swig::DirectorException(jenv, swigerror);
    }
    
    c_result = jresult ? true : false; 
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object in CustomCollisionDispatcher::needsResponse ");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
  return c_result;
}

void SwigDirector_CustomCollisionDispatcher::dispatchAllCollisionPairs(btOverlappingPairCache *pairCache, btDispatcherInfo const &dispatchInfo, btDispatcher *dispatcher) {
  btCollisionDispatcher::dispatchAllCollisionPairs(pairCache,dispatchInfo,dispatcher);
}

int SwigDirector_CustomCollisionDispatcher::getNumManifolds() const {
  return btCollisionDispatcher::getNumManifolds();
}

btPersistentManifold **SwigDirector_CustomCollisionDispatcher::getInternalManifoldPointer() {
  return btCollisionDispatcher::getInternalManifoldPointer();
}

void *SwigDirector_CustomCollisionDispatcher::allocateCollisionAlgorithm(int size) {
  return btCollisionDispatcher::allocateCollisionAlgorithm(size);
}

void SwigDirector_CustomCollisionDispatcher::freeCollisionAlgorithm(void *ptr) {
  btCollisionDispatcher::freeCollisionAlgorithm(ptr);
}

void SwigDirector_CustomCollisionDispatcher::swig_connect_director(JNIEnv *jenv, jobject jself, jclass jcls, bool swig_mem_own, bool weak_global) {
  static struct {
    const char *mname;
    const char *mdesc;
    jmethodID base_methid;
  } methods[] = {
    {
      "needsCollision", "(Lcom/badlogic/gdx/physics/bullet/collision/btCollisionObject;Lcom/badlogic/gdx/physics/bullet/collision/btCollisionObject;)Z", NULL 
    },
    {
      "needsResponse", "(Lcom/badlogic/gdx/physics/bullet/collision/btCollisionObject;Lcom/badlogic/gdx/physics/bullet/collision/btCollisionObject;)Z", NULL 
    }
  };
  
  static jclass baseclass = 0 ;
  
  if (swig_set_self(jenv, jself, swig_mem_own, weak_global)) {
    if (!baseclass) {
      baseclass = jenv->FindClass("com/badlogic/gdx/physics/bullet/collision/CustomCollisionDispatcher");
      if (!baseclass) return;
      baseclass = (jclass) jenv->NewGlobalRef(baseclass);
    }
    bool derived = (jenv->IsSameObject(baseclass, jcls) ? false : true);
    for (int i = 0; i < 2; ++i) {
      if (!methods[i].base_methid) {
        methods[i].base_methid = jenv->GetMethodID(baseclass, methods[i].mname, methods[i].mdesc);
        if (!methods[i].base_methid) return;
      }
      swig_override[i] = false;
      if (derived) {
        jmethodID methid = jenv->GetMethodID(jcls, methods[i].mname, methods[i].mdesc);
        swig_override[i] = (methid != methods[i].base_methid);
        jenv->ExceptionClear();
      }
    }
  }
}


SwigDirector_ContactListener::SwigDirector_ContactListener(JNIEnv *jenv, bool dummy) : ContactListener(dummy), Swig::Director(jenv) {
}

SwigDirector_ContactListener::~SwigDirector_ContactListener() {
  swig_disconnect_director_self("swigDirectorDisconnect");
}


bool SwigDirector_ContactListener::onContactAdded(btManifoldPoint &cp, btCollisionObjectWrapper const &colObj0Wrap, int partId0, int index0, btCollisionObjectWrapper const &colObj1Wrap, int partId1, int index1) {
  bool c_result = SwigValueInit< bool >() ;
  jboolean jresult = 0 ;
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  jlong jcp = 0 ;
  jlong jcolObj0Wrap = 0 ;
  jint jpartId0  ;
  jint jindex0  ;
  jlong jcolObj1Wrap = 0 ;
  jint jpartId1  ;
  jint jindex1  ;
  
  if (!swig_override[0]) {
    SWIG_JavaThrowException(JNIEnvWrapper(this).getJNIEnv(), SWIG_JavaDirectorPureVirtual, "Attempted to invoke pure virtual method ContactListener::onContactAdded.");
    return c_result;
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    *(btManifoldPoint **)&jcp = (btManifoldPoint *) &cp; 
    *(btCollisionObjectWrapper **)&jcolObj0Wrap = (btCollisionObjectWrapper *) &colObj0Wrap; 
    jpartId0 = (jint) partId0;
    jindex0 = (jint) index0;
    *(btCollisionObjectWrapper **)&jcolObj1Wrap = (btCollisionObjectWrapper *) &colObj1Wrap; 
    jpartId1 = (jint) partId1;
    jindex1 = (jint) index1;
    jresult = (jboolean) jenv->CallStaticBooleanMethod(Swig::jclass_CollisionJNI, Swig::director_method_ids[37], swigjobj, jcp, jcolObj0Wrap, jpartId0, jindex0, jcolObj1Wrap, jpartId1, jindex1);
    jthrowable swigerror = jenv->ExceptionOccurred();
    if (swigerror) {
      jenv->ExceptionClear();
      throw Swig::DirectorException(jenv, swigerror);
    }
    
    c_result = jresult ? true : false; 
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object in ContactListener::onContactAdded ");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
  return c_result;
}

bool SwigDirector_ContactListener::onContactAdded(btManifoldPoint &cp, btCollisionObject const *colObj0, int partId0, int index0, btCollisionObject const *colObj1, int partId1, int index1) {
  bool c_result = SwigValueInit< bool >() ;
  jboolean jresult = 0 ;
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  jlong jcp = 0 ;
  jlong jcolObj0 = 0 ;
  jint jpartId0  ;
  jint jindex0  ;
  jlong jcolObj1 = 0 ;
  jint jpartId1  ;
  jint jindex1  ;
  
  if (!swig_override[1]) {
    SWIG_JavaThrowException(JNIEnvWrapper(this).getJNIEnv(), SWIG_JavaDirectorPureVirtual, "Attempted to invoke pure virtual method ContactListener::onContactAdded.");
    return c_result;
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    *(btManifoldPoint **)&jcp = (btManifoldPoint *) &cp; 
    *((btCollisionObject **)&jcolObj0) = (btCollisionObject *) colObj0; 
    jpartId0 = (jint) partId0;
    jindex0 = (jint) index0;
    *((btCollisionObject **)&jcolObj1) = (btCollisionObject *) colObj1; 
    jpartId1 = (jint) partId1;
    jindex1 = (jint) index1;
    jresult = (jboolean) jenv->CallStaticBooleanMethod(Swig::jclass_CollisionJNI, Swig::director_method_ids[38], swigjobj, jcp, jcolObj0, jpartId0, jindex0, jcolObj1, jpartId1, jindex1);
    jthrowable swigerror = jenv->ExceptionOccurred();
    if (swigerror) {
      jenv->ExceptionClear();
      throw Swig::DirectorException(jenv, swigerror);
    }
    
    c_result = jresult ? true : false; 
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object in ContactListener::onContactAdded ");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
  return c_result;
}

bool SwigDirector_ContactListener::onContactAdded(btManifoldPoint &cp, int userValue0, int partId0, int index0, int userValue1, int partId1, int index1) {
  bool c_result = SwigValueInit< bool >() ;
  jboolean jresult = 0 ;
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  jlong jcp = 0 ;
  jint juserValue0  ;
  jint jpartId0  ;
  jint jindex0  ;
  jint juserValue1  ;
  jint jpartId1  ;
  jint jindex1  ;
  
  if (!swig_override[2]) {
    SWIG_JavaThrowException(JNIEnvWrapper(this).getJNIEnv(), SWIG_JavaDirectorPureVirtual, "Attempted to invoke pure virtual method ContactListener::onContactAdded.");
    return c_result;
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    *(btManifoldPoint **)&jcp = (btManifoldPoint *) &cp; 
    juserValue0 = (jint) userValue0;
    jpartId0 = (jint) partId0;
    jindex0 = (jint) index0;
    juserValue1 = (jint) userValue1;
    jpartId1 = (jint) partId1;
    jindex1 = (jint) index1;
    jresult = (jboolean) jenv->CallStaticBooleanMethod(Swig::jclass_CollisionJNI, Swig::director_method_ids[39], swigjobj, jcp, juserValue0, jpartId0, jindex0, juserValue1, jpartId1, jindex1);
    jthrowable swigerror = jenv->ExceptionOccurred();
    if (swigerror) {
      jenv->ExceptionClear();
      throw Swig::DirectorException(jenv, swigerror);
    }
    
    c_result = jresult ? true : false; 
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object in ContactListener::onContactAdded ");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
  return c_result;
}

bool SwigDirector_ContactListener::onContactAdded(btManifoldPoint &cp, btCollisionObjectWrapper const &colObj0Wrap, int partId0, int index0, bool match0, btCollisionObjectWrapper const &colObj1Wrap, int partId1, int index1, bool match1) {
  bool c_result = SwigValueInit< bool >() ;
  jboolean jresult = 0 ;
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  jlong jcp = 0 ;
  jlong jcolObj0Wrap = 0 ;
  jint jpartId0  ;
  jint jindex0  ;
  jboolean jmatch0  ;
  jlong jcolObj1Wrap = 0 ;
  jint jpartId1  ;
  jint jindex1  ;
  jboolean jmatch1  ;
  
  if (!swig_override[3]) {
    SWIG_JavaThrowException(JNIEnvWrapper(this).getJNIEnv(), SWIG_JavaDirectorPureVirtual, "Attempted to invoke pure virtual method ContactListener::onContactAdded.");
    return c_result;
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    *(btManifoldPoint **)&jcp = (btManifoldPoint *) &cp; 
    *(btCollisionObjectWrapper **)&jcolObj0Wrap = (btCollisionObjectWrapper *) &colObj0Wrap; 
    jpartId0 = (jint) partId0;
    jindex0 = (jint) index0;
    jmatch0 = (jboolean) match0;
    *(btCollisionObjectWrapper **)&jcolObj1Wrap = (btCollisionObjectWrapper *) &colObj1Wrap; 
    jpartId1 = (jint) partId1;
    jindex1 = (jint) index1;
    jmatch1 = (jboolean) match1;
    jresult = (jboolean) jenv->CallStaticBooleanMethod(Swig::jclass_CollisionJNI, Swig::director_method_ids[40], swigjobj, jcp, jcolObj0Wrap, jpartId0, jindex0, jmatch0, jcolObj1Wrap, jpartId1, jindex1, jmatch1);
    jthrowable swigerror = jenv->ExceptionOccurred();
    if (swigerror) {
      jenv->ExceptionClear();
      throw Swig::DirectorException(jenv, swigerror);
    }
    
    c_result = jresult ? true : false; 
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object in ContactListener::onContactAdded ");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
  return c_result;
}

bool SwigDirector_ContactListener::onContactAdded(btManifoldPoint &cp, btCollisionObject const *colObj0, int partId0, int index0, bool match0, btCollisionObject const *colObj1, int partId1, int index1, bool match1) {
  bool c_result = SwigValueInit< bool >() ;
  jboolean jresult = 0 ;
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  jlong jcp = 0 ;
  jlong jcolObj0 = 0 ;
  jint jpartId0  ;
  jint jindex0  ;
  jboolean jmatch0  ;
  jlong jcolObj1 = 0 ;
  jint jpartId1  ;
  jint jindex1  ;
  jboolean jmatch1  ;
  
  if (!swig_override[4]) {
    SWIG_JavaThrowException(JNIEnvWrapper(this).getJNIEnv(), SWIG_JavaDirectorPureVirtual, "Attempted to invoke pure virtual method ContactListener::onContactAdded.");
    return c_result;
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    *(btManifoldPoint **)&jcp = (btManifoldPoint *) &cp; 
    *((btCollisionObject **)&jcolObj0) = (btCollisionObject *) colObj0; 
    jpartId0 = (jint) partId0;
    jindex0 = (jint) index0;
    jmatch0 = (jboolean) match0;
    *((btCollisionObject **)&jcolObj1) = (btCollisionObject *) colObj1; 
    jpartId1 = (jint) partId1;
    jindex1 = (jint) index1;
    jmatch1 = (jboolean) match1;
    jresult = (jboolean) jenv->CallStaticBooleanMethod(Swig::jclass_CollisionJNI, Swig::director_method_ids[41], swigjobj, jcp, jcolObj0, jpartId0, jindex0, jmatch0, jcolObj1, jpartId1, jindex1, jmatch1);
    jthrowable swigerror = jenv->ExceptionOccurred();
    if (swigerror) {
      jenv->ExceptionClear();
      throw Swig::DirectorException(jenv, swigerror);
    }
    
    c_result = jresult ? true : false; 
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object in ContactListener::onContactAdded ");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
  return c_result;
}

bool SwigDirector_ContactListener::onContactAdded(btManifoldPoint &cp, int userValue0, int partId0, int index0, bool match0, int userValue1, int partId1, int index1, bool match1) {
  bool c_result = SwigValueInit< bool >() ;
  jboolean jresult = 0 ;
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  jlong jcp = 0 ;
  jint juserValue0  ;
  jint jpartId0  ;
  jint jindex0  ;
  jboolean jmatch0  ;
  jint juserValue1  ;
  jint jpartId1  ;
  jint jindex1  ;
  jboolean jmatch1  ;
  
  if (!swig_override[5]) {
    SWIG_JavaThrowException(JNIEnvWrapper(this).getJNIEnv(), SWIG_JavaDirectorPureVirtual, "Attempted to invoke pure virtual method ContactListener::onContactAdded.");
    return c_result;
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    *(btManifoldPoint **)&jcp = (btManifoldPoint *) &cp; 
    juserValue0 = (jint) userValue0;
    jpartId0 = (jint) partId0;
    jindex0 = (jint) index0;
    jmatch0 = (jboolean) match0;
    juserValue1 = (jint) userValue1;
    jpartId1 = (jint) partId1;
    jindex1 = (jint) index1;
    jmatch1 = (jboolean) match1;
    jresult = (jboolean) jenv->CallStaticBooleanMethod(Swig::jclass_CollisionJNI, Swig::director_method_ids[42], swigjobj, jcp, juserValue0, jpartId0, jindex0, jmatch0, juserValue1, jpartId1, jindex1, jmatch1);
    jthrowable swigerror = jenv->ExceptionOccurred();
    if (swigerror) {
      jenv->ExceptionClear();
      throw Swig::DirectorException(jenv, swigerror);
    }
    
    c_result = jresult ? true : false; 
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object in ContactListener::onContactAdded ");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
  return c_result;
}

bool SwigDirector_ContactListener::onContactAdded(btCollisionObjectWrapper const &colObj0Wrap, int partId0, int index0, btCollisionObjectWrapper const &colObj1Wrap, int partId1, int index1) {
  bool c_result = SwigValueInit< bool >() ;
  jboolean jresult = 0 ;
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  jlong jcolObj0Wrap = 0 ;
  jint jpartId0  ;
  jint jindex0  ;
  jlong jcolObj1Wrap = 0 ;
  jint jpartId1  ;
  jint jindex1  ;
  
  if (!swig_override[6]) {
    SWIG_JavaThrowException(JNIEnvWrapper(this).getJNIEnv(), SWIG_JavaDirectorPureVirtual, "Attempted to invoke pure virtual method ContactListener::onContactAdded.");
    return c_result;
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    *(btCollisionObjectWrapper **)&jcolObj0Wrap = (btCollisionObjectWrapper *) &colObj0Wrap; 
    jpartId0 = (jint) partId0;
    jindex0 = (jint) index0;
    *(btCollisionObjectWrapper **)&jcolObj1Wrap = (btCollisionObjectWrapper *) &colObj1Wrap; 
    jpartId1 = (jint) partId1;
    jindex1 = (jint) index1;
    jresult = (jboolean) jenv->CallStaticBooleanMethod(Swig::jclass_CollisionJNI, Swig::director_method_ids[43], swigjobj, jcolObj0Wrap, jpartId0, jindex0, jcolObj1Wrap, jpartId1, jindex1);
    jthrowable swigerror = jenv->ExceptionOccurred();
    if (swigerror) {
      jenv->ExceptionClear();
      throw Swig::DirectorException(jenv, swigerror);
    }
    
    c_result = jresult ? true : false; 
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object in ContactListener::onContactAdded ");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
  return c_result;
}

bool SwigDirector_ContactListener::onContactAdded(btCollisionObject const *colObj0, int partId0, int index0, btCollisionObject const *colObj1, int partId1, int index1) {
  bool c_result = SwigValueInit< bool >() ;
  jboolean jresult = 0 ;
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  jlong jcolObj0 = 0 ;
  jint jpartId0  ;
  jint jindex0  ;
  jlong jcolObj1 = 0 ;
  jint jpartId1  ;
  jint jindex1  ;
  
  if (!swig_override[7]) {
    SWIG_JavaThrowException(JNIEnvWrapper(this).getJNIEnv(), SWIG_JavaDirectorPureVirtual, "Attempted to invoke pure virtual method ContactListener::onContactAdded.");
    return c_result;
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    *((btCollisionObject **)&jcolObj0) = (btCollisionObject *) colObj0; 
    jpartId0 = (jint) partId0;
    jindex0 = (jint) index0;
    *((btCollisionObject **)&jcolObj1) = (btCollisionObject *) colObj1; 
    jpartId1 = (jint) partId1;
    jindex1 = (jint) index1;
    jresult = (jboolean) jenv->CallStaticBooleanMethod(Swig::jclass_CollisionJNI, Swig::director_method_ids[44], swigjobj, jcolObj0, jpartId0, jindex0, jcolObj1, jpartId1, jindex1);
    jthrowable swigerror = jenv->ExceptionOccurred();
    if (swigerror) {
      jenv->ExceptionClear();
      throw Swig::DirectorException(jenv, swigerror);
    }
    
    c_result = jresult ? true : false; 
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object in ContactListener::onContactAdded ");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
  return c_result;
}

bool SwigDirector_ContactListener::onContactAdded(int userValue0, int partId0, int index0, int userValue1, int partId1, int index1) {
  bool c_result = SwigValueInit< bool >() ;
  jboolean jresult = 0 ;
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  jint juserValue0  ;
  jint jpartId0  ;
  jint jindex0  ;
  jint juserValue1  ;
  jint jpartId1  ;
  jint jindex1  ;
  
  if (!swig_override[8]) {
    SWIG_JavaThrowException(JNIEnvWrapper(this).getJNIEnv(), SWIG_JavaDirectorPureVirtual, "Attempted to invoke pure virtual method ContactListener::onContactAdded.");
    return c_result;
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    juserValue0 = (jint) userValue0;
    jpartId0 = (jint) partId0;
    jindex0 = (jint) index0;
    juserValue1 = (jint) userValue1;
    jpartId1 = (jint) partId1;
    jindex1 = (jint) index1;
    jresult = (jboolean) jenv->CallStaticBooleanMethod(Swig::jclass_CollisionJNI, Swig::director_method_ids[45], swigjobj, juserValue0, jpartId0, jindex0, juserValue1, jpartId1, jindex1);
    jthrowable swigerror = jenv->ExceptionOccurred();
    if (swigerror) {
      jenv->ExceptionClear();
      throw Swig::DirectorException(jenv, swigerror);
    }
    
    c_result = jresult ? true : false; 
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object in ContactListener::onContactAdded ");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
  return c_result;
}

bool SwigDirector_ContactListener::onContactAdded(btCollisionObjectWrapper const &colObj0Wrap, int partId0, int index0, bool match0, btCollisionObjectWrapper const &colObj1Wrap, int partId1, int index1, bool match1) {
  bool c_result = SwigValueInit< bool >() ;
  jboolean jresult = 0 ;
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  jlong jcolObj0Wrap = 0 ;
  jint jpartId0  ;
  jint jindex0  ;
  jboolean jmatch0  ;
  jlong jcolObj1Wrap = 0 ;
  jint jpartId1  ;
  jint jindex1  ;
  jboolean jmatch1  ;
  
  if (!swig_override[9]) {
    SWIG_JavaThrowException(JNIEnvWrapper(this).getJNIEnv(), SWIG_JavaDirectorPureVirtual, "Attempted to invoke pure virtual method ContactListener::onContactAdded.");
    return c_result;
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    *(btCollisionObjectWrapper **)&jcolObj0Wrap = (btCollisionObjectWrapper *) &colObj0Wrap; 
    jpartId0 = (jint) partId0;
    jindex0 = (jint) index0;
    jmatch0 = (jboolean) match0;
    *(btCollisionObjectWrapper **)&jcolObj1Wrap = (btCollisionObjectWrapper *) &colObj1Wrap; 
    jpartId1 = (jint) partId1;
    jindex1 = (jint) index1;
    jmatch1 = (jboolean) match1;
    jresult = (jboolean) jenv->CallStaticBooleanMethod(Swig::jclass_CollisionJNI, Swig::director_method_ids[46], swigjobj, jcolObj0Wrap, jpartId0, jindex0, jmatch0, jcolObj1Wrap, jpartId1, jindex1, jmatch1);
    jthrowable swigerror = jenv->ExceptionOccurred();
    if (swigerror) {
      jenv->ExceptionClear();
      throw Swig::DirectorException(jenv, swigerror);
    }
    
    c_result = jresult ? true : false; 
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object in ContactListener::onContactAdded ");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
  return c_result;
}

bool SwigDirector_ContactListener::onContactAdded(btCollisionObject const *colObj0, int partId0, int index0, bool match0, btCollisionObject const *colObj1, int partId1, int index1, bool match1) {
  bool c_result = SwigValueInit< bool >() ;
  jboolean jresult = 0 ;
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  jlong jcolObj0 = 0 ;
  jint jpartId0  ;
  jint jindex0  ;
  jboolean jmatch0  ;
  jlong jcolObj1 = 0 ;
  jint jpartId1  ;
  jint jindex1  ;
  jboolean jmatch1  ;
  
  if (!swig_override[10]) {
    SWIG_JavaThrowException(JNIEnvWrapper(this).getJNIEnv(), SWIG_JavaDirectorPureVirtual, "Attempted to invoke pure virtual method ContactListener::onContactAdded.");
    return c_result;
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    *((btCollisionObject **)&jcolObj0) = (btCollisionObject *) colObj0; 
    jpartId0 = (jint) partId0;
    jindex0 = (jint) index0;
    jmatch0 = (jboolean) match0;
    *((btCollisionObject **)&jcolObj1) = (btCollisionObject *) colObj1; 
    jpartId1 = (jint) partId1;
    jindex1 = (jint) index1;
    jmatch1 = (jboolean) match1;
    jresult = (jboolean) jenv->CallStaticBooleanMethod(Swig::jclass_CollisionJNI, Swig::director_method_ids[47], swigjobj, jcolObj0, jpartId0, jindex0, jmatch0, jcolObj1, jpartId1, jindex1, jmatch1);
    jthrowable swigerror = jenv->ExceptionOccurred();
    if (swigerror) {
      jenv->ExceptionClear();
      throw Swig::DirectorException(jenv, swigerror);
    }
    
    c_result = jresult ? true : false; 
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object in ContactListener::onContactAdded ");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
  return c_result;
}

bool SwigDirector_ContactListener::onContactAdded(int userValue0, int partId0, int index0, bool match0, int userValue1, int partId1, int index1, bool match1) {
  bool c_result = SwigValueInit< bool >() ;
  jboolean jresult = 0 ;
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  jint juserValue0  ;
  jint jpartId0  ;
  jint jindex0  ;
  jboolean jmatch0  ;
  jint juserValue1  ;
  jint jpartId1  ;
  jint jindex1  ;
  jboolean jmatch1  ;
  
  if (!swig_override[11]) {
    SWIG_JavaThrowException(JNIEnvWrapper(this).getJNIEnv(), SWIG_JavaDirectorPureVirtual, "Attempted to invoke pure virtual method ContactListener::onContactAdded.");
    return c_result;
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    juserValue0 = (jint) userValue0;
    jpartId0 = (jint) partId0;
    jindex0 = (jint) index0;
    jmatch0 = (jboolean) match0;
    juserValue1 = (jint) userValue1;
    jpartId1 = (jint) partId1;
    jindex1 = (jint) index1;
    jmatch1 = (jboolean) match1;
    jresult = (jboolean) jenv->CallStaticBooleanMethod(Swig::jclass_CollisionJNI, Swig::director_method_ids[48], swigjobj, juserValue0, jpartId0, jindex0, jmatch0, juserValue1, jpartId1, jindex1, jmatch1);
    jthrowable swigerror = jenv->ExceptionOccurred();
    if (swigerror) {
      jenv->ExceptionClear();
      throw Swig::DirectorException(jenv, swigerror);
    }
    
    c_result = jresult ? true : false; 
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object in ContactListener::onContactAdded ");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
  return c_result;
}

void SwigDirector_ContactListener::onContactProcessed(btManifoldPoint &cp, btCollisionObject const *colObj0, btCollisionObject const *colObj1) {
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  jlong jcp = 0 ;
  jlong jcolObj0 = 0 ;
  jlong jcolObj1 = 0 ;
  
  if (!swig_override[12]) {
    SWIG_JavaThrowException(JNIEnvWrapper(this).getJNIEnv(), SWIG_JavaDirectorPureVirtual, "Attempted to invoke pure virtual method ContactListener::onContactProcessed.");
    return;
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    *(btManifoldPoint **)&jcp = (btManifoldPoint *) &cp; 
    *((btCollisionObject **)&jcolObj0) = (btCollisionObject *) colObj0; 
    *((btCollisionObject **)&jcolObj1) = (btCollisionObject *) colObj1; 
    jenv->CallStaticVoidMethod(Swig::jclass_CollisionJNI, Swig::director_method_ids[49], swigjobj, jcp, jcolObj0, jcolObj1);
    jthrowable swigerror = jenv->ExceptionOccurred();
    if (swigerror) {
      jenv->ExceptionClear();
      throw Swig::DirectorException(jenv, swigerror);
    }
    
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object in ContactListener::onContactProcessed ");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
}

void SwigDirector_ContactListener::onContactProcessed(btManifoldPoint &cp, int userValue0, int userValue1) {
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  jlong jcp = 0 ;
  jint juserValue0  ;
  jint juserValue1  ;
  
  if (!swig_override[13]) {
    SWIG_JavaThrowException(JNIEnvWrapper(this).getJNIEnv(), SWIG_JavaDirectorPureVirtual, "Attempted to invoke pure virtual method ContactListener::onContactProcessed.");
    return;
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    *(btManifoldPoint **)&jcp = (btManifoldPoint *) &cp; 
    juserValue0 = (jint) userValue0;
    juserValue1 = (jint) userValue1;
    jenv->CallStaticVoidMethod(Swig::jclass_CollisionJNI, Swig::director_method_ids[50], swigjobj, jcp, juserValue0, juserValue1);
    jthrowable swigerror = jenv->ExceptionOccurred();
    if (swigerror) {
      jenv->ExceptionClear();
      throw Swig::DirectorException(jenv, swigerror);
    }
    
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object in ContactListener::onContactProcessed ");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
}

void SwigDirector_ContactListener::onContactProcessed(btManifoldPoint &cp, btCollisionObject const *colObj0, bool match0, btCollisionObject const *colObj1, bool match1) {
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  jlong jcp = 0 ;
  jlong jcolObj0 = 0 ;
  jboolean jmatch0  ;
  jlong jcolObj1 = 0 ;
  jboolean jmatch1  ;
  
  if (!swig_override[14]) {
    SWIG_JavaThrowException(JNIEnvWrapper(this).getJNIEnv(), SWIG_JavaDirectorPureVirtual, "Attempted to invoke pure virtual method ContactListener::onContactProcessed.");
    return;
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    *(btManifoldPoint **)&jcp = (btManifoldPoint *) &cp; 
    *((btCollisionObject **)&jcolObj0) = (btCollisionObject *) colObj0; 
    jmatch0 = (jboolean) match0;
    *((btCollisionObject **)&jcolObj1) = (btCollisionObject *) colObj1; 
    jmatch1 = (jboolean) match1;
    jenv->CallStaticVoidMethod(Swig::jclass_CollisionJNI, Swig::director_method_ids[51], swigjobj, jcp, jcolObj0, jmatch0, jcolObj1, jmatch1);
    jthrowable swigerror = jenv->ExceptionOccurred();
    if (swigerror) {
      jenv->ExceptionClear();
      throw Swig::DirectorException(jenv, swigerror);
    }
    
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object in ContactListener::onContactProcessed ");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
}

void SwigDirector_ContactListener::onContactProcessed(btManifoldPoint &cp, int userValue0, bool match0, int userValue1, bool match1) {
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  jlong jcp = 0 ;
  jint juserValue0  ;
  jboolean jmatch0  ;
  jint juserValue1  ;
  jboolean jmatch1  ;
  
  if (!swig_override[15]) {
    SWIG_JavaThrowException(JNIEnvWrapper(this).getJNIEnv(), SWIG_JavaDirectorPureVirtual, "Attempted to invoke pure virtual method ContactListener::onContactProcessed.");
    return;
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    *(btManifoldPoint **)&jcp = (btManifoldPoint *) &cp; 
    juserValue0 = (jint) userValue0;
    jmatch0 = (jboolean) match0;
    juserValue1 = (jint) userValue1;
    jmatch1 = (jboolean) match1;
    jenv->CallStaticVoidMethod(Swig::jclass_CollisionJNI, Swig::director_method_ids[52], swigjobj, jcp, juserValue0, jmatch0, juserValue1, jmatch1);
    jthrowable swigerror = jenv->ExceptionOccurred();
    if (swigerror) {
      jenv->ExceptionClear();
      throw Swig::DirectorException(jenv, swigerror);
    }
    
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object in ContactListener::onContactProcessed ");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
}

void SwigDirector_ContactListener::onContactProcessed(btCollisionObject const *colObj0, btCollisionObject const *colObj1) {
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  jlong jcolObj0 = 0 ;
  jlong jcolObj1 = 0 ;
  
  if (!swig_override[16]) {
    SWIG_JavaThrowException(JNIEnvWrapper(this).getJNIEnv(), SWIG_JavaDirectorPureVirtual, "Attempted to invoke pure virtual method ContactListener::onContactProcessed.");
    return;
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    *((btCollisionObject **)&jcolObj0) = (btCollisionObject *) colObj0; 
    *((btCollisionObject **)&jcolObj1) = (btCollisionObject *) colObj1; 
    jenv->CallStaticVoidMethod(Swig::jclass_CollisionJNI, Swig::director_method_ids[53], swigjobj, jcolObj0, jcolObj1);
    jthrowable swigerror = jenv->ExceptionOccurred();
    if (swigerror) {
      jenv->ExceptionClear();
      throw Swig::DirectorException(jenv, swigerror);
    }
    
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object in ContactListener::onContactProcessed ");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
}

void SwigDirector_ContactListener::onContactProcessed(int userValue0, int userValue1) {
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  jint juserValue0  ;
  jint juserValue1  ;
  
  if (!swig_override[17]) {
    SWIG_JavaThrowException(JNIEnvWrapper(this).getJNIEnv(), SWIG_JavaDirectorPureVirtual, "Attempted to invoke pure virtual method ContactListener::onContactProcessed.");
    return;
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    juserValue0 = (jint) userValue0;
    juserValue1 = (jint) userValue1;
    jenv->CallStaticVoidMethod(Swig::jclass_CollisionJNI, Swig::director_method_ids[54], swigjobj, juserValue0, juserValue1);
    jthrowable swigerror = jenv->ExceptionOccurred();
    if (swigerror) {
      jenv->ExceptionClear();
      throw Swig::DirectorException(jenv, swigerror);
    }
    
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object in ContactListener::onContactProcessed ");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
}

void SwigDirector_ContactListener::onContactProcessed(btCollisionObject const *colObj0, bool match0, btCollisionObject const *colObj1, bool match1) {
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  jlong jcolObj0 = 0 ;
  jboolean jmatch0  ;
  jlong jcolObj1 = 0 ;
  jboolean jmatch1  ;
  
  if (!swig_override[18]) {
    SWIG_JavaThrowException(JNIEnvWrapper(this).getJNIEnv(), SWIG_JavaDirectorPureVirtual, "Attempted to invoke pure virtual method ContactListener::onContactProcessed.");
    return;
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    *((btCollisionObject **)&jcolObj0) = (btCollisionObject *) colObj0; 
    jmatch0 = (jboolean) match0;
    *((btCollisionObject **)&jcolObj1) = (btCollisionObject *) colObj1; 
    jmatch1 = (jboolean) match1;
    jenv->CallStaticVoidMethod(Swig::jclass_CollisionJNI, Swig::director_method_ids[55], swigjobj, jcolObj0, jmatch0, jcolObj1, jmatch1);
    jthrowable swigerror = jenv->ExceptionOccurred();
    if (swigerror) {
      jenv->ExceptionClear();
      throw Swig::DirectorException(jenv, swigerror);
    }
    
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object in ContactListener::onContactProcessed ");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
}

void SwigDirector_ContactListener::onContactProcessed(int userValue0, bool match0, int userValue1, bool match1) {
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  jint juserValue0  ;
  jboolean jmatch0  ;
  jint juserValue1  ;
  jboolean jmatch1  ;
  
  if (!swig_override[19]) {
    SWIG_JavaThrowException(JNIEnvWrapper(this).getJNIEnv(), SWIG_JavaDirectorPureVirtual, "Attempted to invoke pure virtual method ContactListener::onContactProcessed.");
    return;
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    juserValue0 = (jint) userValue0;
    jmatch0 = (jboolean) match0;
    juserValue1 = (jint) userValue1;
    jmatch1 = (jboolean) match1;
    jenv->CallStaticVoidMethod(Swig::jclass_CollisionJNI, Swig::director_method_ids[56], swigjobj, juserValue0, jmatch0, juserValue1, jmatch1);
    jthrowable swigerror = jenv->ExceptionOccurred();
    if (swigerror) {
      jenv->ExceptionClear();
      throw Swig::DirectorException(jenv, swigerror);
    }
    
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object in ContactListener::onContactProcessed ");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
}

void SwigDirector_ContactListener::onContactDestroyed(int manifoldPointUserValue) {
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  jint jmanifoldPointUserValue  ;
  
  if (!swig_override[20]) {
    SWIG_JavaThrowException(JNIEnvWrapper(this).getJNIEnv(), SWIG_JavaDirectorPureVirtual, "Attempted to invoke pure virtual method ContactListener::onContactDestroyed.");
    return;
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    jmanifoldPointUserValue = (jint) manifoldPointUserValue;
    jenv->CallStaticVoidMethod(Swig::jclass_CollisionJNI, Swig::director_method_ids[57], swigjobj, jmanifoldPointUserValue);
    jthrowable swigerror = jenv->ExceptionOccurred();
    if (swigerror) {
      jenv->ExceptionClear();
      throw Swig::DirectorException(jenv, swigerror);
    }
    
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object in ContactListener::onContactDestroyed ");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
}

void SwigDirector_ContactListener::onContactStarted(btPersistentManifold *manifold) {
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  jlong jmanifold = 0 ;
  
  if (!swig_override[21]) {
    SWIG_JavaThrowException(JNIEnvWrapper(this).getJNIEnv(), SWIG_JavaDirectorPureVirtual, "Attempted to invoke pure virtual method ContactListener::onContactStarted.");
    return;
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    *((btPersistentManifold **)&jmanifold) = (btPersistentManifold *) manifold; 
    jenv->CallStaticVoidMethod(Swig::jclass_CollisionJNI, Swig::director_method_ids[58], swigjobj, jmanifold);
    jthrowable swigerror = jenv->ExceptionOccurred();
    if (swigerror) {
      jenv->ExceptionClear();
      throw Swig::DirectorException(jenv, swigerror);
    }
    
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object in ContactListener::onContactStarted ");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
}

void SwigDirector_ContactListener::onContactStarted(btCollisionObject const *colObj0, btCollisionObject const *colObj1) {
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  jlong jcolObj0 = 0 ;
  jlong jcolObj1 = 0 ;
  
  if (!swig_override[22]) {
    SWIG_JavaThrowException(JNIEnvWrapper(this).getJNIEnv(), SWIG_JavaDirectorPureVirtual, "Attempted to invoke pure virtual method ContactListener::onContactStarted.");
    return;
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    *((btCollisionObject **)&jcolObj0) = (btCollisionObject *) colObj0; 
    *((btCollisionObject **)&jcolObj1) = (btCollisionObject *) colObj1; 
    jenv->CallStaticVoidMethod(Swig::jclass_CollisionJNI, Swig::director_method_ids[59], swigjobj, jcolObj0, jcolObj1);
    jthrowable swigerror = jenv->ExceptionOccurred();
    if (swigerror) {
      jenv->ExceptionClear();
      throw Swig::DirectorException(jenv, swigerror);
    }
    
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object in ContactListener::onContactStarted ");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
}

void SwigDirector_ContactListener::onContactStarted(int const &userValue0, int const &userValue1) {
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  jint juserValue0 = 0 ;
  jint juserValue1 = 0 ;
  
  if (!swig_override[23]) {
    SWIG_JavaThrowException(JNIEnvWrapper(this).getJNIEnv(), SWIG_JavaDirectorPureVirtual, "Attempted to invoke pure virtual method ContactListener::onContactStarted.");
    return;
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    juserValue0 = (jint)userValue0;
    juserValue1 = (jint)userValue1;
    jenv->CallStaticVoidMethod(Swig::jclass_CollisionJNI, Swig::director_method_ids[60], swigjobj, juserValue0, juserValue1);
    jthrowable swigerror = jenv->ExceptionOccurred();
    if (swigerror) {
      jenv->ExceptionClear();
      throw Swig::DirectorException(jenv, swigerror);
    }
    
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object in ContactListener::onContactStarted ");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
}

void SwigDirector_ContactListener::onContactStarted(btPersistentManifold *manifold, bool const &match0, bool const &match1) {
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  jlong jmanifold = 0 ;
  jboolean jmatch0 = 0 ;
  jboolean jmatch1 = 0 ;
  
  if (!swig_override[24]) {
    SWIG_JavaThrowException(JNIEnvWrapper(this).getJNIEnv(), SWIG_JavaDirectorPureVirtual, "Attempted to invoke pure virtual method ContactListener::onContactStarted.");
    return;
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    *((btPersistentManifold **)&jmanifold) = (btPersistentManifold *) manifold; 
    jmatch0 = (jboolean)match0;
    jmatch1 = (jboolean)match1;
    jenv->CallStaticVoidMethod(Swig::jclass_CollisionJNI, Swig::director_method_ids[61], swigjobj, jmanifold, jmatch0, jmatch1);
    jthrowable swigerror = jenv->ExceptionOccurred();
    if (swigerror) {
      jenv->ExceptionClear();
      throw Swig::DirectorException(jenv, swigerror);
    }
    
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object in ContactListener::onContactStarted ");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
}

void SwigDirector_ContactListener::onContactStarted(btCollisionObject const *colObj0, bool const &match0, btCollisionObject const *colObj1, bool const &match1) {
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  jlong jcolObj0 = 0 ;
  jboolean jmatch0 = 0 ;
  jlong jcolObj1 = 0 ;
  jboolean jmatch1 = 0 ;
  
  if (!swig_override[25]) {
    SWIG_JavaThrowException(JNIEnvWrapper(this).getJNIEnv(), SWIG_JavaDirectorPureVirtual, "Attempted to invoke pure virtual method ContactListener::onContactStarted.");
    return;
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    *((btCollisionObject **)&jcolObj0) = (btCollisionObject *) colObj0; 
    jmatch0 = (jboolean)match0;
    *((btCollisionObject **)&jcolObj1) = (btCollisionObject *) colObj1; 
    jmatch1 = (jboolean)match1;
    jenv->CallStaticVoidMethod(Swig::jclass_CollisionJNI, Swig::director_method_ids[62], swigjobj, jcolObj0, jmatch0, jcolObj1, jmatch1);
    jthrowable swigerror = jenv->ExceptionOccurred();
    if (swigerror) {
      jenv->ExceptionClear();
      throw Swig::DirectorException(jenv, swigerror);
    }
    
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object in ContactListener::onContactStarted ");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
}

void SwigDirector_ContactListener::onContactStarted(int const &userValue0, bool const &match0, int const &userValue1, bool const &match1) {
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  jint juserValue0 = 0 ;
  jboolean jmatch0 = 0 ;
  jint juserValue1 = 0 ;
  jboolean jmatch1 = 0 ;
  
  if (!swig_override[26]) {
    SWIG_JavaThrowException(JNIEnvWrapper(this).getJNIEnv(), SWIG_JavaDirectorPureVirtual, "Attempted to invoke pure virtual method ContactListener::onContactStarted.");
    return;
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    juserValue0 = (jint)userValue0;
    jmatch0 = (jboolean)match0;
    juserValue1 = (jint)userValue1;
    jmatch1 = (jboolean)match1;
    jenv->CallStaticVoidMethod(Swig::jclass_CollisionJNI, Swig::director_method_ids[63], swigjobj, juserValue0, jmatch0, juserValue1, jmatch1);
    jthrowable swigerror = jenv->ExceptionOccurred();
    if (swigerror) {
      jenv->ExceptionClear();
      throw Swig::DirectorException(jenv, swigerror);
    }
    
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object in ContactListener::onContactStarted ");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
}

void SwigDirector_ContactListener::onContactEnded(btPersistentManifold *manifold) {
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  jlong jmanifold = 0 ;
  
  if (!swig_override[27]) {
    SWIG_JavaThrowException(JNIEnvWrapper(this).getJNIEnv(), SWIG_JavaDirectorPureVirtual, "Attempted to invoke pure virtual method ContactListener::onContactEnded.");
    return;
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    *((btPersistentManifold **)&jmanifold) = (btPersistentManifold *) manifold; 
    jenv->CallStaticVoidMethod(Swig::jclass_CollisionJNI, Swig::director_method_ids[64], swigjobj, jmanifold);
    jthrowable swigerror = jenv->ExceptionOccurred();
    if (swigerror) {
      jenv->ExceptionClear();
      throw Swig::DirectorException(jenv, swigerror);
    }
    
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object in ContactListener::onContactEnded ");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
}

void SwigDirector_ContactListener::onContactEnded(btCollisionObject const *colObj0, btCollisionObject const *colObj1) {
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  jlong jcolObj0 = 0 ;
  jlong jcolObj1 = 0 ;
  
  if (!swig_override[28]) {
    SWIG_JavaThrowException(JNIEnvWrapper(this).getJNIEnv(), SWIG_JavaDirectorPureVirtual, "Attempted to invoke pure virtual method ContactListener::onContactEnded.");
    return;
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    *((btCollisionObject **)&jcolObj0) = (btCollisionObject *) colObj0; 
    *((btCollisionObject **)&jcolObj1) = (btCollisionObject *) colObj1; 
    jenv->CallStaticVoidMethod(Swig::jclass_CollisionJNI, Swig::director_method_ids[65], swigjobj, jcolObj0, jcolObj1);
    jthrowable swigerror = jenv->ExceptionOccurred();
    if (swigerror) {
      jenv->ExceptionClear();
      throw Swig::DirectorException(jenv, swigerror);
    }
    
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object in ContactListener::onContactEnded ");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
}

void SwigDirector_ContactListener::onContactEnded(int const &userValue0, int const &userValue1) {
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  jint juserValue0 = 0 ;
  jint juserValue1 = 0 ;
  
  if (!swig_override[29]) {
    SWIG_JavaThrowException(JNIEnvWrapper(this).getJNIEnv(), SWIG_JavaDirectorPureVirtual, "Attempted to invoke pure virtual method ContactListener::onContactEnded.");
    return;
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    juserValue0 = (jint)userValue0;
    juserValue1 = (jint)userValue1;
    jenv->CallStaticVoidMethod(Swig::jclass_CollisionJNI, Swig::director_method_ids[66], swigjobj, juserValue0, juserValue1);
    jthrowable swigerror = jenv->ExceptionOccurred();
    if (swigerror) {
      jenv->ExceptionClear();
      throw Swig::DirectorException(jenv, swigerror);
    }
    
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object in ContactListener::onContactEnded ");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
}

void SwigDirector_ContactListener::onContactEnded(btPersistentManifold *manifold, bool const &match0, bool const &match1) {
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  jlong jmanifold = 0 ;
  jboolean jmatch0 = 0 ;
  jboolean jmatch1 = 0 ;
  
  if (!swig_override[30]) {
    SWIG_JavaThrowException(JNIEnvWrapper(this).getJNIEnv(), SWIG_JavaDirectorPureVirtual, "Attempted to invoke pure virtual method ContactListener::onContactEnded.");
    return;
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    *((btPersistentManifold **)&jmanifold) = (btPersistentManifold *) manifold; 
    jmatch0 = (jboolean)match0;
    jmatch1 = (jboolean)match1;
    jenv->CallStaticVoidMethod(Swig::jclass_CollisionJNI, Swig::director_method_ids[67], swigjobj, jmanifold, jmatch0, jmatch1);
    jthrowable swigerror = jenv->ExceptionOccurred();
    if (swigerror) {
      jenv->ExceptionClear();
      throw Swig::DirectorException(jenv, swigerror);
    }
    
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object in ContactListener::onContactEnded ");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
}

void SwigDirector_ContactListener::onContactEnded(btCollisionObject const *colObj0, bool const &match0, btCollisionObject const *colObj1, bool const &match1) {
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  jlong jcolObj0 = 0 ;
  jboolean jmatch0 = 0 ;
  jlong jcolObj1 = 0 ;
  jboolean jmatch1 = 0 ;
  
  if (!swig_override[31]) {
    SWIG_JavaThrowException(JNIEnvWrapper(this).getJNIEnv(), SWIG_JavaDirectorPureVirtual, "Attempted to invoke pure virtual method ContactListener::onContactEnded.");
    return;
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    *((btCollisionObject **)&jcolObj0) = (btCollisionObject *) colObj0; 
    jmatch0 = (jboolean)match0;
    *((btCollisionObject **)&jcolObj1) = (btCollisionObject *) colObj1; 
    jmatch1 = (jboolean)match1;
    jenv->CallStaticVoidMethod(Swig::jclass_CollisionJNI, Swig::director_method_ids[68], swigjobj, jcolObj0, jmatch0, jcolObj1, jmatch1);
    jthrowable swigerror = jenv->ExceptionOccurred();
    if (swigerror) {
      jenv->ExceptionClear();
      throw Swig::DirectorException(jenv, swigerror);
    }
    
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object in ContactListener::onContactEnded ");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
}

void SwigDirector_ContactListener::onContactEnded(int const &userValue0, bool const &match0, int const &userValue1, bool const &match1) {
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  jint juserValue0 = 0 ;
  jboolean jmatch0 = 0 ;
  jint juserValue1 = 0 ;
  jboolean jmatch1 = 0 ;
  
  if (!swig_override[32]) {
    SWIG_JavaThrowException(JNIEnvWrapper(this).getJNIEnv(), SWIG_JavaDirectorPureVirtual, "Attempted to invoke pure virtual method ContactListener::onContactEnded.");
    return;
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    juserValue0 = (jint)userValue0;
    jmatch0 = (jboolean)match0;
    juserValue1 = (jint)userValue1;
    jmatch1 = (jboolean)match1;
    jenv->CallStaticVoidMethod(Swig::jclass_CollisionJNI, Swig::director_method_ids[69], swigjobj, juserValue0, jmatch0, juserValue1, jmatch1);
    jthrowable swigerror = jenv->ExceptionOccurred();
    if (swigerror) {
      jenv->ExceptionClear();
      throw Swig::DirectorException(jenv, swigerror);
    }
    
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object in ContactListener::onContactEnded ");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
}

void SwigDirector_ContactListener::swig_connect_director(JNIEnv *jenv, jobject jself, jclass jcls, bool swig_mem_own, bool weak_global) {
  static struct {
    const char *mname;
    const char *mdesc;
    jmethodID base_methid;
  } methods[] = {
    {
      "onContactAdded", "(Lcom/badlogic/gdx/physics/bullet/collision/btManifoldPoint;Lcom/badlogic/gdx/physics/bullet/collision/btCollisionObjectWrapper;IILcom/badlogic/gdx/physics/bullet/collision/btCollisionObjectWrapper;II)Z", NULL 
    },
    {
      "onContactAdded", "(Lcom/badlogic/gdx/physics/bullet/collision/btManifoldPoint;Lcom/badlogic/gdx/physics/bullet/collision/btCollisionObject;IILcom/badlogic/gdx/physics/bullet/collision/btCollisionObject;II)Z", NULL 
    },
    {
      "onContactAdded", "(Lcom/badlogic/gdx/physics/bullet/collision/btManifoldPoint;IIIIII)Z", NULL 
    },
    {
      "onContactAdded", "(Lcom/badlogic/gdx/physics/bullet/collision/btManifoldPoint;Lcom/badlogic/gdx/physics/bullet/collision/btCollisionObjectWrapper;IIZLcom/badlogic/gdx/physics/bullet/collision/btCollisionObjectWrapper;IIZ)Z", NULL 
    },
    {
      "onContactAdded", "(Lcom/badlogic/gdx/physics/bullet/collision/btManifoldPoint;Lcom/badlogic/gdx/physics/bullet/collision/btCollisionObject;IIZLcom/badlogic/gdx/physics/bullet/collision/btCollisionObject;IIZ)Z", NULL 
    },
    {
      "onContactAdded", "(Lcom/badlogic/gdx/physics/bullet/collision/btManifoldPoint;IIIZIIIZ)Z", NULL 
    },
    {
      "onContactAdded", "(Lcom/badlogic/gdx/physics/bullet/collision/btCollisionObjectWrapper;IILcom/badlogic/gdx/physics/bullet/collision/btCollisionObjectWrapper;II)Z", NULL 
    },
    {
      "onContactAdded", "(Lcom/badlogic/gdx/physics/bullet/collision/btCollisionObject;IILcom/badlogic/gdx/physics/bullet/collision/btCollisionObject;II)Z", NULL 
    },
    {
      "onContactAdded", "(IIIIII)Z", NULL 
    },
    {
      "onContactAdded", "(Lcom/badlogic/gdx/physics/bullet/collision/btCollisionObjectWrapper;IIZLcom/badlogic/gdx/physics/bullet/collision/btCollisionObjectWrapper;IIZ)Z", NULL 
    },
    {
      "onContactAdded", "(Lcom/badlogic/gdx/physics/bullet/collision/btCollisionObject;IIZLcom/badlogic/gdx/physics/bullet/collision/btCollisionObject;IIZ)Z", NULL 
    },
    {
      "onContactAdded", "(IIIZIIIZ)Z", NULL 
    },
    {
      "onContactProcessed", "(Lcom/badlogic/gdx/physics/bullet/collision/btManifoldPoint;Lcom/badlogic/gdx/physics/bullet/collision/btCollisionObject;Lcom/badlogic/gdx/physics/bullet/collision/btCollisionObject;)V", NULL 
    },
    {
      "onContactProcessed", "(Lcom/badlogic/gdx/physics/bullet/collision/btManifoldPoint;II)V", NULL 
    },
    {
      "onContactProcessed", "(Lcom/badlogic/gdx/physics/bullet/collision/btManifoldPoint;Lcom/badlogic/gdx/physics/bullet/collision/btCollisionObject;ZLcom/badlogic/gdx/physics/bullet/collision/btCollisionObject;Z)V", NULL 
    },
    {
      "onContactProcessed", "(Lcom/badlogic/gdx/physics/bullet/collision/btManifoldPoint;IZIZ)V", NULL 
    },
    {
      "onContactProcessed", "(Lcom/badlogic/gdx/physics/bullet/collision/btCollisionObject;Lcom/badlogic/gdx/physics/bullet/collision/btCollisionObject;)V", NULL 
    },
    {
      "onContactProcessed", "(II)V", NULL 
    },
    {
      "onContactProcessed", "(Lcom/badlogic/gdx/physics/bullet/collision/btCollisionObject;ZLcom/badlogic/gdx/physics/bullet/collision/btCollisionObject;Z)V", NULL 
    },
    {
      "onContactProcessed", "(IZIZ)V", NULL 
    },
    {
      "onContactDestroyed", "(I)V", NULL 
    },
    {
      "onContactStarted", "(Lcom/badlogic/gdx/physics/bullet/collision/btPersistentManifold;)V", NULL 
    },
    {
      "onContactStarted", "(Lcom/badlogic/gdx/physics/bullet/collision/btCollisionObject;Lcom/badlogic/gdx/physics/bullet/collision/btCollisionObject;)V", NULL 
    },
    {
      "onContactStarted", "(II)V", NULL 
    },
    {
      "onContactStarted", "(Lcom/badlogic/gdx/physics/bullet/collision/btPersistentManifold;ZZ)V", NULL 
    },
    {
      "onContactStarted", "(Lcom/badlogic/gdx/physics/bullet/collision/btCollisionObject;ZLcom/badlogic/gdx/physics/bullet/collision/btCollisionObject;Z)V", NULL 
    },
    {
      "onContactStarted", "(IZIZ)V", NULL 
    },
    {
      "onContactEnded", "(Lcom/badlogic/gdx/physics/bullet/collision/btPersistentManifold;)V", NULL 
    },
    {
      "onContactEnded", "(Lcom/badlogic/gdx/physics/bullet/collision/btCollisionObject;Lcom/badlogic/gdx/physics/bullet/collision/btCollisionObject;)V", NULL 
    },
    {
      "onContactEnded", "(II)V", NULL 
    },
    {
      "onContactEnded", "(Lcom/badlogic/gdx/physics/bullet/collision/btPersistentManifold;ZZ)V", NULL 
    },
    {
      "onContactEnded", "(Lcom/badlogic/gdx/physics/bullet/collision/btCollisionObject;ZLcom/badlogic/gdx/physics/bullet/collision/btCollisionObject;Z)V", NULL 
    },
    {
      "onContactEnded", "(IZIZ)V", NULL 
    }
  };
  
  static jclass baseclass = 0 ;
  
  if (swig_set_self(jenv, jself, swig_mem_own, weak_global)) {
    if (!baseclass) {
      baseclass = jenv->FindClass("com/badlogic/gdx/physics/bullet/collision/ContactListener");
      if (!baseclass) return;
      baseclass = (jclass) jenv->NewGlobalRef(baseclass);
    }
    bool derived = (jenv->IsSameObject(baseclass, jcls) ? false : true);
    for (int i = 0; i < 33; ++i) {
      if (!methods[i].base_methid) {
        methods[i].base_methid = jenv->GetMethodID(baseclass, methods[i].mname, methods[i].mdesc);
        if (!methods[i].base_methid) return;
      }
      swig_override[i] = false;
      if (derived) {
        jmethodID methid = jenv->GetMethodID(jcls, methods[i].mname, methods[i].mdesc);
        swig_override[i] = (methid != methods[i].base_methid);
        jenv->ExceptionClear();
      }
    }
  }
}


SwigDirector_ContactCache::SwigDirector_ContactCache(JNIEnv *jenv, bool dummy) : ContactCache(dummy), Swig::Director(jenv) {
}

SwigDirector_ContactCache::~SwigDirector_ContactCache() {
  swig_disconnect_director_self("swigDirectorDisconnect");
}


void SwigDirector_ContactCache::onContactStarted(btPersistentManifold *manifold, bool const &match0, bool const &match1) {
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  jlong jmanifold = 0 ;
  jboolean jmatch0 = 0 ;
  jboolean jmatch1 = 0 ;
  
  if (!swig_override[0]) {
    SWIG_JavaThrowException(JNIEnvWrapper(this).getJNIEnv(), SWIG_JavaDirectorPureVirtual, "Attempted to invoke pure virtual method ContactCache::onContactStarted.");
    return;
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    *((btPersistentManifold **)&jmanifold) = (btPersistentManifold *) manifold; 
    jmatch0 = (jboolean)match0;
    jmatch1 = (jboolean)match1;
    jenv->CallStaticVoidMethod(Swig::jclass_CollisionJNI, Swig::director_method_ids[70], swigjobj, jmanifold, jmatch0, jmatch1);
    jthrowable swigerror = jenv->ExceptionOccurred();
    if (swigerror) {
      jenv->ExceptionClear();
      throw Swig::DirectorException(jenv, swigerror);
    }
    
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object in ContactCache::onContactStarted ");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
}

void SwigDirector_ContactCache::onContactEnded(btCollisionObject const *colObj0, bool const &match0, btCollisionObject const *colObj1, bool const &match1) {
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  jlong jcolObj0 = 0 ;
  jboolean jmatch0 = 0 ;
  jlong jcolObj1 = 0 ;
  jboolean jmatch1 = 0 ;
  
  if (!swig_override[1]) {
    SWIG_JavaThrowException(JNIEnvWrapper(this).getJNIEnv(), SWIG_JavaDirectorPureVirtual, "Attempted to invoke pure virtual method ContactCache::onContactEnded.");
    return;
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    *((btCollisionObject **)&jcolObj0) = (btCollisionObject *) colObj0; 
    jmatch0 = (jboolean)match0;
    *((btCollisionObject **)&jcolObj1) = (btCollisionObject *) colObj1; 
    jmatch1 = (jboolean)match1;
    jenv->CallStaticVoidMethod(Swig::jclass_CollisionJNI, Swig::director_method_ids[71], swigjobj, jcolObj0, jmatch0, jcolObj1, jmatch1);
    jthrowable swigerror = jenv->ExceptionOccurred();
    if (swigerror) {
      jenv->ExceptionClear();
      throw Swig::DirectorException(jenv, swigerror);
    }
    
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object in ContactCache::onContactEnded ");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
}

void SwigDirector_ContactCache::swig_connect_director(JNIEnv *jenv, jobject jself, jclass jcls, bool swig_mem_own, bool weak_global) {
  static struct {
    const char *mname;
    const char *mdesc;
    jmethodID base_methid;
  } methods[] = {
    {
      "onContactStarted", "(Lcom/badlogic/gdx/physics/bullet/collision/btPersistentManifold;ZZ)V", NULL 
    },
    {
      "onContactEnded", "(Lcom/badlogic/gdx/physics/bullet/collision/btCollisionObject;ZLcom/badlogic/gdx/physics/bullet/collision/btCollisionObject;Z)V", NULL 
    }
  };
  
  static jclass baseclass = 0 ;
  
  if (swig_set_self(jenv, jself, swig_mem_own, weak_global)) {
    if (!baseclass) {
      baseclass = jenv->FindClass("com/badlogic/gdx/physics/bullet/collision/ContactCache");
      if (!baseclass) return;
      baseclass = (jclass) jenv->NewGlobalRef(baseclass);
    }
    bool derived = (jenv->IsSameObject(baseclass, jcls) ? false : true);
    for (int i = 0; i < 2; ++i) {
      if (!methods[i].base_methid) {
        methods[i].base_methid = jenv->GetMethodID(baseclass, methods[i].mname, methods[i].mdesc);
        if (!methods[i].base_methid) return;
      }
      swig_override[i] = false;
      if (derived) {
        jmethodID methid = jenv->GetMethodID(jcls, methods[i].mname, methods[i].mdesc);
        swig_override[i] = (methid != methods[i].base_methid);
        jenv->ExceptionClear();
      }
    }
  }
}



#ifdef __cplusplus
extern "C" {
#endif

SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_delete_1btDiscreteCollisionDetectorInterface_1Result(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  btDiscreteCollisionDetectorInterface::Result *arg1 = (btDiscreteCollisionDetectorInterface::Result *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(btDiscreteCollisionDetectorInterface::Result **)&jarg1; 
  delete arg1;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btDiscreteCollisionDetectorInterface_1Result_1setShapeIdentifiersA(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jint jarg3) {
  btDiscreteCollisionDetectorInterface::Result *arg1 = (btDiscreteCollisionDetectorInterface::Result *) 0 ;
  int arg2 ;
  int arg3 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btDiscreteCollisionDetectorInterface::Result **)&jarg1; 
  arg2 = (int)jarg2; 
  arg3 = (int)jarg3; 
  (arg1)->setShapeIdentifiersA(arg2,arg3);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btDiscreteCollisionDetectorInterface_1Result_1setShapeIdentifiersB(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jint jarg3) {
  btDiscreteCollisionDetectorInterface::Result *arg1 = (btDiscreteCollisionDetectorInterface::Result *) 0 ;
  int arg2 ;
  int arg3 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btDiscreteCollisionDetectorInterface::Result **)&jarg1; 
  arg2 = (int)jarg2; 
  arg3 = (int)jarg3; 
  (arg1)->setShapeIdentifiersB(arg2,arg3);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btDiscreteCollisionDetectorInterface_1Result_1addContactPoint(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2, jobject jarg3, jfloat jarg4) {
  btDiscreteCollisionDetectorInterface::Result *arg1 = (btDiscreteCollisionDetectorInterface::Result *) 0 ;
  btVector3 *arg2 = 0 ;
  btVector3 *arg3 = 0 ;
  btScalar arg4 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btDiscreteCollisionDetectorInterface::Result **)&jarg1; 
  btVector3 local_arg2;
  gdx_setbtVector3FromVector3(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitVector3 auto_commit_arg2(jenv, jarg2, &local_arg2);
  btVector3 local_arg3;
  gdx_setbtVector3FromVector3(jenv, local_arg3, jarg3);
  arg3 = &local_arg3;
  gdxAutoCommitVector3 auto_commit_arg3(jenv, jarg3, &local_arg3);
  arg4 = (btScalar)jarg4; 
  (arg1)->addContactPoint((btVector3 const &)*arg2,(btVector3 const &)*arg3,arg4);
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_new_1btDiscreteCollisionDetectorInterface_1ClosestPointInput(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  btDiscreteCollisionDetectorInterface::ClosestPointInput *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (btDiscreteCollisionDetectorInterface::ClosestPointInput *)new btDiscreteCollisionDetectorInterface::ClosestPointInput();
  *(btDiscreteCollisionDetectorInterface::ClosestPointInput **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btDiscreteCollisionDetectorInterface_1ClosestPointInput_1transformA_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btDiscreteCollisionDetectorInterface::ClosestPointInput *arg1 = (btDiscreteCollisionDetectorInterface::ClosestPointInput *) 0 ;
  btTransform *arg2 = (btTransform *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btDiscreteCollisionDetectorInterface::ClosestPointInput **)&jarg1; 
  arg2 = *(btTransform **)&jarg2; 
  if (arg1) (arg1)->m_transformA = *arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btDiscreteCollisionDetectorInterface_1ClosestPointInput_1transformA_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btDiscreteCollisionDetectorInterface::ClosestPointInput *arg1 = (btDiscreteCollisionDetectorInterface::ClosestPointInput *) 0 ;
  btTransform *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btDiscreteCollisionDetectorInterface::ClosestPointInput **)&jarg1; 
  result = (btTransform *)& ((arg1)->m_transformA);
  *(btTransform **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btDiscreteCollisionDetectorInterface_1ClosestPointInput_1transformB_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btDiscreteCollisionDetectorInterface::ClosestPointInput *arg1 = (btDiscreteCollisionDetectorInterface::ClosestPointInput *) 0 ;
  btTransform *arg2 = (btTransform *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btDiscreteCollisionDetectorInterface::ClosestPointInput **)&jarg1; 
  arg2 = *(btTransform **)&jarg2; 
  if (arg1) (arg1)->m_transformB = *arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btDiscreteCollisionDetectorInterface_1ClosestPointInput_1transformB_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btDiscreteCollisionDetectorInterface::ClosestPointInput *arg1 = (btDiscreteCollisionDetectorInterface::ClosestPointInput *) 0 ;
  btTransform *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btDiscreteCollisionDetectorInterface::ClosestPointInput **)&jarg1; 
  result = (btTransform *)& ((arg1)->m_transformB);
  *(btTransform **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btDiscreteCollisionDetectorInterface_1ClosestPointInput_1maximumDistanceSquared_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2) {
  btDiscreteCollisionDetectorInterface::ClosestPointInput *arg1 = (btDiscreteCollisionDetectorInterface::ClosestPointInput *) 0 ;
  btScalar arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btDiscreteCollisionDetectorInterface::ClosestPointInput **)&jarg1; 
  arg2 = (btScalar)jarg2; 
  if (arg1) (arg1)->m_maximumDistanceSquared = arg2;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btDiscreteCollisionDetectorInterface_1ClosestPointInput_1maximumDistanceSquared_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jfloat jresult = 0 ;
  btDiscreteCollisionDetectorInterface::ClosestPointInput *arg1 = (btDiscreteCollisionDetectorInterface::ClosestPointInput *) 0 ;
  btScalar result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btDiscreteCollisionDetectorInterface::ClosestPointInput **)&jarg1; 
  result = (btScalar) ((arg1)->m_maximumDistanceSquared);
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_delete_1btDiscreteCollisionDetectorInterface_1ClosestPointInput(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  btDiscreteCollisionDetectorInterface::ClosestPointInput *arg1 = (btDiscreteCollisionDetectorInterface::ClosestPointInput *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(btDiscreteCollisionDetectorInterface::ClosestPointInput **)&jarg1; 
  delete arg1;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_delete_1btDiscreteCollisionDetectorInterface(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  btDiscreteCollisionDetectorInterface *arg1 = (btDiscreteCollisionDetectorInterface *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(btDiscreteCollisionDetectorInterface **)&jarg1; 
  delete arg1;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btDiscreteCollisionDetectorInterface_1getClosestPoints_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlong jarg3, jobject jarg3_, jlong jarg4, jobject jarg4_, jboolean jarg5) {
  btDiscreteCollisionDetectorInterface *arg1 = (btDiscreteCollisionDetectorInterface *) 0 ;
  btDiscreteCollisionDetectorInterface::ClosestPointInput *arg2 = 0 ;
  btDiscreteCollisionDetectorInterface::Result *arg3 = 0 ;
  btIDebugDraw *arg4 = (btIDebugDraw *) 0 ;
  bool arg5 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  (void)jarg3_;
  (void)jarg4_;
  arg1 = *(btDiscreteCollisionDetectorInterface **)&jarg1; 
  arg2 = *(btDiscreteCollisionDetectorInterface::ClosestPointInput **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btDiscreteCollisionDetectorInterface::ClosestPointInput const & reference is null");
    return ;
  } 
  arg3 = *(btDiscreteCollisionDetectorInterface::Result **)&jarg3;
  if (!arg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btDiscreteCollisionDetectorInterface::Result & reference is null");
    return ;
  } 
  arg4 = *(btIDebugDraw **)&jarg4; 
  arg5 = jarg5 ? true : false; 
  (arg1)->getClosestPoints((btDiscreteCollisionDetectorInterface::ClosestPointInput const &)*arg2,*arg3,arg4,arg5);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btDiscreteCollisionDetectorInterface_1getClosestPoints_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlong jarg3, jobject jarg3_, jlong jarg4, jobject jarg4_) {
  btDiscreteCollisionDetectorInterface *arg1 = (btDiscreteCollisionDetectorInterface *) 0 ;
  btDiscreteCollisionDetectorInterface::ClosestPointInput *arg2 = 0 ;
  btDiscreteCollisionDetectorInterface::Result *arg3 = 0 ;
  btIDebugDraw *arg4 = (btIDebugDraw *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  (void)jarg3_;
  (void)jarg4_;
  arg1 = *(btDiscreteCollisionDetectorInterface **)&jarg1; 
  arg2 = *(btDiscreteCollisionDetectorInterface::ClosestPointInput **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btDiscreteCollisionDetectorInterface::ClosestPointInput const & reference is null");
    return ;
  } 
  arg3 = *(btDiscreteCollisionDetectorInterface::Result **)&jarg3;
  if (!arg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btDiscreteCollisionDetectorInterface::Result & reference is null");
    return ;
  } 
  arg4 = *(btIDebugDraw **)&jarg4; 
  (arg1)->getClosestPoints((btDiscreteCollisionDetectorInterface::ClosestPointInput const &)*arg2,*arg3,arg4);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btStorageResult_1normalOnSurfaceB_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btStorageResult *arg1 = (btStorageResult *) 0 ;
  btVector3 *arg2 = (btVector3 *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btStorageResult **)&jarg1; 
  arg2 = *(btVector3 **)&jarg2; 
  if (arg1) (arg1)->m_normalOnSurfaceB = *arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btStorageResult_1normalOnSurfaceB_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btStorageResult *arg1 = (btStorageResult *) 0 ;
  btVector3 *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btStorageResult **)&jarg1; 
  result = (btVector3 *)& ((arg1)->m_normalOnSurfaceB);
  *(btVector3 **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btStorageResult_1closestPointInB_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btStorageResult *arg1 = (btStorageResult *) 0 ;
  btVector3 *arg2 = (btVector3 *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btStorageResult **)&jarg1; 
  arg2 = *(btVector3 **)&jarg2; 
  if (arg1) (arg1)->m_closestPointInB = *arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btStorageResult_1closestPointInB_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btStorageResult *arg1 = (btStorageResult *) 0 ;
  btVector3 *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btStorageResult **)&jarg1; 
  result = (btVector3 *)& ((arg1)->m_closestPointInB);
  *(btVector3 **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btStorageResult_1distance_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2) {
  btStorageResult *arg1 = (btStorageResult *) 0 ;
  btScalar arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btStorageResult **)&jarg1; 
  arg2 = (btScalar)jarg2; 
  if (arg1) (arg1)->m_distance = arg2;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btStorageResult_1distance_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jfloat jresult = 0 ;
  btStorageResult *arg1 = (btStorageResult *) 0 ;
  btScalar result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btStorageResult **)&jarg1; 
  result = (btScalar) ((arg1)->m_distance);
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_delete_1btStorageResult(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  btStorageResult *arg1 = (btStorageResult *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(btStorageResult **)&jarg1; 
  delete arg1;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btBroadphaseProxy_1clientObject_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  btBroadphaseProxy *arg1 = (btBroadphaseProxy *) 0 ;
  void *arg2 = (void *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btBroadphaseProxy **)&jarg1; 
  arg2 = (void *)jarg2; 
  if (arg1) (arg1)->m_clientObject = arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btBroadphaseProxy_1clientObject_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btBroadphaseProxy *arg1 = (btBroadphaseProxy *) 0 ;
  void *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btBroadphaseProxy **)&jarg1; 
  result = (void *) ((arg1)->m_clientObject);
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btBroadphaseProxy_1collisionFilterGroup_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jshort jarg2) {
  btBroadphaseProxy *arg1 = (btBroadphaseProxy *) 0 ;
  short arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btBroadphaseProxy **)&jarg1; 
  arg2 = (short)jarg2; 
  if (arg1) (arg1)->m_collisionFilterGroup = arg2;
}


SWIGEXPORT jshort JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btBroadphaseProxy_1collisionFilterGroup_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jshort jresult = 0 ;
  btBroadphaseProxy *arg1 = (btBroadphaseProxy *) 0 ;
  short result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btBroadphaseProxy **)&jarg1; 
  result = (short) ((arg1)->m_collisionFilterGroup);
  jresult = (jshort)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btBroadphaseProxy_1collisionFilterMask_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jshort jarg2) {
  btBroadphaseProxy *arg1 = (btBroadphaseProxy *) 0 ;
  short arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btBroadphaseProxy **)&jarg1; 
  arg2 = (short)jarg2; 
  if (arg1) (arg1)->m_collisionFilterMask = arg2;
}


SWIGEXPORT jshort JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btBroadphaseProxy_1collisionFilterMask_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jshort jresult = 0 ;
  btBroadphaseProxy *arg1 = (btBroadphaseProxy *) 0 ;
  short result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btBroadphaseProxy **)&jarg1; 
  result = (short) ((arg1)->m_collisionFilterMask);
  jresult = (jshort)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btBroadphaseProxy_1multiSapParentProxy_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  btBroadphaseProxy *arg1 = (btBroadphaseProxy *) 0 ;
  void *arg2 = (void *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btBroadphaseProxy **)&jarg1; 
  arg2 = (void *)jarg2; 
  if (arg1) (arg1)->m_multiSapParentProxy = arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btBroadphaseProxy_1multiSapParentProxy_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btBroadphaseProxy *arg1 = (btBroadphaseProxy *) 0 ;
  void *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btBroadphaseProxy **)&jarg1; 
  result = (void *) ((arg1)->m_multiSapParentProxy);
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btBroadphaseProxy_1uniqueId_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  btBroadphaseProxy *arg1 = (btBroadphaseProxy *) 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btBroadphaseProxy **)&jarg1; 
  arg2 = (int)jarg2; 
  if (arg1) (arg1)->m_uniqueId = arg2;
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btBroadphaseProxy_1uniqueId_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  btBroadphaseProxy *arg1 = (btBroadphaseProxy *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btBroadphaseProxy **)&jarg1; 
  result = (int) ((arg1)->m_uniqueId);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btBroadphaseProxy_1aabbMin_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btBroadphaseProxy *arg1 = (btBroadphaseProxy *) 0 ;
  btVector3 *arg2 = (btVector3 *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btBroadphaseProxy **)&jarg1; 
  arg2 = *(btVector3 **)&jarg2; 
  if (arg1) (arg1)->m_aabbMin = *arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btBroadphaseProxy_1aabbMin_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btBroadphaseProxy *arg1 = (btBroadphaseProxy *) 0 ;
  btVector3 *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btBroadphaseProxy **)&jarg1; 
  result = (btVector3 *)& ((arg1)->m_aabbMin);
  *(btVector3 **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btBroadphaseProxy_1aabbMax_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btBroadphaseProxy *arg1 = (btBroadphaseProxy *) 0 ;
  btVector3 *arg2 = (btVector3 *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btBroadphaseProxy **)&jarg1; 
  arg2 = *(btVector3 **)&jarg2; 
  if (arg1) (arg1)->m_aabbMax = *arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btBroadphaseProxy_1aabbMax_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btBroadphaseProxy *arg1 = (btBroadphaseProxy *) 0 ;
  btVector3 *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btBroadphaseProxy **)&jarg1; 
  result = (btVector3 *)& ((arg1)->m_aabbMax);
  *(btVector3 **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btBroadphaseProxy_1getUid(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  btBroadphaseProxy *arg1 = (btBroadphaseProxy *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btBroadphaseProxy **)&jarg1; 
  result = (int)((btBroadphaseProxy const *)arg1)->getUid();
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_new_1btBroadphaseProxy_1_1SWIG_10(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  btBroadphaseProxy *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (btBroadphaseProxy *)new btBroadphaseProxy();
  *(btBroadphaseProxy **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_new_1btBroadphaseProxy_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jobject jarg1, jobject jarg2, jlong jarg3, jshort jarg4, jshort jarg5, jlong jarg6) {
  jlong jresult = 0 ;
  btVector3 *arg1 = 0 ;
  btVector3 *arg2 = 0 ;
  void *arg3 = (void *) 0 ;
  short arg4 ;
  short arg5 ;
  void *arg6 = (void *) 0 ;
  btBroadphaseProxy *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  btVector3 local_arg1;
  gdx_setbtVector3FromVector3(jenv, local_arg1, jarg1);
  arg1 = &local_arg1;
  gdxAutoCommitVector3 auto_commit_arg1(jenv, jarg1, &local_arg1);
  btVector3 local_arg2;
  gdx_setbtVector3FromVector3(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitVector3 auto_commit_arg2(jenv, jarg2, &local_arg2);
  arg3 = (void *)jarg3; 
  arg4 = (short)jarg4; 
  arg5 = (short)jarg5; 
  arg6 = (void *)jarg6; 
  result = (btBroadphaseProxy *)new btBroadphaseProxy((btVector3 const &)*arg1,(btVector3 const &)*arg2,arg3,arg4,arg5,arg6);
  *(btBroadphaseProxy **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_new_1btBroadphaseProxy_1_1SWIG_12(JNIEnv *jenv, jclass jcls, jobject jarg1, jobject jarg2, jlong jarg3, jshort jarg4, jshort jarg5) {
  jlong jresult = 0 ;
  btVector3 *arg1 = 0 ;
  btVector3 *arg2 = 0 ;
  void *arg3 = (void *) 0 ;
  short arg4 ;
  short arg5 ;
  btBroadphaseProxy *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  btVector3 local_arg1;
  gdx_setbtVector3FromVector3(jenv, local_arg1, jarg1);
  arg1 = &local_arg1;
  gdxAutoCommitVector3 auto_commit_arg1(jenv, jarg1, &local_arg1);
  btVector3 local_arg2;
  gdx_setbtVector3FromVector3(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitVector3 auto_commit_arg2(jenv, jarg2, &local_arg2);
  arg3 = (void *)jarg3; 
  arg4 = (short)jarg4; 
  arg5 = (short)jarg5; 
  result = (btBroadphaseProxy *)new btBroadphaseProxy((btVector3 const &)*arg1,(btVector3 const &)*arg2,arg3,arg4,arg5);
  *(btBroadphaseProxy **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btBroadphaseProxy_1isPolyhedral(JNIEnv *jenv, jclass jcls, jint jarg1) {
  jboolean jresult = 0 ;
  int arg1 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (int)jarg1; 
  result = (bool)btBroadphaseProxy::isPolyhedral(arg1);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btBroadphaseProxy_1isConvex(JNIEnv *jenv, jclass jcls, jint jarg1) {
  jboolean jresult = 0 ;
  int arg1 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (int)jarg1; 
  result = (bool)btBroadphaseProxy::isConvex(arg1);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btBroadphaseProxy_1isNonMoving(JNIEnv *jenv, jclass jcls, jint jarg1) {
  jboolean jresult = 0 ;
  int arg1 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (int)jarg1; 
  result = (bool)btBroadphaseProxy::isNonMoving(arg1);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btBroadphaseProxy_1isConcave(JNIEnv *jenv, jclass jcls, jint jarg1) {
  jboolean jresult = 0 ;
  int arg1 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (int)jarg1; 
  result = (bool)btBroadphaseProxy::isConcave(arg1);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btBroadphaseProxy_1isCompound(JNIEnv *jenv, jclass jcls, jint jarg1) {
  jboolean jresult = 0 ;
  int arg1 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (int)jarg1; 
  result = (bool)btBroadphaseProxy::isCompound(arg1);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btBroadphaseProxy_1isSoftBody(JNIEnv *jenv, jclass jcls, jint jarg1) {
  jboolean jresult = 0 ;
  int arg1 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (int)jarg1; 
  result = (bool)btBroadphaseProxy::isSoftBody(arg1);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btBroadphaseProxy_1isInfinite(JNIEnv *jenv, jclass jcls, jint jarg1) {
  jboolean jresult = 0 ;
  int arg1 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (int)jarg1; 
  result = (bool)btBroadphaseProxy::isInfinite(arg1);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btBroadphaseProxy_1isConvex2d(JNIEnv *jenv, jclass jcls, jint jarg1) {
  jboolean jresult = 0 ;
  int arg1 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (int)jarg1; 
  result = (bool)btBroadphaseProxy::isConvex2d(arg1);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_delete_1btBroadphaseProxy(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  btBroadphaseProxy *arg1 = (btBroadphaseProxy *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(btBroadphaseProxy **)&jarg1; 
  delete arg1;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_new_1btBroadphasePair_1_1SWIG_10(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  btBroadphasePair *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (btBroadphasePair *)new btBroadphasePair();
  *(btBroadphasePair **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_new_1btBroadphasePair_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jobject jarg1) {
  jlong jresult = 0 ;
  btBroadphasePair *arg1 = 0 ;
  btBroadphasePair *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(btBroadphasePair **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btBroadphasePair const & reference is null");
    return 0;
  } 
  result = (btBroadphasePair *)new btBroadphasePair((btBroadphasePair const &)*arg1);
  *(btBroadphasePair **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_new_1btBroadphasePair_1_1SWIG_12(JNIEnv *jenv, jclass jcls, jobject jarg1, jobject jarg2) {
  jlong jresult = 0 ;
  btBroadphaseProxy *arg1 = 0 ;
  btBroadphaseProxy *arg2 = 0 ;
  btBroadphasePair *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(btBroadphaseProxy **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btBroadphaseProxy & reference is null");
    return 0;
  } 
  arg2 = *(btBroadphaseProxy **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btBroadphaseProxy & reference is null");
    return 0;
  } 
  result = (btBroadphasePair *)new btBroadphasePair(*arg1,*arg2);
  *(btBroadphasePair **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btBroadphasePair_1pProxy0_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btBroadphasePair *arg1 = (btBroadphasePair *) 0 ;
  btBroadphaseProxy *arg2 = (btBroadphaseProxy *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btBroadphasePair **)&jarg1; 
  arg2 = *(btBroadphaseProxy **)&jarg2; 
  if (arg1) (arg1)->m_pProxy0 = arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btBroadphasePair_1pProxy0_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btBroadphasePair *arg1 = (btBroadphasePair *) 0 ;
  btBroadphaseProxy *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btBroadphasePair **)&jarg1; 
  result = (btBroadphaseProxy *) ((arg1)->m_pProxy0);
  *(btBroadphaseProxy **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btBroadphasePair_1pProxy1_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btBroadphasePair *arg1 = (btBroadphasePair *) 0 ;
  btBroadphaseProxy *arg2 = (btBroadphaseProxy *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btBroadphasePair **)&jarg1; 
  arg2 = *(btBroadphaseProxy **)&jarg2; 
  if (arg1) (arg1)->m_pProxy1 = arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btBroadphasePair_1pProxy1_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btBroadphasePair *arg1 = (btBroadphasePair *) 0 ;
  btBroadphaseProxy *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btBroadphasePair **)&jarg1; 
  result = (btBroadphaseProxy *) ((arg1)->m_pProxy1);
  *(btBroadphaseProxy **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btBroadphasePair_1algorithm_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btBroadphasePair *arg1 = (btBroadphasePair *) 0 ;
  btCollisionAlgorithm *arg2 = (btCollisionAlgorithm *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btBroadphasePair **)&jarg1; 
  arg2 = *(btCollisionAlgorithm **)&jarg2; 
  if (arg1) (arg1)->m_algorithm = arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btBroadphasePair_1algorithm_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btBroadphasePair *arg1 = (btBroadphasePair *) 0 ;
  btCollisionAlgorithm *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btBroadphasePair **)&jarg1; 
  result = (btCollisionAlgorithm *) ((arg1)->m_algorithm);
  *(btCollisionAlgorithm **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btBroadphasePair_1internalInfo1_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  btBroadphasePair *arg1 = (btBroadphasePair *) 0 ;
  void *arg2 = (void *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btBroadphasePair **)&jarg1; 
  arg2 = (void *)jarg2; 
  if (arg1) (arg1)->m_internalInfo1 = arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btBroadphasePair_1internalInfo1_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btBroadphasePair *arg1 = (btBroadphasePair *) 0 ;
  void *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btBroadphasePair **)&jarg1; 
  result = (void *) ((arg1)->m_internalInfo1);
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btBroadphasePair_1internalTmpValue_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  btBroadphasePair *arg1 = (btBroadphasePair *) 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btBroadphasePair **)&jarg1; 
  arg2 = (int)jarg2; 
  if (arg1) (arg1)->m_internalTmpValue = arg2;
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btBroadphasePair_1internalTmpValue_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  btBroadphasePair *arg1 = (btBroadphasePair *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btBroadphasePair **)&jarg1; 
  result = (int) ((arg1)->m_internalTmpValue);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_delete_1btBroadphasePair(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  btBroadphasePair *arg1 = (btBroadphasePair *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(btBroadphasePair **)&jarg1; 
  delete arg1;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_new_1btBroadphasePairSortPredicate(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  btBroadphasePairSortPredicate *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (btBroadphasePairSortPredicate *)new btBroadphasePairSortPredicate();
  *(btBroadphasePairSortPredicate **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_delete_1btBroadphasePairSortPredicate(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  btBroadphasePairSortPredicate *arg1 = (btBroadphasePairSortPredicate *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(btBroadphasePairSortPredicate **)&jarg1; 
  delete arg1;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_delete_1btBroadphaseAabbCallback(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  btBroadphaseAabbCallback *arg1 = (btBroadphaseAabbCallback *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(btBroadphaseAabbCallback **)&jarg1; 
  delete arg1;
}


SWIGEXPORT jboolean JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btBroadphaseAabbCallback_1process(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  jboolean jresult = 0 ;
  btBroadphaseAabbCallback *arg1 = (btBroadphaseAabbCallback *) 0 ;
  btBroadphaseProxy *arg2 = (btBroadphaseProxy *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btBroadphaseAabbCallback **)&jarg1; 
  arg2 = *(btBroadphaseProxy **)&jarg2; 
  result = (bool)(arg1)->process((btBroadphaseProxy const *)arg2);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_new_1btBroadphaseAabbCallback(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  btBroadphaseAabbCallback *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (btBroadphaseAabbCallback *)new SwigDirector_btBroadphaseAabbCallback(jenv);
  *(btBroadphaseAabbCallback **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btBroadphaseAabbCallback_1director_1connect(JNIEnv *jenv, jclass jcls, jobject jself, jlong objarg, jboolean jswig_mem_own, jboolean jweak_global) {
  btBroadphaseAabbCallback *obj = *((btBroadphaseAabbCallback **)&objarg);
  (void)jcls;
  SwigDirector_btBroadphaseAabbCallback *director = (SwigDirector_btBroadphaseAabbCallback *)(obj);
  if (director) {
    director->swig_connect_director(jenv, jself, jenv->GetObjectClass(jself), (jswig_mem_own == JNI_TRUE), (jweak_global == JNI_TRUE));
  }
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btBroadphaseAabbCallback_1change_1ownership(JNIEnv *jenv, jclass jcls, jobject jself, jlong objarg, jboolean jtake_or_release) {
  btBroadphaseAabbCallback *obj = *((btBroadphaseAabbCallback **)&objarg);
  SwigDirector_btBroadphaseAabbCallback *director = (SwigDirector_btBroadphaseAabbCallback *)(obj);
  (void)jcls;
  if (director) {
    director->swig_java_change_ownership(jenv, jself, jtake_or_release ? true : false);
  }
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btBroadphaseRayCallback_1rayDirectionInverse_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btBroadphaseRayCallback *arg1 = (btBroadphaseRayCallback *) 0 ;
  btVector3 *arg2 = (btVector3 *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btBroadphaseRayCallback **)&jarg1; 
  arg2 = *(btVector3 **)&jarg2; 
  if (arg1) (arg1)->m_rayDirectionInverse = *arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btBroadphaseRayCallback_1rayDirectionInverse_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btBroadphaseRayCallback *arg1 = (btBroadphaseRayCallback *) 0 ;
  btVector3 *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btBroadphaseRayCallback **)&jarg1; 
  result = (btVector3 *)& ((arg1)->m_rayDirectionInverse);
  *(btVector3 **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btBroadphaseRayCallback_1signs_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlongArray jarg2) {
  btBroadphaseRayCallback *arg1 = (btBroadphaseRayCallback *) 0 ;
  unsigned int *arg2 ;
  jlong *jarr2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btBroadphaseRayCallback **)&jarg1; 
  if (jarg2 && jenv->GetArrayLength(jarg2) != 3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, "incorrect array size");
    return ;
  }
  if (!SWIG_JavaArrayInUint(jenv, &jarr2, (unsigned int **)&arg2, jarg2)) return ; 
  {
    size_t ii;
    unsigned int *b = (unsigned int *) arg1->m_signs;
    for (ii = 0; ii < (size_t)3; ii++) b[ii] = *((unsigned int *) arg2 + ii);
  }
  SWIG_JavaArrayArgoutUint(jenv, jarr2, (unsigned int *)arg2, jarg2); 
  delete [] arg2; 
}


SWIGEXPORT jlongArray JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btBroadphaseRayCallback_1signs_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlongArray jresult = 0 ;
  btBroadphaseRayCallback *arg1 = (btBroadphaseRayCallback *) 0 ;
  unsigned int *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btBroadphaseRayCallback **)&jarg1; 
  result = (unsigned int *)(unsigned int *) ((arg1)->m_signs);
  jresult = SWIG_JavaArrayOutUint(jenv, (unsigned int *)result, 3); 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btBroadphaseRayCallback_1lambda_1max_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2) {
  btBroadphaseRayCallback *arg1 = (btBroadphaseRayCallback *) 0 ;
  btScalar arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btBroadphaseRayCallback **)&jarg1; 
  arg2 = (btScalar)jarg2; 
  if (arg1) (arg1)->m_lambda_max = arg2;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btBroadphaseRayCallback_1lambda_1max_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jfloat jresult = 0 ;
  btBroadphaseRayCallback *arg1 = (btBroadphaseRayCallback *) 0 ;
  btScalar result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btBroadphaseRayCallback **)&jarg1; 
  result = (btScalar) ((arg1)->m_lambda_max);
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_delete_1btBroadphaseRayCallback(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  btBroadphaseRayCallback *arg1 = (btBroadphaseRayCallback *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(btBroadphaseRayCallback **)&jarg1; 
  delete arg1;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_new_1btBroadphaseRayCallback(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  btBroadphaseRayCallback *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (btBroadphaseRayCallback *)new SwigDirector_btBroadphaseRayCallback(jenv);
  *(btBroadphaseRayCallback **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btBroadphaseRayCallback_1director_1connect(JNIEnv *jenv, jclass jcls, jobject jself, jlong objarg, jboolean jswig_mem_own, jboolean jweak_global) {
  btBroadphaseRayCallback *obj = *((btBroadphaseRayCallback **)&objarg);
  (void)jcls;
  SwigDirector_btBroadphaseRayCallback *director = (SwigDirector_btBroadphaseRayCallback *)(obj);
  if (director) {
    director->swig_connect_director(jenv, jself, jenv->GetObjectClass(jself), (jswig_mem_own == JNI_TRUE), (jweak_global == JNI_TRUE));
  }
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btBroadphaseRayCallback_1change_1ownership(JNIEnv *jenv, jclass jcls, jobject jself, jlong objarg, jboolean jtake_or_release) {
  btBroadphaseRayCallback *obj = *((btBroadphaseRayCallback **)&objarg);
  SwigDirector_btBroadphaseRayCallback *director = (SwigDirector_btBroadphaseRayCallback *)(obj);
  (void)jcls;
  if (director) {
    director->swig_java_change_ownership(jenv, jself, jtake_or_release ? true : false);
  }
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_delete_1btBroadphaseInterface(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  btBroadphaseInterface *arg1 = (btBroadphaseInterface *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(btBroadphaseInterface **)&jarg1; 
  delete arg1;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btBroadphaseInterface_1createProxy(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2, jobject jarg3, jint jarg4, jlong jarg5, jshort jarg6, jshort jarg7, jlong jarg8, jobject jarg8_, jlong jarg9) {
  jlong jresult = 0 ;
  btBroadphaseInterface *arg1 = (btBroadphaseInterface *) 0 ;
  btVector3 *arg2 = 0 ;
  btVector3 *arg3 = 0 ;
  int arg4 ;
  void *arg5 = (void *) 0 ;
  short arg6 ;
  short arg7 ;
  btDispatcher *arg8 = (btDispatcher *) 0 ;
  void *arg9 = (void *) 0 ;
  btBroadphaseProxy *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg8_;
  arg1 = *(btBroadphaseInterface **)&jarg1; 
  btVector3 local_arg2;
  gdx_setbtVector3FromVector3(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitVector3 auto_commit_arg2(jenv, jarg2, &local_arg2);
  btVector3 local_arg3;
  gdx_setbtVector3FromVector3(jenv, local_arg3, jarg3);
  arg3 = &local_arg3;
  gdxAutoCommitVector3 auto_commit_arg3(jenv, jarg3, &local_arg3);
  arg4 = (int)jarg4; 
  arg5 = (void *)jarg5; 
  arg6 = (short)jarg6; 
  arg7 = (short)jarg7; 
  arg8 = *(btDispatcher **)&jarg8; 
  arg9 = (void *)jarg9; 
  result = (btBroadphaseProxy *)(arg1)->createProxy((btVector3 const &)*arg2,(btVector3 const &)*arg3,arg4,arg5,arg6,arg7,arg8,arg9);
  *(btBroadphaseProxy **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btBroadphaseInterface_1destroyProxy(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlong jarg3, jobject jarg3_) {
  btBroadphaseInterface *arg1 = (btBroadphaseInterface *) 0 ;
  btBroadphaseProxy *arg2 = (btBroadphaseProxy *) 0 ;
  btDispatcher *arg3 = (btDispatcher *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  (void)jarg3_;
  arg1 = *(btBroadphaseInterface **)&jarg1; 
  arg2 = *(btBroadphaseProxy **)&jarg2; 
  arg3 = *(btDispatcher **)&jarg3; 
  (arg1)->destroyProxy(arg2,arg3);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btBroadphaseInterface_1setAabb(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jobject jarg3, jobject jarg4, jlong jarg5, jobject jarg5_) {
  btBroadphaseInterface *arg1 = (btBroadphaseInterface *) 0 ;
  btBroadphaseProxy *arg2 = (btBroadphaseProxy *) 0 ;
  btVector3 *arg3 = 0 ;
  btVector3 *arg4 = 0 ;
  btDispatcher *arg5 = (btDispatcher *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  (void)jarg5_;
  arg1 = *(btBroadphaseInterface **)&jarg1; 
  arg2 = *(btBroadphaseProxy **)&jarg2; 
  btVector3 local_arg3;
  gdx_setbtVector3FromVector3(jenv, local_arg3, jarg3);
  arg3 = &local_arg3;
  gdxAutoCommitVector3 auto_commit_arg3(jenv, jarg3, &local_arg3);
  btVector3 local_arg4;
  gdx_setbtVector3FromVector3(jenv, local_arg4, jarg4);
  arg4 = &local_arg4;
  gdxAutoCommitVector3 auto_commit_arg4(jenv, jarg4, &local_arg4);
  arg5 = *(btDispatcher **)&jarg5; 
  (arg1)->setAabb(arg2,(btVector3 const &)*arg3,(btVector3 const &)*arg4,arg5);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btBroadphaseInterface_1getAabb(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jobject jarg3, jobject jarg4) {
  btBroadphaseInterface *arg1 = (btBroadphaseInterface *) 0 ;
  btBroadphaseProxy *arg2 = (btBroadphaseProxy *) 0 ;
  btVector3 *arg3 = 0 ;
  btVector3 *arg4 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btBroadphaseInterface **)&jarg1; 
  arg2 = *(btBroadphaseProxy **)&jarg2; 
  btVector3 local_arg3;
  gdx_setbtVector3FromVector3(jenv, local_arg3, jarg3);
  arg3 = &local_arg3;
  gdxAutoCommitVector3 auto_commit_arg3(jenv, jarg3, &local_arg3);
  btVector3 local_arg4;
  gdx_setbtVector3FromVector3(jenv, local_arg4, jarg4);
  arg4 = &local_arg4;
  gdxAutoCommitVector3 auto_commit_arg4(jenv, jarg4, &local_arg4);
  ((btBroadphaseInterface const *)arg1)->getAabb(arg2,*arg3,*arg4);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btBroadphaseInterface_1rayTest_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2, jobject jarg3, jlong jarg4, jobject jarg4_, jobject jarg5, jobject jarg6) {
  btBroadphaseInterface *arg1 = (btBroadphaseInterface *) 0 ;
  btVector3 *arg2 = 0 ;
  btVector3 *arg3 = 0 ;
  btBroadphaseRayCallback *arg4 = 0 ;
  btVector3 *arg5 = 0 ;
  btVector3 *arg6 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg4_;
  arg1 = *(btBroadphaseInterface **)&jarg1; 
  btVector3 local_arg2;
  gdx_setbtVector3FromVector3(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitVector3 auto_commit_arg2(jenv, jarg2, &local_arg2);
  btVector3 local_arg3;
  gdx_setbtVector3FromVector3(jenv, local_arg3, jarg3);
  arg3 = &local_arg3;
  gdxAutoCommitVector3 auto_commit_arg3(jenv, jarg3, &local_arg3);
  arg4 = *(btBroadphaseRayCallback **)&jarg4;
  if (!arg4) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btBroadphaseRayCallback & reference is null");
    return ;
  } 
  btVector3 local_arg5;
  gdx_setbtVector3FromVector3(jenv, local_arg5, jarg5);
  arg5 = &local_arg5;
  gdxAutoCommitVector3 auto_commit_arg5(jenv, jarg5, &local_arg5);
  btVector3 local_arg6;
  gdx_setbtVector3FromVector3(jenv, local_arg6, jarg6);
  arg6 = &local_arg6;
  gdxAutoCommitVector3 auto_commit_arg6(jenv, jarg6, &local_arg6);
  (arg1)->rayTest((btVector3 const &)*arg2,(btVector3 const &)*arg3,*arg4,(btVector3 const &)*arg5,(btVector3 const &)*arg6);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btBroadphaseInterface_1rayTest_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2, jobject jarg3, jlong jarg4, jobject jarg4_, jobject jarg5) {
  btBroadphaseInterface *arg1 = (btBroadphaseInterface *) 0 ;
  btVector3 *arg2 = 0 ;
  btVector3 *arg3 = 0 ;
  btBroadphaseRayCallback *arg4 = 0 ;
  btVector3 *arg5 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg4_;
  arg1 = *(btBroadphaseInterface **)&jarg1; 
  btVector3 local_arg2;
  gdx_setbtVector3FromVector3(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitVector3 auto_commit_arg2(jenv, jarg2, &local_arg2);
  btVector3 local_arg3;
  gdx_setbtVector3FromVector3(jenv, local_arg3, jarg3);
  arg3 = &local_arg3;
  gdxAutoCommitVector3 auto_commit_arg3(jenv, jarg3, &local_arg3);
  arg4 = *(btBroadphaseRayCallback **)&jarg4;
  if (!arg4) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btBroadphaseRayCallback & reference is null");
    return ;
  } 
  btVector3 local_arg5;
  gdx_setbtVector3FromVector3(jenv, local_arg5, jarg5);
  arg5 = &local_arg5;
  gdxAutoCommitVector3 auto_commit_arg5(jenv, jarg5, &local_arg5);
  (arg1)->rayTest((btVector3 const &)*arg2,(btVector3 const &)*arg3,*arg4,(btVector3 const &)*arg5);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btBroadphaseInterface_1rayTest_1_1SWIG_12(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2, jobject jarg3, jlong jarg4, jobject jarg4_) {
  btBroadphaseInterface *arg1 = (btBroadphaseInterface *) 0 ;
  btVector3 *arg2 = 0 ;
  btVector3 *arg3 = 0 ;
  btBroadphaseRayCallback *arg4 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg4_;
  arg1 = *(btBroadphaseInterface **)&jarg1; 
  btVector3 local_arg2;
  gdx_setbtVector3FromVector3(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitVector3 auto_commit_arg2(jenv, jarg2, &local_arg2);
  btVector3 local_arg3;
  gdx_setbtVector3FromVector3(jenv, local_arg3, jarg3);
  arg3 = &local_arg3;
  gdxAutoCommitVector3 auto_commit_arg3(jenv, jarg3, &local_arg3);
  arg4 = *(btBroadphaseRayCallback **)&jarg4;
  if (!arg4) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btBroadphaseRayCallback & reference is null");
    return ;
  } 
  (arg1)->rayTest((btVector3 const &)*arg2,(btVector3 const &)*arg3,*arg4);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btBroadphaseInterface_1aabbTest(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2, jobject jarg3, jlong jarg4, jobject jarg4_) {
  btBroadphaseInterface *arg1 = (btBroadphaseInterface *) 0 ;
  btVector3 *arg2 = 0 ;
  btVector3 *arg3 = 0 ;
  btBroadphaseAabbCallback *arg4 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg4_;
  arg1 = *(btBroadphaseInterface **)&jarg1; 
  btVector3 local_arg2;
  gdx_setbtVector3FromVector3(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitVector3 auto_commit_arg2(jenv, jarg2, &local_arg2);
  btVector3 local_arg3;
  gdx_setbtVector3FromVector3(jenv, local_arg3, jarg3);
  arg3 = &local_arg3;
  gdxAutoCommitVector3 auto_commit_arg3(jenv, jarg3, &local_arg3);
  arg4 = *(btBroadphaseAabbCallback **)&jarg4;
  if (!arg4) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btBroadphaseAabbCallback & reference is null");
    return ;
  } 
  (arg1)->aabbTest((btVector3 const &)*arg2,(btVector3 const &)*arg3,*arg4);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btBroadphaseInterface_1calculateOverlappingPairs(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btBroadphaseInterface *arg1 = (btBroadphaseInterface *) 0 ;
  btDispatcher *arg2 = (btDispatcher *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btBroadphaseInterface **)&jarg1; 
  arg2 = *(btDispatcher **)&jarg2; 
  (arg1)->calculateOverlappingPairs(arg2);
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btBroadphaseInterface_1getOverlappingPairCache_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btBroadphaseInterface *arg1 = (btBroadphaseInterface *) 0 ;
  btOverlappingPairCache *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btBroadphaseInterface **)&jarg1; 
  result = (btOverlappingPairCache *)(arg1)->getOverlappingPairCache();
  *(btOverlappingPairCache **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btBroadphaseInterface_1getBroadphaseAabb(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2, jobject jarg3) {
  btBroadphaseInterface *arg1 = (btBroadphaseInterface *) 0 ;
  btVector3 *arg2 = 0 ;
  btVector3 *arg3 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btBroadphaseInterface **)&jarg1; 
  btVector3 local_arg2;
  gdx_setbtVector3FromVector3(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitVector3 auto_commit_arg2(jenv, jarg2, &local_arg2);
  btVector3 local_arg3;
  gdx_setbtVector3FromVector3(jenv, local_arg3, jarg3);
  arg3 = &local_arg3;
  gdxAutoCommitVector3 auto_commit_arg3(jenv, jarg3, &local_arg3);
  ((btBroadphaseInterface const *)arg1)->getBroadphaseAabb(*arg2,*arg3);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btBroadphaseInterface_1resetPool(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btBroadphaseInterface *arg1 = (btBroadphaseInterface *) 0 ;
  btDispatcher *arg2 = (btDispatcher *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btBroadphaseInterface **)&jarg1; 
  arg2 = *(btDispatcher **)&jarg2; 
  (arg1)->resetPool(arg2);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btBroadphaseInterface_1printStats(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  btBroadphaseInterface *arg1 = (btBroadphaseInterface *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btBroadphaseInterface **)&jarg1; 
  (arg1)->printStats();
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btQuantizedBvhNode_1quantizedAabbMin_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jintArray jarg2) {
  btQuantizedBvhNode *arg1 = (btQuantizedBvhNode *) 0 ;
  unsigned short *arg2 ;
  jint *jarr2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btQuantizedBvhNode **)&jarg1; 
  if (jarg2 && jenv->GetArrayLength(jarg2) != 3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, "incorrect array size");
    return ;
  }
  if (!SWIG_JavaArrayInUshort(jenv, &jarr2, (unsigned short **)&arg2, jarg2)) return ; 
  {
    size_t ii;
    unsigned short *b = (unsigned short *) arg1->m_quantizedAabbMin;
    for (ii = 0; ii < (size_t)3; ii++) b[ii] = *((unsigned short *) arg2 + ii);
  }
  SWIG_JavaArrayArgoutUshort(jenv, jarr2, (unsigned short *)arg2, jarg2); 
  delete [] arg2; 
}


SWIGEXPORT jintArray JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btQuantizedBvhNode_1quantizedAabbMin_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jintArray jresult = 0 ;
  btQuantizedBvhNode *arg1 = (btQuantizedBvhNode *) 0 ;
  unsigned short *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btQuantizedBvhNode **)&jarg1; 
  result = (unsigned short *)(unsigned short *) ((arg1)->m_quantizedAabbMin);
  jresult = SWIG_JavaArrayOutUshort(jenv, (unsigned short *)result, 3); 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btQuantizedBvhNode_1quantizedAabbMax_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jintArray jarg2) {
  btQuantizedBvhNode *arg1 = (btQuantizedBvhNode *) 0 ;
  unsigned short *arg2 ;
  jint *jarr2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btQuantizedBvhNode **)&jarg1; 
  if (jarg2 && jenv->GetArrayLength(jarg2) != 3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, "incorrect array size");
    return ;
  }
  if (!SWIG_JavaArrayInUshort(jenv, &jarr2, (unsigned short **)&arg2, jarg2)) return ; 
  {
    size_t ii;
    unsigned short *b = (unsigned short *) arg1->m_quantizedAabbMax;
    for (ii = 0; ii < (size_t)3; ii++) b[ii] = *((unsigned short *) arg2 + ii);
  }
  SWIG_JavaArrayArgoutUshort(jenv, jarr2, (unsigned short *)arg2, jarg2); 
  delete [] arg2; 
}


SWIGEXPORT jintArray JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btQuantizedBvhNode_1quantizedAabbMax_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jintArray jresult = 0 ;
  btQuantizedBvhNode *arg1 = (btQuantizedBvhNode *) 0 ;
  unsigned short *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btQuantizedBvhNode **)&jarg1; 
  result = (unsigned short *)(unsigned short *) ((arg1)->m_quantizedAabbMax);
  jresult = SWIG_JavaArrayOutUshort(jenv, (unsigned short *)result, 3); 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btQuantizedBvhNode_1escapeIndexOrTriangleIndex_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  btQuantizedBvhNode *arg1 = (btQuantizedBvhNode *) 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btQuantizedBvhNode **)&jarg1; 
  arg2 = (int)jarg2; 
  if (arg1) (arg1)->m_escapeIndexOrTriangleIndex = arg2;
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btQuantizedBvhNode_1escapeIndexOrTriangleIndex_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  btQuantizedBvhNode *arg1 = (btQuantizedBvhNode *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btQuantizedBvhNode **)&jarg1; 
  result = (int) ((arg1)->m_escapeIndexOrTriangleIndex);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btQuantizedBvhNode_1isLeafNode(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  btQuantizedBvhNode *arg1 = (btQuantizedBvhNode *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btQuantizedBvhNode **)&jarg1; 
  result = (bool)((btQuantizedBvhNode const *)arg1)->isLeafNode();
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btQuantizedBvhNode_1getEscapeIndex(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  btQuantizedBvhNode *arg1 = (btQuantizedBvhNode *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btQuantizedBvhNode **)&jarg1; 
  result = (int)((btQuantizedBvhNode const *)arg1)->getEscapeIndex();
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btQuantizedBvhNode_1getTriangleIndex(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  btQuantizedBvhNode *arg1 = (btQuantizedBvhNode *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btQuantizedBvhNode **)&jarg1; 
  result = (int)((btQuantizedBvhNode const *)arg1)->getTriangleIndex();
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btQuantizedBvhNode_1getPartId(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  btQuantizedBvhNode *arg1 = (btQuantizedBvhNode *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btQuantizedBvhNode **)&jarg1; 
  result = (int)((btQuantizedBvhNode const *)arg1)->getPartId();
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_new_1btQuantizedBvhNode(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  btQuantizedBvhNode *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (btQuantizedBvhNode *)new btQuantizedBvhNode();
  *(btQuantizedBvhNode **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_delete_1btQuantizedBvhNode(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  btQuantizedBvhNode *arg1 = (btQuantizedBvhNode *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(btQuantizedBvhNode **)&jarg1; 
  delete arg1;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btOptimizedBvhNode_1aabbMinOrg_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btOptimizedBvhNode *arg1 = (btOptimizedBvhNode *) 0 ;
  btVector3 *arg2 = (btVector3 *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btOptimizedBvhNode **)&jarg1; 
  arg2 = *(btVector3 **)&jarg2; 
  if (arg1) (arg1)->m_aabbMinOrg = *arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btOptimizedBvhNode_1aabbMinOrg_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btOptimizedBvhNode *arg1 = (btOptimizedBvhNode *) 0 ;
  btVector3 *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btOptimizedBvhNode **)&jarg1; 
  result = (btVector3 *)& ((arg1)->m_aabbMinOrg);
  *(btVector3 **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btOptimizedBvhNode_1aabbMaxOrg_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btOptimizedBvhNode *arg1 = (btOptimizedBvhNode *) 0 ;
  btVector3 *arg2 = (btVector3 *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btOptimizedBvhNode **)&jarg1; 
  arg2 = *(btVector3 **)&jarg2; 
  if (arg1) (arg1)->m_aabbMaxOrg = *arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btOptimizedBvhNode_1aabbMaxOrg_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btOptimizedBvhNode *arg1 = (btOptimizedBvhNode *) 0 ;
  btVector3 *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btOptimizedBvhNode **)&jarg1; 
  result = (btVector3 *)& ((arg1)->m_aabbMaxOrg);
  *(btVector3 **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btOptimizedBvhNode_1escapeIndex_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  btOptimizedBvhNode *arg1 = (btOptimizedBvhNode *) 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btOptimizedBvhNode **)&jarg1; 
  arg2 = (int)jarg2; 
  if (arg1) (arg1)->m_escapeIndex = arg2;
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btOptimizedBvhNode_1escapeIndex_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  btOptimizedBvhNode *arg1 = (btOptimizedBvhNode *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btOptimizedBvhNode **)&jarg1; 
  result = (int) ((arg1)->m_escapeIndex);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btOptimizedBvhNode_1subPart_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  btOptimizedBvhNode *arg1 = (btOptimizedBvhNode *) 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btOptimizedBvhNode **)&jarg1; 
  arg2 = (int)jarg2; 
  if (arg1) (arg1)->m_subPart = arg2;
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btOptimizedBvhNode_1subPart_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  btOptimizedBvhNode *arg1 = (btOptimizedBvhNode *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btOptimizedBvhNode **)&jarg1; 
  result = (int) ((arg1)->m_subPart);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btOptimizedBvhNode_1triangleIndex_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  btOptimizedBvhNode *arg1 = (btOptimizedBvhNode *) 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btOptimizedBvhNode **)&jarg1; 
  arg2 = (int)jarg2; 
  if (arg1) (arg1)->m_triangleIndex = arg2;
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btOptimizedBvhNode_1triangleIndex_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  btOptimizedBvhNode *arg1 = (btOptimizedBvhNode *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btOptimizedBvhNode **)&jarg1; 
  result = (int) ((arg1)->m_triangleIndex);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btOptimizedBvhNode_1padding_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  btOptimizedBvhNode *arg1 = (btOptimizedBvhNode *) 0 ;
  char *arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btOptimizedBvhNode **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return ;
  }
  {
    if(arg2) {
      strncpy((char*)arg1->m_padding, (const char *)arg2, 20-1);
      arg1->m_padding[20-1] = 0;
    } else {
      arg1->m_padding[0] = 0;
    }
  }
  
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
}


SWIGEXPORT jstring JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btOptimizedBvhNode_1padding_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  btOptimizedBvhNode *arg1 = (btOptimizedBvhNode *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btOptimizedBvhNode **)&jarg1; 
  result = (char *)(char *) ((arg1)->m_padding);
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_new_1btOptimizedBvhNode(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  btOptimizedBvhNode *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (btOptimizedBvhNode *)new btOptimizedBvhNode();
  *(btOptimizedBvhNode **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_delete_1btOptimizedBvhNode(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  btOptimizedBvhNode *arg1 = (btOptimizedBvhNode *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(btOptimizedBvhNode **)&jarg1; 
  delete arg1;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btBvhSubtreeInfo_1quantizedAabbMin_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jintArray jarg2) {
  btBvhSubtreeInfo *arg1 = (btBvhSubtreeInfo *) 0 ;
  unsigned short *arg2 ;
  jint *jarr2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btBvhSubtreeInfo **)&jarg1; 
  if (jarg2 && jenv->GetArrayLength(jarg2) != 3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, "incorrect array size");
    return ;
  }
  if (!SWIG_JavaArrayInUshort(jenv, &jarr2, (unsigned short **)&arg2, jarg2)) return ; 
  {
    size_t ii;
    unsigned short *b = (unsigned short *) arg1->m_quantizedAabbMin;
    for (ii = 0; ii < (size_t)3; ii++) b[ii] = *((unsigned short *) arg2 + ii);
  }
  SWIG_JavaArrayArgoutUshort(jenv, jarr2, (unsigned short *)arg2, jarg2); 
  delete [] arg2; 
}


SWIGEXPORT jintArray JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btBvhSubtreeInfo_1quantizedAabbMin_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jintArray jresult = 0 ;
  btBvhSubtreeInfo *arg1 = (btBvhSubtreeInfo *) 0 ;
  unsigned short *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btBvhSubtreeInfo **)&jarg1; 
  result = (unsigned short *)(unsigned short *) ((arg1)->m_quantizedAabbMin);
  jresult = SWIG_JavaArrayOutUshort(jenv, (unsigned short *)result, 3); 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btBvhSubtreeInfo_1quantizedAabbMax_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jintArray jarg2) {
  btBvhSubtreeInfo *arg1 = (btBvhSubtreeInfo *) 0 ;
  unsigned short *arg2 ;
  jint *jarr2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btBvhSubtreeInfo **)&jarg1; 
  if (jarg2 && jenv->GetArrayLength(jarg2) != 3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, "incorrect array size");
    return ;
  }
  if (!SWIG_JavaArrayInUshort(jenv, &jarr2, (unsigned short **)&arg2, jarg2)) return ; 
  {
    size_t ii;
    unsigned short *b = (unsigned short *) arg1->m_quantizedAabbMax;
    for (ii = 0; ii < (size_t)3; ii++) b[ii] = *((unsigned short *) arg2 + ii);
  }
  SWIG_JavaArrayArgoutUshort(jenv, jarr2, (unsigned short *)arg2, jarg2); 
  delete [] arg2; 
}


SWIGEXPORT jintArray JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btBvhSubtreeInfo_1quantizedAabbMax_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jintArray jresult = 0 ;
  btBvhSubtreeInfo *arg1 = (btBvhSubtreeInfo *) 0 ;
  unsigned short *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btBvhSubtreeInfo **)&jarg1; 
  result = (unsigned short *)(unsigned short *) ((arg1)->m_quantizedAabbMax);
  jresult = SWIG_JavaArrayOutUshort(jenv, (unsigned short *)result, 3); 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btBvhSubtreeInfo_1rootNodeIndex_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  btBvhSubtreeInfo *arg1 = (btBvhSubtreeInfo *) 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btBvhSubtreeInfo **)&jarg1; 
  arg2 = (int)jarg2; 
  if (arg1) (arg1)->m_rootNodeIndex = arg2;
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btBvhSubtreeInfo_1rootNodeIndex_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  btBvhSubtreeInfo *arg1 = (btBvhSubtreeInfo *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btBvhSubtreeInfo **)&jarg1; 
  result = (int) ((arg1)->m_rootNodeIndex);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btBvhSubtreeInfo_1subtreeSize_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  btBvhSubtreeInfo *arg1 = (btBvhSubtreeInfo *) 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btBvhSubtreeInfo **)&jarg1; 
  arg2 = (int)jarg2; 
  if (arg1) (arg1)->m_subtreeSize = arg2;
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btBvhSubtreeInfo_1subtreeSize_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  btBvhSubtreeInfo *arg1 = (btBvhSubtreeInfo *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btBvhSubtreeInfo **)&jarg1; 
  result = (int) ((arg1)->m_subtreeSize);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btBvhSubtreeInfo_1padding_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jintArray jarg2) {
  btBvhSubtreeInfo *arg1 = (btBvhSubtreeInfo *) 0 ;
  int *arg2 ;
  jint *jarr2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btBvhSubtreeInfo **)&jarg1; 
  if (jarg2 && jenv->GetArrayLength(jarg2) != 3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, "incorrect array size");
    return ;
  }
  if (!SWIG_JavaArrayInInt(jenv, &jarr2, (int **)&arg2, jarg2)) return ; 
  {
    size_t ii;
    int *b = (int *) arg1->m_padding;
    for (ii = 0; ii < (size_t)3; ii++) b[ii] = *((int *) arg2 + ii);
  }
  SWIG_JavaArrayArgoutInt(jenv, jarr2, (int *)arg2, jarg2); 
  delete [] arg2; 
}


SWIGEXPORT jintArray JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btBvhSubtreeInfo_1padding_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jintArray jresult = 0 ;
  btBvhSubtreeInfo *arg1 = (btBvhSubtreeInfo *) 0 ;
  int *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btBvhSubtreeInfo **)&jarg1; 
  result = (int *)(int *) ((arg1)->m_padding);
  jresult = SWIG_JavaArrayOutInt(jenv, (int *)result, 3); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_new_1btBvhSubtreeInfo(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  btBvhSubtreeInfo *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (btBvhSubtreeInfo *)new btBvhSubtreeInfo();
  *(btBvhSubtreeInfo **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btBvhSubtreeInfo_1setAabbFromQuantizeNode(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btBvhSubtreeInfo *arg1 = (btBvhSubtreeInfo *) 0 ;
  btQuantizedBvhNode *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btBvhSubtreeInfo **)&jarg1; 
  arg2 = *(btQuantizedBvhNode **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btQuantizedBvhNode const & reference is null");
    return ;
  } 
  (arg1)->setAabbFromQuantizeNode((btQuantizedBvhNode const &)*arg2);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_delete_1btBvhSubtreeInfo(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  btBvhSubtreeInfo *arg1 = (btBvhSubtreeInfo *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(btBvhSubtreeInfo **)&jarg1; 
  delete arg1;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_delete_1btNodeOverlapCallback(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  btNodeOverlapCallback *arg1 = (btNodeOverlapCallback *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(btNodeOverlapCallback **)&jarg1; 
  delete arg1;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btNodeOverlapCallback_1processNode(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jint jarg3) {
  btNodeOverlapCallback *arg1 = (btNodeOverlapCallback *) 0 ;
  int arg2 ;
  int arg3 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btNodeOverlapCallback **)&jarg1; 
  arg2 = (int)jarg2; 
  arg3 = (int)jarg3; 
  (arg1)->processNode(arg2,arg3);
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_new_1btNodeOverlapCallback(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  btNodeOverlapCallback *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (btNodeOverlapCallback *)new SwigDirector_btNodeOverlapCallback(jenv);
  *(btNodeOverlapCallback **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btNodeOverlapCallback_1director_1connect(JNIEnv *jenv, jclass jcls, jobject jself, jlong objarg, jboolean jswig_mem_own, jboolean jweak_global) {
  btNodeOverlapCallback *obj = *((btNodeOverlapCallback **)&objarg);
  (void)jcls;
  SwigDirector_btNodeOverlapCallback *director = (SwigDirector_btNodeOverlapCallback *)(obj);
  if (director) {
    director->swig_connect_director(jenv, jself, jenv->GetObjectClass(jself), (jswig_mem_own == JNI_TRUE), (jweak_global == JNI_TRUE));
  }
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btNodeOverlapCallback_1change_1ownership(JNIEnv *jenv, jclass jcls, jobject jself, jlong objarg, jboolean jtake_or_release) {
  btNodeOverlapCallback *obj = *((btNodeOverlapCallback **)&objarg);
  SwigDirector_btNodeOverlapCallback *director = (SwigDirector_btNodeOverlapCallback *)(obj);
  (void)jcls;
  if (director) {
    director->swig_java_change_ownership(jenv, jself, jtake_or_release ? true : false);
  }
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_new_1btQuantizedBvh(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  btQuantizedBvh *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (btQuantizedBvh *)new btQuantizedBvh();
  *(btQuantizedBvh **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_delete_1btQuantizedBvh(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  btQuantizedBvh *arg1 = (btQuantizedBvh *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(btQuantizedBvh **)&jarg1; 
  delete arg1;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btQuantizedBvh_1setQuantizationValues_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2, jobject jarg3, jfloat jarg4) {
  btQuantizedBvh *arg1 = (btQuantizedBvh *) 0 ;
  btVector3 *arg2 = 0 ;
  btVector3 *arg3 = 0 ;
  btScalar arg4 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btQuantizedBvh **)&jarg1; 
  btVector3 local_arg2;
  gdx_setbtVector3FromVector3(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitVector3 auto_commit_arg2(jenv, jarg2, &local_arg2);
  btVector3 local_arg3;
  gdx_setbtVector3FromVector3(jenv, local_arg3, jarg3);
  arg3 = &local_arg3;
  gdxAutoCommitVector3 auto_commit_arg3(jenv, jarg3, &local_arg3);
  arg4 = (btScalar)jarg4; 
  (arg1)->setQuantizationValues((btVector3 const &)*arg2,(btVector3 const &)*arg3,arg4);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btQuantizedBvh_1setQuantizationValues_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2, jobject jarg3) {
  btQuantizedBvh *arg1 = (btQuantizedBvh *) 0 ;
  btVector3 *arg2 = 0 ;
  btVector3 *arg3 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btQuantizedBvh **)&jarg1; 
  btVector3 local_arg2;
  gdx_setbtVector3FromVector3(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitVector3 auto_commit_arg2(jenv, jarg2, &local_arg2);
  btVector3 local_arg3;
  gdx_setbtVector3FromVector3(jenv, local_arg3, jarg3);
  arg3 = &local_arg3;
  gdxAutoCommitVector3 auto_commit_arg3(jenv, jarg3, &local_arg3);
  (arg1)->setQuantizationValues((btVector3 const &)*arg2,(btVector3 const &)*arg3);
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btQuantizedBvh_1getLeafNodeArray(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btQuantizedBvh *arg1 = (btQuantizedBvh *) 0 ;
  QuantizedNodeArray *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btQuantizedBvh **)&jarg1; 
  result = (QuantizedNodeArray *) &(arg1)->getLeafNodeArray();
  *(QuantizedNodeArray **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btQuantizedBvh_1buildInternal(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  btQuantizedBvh *arg1 = (btQuantizedBvh *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btQuantizedBvh **)&jarg1; 
  (arg1)->buildInternal();
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btQuantizedBvh_1reportAabbOverlappingNodex(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jobject jarg3, jobject jarg4) {
  btQuantizedBvh *arg1 = (btQuantizedBvh *) 0 ;
  btNodeOverlapCallback *arg2 = (btNodeOverlapCallback *) 0 ;
  btVector3 *arg3 = 0 ;
  btVector3 *arg4 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btQuantizedBvh **)&jarg1; 
  arg2 = *(btNodeOverlapCallback **)&jarg2; 
  btVector3 local_arg3;
  gdx_setbtVector3FromVector3(jenv, local_arg3, jarg3);
  arg3 = &local_arg3;
  gdxAutoCommitVector3 auto_commit_arg3(jenv, jarg3, &local_arg3);
  btVector3 local_arg4;
  gdx_setbtVector3FromVector3(jenv, local_arg4, jarg4);
  arg4 = &local_arg4;
  gdxAutoCommitVector3 auto_commit_arg4(jenv, jarg4, &local_arg4);
  ((btQuantizedBvh const *)arg1)->reportAabbOverlappingNodex(arg2,(btVector3 const &)*arg3,(btVector3 const &)*arg4);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btQuantizedBvh_1reportRayOverlappingNodex(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jobject jarg3, jobject jarg4) {
  btQuantizedBvh *arg1 = (btQuantizedBvh *) 0 ;
  btNodeOverlapCallback *arg2 = (btNodeOverlapCallback *) 0 ;
  btVector3 *arg3 = 0 ;
  btVector3 *arg4 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btQuantizedBvh **)&jarg1; 
  arg2 = *(btNodeOverlapCallback **)&jarg2; 
  btVector3 local_arg3;
  gdx_setbtVector3FromVector3(jenv, local_arg3, jarg3);
  arg3 = &local_arg3;
  gdxAutoCommitVector3 auto_commit_arg3(jenv, jarg3, &local_arg3);
  btVector3 local_arg4;
  gdx_setbtVector3FromVector3(jenv, local_arg4, jarg4);
  arg4 = &local_arg4;
  gdxAutoCommitVector3 auto_commit_arg4(jenv, jarg4, &local_arg4);
  ((btQuantizedBvh const *)arg1)->reportRayOverlappingNodex(arg2,(btVector3 const &)*arg3,(btVector3 const &)*arg4);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btQuantizedBvh_1reportBoxCastOverlappingNodex(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jobject jarg3, jobject jarg4, jobject jarg5, jobject jarg6) {
  btQuantizedBvh *arg1 = (btQuantizedBvh *) 0 ;
  btNodeOverlapCallback *arg2 = (btNodeOverlapCallback *) 0 ;
  btVector3 *arg3 = 0 ;
  btVector3 *arg4 = 0 ;
  btVector3 *arg5 = 0 ;
  btVector3 *arg6 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btQuantizedBvh **)&jarg1; 
  arg2 = *(btNodeOverlapCallback **)&jarg2; 
  btVector3 local_arg3;
  gdx_setbtVector3FromVector3(jenv, local_arg3, jarg3);
  arg3 = &local_arg3;
  gdxAutoCommitVector3 auto_commit_arg3(jenv, jarg3, &local_arg3);
  btVector3 local_arg4;
  gdx_setbtVector3FromVector3(jenv, local_arg4, jarg4);
  arg4 = &local_arg4;
  gdxAutoCommitVector3 auto_commit_arg4(jenv, jarg4, &local_arg4);
  btVector3 local_arg5;
  gdx_setbtVector3FromVector3(jenv, local_arg5, jarg5);
  arg5 = &local_arg5;
  gdxAutoCommitVector3 auto_commit_arg5(jenv, jarg5, &local_arg5);
  btVector3 local_arg6;
  gdx_setbtVector3FromVector3(jenv, local_arg6, jarg6);
  arg6 = &local_arg6;
  gdxAutoCommitVector3 auto_commit_arg6(jenv, jarg6, &local_arg6);
  ((btQuantizedBvh const *)arg1)->reportBoxCastOverlappingNodex(arg2,(btVector3 const &)*arg3,(btVector3 const &)*arg4,(btVector3 const &)*arg5,(btVector3 const &)*arg6);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btQuantizedBvh_1quantize(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2, jobject jarg3, jint jarg4) {
  btQuantizedBvh *arg1 = (btQuantizedBvh *) 0 ;
  unsigned short *arg2 = (unsigned short *) 0 ;
  btVector3 *arg3 = 0 ;
  int arg4 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btQuantizedBvh **)&jarg1; 
  {
    arg2 = (unsigned short*)jenv->GetDirectBufferAddress(jarg2);
    if (arg2 == NULL) {
      SWIG_JavaThrowException(jenv, SWIG_JavaRuntimeException, "Unable to get address of direct buffer. Buffer must be allocated direct.");
    }
  }
  btVector3 local_arg3;
  gdx_setbtVector3FromVector3(jenv, local_arg3, jarg3);
  arg3 = &local_arg3;
  gdxAutoCommitVector3 auto_commit_arg3(jenv, jarg3, &local_arg3);
  arg4 = (int)jarg4; 
  ((btQuantizedBvh const *)arg1)->quantize(arg2,(btVector3 const &)*arg3,arg4);
  
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btQuantizedBvh_1quantizeWithClamp(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2, jobject jarg3, jint jarg4) {
  btQuantizedBvh *arg1 = (btQuantizedBvh *) 0 ;
  unsigned short *arg2 = (unsigned short *) 0 ;
  btVector3 *arg3 = 0 ;
  int arg4 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btQuantizedBvh **)&jarg1; 
  {
    arg2 = (unsigned short*)jenv->GetDirectBufferAddress(jarg2);
    if (arg2 == NULL) {
      SWIG_JavaThrowException(jenv, SWIG_JavaRuntimeException, "Unable to get address of direct buffer. Buffer must be allocated direct.");
    }
  }
  btVector3 local_arg3;
  gdx_setbtVector3FromVector3(jenv, local_arg3, jarg3);
  arg3 = &local_arg3;
  gdxAutoCommitVector3 auto_commit_arg3(jenv, jarg3, &local_arg3);
  arg4 = (int)jarg4; 
  ((btQuantizedBvh const *)arg1)->quantizeWithClamp(arg2,(btVector3 const &)*arg3,arg4);
  
}


SWIGEXPORT jobject JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btQuantizedBvh_1unQuantize(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2) {
  jobject jresult = 0 ;
  btQuantizedBvh *arg1 = (btQuantizedBvh *) 0 ;
  unsigned short *arg2 = (unsigned short *) 0 ;
  btVector3 result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btQuantizedBvh **)&jarg1; 
  {
    arg2 = (unsigned short*)jenv->GetDirectBufferAddress(jarg2);
    if (arg2 == NULL) {
      SWIG_JavaThrowException(jenv, SWIG_JavaRuntimeException, "Unable to get address of direct buffer. Buffer must be allocated direct.");
    }
  }
  result = ((btQuantizedBvh const *)arg1)->unQuantize((unsigned short const *)arg2);
  jresult = gdx_getReturnVector3(jenv);
  gdx_setVector3FrombtVector3(jenv, jresult, result);
  
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btQuantizedBvh_1setTraversalMode(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  btQuantizedBvh *arg1 = (btQuantizedBvh *) 0 ;
  btQuantizedBvh::btTraversalMode arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btQuantizedBvh **)&jarg1; 
  arg2 = (btQuantizedBvh::btTraversalMode)jarg2; 
  (arg1)->setTraversalMode(arg2);
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btQuantizedBvh_1getQuantizedNodeArray(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btQuantizedBvh *arg1 = (btQuantizedBvh *) 0 ;
  QuantizedNodeArray *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btQuantizedBvh **)&jarg1; 
  result = (QuantizedNodeArray *) &(arg1)->getQuantizedNodeArray();
  *(QuantizedNodeArray **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btQuantizedBvh_1getSubtreeInfoArray(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btQuantizedBvh *arg1 = (btQuantizedBvh *) 0 ;
  BvhSubtreeInfoArray *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btQuantizedBvh **)&jarg1; 
  result = (BvhSubtreeInfoArray *) &(arg1)->getSubtreeInfoArray();
  *(BvhSubtreeInfoArray **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btQuantizedBvh_1calculateSerializeBufferSize(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btQuantizedBvh *arg1 = (btQuantizedBvh *) 0 ;
  unsigned int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btQuantizedBvh **)&jarg1; 
  result = (unsigned int)((btQuantizedBvh const *)arg1)->calculateSerializeBufferSize();
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btQuantizedBvh_1serialize_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jlong jarg3, jboolean jarg4) {
  jboolean jresult = 0 ;
  btQuantizedBvh *arg1 = (btQuantizedBvh *) 0 ;
  void *arg2 = (void *) 0 ;
  unsigned int arg3 ;
  bool arg4 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btQuantizedBvh **)&jarg1; 
  arg2 = (void *)jarg2; 
  arg3 = (unsigned int)jarg3; 
  arg4 = jarg4 ? true : false; 
  result = (bool)((btQuantizedBvh const *)arg1)->serialize(arg2,arg3,arg4);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btQuantizedBvh_1deSerializeInPlace(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2, jboolean jarg3) {
  jlong jresult = 0 ;
  void *arg1 = (void *) 0 ;
  unsigned int arg2 ;
  bool arg3 ;
  btQuantizedBvh *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (void *)jarg1; 
  arg2 = (unsigned int)jarg2; 
  arg3 = jarg3 ? true : false; 
  result = (btQuantizedBvh *)btQuantizedBvh::deSerializeInPlace(arg1,arg2,arg3);
  *(btQuantizedBvh **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btQuantizedBvh_1getAlignmentSerializationPadding(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  unsigned int result;
  
  (void)jenv;
  (void)jcls;
  result = (unsigned int)btQuantizedBvh::getAlignmentSerializationPadding();
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btQuantizedBvh_1calculateSerializeBufferSizeNew(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  btQuantizedBvh *arg1 = (btQuantizedBvh *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btQuantizedBvh **)&jarg1; 
  result = (int)((btQuantizedBvh const *)arg1)->calculateSerializeBufferSizeNew();
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btQuantizedBvh_1serialize_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jlong jarg3) {
  jstring jresult = 0 ;
  btQuantizedBvh *arg1 = (btQuantizedBvh *) 0 ;
  void *arg2 = (void *) 0 ;
  btSerializer *arg3 = (btSerializer *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btQuantizedBvh **)&jarg1; 
  arg2 = (void *)jarg2; 
  arg3 = *(btSerializer **)&jarg3; 
  result = (char *)((btQuantizedBvh const *)arg1)->serialize(arg2,arg3);
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btQuantizedBvh_1deSerializeFloat(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btQuantizedBvh *arg1 = (btQuantizedBvh *) 0 ;
  btQuantizedBvhFloatData *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btQuantizedBvh **)&jarg1; 
  arg2 = *(btQuantizedBvhFloatData **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btQuantizedBvhFloatData & reference is null");
    return ;
  } 
  (arg1)->deSerializeFloat(*arg2);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btQuantizedBvh_1deSerializeDouble(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btQuantizedBvh *arg1 = (btQuantizedBvh *) 0 ;
  btQuantizedBvhDoubleData *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btQuantizedBvh **)&jarg1; 
  arg2 = *(btQuantizedBvhDoubleData **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btQuantizedBvhDoubleData & reference is null");
    return ;
  } 
  (arg1)->deSerializeDouble(*arg2);
}


SWIGEXPORT jboolean JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btQuantizedBvh_1isQuantized(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  btQuantizedBvh *arg1 = (btQuantizedBvh *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btQuantizedBvh **)&jarg1; 
  result = (bool)(arg1)->isQuantized();
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btBvhSubtreeInfoData_1rootNodeIndex_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  btBvhSubtreeInfoData *arg1 = (btBvhSubtreeInfoData *) 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btBvhSubtreeInfoData **)&jarg1; 
  arg2 = (int)jarg2; 
  if (arg1) (arg1)->m_rootNodeIndex = arg2;
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btBvhSubtreeInfoData_1rootNodeIndex_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  btBvhSubtreeInfoData *arg1 = (btBvhSubtreeInfoData *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btBvhSubtreeInfoData **)&jarg1; 
  result = (int) ((arg1)->m_rootNodeIndex);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btBvhSubtreeInfoData_1subtreeSize_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  btBvhSubtreeInfoData *arg1 = (btBvhSubtreeInfoData *) 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btBvhSubtreeInfoData **)&jarg1; 
  arg2 = (int)jarg2; 
  if (arg1) (arg1)->m_subtreeSize = arg2;
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btBvhSubtreeInfoData_1subtreeSize_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  btBvhSubtreeInfoData *arg1 = (btBvhSubtreeInfoData *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btBvhSubtreeInfoData **)&jarg1; 
  result = (int) ((arg1)->m_subtreeSize);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btBvhSubtreeInfoData_1quantizedAabbMin_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jintArray jarg2) {
  btBvhSubtreeInfoData *arg1 = (btBvhSubtreeInfoData *) 0 ;
  unsigned short *arg2 ;
  jint *jarr2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btBvhSubtreeInfoData **)&jarg1; 
  if (jarg2 && jenv->GetArrayLength(jarg2) != 3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, "incorrect array size");
    return ;
  }
  if (!SWIG_JavaArrayInUshort(jenv, &jarr2, (unsigned short **)&arg2, jarg2)) return ; 
  {
    size_t ii;
    unsigned short *b = (unsigned short *) arg1->m_quantizedAabbMin;
    for (ii = 0; ii < (size_t)3; ii++) b[ii] = *((unsigned short *) arg2 + ii);
  }
  SWIG_JavaArrayArgoutUshort(jenv, jarr2, (unsigned short *)arg2, jarg2); 
  delete [] arg2; 
}


SWIGEXPORT jintArray JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btBvhSubtreeInfoData_1quantizedAabbMin_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jintArray jresult = 0 ;
  btBvhSubtreeInfoData *arg1 = (btBvhSubtreeInfoData *) 0 ;
  unsigned short *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btBvhSubtreeInfoData **)&jarg1; 
  result = (unsigned short *)(unsigned short *) ((arg1)->m_quantizedAabbMin);
  jresult = SWIG_JavaArrayOutUshort(jenv, (unsigned short *)result, 3); 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btBvhSubtreeInfoData_1quantizedAabbMax_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jintArray jarg2) {
  btBvhSubtreeInfoData *arg1 = (btBvhSubtreeInfoData *) 0 ;
  unsigned short *arg2 ;
  jint *jarr2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btBvhSubtreeInfoData **)&jarg1; 
  if (jarg2 && jenv->GetArrayLength(jarg2) != 3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, "incorrect array size");
    return ;
  }
  if (!SWIG_JavaArrayInUshort(jenv, &jarr2, (unsigned short **)&arg2, jarg2)) return ; 
  {
    size_t ii;
    unsigned short *b = (unsigned short *) arg1->m_quantizedAabbMax;
    for (ii = 0; ii < (size_t)3; ii++) b[ii] = *((unsigned short *) arg2 + ii);
  }
  SWIG_JavaArrayArgoutUshort(jenv, jarr2, (unsigned short *)arg2, jarg2); 
  delete [] arg2; 
}


SWIGEXPORT jintArray JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btBvhSubtreeInfoData_1quantizedAabbMax_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jintArray jresult = 0 ;
  btBvhSubtreeInfoData *arg1 = (btBvhSubtreeInfoData *) 0 ;
  unsigned short *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btBvhSubtreeInfoData **)&jarg1; 
  result = (unsigned short *)(unsigned short *) ((arg1)->m_quantizedAabbMax);
  jresult = SWIG_JavaArrayOutUshort(jenv, (unsigned short *)result, 3); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_new_1btBvhSubtreeInfoData(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  btBvhSubtreeInfoData *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (btBvhSubtreeInfoData *)new btBvhSubtreeInfoData();
  *(btBvhSubtreeInfoData **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_delete_1btBvhSubtreeInfoData(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  btBvhSubtreeInfoData *arg1 = (btBvhSubtreeInfoData *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(btBvhSubtreeInfoData **)&jarg1; 
  delete arg1;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btOptimizedBvhNodeFloatData_1aabbMinOrg_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btOptimizedBvhNodeFloatData *arg1 = (btOptimizedBvhNodeFloatData *) 0 ;
  btVector3FloatData *arg2 = (btVector3FloatData *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btOptimizedBvhNodeFloatData **)&jarg1; 
  arg2 = *(btVector3FloatData **)&jarg2; 
  if (arg1) (arg1)->m_aabbMinOrg = *arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btOptimizedBvhNodeFloatData_1aabbMinOrg_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btOptimizedBvhNodeFloatData *arg1 = (btOptimizedBvhNodeFloatData *) 0 ;
  btVector3FloatData *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btOptimizedBvhNodeFloatData **)&jarg1; 
  result = (btVector3FloatData *)& ((arg1)->m_aabbMinOrg);
  *(btVector3FloatData **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btOptimizedBvhNodeFloatData_1aabbMaxOrg_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btOptimizedBvhNodeFloatData *arg1 = (btOptimizedBvhNodeFloatData *) 0 ;
  btVector3FloatData *arg2 = (btVector3FloatData *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btOptimizedBvhNodeFloatData **)&jarg1; 
  arg2 = *(btVector3FloatData **)&jarg2; 
  if (arg1) (arg1)->m_aabbMaxOrg = *arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btOptimizedBvhNodeFloatData_1aabbMaxOrg_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btOptimizedBvhNodeFloatData *arg1 = (btOptimizedBvhNodeFloatData *) 0 ;
  btVector3FloatData *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btOptimizedBvhNodeFloatData **)&jarg1; 
  result = (btVector3FloatData *)& ((arg1)->m_aabbMaxOrg);
  *(btVector3FloatData **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btOptimizedBvhNodeFloatData_1escapeIndex_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  btOptimizedBvhNodeFloatData *arg1 = (btOptimizedBvhNodeFloatData *) 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btOptimizedBvhNodeFloatData **)&jarg1; 
  arg2 = (int)jarg2; 
  if (arg1) (arg1)->m_escapeIndex = arg2;
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btOptimizedBvhNodeFloatData_1escapeIndex_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  btOptimizedBvhNodeFloatData *arg1 = (btOptimizedBvhNodeFloatData *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btOptimizedBvhNodeFloatData **)&jarg1; 
  result = (int) ((arg1)->m_escapeIndex);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btOptimizedBvhNodeFloatData_1subPart_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  btOptimizedBvhNodeFloatData *arg1 = (btOptimizedBvhNodeFloatData *) 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btOptimizedBvhNodeFloatData **)&jarg1; 
  arg2 = (int)jarg2; 
  if (arg1) (arg1)->m_subPart = arg2;
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btOptimizedBvhNodeFloatData_1subPart_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  btOptimizedBvhNodeFloatData *arg1 = (btOptimizedBvhNodeFloatData *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btOptimizedBvhNodeFloatData **)&jarg1; 
  result = (int) ((arg1)->m_subPart);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btOptimizedBvhNodeFloatData_1triangleIndex_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  btOptimizedBvhNodeFloatData *arg1 = (btOptimizedBvhNodeFloatData *) 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btOptimizedBvhNodeFloatData **)&jarg1; 
  arg2 = (int)jarg2; 
  if (arg1) (arg1)->m_triangleIndex = arg2;
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btOptimizedBvhNodeFloatData_1triangleIndex_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  btOptimizedBvhNodeFloatData *arg1 = (btOptimizedBvhNodeFloatData *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btOptimizedBvhNodeFloatData **)&jarg1; 
  result = (int) ((arg1)->m_triangleIndex);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btOptimizedBvhNodeFloatData_1pad_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  btOptimizedBvhNodeFloatData *arg1 = (btOptimizedBvhNodeFloatData *) 0 ;
  char *arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btOptimizedBvhNodeFloatData **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return ;
  }
  {
    if(arg2) {
      strncpy((char*)arg1->m_pad, (const char *)arg2, 4-1);
      arg1->m_pad[4-1] = 0;
    } else {
      arg1->m_pad[0] = 0;
    }
  }
  
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
}


SWIGEXPORT jstring JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btOptimizedBvhNodeFloatData_1pad_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  btOptimizedBvhNodeFloatData *arg1 = (btOptimizedBvhNodeFloatData *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btOptimizedBvhNodeFloatData **)&jarg1; 
  result = (char *)(char *) ((arg1)->m_pad);
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_new_1btOptimizedBvhNodeFloatData(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  btOptimizedBvhNodeFloatData *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (btOptimizedBvhNodeFloatData *)new btOptimizedBvhNodeFloatData();
  *(btOptimizedBvhNodeFloatData **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_delete_1btOptimizedBvhNodeFloatData(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  btOptimizedBvhNodeFloatData *arg1 = (btOptimizedBvhNodeFloatData *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(btOptimizedBvhNodeFloatData **)&jarg1; 
  delete arg1;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btOptimizedBvhNodeDoubleData_1aabbMinOrg_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btOptimizedBvhNodeDoubleData *arg1 = (btOptimizedBvhNodeDoubleData *) 0 ;
  btVector3DoubleData *arg2 = (btVector3DoubleData *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btOptimizedBvhNodeDoubleData **)&jarg1; 
  arg2 = *(btVector3DoubleData **)&jarg2; 
  if (arg1) (arg1)->m_aabbMinOrg = *arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btOptimizedBvhNodeDoubleData_1aabbMinOrg_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btOptimizedBvhNodeDoubleData *arg1 = (btOptimizedBvhNodeDoubleData *) 0 ;
  btVector3DoubleData *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btOptimizedBvhNodeDoubleData **)&jarg1; 
  result = (btVector3DoubleData *)& ((arg1)->m_aabbMinOrg);
  *(btVector3DoubleData **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btOptimizedBvhNodeDoubleData_1aabbMaxOrg_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btOptimizedBvhNodeDoubleData *arg1 = (btOptimizedBvhNodeDoubleData *) 0 ;
  btVector3DoubleData *arg2 = (btVector3DoubleData *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btOptimizedBvhNodeDoubleData **)&jarg1; 
  arg2 = *(btVector3DoubleData **)&jarg2; 
  if (arg1) (arg1)->m_aabbMaxOrg = *arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btOptimizedBvhNodeDoubleData_1aabbMaxOrg_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btOptimizedBvhNodeDoubleData *arg1 = (btOptimizedBvhNodeDoubleData *) 0 ;
  btVector3DoubleData *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btOptimizedBvhNodeDoubleData **)&jarg1; 
  result = (btVector3DoubleData *)& ((arg1)->m_aabbMaxOrg);
  *(btVector3DoubleData **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btOptimizedBvhNodeDoubleData_1escapeIndex_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  btOptimizedBvhNodeDoubleData *arg1 = (btOptimizedBvhNodeDoubleData *) 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btOptimizedBvhNodeDoubleData **)&jarg1; 
  arg2 = (int)jarg2; 
  if (arg1) (arg1)->m_escapeIndex = arg2;
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btOptimizedBvhNodeDoubleData_1escapeIndex_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  btOptimizedBvhNodeDoubleData *arg1 = (btOptimizedBvhNodeDoubleData *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btOptimizedBvhNodeDoubleData **)&jarg1; 
  result = (int) ((arg1)->m_escapeIndex);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btOptimizedBvhNodeDoubleData_1subPart_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  btOptimizedBvhNodeDoubleData *arg1 = (btOptimizedBvhNodeDoubleData *) 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btOptimizedBvhNodeDoubleData **)&jarg1; 
  arg2 = (int)jarg2; 
  if (arg1) (arg1)->m_subPart = arg2;
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btOptimizedBvhNodeDoubleData_1subPart_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  btOptimizedBvhNodeDoubleData *arg1 = (btOptimizedBvhNodeDoubleData *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btOptimizedBvhNodeDoubleData **)&jarg1; 
  result = (int) ((arg1)->m_subPart);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btOptimizedBvhNodeDoubleData_1triangleIndex_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  btOptimizedBvhNodeDoubleData *arg1 = (btOptimizedBvhNodeDoubleData *) 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btOptimizedBvhNodeDoubleData **)&jarg1; 
  arg2 = (int)jarg2; 
  if (arg1) (arg1)->m_triangleIndex = arg2;
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btOptimizedBvhNodeDoubleData_1triangleIndex_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  btOptimizedBvhNodeDoubleData *arg1 = (btOptimizedBvhNodeDoubleData *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btOptimizedBvhNodeDoubleData **)&jarg1; 
  result = (int) ((arg1)->m_triangleIndex);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btOptimizedBvhNodeDoubleData_1pad_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  btOptimizedBvhNodeDoubleData *arg1 = (btOptimizedBvhNodeDoubleData *) 0 ;
  char *arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btOptimizedBvhNodeDoubleData **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return ;
  }
  {
    if(arg2) {
      strncpy((char*)arg1->m_pad, (const char *)arg2, 4-1);
      arg1->m_pad[4-1] = 0;
    } else {
      arg1->m_pad[0] = 0;
    }
  }
  
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
}


SWIGEXPORT jstring JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btOptimizedBvhNodeDoubleData_1pad_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  btOptimizedBvhNodeDoubleData *arg1 = (btOptimizedBvhNodeDoubleData *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btOptimizedBvhNodeDoubleData **)&jarg1; 
  result = (char *)(char *) ((arg1)->m_pad);
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_new_1btOptimizedBvhNodeDoubleData(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  btOptimizedBvhNodeDoubleData *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (btOptimizedBvhNodeDoubleData *)new btOptimizedBvhNodeDoubleData();
  *(btOptimizedBvhNodeDoubleData **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_delete_1btOptimizedBvhNodeDoubleData(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  btOptimizedBvhNodeDoubleData *arg1 = (btOptimizedBvhNodeDoubleData *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(btOptimizedBvhNodeDoubleData **)&jarg1; 
  delete arg1;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btQuantizedBvhNodeData_1quantizedAabbMin_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jintArray jarg2) {
  btQuantizedBvhNodeData *arg1 = (btQuantizedBvhNodeData *) 0 ;
  unsigned short *arg2 ;
  jint *jarr2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btQuantizedBvhNodeData **)&jarg1; 
  if (jarg2 && jenv->GetArrayLength(jarg2) != 3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, "incorrect array size");
    return ;
  }
  if (!SWIG_JavaArrayInUshort(jenv, &jarr2, (unsigned short **)&arg2, jarg2)) return ; 
  {
    size_t ii;
    unsigned short *b = (unsigned short *) arg1->m_quantizedAabbMin;
    for (ii = 0; ii < (size_t)3; ii++) b[ii] = *((unsigned short *) arg2 + ii);
  }
  SWIG_JavaArrayArgoutUshort(jenv, jarr2, (unsigned short *)arg2, jarg2); 
  delete [] arg2; 
}


SWIGEXPORT jintArray JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btQuantizedBvhNodeData_1quantizedAabbMin_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jintArray jresult = 0 ;
  btQuantizedBvhNodeData *arg1 = (btQuantizedBvhNodeData *) 0 ;
  unsigned short *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btQuantizedBvhNodeData **)&jarg1; 
  result = (unsigned short *)(unsigned short *) ((arg1)->m_quantizedAabbMin);
  jresult = SWIG_JavaArrayOutUshort(jenv, (unsigned short *)result, 3); 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btQuantizedBvhNodeData_1quantizedAabbMax_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jintArray jarg2) {
  btQuantizedBvhNodeData *arg1 = (btQuantizedBvhNodeData *) 0 ;
  unsigned short *arg2 ;
  jint *jarr2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btQuantizedBvhNodeData **)&jarg1; 
  if (jarg2 && jenv->GetArrayLength(jarg2) != 3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, "incorrect array size");
    return ;
  }
  if (!SWIG_JavaArrayInUshort(jenv, &jarr2, (unsigned short **)&arg2, jarg2)) return ; 
  {
    size_t ii;
    unsigned short *b = (unsigned short *) arg1->m_quantizedAabbMax;
    for (ii = 0; ii < (size_t)3; ii++) b[ii] = *((unsigned short *) arg2 + ii);
  }
  SWIG_JavaArrayArgoutUshort(jenv, jarr2, (unsigned short *)arg2, jarg2); 
  delete [] arg2; 
}


SWIGEXPORT jintArray JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btQuantizedBvhNodeData_1quantizedAabbMax_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jintArray jresult = 0 ;
  btQuantizedBvhNodeData *arg1 = (btQuantizedBvhNodeData *) 0 ;
  unsigned short *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btQuantizedBvhNodeData **)&jarg1; 
  result = (unsigned short *)(unsigned short *) ((arg1)->m_quantizedAabbMax);
  jresult = SWIG_JavaArrayOutUshort(jenv, (unsigned short *)result, 3); 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btQuantizedBvhNodeData_1escapeIndexOrTriangleIndex_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  btQuantizedBvhNodeData *arg1 = (btQuantizedBvhNodeData *) 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btQuantizedBvhNodeData **)&jarg1; 
  arg2 = (int)jarg2; 
  if (arg1) (arg1)->m_escapeIndexOrTriangleIndex = arg2;
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btQuantizedBvhNodeData_1escapeIndexOrTriangleIndex_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  btQuantizedBvhNodeData *arg1 = (btQuantizedBvhNodeData *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btQuantizedBvhNodeData **)&jarg1; 
  result = (int) ((arg1)->m_escapeIndexOrTriangleIndex);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_new_1btQuantizedBvhNodeData(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  btQuantizedBvhNodeData *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (btQuantizedBvhNodeData *)new btQuantizedBvhNodeData();
  *(btQuantizedBvhNodeData **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_delete_1btQuantizedBvhNodeData(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  btQuantizedBvhNodeData *arg1 = (btQuantizedBvhNodeData *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(btQuantizedBvhNodeData **)&jarg1; 
  delete arg1;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btQuantizedBvhFloatData_1bvhAabbMin_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btQuantizedBvhFloatData *arg1 = (btQuantizedBvhFloatData *) 0 ;
  btVector3FloatData *arg2 = (btVector3FloatData *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btQuantizedBvhFloatData **)&jarg1; 
  arg2 = *(btVector3FloatData **)&jarg2; 
  if (arg1) (arg1)->m_bvhAabbMin = *arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btQuantizedBvhFloatData_1bvhAabbMin_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btQuantizedBvhFloatData *arg1 = (btQuantizedBvhFloatData *) 0 ;
  btVector3FloatData *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btQuantizedBvhFloatData **)&jarg1; 
  result = (btVector3FloatData *)& ((arg1)->m_bvhAabbMin);
  *(btVector3FloatData **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btQuantizedBvhFloatData_1bvhAabbMax_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btQuantizedBvhFloatData *arg1 = (btQuantizedBvhFloatData *) 0 ;
  btVector3FloatData *arg2 = (btVector3FloatData *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btQuantizedBvhFloatData **)&jarg1; 
  arg2 = *(btVector3FloatData **)&jarg2; 
  if (arg1) (arg1)->m_bvhAabbMax = *arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btQuantizedBvhFloatData_1bvhAabbMax_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btQuantizedBvhFloatData *arg1 = (btQuantizedBvhFloatData *) 0 ;
  btVector3FloatData *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btQuantizedBvhFloatData **)&jarg1; 
  result = (btVector3FloatData *)& ((arg1)->m_bvhAabbMax);
  *(btVector3FloatData **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btQuantizedBvhFloatData_1bvhQuantization_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btQuantizedBvhFloatData *arg1 = (btQuantizedBvhFloatData *) 0 ;
  btVector3FloatData *arg2 = (btVector3FloatData *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btQuantizedBvhFloatData **)&jarg1; 
  arg2 = *(btVector3FloatData **)&jarg2; 
  if (arg1) (arg1)->m_bvhQuantization = *arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btQuantizedBvhFloatData_1bvhQuantization_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btQuantizedBvhFloatData *arg1 = (btQuantizedBvhFloatData *) 0 ;
  btVector3FloatData *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btQuantizedBvhFloatData **)&jarg1; 
  result = (btVector3FloatData *)& ((arg1)->m_bvhQuantization);
  *(btVector3FloatData **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btQuantizedBvhFloatData_1curNodeIndex_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  btQuantizedBvhFloatData *arg1 = (btQuantizedBvhFloatData *) 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btQuantizedBvhFloatData **)&jarg1; 
  arg2 = (int)jarg2; 
  if (arg1) (arg1)->m_curNodeIndex = arg2;
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btQuantizedBvhFloatData_1curNodeIndex_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  btQuantizedBvhFloatData *arg1 = (btQuantizedBvhFloatData *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btQuantizedBvhFloatData **)&jarg1; 
  result = (int) ((arg1)->m_curNodeIndex);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btQuantizedBvhFloatData_1useQuantization_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  btQuantizedBvhFloatData *arg1 = (btQuantizedBvhFloatData *) 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btQuantizedBvhFloatData **)&jarg1; 
  arg2 = (int)jarg2; 
  if (arg1) (arg1)->m_useQuantization = arg2;
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btQuantizedBvhFloatData_1useQuantization_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  btQuantizedBvhFloatData *arg1 = (btQuantizedBvhFloatData *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btQuantizedBvhFloatData **)&jarg1; 
  result = (int) ((arg1)->m_useQuantization);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btQuantizedBvhFloatData_1numContiguousLeafNodes_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  btQuantizedBvhFloatData *arg1 = (btQuantizedBvhFloatData *) 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btQuantizedBvhFloatData **)&jarg1; 
  arg2 = (int)jarg2; 
  if (arg1) (arg1)->m_numContiguousLeafNodes = arg2;
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btQuantizedBvhFloatData_1numContiguousLeafNodes_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  btQuantizedBvhFloatData *arg1 = (btQuantizedBvhFloatData *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btQuantizedBvhFloatData **)&jarg1; 
  result = (int) ((arg1)->m_numContiguousLeafNodes);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btQuantizedBvhFloatData_1numQuantizedContiguousNodes_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  btQuantizedBvhFloatData *arg1 = (btQuantizedBvhFloatData *) 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btQuantizedBvhFloatData **)&jarg1; 
  arg2 = (int)jarg2; 
  if (arg1) (arg1)->m_numQuantizedContiguousNodes = arg2;
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btQuantizedBvhFloatData_1numQuantizedContiguousNodes_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  btQuantizedBvhFloatData *arg1 = (btQuantizedBvhFloatData *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btQuantizedBvhFloatData **)&jarg1; 
  result = (int) ((arg1)->m_numQuantizedContiguousNodes);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btQuantizedBvhFloatData_1contiguousNodesPtr_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btQuantizedBvhFloatData *arg1 = (btQuantizedBvhFloatData *) 0 ;
  btOptimizedBvhNodeFloatData *arg2 = (btOptimizedBvhNodeFloatData *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btQuantizedBvhFloatData **)&jarg1; 
  arg2 = *(btOptimizedBvhNodeFloatData **)&jarg2; 
  if (arg1) (arg1)->m_contiguousNodesPtr = arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btQuantizedBvhFloatData_1contiguousNodesPtr_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btQuantizedBvhFloatData *arg1 = (btQuantizedBvhFloatData *) 0 ;
  btOptimizedBvhNodeFloatData *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btQuantizedBvhFloatData **)&jarg1; 
  result = (btOptimizedBvhNodeFloatData *) ((arg1)->m_contiguousNodesPtr);
  *(btOptimizedBvhNodeFloatData **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btQuantizedBvhFloatData_1quantizedContiguousNodesPtr_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btQuantizedBvhFloatData *arg1 = (btQuantizedBvhFloatData *) 0 ;
  btQuantizedBvhNodeData *arg2 = (btQuantizedBvhNodeData *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btQuantizedBvhFloatData **)&jarg1; 
  arg2 = *(btQuantizedBvhNodeData **)&jarg2; 
  if (arg1) (arg1)->m_quantizedContiguousNodesPtr = arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btQuantizedBvhFloatData_1quantizedContiguousNodesPtr_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btQuantizedBvhFloatData *arg1 = (btQuantizedBvhFloatData *) 0 ;
  btQuantizedBvhNodeData *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btQuantizedBvhFloatData **)&jarg1; 
  result = (btQuantizedBvhNodeData *) ((arg1)->m_quantizedContiguousNodesPtr);
  *(btQuantizedBvhNodeData **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btQuantizedBvhFloatData_1subTreeInfoPtr_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btQuantizedBvhFloatData *arg1 = (btQuantizedBvhFloatData *) 0 ;
  btBvhSubtreeInfoData *arg2 = (btBvhSubtreeInfoData *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btQuantizedBvhFloatData **)&jarg1; 
  arg2 = *(btBvhSubtreeInfoData **)&jarg2; 
  if (arg1) (arg1)->m_subTreeInfoPtr = arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btQuantizedBvhFloatData_1subTreeInfoPtr_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btQuantizedBvhFloatData *arg1 = (btQuantizedBvhFloatData *) 0 ;
  btBvhSubtreeInfoData *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btQuantizedBvhFloatData **)&jarg1; 
  result = (btBvhSubtreeInfoData *) ((arg1)->m_subTreeInfoPtr);
  *(btBvhSubtreeInfoData **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btQuantizedBvhFloatData_1traversalMode_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  btQuantizedBvhFloatData *arg1 = (btQuantizedBvhFloatData *) 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btQuantizedBvhFloatData **)&jarg1; 
  arg2 = (int)jarg2; 
  if (arg1) (arg1)->m_traversalMode = arg2;
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btQuantizedBvhFloatData_1traversalMode_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  btQuantizedBvhFloatData *arg1 = (btQuantizedBvhFloatData *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btQuantizedBvhFloatData **)&jarg1; 
  result = (int) ((arg1)->m_traversalMode);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btQuantizedBvhFloatData_1numSubtreeHeaders_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  btQuantizedBvhFloatData *arg1 = (btQuantizedBvhFloatData *) 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btQuantizedBvhFloatData **)&jarg1; 
  arg2 = (int)jarg2; 
  if (arg1) (arg1)->m_numSubtreeHeaders = arg2;
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btQuantizedBvhFloatData_1numSubtreeHeaders_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  btQuantizedBvhFloatData *arg1 = (btQuantizedBvhFloatData *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btQuantizedBvhFloatData **)&jarg1; 
  result = (int) ((arg1)->m_numSubtreeHeaders);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_new_1btQuantizedBvhFloatData(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  btQuantizedBvhFloatData *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (btQuantizedBvhFloatData *)new btQuantizedBvhFloatData();
  *(btQuantizedBvhFloatData **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_delete_1btQuantizedBvhFloatData(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  btQuantizedBvhFloatData *arg1 = (btQuantizedBvhFloatData *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(btQuantizedBvhFloatData **)&jarg1; 
  delete arg1;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btQuantizedBvhDoubleData_1bvhAabbMin_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btQuantizedBvhDoubleData *arg1 = (btQuantizedBvhDoubleData *) 0 ;
  btVector3DoubleData *arg2 = (btVector3DoubleData *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btQuantizedBvhDoubleData **)&jarg1; 
  arg2 = *(btVector3DoubleData **)&jarg2; 
  if (arg1) (arg1)->m_bvhAabbMin = *arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btQuantizedBvhDoubleData_1bvhAabbMin_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btQuantizedBvhDoubleData *arg1 = (btQuantizedBvhDoubleData *) 0 ;
  btVector3DoubleData *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btQuantizedBvhDoubleData **)&jarg1; 
  result = (btVector3DoubleData *)& ((arg1)->m_bvhAabbMin);
  *(btVector3DoubleData **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btQuantizedBvhDoubleData_1bvhAabbMax_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btQuantizedBvhDoubleData *arg1 = (btQuantizedBvhDoubleData *) 0 ;
  btVector3DoubleData *arg2 = (btVector3DoubleData *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btQuantizedBvhDoubleData **)&jarg1; 
  arg2 = *(btVector3DoubleData **)&jarg2; 
  if (arg1) (arg1)->m_bvhAabbMax = *arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btQuantizedBvhDoubleData_1bvhAabbMax_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btQuantizedBvhDoubleData *arg1 = (btQuantizedBvhDoubleData *) 0 ;
  btVector3DoubleData *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btQuantizedBvhDoubleData **)&jarg1; 
  result = (btVector3DoubleData *)& ((arg1)->m_bvhAabbMax);
  *(btVector3DoubleData **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btQuantizedBvhDoubleData_1bvhQuantization_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btQuantizedBvhDoubleData *arg1 = (btQuantizedBvhDoubleData *) 0 ;
  btVector3DoubleData *arg2 = (btVector3DoubleData *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btQuantizedBvhDoubleData **)&jarg1; 
  arg2 = *(btVector3DoubleData **)&jarg2; 
  if (arg1) (arg1)->m_bvhQuantization = *arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btQuantizedBvhDoubleData_1bvhQuantization_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btQuantizedBvhDoubleData *arg1 = (btQuantizedBvhDoubleData *) 0 ;
  btVector3DoubleData *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btQuantizedBvhDoubleData **)&jarg1; 
  result = (btVector3DoubleData *)& ((arg1)->m_bvhQuantization);
  *(btVector3DoubleData **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btQuantizedBvhDoubleData_1curNodeIndex_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  btQuantizedBvhDoubleData *arg1 = (btQuantizedBvhDoubleData *) 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btQuantizedBvhDoubleData **)&jarg1; 
  arg2 = (int)jarg2; 
  if (arg1) (arg1)->m_curNodeIndex = arg2;
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btQuantizedBvhDoubleData_1curNodeIndex_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  btQuantizedBvhDoubleData *arg1 = (btQuantizedBvhDoubleData *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btQuantizedBvhDoubleData **)&jarg1; 
  result = (int) ((arg1)->m_curNodeIndex);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btQuantizedBvhDoubleData_1useQuantization_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  btQuantizedBvhDoubleData *arg1 = (btQuantizedBvhDoubleData *) 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btQuantizedBvhDoubleData **)&jarg1; 
  arg2 = (int)jarg2; 
  if (arg1) (arg1)->m_useQuantization = arg2;
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btQuantizedBvhDoubleData_1useQuantization_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  btQuantizedBvhDoubleData *arg1 = (btQuantizedBvhDoubleData *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btQuantizedBvhDoubleData **)&jarg1; 
  result = (int) ((arg1)->m_useQuantization);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btQuantizedBvhDoubleData_1numContiguousLeafNodes_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  btQuantizedBvhDoubleData *arg1 = (btQuantizedBvhDoubleData *) 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btQuantizedBvhDoubleData **)&jarg1; 
  arg2 = (int)jarg2; 
  if (arg1) (arg1)->m_numContiguousLeafNodes = arg2;
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btQuantizedBvhDoubleData_1numContiguousLeafNodes_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  btQuantizedBvhDoubleData *arg1 = (btQuantizedBvhDoubleData *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btQuantizedBvhDoubleData **)&jarg1; 
  result = (int) ((arg1)->m_numContiguousLeafNodes);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btQuantizedBvhDoubleData_1numQuantizedContiguousNodes_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  btQuantizedBvhDoubleData *arg1 = (btQuantizedBvhDoubleData *) 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btQuantizedBvhDoubleData **)&jarg1; 
  arg2 = (int)jarg2; 
  if (arg1) (arg1)->m_numQuantizedContiguousNodes = arg2;
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btQuantizedBvhDoubleData_1numQuantizedContiguousNodes_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  btQuantizedBvhDoubleData *arg1 = (btQuantizedBvhDoubleData *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btQuantizedBvhDoubleData **)&jarg1; 
  result = (int) ((arg1)->m_numQuantizedContiguousNodes);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btQuantizedBvhDoubleData_1contiguousNodesPtr_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btQuantizedBvhDoubleData *arg1 = (btQuantizedBvhDoubleData *) 0 ;
  btOptimizedBvhNodeDoubleData *arg2 = (btOptimizedBvhNodeDoubleData *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btQuantizedBvhDoubleData **)&jarg1; 
  arg2 = *(btOptimizedBvhNodeDoubleData **)&jarg2; 
  if (arg1) (arg1)->m_contiguousNodesPtr = arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btQuantizedBvhDoubleData_1contiguousNodesPtr_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btQuantizedBvhDoubleData *arg1 = (btQuantizedBvhDoubleData *) 0 ;
  btOptimizedBvhNodeDoubleData *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btQuantizedBvhDoubleData **)&jarg1; 
  result = (btOptimizedBvhNodeDoubleData *) ((arg1)->m_contiguousNodesPtr);
  *(btOptimizedBvhNodeDoubleData **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btQuantizedBvhDoubleData_1quantizedContiguousNodesPtr_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btQuantizedBvhDoubleData *arg1 = (btQuantizedBvhDoubleData *) 0 ;
  btQuantizedBvhNodeData *arg2 = (btQuantizedBvhNodeData *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btQuantizedBvhDoubleData **)&jarg1; 
  arg2 = *(btQuantizedBvhNodeData **)&jarg2; 
  if (arg1) (arg1)->m_quantizedContiguousNodesPtr = arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btQuantizedBvhDoubleData_1quantizedContiguousNodesPtr_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btQuantizedBvhDoubleData *arg1 = (btQuantizedBvhDoubleData *) 0 ;
  btQuantizedBvhNodeData *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btQuantizedBvhDoubleData **)&jarg1; 
  result = (btQuantizedBvhNodeData *) ((arg1)->m_quantizedContiguousNodesPtr);
  *(btQuantizedBvhNodeData **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btQuantizedBvhDoubleData_1traversalMode_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  btQuantizedBvhDoubleData *arg1 = (btQuantizedBvhDoubleData *) 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btQuantizedBvhDoubleData **)&jarg1; 
  arg2 = (int)jarg2; 
  if (arg1) (arg1)->m_traversalMode = arg2;
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btQuantizedBvhDoubleData_1traversalMode_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  btQuantizedBvhDoubleData *arg1 = (btQuantizedBvhDoubleData *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btQuantizedBvhDoubleData **)&jarg1; 
  result = (int) ((arg1)->m_traversalMode);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btQuantizedBvhDoubleData_1numSubtreeHeaders_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  btQuantizedBvhDoubleData *arg1 = (btQuantizedBvhDoubleData *) 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btQuantizedBvhDoubleData **)&jarg1; 
  arg2 = (int)jarg2; 
  if (arg1) (arg1)->m_numSubtreeHeaders = arg2;
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btQuantizedBvhDoubleData_1numSubtreeHeaders_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  btQuantizedBvhDoubleData *arg1 = (btQuantizedBvhDoubleData *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btQuantizedBvhDoubleData **)&jarg1; 
  result = (int) ((arg1)->m_numSubtreeHeaders);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btQuantizedBvhDoubleData_1subTreeInfoPtr_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btQuantizedBvhDoubleData *arg1 = (btQuantizedBvhDoubleData *) 0 ;
  btBvhSubtreeInfoData *arg2 = (btBvhSubtreeInfoData *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btQuantizedBvhDoubleData **)&jarg1; 
  arg2 = *(btBvhSubtreeInfoData **)&jarg2; 
  if (arg1) (arg1)->m_subTreeInfoPtr = arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btQuantizedBvhDoubleData_1subTreeInfoPtr_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btQuantizedBvhDoubleData *arg1 = (btQuantizedBvhDoubleData *) 0 ;
  btBvhSubtreeInfoData *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btQuantizedBvhDoubleData **)&jarg1; 
  result = (btBvhSubtreeInfoData *) ((arg1)->m_subTreeInfoPtr);
  *(btBvhSubtreeInfoData **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_new_1btQuantizedBvhDoubleData(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  btQuantizedBvhDoubleData *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (btQuantizedBvhDoubleData *)new btQuantizedBvhDoubleData();
  *(btQuantizedBvhDoubleData **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_delete_1btQuantizedBvhDoubleData(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  btQuantizedBvhDoubleData *arg1 = (btQuantizedBvhDoubleData *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(btQuantizedBvhDoubleData **)&jarg1; 
  delete arg1;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btSimpleBroadphaseProxy_1nextFree_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  btSimpleBroadphaseProxy *arg1 = (btSimpleBroadphaseProxy *) 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSimpleBroadphaseProxy **)&jarg1; 
  arg2 = (int)jarg2; 
  if (arg1) (arg1)->m_nextFree = arg2;
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btSimpleBroadphaseProxy_1nextFree_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  btSimpleBroadphaseProxy *arg1 = (btSimpleBroadphaseProxy *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSimpleBroadphaseProxy **)&jarg1; 
  result = (int) ((arg1)->m_nextFree);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_new_1btSimpleBroadphaseProxy_1_1SWIG_10(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  btSimpleBroadphaseProxy *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (btSimpleBroadphaseProxy *)new btSimpleBroadphaseProxy();
  *(btSimpleBroadphaseProxy **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_new_1btSimpleBroadphaseProxy_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jobject jarg1, jobject jarg2, jint jarg3, jlong jarg4, jshort jarg5, jshort jarg6, jlong jarg7) {
  jlong jresult = 0 ;
  btVector3 *arg1 = 0 ;
  btVector3 *arg2 = 0 ;
  int arg3 ;
  void *arg4 = (void *) 0 ;
  short arg5 ;
  short arg6 ;
  void *arg7 = (void *) 0 ;
  btSimpleBroadphaseProxy *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  btVector3 local_arg1;
  gdx_setbtVector3FromVector3(jenv, local_arg1, jarg1);
  arg1 = &local_arg1;
  gdxAutoCommitVector3 auto_commit_arg1(jenv, jarg1, &local_arg1);
  btVector3 local_arg2;
  gdx_setbtVector3FromVector3(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitVector3 auto_commit_arg2(jenv, jarg2, &local_arg2);
  arg3 = (int)jarg3; 
  arg4 = (void *)jarg4; 
  arg5 = (short)jarg5; 
  arg6 = (short)jarg6; 
  arg7 = (void *)jarg7; 
  result = (btSimpleBroadphaseProxy *)new btSimpleBroadphaseProxy((btVector3 const &)*arg1,(btVector3 const &)*arg2,arg3,arg4,arg5,arg6,arg7);
  *(btSimpleBroadphaseProxy **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btSimpleBroadphaseProxy_1SetNextFree(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  btSimpleBroadphaseProxy *arg1 = (btSimpleBroadphaseProxy *) 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSimpleBroadphaseProxy **)&jarg1; 
  arg2 = (int)jarg2; 
  (arg1)->SetNextFree(arg2);
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btSimpleBroadphaseProxy_1GetNextFree(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  btSimpleBroadphaseProxy *arg1 = (btSimpleBroadphaseProxy *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSimpleBroadphaseProxy **)&jarg1; 
  result = (int)((btSimpleBroadphaseProxy const *)arg1)->GetNextFree();
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_delete_1btSimpleBroadphaseProxy(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  btSimpleBroadphaseProxy *arg1 = (btSimpleBroadphaseProxy *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(btSimpleBroadphaseProxy **)&jarg1; 
  delete arg1;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_new_1btSimpleBroadphase_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jint jarg1, jlong jarg2, jobject jarg2_) {
  jlong jresult = 0 ;
  int arg1 ;
  btOverlappingPairCache *arg2 = (btOverlappingPairCache *) 0 ;
  btSimpleBroadphase *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg2_;
  arg1 = (int)jarg1; 
  arg2 = *(btOverlappingPairCache **)&jarg2; 
  result = (btSimpleBroadphase *)new btSimpleBroadphase(arg1,arg2);
  *(btSimpleBroadphase **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_new_1btSimpleBroadphase_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jint jarg1) {
  jlong jresult = 0 ;
  int arg1 ;
  btSimpleBroadphase *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (int)jarg1; 
  result = (btSimpleBroadphase *)new btSimpleBroadphase(arg1);
  *(btSimpleBroadphase **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_new_1btSimpleBroadphase_1_1SWIG_12(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  btSimpleBroadphase *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (btSimpleBroadphase *)new btSimpleBroadphase();
  *(btSimpleBroadphase **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_delete_1btSimpleBroadphase(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  btSimpleBroadphase *arg1 = (btSimpleBroadphase *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(btSimpleBroadphase **)&jarg1; 
  delete arg1;
}


SWIGEXPORT jboolean JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btSimpleBroadphase_1aabbOverlap(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  jboolean jresult = 0 ;
  btSimpleBroadphaseProxy *arg1 = (btSimpleBroadphaseProxy *) 0 ;
  btSimpleBroadphaseProxy *arg2 = (btSimpleBroadphaseProxy *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btSimpleBroadphaseProxy **)&jarg1; 
  arg2 = *(btSimpleBroadphaseProxy **)&jarg2; 
  result = (bool)btSimpleBroadphase::aabbOverlap(arg1,arg2);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btSimpleBroadphase_1rayTest_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2, jobject jarg3, jlong jarg4, jobject jarg4_, jobject jarg5, jobject jarg6) {
  btSimpleBroadphase *arg1 = (btSimpleBroadphase *) 0 ;
  btVector3 *arg2 = 0 ;
  btVector3 *arg3 = 0 ;
  btBroadphaseRayCallback *arg4 = 0 ;
  btVector3 *arg5 = 0 ;
  btVector3 *arg6 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg4_;
  arg1 = *(btSimpleBroadphase **)&jarg1; 
  btVector3 local_arg2;
  gdx_setbtVector3FromVector3(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitVector3 auto_commit_arg2(jenv, jarg2, &local_arg2);
  btVector3 local_arg3;
  gdx_setbtVector3FromVector3(jenv, local_arg3, jarg3);
  arg3 = &local_arg3;
  gdxAutoCommitVector3 auto_commit_arg3(jenv, jarg3, &local_arg3);
  arg4 = *(btBroadphaseRayCallback **)&jarg4;
  if (!arg4) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btBroadphaseRayCallback & reference is null");
    return ;
  } 
  btVector3 local_arg5;
  gdx_setbtVector3FromVector3(jenv, local_arg5, jarg5);
  arg5 = &local_arg5;
  gdxAutoCommitVector3 auto_commit_arg5(jenv, jarg5, &local_arg5);
  btVector3 local_arg6;
  gdx_setbtVector3FromVector3(jenv, local_arg6, jarg6);
  arg6 = &local_arg6;
  gdxAutoCommitVector3 auto_commit_arg6(jenv, jarg6, &local_arg6);
  (arg1)->rayTest((btVector3 const &)*arg2,(btVector3 const &)*arg3,*arg4,(btVector3 const &)*arg5,(btVector3 const &)*arg6);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btSimpleBroadphase_1rayTest_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2, jobject jarg3, jlong jarg4, jobject jarg4_, jobject jarg5) {
  btSimpleBroadphase *arg1 = (btSimpleBroadphase *) 0 ;
  btVector3 *arg2 = 0 ;
  btVector3 *arg3 = 0 ;
  btBroadphaseRayCallback *arg4 = 0 ;
  btVector3 *arg5 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg4_;
  arg1 = *(btSimpleBroadphase **)&jarg1; 
  btVector3 local_arg2;
  gdx_setbtVector3FromVector3(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitVector3 auto_commit_arg2(jenv, jarg2, &local_arg2);
  btVector3 local_arg3;
  gdx_setbtVector3FromVector3(jenv, local_arg3, jarg3);
  arg3 = &local_arg3;
  gdxAutoCommitVector3 auto_commit_arg3(jenv, jarg3, &local_arg3);
  arg4 = *(btBroadphaseRayCallback **)&jarg4;
  if (!arg4) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btBroadphaseRayCallback & reference is null");
    return ;
  } 
  btVector3 local_arg5;
  gdx_setbtVector3FromVector3(jenv, local_arg5, jarg5);
  arg5 = &local_arg5;
  gdxAutoCommitVector3 auto_commit_arg5(jenv, jarg5, &local_arg5);
  (arg1)->rayTest((btVector3 const &)*arg2,(btVector3 const &)*arg3,*arg4,(btVector3 const &)*arg5);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btSimpleBroadphase_1rayTest_1_1SWIG_12(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2, jobject jarg3, jlong jarg4, jobject jarg4_) {
  btSimpleBroadphase *arg1 = (btSimpleBroadphase *) 0 ;
  btVector3 *arg2 = 0 ;
  btVector3 *arg3 = 0 ;
  btBroadphaseRayCallback *arg4 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg4_;
  arg1 = *(btSimpleBroadphase **)&jarg1; 
  btVector3 local_arg2;
  gdx_setbtVector3FromVector3(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitVector3 auto_commit_arg2(jenv, jarg2, &local_arg2);
  btVector3 local_arg3;
  gdx_setbtVector3FromVector3(jenv, local_arg3, jarg3);
  arg3 = &local_arg3;
  gdxAutoCommitVector3 auto_commit_arg3(jenv, jarg3, &local_arg3);
  arg4 = *(btBroadphaseRayCallback **)&jarg4;
  if (!arg4) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btBroadphaseRayCallback & reference is null");
    return ;
  } 
  (arg1)->rayTest((btVector3 const &)*arg2,(btVector3 const &)*arg3,*arg4);
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btSimpleBroadphase_1getOverlappingPairCache_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btSimpleBroadphase *arg1 = (btSimpleBroadphase *) 0 ;
  btOverlappingPairCache *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSimpleBroadphase **)&jarg1; 
  result = (btOverlappingPairCache *)(arg1)->getOverlappingPairCache();
  *(btOverlappingPairCache **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btSimpleBroadphase_1testAabbOverlap(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlong jarg3, jobject jarg3_) {
  jboolean jresult = 0 ;
  btSimpleBroadphase *arg1 = (btSimpleBroadphase *) 0 ;
  btBroadphaseProxy *arg2 = (btBroadphaseProxy *) 0 ;
  btBroadphaseProxy *arg3 = (btBroadphaseProxy *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  (void)jarg3_;
  arg1 = *(btSimpleBroadphase **)&jarg1; 
  arg2 = *(btBroadphaseProxy **)&jarg2; 
  arg3 = *(btBroadphaseProxy **)&jarg3; 
  result = (bool)(arg1)->testAabbOverlap(arg2,arg3);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btMultiSapBroadphase_1btMultiSapProxy_1aabbMin_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btMultiSapBroadphase::btMultiSapProxy *arg1 = (btMultiSapBroadphase::btMultiSapProxy *) 0 ;
  btVector3 *arg2 = (btVector3 *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btMultiSapBroadphase::btMultiSapProxy **)&jarg1; 
  arg2 = *(btVector3 **)&jarg2; 
  if (arg1) (arg1)->m_aabbMin = *arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btMultiSapBroadphase_1btMultiSapProxy_1aabbMin_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btMultiSapBroadphase::btMultiSapProxy *arg1 = (btMultiSapBroadphase::btMultiSapProxy *) 0 ;
  btVector3 *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btMultiSapBroadphase::btMultiSapProxy **)&jarg1; 
  result = (btVector3 *)& ((arg1)->m_aabbMin);
  *(btVector3 **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btMultiSapBroadphase_1btMultiSapProxy_1aabbMax_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btMultiSapBroadphase::btMultiSapProxy *arg1 = (btMultiSapBroadphase::btMultiSapProxy *) 0 ;
  btVector3 *arg2 = (btVector3 *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btMultiSapBroadphase::btMultiSapProxy **)&jarg1; 
  arg2 = *(btVector3 **)&jarg2; 
  if (arg1) (arg1)->m_aabbMax = *arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btMultiSapBroadphase_1btMultiSapProxy_1aabbMax_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btMultiSapBroadphase::btMultiSapProxy *arg1 = (btMultiSapBroadphase::btMultiSapProxy *) 0 ;
  btVector3 *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btMultiSapBroadphase::btMultiSapProxy **)&jarg1; 
  result = (btVector3 *)& ((arg1)->m_aabbMax);
  *(btVector3 **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btMultiSapBroadphase_1btMultiSapProxy_1shapeType_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  btMultiSapBroadphase::btMultiSapProxy *arg1 = (btMultiSapBroadphase::btMultiSapProxy *) 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btMultiSapBroadphase::btMultiSapProxy **)&jarg1; 
  arg2 = (int)jarg2; 
  if (arg1) (arg1)->m_shapeType = arg2;
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btMultiSapBroadphase_1btMultiSapProxy_1shapeType_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  btMultiSapBroadphase::btMultiSapProxy *arg1 = (btMultiSapBroadphase::btMultiSapProxy *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btMultiSapBroadphase::btMultiSapProxy **)&jarg1; 
  result = (int) ((arg1)->m_shapeType);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_new_1btMultiSapBroadphase_1btMultiSapProxy(JNIEnv *jenv, jclass jcls, jobject jarg1, jobject jarg2, jint jarg3, jlong jarg4, jshort jarg5, jshort jarg6) {
  jlong jresult = 0 ;
  btVector3 *arg1 = 0 ;
  btVector3 *arg2 = 0 ;
  int arg3 ;
  void *arg4 = (void *) 0 ;
  short arg5 ;
  short arg6 ;
  btMultiSapBroadphase::btMultiSapProxy *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  btVector3 local_arg1;
  gdx_setbtVector3FromVector3(jenv, local_arg1, jarg1);
  arg1 = &local_arg1;
  gdxAutoCommitVector3 auto_commit_arg1(jenv, jarg1, &local_arg1);
  btVector3 local_arg2;
  gdx_setbtVector3FromVector3(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitVector3 auto_commit_arg2(jenv, jarg2, &local_arg2);
  arg3 = (int)jarg3; 
  arg4 = (void *)jarg4; 
  arg5 = (short)jarg5; 
  arg6 = (short)jarg6; 
  result = (btMultiSapBroadphase::btMultiSapProxy *)new btMultiSapBroadphase::btMultiSapProxy((btVector3 const &)*arg1,(btVector3 const &)*arg2,arg3,arg4,arg5,arg6);
  *(btMultiSapBroadphase::btMultiSapProxy **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_delete_1btMultiSapBroadphase_1btMultiSapProxy(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  btMultiSapBroadphase::btMultiSapProxy *arg1 = (btMultiSapBroadphase::btMultiSapProxy *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(btMultiSapBroadphase::btMultiSapProxy **)&jarg1; 
  delete arg1;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btMultiSapBroadphase_1getBroadphaseArray_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btMultiSapBroadphase *arg1 = (btMultiSapBroadphase *) 0 ;
  btSapBroadphaseArray *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btMultiSapBroadphase **)&jarg1; 
  result = (btSapBroadphaseArray *) &(arg1)->getBroadphaseArray();
  *(btSapBroadphaseArray **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_delete_1btMultiSapBroadphase(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  btMultiSapBroadphase *arg1 = (btMultiSapBroadphase *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(btMultiSapBroadphase **)&jarg1; 
  delete arg1;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btMultiSapBroadphase_1rayTest_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2, jobject jarg3, jlong jarg4, jobject jarg4_, jobject jarg5, jobject jarg6) {
  btMultiSapBroadphase *arg1 = (btMultiSapBroadphase *) 0 ;
  btVector3 *arg2 = 0 ;
  btVector3 *arg3 = 0 ;
  btBroadphaseRayCallback *arg4 = 0 ;
  btVector3 *arg5 = 0 ;
  btVector3 *arg6 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg4_;
  arg1 = *(btMultiSapBroadphase **)&jarg1; 
  btVector3 local_arg2;
  gdx_setbtVector3FromVector3(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitVector3 auto_commit_arg2(jenv, jarg2, &local_arg2);
  btVector3 local_arg3;
  gdx_setbtVector3FromVector3(jenv, local_arg3, jarg3);
  arg3 = &local_arg3;
  gdxAutoCommitVector3 auto_commit_arg3(jenv, jarg3, &local_arg3);
  arg4 = *(btBroadphaseRayCallback **)&jarg4;
  if (!arg4) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btBroadphaseRayCallback & reference is null");
    return ;
  } 
  btVector3 local_arg5;
  gdx_setbtVector3FromVector3(jenv, local_arg5, jarg5);
  arg5 = &local_arg5;
  gdxAutoCommitVector3 auto_commit_arg5(jenv, jarg5, &local_arg5);
  btVector3 local_arg6;
  gdx_setbtVector3FromVector3(jenv, local_arg6, jarg6);
  arg6 = &local_arg6;
  gdxAutoCommitVector3 auto_commit_arg6(jenv, jarg6, &local_arg6);
  (arg1)->rayTest((btVector3 const &)*arg2,(btVector3 const &)*arg3,*arg4,(btVector3 const &)*arg5,(btVector3 const &)*arg6);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btMultiSapBroadphase_1rayTest_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2, jobject jarg3, jlong jarg4, jobject jarg4_, jobject jarg5) {
  btMultiSapBroadphase *arg1 = (btMultiSapBroadphase *) 0 ;
  btVector3 *arg2 = 0 ;
  btVector3 *arg3 = 0 ;
  btBroadphaseRayCallback *arg4 = 0 ;
  btVector3 *arg5 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg4_;
  arg1 = *(btMultiSapBroadphase **)&jarg1; 
  btVector3 local_arg2;
  gdx_setbtVector3FromVector3(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitVector3 auto_commit_arg2(jenv, jarg2, &local_arg2);
  btVector3 local_arg3;
  gdx_setbtVector3FromVector3(jenv, local_arg3, jarg3);
  arg3 = &local_arg3;
  gdxAutoCommitVector3 auto_commit_arg3(jenv, jarg3, &local_arg3);
  arg4 = *(btBroadphaseRayCallback **)&jarg4;
  if (!arg4) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btBroadphaseRayCallback & reference is null");
    return ;
  } 
  btVector3 local_arg5;
  gdx_setbtVector3FromVector3(jenv, local_arg5, jarg5);
  arg5 = &local_arg5;
  gdxAutoCommitVector3 auto_commit_arg5(jenv, jarg5, &local_arg5);
  (arg1)->rayTest((btVector3 const &)*arg2,(btVector3 const &)*arg3,*arg4,(btVector3 const &)*arg5);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btMultiSapBroadphase_1rayTest_1_1SWIG_12(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2, jobject jarg3, jlong jarg4, jobject jarg4_) {
  btMultiSapBroadphase *arg1 = (btMultiSapBroadphase *) 0 ;
  btVector3 *arg2 = 0 ;
  btVector3 *arg3 = 0 ;
  btBroadphaseRayCallback *arg4 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg4_;
  arg1 = *(btMultiSapBroadphase **)&jarg1; 
  btVector3 local_arg2;
  gdx_setbtVector3FromVector3(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitVector3 auto_commit_arg2(jenv, jarg2, &local_arg2);
  btVector3 local_arg3;
  gdx_setbtVector3FromVector3(jenv, local_arg3, jarg3);
  arg3 = &local_arg3;
  gdxAutoCommitVector3 auto_commit_arg3(jenv, jarg3, &local_arg3);
  arg4 = *(btBroadphaseRayCallback **)&jarg4;
  if (!arg4) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btBroadphaseRayCallback & reference is null");
    return ;
  } 
  (arg1)->rayTest((btVector3 const &)*arg2,(btVector3 const &)*arg3,*arg4);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btMultiSapBroadphase_1addToChildBroadphase(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlong jarg3, jobject jarg3_, jlong jarg4, jobject jarg4_) {
  btMultiSapBroadphase *arg1 = (btMultiSapBroadphase *) 0 ;
  btMultiSapBroadphase::btMultiSapProxy *arg2 = (btMultiSapBroadphase::btMultiSapProxy *) 0 ;
  btBroadphaseProxy *arg3 = (btBroadphaseProxy *) 0 ;
  btBroadphaseInterface *arg4 = (btBroadphaseInterface *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  (void)jarg3_;
  (void)jarg4_;
  arg1 = *(btMultiSapBroadphase **)&jarg1; 
  arg2 = *(btMultiSapBroadphase::btMultiSapProxy **)&jarg2; 
  arg3 = *(btBroadphaseProxy **)&jarg3; 
  arg4 = *(btBroadphaseInterface **)&jarg4; 
  (arg1)->addToChildBroadphase(arg2,arg3,arg4);
}


SWIGEXPORT jboolean JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btMultiSapBroadphase_1testAabbOverlap(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlong jarg3, jobject jarg3_) {
  jboolean jresult = 0 ;
  btMultiSapBroadphase *arg1 = (btMultiSapBroadphase *) 0 ;
  btBroadphaseProxy *arg2 = (btBroadphaseProxy *) 0 ;
  btBroadphaseProxy *arg3 = (btBroadphaseProxy *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  (void)jarg3_;
  arg1 = *(btMultiSapBroadphase **)&jarg1; 
  arg2 = *(btBroadphaseProxy **)&jarg2; 
  arg3 = *(btBroadphaseProxy **)&jarg3; 
  result = (bool)(arg1)->testAabbOverlap(arg2,arg3);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btMultiSapBroadphase_1getOverlappingPairCache_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btMultiSapBroadphase *arg1 = (btMultiSapBroadphase *) 0 ;
  btOverlappingPairCache *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btMultiSapBroadphase **)&jarg1; 
  result = (btOverlappingPairCache *)(arg1)->getOverlappingPairCache();
  *(btOverlappingPairCache **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btMultiSapBroadphase_1buildTree(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2, jobject jarg3) {
  btMultiSapBroadphase *arg1 = (btMultiSapBroadphase *) 0 ;
  btVector3 *arg2 = 0 ;
  btVector3 *arg3 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btMultiSapBroadphase **)&jarg1; 
  btVector3 local_arg2;
  gdx_setbtVector3FromVector3(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitVector3 auto_commit_arg2(jenv, jarg2, &local_arg2);
  btVector3 local_arg3;
  gdx_setbtVector3FromVector3(jenv, local_arg3, jarg3);
  arg3 = &local_arg3;
  gdxAutoCommitVector3 auto_commit_arg3(jenv, jarg3, &local_arg3);
  (arg1)->buildTree((btVector3 const &)*arg2,(btVector3 const &)*arg3);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btMultiSapBroadphase_1quicksort(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jint jarg3, jint jarg4) {
  btMultiSapBroadphase *arg1 = (btMultiSapBroadphase *) 0 ;
  btBroadphasePairArray *arg2 = 0 ;
  int arg3 ;
  int arg4 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btMultiSapBroadphase **)&jarg1; 
  arg2 = *(btBroadphasePairArray **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btBroadphasePairArray & reference is null");
    return ;
  } 
  arg3 = (int)jarg3; 
  arg4 = (int)jarg4; 
  (arg1)->quicksort(*arg2,arg3,arg4);
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_new_1btCollisionAlgorithmConstructionInfo_1_1SWIG_10(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  btCollisionAlgorithmConstructionInfo *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (btCollisionAlgorithmConstructionInfo *)new btCollisionAlgorithmConstructionInfo();
  *(btCollisionAlgorithmConstructionInfo **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_new_1btCollisionAlgorithmConstructionInfo_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  jlong jresult = 0 ;
  btDispatcher *arg1 = (btDispatcher *) 0 ;
  int arg2 ;
  btCollisionAlgorithmConstructionInfo *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btDispatcher **)&jarg1; 
  arg2 = (int)jarg2; 
  result = (btCollisionAlgorithmConstructionInfo *)new btCollisionAlgorithmConstructionInfo(arg1,arg2);
  *(btCollisionAlgorithmConstructionInfo **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btCollisionAlgorithmConstructionInfo_1dispatcher1_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btCollisionAlgorithmConstructionInfo *arg1 = (btCollisionAlgorithmConstructionInfo *) 0 ;
  btDispatcher *arg2 = (btDispatcher *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btCollisionAlgorithmConstructionInfo **)&jarg1; 
  arg2 = *(btDispatcher **)&jarg2; 
  if (arg1) (arg1)->m_dispatcher1 = arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btCollisionAlgorithmConstructionInfo_1dispatcher1_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btCollisionAlgorithmConstructionInfo *arg1 = (btCollisionAlgorithmConstructionInfo *) 0 ;
  btDispatcher *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btCollisionAlgorithmConstructionInfo **)&jarg1; 
  result = (btDispatcher *) ((arg1)->m_dispatcher1);
  *(btDispatcher **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btCollisionAlgorithmConstructionInfo_1manifold_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btCollisionAlgorithmConstructionInfo *arg1 = (btCollisionAlgorithmConstructionInfo *) 0 ;
  btPersistentManifold *arg2 = (btPersistentManifold *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btCollisionAlgorithmConstructionInfo **)&jarg1; 
  arg2 = *(btPersistentManifold **)&jarg2; 
  if (arg1) (arg1)->m_manifold = arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btCollisionAlgorithmConstructionInfo_1manifold_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btCollisionAlgorithmConstructionInfo *arg1 = (btCollisionAlgorithmConstructionInfo *) 0 ;
  btPersistentManifold *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btCollisionAlgorithmConstructionInfo **)&jarg1; 
  result = (btPersistentManifold *) ((arg1)->m_manifold);
  *(btPersistentManifold **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_delete_1btCollisionAlgorithmConstructionInfo(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  btCollisionAlgorithmConstructionInfo *arg1 = (btCollisionAlgorithmConstructionInfo *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(btCollisionAlgorithmConstructionInfo **)&jarg1; 
  delete arg1;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_delete_1btCollisionAlgorithm(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  btCollisionAlgorithm *arg1 = (btCollisionAlgorithm *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(btCollisionAlgorithm **)&jarg1; 
  delete arg1;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btCollisionAlgorithm_1processCollision(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlong jarg3, jobject jarg3_, jlong jarg4, jobject jarg4_, jlong jarg5, jobject jarg5_) {
  btCollisionAlgorithm *arg1 = (btCollisionAlgorithm *) 0 ;
  btCollisionObjectWrapper *arg2 = (btCollisionObjectWrapper *) 0 ;
  btCollisionObjectWrapper *arg3 = (btCollisionObjectWrapper *) 0 ;
  btDispatcherInfo *arg4 = 0 ;
  btManifoldResult *arg5 = (btManifoldResult *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  (void)jarg3_;
  (void)jarg4_;
  (void)jarg5_;
  arg1 = *(btCollisionAlgorithm **)&jarg1; 
  arg2 = *(btCollisionObjectWrapper **)&jarg2; 
  arg3 = *(btCollisionObjectWrapper **)&jarg3; 
  arg4 = *(btDispatcherInfo **)&jarg4;
  if (!arg4) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btDispatcherInfo const & reference is null");
    return ;
  } 
  arg5 = *(btManifoldResult **)&jarg5; 
  (arg1)->processCollision((btCollisionObjectWrapper const *)arg2,(btCollisionObjectWrapper const *)arg3,(btDispatcherInfo const &)*arg4,arg5);
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btCollisionAlgorithm_1calculateTimeOfImpact(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlong jarg3, jobject jarg3_, jlong jarg4, jobject jarg4_, jlong jarg5, jobject jarg5_) {
  jfloat jresult = 0 ;
  btCollisionAlgorithm *arg1 = (btCollisionAlgorithm *) 0 ;
  btCollisionObject *arg2 = (btCollisionObject *) 0 ;
  btCollisionObject *arg3 = (btCollisionObject *) 0 ;
  btDispatcherInfo *arg4 = 0 ;
  btManifoldResult *arg5 = (btManifoldResult *) 0 ;
  btScalar result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  (void)jarg3_;
  (void)jarg4_;
  (void)jarg5_;
  arg1 = *(btCollisionAlgorithm **)&jarg1; 
  arg2 = *(btCollisionObject **)&jarg2; 
  arg3 = *(btCollisionObject **)&jarg3; 
  arg4 = *(btDispatcherInfo **)&jarg4;
  if (!arg4) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btDispatcherInfo const & reference is null");
    return 0;
  } 
  arg5 = *(btManifoldResult **)&jarg5; 
  result = (btScalar)(arg1)->calculateTimeOfImpact(arg2,arg3,(btDispatcherInfo const &)*arg4,arg5);
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btCollisionAlgorithm_1getAllContactManifolds(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btCollisionAlgorithm *arg1 = (btCollisionAlgorithm *) 0 ;
  btManifoldArray *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btCollisionAlgorithm **)&jarg1; 
  arg2 = *(btManifoldArray **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btManifoldArray & reference is null");
    return ;
  } 
  (arg1)->getAllContactManifolds(*arg2);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_delete_1btOverlappingPairCallback(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  btOverlappingPairCallback *arg1 = (btOverlappingPairCallback *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(btOverlappingPairCallback **)&jarg1; 
  delete arg1;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btOverlappingPairCallback_1addOverlappingPair(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlong jarg3, jobject jarg3_) {
  jlong jresult = 0 ;
  btOverlappingPairCallback *arg1 = (btOverlappingPairCallback *) 0 ;
  btBroadphaseProxy *arg2 = (btBroadphaseProxy *) 0 ;
  btBroadphaseProxy *arg3 = (btBroadphaseProxy *) 0 ;
  btBroadphasePair *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  (void)jarg3_;
  arg1 = *(btOverlappingPairCallback **)&jarg1; 
  arg2 = *(btBroadphaseProxy **)&jarg2; 
  arg3 = *(btBroadphaseProxy **)&jarg3; 
  result = (btBroadphasePair *)(arg1)->addOverlappingPair(arg2,arg3);
  *(btBroadphasePair **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btOverlappingPairCallback_1removeOverlappingPair(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlong jarg3, jobject jarg3_, jlong jarg4, jobject jarg4_) {
  jlong jresult = 0 ;
  btOverlappingPairCallback *arg1 = (btOverlappingPairCallback *) 0 ;
  btBroadphaseProxy *arg2 = (btBroadphaseProxy *) 0 ;
  btBroadphaseProxy *arg3 = (btBroadphaseProxy *) 0 ;
  btDispatcher *arg4 = (btDispatcher *) 0 ;
  void *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  (void)jarg3_;
  (void)jarg4_;
  arg1 = *(btOverlappingPairCallback **)&jarg1; 
  arg2 = *(btBroadphaseProxy **)&jarg2; 
  arg3 = *(btBroadphaseProxy **)&jarg3; 
  arg4 = *(btDispatcher **)&jarg4; 
  result = (void *)(arg1)->removeOverlappingPair(arg2,arg3,arg4);
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btOverlappingPairCallback_1removeOverlappingPairsContainingProxy(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlong jarg3, jobject jarg3_) {
  btOverlappingPairCallback *arg1 = (btOverlappingPairCallback *) 0 ;
  btBroadphaseProxy *arg2 = (btBroadphaseProxy *) 0 ;
  btDispatcher *arg3 = (btDispatcher *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  (void)jarg3_;
  arg1 = *(btOverlappingPairCallback **)&jarg1; 
  arg2 = *(btBroadphaseProxy **)&jarg2; 
  arg3 = *(btDispatcher **)&jarg3; 
  (arg1)->removeOverlappingPairsContainingProxy(arg2,arg3);
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_new_1btOverlappingPairCallback(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  btOverlappingPairCallback *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (btOverlappingPairCallback *)new SwigDirector_btOverlappingPairCallback(jenv);
  *(btOverlappingPairCallback **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btOverlappingPairCallback_1director_1connect(JNIEnv *jenv, jclass jcls, jobject jself, jlong objarg, jboolean jswig_mem_own, jboolean jweak_global) {
  btOverlappingPairCallback *obj = *((btOverlappingPairCallback **)&objarg);
  (void)jcls;
  SwigDirector_btOverlappingPairCallback *director = (SwigDirector_btOverlappingPairCallback *)(obj);
  if (director) {
    director->swig_connect_director(jenv, jself, jenv->GetObjectClass(jself), (jswig_mem_own == JNI_TRUE), (jweak_global == JNI_TRUE));
  }
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btOverlappingPairCallback_1change_1ownership(JNIEnv *jenv, jclass jcls, jobject jself, jlong objarg, jboolean jtake_or_release) {
  btOverlappingPairCallback *obj = *((btOverlappingPairCallback **)&objarg);
  SwigDirector_btOverlappingPairCallback *director = (SwigDirector_btOverlappingPairCallback *)(obj);
  (void)jcls;
  if (director) {
    director->swig_java_change_ownership(jenv, jself, jtake_or_release ? true : false);
  }
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_gOverlappingPairs_1set(JNIEnv *jenv, jclass jcls, jint jarg1) {
  int arg1 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (int)jarg1; 
  gOverlappingPairs = arg1;
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_gOverlappingPairs_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  result = (int)gOverlappingPairs;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btAxisSweep3InternalShort_1Edge_1pos_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  btAxisSweep3Internal< unsigned short >::Edge *arg1 = (btAxisSweep3Internal< unsigned short >::Edge *) 0 ;
  unsigned short arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btAxisSweep3Internal< unsigned short >::Edge **)&jarg1; 
  arg2 = (unsigned short)jarg2; 
  if (arg1) (arg1)->m_pos = arg2;
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btAxisSweep3InternalShort_1Edge_1pos_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  btAxisSweep3Internal< unsigned short >::Edge *arg1 = (btAxisSweep3Internal< unsigned short >::Edge *) 0 ;
  unsigned short result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btAxisSweep3Internal< unsigned short >::Edge **)&jarg1; 
  result = (unsigned short) ((arg1)->m_pos);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btAxisSweep3InternalShort_1Edge_1handle_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  btAxisSweep3Internal< unsigned short >::Edge *arg1 = (btAxisSweep3Internal< unsigned short >::Edge *) 0 ;
  unsigned short arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btAxisSweep3Internal< unsigned short >::Edge **)&jarg1; 
  arg2 = (unsigned short)jarg2; 
  if (arg1) (arg1)->m_handle = arg2;
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btAxisSweep3InternalShort_1Edge_1handle_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  btAxisSweep3Internal< unsigned short >::Edge *arg1 = (btAxisSweep3Internal< unsigned short >::Edge *) 0 ;
  unsigned short result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btAxisSweep3Internal< unsigned short >::Edge **)&jarg1; 
  result = (unsigned short) ((arg1)->m_handle);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btAxisSweep3InternalShort_1Edge_1IsMax(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  btAxisSweep3Internal< unsigned short >::Edge *arg1 = (btAxisSweep3Internal< unsigned short >::Edge *) 0 ;
  unsigned short result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btAxisSweep3Internal< unsigned short >::Edge **)&jarg1; 
  result = (unsigned short)((btAxisSweep3Internal< unsigned short >::Edge const *)arg1)->IsMax();
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_new_1btAxisSweep3InternalShort_1Edge(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  btAxisSweep3Internal< unsigned short >::Edge *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (btAxisSweep3Internal< unsigned short >::Edge *)new btAxisSweep3Internal< unsigned short >::Edge();
  *(btAxisSweep3Internal< unsigned short >::Edge **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_delete_1btAxisSweep3InternalShort_1Edge(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  btAxisSweep3Internal< unsigned short >::Edge *arg1 = (btAxisSweep3Internal< unsigned short >::Edge *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(btAxisSweep3Internal< unsigned short >::Edge **)&jarg1; 
  delete arg1;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btAxisSweep3InternalShort_1Handle_1minEdges_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jintArray jarg2) {
  btAxisSweep3Internal< unsigned short >::Handle *arg1 = (btAxisSweep3Internal< unsigned short >::Handle *) 0 ;
  unsigned short *arg2 ;
  jint *jarr2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btAxisSweep3Internal< unsigned short >::Handle **)&jarg1; 
  if (jarg2 && jenv->GetArrayLength(jarg2) != 3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, "incorrect array size");
    return ;
  }
  if (!SWIG_JavaArrayInUshort(jenv, &jarr2, (unsigned short **)&arg2, jarg2)) return ; 
  {
    size_t ii;
    unsigned short *b = (unsigned short *) arg1->m_minEdges;
    for (ii = 0; ii < (size_t)3; ii++) b[ii] = *((unsigned short *) arg2 + ii);
  }
  SWIG_JavaArrayArgoutUshort(jenv, jarr2, (unsigned short *)arg2, jarg2); 
  delete [] arg2; 
}


SWIGEXPORT jintArray JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btAxisSweep3InternalShort_1Handle_1minEdges_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jintArray jresult = 0 ;
  btAxisSweep3Internal< unsigned short >::Handle *arg1 = (btAxisSweep3Internal< unsigned short >::Handle *) 0 ;
  unsigned short *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btAxisSweep3Internal< unsigned short >::Handle **)&jarg1; 
  result = (unsigned short *)(unsigned short *) ((arg1)->m_minEdges);
  jresult = SWIG_JavaArrayOutUshort(jenv, (unsigned short *)result, 3); 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btAxisSweep3InternalShort_1Handle_1maxEdges_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jintArray jarg2) {
  btAxisSweep3Internal< unsigned short >::Handle *arg1 = (btAxisSweep3Internal< unsigned short >::Handle *) 0 ;
  unsigned short *arg2 ;
  jint *jarr2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btAxisSweep3Internal< unsigned short >::Handle **)&jarg1; 
  if (jarg2 && jenv->GetArrayLength(jarg2) != 3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, "incorrect array size");
    return ;
  }
  if (!SWIG_JavaArrayInUshort(jenv, &jarr2, (unsigned short **)&arg2, jarg2)) return ; 
  {
    size_t ii;
    unsigned short *b = (unsigned short *) arg1->m_maxEdges;
    for (ii = 0; ii < (size_t)3; ii++) b[ii] = *((unsigned short *) arg2 + ii);
  }
  SWIG_JavaArrayArgoutUshort(jenv, jarr2, (unsigned short *)arg2, jarg2); 
  delete [] arg2; 
}


SWIGEXPORT jintArray JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btAxisSweep3InternalShort_1Handle_1maxEdges_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jintArray jresult = 0 ;
  btAxisSweep3Internal< unsigned short >::Handle *arg1 = (btAxisSweep3Internal< unsigned short >::Handle *) 0 ;
  unsigned short *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btAxisSweep3Internal< unsigned short >::Handle **)&jarg1; 
  result = (unsigned short *)(unsigned short *) ((arg1)->m_maxEdges);
  jresult = SWIG_JavaArrayOutUshort(jenv, (unsigned short *)result, 3); 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btAxisSweep3InternalShort_1Handle_1dbvtProxy_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btAxisSweep3Internal< unsigned short >::Handle *arg1 = (btAxisSweep3Internal< unsigned short >::Handle *) 0 ;
  btBroadphaseProxy *arg2 = (btBroadphaseProxy *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btAxisSweep3Internal< unsigned short >::Handle **)&jarg1; 
  arg2 = *(btBroadphaseProxy **)&jarg2; 
  if (arg1) (arg1)->m_dbvtProxy = arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btAxisSweep3InternalShort_1Handle_1dbvtProxy_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btAxisSweep3Internal< unsigned short >::Handle *arg1 = (btAxisSweep3Internal< unsigned short >::Handle *) 0 ;
  btBroadphaseProxy *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btAxisSweep3Internal< unsigned short >::Handle **)&jarg1; 
  result = (btBroadphaseProxy *) ((arg1)->m_dbvtProxy);
  *(btBroadphaseProxy **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btAxisSweep3InternalShort_1Handle_1SetNextFree(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  btAxisSweep3Internal< unsigned short >::Handle *arg1 = (btAxisSweep3Internal< unsigned short >::Handle *) 0 ;
  unsigned short arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btAxisSweep3Internal< unsigned short >::Handle **)&jarg1; 
  arg2 = (unsigned short)jarg2; 
  (arg1)->SetNextFree(arg2);
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btAxisSweep3InternalShort_1Handle_1GetNextFree(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  btAxisSweep3Internal< unsigned short >::Handle *arg1 = (btAxisSweep3Internal< unsigned short >::Handle *) 0 ;
  unsigned short result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btAxisSweep3Internal< unsigned short >::Handle **)&jarg1; 
  result = (unsigned short)((btAxisSweep3Internal< unsigned short >::Handle const *)arg1)->GetNextFree();
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_new_1btAxisSweep3InternalShort_1Handle(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  btAxisSweep3Internal< unsigned short >::Handle *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (btAxisSweep3Internal< unsigned short >::Handle *)new btAxisSweep3Internal< unsigned short >::Handle();
  *(btAxisSweep3Internal< unsigned short >::Handle **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_delete_1btAxisSweep3InternalShort_1Handle(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  btAxisSweep3Internal< unsigned short >::Handle *arg1 = (btAxisSweep3Internal< unsigned short >::Handle *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(btAxisSweep3Internal< unsigned short >::Handle **)&jarg1; 
  delete arg1;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_new_1btAxisSweep3InternalShort_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jobject jarg1, jobject jarg2, jint jarg3, jint jarg4, jint jarg5, jlong jarg6, jobject jarg6_, jboolean jarg7) {
  jlong jresult = 0 ;
  btVector3 *arg1 = 0 ;
  btVector3 *arg2 = 0 ;
  unsigned short arg3 ;
  unsigned short arg4 ;
  unsigned short arg5 ;
  btOverlappingPairCache *arg6 = (btOverlappingPairCache *) 0 ;
  bool arg7 ;
  btAxisSweep3Internal< unsigned short > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg6_;
  btVector3 local_arg1;
  gdx_setbtVector3FromVector3(jenv, local_arg1, jarg1);
  arg1 = &local_arg1;
  gdxAutoCommitVector3 auto_commit_arg1(jenv, jarg1, &local_arg1);
  btVector3 local_arg2;
  gdx_setbtVector3FromVector3(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitVector3 auto_commit_arg2(jenv, jarg2, &local_arg2);
  arg3 = (unsigned short)jarg3; 
  arg4 = (unsigned short)jarg4; 
  arg5 = (unsigned short)jarg5; 
  arg6 = *(btOverlappingPairCache **)&jarg6; 
  arg7 = jarg7 ? true : false; 
  result = (btAxisSweep3Internal< unsigned short > *)new btAxisSweep3Internal< unsigned short >((btVector3 const &)*arg1,(btVector3 const &)*arg2,arg3,arg4,arg5,arg6,arg7);
  *(btAxisSweep3Internal< unsigned short > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_new_1btAxisSweep3InternalShort_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jobject jarg1, jobject jarg2, jint jarg3, jint jarg4, jint jarg5, jlong jarg6, jobject jarg6_) {
  jlong jresult = 0 ;
  btVector3 *arg1 = 0 ;
  btVector3 *arg2 = 0 ;
  unsigned short arg3 ;
  unsigned short arg4 ;
  unsigned short arg5 ;
  btOverlappingPairCache *arg6 = (btOverlappingPairCache *) 0 ;
  btAxisSweep3Internal< unsigned short > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg6_;
  btVector3 local_arg1;
  gdx_setbtVector3FromVector3(jenv, local_arg1, jarg1);
  arg1 = &local_arg1;
  gdxAutoCommitVector3 auto_commit_arg1(jenv, jarg1, &local_arg1);
  btVector3 local_arg2;
  gdx_setbtVector3FromVector3(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitVector3 auto_commit_arg2(jenv, jarg2, &local_arg2);
  arg3 = (unsigned short)jarg3; 
  arg4 = (unsigned short)jarg4; 
  arg5 = (unsigned short)jarg5; 
  arg6 = *(btOverlappingPairCache **)&jarg6; 
  result = (btAxisSweep3Internal< unsigned short > *)new btAxisSweep3Internal< unsigned short >((btVector3 const &)*arg1,(btVector3 const &)*arg2,arg3,arg4,arg5,arg6);
  *(btAxisSweep3Internal< unsigned short > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_new_1btAxisSweep3InternalShort_1_1SWIG_12(JNIEnv *jenv, jclass jcls, jobject jarg1, jobject jarg2, jint jarg3, jint jarg4, jint jarg5) {
  jlong jresult = 0 ;
  btVector3 *arg1 = 0 ;
  btVector3 *arg2 = 0 ;
  unsigned short arg3 ;
  unsigned short arg4 ;
  unsigned short arg5 ;
  btAxisSweep3Internal< unsigned short > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  btVector3 local_arg1;
  gdx_setbtVector3FromVector3(jenv, local_arg1, jarg1);
  arg1 = &local_arg1;
  gdxAutoCommitVector3 auto_commit_arg1(jenv, jarg1, &local_arg1);
  btVector3 local_arg2;
  gdx_setbtVector3FromVector3(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitVector3 auto_commit_arg2(jenv, jarg2, &local_arg2);
  arg3 = (unsigned short)jarg3; 
  arg4 = (unsigned short)jarg4; 
  arg5 = (unsigned short)jarg5; 
  result = (btAxisSweep3Internal< unsigned short > *)new btAxisSweep3Internal< unsigned short >((btVector3 const &)*arg1,(btVector3 const &)*arg2,arg3,arg4,arg5);
  *(btAxisSweep3Internal< unsigned short > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_new_1btAxisSweep3InternalShort_1_1SWIG_13(JNIEnv *jenv, jclass jcls, jobject jarg1, jobject jarg2, jint jarg3, jint jarg4) {
  jlong jresult = 0 ;
  btVector3 *arg1 = 0 ;
  btVector3 *arg2 = 0 ;
  unsigned short arg3 ;
  unsigned short arg4 ;
  btAxisSweep3Internal< unsigned short > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  btVector3 local_arg1;
  gdx_setbtVector3FromVector3(jenv, local_arg1, jarg1);
  arg1 = &local_arg1;
  gdxAutoCommitVector3 auto_commit_arg1(jenv, jarg1, &local_arg1);
  btVector3 local_arg2;
  gdx_setbtVector3FromVector3(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitVector3 auto_commit_arg2(jenv, jarg2, &local_arg2);
  arg3 = (unsigned short)jarg3; 
  arg4 = (unsigned short)jarg4; 
  result = (btAxisSweep3Internal< unsigned short > *)new btAxisSweep3Internal< unsigned short >((btVector3 const &)*arg1,(btVector3 const &)*arg2,arg3,arg4);
  *(btAxisSweep3Internal< unsigned short > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_delete_1btAxisSweep3InternalShort(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  btAxisSweep3Internal< unsigned short > *arg1 = (btAxisSweep3Internal< unsigned short > *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(btAxisSweep3Internal< unsigned short > **)&jarg1; 
  delete arg1;
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btAxisSweep3InternalShort_1getNumHandles(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  btAxisSweep3Internal< unsigned short > *arg1 = (btAxisSweep3Internal< unsigned short > *) 0 ;
  unsigned short result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btAxisSweep3Internal< unsigned short > **)&jarg1; 
  result = (unsigned short)((btAxisSweep3Internal< unsigned short > const *)arg1)->getNumHandles();
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btAxisSweep3InternalShort_1addHandle(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2, jobject jarg3, jlong jarg4, jshort jarg5, jshort jarg6, jlong jarg7, jobject jarg7_, jlong jarg8) {
  jint jresult = 0 ;
  btAxisSweep3Internal< unsigned short > *arg1 = (btAxisSweep3Internal< unsigned short > *) 0 ;
  btVector3 *arg2 = 0 ;
  btVector3 *arg3 = 0 ;
  void *arg4 = (void *) 0 ;
  short arg5 ;
  short arg6 ;
  btDispatcher *arg7 = (btDispatcher *) 0 ;
  void *arg8 = (void *) 0 ;
  unsigned short result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg7_;
  arg1 = *(btAxisSweep3Internal< unsigned short > **)&jarg1; 
  btVector3 local_arg2;
  gdx_setbtVector3FromVector3(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitVector3 auto_commit_arg2(jenv, jarg2, &local_arg2);
  btVector3 local_arg3;
  gdx_setbtVector3FromVector3(jenv, local_arg3, jarg3);
  arg3 = &local_arg3;
  gdxAutoCommitVector3 auto_commit_arg3(jenv, jarg3, &local_arg3);
  arg4 = (void *)jarg4; 
  arg5 = (short)jarg5; 
  arg6 = (short)jarg6; 
  arg7 = *(btDispatcher **)&jarg7; 
  arg8 = (void *)jarg8; 
  result = (unsigned short)(arg1)->addHandle((btVector3 const &)*arg2,(btVector3 const &)*arg3,arg4,arg5,arg6,arg7,arg8);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btAxisSweep3InternalShort_1removeHandle(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jlong jarg3, jobject jarg3_) {
  btAxisSweep3Internal< unsigned short > *arg1 = (btAxisSweep3Internal< unsigned short > *) 0 ;
  unsigned short arg2 ;
  btDispatcher *arg3 = (btDispatcher *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg3_;
  arg1 = *(btAxisSweep3Internal< unsigned short > **)&jarg1; 
  arg2 = (unsigned short)jarg2; 
  arg3 = *(btDispatcher **)&jarg3; 
  (arg1)->removeHandle(arg2,arg3);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btAxisSweep3InternalShort_1updateHandle(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jobject jarg3, jobject jarg4, jlong jarg5, jobject jarg5_) {
  btAxisSweep3Internal< unsigned short > *arg1 = (btAxisSweep3Internal< unsigned short > *) 0 ;
  unsigned short arg2 ;
  btVector3 *arg3 = 0 ;
  btVector3 *arg4 = 0 ;
  btDispatcher *arg5 = (btDispatcher *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg5_;
  arg1 = *(btAxisSweep3Internal< unsigned short > **)&jarg1; 
  arg2 = (unsigned short)jarg2; 
  btVector3 local_arg3;
  gdx_setbtVector3FromVector3(jenv, local_arg3, jarg3);
  arg3 = &local_arg3;
  gdxAutoCommitVector3 auto_commit_arg3(jenv, jarg3, &local_arg3);
  btVector3 local_arg4;
  gdx_setbtVector3FromVector3(jenv, local_arg4, jarg4);
  arg4 = &local_arg4;
  gdxAutoCommitVector3 auto_commit_arg4(jenv, jarg4, &local_arg4);
  arg5 = *(btDispatcher **)&jarg5; 
  (arg1)->updateHandle(arg2,(btVector3 const &)*arg3,(btVector3 const &)*arg4,arg5);
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btAxisSweep3InternalShort_1getHandle(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  jlong jresult = 0 ;
  btAxisSweep3Internal< unsigned short > *arg1 = (btAxisSweep3Internal< unsigned short > *) 0 ;
  unsigned short arg2 ;
  btAxisSweep3Internal< unsigned short >::Handle *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btAxisSweep3Internal< unsigned short > **)&jarg1; 
  arg2 = (unsigned short)jarg2; 
  result = (btAxisSweep3Internal< unsigned short >::Handle *)((btAxisSweep3Internal< unsigned short > const *)arg1)->getHandle(arg2);
  *(btAxisSweep3Internal< unsigned short >::Handle **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btAxisSweep3InternalShort_1rayTest_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2, jobject jarg3, jlong jarg4, jobject jarg4_, jobject jarg5, jobject jarg6) {
  btAxisSweep3Internal< unsigned short > *arg1 = (btAxisSweep3Internal< unsigned short > *) 0 ;
  btVector3 *arg2 = 0 ;
  btVector3 *arg3 = 0 ;
  btBroadphaseRayCallback *arg4 = 0 ;
  btVector3 *arg5 = 0 ;
  btVector3 *arg6 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg4_;
  arg1 = *(btAxisSweep3Internal< unsigned short > **)&jarg1; 
  btVector3 local_arg2;
  gdx_setbtVector3FromVector3(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitVector3 auto_commit_arg2(jenv, jarg2, &local_arg2);
  btVector3 local_arg3;
  gdx_setbtVector3FromVector3(jenv, local_arg3, jarg3);
  arg3 = &local_arg3;
  gdxAutoCommitVector3 auto_commit_arg3(jenv, jarg3, &local_arg3);
  arg4 = *(btBroadphaseRayCallback **)&jarg4;
  if (!arg4) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btBroadphaseRayCallback & reference is null");
    return ;
  } 
  btVector3 local_arg5;
  gdx_setbtVector3FromVector3(jenv, local_arg5, jarg5);
  arg5 = &local_arg5;
  gdxAutoCommitVector3 auto_commit_arg5(jenv, jarg5, &local_arg5);
  btVector3 local_arg6;
  gdx_setbtVector3FromVector3(jenv, local_arg6, jarg6);
  arg6 = &local_arg6;
  gdxAutoCommitVector3 auto_commit_arg6(jenv, jarg6, &local_arg6);
  (arg1)->rayTest((btVector3 const &)*arg2,(btVector3 const &)*arg3,*arg4,(btVector3 const &)*arg5,(btVector3 const &)*arg6);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btAxisSweep3InternalShort_1rayTest_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2, jobject jarg3, jlong jarg4, jobject jarg4_, jobject jarg5) {
  btAxisSweep3Internal< unsigned short > *arg1 = (btAxisSweep3Internal< unsigned short > *) 0 ;
  btVector3 *arg2 = 0 ;
  btVector3 *arg3 = 0 ;
  btBroadphaseRayCallback *arg4 = 0 ;
  btVector3 *arg5 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg4_;
  arg1 = *(btAxisSweep3Internal< unsigned short > **)&jarg1; 
  btVector3 local_arg2;
  gdx_setbtVector3FromVector3(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitVector3 auto_commit_arg2(jenv, jarg2, &local_arg2);
  btVector3 local_arg3;
  gdx_setbtVector3FromVector3(jenv, local_arg3, jarg3);
  arg3 = &local_arg3;
  gdxAutoCommitVector3 auto_commit_arg3(jenv, jarg3, &local_arg3);
  arg4 = *(btBroadphaseRayCallback **)&jarg4;
  if (!arg4) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btBroadphaseRayCallback & reference is null");
    return ;
  } 
  btVector3 local_arg5;
  gdx_setbtVector3FromVector3(jenv, local_arg5, jarg5);
  arg5 = &local_arg5;
  gdxAutoCommitVector3 auto_commit_arg5(jenv, jarg5, &local_arg5);
  (arg1)->rayTest((btVector3 const &)*arg2,(btVector3 const &)*arg3,*arg4,(btVector3 const &)*arg5);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btAxisSweep3InternalShort_1rayTest_1_1SWIG_12(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2, jobject jarg3, jlong jarg4, jobject jarg4_) {
  btAxisSweep3Internal< unsigned short > *arg1 = (btAxisSweep3Internal< unsigned short > *) 0 ;
  btVector3 *arg2 = 0 ;
  btVector3 *arg3 = 0 ;
  btBroadphaseRayCallback *arg4 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg4_;
  arg1 = *(btAxisSweep3Internal< unsigned short > **)&jarg1; 
  btVector3 local_arg2;
  gdx_setbtVector3FromVector3(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitVector3 auto_commit_arg2(jenv, jarg2, &local_arg2);
  btVector3 local_arg3;
  gdx_setbtVector3FromVector3(jenv, local_arg3, jarg3);
  arg3 = &local_arg3;
  gdxAutoCommitVector3 auto_commit_arg3(jenv, jarg3, &local_arg3);
  arg4 = *(btBroadphaseRayCallback **)&jarg4;
  if (!arg4) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btBroadphaseRayCallback & reference is null");
    return ;
  } 
  (arg1)->rayTest((btVector3 const &)*arg2,(btVector3 const &)*arg3,*arg4);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btAxisSweep3InternalShort_1quantize(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2, jobject jarg3, jint jarg4) {
  btAxisSweep3Internal< unsigned short > *arg1 = (btAxisSweep3Internal< unsigned short > *) 0 ;
  unsigned short *arg2 = (unsigned short *) 0 ;
  btVector3 *arg3 = 0 ;
  int arg4 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btAxisSweep3Internal< unsigned short > **)&jarg1; 
  {
    arg2 = (unsigned short*)jenv->GetDirectBufferAddress(jarg2);
    if (arg2 == NULL) {
      SWIG_JavaThrowException(jenv, SWIG_JavaRuntimeException, "Unable to get address of direct buffer. Buffer must be allocated direct.");
    }
  }
  btVector3 local_arg3;
  gdx_setbtVector3FromVector3(jenv, local_arg3, jarg3);
  arg3 = &local_arg3;
  gdxAutoCommitVector3 auto_commit_arg3(jenv, jarg3, &local_arg3);
  arg4 = (int)jarg4; 
  ((btAxisSweep3Internal< unsigned short > const *)arg1)->quantize(arg2,(btVector3 const &)*arg3,arg4);
  
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btAxisSweep3InternalShort_1unQuantize(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jobject jarg3, jobject jarg4) {
  btAxisSweep3Internal< unsigned short > *arg1 = (btAxisSweep3Internal< unsigned short > *) 0 ;
  btBroadphaseProxy *arg2 = (btBroadphaseProxy *) 0 ;
  btVector3 *arg3 = 0 ;
  btVector3 *arg4 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btAxisSweep3Internal< unsigned short > **)&jarg1; 
  arg2 = *(btBroadphaseProxy **)&jarg2; 
  btVector3 local_arg3;
  gdx_setbtVector3FromVector3(jenv, local_arg3, jarg3);
  arg3 = &local_arg3;
  gdxAutoCommitVector3 auto_commit_arg3(jenv, jarg3, &local_arg3);
  btVector3 local_arg4;
  gdx_setbtVector3FromVector3(jenv, local_arg4, jarg4);
  arg4 = &local_arg4;
  gdxAutoCommitVector3 auto_commit_arg4(jenv, jarg4, &local_arg4);
  ((btAxisSweep3Internal< unsigned short > const *)arg1)->unQuantize(arg2,*arg3,*arg4);
}


SWIGEXPORT jboolean JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btAxisSweep3InternalShort_1testAabbOverlap(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlong jarg3, jobject jarg3_) {
  jboolean jresult = 0 ;
  btAxisSweep3Internal< unsigned short > *arg1 = (btAxisSweep3Internal< unsigned short > *) 0 ;
  btBroadphaseProxy *arg2 = (btBroadphaseProxy *) 0 ;
  btBroadphaseProxy *arg3 = (btBroadphaseProxy *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  (void)jarg3_;
  arg1 = *(btAxisSweep3Internal< unsigned short > **)&jarg1; 
  arg2 = *(btBroadphaseProxy **)&jarg2; 
  arg3 = *(btBroadphaseProxy **)&jarg3; 
  result = (bool)(arg1)->testAabbOverlap(arg2,arg3);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btAxisSweep3InternalShort_1getOverlappingPairCache_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btAxisSweep3Internal< unsigned short > *arg1 = (btAxisSweep3Internal< unsigned short > *) 0 ;
  btOverlappingPairCache *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btAxisSweep3Internal< unsigned short > **)&jarg1; 
  result = (btOverlappingPairCache *)(arg1)->getOverlappingPairCache();
  *(btOverlappingPairCache **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btAxisSweep3InternalShort_1setOverlappingPairUserCallback(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btAxisSweep3Internal< unsigned short > *arg1 = (btAxisSweep3Internal< unsigned short > *) 0 ;
  btOverlappingPairCallback *arg2 = (btOverlappingPairCallback *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btAxisSweep3Internal< unsigned short > **)&jarg1; 
  arg2 = *(btOverlappingPairCallback **)&jarg2; 
  (arg1)->setOverlappingPairUserCallback(arg2);
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btAxisSweep3InternalShort_1getOverlappingPairUserCallback(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btAxisSweep3Internal< unsigned short > *arg1 = (btAxisSweep3Internal< unsigned short > *) 0 ;
  btOverlappingPairCallback *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btAxisSweep3Internal< unsigned short > **)&jarg1; 
  result = (btOverlappingPairCallback *)((btAxisSweep3Internal< unsigned short > const *)arg1)->getOverlappingPairUserCallback();
  *(btOverlappingPairCallback **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btAxisSweep3InternalInt_1Edge_1pos_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  btAxisSweep3Internal< unsigned int >::Edge *arg1 = (btAxisSweep3Internal< unsigned int >::Edge *) 0 ;
  unsigned int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btAxisSweep3Internal< unsigned int >::Edge **)&jarg1; 
  arg2 = (unsigned int)jarg2; 
  if (arg1) (arg1)->m_pos = arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btAxisSweep3InternalInt_1Edge_1pos_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btAxisSweep3Internal< unsigned int >::Edge *arg1 = (btAxisSweep3Internal< unsigned int >::Edge *) 0 ;
  unsigned int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btAxisSweep3Internal< unsigned int >::Edge **)&jarg1; 
  result = (unsigned int) ((arg1)->m_pos);
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btAxisSweep3InternalInt_1Edge_1handle_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  btAxisSweep3Internal< unsigned int >::Edge *arg1 = (btAxisSweep3Internal< unsigned int >::Edge *) 0 ;
  unsigned int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btAxisSweep3Internal< unsigned int >::Edge **)&jarg1; 
  arg2 = (unsigned int)jarg2; 
  if (arg1) (arg1)->m_handle = arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btAxisSweep3InternalInt_1Edge_1handle_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btAxisSweep3Internal< unsigned int >::Edge *arg1 = (btAxisSweep3Internal< unsigned int >::Edge *) 0 ;
  unsigned int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btAxisSweep3Internal< unsigned int >::Edge **)&jarg1; 
  result = (unsigned int) ((arg1)->m_handle);
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btAxisSweep3InternalInt_1Edge_1IsMax(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btAxisSweep3Internal< unsigned int >::Edge *arg1 = (btAxisSweep3Internal< unsigned int >::Edge *) 0 ;
  unsigned int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btAxisSweep3Internal< unsigned int >::Edge **)&jarg1; 
  result = (unsigned int)((btAxisSweep3Internal< unsigned int >::Edge const *)arg1)->IsMax();
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_new_1btAxisSweep3InternalInt_1Edge(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  btAxisSweep3Internal< unsigned int >::Edge *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (btAxisSweep3Internal< unsigned int >::Edge *)new btAxisSweep3Internal< unsigned int >::Edge();
  *(btAxisSweep3Internal< unsigned int >::Edge **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_delete_1btAxisSweep3InternalInt_1Edge(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  btAxisSweep3Internal< unsigned int >::Edge *arg1 = (btAxisSweep3Internal< unsigned int >::Edge *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(btAxisSweep3Internal< unsigned int >::Edge **)&jarg1; 
  delete arg1;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btAxisSweep3InternalInt_1Handle_1minEdges_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlongArray jarg2) {
  btAxisSweep3Internal< unsigned int >::Handle *arg1 = (btAxisSweep3Internal< unsigned int >::Handle *) 0 ;
  unsigned int *arg2 ;
  jlong *jarr2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btAxisSweep3Internal< unsigned int >::Handle **)&jarg1; 
  if (jarg2 && jenv->GetArrayLength(jarg2) != 3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, "incorrect array size");
    return ;
  }
  if (!SWIG_JavaArrayInUint(jenv, &jarr2, (unsigned int **)&arg2, jarg2)) return ; 
  {
    size_t ii;
    unsigned int *b = (unsigned int *) arg1->m_minEdges;
    for (ii = 0; ii < (size_t)3; ii++) b[ii] = *((unsigned int *) arg2 + ii);
  }
  SWIG_JavaArrayArgoutUint(jenv, jarr2, (unsigned int *)arg2, jarg2); 
  delete [] arg2; 
}


SWIGEXPORT jlongArray JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btAxisSweep3InternalInt_1Handle_1minEdges_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlongArray jresult = 0 ;
  btAxisSweep3Internal< unsigned int >::Handle *arg1 = (btAxisSweep3Internal< unsigned int >::Handle *) 0 ;
  unsigned int *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btAxisSweep3Internal< unsigned int >::Handle **)&jarg1; 
  result = (unsigned int *)(unsigned int *) ((arg1)->m_minEdges);
  jresult = SWIG_JavaArrayOutUint(jenv, (unsigned int *)result, 3); 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btAxisSweep3InternalInt_1Handle_1maxEdges_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlongArray jarg2) {
  btAxisSweep3Internal< unsigned int >::Handle *arg1 = (btAxisSweep3Internal< unsigned int >::Handle *) 0 ;
  unsigned int *arg2 ;
  jlong *jarr2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btAxisSweep3Internal< unsigned int >::Handle **)&jarg1; 
  if (jarg2 && jenv->GetArrayLength(jarg2) != 3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, "incorrect array size");
    return ;
  }
  if (!SWIG_JavaArrayInUint(jenv, &jarr2, (unsigned int **)&arg2, jarg2)) return ; 
  {
    size_t ii;
    unsigned int *b = (unsigned int *) arg1->m_maxEdges;
    for (ii = 0; ii < (size_t)3; ii++) b[ii] = *((unsigned int *) arg2 + ii);
  }
  SWIG_JavaArrayArgoutUint(jenv, jarr2, (unsigned int *)arg2, jarg2); 
  delete [] arg2; 
}


SWIGEXPORT jlongArray JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btAxisSweep3InternalInt_1Handle_1maxEdges_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlongArray jresult = 0 ;
  btAxisSweep3Internal< unsigned int >::Handle *arg1 = (btAxisSweep3Internal< unsigned int >::Handle *) 0 ;
  unsigned int *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btAxisSweep3Internal< unsigned int >::Handle **)&jarg1; 
  result = (unsigned int *)(unsigned int *) ((arg1)->m_maxEdges);
  jresult = SWIG_JavaArrayOutUint(jenv, (unsigned int *)result, 3); 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btAxisSweep3InternalInt_1Handle_1dbvtProxy_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btAxisSweep3Internal< unsigned int >::Handle *arg1 = (btAxisSweep3Internal< unsigned int >::Handle *) 0 ;
  btBroadphaseProxy *arg2 = (btBroadphaseProxy *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btAxisSweep3Internal< unsigned int >::Handle **)&jarg1; 
  arg2 = *(btBroadphaseProxy **)&jarg2; 
  if (arg1) (arg1)->m_dbvtProxy = arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btAxisSweep3InternalInt_1Handle_1dbvtProxy_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btAxisSweep3Internal< unsigned int >::Handle *arg1 = (btAxisSweep3Internal< unsigned int >::Handle *) 0 ;
  btBroadphaseProxy *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btAxisSweep3Internal< unsigned int >::Handle **)&jarg1; 
  result = (btBroadphaseProxy *) ((arg1)->m_dbvtProxy);
  *(btBroadphaseProxy **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btAxisSweep3InternalInt_1Handle_1SetNextFree(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  btAxisSweep3Internal< unsigned int >::Handle *arg1 = (btAxisSweep3Internal< unsigned int >::Handle *) 0 ;
  unsigned int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btAxisSweep3Internal< unsigned int >::Handle **)&jarg1; 
  arg2 = (unsigned int)jarg2; 
  (arg1)->SetNextFree(arg2);
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btAxisSweep3InternalInt_1Handle_1GetNextFree(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btAxisSweep3Internal< unsigned int >::Handle *arg1 = (btAxisSweep3Internal< unsigned int >::Handle *) 0 ;
  unsigned int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btAxisSweep3Internal< unsigned int >::Handle **)&jarg1; 
  result = (unsigned int)((btAxisSweep3Internal< unsigned int >::Handle const *)arg1)->GetNextFree();
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_new_1btAxisSweep3InternalInt_1Handle(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  btAxisSweep3Internal< unsigned int >::Handle *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (btAxisSweep3Internal< unsigned int >::Handle *)new btAxisSweep3Internal< unsigned int >::Handle();
  *(btAxisSweep3Internal< unsigned int >::Handle **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_delete_1btAxisSweep3InternalInt_1Handle(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  btAxisSweep3Internal< unsigned int >::Handle *arg1 = (btAxisSweep3Internal< unsigned int >::Handle *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(btAxisSweep3Internal< unsigned int >::Handle **)&jarg1; 
  delete arg1;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_new_1btAxisSweep3InternalInt_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jobject jarg1, jobject jarg2, jlong jarg3, jlong jarg4, jlong jarg5, jlong jarg6, jobject jarg6_, jboolean jarg7) {
  jlong jresult = 0 ;
  btVector3 *arg1 = 0 ;
  btVector3 *arg2 = 0 ;
  unsigned int arg3 ;
  unsigned int arg4 ;
  unsigned int arg5 ;
  btOverlappingPairCache *arg6 = (btOverlappingPairCache *) 0 ;
  bool arg7 ;
  btAxisSweep3Internal< unsigned int > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg6_;
  btVector3 local_arg1;
  gdx_setbtVector3FromVector3(jenv, local_arg1, jarg1);
  arg1 = &local_arg1;
  gdxAutoCommitVector3 auto_commit_arg1(jenv, jarg1, &local_arg1);
  btVector3 local_arg2;
  gdx_setbtVector3FromVector3(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitVector3 auto_commit_arg2(jenv, jarg2, &local_arg2);
  arg3 = (unsigned int)jarg3; 
  arg4 = (unsigned int)jarg4; 
  arg5 = (unsigned int)jarg5; 
  arg6 = *(btOverlappingPairCache **)&jarg6; 
  arg7 = jarg7 ? true : false; 
  result = (btAxisSweep3Internal< unsigned int > *)new btAxisSweep3Internal< unsigned int >((btVector3 const &)*arg1,(btVector3 const &)*arg2,arg3,arg4,arg5,arg6,arg7);
  *(btAxisSweep3Internal< unsigned int > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_new_1btAxisSweep3InternalInt_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jobject jarg1, jobject jarg2, jlong jarg3, jlong jarg4, jlong jarg5, jlong jarg6, jobject jarg6_) {
  jlong jresult = 0 ;
  btVector3 *arg1 = 0 ;
  btVector3 *arg2 = 0 ;
  unsigned int arg3 ;
  unsigned int arg4 ;
  unsigned int arg5 ;
  btOverlappingPairCache *arg6 = (btOverlappingPairCache *) 0 ;
  btAxisSweep3Internal< unsigned int > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg6_;
  btVector3 local_arg1;
  gdx_setbtVector3FromVector3(jenv, local_arg1, jarg1);
  arg1 = &local_arg1;
  gdxAutoCommitVector3 auto_commit_arg1(jenv, jarg1, &local_arg1);
  btVector3 local_arg2;
  gdx_setbtVector3FromVector3(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitVector3 auto_commit_arg2(jenv, jarg2, &local_arg2);
  arg3 = (unsigned int)jarg3; 
  arg4 = (unsigned int)jarg4; 
  arg5 = (unsigned int)jarg5; 
  arg6 = *(btOverlappingPairCache **)&jarg6; 
  result = (btAxisSweep3Internal< unsigned int > *)new btAxisSweep3Internal< unsigned int >((btVector3 const &)*arg1,(btVector3 const &)*arg2,arg3,arg4,arg5,arg6);
  *(btAxisSweep3Internal< unsigned int > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_new_1btAxisSweep3InternalInt_1_1SWIG_12(JNIEnv *jenv, jclass jcls, jobject jarg1, jobject jarg2, jlong jarg3, jlong jarg4, jlong jarg5) {
  jlong jresult = 0 ;
  btVector3 *arg1 = 0 ;
  btVector3 *arg2 = 0 ;
  unsigned int arg3 ;
  unsigned int arg4 ;
  unsigned int arg5 ;
  btAxisSweep3Internal< unsigned int > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  btVector3 local_arg1;
  gdx_setbtVector3FromVector3(jenv, local_arg1, jarg1);
  arg1 = &local_arg1;
  gdxAutoCommitVector3 auto_commit_arg1(jenv, jarg1, &local_arg1);
  btVector3 local_arg2;
  gdx_setbtVector3FromVector3(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitVector3 auto_commit_arg2(jenv, jarg2, &local_arg2);
  arg3 = (unsigned int)jarg3; 
  arg4 = (unsigned int)jarg4; 
  arg5 = (unsigned int)jarg5; 
  result = (btAxisSweep3Internal< unsigned int > *)new btAxisSweep3Internal< unsigned int >((btVector3 const &)*arg1,(btVector3 const &)*arg2,arg3,arg4,arg5);
  *(btAxisSweep3Internal< unsigned int > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_new_1btAxisSweep3InternalInt_1_1SWIG_13(JNIEnv *jenv, jclass jcls, jobject jarg1, jobject jarg2, jlong jarg3, jlong jarg4) {
  jlong jresult = 0 ;
  btVector3 *arg1 = 0 ;
  btVector3 *arg2 = 0 ;
  unsigned int arg3 ;
  unsigned int arg4 ;
  btAxisSweep3Internal< unsigned int > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  btVector3 local_arg1;
  gdx_setbtVector3FromVector3(jenv, local_arg1, jarg1);
  arg1 = &local_arg1;
  gdxAutoCommitVector3 auto_commit_arg1(jenv, jarg1, &local_arg1);
  btVector3 local_arg2;
  gdx_setbtVector3FromVector3(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitVector3 auto_commit_arg2(jenv, jarg2, &local_arg2);
  arg3 = (unsigned int)jarg3; 
  arg4 = (unsigned int)jarg4; 
  result = (btAxisSweep3Internal< unsigned int > *)new btAxisSweep3Internal< unsigned int >((btVector3 const &)*arg1,(btVector3 const &)*arg2,arg3,arg4);
  *(btAxisSweep3Internal< unsigned int > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_delete_1btAxisSweep3InternalInt(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  btAxisSweep3Internal< unsigned int > *arg1 = (btAxisSweep3Internal< unsigned int > *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(btAxisSweep3Internal< unsigned int > **)&jarg1; 
  delete arg1;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btAxisSweep3InternalInt_1getNumHandles(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btAxisSweep3Internal< unsigned int > *arg1 = (btAxisSweep3Internal< unsigned int > *) 0 ;
  unsigned int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btAxisSweep3Internal< unsigned int > **)&jarg1; 
  result = (unsigned int)((btAxisSweep3Internal< unsigned int > const *)arg1)->getNumHandles();
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btAxisSweep3InternalInt_1addHandle(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2, jobject jarg3, jlong jarg4, jshort jarg5, jshort jarg6, jlong jarg7, jobject jarg7_, jlong jarg8) {
  jlong jresult = 0 ;
  btAxisSweep3Internal< unsigned int > *arg1 = (btAxisSweep3Internal< unsigned int > *) 0 ;
  btVector3 *arg2 = 0 ;
  btVector3 *arg3 = 0 ;
  void *arg4 = (void *) 0 ;
  short arg5 ;
  short arg6 ;
  btDispatcher *arg7 = (btDispatcher *) 0 ;
  void *arg8 = (void *) 0 ;
  unsigned int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg7_;
  arg1 = *(btAxisSweep3Internal< unsigned int > **)&jarg1; 
  btVector3 local_arg2;
  gdx_setbtVector3FromVector3(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitVector3 auto_commit_arg2(jenv, jarg2, &local_arg2);
  btVector3 local_arg3;
  gdx_setbtVector3FromVector3(jenv, local_arg3, jarg3);
  arg3 = &local_arg3;
  gdxAutoCommitVector3 auto_commit_arg3(jenv, jarg3, &local_arg3);
  arg4 = (void *)jarg4; 
  arg5 = (short)jarg5; 
  arg6 = (short)jarg6; 
  arg7 = *(btDispatcher **)&jarg7; 
  arg8 = (void *)jarg8; 
  result = (unsigned int)(arg1)->addHandle((btVector3 const &)*arg2,(btVector3 const &)*arg3,arg4,arg5,arg6,arg7,arg8);
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btAxisSweep3InternalInt_1removeHandle(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jlong jarg3, jobject jarg3_) {
  btAxisSweep3Internal< unsigned int > *arg1 = (btAxisSweep3Internal< unsigned int > *) 0 ;
  unsigned int arg2 ;
  btDispatcher *arg3 = (btDispatcher *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg3_;
  arg1 = *(btAxisSweep3Internal< unsigned int > **)&jarg1; 
  arg2 = (unsigned int)jarg2; 
  arg3 = *(btDispatcher **)&jarg3; 
  (arg1)->removeHandle(arg2,arg3);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btAxisSweep3InternalInt_1updateHandle(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg3, jobject jarg4, jlong jarg5, jobject jarg5_) {
  btAxisSweep3Internal< unsigned int > *arg1 = (btAxisSweep3Internal< unsigned int > *) 0 ;
  unsigned int arg2 ;
  btVector3 *arg3 = 0 ;
  btVector3 *arg4 = 0 ;
  btDispatcher *arg5 = (btDispatcher *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg5_;
  arg1 = *(btAxisSweep3Internal< unsigned int > **)&jarg1; 
  arg2 = (unsigned int)jarg2; 
  btVector3 local_arg3;
  gdx_setbtVector3FromVector3(jenv, local_arg3, jarg3);
  arg3 = &local_arg3;
  gdxAutoCommitVector3 auto_commit_arg3(jenv, jarg3, &local_arg3);
  btVector3 local_arg4;
  gdx_setbtVector3FromVector3(jenv, local_arg4, jarg4);
  arg4 = &local_arg4;
  gdxAutoCommitVector3 auto_commit_arg4(jenv, jarg4, &local_arg4);
  arg5 = *(btDispatcher **)&jarg5; 
  (arg1)->updateHandle(arg2,(btVector3 const &)*arg3,(btVector3 const &)*arg4,arg5);
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btAxisSweep3InternalInt_1getHandle(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  jlong jresult = 0 ;
  btAxisSweep3Internal< unsigned int > *arg1 = (btAxisSweep3Internal< unsigned int > *) 0 ;
  unsigned int arg2 ;
  btAxisSweep3Internal< unsigned int >::Handle *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btAxisSweep3Internal< unsigned int > **)&jarg1; 
  arg2 = (unsigned int)jarg2; 
  result = (btAxisSweep3Internal< unsigned int >::Handle *)((btAxisSweep3Internal< unsigned int > const *)arg1)->getHandle(arg2);
  *(btAxisSweep3Internal< unsigned int >::Handle **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btAxisSweep3InternalInt_1rayTest_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2, jobject jarg3, jlong jarg4, jobject jarg4_, jobject jarg5, jobject jarg6) {
  btAxisSweep3Internal< unsigned int > *arg1 = (btAxisSweep3Internal< unsigned int > *) 0 ;
  btVector3 *arg2 = 0 ;
  btVector3 *arg3 = 0 ;
  btBroadphaseRayCallback *arg4 = 0 ;
  btVector3 *arg5 = 0 ;
  btVector3 *arg6 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg4_;
  arg1 = *(btAxisSweep3Internal< unsigned int > **)&jarg1; 
  btVector3 local_arg2;
  gdx_setbtVector3FromVector3(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitVector3 auto_commit_arg2(jenv, jarg2, &local_arg2);
  btVector3 local_arg3;
  gdx_setbtVector3FromVector3(jenv, local_arg3, jarg3);
  arg3 = &local_arg3;
  gdxAutoCommitVector3 auto_commit_arg3(jenv, jarg3, &local_arg3);
  arg4 = *(btBroadphaseRayCallback **)&jarg4;
  if (!arg4) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btBroadphaseRayCallback & reference is null");
    return ;
  } 
  btVector3 local_arg5;
  gdx_setbtVector3FromVector3(jenv, local_arg5, jarg5);
  arg5 = &local_arg5;
  gdxAutoCommitVector3 auto_commit_arg5(jenv, jarg5, &local_arg5);
  btVector3 local_arg6;
  gdx_setbtVector3FromVector3(jenv, local_arg6, jarg6);
  arg6 = &local_arg6;
  gdxAutoCommitVector3 auto_commit_arg6(jenv, jarg6, &local_arg6);
  (arg1)->rayTest((btVector3 const &)*arg2,(btVector3 const &)*arg3,*arg4,(btVector3 const &)*arg5,(btVector3 const &)*arg6);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btAxisSweep3InternalInt_1rayTest_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2, jobject jarg3, jlong jarg4, jobject jarg4_, jobject jarg5) {
  btAxisSweep3Internal< unsigned int > *arg1 = (btAxisSweep3Internal< unsigned int > *) 0 ;
  btVector3 *arg2 = 0 ;
  btVector3 *arg3 = 0 ;
  btBroadphaseRayCallback *arg4 = 0 ;
  btVector3 *arg5 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg4_;
  arg1 = *(btAxisSweep3Internal< unsigned int > **)&jarg1; 
  btVector3 local_arg2;
  gdx_setbtVector3FromVector3(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitVector3 auto_commit_arg2(jenv, jarg2, &local_arg2);
  btVector3 local_arg3;
  gdx_setbtVector3FromVector3(jenv, local_arg3, jarg3);
  arg3 = &local_arg3;
  gdxAutoCommitVector3 auto_commit_arg3(jenv, jarg3, &local_arg3);
  arg4 = *(btBroadphaseRayCallback **)&jarg4;
  if (!arg4) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btBroadphaseRayCallback & reference is null");
    return ;
  } 
  btVector3 local_arg5;
  gdx_setbtVector3FromVector3(jenv, local_arg5, jarg5);
  arg5 = &local_arg5;
  gdxAutoCommitVector3 auto_commit_arg5(jenv, jarg5, &local_arg5);
  (arg1)->rayTest((btVector3 const &)*arg2,(btVector3 const &)*arg3,*arg4,(btVector3 const &)*arg5);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btAxisSweep3InternalInt_1rayTest_1_1SWIG_12(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2, jobject jarg3, jlong jarg4, jobject jarg4_) {
  btAxisSweep3Internal< unsigned int > *arg1 = (btAxisSweep3Internal< unsigned int > *) 0 ;
  btVector3 *arg2 = 0 ;
  btVector3 *arg3 = 0 ;
  btBroadphaseRayCallback *arg4 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg4_;
  arg1 = *(btAxisSweep3Internal< unsigned int > **)&jarg1; 
  btVector3 local_arg2;
  gdx_setbtVector3FromVector3(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitVector3 auto_commit_arg2(jenv, jarg2, &local_arg2);
  btVector3 local_arg3;
  gdx_setbtVector3FromVector3(jenv, local_arg3, jarg3);
  arg3 = &local_arg3;
  gdxAutoCommitVector3 auto_commit_arg3(jenv, jarg3, &local_arg3);
  arg4 = *(btBroadphaseRayCallback **)&jarg4;
  if (!arg4) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btBroadphaseRayCallback & reference is null");
    return ;
  } 
  (arg1)->rayTest((btVector3 const &)*arg2,(btVector3 const &)*arg3,*arg4);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btAxisSweep3InternalInt_1quantize(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2, jobject jarg3, jint jarg4) {
  btAxisSweep3Internal< unsigned int > *arg1 = (btAxisSweep3Internal< unsigned int > *) 0 ;
  unsigned int *arg2 = (unsigned int *) 0 ;
  btVector3 *arg3 = 0 ;
  int arg4 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btAxisSweep3Internal< unsigned int > **)&jarg1; 
  {
    arg2 = (unsigned int*)jenv->GetDirectBufferAddress(jarg2);
    if (arg2 == NULL) {
      SWIG_JavaThrowException(jenv, SWIG_JavaRuntimeException, "Unable to get address of direct buffer. Buffer must be allocated direct.");
    }
  }
  btVector3 local_arg3;
  gdx_setbtVector3FromVector3(jenv, local_arg3, jarg3);
  arg3 = &local_arg3;
  gdxAutoCommitVector3 auto_commit_arg3(jenv, jarg3, &local_arg3);
  arg4 = (int)jarg4; 
  ((btAxisSweep3Internal< unsigned int > const *)arg1)->quantize(arg2,(btVector3 const &)*arg3,arg4);
  
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btAxisSweep3InternalInt_1unQuantize(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jobject jarg3, jobject jarg4) {
  btAxisSweep3Internal< unsigned int > *arg1 = (btAxisSweep3Internal< unsigned int > *) 0 ;
  btBroadphaseProxy *arg2 = (btBroadphaseProxy *) 0 ;
  btVector3 *arg3 = 0 ;
  btVector3 *arg4 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btAxisSweep3Internal< unsigned int > **)&jarg1; 
  arg2 = *(btBroadphaseProxy **)&jarg2; 
  btVector3 local_arg3;
  gdx_setbtVector3FromVector3(jenv, local_arg3, jarg3);
  arg3 = &local_arg3;
  gdxAutoCommitVector3 auto_commit_arg3(jenv, jarg3, &local_arg3);
  btVector3 local_arg4;
  gdx_setbtVector3FromVector3(jenv, local_arg4, jarg4);
  arg4 = &local_arg4;
  gdxAutoCommitVector3 auto_commit_arg4(jenv, jarg4, &local_arg4);
  ((btAxisSweep3Internal< unsigned int > const *)arg1)->unQuantize(arg2,*arg3,*arg4);
}


SWIGEXPORT jboolean JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btAxisSweep3InternalInt_1testAabbOverlap(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlong jarg3, jobject jarg3_) {
  jboolean jresult = 0 ;
  btAxisSweep3Internal< unsigned int > *arg1 = (btAxisSweep3Internal< unsigned int > *) 0 ;
  btBroadphaseProxy *arg2 = (btBroadphaseProxy *) 0 ;
  btBroadphaseProxy *arg3 = (btBroadphaseProxy *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  (void)jarg3_;
  arg1 = *(btAxisSweep3Internal< unsigned int > **)&jarg1; 
  arg2 = *(btBroadphaseProxy **)&jarg2; 
  arg3 = *(btBroadphaseProxy **)&jarg3; 
  result = (bool)(arg1)->testAabbOverlap(arg2,arg3);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btAxisSweep3InternalInt_1getOverlappingPairCache_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btAxisSweep3Internal< unsigned int > *arg1 = (btAxisSweep3Internal< unsigned int > *) 0 ;
  btOverlappingPairCache *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btAxisSweep3Internal< unsigned int > **)&jarg1; 
  result = (btOverlappingPairCache *)(arg1)->getOverlappingPairCache();
  *(btOverlappingPairCache **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btAxisSweep3InternalInt_1setOverlappingPairUserCallback(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btAxisSweep3Internal< unsigned int > *arg1 = (btAxisSweep3Internal< unsigned int > *) 0 ;
  btOverlappingPairCallback *arg2 = (btOverlappingPairCallback *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btAxisSweep3Internal< unsigned int > **)&jarg1; 
  arg2 = *(btOverlappingPairCallback **)&jarg2; 
  (arg1)->setOverlappingPairUserCallback(arg2);
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btAxisSweep3InternalInt_1getOverlappingPairUserCallback(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btAxisSweep3Internal< unsigned int > *arg1 = (btAxisSweep3Internal< unsigned int > *) 0 ;
  btOverlappingPairCallback *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btAxisSweep3Internal< unsigned int > **)&jarg1; 
  result = (btOverlappingPairCallback *)((btAxisSweep3Internal< unsigned int > const *)arg1)->getOverlappingPairUserCallback();
  *(btOverlappingPairCallback **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_new_1btAxisSweep3_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jobject jarg1, jobject jarg2, jint jarg3, jlong jarg4, jobject jarg4_, jboolean jarg5) {
  jlong jresult = 0 ;
  btVector3 *arg1 = 0 ;
  btVector3 *arg2 = 0 ;
  unsigned short arg3 ;
  btOverlappingPairCache *arg4 = (btOverlappingPairCache *) 0 ;
  bool arg5 ;
  btAxisSweep3 *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg4_;
  btVector3 local_arg1;
  gdx_setbtVector3FromVector3(jenv, local_arg1, jarg1);
  arg1 = &local_arg1;
  gdxAutoCommitVector3 auto_commit_arg1(jenv, jarg1, &local_arg1);
  btVector3 local_arg2;
  gdx_setbtVector3FromVector3(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitVector3 auto_commit_arg2(jenv, jarg2, &local_arg2);
  arg3 = (unsigned short)jarg3; 
  arg4 = *(btOverlappingPairCache **)&jarg4; 
  arg5 = jarg5 ? true : false; 
  result = (btAxisSweep3 *)new btAxisSweep3((btVector3 const &)*arg1,(btVector3 const &)*arg2,arg3,arg4,arg5);
  *(btAxisSweep3 **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_new_1btAxisSweep3_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jobject jarg1, jobject jarg2, jint jarg3, jlong jarg4, jobject jarg4_) {
  jlong jresult = 0 ;
  btVector3 *arg1 = 0 ;
  btVector3 *arg2 = 0 ;
  unsigned short arg3 ;
  btOverlappingPairCache *arg4 = (btOverlappingPairCache *) 0 ;
  btAxisSweep3 *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg4_;
  btVector3 local_arg1;
  gdx_setbtVector3FromVector3(jenv, local_arg1, jarg1);
  arg1 = &local_arg1;
  gdxAutoCommitVector3 auto_commit_arg1(jenv, jarg1, &local_arg1);
  btVector3 local_arg2;
  gdx_setbtVector3FromVector3(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitVector3 auto_commit_arg2(jenv, jarg2, &local_arg2);
  arg3 = (unsigned short)jarg3; 
  arg4 = *(btOverlappingPairCache **)&jarg4; 
  result = (btAxisSweep3 *)new btAxisSweep3((btVector3 const &)*arg1,(btVector3 const &)*arg2,arg3,arg4);
  *(btAxisSweep3 **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_new_1btAxisSweep3_1_1SWIG_12(JNIEnv *jenv, jclass jcls, jobject jarg1, jobject jarg2, jint jarg3) {
  jlong jresult = 0 ;
  btVector3 *arg1 = 0 ;
  btVector3 *arg2 = 0 ;
  unsigned short arg3 ;
  btAxisSweep3 *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  btVector3 local_arg1;
  gdx_setbtVector3FromVector3(jenv, local_arg1, jarg1);
  arg1 = &local_arg1;
  gdxAutoCommitVector3 auto_commit_arg1(jenv, jarg1, &local_arg1);
  btVector3 local_arg2;
  gdx_setbtVector3FromVector3(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitVector3 auto_commit_arg2(jenv, jarg2, &local_arg2);
  arg3 = (unsigned short)jarg3; 
  result = (btAxisSweep3 *)new btAxisSweep3((btVector3 const &)*arg1,(btVector3 const &)*arg2,arg3);
  *(btAxisSweep3 **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_new_1btAxisSweep3_1_1SWIG_13(JNIEnv *jenv, jclass jcls, jobject jarg1, jobject jarg2) {
  jlong jresult = 0 ;
  btVector3 *arg1 = 0 ;
  btVector3 *arg2 = 0 ;
  btAxisSweep3 *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  btVector3 local_arg1;
  gdx_setbtVector3FromVector3(jenv, local_arg1, jarg1);
  arg1 = &local_arg1;
  gdxAutoCommitVector3 auto_commit_arg1(jenv, jarg1, &local_arg1);
  btVector3 local_arg2;
  gdx_setbtVector3FromVector3(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitVector3 auto_commit_arg2(jenv, jarg2, &local_arg2);
  result = (btAxisSweep3 *)new btAxisSweep3((btVector3 const &)*arg1,(btVector3 const &)*arg2);
  *(btAxisSweep3 **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_delete_1btAxisSweep3(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  btAxisSweep3 *arg1 = (btAxisSweep3 *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(btAxisSweep3 **)&jarg1; 
  delete arg1;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_new_1bt32BitAxisSweep3_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jobject jarg1, jobject jarg2, jlong jarg3, jlong jarg4, jobject jarg4_, jboolean jarg5) {
  jlong jresult = 0 ;
  btVector3 *arg1 = 0 ;
  btVector3 *arg2 = 0 ;
  unsigned int arg3 ;
  btOverlappingPairCache *arg4 = (btOverlappingPairCache *) 0 ;
  bool arg5 ;
  bt32BitAxisSweep3 *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg4_;
  btVector3 local_arg1;
  gdx_setbtVector3FromVector3(jenv, local_arg1, jarg1);
  arg1 = &local_arg1;
  gdxAutoCommitVector3 auto_commit_arg1(jenv, jarg1, &local_arg1);
  btVector3 local_arg2;
  gdx_setbtVector3FromVector3(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitVector3 auto_commit_arg2(jenv, jarg2, &local_arg2);
  arg3 = (unsigned int)jarg3; 
  arg4 = *(btOverlappingPairCache **)&jarg4; 
  arg5 = jarg5 ? true : false; 
  result = (bt32BitAxisSweep3 *)new bt32BitAxisSweep3((btVector3 const &)*arg1,(btVector3 const &)*arg2,arg3,arg4,arg5);
  *(bt32BitAxisSweep3 **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_new_1bt32BitAxisSweep3_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jobject jarg1, jobject jarg2, jlong jarg3, jlong jarg4, jobject jarg4_) {
  jlong jresult = 0 ;
  btVector3 *arg1 = 0 ;
  btVector3 *arg2 = 0 ;
  unsigned int arg3 ;
  btOverlappingPairCache *arg4 = (btOverlappingPairCache *) 0 ;
  bt32BitAxisSweep3 *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg4_;
  btVector3 local_arg1;
  gdx_setbtVector3FromVector3(jenv, local_arg1, jarg1);
  arg1 = &local_arg1;
  gdxAutoCommitVector3 auto_commit_arg1(jenv, jarg1, &local_arg1);
  btVector3 local_arg2;
  gdx_setbtVector3FromVector3(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitVector3 auto_commit_arg2(jenv, jarg2, &local_arg2);
  arg3 = (unsigned int)jarg3; 
  arg4 = *(btOverlappingPairCache **)&jarg4; 
  result = (bt32BitAxisSweep3 *)new bt32BitAxisSweep3((btVector3 const &)*arg1,(btVector3 const &)*arg2,arg3,arg4);
  *(bt32BitAxisSweep3 **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_new_1bt32BitAxisSweep3_1_1SWIG_12(JNIEnv *jenv, jclass jcls, jobject jarg1, jobject jarg2, jlong jarg3) {
  jlong jresult = 0 ;
  btVector3 *arg1 = 0 ;
  btVector3 *arg2 = 0 ;
  unsigned int arg3 ;
  bt32BitAxisSweep3 *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  btVector3 local_arg1;
  gdx_setbtVector3FromVector3(jenv, local_arg1, jarg1);
  arg1 = &local_arg1;
  gdxAutoCommitVector3 auto_commit_arg1(jenv, jarg1, &local_arg1);
  btVector3 local_arg2;
  gdx_setbtVector3FromVector3(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitVector3 auto_commit_arg2(jenv, jarg2, &local_arg2);
  arg3 = (unsigned int)jarg3; 
  result = (bt32BitAxisSweep3 *)new bt32BitAxisSweep3((btVector3 const &)*arg1,(btVector3 const &)*arg2,arg3);
  *(bt32BitAxisSweep3 **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_new_1bt32BitAxisSweep3_1_1SWIG_13(JNIEnv *jenv, jclass jcls, jobject jarg1, jobject jarg2) {
  jlong jresult = 0 ;
  btVector3 *arg1 = 0 ;
  btVector3 *arg2 = 0 ;
  bt32BitAxisSweep3 *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  btVector3 local_arg1;
  gdx_setbtVector3FromVector3(jenv, local_arg1, jarg1);
  arg1 = &local_arg1;
  gdxAutoCommitVector3 auto_commit_arg1(jenv, jarg1, &local_arg1);
  btVector3 local_arg2;
  gdx_setbtVector3FromVector3(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitVector3 auto_commit_arg2(jenv, jarg2, &local_arg2);
  result = (bt32BitAxisSweep3 *)new bt32BitAxisSweep3((btVector3 const &)*arg1,(btVector3 const &)*arg2);
  *(bt32BitAxisSweep3 **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_delete_1bt32BitAxisSweep3(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  bt32BitAxisSweep3 *arg1 = (bt32BitAxisSweep3 *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(bt32BitAxisSweep3 **)&jarg1; 
  delete arg1;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_new_1btDispatcherInfo(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  btDispatcherInfo *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (btDispatcherInfo *)new btDispatcherInfo();
  *(btDispatcherInfo **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btDispatcherInfo_1timeStep_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2) {
  btDispatcherInfo *arg1 = (btDispatcherInfo *) 0 ;
  btScalar arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btDispatcherInfo **)&jarg1; 
  arg2 = (btScalar)jarg2; 
  if (arg1) (arg1)->m_timeStep = arg2;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btDispatcherInfo_1timeStep_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jfloat jresult = 0 ;
  btDispatcherInfo *arg1 = (btDispatcherInfo *) 0 ;
  btScalar result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btDispatcherInfo **)&jarg1; 
  result = (btScalar) ((arg1)->m_timeStep);
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btDispatcherInfo_1stepCount_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  btDispatcherInfo *arg1 = (btDispatcherInfo *) 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btDispatcherInfo **)&jarg1; 
  arg2 = (int)jarg2; 
  if (arg1) (arg1)->m_stepCount = arg2;
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btDispatcherInfo_1stepCount_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  btDispatcherInfo *arg1 = (btDispatcherInfo *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btDispatcherInfo **)&jarg1; 
  result = (int) ((arg1)->m_stepCount);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btDispatcherInfo_1dispatchFunc_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  btDispatcherInfo *arg1 = (btDispatcherInfo *) 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btDispatcherInfo **)&jarg1; 
  arg2 = (int)jarg2; 
  if (arg1) (arg1)->m_dispatchFunc = arg2;
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btDispatcherInfo_1dispatchFunc_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  btDispatcherInfo *arg1 = (btDispatcherInfo *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btDispatcherInfo **)&jarg1; 
  result = (int) ((arg1)->m_dispatchFunc);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btDispatcherInfo_1timeOfImpact_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2) {
  btDispatcherInfo *arg1 = (btDispatcherInfo *) 0 ;
  btScalar arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btDispatcherInfo **)&jarg1; 
  arg2 = (btScalar)jarg2; 
  if (arg1) (arg1)->m_timeOfImpact = arg2;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btDispatcherInfo_1timeOfImpact_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jfloat jresult = 0 ;
  btDispatcherInfo *arg1 = (btDispatcherInfo *) 0 ;
  btScalar result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btDispatcherInfo **)&jarg1; 
  result = (btScalar) ((arg1)->m_timeOfImpact);
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btDispatcherInfo_1useContinuous_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jboolean jarg2) {
  btDispatcherInfo *arg1 = (btDispatcherInfo *) 0 ;
  bool arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btDispatcherInfo **)&jarg1; 
  arg2 = jarg2 ? true : false; 
  if (arg1) (arg1)->m_useContinuous = arg2;
}


SWIGEXPORT jboolean JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btDispatcherInfo_1useContinuous_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  btDispatcherInfo *arg1 = (btDispatcherInfo *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btDispatcherInfo **)&jarg1; 
  result = (bool) ((arg1)->m_useContinuous);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btDispatcherInfo_1debugDraw_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btDispatcherInfo *arg1 = (btDispatcherInfo *) 0 ;
  btIDebugDraw *arg2 = (btIDebugDraw *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btDispatcherInfo **)&jarg1; 
  arg2 = *(btIDebugDraw **)&jarg2; 
  if (arg1) (arg1)->m_debugDraw = arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btDispatcherInfo_1debugDraw_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btDispatcherInfo *arg1 = (btDispatcherInfo *) 0 ;
  btIDebugDraw *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btDispatcherInfo **)&jarg1; 
  result = (btIDebugDraw *) ((arg1)->m_debugDraw);
  *(btIDebugDraw **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btDispatcherInfo_1enableSatConvex_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jboolean jarg2) {
  btDispatcherInfo *arg1 = (btDispatcherInfo *) 0 ;
  bool arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btDispatcherInfo **)&jarg1; 
  arg2 = jarg2 ? true : false; 
  if (arg1) (arg1)->m_enableSatConvex = arg2;
}


SWIGEXPORT jboolean JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btDispatcherInfo_1enableSatConvex_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  btDispatcherInfo *arg1 = (btDispatcherInfo *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btDispatcherInfo **)&jarg1; 
  result = (bool) ((arg1)->m_enableSatConvex);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btDispatcherInfo_1enableSPU_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jboolean jarg2) {
  btDispatcherInfo *arg1 = (btDispatcherInfo *) 0 ;
  bool arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btDispatcherInfo **)&jarg1; 
  arg2 = jarg2 ? true : false; 
  if (arg1) (arg1)->m_enableSPU = arg2;
}


SWIGEXPORT jboolean JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btDispatcherInfo_1enableSPU_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  btDispatcherInfo *arg1 = (btDispatcherInfo *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btDispatcherInfo **)&jarg1; 
  result = (bool) ((arg1)->m_enableSPU);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btDispatcherInfo_1useEpa_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jboolean jarg2) {
  btDispatcherInfo *arg1 = (btDispatcherInfo *) 0 ;
  bool arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btDispatcherInfo **)&jarg1; 
  arg2 = jarg2 ? true : false; 
  if (arg1) (arg1)->m_useEpa = arg2;
}


SWIGEXPORT jboolean JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btDispatcherInfo_1useEpa_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  btDispatcherInfo *arg1 = (btDispatcherInfo *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btDispatcherInfo **)&jarg1; 
  result = (bool) ((arg1)->m_useEpa);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btDispatcherInfo_1allowedCcdPenetration_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2) {
  btDispatcherInfo *arg1 = (btDispatcherInfo *) 0 ;
  btScalar arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btDispatcherInfo **)&jarg1; 
  arg2 = (btScalar)jarg2; 
  if (arg1) (arg1)->m_allowedCcdPenetration = arg2;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btDispatcherInfo_1allowedCcdPenetration_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jfloat jresult = 0 ;
  btDispatcherInfo *arg1 = (btDispatcherInfo *) 0 ;
  btScalar result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btDispatcherInfo **)&jarg1; 
  result = (btScalar) ((arg1)->m_allowedCcdPenetration);
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btDispatcherInfo_1useConvexConservativeDistanceUtil_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jboolean jarg2) {
  btDispatcherInfo *arg1 = (btDispatcherInfo *) 0 ;
  bool arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btDispatcherInfo **)&jarg1; 
  arg2 = jarg2 ? true : false; 
  if (arg1) (arg1)->m_useConvexConservativeDistanceUtil = arg2;
}


SWIGEXPORT jboolean JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btDispatcherInfo_1useConvexConservativeDistanceUtil_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  btDispatcherInfo *arg1 = (btDispatcherInfo *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btDispatcherInfo **)&jarg1; 
  result = (bool) ((arg1)->m_useConvexConservativeDistanceUtil);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btDispatcherInfo_1convexConservativeDistanceThreshold_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2) {
  btDispatcherInfo *arg1 = (btDispatcherInfo *) 0 ;
  btScalar arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btDispatcherInfo **)&jarg1; 
  arg2 = (btScalar)jarg2; 
  if (arg1) (arg1)->m_convexConservativeDistanceThreshold = arg2;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btDispatcherInfo_1convexConservativeDistanceThreshold_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jfloat jresult = 0 ;
  btDispatcherInfo *arg1 = (btDispatcherInfo *) 0 ;
  btScalar result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btDispatcherInfo **)&jarg1; 
  result = (btScalar) ((arg1)->m_convexConservativeDistanceThreshold);
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_delete_1btDispatcherInfo(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  btDispatcherInfo *arg1 = (btDispatcherInfo *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(btDispatcherInfo **)&jarg1; 
  delete arg1;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_delete_1btDispatcher(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  btDispatcher *arg1 = (btDispatcher *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(btDispatcher **)&jarg1; 
  delete arg1;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btDispatcher_1findAlgorithm_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlong jarg3, jobject jarg3_, jlong jarg4, jobject jarg4_) {
  jlong jresult = 0 ;
  btDispatcher *arg1 = (btDispatcher *) 0 ;
  btCollisionObjectWrapper *arg2 = (btCollisionObjectWrapper *) 0 ;
  btCollisionObjectWrapper *arg3 = (btCollisionObjectWrapper *) 0 ;
  btPersistentManifold *arg4 = (btPersistentManifold *) 0 ;
  btCollisionAlgorithm *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  (void)jarg3_;
  (void)jarg4_;
  arg1 = *(btDispatcher **)&jarg1; 
  arg2 = *(btCollisionObjectWrapper **)&jarg2; 
  arg3 = *(btCollisionObjectWrapper **)&jarg3; 
  arg4 = *(btPersistentManifold **)&jarg4; 
  result = (btCollisionAlgorithm *)(arg1)->findAlgorithm((btCollisionObjectWrapper const *)arg2,(btCollisionObjectWrapper const *)arg3,arg4);
  *(btCollisionAlgorithm **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btDispatcher_1findAlgorithm_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlong jarg3, jobject jarg3_) {
  jlong jresult = 0 ;
  btDispatcher *arg1 = (btDispatcher *) 0 ;
  btCollisionObjectWrapper *arg2 = (btCollisionObjectWrapper *) 0 ;
  btCollisionObjectWrapper *arg3 = (btCollisionObjectWrapper *) 0 ;
  btCollisionAlgorithm *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  (void)jarg3_;
  arg1 = *(btDispatcher **)&jarg1; 
  arg2 = *(btCollisionObjectWrapper **)&jarg2; 
  arg3 = *(btCollisionObjectWrapper **)&jarg3; 
  result = (btCollisionAlgorithm *)(arg1)->findAlgorithm((btCollisionObjectWrapper const *)arg2,(btCollisionObjectWrapper const *)arg3);
  *(btCollisionAlgorithm **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btDispatcher_1getNewManifold(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlong jarg3, jobject jarg3_) {
  jlong jresult = 0 ;
  btDispatcher *arg1 = (btDispatcher *) 0 ;
  btCollisionObject *arg2 = (btCollisionObject *) 0 ;
  btCollisionObject *arg3 = (btCollisionObject *) 0 ;
  btPersistentManifold *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  (void)jarg3_;
  arg1 = *(btDispatcher **)&jarg1; 
  arg2 = *(btCollisionObject **)&jarg2; 
  arg3 = *(btCollisionObject **)&jarg3; 
  result = (btPersistentManifold *)(arg1)->getNewManifold((btCollisionObject const *)arg2,(btCollisionObject const *)arg3);
  *(btPersistentManifold **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btDispatcher_1releaseManifold(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btDispatcher *arg1 = (btDispatcher *) 0 ;
  btPersistentManifold *arg2 = (btPersistentManifold *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btDispatcher **)&jarg1; 
  arg2 = *(btPersistentManifold **)&jarg2; 
  (arg1)->releaseManifold(arg2);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btDispatcher_1clearManifold(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btDispatcher *arg1 = (btDispatcher *) 0 ;
  btPersistentManifold *arg2 = (btPersistentManifold *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btDispatcher **)&jarg1; 
  arg2 = *(btPersistentManifold **)&jarg2; 
  (arg1)->clearManifold(arg2);
}


SWIGEXPORT jboolean JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btDispatcher_1needsCollision(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlong jarg3, jobject jarg3_) {
  jboolean jresult = 0 ;
  btDispatcher *arg1 = (btDispatcher *) 0 ;
  btCollisionObject *arg2 = (btCollisionObject *) 0 ;
  btCollisionObject *arg3 = (btCollisionObject *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  (void)jarg3_;
  arg1 = *(btDispatcher **)&jarg1; 
  arg2 = *(btCollisionObject **)&jarg2; 
  arg3 = *(btCollisionObject **)&jarg3; 
  result = (bool)(arg1)->needsCollision((btCollisionObject const *)arg2,(btCollisionObject const *)arg3);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btDispatcher_1needsResponse(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlong jarg3, jobject jarg3_) {
  jboolean jresult = 0 ;
  btDispatcher *arg1 = (btDispatcher *) 0 ;
  btCollisionObject *arg2 = (btCollisionObject *) 0 ;
  btCollisionObject *arg3 = (btCollisionObject *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  (void)jarg3_;
  arg1 = *(btDispatcher **)&jarg1; 
  arg2 = *(btCollisionObject **)&jarg2; 
  arg3 = *(btCollisionObject **)&jarg3; 
  result = (bool)(arg1)->needsResponse((btCollisionObject const *)arg2,(btCollisionObject const *)arg3);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btDispatcher_1dispatchAllCollisionPairs(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlong jarg3, jobject jarg3_, jlong jarg4, jobject jarg4_) {
  btDispatcher *arg1 = (btDispatcher *) 0 ;
  btOverlappingPairCache *arg2 = (btOverlappingPairCache *) 0 ;
  btDispatcherInfo *arg3 = 0 ;
  btDispatcher *arg4 = (btDispatcher *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  (void)jarg3_;
  (void)jarg4_;
  arg1 = *(btDispatcher **)&jarg1; 
  arg2 = *(btOverlappingPairCache **)&jarg2; 
  arg3 = *(btDispatcherInfo **)&jarg3;
  if (!arg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btDispatcherInfo const & reference is null");
    return ;
  } 
  arg4 = *(btDispatcher **)&jarg4; 
  (arg1)->dispatchAllCollisionPairs(arg2,(btDispatcherInfo const &)*arg3,arg4);
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btDispatcher_1getNumManifolds(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  btDispatcher *arg1 = (btDispatcher *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btDispatcher **)&jarg1; 
  result = (int)((btDispatcher const *)arg1)->getNumManifolds();
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btDispatcher_1getManifoldByIndexInternal(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  jlong jresult = 0 ;
  btDispatcher *arg1 = (btDispatcher *) 0 ;
  int arg2 ;
  btPersistentManifold *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btDispatcher **)&jarg1; 
  arg2 = (int)jarg2; 
  result = (btPersistentManifold *)(arg1)->getManifoldByIndexInternal(arg2);
  *(btPersistentManifold **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btDispatcher_1getInternalManifoldPointer(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btDispatcher *arg1 = (btDispatcher *) 0 ;
  btPersistentManifold **result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btDispatcher **)&jarg1; 
  result = (btPersistentManifold **)(arg1)->getInternalManifoldPointer();
  *(btPersistentManifold ***)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btDispatcher_1getInternalManifoldPool_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btDispatcher *arg1 = (btDispatcher *) 0 ;
  btPoolAllocator *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btDispatcher **)&jarg1; 
  result = (btPoolAllocator *)(arg1)->getInternalManifoldPool();
  *(btPoolAllocator **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btDispatcher_1allocateCollisionAlgorithm(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  jlong jresult = 0 ;
  btDispatcher *arg1 = (btDispatcher *) 0 ;
  int arg2 ;
  void *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btDispatcher **)&jarg1; 
  arg2 = (int)jarg2; 
  result = (void *)(arg1)->allocateCollisionAlgorithm(arg2);
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btDispatcher_1freeCollisionAlgorithm(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  btDispatcher *arg1 = (btDispatcher *) 0 ;
  void *arg2 = (void *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btDispatcher **)&jarg1; 
  arg2 = (void *)jarg2; 
  (arg1)->freeCollisionAlgorithm(arg2);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_delete_1btOverlapCallback(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  btOverlapCallback *arg1 = (btOverlapCallback *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(btOverlapCallback **)&jarg1; 
  delete arg1;
}


SWIGEXPORT jboolean JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btOverlapCallback_1processOverlap(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2) {
  jboolean jresult = 0 ;
  btOverlapCallback *arg1 = (btOverlapCallback *) 0 ;
  btBroadphasePair *arg2 = 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btOverlapCallback **)&jarg1; 
  arg2 = *(btBroadphasePair **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btBroadphasePair & reference is null");
    return 0;
  } 
  result = (bool)(arg1)->processOverlap(*arg2);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_new_1btOverlapCallback(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  btOverlapCallback *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (btOverlapCallback *)new SwigDirector_btOverlapCallback(jenv);
  *(btOverlapCallback **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btOverlapCallback_1director_1connect(JNIEnv *jenv, jclass jcls, jobject jself, jlong objarg, jboolean jswig_mem_own, jboolean jweak_global) {
  btOverlapCallback *obj = *((btOverlapCallback **)&objarg);
  (void)jcls;
  SwigDirector_btOverlapCallback *director = (SwigDirector_btOverlapCallback *)(obj);
  if (director) {
    director->swig_connect_director(jenv, jself, jenv->GetObjectClass(jself), (jswig_mem_own == JNI_TRUE), (jweak_global == JNI_TRUE));
  }
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btOverlapCallback_1change_1ownership(JNIEnv *jenv, jclass jcls, jobject jself, jlong objarg, jboolean jtake_or_release) {
  btOverlapCallback *obj = *((btOverlapCallback **)&objarg);
  SwigDirector_btOverlapCallback *director = (SwigDirector_btOverlapCallback *)(obj);
  (void)jcls;
  if (director) {
    director->swig_java_change_ownership(jenv, jself, jtake_or_release ? true : false);
  }
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_delete_1btOverlapFilterCallback(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  btOverlapFilterCallback *arg1 = (btOverlapFilterCallback *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(btOverlapFilterCallback **)&jarg1; 
  delete arg1;
}


SWIGEXPORT jboolean JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btOverlapFilterCallback_1needBroadphaseCollision(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlong jarg3, jobject jarg3_) {
  jboolean jresult = 0 ;
  btOverlapFilterCallback *arg1 = (btOverlapFilterCallback *) 0 ;
  btBroadphaseProxy *arg2 = (btBroadphaseProxy *) 0 ;
  btBroadphaseProxy *arg3 = (btBroadphaseProxy *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  (void)jarg3_;
  arg1 = *(btOverlapFilterCallback **)&jarg1; 
  arg2 = *(btBroadphaseProxy **)&jarg2; 
  arg3 = *(btBroadphaseProxy **)&jarg3; 
  result = (bool)((btOverlapFilterCallback const *)arg1)->needBroadphaseCollision(arg2,arg3);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_new_1btOverlapFilterCallback(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  btOverlapFilterCallback *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (btOverlapFilterCallback *)new SwigDirector_btOverlapFilterCallback(jenv);
  *(btOverlapFilterCallback **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btOverlapFilterCallback_1director_1connect(JNIEnv *jenv, jclass jcls, jobject jself, jlong objarg, jboolean jswig_mem_own, jboolean jweak_global) {
  btOverlapFilterCallback *obj = *((btOverlapFilterCallback **)&objarg);
  (void)jcls;
  SwigDirector_btOverlapFilterCallback *director = (SwigDirector_btOverlapFilterCallback *)(obj);
  if (director) {
    director->swig_connect_director(jenv, jself, jenv->GetObjectClass(jself), (jswig_mem_own == JNI_TRUE), (jweak_global == JNI_TRUE));
  }
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btOverlapFilterCallback_1change_1ownership(JNIEnv *jenv, jclass jcls, jobject jself, jlong objarg, jboolean jtake_or_release) {
  btOverlapFilterCallback *obj = *((btOverlapFilterCallback **)&objarg);
  SwigDirector_btOverlapFilterCallback *director = (SwigDirector_btOverlapFilterCallback *)(obj);
  (void)jcls;
  if (director) {
    director->swig_java_change_ownership(jenv, jself, jtake_or_release ? true : false);
  }
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_gRemovePairs_1set(JNIEnv *jenv, jclass jcls, jint jarg1) {
  int arg1 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (int)jarg1; 
  gRemovePairs = arg1;
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_gRemovePairs_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  result = (int)gRemovePairs;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_gAddedPairs_1set(JNIEnv *jenv, jclass jcls, jint jarg1) {
  int arg1 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (int)jarg1; 
  gAddedPairs = arg1;
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_gAddedPairs_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  result = (int)gAddedPairs;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_gFindPairs_1set(JNIEnv *jenv, jclass jcls, jint jarg1) {
  int arg1 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (int)jarg1; 
  gFindPairs = arg1;
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_gFindPairs_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  result = (int)gFindPairs;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_BT_1NULL_1PAIR_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  result = (int)(int)BT_NULL_PAIR;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_delete_1btOverlappingPairCache(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  btOverlappingPairCache *arg1 = (btOverlappingPairCache *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(btOverlappingPairCache **)&jarg1; 
  delete arg1;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btOverlappingPairCache_1getOverlappingPairArrayPtr_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btOverlappingPairCache *arg1 = (btOverlappingPairCache *) 0 ;
  btBroadphasePair *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btOverlappingPairCache **)&jarg1; 
  result = (btBroadphasePair *)(arg1)->getOverlappingPairArrayPtr();
  *(btBroadphasePair **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btOverlappingPairCache_1getOverlappingPairArray(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btOverlappingPairCache *arg1 = (btOverlappingPairCache *) 0 ;
  btBroadphasePairArray *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btOverlappingPairCache **)&jarg1; 
  result = (btBroadphasePairArray *) &(arg1)->getOverlappingPairArray();
  *(btBroadphasePairArray **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btOverlappingPairCache_1cleanOverlappingPair(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2, jlong jarg3, jobject jarg3_) {
  btOverlappingPairCache *arg1 = (btOverlappingPairCache *) 0 ;
  btBroadphasePair *arg2 = 0 ;
  btDispatcher *arg3 = (btDispatcher *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg3_;
  arg1 = *(btOverlappingPairCache **)&jarg1; 
  arg2 = *(btBroadphasePair **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btBroadphasePair & reference is null");
    return ;
  } 
  arg3 = *(btDispatcher **)&jarg3; 
  (arg1)->cleanOverlappingPair(*arg2,arg3);
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btOverlappingPairCache_1getNumOverlappingPairs(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  btOverlappingPairCache *arg1 = (btOverlappingPairCache *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btOverlappingPairCache **)&jarg1; 
  result = (int)((btOverlappingPairCache const *)arg1)->getNumOverlappingPairs();
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btOverlappingPairCache_1cleanProxyFromPairs(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlong jarg3, jobject jarg3_) {
  btOverlappingPairCache *arg1 = (btOverlappingPairCache *) 0 ;
  btBroadphaseProxy *arg2 = (btBroadphaseProxy *) 0 ;
  btDispatcher *arg3 = (btDispatcher *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  (void)jarg3_;
  arg1 = *(btOverlappingPairCache **)&jarg1; 
  arg2 = *(btBroadphaseProxy **)&jarg2; 
  arg3 = *(btDispatcher **)&jarg3; 
  (arg1)->cleanProxyFromPairs(arg2,arg3);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btOverlappingPairCache_1setOverlapFilterCallback(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btOverlappingPairCache *arg1 = (btOverlappingPairCache *) 0 ;
  btOverlapFilterCallback *arg2 = (btOverlapFilterCallback *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btOverlappingPairCache **)&jarg1; 
  arg2 = *(btOverlapFilterCallback **)&jarg2; 
  (arg1)->setOverlapFilterCallback(arg2);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btOverlappingPairCache_1processAllOverlappingPairs(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlong jarg3, jobject jarg3_) {
  btOverlappingPairCache *arg1 = (btOverlappingPairCache *) 0 ;
  btOverlapCallback *arg2 = (btOverlapCallback *) 0 ;
  btDispatcher *arg3 = (btDispatcher *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  (void)jarg3_;
  arg1 = *(btOverlappingPairCache **)&jarg1; 
  arg2 = *(btOverlapCallback **)&jarg2; 
  arg3 = *(btDispatcher **)&jarg3; 
  (arg1)->processAllOverlappingPairs(arg2,arg3);
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btOverlappingPairCache_1findPair(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlong jarg3, jobject jarg3_) {
  jlong jresult = 0 ;
  btOverlappingPairCache *arg1 = (btOverlappingPairCache *) 0 ;
  btBroadphaseProxy *arg2 = (btBroadphaseProxy *) 0 ;
  btBroadphaseProxy *arg3 = (btBroadphaseProxy *) 0 ;
  btBroadphasePair *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  (void)jarg3_;
  arg1 = *(btOverlappingPairCache **)&jarg1; 
  arg2 = *(btBroadphaseProxy **)&jarg2; 
  arg3 = *(btBroadphaseProxy **)&jarg3; 
  result = (btBroadphasePair *)(arg1)->findPair(arg2,arg3);
  *(btBroadphasePair **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btOverlappingPairCache_1hasDeferredRemoval(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  btOverlappingPairCache *arg1 = (btOverlappingPairCache *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btOverlappingPairCache **)&jarg1; 
  result = (bool)(arg1)->hasDeferredRemoval();
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btOverlappingPairCache_1setInternalGhostPairCallback(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btOverlappingPairCache *arg1 = (btOverlappingPairCache *) 0 ;
  btOverlappingPairCallback *arg2 = (btOverlappingPairCallback *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btOverlappingPairCache **)&jarg1; 
  arg2 = *(btOverlappingPairCallback **)&jarg2; 
  (arg1)->setInternalGhostPairCallback(arg2);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btOverlappingPairCache_1sortOverlappingPairs(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btOverlappingPairCache *arg1 = (btOverlappingPairCache *) 0 ;
  btDispatcher *arg2 = (btDispatcher *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btOverlappingPairCache **)&jarg1; 
  arg2 = *(btDispatcher **)&jarg2; 
  (arg1)->sortOverlappingPairs(arg2);
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_new_1btHashedOverlappingPairCache(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  btHashedOverlappingPairCache *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (btHashedOverlappingPairCache *)new btHashedOverlappingPairCache();
  *(btHashedOverlappingPairCache **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_delete_1btHashedOverlappingPairCache(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  btHashedOverlappingPairCache *arg1 = (btHashedOverlappingPairCache *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(btHashedOverlappingPairCache **)&jarg1; 
  delete arg1;
}


SWIGEXPORT jboolean JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btHashedOverlappingPairCache_1needsBroadphaseCollision(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlong jarg3, jobject jarg3_) {
  jboolean jresult = 0 ;
  btHashedOverlappingPairCache *arg1 = (btHashedOverlappingPairCache *) 0 ;
  btBroadphaseProxy *arg2 = (btBroadphaseProxy *) 0 ;
  btBroadphaseProxy *arg3 = (btBroadphaseProxy *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  (void)jarg3_;
  arg1 = *(btHashedOverlappingPairCache **)&jarg1; 
  arg2 = *(btBroadphaseProxy **)&jarg2; 
  arg3 = *(btBroadphaseProxy **)&jarg3; 
  result = (bool)((btHashedOverlappingPairCache const *)arg1)->needsBroadphaseCollision(arg2,arg3);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btHashedOverlappingPairCache_1getOverlappingPairArrayPtr_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btHashedOverlappingPairCache *arg1 = (btHashedOverlappingPairCache *) 0 ;
  btBroadphasePair *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btHashedOverlappingPairCache **)&jarg1; 
  result = (btBroadphasePair *)(arg1)->getOverlappingPairArrayPtr();
  *(btBroadphasePair **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btHashedOverlappingPairCache_1getOverlappingPairArray_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btHashedOverlappingPairCache *arg1 = (btHashedOverlappingPairCache *) 0 ;
  btBroadphasePairArray *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btHashedOverlappingPairCache **)&jarg1; 
  result = (btBroadphasePairArray *) &(arg1)->getOverlappingPairArray();
  *(btBroadphasePairArray **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btHashedOverlappingPairCache_1GetCount(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  btHashedOverlappingPairCache *arg1 = (btHashedOverlappingPairCache *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btHashedOverlappingPairCache **)&jarg1; 
  result = (int)((btHashedOverlappingPairCache const *)arg1)->GetCount();
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btHashedOverlappingPairCache_1getOverlapFilterCallback(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btHashedOverlappingPairCache *arg1 = (btHashedOverlappingPairCache *) 0 ;
  btOverlapFilterCallback *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btHashedOverlappingPairCache **)&jarg1; 
  result = (btOverlapFilterCallback *)(arg1)->getOverlapFilterCallback();
  *(btOverlapFilterCallback **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_new_1btSortedOverlappingPairCache(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  btSortedOverlappingPairCache *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (btSortedOverlappingPairCache *)new btSortedOverlappingPairCache();
  *(btSortedOverlappingPairCache **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_delete_1btSortedOverlappingPairCache(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  btSortedOverlappingPairCache *arg1 = (btSortedOverlappingPairCache *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(btSortedOverlappingPairCache **)&jarg1; 
  delete arg1;
}


SWIGEXPORT jboolean JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btSortedOverlappingPairCache_1needsBroadphaseCollision(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlong jarg3, jobject jarg3_) {
  jboolean jresult = 0 ;
  btSortedOverlappingPairCache *arg1 = (btSortedOverlappingPairCache *) 0 ;
  btBroadphaseProxy *arg2 = (btBroadphaseProxy *) 0 ;
  btBroadphaseProxy *arg3 = (btBroadphaseProxy *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  (void)jarg3_;
  arg1 = *(btSortedOverlappingPairCache **)&jarg1; 
  arg2 = *(btBroadphaseProxy **)&jarg2; 
  arg3 = *(btBroadphaseProxy **)&jarg3; 
  result = (bool)((btSortedOverlappingPairCache const *)arg1)->needsBroadphaseCollision(arg2,arg3);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btSortedOverlappingPairCache_1getOverlappingPairArray_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btSortedOverlappingPairCache *arg1 = (btSortedOverlappingPairCache *) 0 ;
  btBroadphasePairArray *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSortedOverlappingPairCache **)&jarg1; 
  result = (btBroadphasePairArray *) &(arg1)->getOverlappingPairArray();
  *(btBroadphasePairArray **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btSortedOverlappingPairCache_1getOverlappingPairArrayPtr_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btSortedOverlappingPairCache *arg1 = (btSortedOverlappingPairCache *) 0 ;
  btBroadphasePair *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSortedOverlappingPairCache **)&jarg1; 
  result = (btBroadphasePair *)(arg1)->getOverlappingPairArrayPtr();
  *(btBroadphasePair **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btSortedOverlappingPairCache_1getOverlapFilterCallback(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btSortedOverlappingPairCache *arg1 = (btSortedOverlappingPairCache *) 0 ;
  btOverlapFilterCallback *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSortedOverlappingPairCache **)&jarg1; 
  result = (btOverlapFilterCallback *)(arg1)->getOverlapFilterCallback();
  *(btOverlapFilterCallback **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btNullPairCache_1getOverlappingPairArrayPtr_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btNullPairCache *arg1 = (btNullPairCache *) 0 ;
  btBroadphasePair *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btNullPairCache **)&jarg1; 
  result = (btBroadphasePair *)(arg1)->getOverlappingPairArrayPtr();
  *(btBroadphasePair **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_new_1btNullPairCache(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  btNullPairCache *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (btNullPairCache *)new btNullPairCache();
  *(btNullPairCache **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_delete_1btNullPairCache(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  btNullPairCache *arg1 = (btNullPairCache *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(btNullPairCache **)&jarg1; 
  delete arg1;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_delete_1btCollisionShape(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  btCollisionShape *arg1 = (btCollisionShape *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(btCollisionShape **)&jarg1; 
  delete arg1;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btCollisionShape_1getAabb(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2, jobject jarg3, jobject jarg4) {
  btCollisionShape *arg1 = (btCollisionShape *) 0 ;
  btTransform *arg2 = 0 ;
  btVector3 *arg3 = 0 ;
  btVector3 *arg4 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btCollisionShape **)&jarg1; 
  btTransform local_arg2;
  gdx_setbtTransformFromMatrix4(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitMatrix4 auto_commit_arg2(jenv, jarg2, &local_arg2);
  btVector3 local_arg3;
  gdx_setbtVector3FromVector3(jenv, local_arg3, jarg3);
  arg3 = &local_arg3;
  gdxAutoCommitVector3 auto_commit_arg3(jenv, jarg3, &local_arg3);
  btVector3 local_arg4;
  gdx_setbtVector3FromVector3(jenv, local_arg4, jarg4);
  arg4 = &local_arg4;
  gdxAutoCommitVector3 auto_commit_arg4(jenv, jarg4, &local_arg4);
  ((btCollisionShape const *)arg1)->getAabb((btTransform const &)*arg2,*arg3,*arg4);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btCollisionShape_1getBoundingSphere(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2, jlong jarg3) {
  btCollisionShape *arg1 = (btCollisionShape *) 0 ;
  btVector3 *arg2 = 0 ;
  btScalar *arg3 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btCollisionShape **)&jarg1; 
  btVector3 local_arg2;
  gdx_setbtVector3FromVector3(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitVector3 auto_commit_arg2(jenv, jarg2, &local_arg2);
  arg3 = *(btScalar **)&jarg3;
  if (!arg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btScalar & reference is null");
    return ;
  } 
  ((btCollisionShape const *)arg1)->getBoundingSphere(*arg2,*arg3);
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btCollisionShape_1getAngularMotionDisc(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jfloat jresult = 0 ;
  btCollisionShape *arg1 = (btCollisionShape *) 0 ;
  btScalar result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btCollisionShape **)&jarg1; 
  result = (btScalar)((btCollisionShape const *)arg1)->getAngularMotionDisc();
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btCollisionShape_1getContactBreakingThreshold(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2) {
  jfloat jresult = 0 ;
  btCollisionShape *arg1 = (btCollisionShape *) 0 ;
  btScalar arg2 ;
  btScalar result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btCollisionShape **)&jarg1; 
  arg2 = (btScalar)jarg2; 
  result = (btScalar)((btCollisionShape const *)arg1)->getContactBreakingThreshold(arg2);
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btCollisionShape_1calculateTemporalAabb(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2, jobject jarg3, jobject jarg4, jfloat jarg5, jobject jarg6, jobject jarg7) {
  btCollisionShape *arg1 = (btCollisionShape *) 0 ;
  btTransform *arg2 = 0 ;
  btVector3 *arg3 = 0 ;
  btVector3 *arg4 = 0 ;
  btScalar arg5 ;
  btVector3 *arg6 = 0 ;
  btVector3 *arg7 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btCollisionShape **)&jarg1; 
  btTransform local_arg2;
  gdx_setbtTransformFromMatrix4(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitMatrix4 auto_commit_arg2(jenv, jarg2, &local_arg2);
  btVector3 local_arg3;
  gdx_setbtVector3FromVector3(jenv, local_arg3, jarg3);
  arg3 = &local_arg3;
  gdxAutoCommitVector3 auto_commit_arg3(jenv, jarg3, &local_arg3);
  btVector3 local_arg4;
  gdx_setbtVector3FromVector3(jenv, local_arg4, jarg4);
  arg4 = &local_arg4;
  gdxAutoCommitVector3 auto_commit_arg4(jenv, jarg4, &local_arg4);
  arg5 = (btScalar)jarg5; 
  btVector3 local_arg6;
  gdx_setbtVector3FromVector3(jenv, local_arg6, jarg6);
  arg6 = &local_arg6;
  gdxAutoCommitVector3 auto_commit_arg6(jenv, jarg6, &local_arg6);
  btVector3 local_arg7;
  gdx_setbtVector3FromVector3(jenv, local_arg7, jarg7);
  arg7 = &local_arg7;
  gdxAutoCommitVector3 auto_commit_arg7(jenv, jarg7, &local_arg7);
  ((btCollisionShape const *)arg1)->calculateTemporalAabb((btTransform const &)*arg2,(btVector3 const &)*arg3,(btVector3 const &)*arg4,arg5,*arg6,*arg7);
}


SWIGEXPORT jboolean JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btCollisionShape_1isPolyhedral(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  btCollisionShape *arg1 = (btCollisionShape *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btCollisionShape **)&jarg1; 
  result = (bool)((btCollisionShape const *)arg1)->isPolyhedral();
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btCollisionShape_1isConvex2d(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  btCollisionShape *arg1 = (btCollisionShape *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btCollisionShape **)&jarg1; 
  result = (bool)((btCollisionShape const *)arg1)->isConvex2d();
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btCollisionShape_1isConvex(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  btCollisionShape *arg1 = (btCollisionShape *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btCollisionShape **)&jarg1; 
  result = (bool)((btCollisionShape const *)arg1)->isConvex();
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btCollisionShape_1isNonMoving(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  btCollisionShape *arg1 = (btCollisionShape *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btCollisionShape **)&jarg1; 
  result = (bool)((btCollisionShape const *)arg1)->isNonMoving();
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btCollisionShape_1isConcave(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  btCollisionShape *arg1 = (btCollisionShape *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btCollisionShape **)&jarg1; 
  result = (bool)((btCollisionShape const *)arg1)->isConcave();
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btCollisionShape_1isCompound(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  btCollisionShape *arg1 = (btCollisionShape *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btCollisionShape **)&jarg1; 
  result = (bool)((btCollisionShape const *)arg1)->isCompound();
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btCollisionShape_1isSoftBody(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  btCollisionShape *arg1 = (btCollisionShape *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btCollisionShape **)&jarg1; 
  result = (bool)((btCollisionShape const *)arg1)->isSoftBody();
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btCollisionShape_1isInfinite(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  btCollisionShape *arg1 = (btCollisionShape *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btCollisionShape **)&jarg1; 
  result = (bool)((btCollisionShape const *)arg1)->isInfinite();
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btCollisionShape_1setLocalScaling(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2) {
  btCollisionShape *arg1 = (btCollisionShape *) 0 ;
  btVector3 *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btCollisionShape **)&jarg1; 
  btVector3 local_arg2;
  gdx_setbtVector3FromVector3(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitVector3 auto_commit_arg2(jenv, jarg2, &local_arg2);
  (arg1)->setLocalScaling((btVector3 const &)*arg2);
}


SWIGEXPORT jobject JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btCollisionShape_1getLocalScaling(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jobject jresult = 0 ;
  btCollisionShape *arg1 = (btCollisionShape *) 0 ;
  btVector3 *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btCollisionShape **)&jarg1; 
  result = (btVector3 *) &((btCollisionShape const *)arg1)->getLocalScaling();
  jresult = gdx_getReturnVector3(jenv);
  gdx_setVector3FrombtVector3(jenv, jresult, result);
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btCollisionShape_1calculateLocalInertia(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2, jobject jarg3) {
  btCollisionShape *arg1 = (btCollisionShape *) 0 ;
  btScalar arg2 ;
  btVector3 *arg3 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btCollisionShape **)&jarg1; 
  arg2 = (btScalar)jarg2; 
  btVector3 local_arg3;
  gdx_setbtVector3FromVector3(jenv, local_arg3, jarg3);
  arg3 = &local_arg3;
  gdxAutoCommitVector3 auto_commit_arg3(jenv, jarg3, &local_arg3);
  ((btCollisionShape const *)arg1)->calculateLocalInertia(arg2,*arg3);
}


SWIGEXPORT jstring JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btCollisionShape_1getName(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  btCollisionShape *arg1 = (btCollisionShape *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btCollisionShape **)&jarg1; 
  result = (char *)((btCollisionShape const *)arg1)->getName();
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btCollisionShape_1getShapeType(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  btCollisionShape *arg1 = (btCollisionShape *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btCollisionShape **)&jarg1; 
  result = (int)((btCollisionShape const *)arg1)->getShapeType();
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jobject JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btCollisionShape_1getAnisotropicRollingFrictionDirection(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jobject jresult = 0 ;
  btCollisionShape *arg1 = (btCollisionShape *) 0 ;
  btVector3 result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btCollisionShape **)&jarg1; 
  result = ((btCollisionShape const *)arg1)->getAnisotropicRollingFrictionDirection();
  jresult = gdx_getReturnVector3(jenv);
  gdx_setVector3FrombtVector3(jenv, jresult, result);
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btCollisionShape_1setMargin(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2) {
  btCollisionShape *arg1 = (btCollisionShape *) 0 ;
  btScalar arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btCollisionShape **)&jarg1; 
  arg2 = (btScalar)jarg2; 
  (arg1)->setMargin(arg2);
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btCollisionShape_1getMargin(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jfloat jresult = 0 ;
  btCollisionShape *arg1 = (btCollisionShape *) 0 ;
  btScalar result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btCollisionShape **)&jarg1; 
  result = (btScalar)((btCollisionShape const *)arg1)->getMargin();
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btCollisionShape_1setUserPointer(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  btCollisionShape *arg1 = (btCollisionShape *) 0 ;
  void *arg2 = (void *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btCollisionShape **)&jarg1; 
  arg2 = (void *)jarg2; 
  (arg1)->setUserPointer(arg2);
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btCollisionShape_1getUserPointer(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btCollisionShape *arg1 = (btCollisionShape *) 0 ;
  void *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btCollisionShape **)&jarg1; 
  result = (void *)((btCollisionShape const *)arg1)->getUserPointer();
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btCollisionShape_1setUserIndex(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  btCollisionShape *arg1 = (btCollisionShape *) 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btCollisionShape **)&jarg1; 
  arg2 = (int)jarg2; 
  (arg1)->setUserIndex(arg2);
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btCollisionShape_1getUserIndex(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  btCollisionShape *arg1 = (btCollisionShape *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btCollisionShape **)&jarg1; 
  result = (int)((btCollisionShape const *)arg1)->getUserIndex();
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btCollisionShape_1calculateSerializeBufferSize(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  btCollisionShape *arg1 = (btCollisionShape *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btCollisionShape **)&jarg1; 
  result = (int)((btCollisionShape const *)arg1)->calculateSerializeBufferSize();
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btCollisionShape_1serialize(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jlong jarg3) {
  jstring jresult = 0 ;
  btCollisionShape *arg1 = (btCollisionShape *) 0 ;
  void *arg2 = (void *) 0 ;
  btSerializer *arg3 = (btSerializer *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btCollisionShape **)&jarg1; 
  arg2 = (void *)jarg2; 
  arg3 = *(btSerializer **)&jarg3; 
  result = (char *)((btCollisionShape const *)arg1)->serialize(arg2,arg3);
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btCollisionShape_1serializeSingleShape(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  btCollisionShape *arg1 = (btCollisionShape *) 0 ;
  btSerializer *arg2 = (btSerializer *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btCollisionShape **)&jarg1; 
  arg2 = *(btSerializer **)&jarg2; 
  ((btCollisionShape const *)arg1)->serializeSingleShape(arg2);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btCollisionShapeData_1name_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  btCollisionShapeData *arg1 = (btCollisionShapeData *) 0 ;
  char *arg2 = (char *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btCollisionShapeData **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return ;
  }
  {
    delete [] arg1->m_name;
    if (arg2) {
      arg1->m_name = (char *) (new char[strlen((const char *)arg2)+1]);
      strcpy((char *)arg1->m_name, (const char *)arg2);
    } else {
      arg1->m_name = 0;
    }
  }
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
}


SWIGEXPORT jstring JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btCollisionShapeData_1name_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  btCollisionShapeData *arg1 = (btCollisionShapeData *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btCollisionShapeData **)&jarg1; 
  result = (char *) ((arg1)->m_name);
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btCollisionShapeData_1shapeType_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  btCollisionShapeData *arg1 = (btCollisionShapeData *) 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btCollisionShapeData **)&jarg1; 
  arg2 = (int)jarg2; 
  if (arg1) (arg1)->m_shapeType = arg2;
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btCollisionShapeData_1shapeType_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  btCollisionShapeData *arg1 = (btCollisionShapeData *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btCollisionShapeData **)&jarg1; 
  result = (int) ((arg1)->m_shapeType);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btCollisionShapeData_1padding_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  btCollisionShapeData *arg1 = (btCollisionShapeData *) 0 ;
  char *arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btCollisionShapeData **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return ;
  }
  {
    if(arg2) {
      strncpy((char*)arg1->m_padding, (const char *)arg2, 4-1);
      arg1->m_padding[4-1] = 0;
    } else {
      arg1->m_padding[0] = 0;
    }
  }
  
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
}


SWIGEXPORT jstring JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btCollisionShapeData_1padding_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  btCollisionShapeData *arg1 = (btCollisionShapeData *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btCollisionShapeData **)&jarg1; 
  result = (char *)(char *) ((arg1)->m_padding);
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_new_1btCollisionShapeData(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  btCollisionShapeData *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (btCollisionShapeData *)new btCollisionShapeData();
  *(btCollisionShapeData **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_delete_1btCollisionShapeData(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  btCollisionShapeData *arg1 = (btCollisionShapeData *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(btCollisionShapeData **)&jarg1; 
  delete arg1;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_delete_1btConvexShape(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  btConvexShape *arg1 = (btConvexShape *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(btConvexShape **)&jarg1; 
  delete arg1;
}


SWIGEXPORT jobject JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btConvexShape_1localGetSupportingVertex(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2) {
  jobject jresult = 0 ;
  btConvexShape *arg1 = (btConvexShape *) 0 ;
  btVector3 *arg2 = 0 ;
  btVector3 result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btConvexShape **)&jarg1; 
  btVector3 local_arg2;
  gdx_setbtVector3FromVector3(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitVector3 auto_commit_arg2(jenv, jarg2, &local_arg2);
  result = ((btConvexShape const *)arg1)->localGetSupportingVertex((btVector3 const &)*arg2);
  jresult = gdx_getReturnVector3(jenv);
  gdx_setVector3FrombtVector3(jenv, jresult, result);
  return jresult;
}


SWIGEXPORT jobject JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btConvexShape_1localGetSupportingVertexWithoutMargin(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2) {
  jobject jresult = 0 ;
  btConvexShape *arg1 = (btConvexShape *) 0 ;
  btVector3 *arg2 = 0 ;
  btVector3 result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btConvexShape **)&jarg1; 
  btVector3 local_arg2;
  gdx_setbtVector3FromVector3(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitVector3 auto_commit_arg2(jenv, jarg2, &local_arg2);
  result = ((btConvexShape const *)arg1)->localGetSupportingVertexWithoutMargin((btVector3 const &)*arg2);
  jresult = gdx_getReturnVector3(jenv);
  gdx_setVector3FrombtVector3(jenv, jresult, result);
  return jresult;
}


SWIGEXPORT jobject JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btConvexShape_1localGetSupportVertexWithoutMarginNonVirtual(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2) {
  jobject jresult = 0 ;
  btConvexShape *arg1 = (btConvexShape *) 0 ;
  btVector3 *arg2 = 0 ;
  btVector3 result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btConvexShape **)&jarg1; 
  btVector3 local_arg2;
  gdx_setbtVector3FromVector3(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitVector3 auto_commit_arg2(jenv, jarg2, &local_arg2);
  result = ((btConvexShape const *)arg1)->localGetSupportVertexWithoutMarginNonVirtual((btVector3 const &)*arg2);
  jresult = gdx_getReturnVector3(jenv);
  gdx_setVector3FrombtVector3(jenv, jresult, result);
  return jresult;
}


SWIGEXPORT jobject JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btConvexShape_1localGetSupportVertexNonVirtual(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2) {
  jobject jresult = 0 ;
  btConvexShape *arg1 = (btConvexShape *) 0 ;
  btVector3 *arg2 = 0 ;
  btVector3 result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btConvexShape **)&jarg1; 
  btVector3 local_arg2;
  gdx_setbtVector3FromVector3(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitVector3 auto_commit_arg2(jenv, jarg2, &local_arg2);
  result = ((btConvexShape const *)arg1)->localGetSupportVertexNonVirtual((btVector3 const &)*arg2);
  jresult = gdx_getReturnVector3(jenv);
  gdx_setVector3FrombtVector3(jenv, jresult, result);
  return jresult;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btConvexShape_1getMarginNonVirtual(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jfloat jresult = 0 ;
  btConvexShape *arg1 = (btConvexShape *) 0 ;
  btScalar result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btConvexShape **)&jarg1; 
  result = (btScalar)((btConvexShape const *)arg1)->getMarginNonVirtual();
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btConvexShape_1getAabbNonVirtual(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2, jobject jarg3, jobject jarg4) {
  btConvexShape *arg1 = (btConvexShape *) 0 ;
  btTransform *arg2 = 0 ;
  btVector3 *arg3 = 0 ;
  btVector3 *arg4 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btConvexShape **)&jarg1; 
  btTransform local_arg2;
  gdx_setbtTransformFromMatrix4(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitMatrix4 auto_commit_arg2(jenv, jarg2, &local_arg2);
  btVector3 local_arg3;
  gdx_setbtVector3FromVector3(jenv, local_arg3, jarg3);
  arg3 = &local_arg3;
  gdxAutoCommitVector3 auto_commit_arg3(jenv, jarg3, &local_arg3);
  btVector3 local_arg4;
  gdx_setbtVector3FromVector3(jenv, local_arg4, jarg4);
  arg4 = &local_arg4;
  gdxAutoCommitVector3 auto_commit_arg4(jenv, jarg4, &local_arg4);
  ((btConvexShape const *)arg1)->getAabbNonVirtual((btTransform const &)*arg2,*arg3,*arg4);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btConvexShape_1project(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2, jobject jarg3, jlong jarg4, jlong jarg5, jobject jarg6, jobject jarg7) {
  btConvexShape *arg1 = (btConvexShape *) 0 ;
  btTransform *arg2 = 0 ;
  btVector3 *arg3 = 0 ;
  btScalar *arg4 = 0 ;
  btScalar *arg5 = 0 ;
  btVector3 *arg6 = 0 ;
  btVector3 *arg7 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btConvexShape **)&jarg1; 
  btTransform local_arg2;
  gdx_setbtTransformFromMatrix4(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitMatrix4 auto_commit_arg2(jenv, jarg2, &local_arg2);
  btVector3 local_arg3;
  gdx_setbtVector3FromVector3(jenv, local_arg3, jarg3);
  arg3 = &local_arg3;
  gdxAutoCommitVector3 auto_commit_arg3(jenv, jarg3, &local_arg3);
  arg4 = *(btScalar **)&jarg4;
  if (!arg4) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btScalar & reference is null");
    return ;
  } 
  arg5 = *(btScalar **)&jarg5;
  if (!arg5) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btScalar & reference is null");
    return ;
  } 
  btVector3 local_arg6;
  gdx_setbtVector3FromVector3(jenv, local_arg6, jarg6);
  arg6 = &local_arg6;
  gdxAutoCommitVector3 auto_commit_arg6(jenv, jarg6, &local_arg6);
  btVector3 local_arg7;
  gdx_setbtVector3FromVector3(jenv, local_arg7, jarg7);
  arg7 = &local_arg7;
  gdxAutoCommitVector3 auto_commit_arg7(jenv, jarg7, &local_arg7);
  ((btConvexShape const *)arg1)->project((btTransform const &)*arg2,(btVector3 const &)*arg3,*arg4,*arg5,*arg6,*arg7);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btConvexShape_1batchedUnitVectorGetSupportingVertexWithoutMargin(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlong jarg3, jobject jarg3_, jint jarg4) {
  btConvexShape *arg1 = (btConvexShape *) 0 ;
  btVector3 *arg2 = (btVector3 *) 0 ;
  btVector3 *arg3 = (btVector3 *) 0 ;
  int arg4 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  (void)jarg3_;
  arg1 = *(btConvexShape **)&jarg1; 
  arg2 = *(btVector3 **)&jarg2; 
  arg3 = *(btVector3 **)&jarg3; 
  arg4 = (int)jarg4; 
  ((btConvexShape const *)arg1)->batchedUnitVectorGetSupportingVertexWithoutMargin((btVector3 const *)arg2,arg3,arg4);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btConvexShape_1getAabbSlow(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2, jobject jarg3, jobject jarg4) {
  btConvexShape *arg1 = (btConvexShape *) 0 ;
  btTransform *arg2 = 0 ;
  btVector3 *arg3 = 0 ;
  btVector3 *arg4 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btConvexShape **)&jarg1; 
  btTransform local_arg2;
  gdx_setbtTransformFromMatrix4(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitMatrix4 auto_commit_arg2(jenv, jarg2, &local_arg2);
  btVector3 local_arg3;
  gdx_setbtVector3FromVector3(jenv, local_arg3, jarg3);
  arg3 = &local_arg3;
  gdxAutoCommitVector3 auto_commit_arg3(jenv, jarg3, &local_arg3);
  btVector3 local_arg4;
  gdx_setbtVector3FromVector3(jenv, local_arg4, jarg4);
  arg4 = &local_arg4;
  gdxAutoCommitVector3 auto_commit_arg4(jenv, jarg4, &local_arg4);
  ((btConvexShape const *)arg1)->getAabbSlow((btTransform const &)*arg2,*arg3,*arg4);
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btConvexShape_1getNumPreferredPenetrationDirections(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  btConvexShape *arg1 = (btConvexShape *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btConvexShape **)&jarg1; 
  result = (int)((btConvexShape const *)arg1)->getNumPreferredPenetrationDirections();
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btConvexShape_1getPreferredPenetrationDirection(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jobject jarg3) {
  btConvexShape *arg1 = (btConvexShape *) 0 ;
  int arg2 ;
  btVector3 *arg3 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btConvexShape **)&jarg1; 
  arg2 = (int)jarg2; 
  btVector3 local_arg3;
  gdx_setbtVector3FromVector3(jenv, local_arg3, jarg3);
  arg3 = &local_arg3;
  gdxAutoCommitVector3 auto_commit_arg3(jenv, jarg3, &local_arg3);
  ((btConvexShape const *)arg1)->getPreferredPenetrationDirection(arg2,*arg3);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_delete_1btConvexInternalShape(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  btConvexInternalShape *arg1 = (btConvexInternalShape *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(btConvexInternalShape **)&jarg1; 
  delete arg1;
}


SWIGEXPORT jobject JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btConvexInternalShape_1getImplicitShapeDimensions(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jobject jresult = 0 ;
  btConvexInternalShape *arg1 = (btConvexInternalShape *) 0 ;
  btVector3 *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btConvexInternalShape **)&jarg1; 
  result = (btVector3 *) &((btConvexInternalShape const *)arg1)->getImplicitShapeDimensions();
  jresult = gdx_getReturnVector3(jenv);
  gdx_setVector3FrombtVector3(jenv, jresult, result);
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btConvexInternalShape_1setImplicitShapeDimensions(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2) {
  btConvexInternalShape *arg1 = (btConvexInternalShape *) 0 ;
  btVector3 *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btConvexInternalShape **)&jarg1; 
  btVector3 local_arg2;
  gdx_setbtVector3FromVector3(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitVector3 auto_commit_arg2(jenv, jarg2, &local_arg2);
  (arg1)->setImplicitShapeDimensions((btVector3 const &)*arg2);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btConvexInternalShape_1setSafeMargin_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2, jfloat jarg3) {
  btConvexInternalShape *arg1 = (btConvexInternalShape *) 0 ;
  btScalar arg2 ;
  btScalar arg3 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btConvexInternalShape **)&jarg1; 
  arg2 = (btScalar)jarg2; 
  arg3 = (btScalar)jarg3; 
  (arg1)->setSafeMargin(arg2,arg3);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btConvexInternalShape_1setSafeMargin_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2) {
  btConvexInternalShape *arg1 = (btConvexInternalShape *) 0 ;
  btScalar arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btConvexInternalShape **)&jarg1; 
  arg2 = (btScalar)jarg2; 
  (arg1)->setSafeMargin(arg2);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btConvexInternalShape_1setSafeMargin_1_1SWIG_12(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2, jfloat jarg3) {
  btConvexInternalShape *arg1 = (btConvexInternalShape *) 0 ;
  btVector3 *arg2 = 0 ;
  btScalar arg3 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btConvexInternalShape **)&jarg1; 
  btVector3 local_arg2;
  gdx_setbtVector3FromVector3(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitVector3 auto_commit_arg2(jenv, jarg2, &local_arg2);
  arg3 = (btScalar)jarg3; 
  (arg1)->setSafeMargin((btVector3 const &)*arg2,arg3);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btConvexInternalShape_1setSafeMargin_1_1SWIG_13(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2) {
  btConvexInternalShape *arg1 = (btConvexInternalShape *) 0 ;
  btVector3 *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btConvexInternalShape **)&jarg1; 
  btVector3 local_arg2;
  gdx_setbtVector3FromVector3(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitVector3 auto_commit_arg2(jenv, jarg2, &local_arg2);
  (arg1)->setSafeMargin((btVector3 const &)*arg2);
}


SWIGEXPORT jobject JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btConvexInternalShape_1getLocalScalingNV(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jobject jresult = 0 ;
  btConvexInternalShape *arg1 = (btConvexInternalShape *) 0 ;
  btVector3 *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btConvexInternalShape **)&jarg1; 
  result = (btVector3 *) &((btConvexInternalShape const *)arg1)->getLocalScalingNV();
  jresult = gdx_getReturnVector3(jenv);
  gdx_setVector3FrombtVector3(jenv, jresult, result);
  return jresult;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btConvexInternalShape_1getMarginNV(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jfloat jresult = 0 ;
  btConvexInternalShape *arg1 = (btConvexInternalShape *) 0 ;
  btScalar result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btConvexInternalShape **)&jarg1; 
  result = (btScalar)((btConvexInternalShape const *)arg1)->getMarginNV();
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btConvexInternalShapeData_1collisionShapeData_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btConvexInternalShapeData *arg1 = (btConvexInternalShapeData *) 0 ;
  btCollisionShapeData *arg2 = (btCollisionShapeData *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btConvexInternalShapeData **)&jarg1; 
  arg2 = *(btCollisionShapeData **)&jarg2; 
  if (arg1) (arg1)->m_collisionShapeData = *arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btConvexInternalShapeData_1collisionShapeData_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btConvexInternalShapeData *arg1 = (btConvexInternalShapeData *) 0 ;
  btCollisionShapeData *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btConvexInternalShapeData **)&jarg1; 
  result = (btCollisionShapeData *)& ((arg1)->m_collisionShapeData);
  *(btCollisionShapeData **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btConvexInternalShapeData_1localScaling_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btConvexInternalShapeData *arg1 = (btConvexInternalShapeData *) 0 ;
  btVector3FloatData *arg2 = (btVector3FloatData *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btConvexInternalShapeData **)&jarg1; 
  arg2 = *(btVector3FloatData **)&jarg2; 
  if (arg1) (arg1)->m_localScaling = *arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btConvexInternalShapeData_1localScaling_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btConvexInternalShapeData *arg1 = (btConvexInternalShapeData *) 0 ;
  btVector3FloatData *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btConvexInternalShapeData **)&jarg1; 
  result = (btVector3FloatData *)& ((arg1)->m_localScaling);
  *(btVector3FloatData **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btConvexInternalShapeData_1implicitShapeDimensions_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btConvexInternalShapeData *arg1 = (btConvexInternalShapeData *) 0 ;
  btVector3FloatData *arg2 = (btVector3FloatData *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btConvexInternalShapeData **)&jarg1; 
  arg2 = *(btVector3FloatData **)&jarg2; 
  if (arg1) (arg1)->m_implicitShapeDimensions = *arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btConvexInternalShapeData_1implicitShapeDimensions_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btConvexInternalShapeData *arg1 = (btConvexInternalShapeData *) 0 ;
  btVector3FloatData *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btConvexInternalShapeData **)&jarg1; 
  result = (btVector3FloatData *)& ((arg1)->m_implicitShapeDimensions);
  *(btVector3FloatData **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btConvexInternalShapeData_1collisionMargin_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2) {
  btConvexInternalShapeData *arg1 = (btConvexInternalShapeData *) 0 ;
  float arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btConvexInternalShapeData **)&jarg1; 
  arg2 = (float)jarg2; 
  if (arg1) (arg1)->m_collisionMargin = arg2;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btConvexInternalShapeData_1collisionMargin_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jfloat jresult = 0 ;
  btConvexInternalShapeData *arg1 = (btConvexInternalShapeData *) 0 ;
  float result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btConvexInternalShapeData **)&jarg1; 
  result = (float) ((arg1)->m_collisionMargin);
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btConvexInternalShapeData_1padding_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  btConvexInternalShapeData *arg1 = (btConvexInternalShapeData *) 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btConvexInternalShapeData **)&jarg1; 
  arg2 = (int)jarg2; 
  if (arg1) (arg1)->m_padding = arg2;
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btConvexInternalShapeData_1padding_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  btConvexInternalShapeData *arg1 = (btConvexInternalShapeData *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btConvexInternalShapeData **)&jarg1; 
  result = (int) ((arg1)->m_padding);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_new_1btConvexInternalShapeData(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  btConvexInternalShapeData *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (btConvexInternalShapeData *)new btConvexInternalShapeData();
  *(btConvexInternalShapeData **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_delete_1btConvexInternalShapeData(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  btConvexInternalShapeData *arg1 = (btConvexInternalShapeData *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(btConvexInternalShapeData **)&jarg1; 
  delete arg1;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btConvexInternalAabbCachingShape_1recalcLocalAabb(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  btConvexInternalAabbCachingShape *arg1 = (btConvexInternalAabbCachingShape *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btConvexInternalAabbCachingShape **)&jarg1; 
  (arg1)->recalcLocalAabb();
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_delete_1btConvexInternalAabbCachingShape(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  btConvexInternalAabbCachingShape *arg1 = (btConvexInternalAabbCachingShape *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(btConvexInternalAabbCachingShape **)&jarg1; 
  delete arg1;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_delete_1btPolyhedralConvexShape(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  btPolyhedralConvexShape *arg1 = (btPolyhedralConvexShape *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(btPolyhedralConvexShape **)&jarg1; 
  delete arg1;
}


SWIGEXPORT jboolean JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btPolyhedralConvexShape_1initializePolyhedralFeatures_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  jboolean jresult = 0 ;
  btPolyhedralConvexShape *arg1 = (btPolyhedralConvexShape *) 0 ;
  int arg2 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btPolyhedralConvexShape **)&jarg1; 
  arg2 = (int)jarg2; 
  result = (bool)(arg1)->initializePolyhedralFeatures(arg2);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btPolyhedralConvexShape_1initializePolyhedralFeatures_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  btPolyhedralConvexShape *arg1 = (btPolyhedralConvexShape *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btPolyhedralConvexShape **)&jarg1; 
  result = (bool)(arg1)->initializePolyhedralFeatures();
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btPolyhedralConvexShape_1getConvexPolyhedron(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btPolyhedralConvexShape *arg1 = (btPolyhedralConvexShape *) 0 ;
  btConvexPolyhedron *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btPolyhedralConvexShape **)&jarg1; 
  result = (btConvexPolyhedron *)((btPolyhedralConvexShape const *)arg1)->getConvexPolyhedron();
  *(btConvexPolyhedron **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btPolyhedralConvexShape_1getNumVertices(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  btPolyhedralConvexShape *arg1 = (btPolyhedralConvexShape *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btPolyhedralConvexShape **)&jarg1; 
  result = (int)((btPolyhedralConvexShape const *)arg1)->getNumVertices();
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btPolyhedralConvexShape_1getNumEdges(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  btPolyhedralConvexShape *arg1 = (btPolyhedralConvexShape *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btPolyhedralConvexShape **)&jarg1; 
  result = (int)((btPolyhedralConvexShape const *)arg1)->getNumEdges();
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btPolyhedralConvexShape_1getEdge(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jobject jarg3, jobject jarg4) {
  btPolyhedralConvexShape *arg1 = (btPolyhedralConvexShape *) 0 ;
  int arg2 ;
  btVector3 *arg3 = 0 ;
  btVector3 *arg4 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btPolyhedralConvexShape **)&jarg1; 
  arg2 = (int)jarg2; 
  btVector3 local_arg3;
  gdx_setbtVector3FromVector3(jenv, local_arg3, jarg3);
  arg3 = &local_arg3;
  gdxAutoCommitVector3 auto_commit_arg3(jenv, jarg3, &local_arg3);
  btVector3 local_arg4;
  gdx_setbtVector3FromVector3(jenv, local_arg4, jarg4);
  arg4 = &local_arg4;
  gdxAutoCommitVector3 auto_commit_arg4(jenv, jarg4, &local_arg4);
  ((btPolyhedralConvexShape const *)arg1)->getEdge(arg2,*arg3,*arg4);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btPolyhedralConvexShape_1getVertex(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jobject jarg3) {
  btPolyhedralConvexShape *arg1 = (btPolyhedralConvexShape *) 0 ;
  int arg2 ;
  btVector3 *arg3 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btPolyhedralConvexShape **)&jarg1; 
  arg2 = (int)jarg2; 
  btVector3 local_arg3;
  gdx_setbtVector3FromVector3(jenv, local_arg3, jarg3);
  arg3 = &local_arg3;
  gdxAutoCommitVector3 auto_commit_arg3(jenv, jarg3, &local_arg3);
  ((btPolyhedralConvexShape const *)arg1)->getVertex(arg2,*arg3);
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btPolyhedralConvexShape_1getNumPlanes(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  btPolyhedralConvexShape *arg1 = (btPolyhedralConvexShape *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btPolyhedralConvexShape **)&jarg1; 
  result = (int)((btPolyhedralConvexShape const *)arg1)->getNumPlanes();
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btPolyhedralConvexShape_1getPlane(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2, jobject jarg3, jint jarg4) {
  btPolyhedralConvexShape *arg1 = (btPolyhedralConvexShape *) 0 ;
  btVector3 *arg2 = 0 ;
  btVector3 *arg3 = 0 ;
  int arg4 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btPolyhedralConvexShape **)&jarg1; 
  btVector3 local_arg2;
  gdx_setbtVector3FromVector3(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitVector3 auto_commit_arg2(jenv, jarg2, &local_arg2);
  btVector3 local_arg3;
  gdx_setbtVector3FromVector3(jenv, local_arg3, jarg3);
  arg3 = &local_arg3;
  gdxAutoCommitVector3 auto_commit_arg3(jenv, jarg3, &local_arg3);
  arg4 = (int)jarg4; 
  ((btPolyhedralConvexShape const *)arg1)->getPlane(*arg2,*arg3,arg4);
}


SWIGEXPORT jboolean JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btPolyhedralConvexShape_1isInside(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2, jfloat jarg3) {
  jboolean jresult = 0 ;
  btPolyhedralConvexShape *arg1 = (btPolyhedralConvexShape *) 0 ;
  btVector3 *arg2 = 0 ;
  btScalar arg3 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btPolyhedralConvexShape **)&jarg1; 
  btVector3 local_arg2;
  gdx_setbtVector3FromVector3(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitVector3 auto_commit_arg2(jenv, jarg2, &local_arg2);
  arg3 = (btScalar)jarg3; 
  result = (bool)((btPolyhedralConvexShape const *)arg1)->isInside((btVector3 const &)*arg2,arg3);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btPolyhedralConvexAabbCachingShape_1getNonvirtualAabb(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2, jobject jarg3, jobject jarg4, jfloat jarg5) {
  btPolyhedralConvexAabbCachingShape *arg1 = (btPolyhedralConvexAabbCachingShape *) 0 ;
  btTransform *arg2 = 0 ;
  btVector3 *arg3 = 0 ;
  btVector3 *arg4 = 0 ;
  btScalar arg5 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btPolyhedralConvexAabbCachingShape **)&jarg1; 
  btTransform local_arg2;
  gdx_setbtTransformFromMatrix4(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitMatrix4 auto_commit_arg2(jenv, jarg2, &local_arg2);
  btVector3 local_arg3;
  gdx_setbtVector3FromVector3(jenv, local_arg3, jarg3);
  arg3 = &local_arg3;
  gdxAutoCommitVector3 auto_commit_arg3(jenv, jarg3, &local_arg3);
  btVector3 local_arg4;
  gdx_setbtVector3FromVector3(jenv, local_arg4, jarg4);
  arg4 = &local_arg4;
  gdxAutoCommitVector3 auto_commit_arg4(jenv, jarg4, &local_arg4);
  arg5 = (btScalar)jarg5; 
  ((btPolyhedralConvexAabbCachingShape const *)arg1)->getNonvirtualAabb((btTransform const &)*arg2,*arg3,*arg4,arg5);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btPolyhedralConvexAabbCachingShape_1recalcLocalAabb(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  btPolyhedralConvexAabbCachingShape *arg1 = (btPolyhedralConvexAabbCachingShape *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btPolyhedralConvexAabbCachingShape **)&jarg1; 
  (arg1)->recalcLocalAabb();
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_delete_1btPolyhedralConvexAabbCachingShape(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  btPolyhedralConvexAabbCachingShape *arg1 = (btPolyhedralConvexAabbCachingShape *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(btPolyhedralConvexAabbCachingShape **)&jarg1; 
  delete arg1;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_delete_1btConcaveShape(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  btConcaveShape *arg1 = (btConcaveShape *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(btConcaveShape **)&jarg1; 
  delete arg1;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btConcaveShape_1processAllTriangles(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jobject jarg3, jobject jarg4) {
  btConcaveShape *arg1 = (btConcaveShape *) 0 ;
  btTriangleCallback *arg2 = (btTriangleCallback *) 0 ;
  btVector3 *arg3 = 0 ;
  btVector3 *arg4 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btConcaveShape **)&jarg1; 
  arg2 = *(btTriangleCallback **)&jarg2; 
  btVector3 local_arg3;
  gdx_setbtVector3FromVector3(jenv, local_arg3, jarg3);
  arg3 = &local_arg3;
  gdxAutoCommitVector3 auto_commit_arg3(jenv, jarg3, &local_arg3);
  btVector3 local_arg4;
  gdx_setbtVector3FromVector3(jenv, local_arg4, jarg4);
  arg4 = &local_arg4;
  gdxAutoCommitVector3 auto_commit_arg4(jenv, jarg4, &local_arg4);
  ((btConcaveShape const *)arg1)->processAllTriangles(arg2,(btVector3 const &)*arg3,(btVector3 const &)*arg4);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_delete_1btTriangleCallback(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  btTriangleCallback *arg1 = (btTriangleCallback *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(btTriangleCallback **)&jarg1; 
  delete arg1;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btTriangleCallback_1processTriangle(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jint jarg3, jint jarg4) {
  btTriangleCallback *arg1 = (btTriangleCallback *) 0 ;
  btVector3 *arg2 = (btVector3 *) 0 ;
  int arg3 ;
  int arg4 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btTriangleCallback **)&jarg1; 
  arg2 = *(btVector3 **)&jarg2; 
  arg3 = (int)jarg3; 
  arg4 = (int)jarg4; 
  (arg1)->processTriangle(arg2,arg3,arg4);
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_new_1btTriangleCallback(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  btTriangleCallback *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (btTriangleCallback *)new SwigDirector_btTriangleCallback(jenv);
  *(btTriangleCallback **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btTriangleCallback_1director_1connect(JNIEnv *jenv, jclass jcls, jobject jself, jlong objarg, jboolean jswig_mem_own, jboolean jweak_global) {
  btTriangleCallback *obj = *((btTriangleCallback **)&objarg);
  (void)jcls;
  SwigDirector_btTriangleCallback *director = (SwigDirector_btTriangleCallback *)(obj);
  if (director) {
    director->swig_connect_director(jenv, jself, jenv->GetObjectClass(jself), (jswig_mem_own == JNI_TRUE), (jweak_global == JNI_TRUE));
  }
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btTriangleCallback_1change_1ownership(JNIEnv *jenv, jclass jcls, jobject jself, jlong objarg, jboolean jtake_or_release) {
  btTriangleCallback *obj = *((btTriangleCallback **)&objarg);
  SwigDirector_btTriangleCallback *director = (SwigDirector_btTriangleCallback *)(obj);
  (void)jcls;
  if (director) {
    director->swig_java_change_ownership(jenv, jself, jtake_or_release ? true : false);
  }
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_delete_1btInternalTriangleIndexCallback(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  btInternalTriangleIndexCallback *arg1 = (btInternalTriangleIndexCallback *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(btInternalTriangleIndexCallback **)&jarg1; 
  delete arg1;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btInternalTriangleIndexCallback_1internalProcessTriangleIndex(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jint jarg3, jint jarg4) {
  btInternalTriangleIndexCallback *arg1 = (btInternalTriangleIndexCallback *) 0 ;
  btVector3 *arg2 = (btVector3 *) 0 ;
  int arg3 ;
  int arg4 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btInternalTriangleIndexCallback **)&jarg1; 
  arg2 = *(btVector3 **)&jarg2; 
  arg3 = (int)jarg3; 
  arg4 = (int)jarg4; 
  (arg1)->internalProcessTriangleIndex(arg2,arg3,arg4);
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_new_1btInternalTriangleIndexCallback(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  btInternalTriangleIndexCallback *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (btInternalTriangleIndexCallback *)new SwigDirector_btInternalTriangleIndexCallback(jenv);
  *(btInternalTriangleIndexCallback **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btInternalTriangleIndexCallback_1director_1connect(JNIEnv *jenv, jclass jcls, jobject jself, jlong objarg, jboolean jswig_mem_own, jboolean jweak_global) {
  btInternalTriangleIndexCallback *obj = *((btInternalTriangleIndexCallback **)&objarg);
  (void)jcls;
  SwigDirector_btInternalTriangleIndexCallback *director = (SwigDirector_btInternalTriangleIndexCallback *)(obj);
  if (director) {
    director->swig_connect_director(jenv, jself, jenv->GetObjectClass(jself), (jswig_mem_own == JNI_TRUE), (jweak_global == JNI_TRUE));
  }
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btInternalTriangleIndexCallback_1change_1ownership(JNIEnv *jenv, jclass jcls, jobject jself, jlong objarg, jboolean jtake_or_release) {
  btInternalTriangleIndexCallback *obj = *((btInternalTriangleIndexCallback **)&objarg);
  SwigDirector_btInternalTriangleIndexCallback *director = (SwigDirector_btInternalTriangleIndexCallback *)(obj);
  (void)jcls;
  if (director) {
    director->swig_java_change_ownership(jenv, jself, jtake_or_release ? true : false);
  }
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_new_1btTriangleInfo(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  btTriangleInfo *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (btTriangleInfo *)new btTriangleInfo();
  *(btTriangleInfo **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btTriangleInfo_1flags_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  btTriangleInfo *arg1 = (btTriangleInfo *) 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btTriangleInfo **)&jarg1; 
  arg2 = (int)jarg2; 
  if (arg1) (arg1)->m_flags = arg2;
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btTriangleInfo_1flags_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  btTriangleInfo *arg1 = (btTriangleInfo *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btTriangleInfo **)&jarg1; 
  result = (int) ((arg1)->m_flags);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btTriangleInfo_1edgeV0V1Angle_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2) {
  btTriangleInfo *arg1 = (btTriangleInfo *) 0 ;
  btScalar arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btTriangleInfo **)&jarg1; 
  arg2 = (btScalar)jarg2; 
  if (arg1) (arg1)->m_edgeV0V1Angle = arg2;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btTriangleInfo_1edgeV0V1Angle_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jfloat jresult = 0 ;
  btTriangleInfo *arg1 = (btTriangleInfo *) 0 ;
  btScalar result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btTriangleInfo **)&jarg1; 
  result = (btScalar) ((arg1)->m_edgeV0V1Angle);
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btTriangleInfo_1edgeV1V2Angle_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2) {
  btTriangleInfo *arg1 = (btTriangleInfo *) 0 ;
  btScalar arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btTriangleInfo **)&jarg1; 
  arg2 = (btScalar)jarg2; 
  if (arg1) (arg1)->m_edgeV1V2Angle = arg2;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btTriangleInfo_1edgeV1V2Angle_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jfloat jresult = 0 ;
  btTriangleInfo *arg1 = (btTriangleInfo *) 0 ;
  btScalar result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btTriangleInfo **)&jarg1; 
  result = (btScalar) ((arg1)->m_edgeV1V2Angle);
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btTriangleInfo_1edgeV2V0Angle_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2) {
  btTriangleInfo *arg1 = (btTriangleInfo *) 0 ;
  btScalar arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btTriangleInfo **)&jarg1; 
  arg2 = (btScalar)jarg2; 
  if (arg1) (arg1)->m_edgeV2V0Angle = arg2;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btTriangleInfo_1edgeV2V0Angle_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jfloat jresult = 0 ;
  btTriangleInfo *arg1 = (btTriangleInfo *) 0 ;
  btScalar result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btTriangleInfo **)&jarg1; 
  result = (btScalar) ((arg1)->m_edgeV2V0Angle);
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_delete_1btTriangleInfo(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  btTriangleInfo *arg1 = (btTriangleInfo *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(btTriangleInfo **)&jarg1; 
  delete arg1;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btTriangleInfoMap_1convexEpsilon_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2) {
  btTriangleInfoMap *arg1 = (btTriangleInfoMap *) 0 ;
  btScalar arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btTriangleInfoMap **)&jarg1; 
  arg2 = (btScalar)jarg2; 
  if (arg1) (arg1)->m_convexEpsilon = arg2;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btTriangleInfoMap_1convexEpsilon_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jfloat jresult = 0 ;
  btTriangleInfoMap *arg1 = (btTriangleInfoMap *) 0 ;
  btScalar result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btTriangleInfoMap **)&jarg1; 
  result = (btScalar) ((arg1)->m_convexEpsilon);
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btTriangleInfoMap_1planarEpsilon_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2) {
  btTriangleInfoMap *arg1 = (btTriangleInfoMap *) 0 ;
  btScalar arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btTriangleInfoMap **)&jarg1; 
  arg2 = (btScalar)jarg2; 
  if (arg1) (arg1)->m_planarEpsilon = arg2;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btTriangleInfoMap_1planarEpsilon_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jfloat jresult = 0 ;
  btTriangleInfoMap *arg1 = (btTriangleInfoMap *) 0 ;
  btScalar result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btTriangleInfoMap **)&jarg1; 
  result = (btScalar) ((arg1)->m_planarEpsilon);
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btTriangleInfoMap_1equalVertexThreshold_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2) {
  btTriangleInfoMap *arg1 = (btTriangleInfoMap *) 0 ;
  btScalar arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btTriangleInfoMap **)&jarg1; 
  arg2 = (btScalar)jarg2; 
  if (arg1) (arg1)->m_equalVertexThreshold = arg2;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btTriangleInfoMap_1equalVertexThreshold_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jfloat jresult = 0 ;
  btTriangleInfoMap *arg1 = (btTriangleInfoMap *) 0 ;
  btScalar result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btTriangleInfoMap **)&jarg1; 
  result = (btScalar) ((arg1)->m_equalVertexThreshold);
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btTriangleInfoMap_1edgeDistanceThreshold_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2) {
  btTriangleInfoMap *arg1 = (btTriangleInfoMap *) 0 ;
  btScalar arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btTriangleInfoMap **)&jarg1; 
  arg2 = (btScalar)jarg2; 
  if (arg1) (arg1)->m_edgeDistanceThreshold = arg2;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btTriangleInfoMap_1edgeDistanceThreshold_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jfloat jresult = 0 ;
  btTriangleInfoMap *arg1 = (btTriangleInfoMap *) 0 ;
  btScalar result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btTriangleInfoMap **)&jarg1; 
  result = (btScalar) ((arg1)->m_edgeDistanceThreshold);
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btTriangleInfoMap_1maxEdgeAngleThreshold_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2) {
  btTriangleInfoMap *arg1 = (btTriangleInfoMap *) 0 ;
  btScalar arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btTriangleInfoMap **)&jarg1; 
  arg2 = (btScalar)jarg2; 
  if (arg1) (arg1)->m_maxEdgeAngleThreshold = arg2;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btTriangleInfoMap_1maxEdgeAngleThreshold_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jfloat jresult = 0 ;
  btTriangleInfoMap *arg1 = (btTriangleInfoMap *) 0 ;
  btScalar result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btTriangleInfoMap **)&jarg1; 
  result = (btScalar) ((arg1)->m_maxEdgeAngleThreshold);
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btTriangleInfoMap_1zeroAreaThreshold_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2) {
  btTriangleInfoMap *arg1 = (btTriangleInfoMap *) 0 ;
  btScalar arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btTriangleInfoMap **)&jarg1; 
  arg2 = (btScalar)jarg2; 
  if (arg1) (arg1)->m_zeroAreaThreshold = arg2;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btTriangleInfoMap_1zeroAreaThreshold_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jfloat jresult = 0 ;
  btTriangleInfoMap *arg1 = (btTriangleInfoMap *) 0 ;
  btScalar result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btTriangleInfoMap **)&jarg1; 
  result = (btScalar) ((arg1)->m_zeroAreaThreshold);
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_new_1btTriangleInfoMap(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  btTriangleInfoMap *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (btTriangleInfoMap *)new btTriangleInfoMap();
  *(btTriangleInfoMap **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_delete_1btTriangleInfoMap(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  btTriangleInfoMap *arg1 = (btTriangleInfoMap *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(btTriangleInfoMap **)&jarg1; 
  delete arg1;
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btTriangleInfoMap_1calculateSerializeBufferSize(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  btTriangleInfoMap *arg1 = (btTriangleInfoMap *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btTriangleInfoMap **)&jarg1; 
  result = (int)((btTriangleInfoMap const *)arg1)->calculateSerializeBufferSize();
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btTriangleInfoMap_1serialize(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jlong jarg3) {
  jstring jresult = 0 ;
  btTriangleInfoMap *arg1 = (btTriangleInfoMap *) 0 ;
  void *arg2 = (void *) 0 ;
  btSerializer *arg3 = (btSerializer *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btTriangleInfoMap **)&jarg1; 
  arg2 = (void *)jarg2; 
  arg3 = *(btSerializer **)&jarg3; 
  result = (char *)((btTriangleInfoMap const *)arg1)->serialize(arg2,arg3);
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btTriangleInfoMap_1deSerialize(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btTriangleInfoMap *arg1 = (btTriangleInfoMap *) 0 ;
  btTriangleInfoMapData *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btTriangleInfoMap **)&jarg1; 
  arg2 = *(btTriangleInfoMapData **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btTriangleInfoMapData & reference is null");
    return ;
  } 
  (arg1)->deSerialize(*arg2);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btTriangleInfoData_1flags_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  btTriangleInfoData *arg1 = (btTriangleInfoData *) 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btTriangleInfoData **)&jarg1; 
  arg2 = (int)jarg2; 
  if (arg1) (arg1)->m_flags = arg2;
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btTriangleInfoData_1flags_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  btTriangleInfoData *arg1 = (btTriangleInfoData *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btTriangleInfoData **)&jarg1; 
  result = (int) ((arg1)->m_flags);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btTriangleInfoData_1edgeV0V1Angle_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2) {
  btTriangleInfoData *arg1 = (btTriangleInfoData *) 0 ;
  float arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btTriangleInfoData **)&jarg1; 
  arg2 = (float)jarg2; 
  if (arg1) (arg1)->m_edgeV0V1Angle = arg2;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btTriangleInfoData_1edgeV0V1Angle_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jfloat jresult = 0 ;
  btTriangleInfoData *arg1 = (btTriangleInfoData *) 0 ;
  float result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btTriangleInfoData **)&jarg1; 
  result = (float) ((arg1)->m_edgeV0V1Angle);
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btTriangleInfoData_1edgeV1V2Angle_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2) {
  btTriangleInfoData *arg1 = (btTriangleInfoData *) 0 ;
  float arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btTriangleInfoData **)&jarg1; 
  arg2 = (float)jarg2; 
  if (arg1) (arg1)->m_edgeV1V2Angle = arg2;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btTriangleInfoData_1edgeV1V2Angle_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jfloat jresult = 0 ;
  btTriangleInfoData *arg1 = (btTriangleInfoData *) 0 ;
  float result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btTriangleInfoData **)&jarg1; 
  result = (float) ((arg1)->m_edgeV1V2Angle);
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btTriangleInfoData_1edgeV2V0Angle_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2) {
  btTriangleInfoData *arg1 = (btTriangleInfoData *) 0 ;
  float arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btTriangleInfoData **)&jarg1; 
  arg2 = (float)jarg2; 
  if (arg1) (arg1)->m_edgeV2V0Angle = arg2;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btTriangleInfoData_1edgeV2V0Angle_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jfloat jresult = 0 ;
  btTriangleInfoData *arg1 = (btTriangleInfoData *) 0 ;
  float result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btTriangleInfoData **)&jarg1; 
  result = (float) ((arg1)->m_edgeV2V0Angle);
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_new_1btTriangleInfoData(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  btTriangleInfoData *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (btTriangleInfoData *)new btTriangleInfoData();
  *(btTriangleInfoData **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_delete_1btTriangleInfoData(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  btTriangleInfoData *arg1 = (btTriangleInfoData *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(btTriangleInfoData **)&jarg1; 
  delete arg1;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btTriangleInfoMapData_1hashTablePtr_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2) {
  btTriangleInfoMapData *arg1 = (btTriangleInfoMapData *) 0 ;
  int *arg2 = (int *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btTriangleInfoMapData **)&jarg1; 
  {
    arg2 = (int*)jenv->GetDirectBufferAddress(jarg2);
    if (arg2 == NULL) {
      SWIG_JavaThrowException(jenv, SWIG_JavaRuntimeException, "Unable to get address of direct buffer. Buffer must be allocated direct.");
    }
  }
  {
    if (arg2) {
      arg1->m_hashTablePtr = arg2;
    } else {
      arg1->m_hashTablePtr = 0;
    }
  }
  
}


SWIGEXPORT jobject JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btTriangleInfoMapData_1hashTablePtr_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jobject jresult = 0 ;
  btTriangleInfoMapData *arg1 = (btTriangleInfoMapData *) 0 ;
  int *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btTriangleInfoMapData **)&jarg1; 
  result = (int *) ((arg1)->m_hashTablePtr);
  *(int **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btTriangleInfoMapData_1nextPtr_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2) {
  btTriangleInfoMapData *arg1 = (btTriangleInfoMapData *) 0 ;
  int *arg2 = (int *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btTriangleInfoMapData **)&jarg1; 
  {
    arg2 = (int*)jenv->GetDirectBufferAddress(jarg2);
    if (arg2 == NULL) {
      SWIG_JavaThrowException(jenv, SWIG_JavaRuntimeException, "Unable to get address of direct buffer. Buffer must be allocated direct.");
    }
  }
  {
    if (arg2) {
      arg1->m_nextPtr = arg2;
    } else {
      arg1->m_nextPtr = 0;
    }
  }
  
}


SWIGEXPORT jobject JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btTriangleInfoMapData_1nextPtr_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jobject jresult = 0 ;
  btTriangleInfoMapData *arg1 = (btTriangleInfoMapData *) 0 ;
  int *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btTriangleInfoMapData **)&jarg1; 
  result = (int *) ((arg1)->m_nextPtr);
  *(int **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btTriangleInfoMapData_1valueArrayPtr_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btTriangleInfoMapData *arg1 = (btTriangleInfoMapData *) 0 ;
  btTriangleInfoData *arg2 = (btTriangleInfoData *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btTriangleInfoMapData **)&jarg1; 
  arg2 = *(btTriangleInfoData **)&jarg2; 
  if (arg1) (arg1)->m_valueArrayPtr = arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btTriangleInfoMapData_1valueArrayPtr_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btTriangleInfoMapData *arg1 = (btTriangleInfoMapData *) 0 ;
  btTriangleInfoData *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btTriangleInfoMapData **)&jarg1; 
  result = (btTriangleInfoData *) ((arg1)->m_valueArrayPtr);
  *(btTriangleInfoData **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btTriangleInfoMapData_1keyArrayPtr_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2) {
  btTriangleInfoMapData *arg1 = (btTriangleInfoMapData *) 0 ;
  int *arg2 = (int *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btTriangleInfoMapData **)&jarg1; 
  {
    arg2 = (int*)jenv->GetDirectBufferAddress(jarg2);
    if (arg2 == NULL) {
      SWIG_JavaThrowException(jenv, SWIG_JavaRuntimeException, "Unable to get address of direct buffer. Buffer must be allocated direct.");
    }
  }
  {
    if (arg2) {
      arg1->m_keyArrayPtr = arg2;
    } else {
      arg1->m_keyArrayPtr = 0;
    }
  }
  
}


SWIGEXPORT jobject JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btTriangleInfoMapData_1keyArrayPtr_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jobject jresult = 0 ;
  btTriangleInfoMapData *arg1 = (btTriangleInfoMapData *) 0 ;
  int *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btTriangleInfoMapData **)&jarg1; 
  result = (int *) ((arg1)->m_keyArrayPtr);
  *(int **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btTriangleInfoMapData_1convexEpsilon_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2) {
  btTriangleInfoMapData *arg1 = (btTriangleInfoMapData *) 0 ;
  float arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btTriangleInfoMapData **)&jarg1; 
  arg2 = (float)jarg2; 
  if (arg1) (arg1)->m_convexEpsilon = arg2;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btTriangleInfoMapData_1convexEpsilon_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jfloat jresult = 0 ;
  btTriangleInfoMapData *arg1 = (btTriangleInfoMapData *) 0 ;
  float result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btTriangleInfoMapData **)&jarg1; 
  result = (float) ((arg1)->m_convexEpsilon);
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btTriangleInfoMapData_1planarEpsilon_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2) {
  btTriangleInfoMapData *arg1 = (btTriangleInfoMapData *) 0 ;
  float arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btTriangleInfoMapData **)&jarg1; 
  arg2 = (float)jarg2; 
  if (arg1) (arg1)->m_planarEpsilon = arg2;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btTriangleInfoMapData_1planarEpsilon_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jfloat jresult = 0 ;
  btTriangleInfoMapData *arg1 = (btTriangleInfoMapData *) 0 ;
  float result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btTriangleInfoMapData **)&jarg1; 
  result = (float) ((arg1)->m_planarEpsilon);
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btTriangleInfoMapData_1equalVertexThreshold_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2) {
  btTriangleInfoMapData *arg1 = (btTriangleInfoMapData *) 0 ;
  float arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btTriangleInfoMapData **)&jarg1; 
  arg2 = (float)jarg2; 
  if (arg1) (arg1)->m_equalVertexThreshold = arg2;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btTriangleInfoMapData_1equalVertexThreshold_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jfloat jresult = 0 ;
  btTriangleInfoMapData *arg1 = (btTriangleInfoMapData *) 0 ;
  float result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btTriangleInfoMapData **)&jarg1; 
  result = (float) ((arg1)->m_equalVertexThreshold);
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btTriangleInfoMapData_1edgeDistanceThreshold_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2) {
  btTriangleInfoMapData *arg1 = (btTriangleInfoMapData *) 0 ;
  float arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btTriangleInfoMapData **)&jarg1; 
  arg2 = (float)jarg2; 
  if (arg1) (arg1)->m_edgeDistanceThreshold = arg2;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btTriangleInfoMapData_1edgeDistanceThreshold_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jfloat jresult = 0 ;
  btTriangleInfoMapData *arg1 = (btTriangleInfoMapData *) 0 ;
  float result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btTriangleInfoMapData **)&jarg1; 
  result = (float) ((arg1)->m_edgeDistanceThreshold);
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btTriangleInfoMapData_1zeroAreaThreshold_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2) {
  btTriangleInfoMapData *arg1 = (btTriangleInfoMapData *) 0 ;
  float arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btTriangleInfoMapData **)&jarg1; 
  arg2 = (float)jarg2; 
  if (arg1) (arg1)->m_zeroAreaThreshold = arg2;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btTriangleInfoMapData_1zeroAreaThreshold_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jfloat jresult = 0 ;
  btTriangleInfoMapData *arg1 = (btTriangleInfoMapData *) 0 ;
  float result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btTriangleInfoMapData **)&jarg1; 
  result = (float) ((arg1)->m_zeroAreaThreshold);
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btTriangleInfoMapData_1nextSize_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  btTriangleInfoMapData *arg1 = (btTriangleInfoMapData *) 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btTriangleInfoMapData **)&jarg1; 
  arg2 = (int)jarg2; 
  if (arg1) (arg1)->m_nextSize = arg2;
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btTriangleInfoMapData_1nextSize_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  btTriangleInfoMapData *arg1 = (btTriangleInfoMapData *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btTriangleInfoMapData **)&jarg1; 
  result = (int) ((arg1)->m_nextSize);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btTriangleInfoMapData_1hashTableSize_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  btTriangleInfoMapData *arg1 = (btTriangleInfoMapData *) 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btTriangleInfoMapData **)&jarg1; 
  arg2 = (int)jarg2; 
  if (arg1) (arg1)->m_hashTableSize = arg2;
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btTriangleInfoMapData_1hashTableSize_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  btTriangleInfoMapData *arg1 = (btTriangleInfoMapData *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btTriangleInfoMapData **)&jarg1; 
  result = (int) ((arg1)->m_hashTableSize);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btTriangleInfoMapData_1numValues_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  btTriangleInfoMapData *arg1 = (btTriangleInfoMapData *) 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btTriangleInfoMapData **)&jarg1; 
  arg2 = (int)jarg2; 
  if (arg1) (arg1)->m_numValues = arg2;
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btTriangleInfoMapData_1numValues_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  btTriangleInfoMapData *arg1 = (btTriangleInfoMapData *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btTriangleInfoMapData **)&jarg1; 
  result = (int) ((arg1)->m_numValues);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btTriangleInfoMapData_1numKeys_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  btTriangleInfoMapData *arg1 = (btTriangleInfoMapData *) 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btTriangleInfoMapData **)&jarg1; 
  arg2 = (int)jarg2; 
  if (arg1) (arg1)->m_numKeys = arg2;
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btTriangleInfoMapData_1numKeys_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  btTriangleInfoMapData *arg1 = (btTriangleInfoMapData *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btTriangleInfoMapData **)&jarg1; 
  result = (int) ((arg1)->m_numKeys);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btTriangleInfoMapData_1padding_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  btTriangleInfoMapData *arg1 = (btTriangleInfoMapData *) 0 ;
  char *arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btTriangleInfoMapData **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return ;
  }
  {
    if(arg2) {
      strncpy((char*)arg1->m_padding, (const char *)arg2, 4-1);
      arg1->m_padding[4-1] = 0;
    } else {
      arg1->m_padding[0] = 0;
    }
  }
  
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
}


SWIGEXPORT jstring JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btTriangleInfoMapData_1padding_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  btTriangleInfoMapData *arg1 = (btTriangleInfoMapData *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btTriangleInfoMapData **)&jarg1; 
  result = (char *)(char *) ((arg1)->m_padding);
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_new_1btTriangleInfoMapData(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  btTriangleInfoMapData *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (btTriangleInfoMapData *)new btTriangleInfoMapData();
  *(btTriangleInfoMapData **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_delete_1btTriangleInfoMapData(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  btTriangleInfoMapData *arg1 = (btTriangleInfoMapData *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(btTriangleInfoMapData **)&jarg1; 
  delete arg1;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_new_1btStaticPlaneShape(JNIEnv *jenv, jclass jcls, jobject jarg1, jfloat jarg2) {
  jlong jresult = 0 ;
  btVector3 *arg1 = 0 ;
  btScalar arg2 ;
  btStaticPlaneShape *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  btVector3 local_arg1;
  gdx_setbtVector3FromVector3(jenv, local_arg1, jarg1);
  arg1 = &local_arg1;
  gdxAutoCommitVector3 auto_commit_arg1(jenv, jarg1, &local_arg1);
  arg2 = (btScalar)jarg2; 
  result = (btStaticPlaneShape *)new btStaticPlaneShape((btVector3 const &)*arg1,arg2);
  *(btStaticPlaneShape **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_delete_1btStaticPlaneShape(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  btStaticPlaneShape *arg1 = (btStaticPlaneShape *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(btStaticPlaneShape **)&jarg1; 
  delete arg1;
}


SWIGEXPORT jobject JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btStaticPlaneShape_1getPlaneNormal(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jobject jresult = 0 ;
  btStaticPlaneShape *arg1 = (btStaticPlaneShape *) 0 ;
  btVector3 *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btStaticPlaneShape **)&jarg1; 
  result = (btVector3 *) &((btStaticPlaneShape const *)arg1)->getPlaneNormal();
  jresult = gdx_getReturnVector3(jenv);
  gdx_setVector3FrombtVector3(jenv, jresult, result);
  return jresult;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btStaticPlaneShape_1getPlaneConstant(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jfloat jresult = 0 ;
  btStaticPlaneShape *arg1 = (btStaticPlaneShape *) 0 ;
  btScalar *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btStaticPlaneShape **)&jarg1; 
  result = (btScalar *) &((btStaticPlaneShape const *)arg1)->getPlaneConstant();
  jresult = (jfloat)*result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btStaticPlaneShapeData_1collisionShapeData_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btStaticPlaneShapeData *arg1 = (btStaticPlaneShapeData *) 0 ;
  btCollisionShapeData *arg2 = (btCollisionShapeData *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btStaticPlaneShapeData **)&jarg1; 
  arg2 = *(btCollisionShapeData **)&jarg2; 
  if (arg1) (arg1)->m_collisionShapeData = *arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btStaticPlaneShapeData_1collisionShapeData_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btStaticPlaneShapeData *arg1 = (btStaticPlaneShapeData *) 0 ;
  btCollisionShapeData *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btStaticPlaneShapeData **)&jarg1; 
  result = (btCollisionShapeData *)& ((arg1)->m_collisionShapeData);
  *(btCollisionShapeData **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btStaticPlaneShapeData_1localScaling_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btStaticPlaneShapeData *arg1 = (btStaticPlaneShapeData *) 0 ;
  btVector3FloatData *arg2 = (btVector3FloatData *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btStaticPlaneShapeData **)&jarg1; 
  arg2 = *(btVector3FloatData **)&jarg2; 
  if (arg1) (arg1)->m_localScaling = *arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btStaticPlaneShapeData_1localScaling_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btStaticPlaneShapeData *arg1 = (btStaticPlaneShapeData *) 0 ;
  btVector3FloatData *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btStaticPlaneShapeData **)&jarg1; 
  result = (btVector3FloatData *)& ((arg1)->m_localScaling);
  *(btVector3FloatData **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btStaticPlaneShapeData_1planeNormal_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btStaticPlaneShapeData *arg1 = (btStaticPlaneShapeData *) 0 ;
  btVector3FloatData *arg2 = (btVector3FloatData *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btStaticPlaneShapeData **)&jarg1; 
  arg2 = *(btVector3FloatData **)&jarg2; 
  if (arg1) (arg1)->m_planeNormal = *arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btStaticPlaneShapeData_1planeNormal_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btStaticPlaneShapeData *arg1 = (btStaticPlaneShapeData *) 0 ;
  btVector3FloatData *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btStaticPlaneShapeData **)&jarg1; 
  result = (btVector3FloatData *)& ((arg1)->m_planeNormal);
  *(btVector3FloatData **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btStaticPlaneShapeData_1planeConstant_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2) {
  btStaticPlaneShapeData *arg1 = (btStaticPlaneShapeData *) 0 ;
  float arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btStaticPlaneShapeData **)&jarg1; 
  arg2 = (float)jarg2; 
  if (arg1) (arg1)->m_planeConstant = arg2;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btStaticPlaneShapeData_1planeConstant_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jfloat jresult = 0 ;
  btStaticPlaneShapeData *arg1 = (btStaticPlaneShapeData *) 0 ;
  float result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btStaticPlaneShapeData **)&jarg1; 
  result = (float) ((arg1)->m_planeConstant);
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btStaticPlaneShapeData_1pad_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  btStaticPlaneShapeData *arg1 = (btStaticPlaneShapeData *) 0 ;
  char *arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btStaticPlaneShapeData **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return ;
  }
  {
    if(arg2) {
      strncpy((char*)arg1->m_pad, (const char *)arg2, 4-1);
      arg1->m_pad[4-1] = 0;
    } else {
      arg1->m_pad[0] = 0;
    }
  }
  
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
}


SWIGEXPORT jstring JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btStaticPlaneShapeData_1pad_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  btStaticPlaneShapeData *arg1 = (btStaticPlaneShapeData *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btStaticPlaneShapeData **)&jarg1; 
  result = (char *)(char *) ((arg1)->m_pad);
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_new_1btStaticPlaneShapeData(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  btStaticPlaneShapeData *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (btStaticPlaneShapeData *)new btStaticPlaneShapeData();
  *(btStaticPlaneShapeData **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_delete_1btStaticPlaneShapeData(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  btStaticPlaneShapeData *arg1 = (btStaticPlaneShapeData *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(btStaticPlaneShapeData **)&jarg1; 
  delete arg1;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_delete_1btHeightfieldTerrainShape(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  btHeightfieldTerrainShape *arg1 = (btHeightfieldTerrainShape *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(btHeightfieldTerrainShape **)&jarg1; 
  delete arg1;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btHeightfieldTerrainShape_1setUseDiamondSubdivision_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jboolean jarg2) {
  btHeightfieldTerrainShape *arg1 = (btHeightfieldTerrainShape *) 0 ;
  bool arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btHeightfieldTerrainShape **)&jarg1; 
  arg2 = jarg2 ? true : false; 
  (arg1)->setUseDiamondSubdivision(arg2);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btHeightfieldTerrainShape_1setUseDiamondSubdivision_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  btHeightfieldTerrainShape *arg1 = (btHeightfieldTerrainShape *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btHeightfieldTerrainShape **)&jarg1; 
  (arg1)->setUseDiamondSubdivision();
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btHeightfieldTerrainShape_1setUseZigzagSubdivision_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jboolean jarg2) {
  btHeightfieldTerrainShape *arg1 = (btHeightfieldTerrainShape *) 0 ;
  bool arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btHeightfieldTerrainShape **)&jarg1; 
  arg2 = jarg2 ? true : false; 
  (arg1)->setUseZigzagSubdivision(arg2);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btHeightfieldTerrainShape_1setUseZigzagSubdivision_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  btHeightfieldTerrainShape *arg1 = (btHeightfieldTerrainShape *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btHeightfieldTerrainShape **)&jarg1; 
  (arg1)->setUseZigzagSubdivision();
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_new_1btHeightfieldTerrainShape_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jint jarg1, jint jarg2, jobject jarg3, jfloat jarg4, jfloat jarg5, jfloat jarg6, jint jarg7, jboolean jarg8) {
  jlong jresult = 0 ;
  int arg1 ;
  int arg2 ;
  float *arg3 = (float *) 0 ;
  btScalar arg4 ;
  btScalar arg5 ;
  btScalar arg6 ;
  int arg7 ;
  bool arg8 ;
  btHeightfieldTerrainShape *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (int)jarg1; 
  arg2 = (int)jarg2; 
  {
    arg3 = (float*)jenv->GetDirectBufferAddress(jarg3);
    if (arg3 == NULL) {
      SWIG_JavaThrowException(jenv, SWIG_JavaRuntimeException, "Unable to get address of direct buffer. Buffer must be allocated direct.");
    }
  }
  arg4 = (btScalar)jarg4; 
  arg5 = (btScalar)jarg5; 
  arg6 = (btScalar)jarg6; 
  arg7 = (int)jarg7; 
  arg8 = jarg8 ? true : false; 
  result = (btHeightfieldTerrainShape *)new_btHeightfieldTerrainShape__SWIG_0(arg1,arg2,(float const *)arg3,arg4,arg5,arg6,arg7,arg8);
  *(btHeightfieldTerrainShape **)&jresult = result; 
  
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_new_1btHeightfieldTerrainShape_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jint jarg1, jint jarg2, jobject jarg3, jfloat jarg4, jfloat jarg5, jfloat jarg6, jint jarg7, jboolean jarg8) {
  jlong jresult = 0 ;
  int arg1 ;
  int arg2 ;
  short *arg3 = (short *) 0 ;
  btScalar arg4 ;
  btScalar arg5 ;
  btScalar arg6 ;
  int arg7 ;
  bool arg8 ;
  btHeightfieldTerrainShape *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (int)jarg1; 
  arg2 = (int)jarg2; 
  {
    arg3 = (short*)jenv->GetDirectBufferAddress(jarg3);
    if (arg3 == NULL) {
      SWIG_JavaThrowException(jenv, SWIG_JavaRuntimeException, "Unable to get address of direct buffer. Buffer must be allocated direct.");
    }
  }
  arg4 = (btScalar)jarg4; 
  arg5 = (btScalar)jarg5; 
  arg6 = (btScalar)jarg6; 
  arg7 = (int)jarg7; 
  arg8 = jarg8 ? true : false; 
  result = (btHeightfieldTerrainShape *)new_btHeightfieldTerrainShape__SWIG_1(arg1,arg2,(short const *)arg3,arg4,arg5,arg6,arg7,arg8);
  *(btHeightfieldTerrainShape **)&jresult = result; 
  
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_delete_1btTriangleMeshShape(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  btTriangleMeshShape *arg1 = (btTriangleMeshShape *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(btTriangleMeshShape **)&jarg1; 
  delete arg1;
}


SWIGEXPORT jobject JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btTriangleMeshShape_1localGetSupportingVertex(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2) {
  jobject jresult = 0 ;
  btTriangleMeshShape *arg1 = (btTriangleMeshShape *) 0 ;
  btVector3 *arg2 = 0 ;
  btVector3 result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btTriangleMeshShape **)&jarg1; 
  btVector3 local_arg2;
  gdx_setbtVector3FromVector3(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitVector3 auto_commit_arg2(jenv, jarg2, &local_arg2);
  result = ((btTriangleMeshShape const *)arg1)->localGetSupportingVertex((btVector3 const &)*arg2);
  jresult = gdx_getReturnVector3(jenv);
  gdx_setVector3FrombtVector3(jenv, jresult, result);
  return jresult;
}


SWIGEXPORT jobject JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btTriangleMeshShape_1localGetSupportingVertexWithoutMargin(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2) {
  jobject jresult = 0 ;
  btTriangleMeshShape *arg1 = (btTriangleMeshShape *) 0 ;
  btVector3 *arg2 = 0 ;
  btVector3 result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btTriangleMeshShape **)&jarg1; 
  btVector3 local_arg2;
  gdx_setbtVector3FromVector3(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitVector3 auto_commit_arg2(jenv, jarg2, &local_arg2);
  result = ((btTriangleMeshShape const *)arg1)->localGetSupportingVertexWithoutMargin((btVector3 const &)*arg2);
  jresult = gdx_getReturnVector3(jenv);
  gdx_setVector3FrombtVector3(jenv, jresult, result);
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btTriangleMeshShape_1recalcLocalAabb(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  btTriangleMeshShape *arg1 = (btTriangleMeshShape *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btTriangleMeshShape **)&jarg1; 
  (arg1)->recalcLocalAabb();
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btTriangleMeshShape_1getMeshInterface_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btTriangleMeshShape *arg1 = (btTriangleMeshShape *) 0 ;
  btStridingMeshInterface *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btTriangleMeshShape **)&jarg1; 
  result = (btStridingMeshInterface *)(arg1)->getMeshInterface();
  *(btStridingMeshInterface **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jobject JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btTriangleMeshShape_1getLocalAabbMin(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jobject jresult = 0 ;
  btTriangleMeshShape *arg1 = (btTriangleMeshShape *) 0 ;
  btVector3 *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btTriangleMeshShape **)&jarg1; 
  result = (btVector3 *) &((btTriangleMeshShape const *)arg1)->getLocalAabbMin();
  jresult = gdx_getReturnVector3(jenv);
  gdx_setVector3FrombtVector3(jenv, jresult, result);
  return jresult;
}


SWIGEXPORT jobject JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btTriangleMeshShape_1getLocalAabbMax(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jobject jresult = 0 ;
  btTriangleMeshShape *arg1 = (btTriangleMeshShape *) 0 ;
  btVector3 *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btTriangleMeshShape **)&jarg1; 
  result = (btVector3 *) &((btTriangleMeshShape const *)arg1)->getLocalAabbMax();
  jresult = gdx_getReturnVector3(jenv);
  gdx_setVector3FrombtVector3(jenv, jresult, result);
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_delete_1btBvhTriangleMeshShape(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  btBvhTriangleMeshShape *arg1 = (btBvhTriangleMeshShape *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(btBvhTriangleMeshShape **)&jarg1; 
  delete arg1;
}


SWIGEXPORT jboolean JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btBvhTriangleMeshShape_1getOwnsBvh(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  btBvhTriangleMeshShape *arg1 = (btBvhTriangleMeshShape *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btBvhTriangleMeshShape **)&jarg1; 
  result = (bool)((btBvhTriangleMeshShape const *)arg1)->getOwnsBvh();
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btBvhTriangleMeshShape_1performRaycast(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jobject jarg3, jobject jarg4) {
  btBvhTriangleMeshShape *arg1 = (btBvhTriangleMeshShape *) 0 ;
  btTriangleCallback *arg2 = (btTriangleCallback *) 0 ;
  btVector3 *arg3 = 0 ;
  btVector3 *arg4 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btBvhTriangleMeshShape **)&jarg1; 
  arg2 = *(btTriangleCallback **)&jarg2; 
  btVector3 local_arg3;
  gdx_setbtVector3FromVector3(jenv, local_arg3, jarg3);
  arg3 = &local_arg3;
  gdxAutoCommitVector3 auto_commit_arg3(jenv, jarg3, &local_arg3);
  btVector3 local_arg4;
  gdx_setbtVector3FromVector3(jenv, local_arg4, jarg4);
  arg4 = &local_arg4;
  gdxAutoCommitVector3 auto_commit_arg4(jenv, jarg4, &local_arg4);
  (arg1)->performRaycast(arg2,(btVector3 const &)*arg3,(btVector3 const &)*arg4);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btBvhTriangleMeshShape_1performConvexcast(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jobject jarg3, jobject jarg4, jobject jarg5, jobject jarg6) {
  btBvhTriangleMeshShape *arg1 = (btBvhTriangleMeshShape *) 0 ;
  btTriangleCallback *arg2 = (btTriangleCallback *) 0 ;
  btVector3 *arg3 = 0 ;
  btVector3 *arg4 = 0 ;
  btVector3 *arg5 = 0 ;
  btVector3 *arg6 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btBvhTriangleMeshShape **)&jarg1; 
  arg2 = *(btTriangleCallback **)&jarg2; 
  btVector3 local_arg3;
  gdx_setbtVector3FromVector3(jenv, local_arg3, jarg3);
  arg3 = &local_arg3;
  gdxAutoCommitVector3 auto_commit_arg3(jenv, jarg3, &local_arg3);
  btVector3 local_arg4;
  gdx_setbtVector3FromVector3(jenv, local_arg4, jarg4);
  arg4 = &local_arg4;
  gdxAutoCommitVector3 auto_commit_arg4(jenv, jarg4, &local_arg4);
  btVector3 local_arg5;
  gdx_setbtVector3FromVector3(jenv, local_arg5, jarg5);
  arg5 = &local_arg5;
  gdxAutoCommitVector3 auto_commit_arg5(jenv, jarg5, &local_arg5);
  btVector3 local_arg6;
  gdx_setbtVector3FromVector3(jenv, local_arg6, jarg6);
  arg6 = &local_arg6;
  gdxAutoCommitVector3 auto_commit_arg6(jenv, jarg6, &local_arg6);
  (arg1)->performConvexcast(arg2,(btVector3 const &)*arg3,(btVector3 const &)*arg4,(btVector3 const &)*arg5,(btVector3 const &)*arg6);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btBvhTriangleMeshShape_1refitTree(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2, jobject jarg3) {
  btBvhTriangleMeshShape *arg1 = (btBvhTriangleMeshShape *) 0 ;
  btVector3 *arg2 = 0 ;
  btVector3 *arg3 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btBvhTriangleMeshShape **)&jarg1; 
  btVector3 local_arg2;
  gdx_setbtVector3FromVector3(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitVector3 auto_commit_arg2(jenv, jarg2, &local_arg2);
  btVector3 local_arg3;
  gdx_setbtVector3FromVector3(jenv, local_arg3, jarg3);
  arg3 = &local_arg3;
  gdxAutoCommitVector3 auto_commit_arg3(jenv, jarg3, &local_arg3);
  (arg1)->refitTree((btVector3 const &)*arg2,(btVector3 const &)*arg3);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btBvhTriangleMeshShape_1partialRefitTree(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2, jobject jarg3) {
  btBvhTriangleMeshShape *arg1 = (btBvhTriangleMeshShape *) 0 ;
  btVector3 *arg2 = 0 ;
  btVector3 *arg3 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btBvhTriangleMeshShape **)&jarg1; 
  btVector3 local_arg2;
  gdx_setbtVector3FromVector3(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitVector3 auto_commit_arg2(jenv, jarg2, &local_arg2);
  btVector3 local_arg3;
  gdx_setbtVector3FromVector3(jenv, local_arg3, jarg3);
  arg3 = &local_arg3;
  gdxAutoCommitVector3 auto_commit_arg3(jenv, jarg3, &local_arg3);
  (arg1)->partialRefitTree((btVector3 const &)*arg2,(btVector3 const &)*arg3);
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btBvhTriangleMeshShape_1getOptimizedBvh(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btBvhTriangleMeshShape *arg1 = (btBvhTriangleMeshShape *) 0 ;
  btOptimizedBvh *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btBvhTriangleMeshShape **)&jarg1; 
  result = (btOptimizedBvh *)(arg1)->getOptimizedBvh();
  *(btOptimizedBvh **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btBvhTriangleMeshShape_1setOptimizedBvh_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jobject jarg3) {
  btBvhTriangleMeshShape *arg1 = (btBvhTriangleMeshShape *) 0 ;
  btOptimizedBvh *arg2 = (btOptimizedBvh *) 0 ;
  btVector3 *arg3 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btBvhTriangleMeshShape **)&jarg1; 
  arg2 = *(btOptimizedBvh **)&jarg2; 
  btVector3 local_arg3;
  gdx_setbtVector3FromVector3(jenv, local_arg3, jarg3);
  arg3 = &local_arg3;
  gdxAutoCommitVector3 auto_commit_arg3(jenv, jarg3, &local_arg3);
  (arg1)->setOptimizedBvh(arg2,(btVector3 const &)*arg3);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btBvhTriangleMeshShape_1setOptimizedBvh_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btBvhTriangleMeshShape *arg1 = (btBvhTriangleMeshShape *) 0 ;
  btOptimizedBvh *arg2 = (btOptimizedBvh *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btBvhTriangleMeshShape **)&jarg1; 
  arg2 = *(btOptimizedBvh **)&jarg2; 
  (arg1)->setOptimizedBvh(arg2);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btBvhTriangleMeshShape_1buildOptimizedBvh(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  btBvhTriangleMeshShape *arg1 = (btBvhTriangleMeshShape *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btBvhTriangleMeshShape **)&jarg1; 
  (arg1)->buildOptimizedBvh();
}


SWIGEXPORT jboolean JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btBvhTriangleMeshShape_1usesQuantizedAabbCompression(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  btBvhTriangleMeshShape *arg1 = (btBvhTriangleMeshShape *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btBvhTriangleMeshShape **)&jarg1; 
  result = (bool)((btBvhTriangleMeshShape const *)arg1)->usesQuantizedAabbCompression();
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btBvhTriangleMeshShape_1setTriangleInfoMap(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btBvhTriangleMeshShape *arg1 = (btBvhTriangleMeshShape *) 0 ;
  btTriangleInfoMap *arg2 = (btTriangleInfoMap *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btBvhTriangleMeshShape **)&jarg1; 
  arg2 = *(btTriangleInfoMap **)&jarg2; 
  (arg1)->setTriangleInfoMap(arg2);
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btBvhTriangleMeshShape_1getTriangleInfoMap_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btBvhTriangleMeshShape *arg1 = (btBvhTriangleMeshShape *) 0 ;
  btTriangleInfoMap *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btBvhTriangleMeshShape **)&jarg1; 
  result = (btTriangleInfoMap *)((btBvhTriangleMeshShape const *)arg1)->getTriangleInfoMap();
  *(btTriangleInfoMap **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btBvhTriangleMeshShape_1serializeSingleBvh(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  btBvhTriangleMeshShape *arg1 = (btBvhTriangleMeshShape *) 0 ;
  btSerializer *arg2 = (btSerializer *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btBvhTriangleMeshShape **)&jarg1; 
  arg2 = *(btSerializer **)&jarg2; 
  ((btBvhTriangleMeshShape const *)arg1)->serializeSingleBvh(arg2);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btBvhTriangleMeshShape_1serializeSingleTriangleInfoMap(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  btBvhTriangleMeshShape *arg1 = (btBvhTriangleMeshShape *) 0 ;
  btSerializer *arg2 = (btSerializer *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btBvhTriangleMeshShape **)&jarg1; 
  arg2 = *(btSerializer **)&jarg2; 
  ((btBvhTriangleMeshShape const *)arg1)->serializeSingleTriangleInfoMap(arg2);
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_new_1btBvhTriangleMeshShape_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jboolean jarg1, jlong jarg2, jobject jarg2_, jboolean jarg3, jboolean jarg4) {
  jlong jresult = 0 ;
  bool arg1 ;
  btStridingMeshInterface *arg2 = (btStridingMeshInterface *) 0 ;
  bool arg3 ;
  bool arg4 ;
  btBvhTriangleMeshShape *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg2_;
  arg1 = jarg1 ? true : false; 
  arg2 = *(btStridingMeshInterface **)&jarg2; 
  arg3 = jarg3 ? true : false; 
  arg4 = jarg4 ? true : false; 
  result = (btBvhTriangleMeshShape *)new_btBvhTriangleMeshShape__SWIG_0(arg1,arg2,arg3,arg4);
  *(btBvhTriangleMeshShape **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_new_1btBvhTriangleMeshShape_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jboolean jarg1, jlong jarg2, jobject jarg2_, jboolean jarg3) {
  jlong jresult = 0 ;
  bool arg1 ;
  btStridingMeshInterface *arg2 = (btStridingMeshInterface *) 0 ;
  bool arg3 ;
  btBvhTriangleMeshShape *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg2_;
  arg1 = jarg1 ? true : false; 
  arg2 = *(btStridingMeshInterface **)&jarg2; 
  arg3 = jarg3 ? true : false; 
  result = (btBvhTriangleMeshShape *)new_btBvhTriangleMeshShape__SWIG_0(arg1,arg2,arg3);
  *(btBvhTriangleMeshShape **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_new_1btBvhTriangleMeshShape_1_1SWIG_12(JNIEnv *jenv, jclass jcls, jboolean jarg1, jlong jarg2, jobject jarg2_, jboolean jarg3, jobject jarg4, jobject jarg5, jboolean jarg6) {
  jlong jresult = 0 ;
  bool arg1 ;
  btStridingMeshInterface *arg2 = (btStridingMeshInterface *) 0 ;
  bool arg3 ;
  btVector3 *arg4 = 0 ;
  btVector3 *arg5 = 0 ;
  bool arg6 ;
  btBvhTriangleMeshShape *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg2_;
  arg1 = jarg1 ? true : false; 
  arg2 = *(btStridingMeshInterface **)&jarg2; 
  arg3 = jarg3 ? true : false; 
  btVector3 local_arg4;
  gdx_setbtVector3FromVector3(jenv, local_arg4, jarg4);
  arg4 = &local_arg4;
  gdxAutoCommitVector3 auto_commit_arg4(jenv, jarg4, &local_arg4);
  btVector3 local_arg5;
  gdx_setbtVector3FromVector3(jenv, local_arg5, jarg5);
  arg5 = &local_arg5;
  gdxAutoCommitVector3 auto_commit_arg5(jenv, jarg5, &local_arg5);
  arg6 = jarg6 ? true : false; 
  result = (btBvhTriangleMeshShape *)new_btBvhTriangleMeshShape__SWIG_2(arg1,arg2,arg3,(btVector3 const &)*arg4,(btVector3 const &)*arg5,arg6);
  *(btBvhTriangleMeshShape **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_new_1btBvhTriangleMeshShape_1_1SWIG_13(JNIEnv *jenv, jclass jcls, jboolean jarg1, jlong jarg2, jobject jarg2_, jboolean jarg3, jobject jarg4, jobject jarg5) {
  jlong jresult = 0 ;
  bool arg1 ;
  btStridingMeshInterface *arg2 = (btStridingMeshInterface *) 0 ;
  bool arg3 ;
  btVector3 *arg4 = 0 ;
  btVector3 *arg5 = 0 ;
  btBvhTriangleMeshShape *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg2_;
  arg1 = jarg1 ? true : false; 
  arg2 = *(btStridingMeshInterface **)&jarg2; 
  arg3 = jarg3 ? true : false; 
  btVector3 local_arg4;
  gdx_setbtVector3FromVector3(jenv, local_arg4, jarg4);
  arg4 = &local_arg4;
  gdxAutoCommitVector3 auto_commit_arg4(jenv, jarg4, &local_arg4);
  btVector3 local_arg5;
  gdx_setbtVector3FromVector3(jenv, local_arg5, jarg5);
  arg5 = &local_arg5;
  gdxAutoCommitVector3 auto_commit_arg5(jenv, jarg5, &local_arg5);
  result = (btBvhTriangleMeshShape *)new_btBvhTriangleMeshShape__SWIG_2(arg1,arg2,arg3,(btVector3 const &)*arg4,(btVector3 const &)*arg5);
  *(btBvhTriangleMeshShape **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btTriangleMeshShapeData_1collisionShapeData_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btTriangleMeshShapeData *arg1 = (btTriangleMeshShapeData *) 0 ;
  btCollisionShapeData *arg2 = (btCollisionShapeData *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btTriangleMeshShapeData **)&jarg1; 
  arg2 = *(btCollisionShapeData **)&jarg2; 
  if (arg1) (arg1)->m_collisionShapeData = *arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btTriangleMeshShapeData_1collisionShapeData_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btTriangleMeshShapeData *arg1 = (btTriangleMeshShapeData *) 0 ;
  btCollisionShapeData *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btTriangleMeshShapeData **)&jarg1; 
  result = (btCollisionShapeData *)& ((arg1)->m_collisionShapeData);
  *(btCollisionShapeData **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btTriangleMeshShapeData_1meshInterface_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btTriangleMeshShapeData *arg1 = (btTriangleMeshShapeData *) 0 ;
  btStridingMeshInterfaceData *arg2 = (btStridingMeshInterfaceData *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btTriangleMeshShapeData **)&jarg1; 
  arg2 = *(btStridingMeshInterfaceData **)&jarg2; 
  if (arg1) (arg1)->m_meshInterface = *arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btTriangleMeshShapeData_1meshInterface_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btTriangleMeshShapeData *arg1 = (btTriangleMeshShapeData *) 0 ;
  btStridingMeshInterfaceData *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btTriangleMeshShapeData **)&jarg1; 
  result = (btStridingMeshInterfaceData *)& ((arg1)->m_meshInterface);
  *(btStridingMeshInterfaceData **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btTriangleMeshShapeData_1quantizedFloatBvh_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btTriangleMeshShapeData *arg1 = (btTriangleMeshShapeData *) 0 ;
  btQuantizedBvhFloatData *arg2 = (btQuantizedBvhFloatData *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btTriangleMeshShapeData **)&jarg1; 
  arg2 = *(btQuantizedBvhFloatData **)&jarg2; 
  if (arg1) (arg1)->m_quantizedFloatBvh = arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btTriangleMeshShapeData_1quantizedFloatBvh_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btTriangleMeshShapeData *arg1 = (btTriangleMeshShapeData *) 0 ;
  btQuantizedBvhFloatData *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btTriangleMeshShapeData **)&jarg1; 
  result = (btQuantizedBvhFloatData *) ((arg1)->m_quantizedFloatBvh);
  *(btQuantizedBvhFloatData **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btTriangleMeshShapeData_1quantizedDoubleBvh_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btTriangleMeshShapeData *arg1 = (btTriangleMeshShapeData *) 0 ;
  btQuantizedBvhDoubleData *arg2 = (btQuantizedBvhDoubleData *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btTriangleMeshShapeData **)&jarg1; 
  arg2 = *(btQuantizedBvhDoubleData **)&jarg2; 
  if (arg1) (arg1)->m_quantizedDoubleBvh = arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btTriangleMeshShapeData_1quantizedDoubleBvh_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btTriangleMeshShapeData *arg1 = (btTriangleMeshShapeData *) 0 ;
  btQuantizedBvhDoubleData *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btTriangleMeshShapeData **)&jarg1; 
  result = (btQuantizedBvhDoubleData *) ((arg1)->m_quantizedDoubleBvh);
  *(btQuantizedBvhDoubleData **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btTriangleMeshShapeData_1triangleInfoMap_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btTriangleMeshShapeData *arg1 = (btTriangleMeshShapeData *) 0 ;
  btTriangleInfoMapData *arg2 = (btTriangleInfoMapData *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btTriangleMeshShapeData **)&jarg1; 
  arg2 = *(btTriangleInfoMapData **)&jarg2; 
  if (arg1) (arg1)->m_triangleInfoMap = arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btTriangleMeshShapeData_1triangleInfoMap_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btTriangleMeshShapeData *arg1 = (btTriangleMeshShapeData *) 0 ;
  btTriangleInfoMapData *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btTriangleMeshShapeData **)&jarg1; 
  result = (btTriangleInfoMapData *) ((arg1)->m_triangleInfoMap);
  *(btTriangleInfoMapData **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btTriangleMeshShapeData_1collisionMargin_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2) {
  btTriangleMeshShapeData *arg1 = (btTriangleMeshShapeData *) 0 ;
  float arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btTriangleMeshShapeData **)&jarg1; 
  arg2 = (float)jarg2; 
  if (arg1) (arg1)->m_collisionMargin = arg2;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btTriangleMeshShapeData_1collisionMargin_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jfloat jresult = 0 ;
  btTriangleMeshShapeData *arg1 = (btTriangleMeshShapeData *) 0 ;
  float result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btTriangleMeshShapeData **)&jarg1; 
  result = (float) ((arg1)->m_collisionMargin);
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btTriangleMeshShapeData_1pad3_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  btTriangleMeshShapeData *arg1 = (btTriangleMeshShapeData *) 0 ;
  char *arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btTriangleMeshShapeData **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return ;
  }
  {
    if(arg2) {
      strncpy((char*)arg1->m_pad3, (const char *)arg2, 4-1);
      arg1->m_pad3[4-1] = 0;
    } else {
      arg1->m_pad3[0] = 0;
    }
  }
  
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
}


SWIGEXPORT jstring JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btTriangleMeshShapeData_1pad3_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  btTriangleMeshShapeData *arg1 = (btTriangleMeshShapeData *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btTriangleMeshShapeData **)&jarg1; 
  result = (char *)(char *) ((arg1)->m_pad3);
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_new_1btTriangleMeshShapeData(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  btTriangleMeshShapeData *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (btTriangleMeshShapeData *)new btTriangleMeshShapeData();
  *(btTriangleMeshShapeData **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_delete_1btTriangleMeshShapeData(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  btTriangleMeshShapeData *arg1 = (btTriangleMeshShapeData *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(btTriangleMeshShapeData **)&jarg1; 
  delete arg1;
}


SWIGEXPORT jobject JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btBoxShape_1getHalfExtentsWithMargin(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jobject jresult = 0 ;
  btBoxShape *arg1 = (btBoxShape *) 0 ;
  btVector3 result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btBoxShape **)&jarg1; 
  result = ((btBoxShape const *)arg1)->getHalfExtentsWithMargin();
  jresult = gdx_getReturnVector3(jenv);
  gdx_setVector3FrombtVector3(jenv, jresult, result);
  return jresult;
}


SWIGEXPORT jobject JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btBoxShape_1getHalfExtentsWithoutMargin(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jobject jresult = 0 ;
  btBoxShape *arg1 = (btBoxShape *) 0 ;
  btVector3 *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btBoxShape **)&jarg1; 
  result = (btVector3 *) &((btBoxShape const *)arg1)->getHalfExtentsWithoutMargin();
  jresult = gdx_getReturnVector3(jenv);
  gdx_setVector3FrombtVector3(jenv, jresult, result);
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_new_1btBoxShape(JNIEnv *jenv, jclass jcls, jobject jarg1) {
  jlong jresult = 0 ;
  btVector3 *arg1 = 0 ;
  btBoxShape *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  btVector3 local_arg1;
  gdx_setbtVector3FromVector3(jenv, local_arg1, jarg1);
  arg1 = &local_arg1;
  gdxAutoCommitVector3 auto_commit_arg1(jenv, jarg1, &local_arg1);
  result = (btBoxShape *)new btBoxShape((btVector3 const &)*arg1);
  *(btBoxShape **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btBoxShape_1getPlaneEquation(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jint jarg3) {
  btBoxShape *arg1 = (btBoxShape *) 0 ;
  btVector4 *arg2 = 0 ;
  int arg3 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btBoxShape **)&jarg1; 
  arg2 = *(btVector4 **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btVector4 & reference is null");
    return ;
  } 
  arg3 = (int)jarg3; 
  ((btBoxShape const *)arg1)->getPlaneEquation(*arg2,arg3);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_delete_1btBoxShape(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  btBoxShape *arg1 = (btBoxShape *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(btBoxShape **)&jarg1; 
  delete arg1;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_new_1btCapsuleShape_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jfloat jarg1, jfloat jarg2) {
  jlong jresult = 0 ;
  btScalar arg1 ;
  btScalar arg2 ;
  btCapsuleShape *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (btScalar)jarg1; 
  arg2 = (btScalar)jarg2; 
  result = (btCapsuleShape *)new btCapsuleShape(arg1,arg2);
  *(btCapsuleShape **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btCapsuleShape_1getUpAxis(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  btCapsuleShape *arg1 = (btCapsuleShape *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btCapsuleShape **)&jarg1; 
  result = (int)((btCapsuleShape const *)arg1)->getUpAxis();
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btCapsuleShape_1getRadius(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jfloat jresult = 0 ;
  btCapsuleShape *arg1 = (btCapsuleShape *) 0 ;
  btScalar result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btCapsuleShape **)&jarg1; 
  result = (btScalar)((btCapsuleShape const *)arg1)->getRadius();
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btCapsuleShape_1getHalfHeight(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jfloat jresult = 0 ;
  btCapsuleShape *arg1 = (btCapsuleShape *) 0 ;
  btScalar result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btCapsuleShape **)&jarg1; 
  result = (btScalar)((btCapsuleShape const *)arg1)->getHalfHeight();
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btCapsuleShape_1deSerializeFloat(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btCapsuleShape *arg1 = (btCapsuleShape *) 0 ;
  btCapsuleShapeData *arg2 = (btCapsuleShapeData *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btCapsuleShape **)&jarg1; 
  arg2 = *(btCapsuleShapeData **)&jarg2; 
  (arg1)->deSerializeFloat(arg2);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_delete_1btCapsuleShape(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  btCapsuleShape *arg1 = (btCapsuleShape *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(btCapsuleShape **)&jarg1; 
  delete arg1;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_new_1btCapsuleShapeX(JNIEnv *jenv, jclass jcls, jfloat jarg1, jfloat jarg2) {
  jlong jresult = 0 ;
  btScalar arg1 ;
  btScalar arg2 ;
  btCapsuleShapeX *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (btScalar)jarg1; 
  arg2 = (btScalar)jarg2; 
  result = (btCapsuleShapeX *)new btCapsuleShapeX(arg1,arg2);
  *(btCapsuleShapeX **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_delete_1btCapsuleShapeX(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  btCapsuleShapeX *arg1 = (btCapsuleShapeX *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(btCapsuleShapeX **)&jarg1; 
  delete arg1;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_new_1btCapsuleShapeZ(JNIEnv *jenv, jclass jcls, jfloat jarg1, jfloat jarg2) {
  jlong jresult = 0 ;
  btScalar arg1 ;
  btScalar arg2 ;
  btCapsuleShapeZ *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (btScalar)jarg1; 
  arg2 = (btScalar)jarg2; 
  result = (btCapsuleShapeZ *)new btCapsuleShapeZ(arg1,arg2);
  *(btCapsuleShapeZ **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_delete_1btCapsuleShapeZ(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  btCapsuleShapeZ *arg1 = (btCapsuleShapeZ *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(btCapsuleShapeZ **)&jarg1; 
  delete arg1;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btCapsuleShapeData_1convexInternalShapeData_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btCapsuleShapeData *arg1 = (btCapsuleShapeData *) 0 ;
  btConvexInternalShapeData *arg2 = (btConvexInternalShapeData *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btCapsuleShapeData **)&jarg1; 
  arg2 = *(btConvexInternalShapeData **)&jarg2; 
  if (arg1) (arg1)->m_convexInternalShapeData = *arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btCapsuleShapeData_1convexInternalShapeData_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btCapsuleShapeData *arg1 = (btCapsuleShapeData *) 0 ;
  btConvexInternalShapeData *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btCapsuleShapeData **)&jarg1; 
  result = (btConvexInternalShapeData *)& ((arg1)->m_convexInternalShapeData);
  *(btConvexInternalShapeData **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btCapsuleShapeData_1upAxis_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  btCapsuleShapeData *arg1 = (btCapsuleShapeData *) 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btCapsuleShapeData **)&jarg1; 
  arg2 = (int)jarg2; 
  if (arg1) (arg1)->m_upAxis = arg2;
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btCapsuleShapeData_1upAxis_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  btCapsuleShapeData *arg1 = (btCapsuleShapeData *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btCapsuleShapeData **)&jarg1; 
  result = (int) ((arg1)->m_upAxis);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btCapsuleShapeData_1padding_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  btCapsuleShapeData *arg1 = (btCapsuleShapeData *) 0 ;
  char *arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btCapsuleShapeData **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return ;
  }
  {
    if(arg2) {
      strncpy((char*)arg1->m_padding, (const char *)arg2, 4-1);
      arg1->m_padding[4-1] = 0;
    } else {
      arg1->m_padding[0] = 0;
    }
  }
  
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
}


SWIGEXPORT jstring JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btCapsuleShapeData_1padding_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  btCapsuleShapeData *arg1 = (btCapsuleShapeData *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btCapsuleShapeData **)&jarg1; 
  result = (char *)(char *) ((arg1)->m_padding);
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_new_1btCapsuleShapeData(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  btCapsuleShapeData *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (btCapsuleShapeData *)new btCapsuleShapeData();
  *(btCapsuleShapeData **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_delete_1btCapsuleShapeData(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  btCapsuleShapeData *arg1 = (btCapsuleShapeData *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(btCapsuleShapeData **)&jarg1; 
  delete arg1;
}


SWIGEXPORT jobject JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btBox2dShape_1getHalfExtentsWithMargin(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jobject jresult = 0 ;
  btBox2dShape *arg1 = (btBox2dShape *) 0 ;
  btVector3 result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btBox2dShape **)&jarg1; 
  result = ((btBox2dShape const *)arg1)->getHalfExtentsWithMargin();
  jresult = gdx_getReturnVector3(jenv);
  gdx_setVector3FrombtVector3(jenv, jresult, result);
  return jresult;
}


SWIGEXPORT jobject JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btBox2dShape_1getHalfExtentsWithoutMargin(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jobject jresult = 0 ;
  btBox2dShape *arg1 = (btBox2dShape *) 0 ;
  btVector3 *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btBox2dShape **)&jarg1; 
  result = (btVector3 *) &((btBox2dShape const *)arg1)->getHalfExtentsWithoutMargin();
  jresult = gdx_getReturnVector3(jenv);
  gdx_setVector3FrombtVector3(jenv, jresult, result);
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_new_1btBox2dShape(JNIEnv *jenv, jclass jcls, jobject jarg1) {
  jlong jresult = 0 ;
  btVector3 *arg1 = 0 ;
  btBox2dShape *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  btVector3 local_arg1;
  gdx_setbtVector3FromVector3(jenv, local_arg1, jarg1);
  arg1 = &local_arg1;
  gdxAutoCommitVector3 auto_commit_arg1(jenv, jarg1, &local_arg1);
  result = (btBox2dShape *)new btBox2dShape((btVector3 const &)*arg1);
  *(btBox2dShape **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btBox2dShape_1getVertexCount(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  btBox2dShape *arg1 = (btBox2dShape *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btBox2dShape **)&jarg1; 
  result = (int)((btBox2dShape const *)arg1)->getVertexCount();
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btBox2dShape_1getVertices(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btBox2dShape *arg1 = (btBox2dShape *) 0 ;
  btVector3 *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btBox2dShape **)&jarg1; 
  result = (btVector3 *)((btBox2dShape const *)arg1)->getVertices();
  *(btVector3 **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btBox2dShape_1getNormals(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btBox2dShape *arg1 = (btBox2dShape *) 0 ;
  btVector3 *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btBox2dShape **)&jarg1; 
  result = (btVector3 *)((btBox2dShape const *)arg1)->getNormals();
  *(btVector3 **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jobject JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btBox2dShape_1getCentroid(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jobject jresult = 0 ;
  btBox2dShape *arg1 = (btBox2dShape *) 0 ;
  btVector3 *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btBox2dShape **)&jarg1; 
  result = (btVector3 *) &((btBox2dShape const *)arg1)->getCentroid();
  jresult = gdx_getReturnVector3(jenv);
  gdx_setVector3FrombtVector3(jenv, jresult, result);
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btBox2dShape_1getPlaneEquation(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jint jarg3) {
  btBox2dShape *arg1 = (btBox2dShape *) 0 ;
  btVector4 *arg2 = 0 ;
  int arg3 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btBox2dShape **)&jarg1; 
  arg2 = *(btVector4 **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btVector4 & reference is null");
    return ;
  } 
  arg3 = (int)jarg3; 
  ((btBox2dShape const *)arg1)->getPlaneEquation(*arg2,arg3);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_delete_1btBox2dShape(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  btBox2dShape *arg1 = (btBox2dShape *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(btBox2dShape **)&jarg1; 
  delete arg1;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btTriangleShape_1vertices1_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btTriangleShape *arg1 = (btTriangleShape *) 0 ;
  btVector3 *arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btTriangleShape **)&jarg1; 
  arg2 = *(btVector3 **)&jarg2; 
  {
    size_t ii;
    btVector3 *b = (btVector3 *) arg1->m_vertices1;
    for (ii = 0; ii < (size_t)3; ii++) b[ii] = *((btVector3 *) arg2 + ii);
  }
  
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btTriangleShape_1vertices1_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btTriangleShape *arg1 = (btTriangleShape *) 0 ;
  btVector3 *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btTriangleShape **)&jarg1; 
  result = (btVector3 *)(btVector3 *) ((arg1)->m_vertices1);
  *(btVector3 **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jobject JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btTriangleShape_1getVertexPtr_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  jobject jresult = 0 ;
  btTriangleShape *arg1 = (btTriangleShape *) 0 ;
  int arg2 ;
  btVector3 *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btTriangleShape **)&jarg1; 
  arg2 = (int)jarg2; 
  result = (btVector3 *) &(arg1)->getVertexPtr(arg2);
  jresult = gdx_getReturnVector3(jenv);
  gdx_setVector3FrombtVector3(jenv, jresult, result);
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_new_1btTriangleShape_1_1SWIG_10(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  btTriangleShape *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (btTriangleShape *)new btTriangleShape();
  *(btTriangleShape **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_new_1btTriangleShape_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jobject jarg1, jobject jarg2, jobject jarg3) {
  jlong jresult = 0 ;
  btVector3 *arg1 = 0 ;
  btVector3 *arg2 = 0 ;
  btVector3 *arg3 = 0 ;
  btTriangleShape *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  btVector3 local_arg1;
  gdx_setbtVector3FromVector3(jenv, local_arg1, jarg1);
  arg1 = &local_arg1;
  gdxAutoCommitVector3 auto_commit_arg1(jenv, jarg1, &local_arg1);
  btVector3 local_arg2;
  gdx_setbtVector3FromVector3(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitVector3 auto_commit_arg2(jenv, jarg2, &local_arg2);
  btVector3 local_arg3;
  gdx_setbtVector3FromVector3(jenv, local_arg3, jarg3);
  arg3 = &local_arg3;
  gdxAutoCommitVector3 auto_commit_arg3(jenv, jarg3, &local_arg3);
  result = (btTriangleShape *)new btTriangleShape((btVector3 const &)*arg1,(btVector3 const &)*arg2,(btVector3 const &)*arg3);
  *(btTriangleShape **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btTriangleShape_1calcNormal(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2) {
  btTriangleShape *arg1 = (btTriangleShape *) 0 ;
  btVector3 *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btTriangleShape **)&jarg1; 
  btVector3 local_arg2;
  gdx_setbtVector3FromVector3(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitVector3 auto_commit_arg2(jenv, jarg2, &local_arg2);
  ((btTriangleShape const *)arg1)->calcNormal(*arg2);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btTriangleShape_1getPlaneEquation(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jobject jarg3, jobject jarg4) {
  btTriangleShape *arg1 = (btTriangleShape *) 0 ;
  int arg2 ;
  btVector3 *arg3 = 0 ;
  btVector3 *arg4 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btTriangleShape **)&jarg1; 
  arg2 = (int)jarg2; 
  btVector3 local_arg3;
  gdx_setbtVector3FromVector3(jenv, local_arg3, jarg3);
  arg3 = &local_arg3;
  gdxAutoCommitVector3 auto_commit_arg3(jenv, jarg3, &local_arg3);
  btVector3 local_arg4;
  gdx_setbtVector3FromVector3(jenv, local_arg4, jarg4);
  arg4 = &local_arg4;
  gdxAutoCommitVector3 auto_commit_arg4(jenv, jarg4, &local_arg4);
  ((btTriangleShape const *)arg1)->getPlaneEquation(arg2,*arg3,*arg4);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_delete_1btTriangleShape(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  btTriangleShape *arg1 = (btTriangleShape *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(btTriangleShape **)&jarg1; 
  delete arg1;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_new_1btSphereShape(JNIEnv *jenv, jclass jcls, jfloat jarg1) {
  jlong jresult = 0 ;
  btScalar arg1 ;
  btSphereShape *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (btScalar)jarg1; 
  result = (btSphereShape *)new btSphereShape(arg1);
  *(btSphereShape **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btSphereShape_1getRadius(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jfloat jresult = 0 ;
  btSphereShape *arg1 = (btSphereShape *) 0 ;
  btScalar result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSphereShape **)&jarg1; 
  result = (btScalar)((btSphereShape const *)arg1)->getRadius();
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btSphereShape_1setUnscaledRadius(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2) {
  btSphereShape *arg1 = (btSphereShape *) 0 ;
  btScalar arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSphereShape **)&jarg1; 
  arg2 = (btScalar)jarg2; 
  (arg1)->setUnscaledRadius(arg2);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_delete_1btSphereShape(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  btSphereShape *arg1 = (btSphereShape *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(btSphereShape **)&jarg1; 
  delete arg1;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_delete_1btStridingMeshInterface(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  btStridingMeshInterface *arg1 = (btStridingMeshInterface *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(btStridingMeshInterface **)&jarg1; 
  delete arg1;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btStridingMeshInterface_1InternalProcessAllTriangles(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jobject jarg3, jobject jarg4) {
  btStridingMeshInterface *arg1 = (btStridingMeshInterface *) 0 ;
  btInternalTriangleIndexCallback *arg2 = (btInternalTriangleIndexCallback *) 0 ;
  btVector3 *arg3 = 0 ;
  btVector3 *arg4 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btStridingMeshInterface **)&jarg1; 
  arg2 = *(btInternalTriangleIndexCallback **)&jarg2; 
  btVector3 local_arg3;
  gdx_setbtVector3FromVector3(jenv, local_arg3, jarg3);
  arg3 = &local_arg3;
  gdxAutoCommitVector3 auto_commit_arg3(jenv, jarg3, &local_arg3);
  btVector3 local_arg4;
  gdx_setbtVector3FromVector3(jenv, local_arg4, jarg4);
  arg4 = &local_arg4;
  gdxAutoCommitVector3 auto_commit_arg4(jenv, jarg4, &local_arg4);
  ((btStridingMeshInterface const *)arg1)->InternalProcessAllTriangles(arg2,(btVector3 const &)*arg3,(btVector3 const &)*arg4);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btStridingMeshInterface_1calculateAabbBruteForce(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2, jobject jarg3) {
  btStridingMeshInterface *arg1 = (btStridingMeshInterface *) 0 ;
  btVector3 *arg2 = 0 ;
  btVector3 *arg3 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btStridingMeshInterface **)&jarg1; 
  btVector3 local_arg2;
  gdx_setbtVector3FromVector3(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitVector3 auto_commit_arg2(jenv, jarg2, &local_arg2);
  btVector3 local_arg3;
  gdx_setbtVector3FromVector3(jenv, local_arg3, jarg3);
  arg3 = &local_arg3;
  gdxAutoCommitVector3 auto_commit_arg3(jenv, jarg3, &local_arg3);
  (arg1)->calculateAabbBruteForce(*arg2,*arg3);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btStridingMeshInterface_1getLockedVertexIndexBase_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jlong jarg3, jlong jarg4, jlong jarg5, jlong jarg6, jlong jarg7, jlong jarg8, jlong jarg9, jint jarg10) {
  btStridingMeshInterface *arg1 = (btStridingMeshInterface *) 0 ;
  unsigned char **arg2 = (unsigned char **) 0 ;
  int *arg3 = 0 ;
  PHY_ScalarType *arg4 = 0 ;
  int *arg5 = 0 ;
  unsigned char **arg6 = (unsigned char **) 0 ;
  int *arg7 = 0 ;
  int *arg8 = 0 ;
  PHY_ScalarType *arg9 = 0 ;
  int arg10 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btStridingMeshInterface **)&jarg1; 
  arg2 = *(unsigned char ***)&jarg2; 
  arg3 = *(int **)&jarg3;
  if (!arg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "int & reference is null");
    return ;
  } 
  arg4 = *(PHY_ScalarType **)&jarg4;
  if (!arg4) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "PHY_ScalarType & reference is null");
    return ;
  } 
  arg5 = *(int **)&jarg5;
  if (!arg5) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "int & reference is null");
    return ;
  } 
  arg6 = *(unsigned char ***)&jarg6; 
  arg7 = *(int **)&jarg7;
  if (!arg7) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "int & reference is null");
    return ;
  } 
  arg8 = *(int **)&jarg8;
  if (!arg8) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "int & reference is null");
    return ;
  } 
  arg9 = *(PHY_ScalarType **)&jarg9;
  if (!arg9) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "PHY_ScalarType & reference is null");
    return ;
  } 
  arg10 = (int)jarg10; 
  (arg1)->getLockedVertexIndexBase(arg2,*arg3,*arg4,*arg5,arg6,*arg7,*arg8,*arg9,arg10);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btStridingMeshInterface_1getLockedVertexIndexBase_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jlong jarg3, jlong jarg4, jlong jarg5, jlong jarg6, jlong jarg7, jlong jarg8, jlong jarg9) {
  btStridingMeshInterface *arg1 = (btStridingMeshInterface *) 0 ;
  unsigned char **arg2 = (unsigned char **) 0 ;
  int *arg3 = 0 ;
  PHY_ScalarType *arg4 = 0 ;
  int *arg5 = 0 ;
  unsigned char **arg6 = (unsigned char **) 0 ;
  int *arg7 = 0 ;
  int *arg8 = 0 ;
  PHY_ScalarType *arg9 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btStridingMeshInterface **)&jarg1; 
  arg2 = *(unsigned char ***)&jarg2; 
  arg3 = *(int **)&jarg3;
  if (!arg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "int & reference is null");
    return ;
  } 
  arg4 = *(PHY_ScalarType **)&jarg4;
  if (!arg4) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "PHY_ScalarType & reference is null");
    return ;
  } 
  arg5 = *(int **)&jarg5;
  if (!arg5) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "int & reference is null");
    return ;
  } 
  arg6 = *(unsigned char ***)&jarg6; 
  arg7 = *(int **)&jarg7;
  if (!arg7) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "int & reference is null");
    return ;
  } 
  arg8 = *(int **)&jarg8;
  if (!arg8) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "int & reference is null");
    return ;
  } 
  arg9 = *(PHY_ScalarType **)&jarg9;
  if (!arg9) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "PHY_ScalarType & reference is null");
    return ;
  } 
  (arg1)->getLockedVertexIndexBase(arg2,*arg3,*arg4,*arg5,arg6,*arg7,*arg8,*arg9);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btStridingMeshInterface_1getLockedReadOnlyVertexIndexBase_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jlong jarg3, jlong jarg4, jlong jarg5, jlong jarg6, jlong jarg7, jlong jarg8, jlong jarg9, jint jarg10) {
  btStridingMeshInterface *arg1 = (btStridingMeshInterface *) 0 ;
  unsigned char **arg2 = (unsigned char **) 0 ;
  int *arg3 = 0 ;
  PHY_ScalarType *arg4 = 0 ;
  int *arg5 = 0 ;
  unsigned char **arg6 = (unsigned char **) 0 ;
  int *arg7 = 0 ;
  int *arg8 = 0 ;
  PHY_ScalarType *arg9 = 0 ;
  int arg10 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btStridingMeshInterface **)&jarg1; 
  arg2 = *(unsigned char ***)&jarg2; 
  arg3 = *(int **)&jarg3;
  if (!arg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "int & reference is null");
    return ;
  } 
  arg4 = *(PHY_ScalarType **)&jarg4;
  if (!arg4) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "PHY_ScalarType & reference is null");
    return ;
  } 
  arg5 = *(int **)&jarg5;
  if (!arg5) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "int & reference is null");
    return ;
  } 
  arg6 = *(unsigned char ***)&jarg6; 
  arg7 = *(int **)&jarg7;
  if (!arg7) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "int & reference is null");
    return ;
  } 
  arg8 = *(int **)&jarg8;
  if (!arg8) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "int & reference is null");
    return ;
  } 
  arg9 = *(PHY_ScalarType **)&jarg9;
  if (!arg9) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "PHY_ScalarType & reference is null");
    return ;
  } 
  arg10 = (int)jarg10; 
  ((btStridingMeshInterface const *)arg1)->getLockedReadOnlyVertexIndexBase((unsigned char const **)arg2,*arg3,*arg4,*arg5,(unsigned char const **)arg6,*arg7,*arg8,*arg9,arg10);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btStridingMeshInterface_1getLockedReadOnlyVertexIndexBase_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jlong jarg3, jlong jarg4, jlong jarg5, jlong jarg6, jlong jarg7, jlong jarg8, jlong jarg9) {
  btStridingMeshInterface *arg1 = (btStridingMeshInterface *) 0 ;
  unsigned char **arg2 = (unsigned char **) 0 ;
  int *arg3 = 0 ;
  PHY_ScalarType *arg4 = 0 ;
  int *arg5 = 0 ;
  unsigned char **arg6 = (unsigned char **) 0 ;
  int *arg7 = 0 ;
  int *arg8 = 0 ;
  PHY_ScalarType *arg9 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btStridingMeshInterface **)&jarg1; 
  arg2 = *(unsigned char ***)&jarg2; 
  arg3 = *(int **)&jarg3;
  if (!arg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "int & reference is null");
    return ;
  } 
  arg4 = *(PHY_ScalarType **)&jarg4;
  if (!arg4) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "PHY_ScalarType & reference is null");
    return ;
  } 
  arg5 = *(int **)&jarg5;
  if (!arg5) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "int & reference is null");
    return ;
  } 
  arg6 = *(unsigned char ***)&jarg6; 
  arg7 = *(int **)&jarg7;
  if (!arg7) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "int & reference is null");
    return ;
  } 
  arg8 = *(int **)&jarg8;
  if (!arg8) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "int & reference is null");
    return ;
  } 
  arg9 = *(PHY_ScalarType **)&jarg9;
  if (!arg9) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "PHY_ScalarType & reference is null");
    return ;
  } 
  ((btStridingMeshInterface const *)arg1)->getLockedReadOnlyVertexIndexBase((unsigned char const **)arg2,*arg3,*arg4,*arg5,(unsigned char const **)arg6,*arg7,*arg8,*arg9);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btStridingMeshInterface_1unLockVertexBase(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  btStridingMeshInterface *arg1 = (btStridingMeshInterface *) 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btStridingMeshInterface **)&jarg1; 
  arg2 = (int)jarg2; 
  (arg1)->unLockVertexBase(arg2);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btStridingMeshInterface_1unLockReadOnlyVertexBase(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  btStridingMeshInterface *arg1 = (btStridingMeshInterface *) 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btStridingMeshInterface **)&jarg1; 
  arg2 = (int)jarg2; 
  ((btStridingMeshInterface const *)arg1)->unLockReadOnlyVertexBase(arg2);
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btStridingMeshInterface_1getNumSubParts(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  btStridingMeshInterface *arg1 = (btStridingMeshInterface *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btStridingMeshInterface **)&jarg1; 
  result = (int)((btStridingMeshInterface const *)arg1)->getNumSubParts();
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btStridingMeshInterface_1preallocateVertices(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  btStridingMeshInterface *arg1 = (btStridingMeshInterface *) 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btStridingMeshInterface **)&jarg1; 
  arg2 = (int)jarg2; 
  (arg1)->preallocateVertices(arg2);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btStridingMeshInterface_1preallocateIndices(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  btStridingMeshInterface *arg1 = (btStridingMeshInterface *) 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btStridingMeshInterface **)&jarg1; 
  arg2 = (int)jarg2; 
  (arg1)->preallocateIndices(arg2);
}


SWIGEXPORT jboolean JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btStridingMeshInterface_1hasPremadeAabb(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  btStridingMeshInterface *arg1 = (btStridingMeshInterface *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btStridingMeshInterface **)&jarg1; 
  result = (bool)((btStridingMeshInterface const *)arg1)->hasPremadeAabb();
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btStridingMeshInterface_1setPremadeAabb(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2, jobject jarg3) {
  btStridingMeshInterface *arg1 = (btStridingMeshInterface *) 0 ;
  btVector3 *arg2 = 0 ;
  btVector3 *arg3 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btStridingMeshInterface **)&jarg1; 
  btVector3 local_arg2;
  gdx_setbtVector3FromVector3(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitVector3 auto_commit_arg2(jenv, jarg2, &local_arg2);
  btVector3 local_arg3;
  gdx_setbtVector3FromVector3(jenv, local_arg3, jarg3);
  arg3 = &local_arg3;
  gdxAutoCommitVector3 auto_commit_arg3(jenv, jarg3, &local_arg3);
  ((btStridingMeshInterface const *)arg1)->setPremadeAabb((btVector3 const &)*arg2,(btVector3 const &)*arg3);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btStridingMeshInterface_1getPremadeAabb(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlong jarg3, jobject jarg3_) {
  btStridingMeshInterface *arg1 = (btStridingMeshInterface *) 0 ;
  btVector3 *arg2 = (btVector3 *) 0 ;
  btVector3 *arg3 = (btVector3 *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  (void)jarg3_;
  arg1 = *(btStridingMeshInterface **)&jarg1; 
  arg2 = *(btVector3 **)&jarg2; 
  arg3 = *(btVector3 **)&jarg3; 
  ((btStridingMeshInterface const *)arg1)->getPremadeAabb(arg2,arg3);
}


SWIGEXPORT jobject JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btStridingMeshInterface_1getScaling(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jobject jresult = 0 ;
  btStridingMeshInterface *arg1 = (btStridingMeshInterface *) 0 ;
  btVector3 *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btStridingMeshInterface **)&jarg1; 
  result = (btVector3 *) &((btStridingMeshInterface const *)arg1)->getScaling();
  jresult = gdx_getReturnVector3(jenv);
  gdx_setVector3FrombtVector3(jenv, jresult, result);
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btStridingMeshInterface_1setScaling(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2) {
  btStridingMeshInterface *arg1 = (btStridingMeshInterface *) 0 ;
  btVector3 *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btStridingMeshInterface **)&jarg1; 
  btVector3 local_arg2;
  gdx_setbtVector3FromVector3(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitVector3 auto_commit_arg2(jenv, jarg2, &local_arg2);
  (arg1)->setScaling((btVector3 const &)*arg2);
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btStridingMeshInterface_1calculateSerializeBufferSize(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  btStridingMeshInterface *arg1 = (btStridingMeshInterface *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btStridingMeshInterface **)&jarg1; 
  result = (int)((btStridingMeshInterface const *)arg1)->calculateSerializeBufferSize();
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btStridingMeshInterface_1serialize(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jlong jarg3) {
  jstring jresult = 0 ;
  btStridingMeshInterface *arg1 = (btStridingMeshInterface *) 0 ;
  void *arg2 = (void *) 0 ;
  btSerializer *arg3 = (btSerializer *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btStridingMeshInterface **)&jarg1; 
  arg2 = (void *)jarg2; 
  arg3 = *(btSerializer **)&jarg3; 
  result = (char *)((btStridingMeshInterface const *)arg1)->serialize(arg2,arg3);
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btIntIndexData_1value_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  btIntIndexData *arg1 = (btIntIndexData *) 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btIntIndexData **)&jarg1; 
  arg2 = (int)jarg2; 
  if (arg1) (arg1)->m_value = arg2;
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btIntIndexData_1value_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  btIntIndexData *arg1 = (btIntIndexData *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btIntIndexData **)&jarg1; 
  result = (int) ((arg1)->m_value);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_new_1btIntIndexData(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  btIntIndexData *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (btIntIndexData *)new btIntIndexData();
  *(btIntIndexData **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_delete_1btIntIndexData(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  btIntIndexData *arg1 = (btIntIndexData *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(btIntIndexData **)&jarg1; 
  delete arg1;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btShortIntIndexData_1value_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jshort jarg2) {
  btShortIntIndexData *arg1 = (btShortIntIndexData *) 0 ;
  short arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btShortIntIndexData **)&jarg1; 
  arg2 = (short)jarg2; 
  if (arg1) (arg1)->m_value = arg2;
}


SWIGEXPORT jshort JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btShortIntIndexData_1value_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jshort jresult = 0 ;
  btShortIntIndexData *arg1 = (btShortIntIndexData *) 0 ;
  short result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btShortIntIndexData **)&jarg1; 
  result = (short) ((arg1)->m_value);
  jresult = (jshort)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btShortIntIndexData_1pad_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  btShortIntIndexData *arg1 = (btShortIntIndexData *) 0 ;
  char *arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btShortIntIndexData **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return ;
  }
  {
    if(arg2) {
      strncpy((char*)arg1->m_pad, (const char *)arg2, 2-1);
      arg1->m_pad[2-1] = 0;
    } else {
      arg1->m_pad[0] = 0;
    }
  }
  
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
}


SWIGEXPORT jstring JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btShortIntIndexData_1pad_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  btShortIntIndexData *arg1 = (btShortIntIndexData *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btShortIntIndexData **)&jarg1; 
  result = (char *)(char *) ((arg1)->m_pad);
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_new_1btShortIntIndexData(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  btShortIntIndexData *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (btShortIntIndexData *)new btShortIntIndexData();
  *(btShortIntIndexData **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_delete_1btShortIntIndexData(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  btShortIntIndexData *arg1 = (btShortIntIndexData *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(btShortIntIndexData **)&jarg1; 
  delete arg1;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btShortIntIndexTripletData_1values_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jshortArray jarg2) {
  btShortIntIndexTripletData *arg1 = (btShortIntIndexTripletData *) 0 ;
  short *arg2 ;
  jshort *jarr2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btShortIntIndexTripletData **)&jarg1; 
  if (jarg2 && jenv->GetArrayLength(jarg2) != 3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, "incorrect array size");
    return ;
  }
  if (!SWIG_JavaArrayInShort(jenv, &jarr2, (short **)&arg2, jarg2)) return ; 
  {
    size_t ii;
    short *b = (short *) arg1->m_values;
    for (ii = 0; ii < (size_t)3; ii++) b[ii] = *((short *) arg2 + ii);
  }
  SWIG_JavaArrayArgoutShort(jenv, jarr2, (short *)arg2, jarg2); 
  delete [] arg2; 
}


SWIGEXPORT jshortArray JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btShortIntIndexTripletData_1values_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jshortArray jresult = 0 ;
  btShortIntIndexTripletData *arg1 = (btShortIntIndexTripletData *) 0 ;
  short *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btShortIntIndexTripletData **)&jarg1; 
  result = (short *)(short *) ((arg1)->m_values);
  jresult = SWIG_JavaArrayOutShort(jenv, (short *)result, 3); 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btShortIntIndexTripletData_1pad_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  btShortIntIndexTripletData *arg1 = (btShortIntIndexTripletData *) 0 ;
  char *arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btShortIntIndexTripletData **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return ;
  }
  {
    if(arg2) {
      strncpy((char*)arg1->m_pad, (const char *)arg2, 2-1);
      arg1->m_pad[2-1] = 0;
    } else {
      arg1->m_pad[0] = 0;
    }
  }
  
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
}


SWIGEXPORT jstring JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btShortIntIndexTripletData_1pad_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  btShortIntIndexTripletData *arg1 = (btShortIntIndexTripletData *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btShortIntIndexTripletData **)&jarg1; 
  result = (char *)(char *) ((arg1)->m_pad);
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_new_1btShortIntIndexTripletData(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  btShortIntIndexTripletData *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (btShortIntIndexTripletData *)new btShortIntIndexTripletData();
  *(btShortIntIndexTripletData **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_delete_1btShortIntIndexTripletData(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  btShortIntIndexTripletData *arg1 = (btShortIntIndexTripletData *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(btShortIntIndexTripletData **)&jarg1; 
  delete arg1;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btCharIndexTripletData_1values_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jshortArray jarg2) {
  btCharIndexTripletData *arg1 = (btCharIndexTripletData *) 0 ;
  unsigned char *arg2 ;
  jshort *jarr2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btCharIndexTripletData **)&jarg1; 
  if (jarg2 && jenv->GetArrayLength(jarg2) != 3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, "incorrect array size");
    return ;
  }
  if (!SWIG_JavaArrayInUchar(jenv, &jarr2, (unsigned char **)&arg2, jarg2)) return ; 
  {
    size_t ii;
    unsigned char *b = (unsigned char *) arg1->m_values;
    for (ii = 0; ii < (size_t)3; ii++) b[ii] = *((unsigned char *) arg2 + ii);
  }
  SWIG_JavaArrayArgoutUchar(jenv, jarr2, (unsigned char *)arg2, jarg2); 
  delete [] arg2; 
}


SWIGEXPORT jshortArray JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btCharIndexTripletData_1values_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jshortArray jresult = 0 ;
  btCharIndexTripletData *arg1 = (btCharIndexTripletData *) 0 ;
  unsigned char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btCharIndexTripletData **)&jarg1; 
  result = (unsigned char *)(unsigned char *) ((arg1)->m_values);
  jresult = SWIG_JavaArrayOutUchar(jenv, (unsigned char *)result, 3); 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btCharIndexTripletData_1pad_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jchar jarg2) {
  btCharIndexTripletData *arg1 = (btCharIndexTripletData *) 0 ;
  char arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btCharIndexTripletData **)&jarg1; 
  arg2 = (char)jarg2; 
  if (arg1) (arg1)->m_pad = arg2;
}


SWIGEXPORT jchar JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btCharIndexTripletData_1pad_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jchar jresult = 0 ;
  btCharIndexTripletData *arg1 = (btCharIndexTripletData *) 0 ;
  char result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btCharIndexTripletData **)&jarg1; 
  result = (char) ((arg1)->m_pad);
  jresult = (jchar)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_new_1btCharIndexTripletData(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  btCharIndexTripletData *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (btCharIndexTripletData *)new btCharIndexTripletData();
  *(btCharIndexTripletData **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_delete_1btCharIndexTripletData(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  btCharIndexTripletData *arg1 = (btCharIndexTripletData *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(btCharIndexTripletData **)&jarg1; 
  delete arg1;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btMeshPartData_1vertices3f_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btMeshPartData *arg1 = (btMeshPartData *) 0 ;
  btVector3FloatData *arg2 = (btVector3FloatData *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btMeshPartData **)&jarg1; 
  arg2 = *(btVector3FloatData **)&jarg2; 
  if (arg1) (arg1)->m_vertices3f = arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btMeshPartData_1vertices3f_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btMeshPartData *arg1 = (btMeshPartData *) 0 ;
  btVector3FloatData *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btMeshPartData **)&jarg1; 
  result = (btVector3FloatData *) ((arg1)->m_vertices3f);
  *(btVector3FloatData **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btMeshPartData_1vertices3d_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btMeshPartData *arg1 = (btMeshPartData *) 0 ;
  btVector3DoubleData *arg2 = (btVector3DoubleData *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btMeshPartData **)&jarg1; 
  arg2 = *(btVector3DoubleData **)&jarg2; 
  if (arg1) (arg1)->m_vertices3d = arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btMeshPartData_1vertices3d_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btMeshPartData *arg1 = (btMeshPartData *) 0 ;
  btVector3DoubleData *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btMeshPartData **)&jarg1; 
  result = (btVector3DoubleData *) ((arg1)->m_vertices3d);
  *(btVector3DoubleData **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btMeshPartData_1indices32_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btMeshPartData *arg1 = (btMeshPartData *) 0 ;
  btIntIndexData *arg2 = (btIntIndexData *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btMeshPartData **)&jarg1; 
  arg2 = *(btIntIndexData **)&jarg2; 
  if (arg1) (arg1)->m_indices32 = arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btMeshPartData_1indices32_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btMeshPartData *arg1 = (btMeshPartData *) 0 ;
  btIntIndexData *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btMeshPartData **)&jarg1; 
  result = (btIntIndexData *) ((arg1)->m_indices32);
  *(btIntIndexData **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btMeshPartData_13indices16_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btMeshPartData *arg1 = (btMeshPartData *) 0 ;
  btShortIntIndexTripletData *arg2 = (btShortIntIndexTripletData *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btMeshPartData **)&jarg1; 
  arg2 = *(btShortIntIndexTripletData **)&jarg2; 
  if (arg1) (arg1)->m_3indices16 = arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btMeshPartData_13indices16_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btMeshPartData *arg1 = (btMeshPartData *) 0 ;
  btShortIntIndexTripletData *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btMeshPartData **)&jarg1; 
  result = (btShortIntIndexTripletData *) ((arg1)->m_3indices16);
  *(btShortIntIndexTripletData **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btMeshPartData_13indices8_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btMeshPartData *arg1 = (btMeshPartData *) 0 ;
  btCharIndexTripletData *arg2 = (btCharIndexTripletData *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btMeshPartData **)&jarg1; 
  arg2 = *(btCharIndexTripletData **)&jarg2; 
  if (arg1) (arg1)->m_3indices8 = arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btMeshPartData_13indices8_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btMeshPartData *arg1 = (btMeshPartData *) 0 ;
  btCharIndexTripletData *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btMeshPartData **)&jarg1; 
  result = (btCharIndexTripletData *) ((arg1)->m_3indices8);
  *(btCharIndexTripletData **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btMeshPartData_1indices16_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btMeshPartData *arg1 = (btMeshPartData *) 0 ;
  btShortIntIndexData *arg2 = (btShortIntIndexData *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btMeshPartData **)&jarg1; 
  arg2 = *(btShortIntIndexData **)&jarg2; 
  if (arg1) (arg1)->m_indices16 = arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btMeshPartData_1indices16_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btMeshPartData *arg1 = (btMeshPartData *) 0 ;
  btShortIntIndexData *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btMeshPartData **)&jarg1; 
  result = (btShortIntIndexData *) ((arg1)->m_indices16);
  *(btShortIntIndexData **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btMeshPartData_1numTriangles_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  btMeshPartData *arg1 = (btMeshPartData *) 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btMeshPartData **)&jarg1; 
  arg2 = (int)jarg2; 
  if (arg1) (arg1)->m_numTriangles = arg2;
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btMeshPartData_1numTriangles_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  btMeshPartData *arg1 = (btMeshPartData *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btMeshPartData **)&jarg1; 
  result = (int) ((arg1)->m_numTriangles);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btMeshPartData_1numVertices_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  btMeshPartData *arg1 = (btMeshPartData *) 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btMeshPartData **)&jarg1; 
  arg2 = (int)jarg2; 
  if (arg1) (arg1)->m_numVertices = arg2;
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btMeshPartData_1numVertices_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  btMeshPartData *arg1 = (btMeshPartData *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btMeshPartData **)&jarg1; 
  result = (int) ((arg1)->m_numVertices);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_new_1btMeshPartData(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  btMeshPartData *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (btMeshPartData *)new btMeshPartData();
  *(btMeshPartData **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_delete_1btMeshPartData(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  btMeshPartData *arg1 = (btMeshPartData *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(btMeshPartData **)&jarg1; 
  delete arg1;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btStridingMeshInterfaceData_1meshPartsPtr_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btStridingMeshInterfaceData *arg1 = (btStridingMeshInterfaceData *) 0 ;
  btMeshPartData *arg2 = (btMeshPartData *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btStridingMeshInterfaceData **)&jarg1; 
  arg2 = *(btMeshPartData **)&jarg2; 
  if (arg1) (arg1)->m_meshPartsPtr = arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btStridingMeshInterfaceData_1meshPartsPtr_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btStridingMeshInterfaceData *arg1 = (btStridingMeshInterfaceData *) 0 ;
  btMeshPartData *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btStridingMeshInterfaceData **)&jarg1; 
  result = (btMeshPartData *) ((arg1)->m_meshPartsPtr);
  *(btMeshPartData **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btStridingMeshInterfaceData_1scaling_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btStridingMeshInterfaceData *arg1 = (btStridingMeshInterfaceData *) 0 ;
  btVector3FloatData *arg2 = (btVector3FloatData *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btStridingMeshInterfaceData **)&jarg1; 
  arg2 = *(btVector3FloatData **)&jarg2; 
  if (arg1) (arg1)->m_scaling = *arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btStridingMeshInterfaceData_1scaling_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btStridingMeshInterfaceData *arg1 = (btStridingMeshInterfaceData *) 0 ;
  btVector3FloatData *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btStridingMeshInterfaceData **)&jarg1; 
  result = (btVector3FloatData *)& ((arg1)->m_scaling);
  *(btVector3FloatData **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btStridingMeshInterfaceData_1numMeshParts_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  btStridingMeshInterfaceData *arg1 = (btStridingMeshInterfaceData *) 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btStridingMeshInterfaceData **)&jarg1; 
  arg2 = (int)jarg2; 
  if (arg1) (arg1)->m_numMeshParts = arg2;
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btStridingMeshInterfaceData_1numMeshParts_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  btStridingMeshInterfaceData *arg1 = (btStridingMeshInterfaceData *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btStridingMeshInterfaceData **)&jarg1; 
  result = (int) ((arg1)->m_numMeshParts);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btStridingMeshInterfaceData_1padding_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  btStridingMeshInterfaceData *arg1 = (btStridingMeshInterfaceData *) 0 ;
  char *arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btStridingMeshInterfaceData **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return ;
  }
  {
    if(arg2) {
      strncpy((char*)arg1->m_padding, (const char *)arg2, 4-1);
      arg1->m_padding[4-1] = 0;
    } else {
      arg1->m_padding[0] = 0;
    }
  }
  
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
}


SWIGEXPORT jstring JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btStridingMeshInterfaceData_1padding_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  btStridingMeshInterfaceData *arg1 = (btStridingMeshInterfaceData *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btStridingMeshInterfaceData **)&jarg1; 
  result = (char *)(char *) ((arg1)->m_padding);
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_new_1btStridingMeshInterfaceData(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  btStridingMeshInterfaceData *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (btStridingMeshInterfaceData *)new btStridingMeshInterfaceData();
  *(btStridingMeshInterfaceData **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_delete_1btStridingMeshInterfaceData(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  btStridingMeshInterfaceData *arg1 = (btStridingMeshInterfaceData *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(btStridingMeshInterfaceData **)&jarg1; 
  delete arg1;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_new_1btMinkowskiSumShape(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  jlong jresult = 0 ;
  btConvexShape *arg1 = (btConvexShape *) 0 ;
  btConvexShape *arg2 = (btConvexShape *) 0 ;
  btMinkowskiSumShape *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btConvexShape **)&jarg1; 
  arg2 = *(btConvexShape **)&jarg2; 
  result = (btMinkowskiSumShape *)new btMinkowskiSumShape((btConvexShape const *)arg1,(btConvexShape const *)arg2);
  *(btMinkowskiSumShape **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btMinkowskiSumShape_1setTransformA(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2) {
  btMinkowskiSumShape *arg1 = (btMinkowskiSumShape *) 0 ;
  btTransform *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btMinkowskiSumShape **)&jarg1; 
  btTransform local_arg2;
  gdx_setbtTransformFromMatrix4(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitMatrix4 auto_commit_arg2(jenv, jarg2, &local_arg2);
  (arg1)->setTransformA((btTransform const &)*arg2);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btMinkowskiSumShape_1setTransformB(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2) {
  btMinkowskiSumShape *arg1 = (btMinkowskiSumShape *) 0 ;
  btTransform *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btMinkowskiSumShape **)&jarg1; 
  btTransform local_arg2;
  gdx_setbtTransformFromMatrix4(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitMatrix4 auto_commit_arg2(jenv, jarg2, &local_arg2);
  (arg1)->setTransformB((btTransform const &)*arg2);
}


SWIGEXPORT jobject JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btMinkowskiSumShape_1getTransformA(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jobject jresult = 0 ;
  btMinkowskiSumShape *arg1 = (btMinkowskiSumShape *) 0 ;
  btTransform *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btMinkowskiSumShape **)&jarg1; 
  result = (btTransform *) &((btMinkowskiSumShape const *)arg1)->getTransformA();
  jresult = gdx_getReturnMatrix4(jenv);
  gdx_setMatrix4FrombtTransform(jenv, jresult, result);
  return jresult;
}


SWIGEXPORT jobject JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btMinkowskiSumShape_1GetTransformB(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jobject jresult = 0 ;
  btMinkowskiSumShape *arg1 = (btMinkowskiSumShape *) 0 ;
  btTransform *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btMinkowskiSumShape **)&jarg1; 
  result = (btTransform *) &((btMinkowskiSumShape const *)arg1)->GetTransformB();
  jresult = gdx_getReturnMatrix4(jenv);
  gdx_setMatrix4FrombtTransform(jenv, jresult, result);
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btMinkowskiSumShape_1getShapeA(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btMinkowskiSumShape *arg1 = (btMinkowskiSumShape *) 0 ;
  btConvexShape *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btMinkowskiSumShape **)&jarg1; 
  result = (btConvexShape *)((btMinkowskiSumShape const *)arg1)->getShapeA();
  *(btConvexShape **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btMinkowskiSumShape_1getShapeB(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btMinkowskiSumShape *arg1 = (btMinkowskiSumShape *) 0 ;
  btConvexShape *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btMinkowskiSumShape **)&jarg1; 
  result = (btConvexShape *)((btMinkowskiSumShape const *)arg1)->getShapeB();
  *(btConvexShape **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_delete_1btMinkowskiSumShape(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  btMinkowskiSumShape *arg1 = (btMinkowskiSumShape *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(btMinkowskiSumShape **)&jarg1; 
  delete arg1;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btFace_1indices_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  btFace *arg1 = (btFace *) 0 ;
  btAlignedObjectArray< int > *arg2 = (btAlignedObjectArray< int > *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btFace **)&jarg1; 
  arg2 = *(btAlignedObjectArray< int > **)&jarg2; 
  if (arg1) (arg1)->m_indices = *arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btFace_1indices_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btFace *arg1 = (btFace *) 0 ;
  btAlignedObjectArray< int > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btFace **)&jarg1; 
  result = (btAlignedObjectArray< int > *)& ((arg1)->m_indices);
  *(btAlignedObjectArray< int > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btFace_1plane_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloatArray jarg2) {
  btFace *arg1 = (btFace *) 0 ;
  btScalar *arg2 ;
  jfloat *jarr2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btFace **)&jarg1; 
  if (jarg2 && jenv->GetArrayLength(jarg2) != 4) {
    SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, "incorrect array size");
    return ;
  }
  if (!SWIG_JavaArrayInFloat(jenv, &jarr2, (float **)&arg2, jarg2)) return ; 
  {
    size_t ii;
    btScalar *b = (btScalar *) arg1->m_plane;
    for (ii = 0; ii < (size_t)4; ii++) b[ii] = *((btScalar *) arg2 + ii);
  }
  SWIG_JavaArrayArgoutFloat(jenv, jarr2, (float *)arg2, jarg2); 
  delete [] arg2; 
}


SWIGEXPORT jfloatArray JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btFace_1plane_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jfloatArray jresult = 0 ;
  btFace *arg1 = (btFace *) 0 ;
  btScalar *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btFace **)&jarg1; 
  result = (btScalar *)(btScalar *) ((arg1)->m_plane);
  jresult = SWIG_JavaArrayOutFloat(jenv, (float *)result, 4); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_new_1btFace(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  btFace *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (btFace *)new btFace();
  *(btFace **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_delete_1btFace(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  btFace *arg1 = (btFace *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(btFace **)&jarg1; 
  delete arg1;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_new_1btConvexPolyhedron(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  btConvexPolyhedron *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (btConvexPolyhedron *)new btConvexPolyhedron();
  *(btConvexPolyhedron **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_delete_1btConvexPolyhedron(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  btConvexPolyhedron *arg1 = (btConvexPolyhedron *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(btConvexPolyhedron **)&jarg1; 
  delete arg1;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btConvexPolyhedron_1vertices_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btConvexPolyhedron *arg1 = (btConvexPolyhedron *) 0 ;
  btAlignedObjectArray< btVector3 > *arg2 = (btAlignedObjectArray< btVector3 > *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btConvexPolyhedron **)&jarg1; 
  arg2 = *(btAlignedObjectArray< btVector3 > **)&jarg2; 
  if (arg1) (arg1)->m_vertices = *arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btConvexPolyhedron_1vertices_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btConvexPolyhedron *arg1 = (btConvexPolyhedron *) 0 ;
  btAlignedObjectArray< btVector3 > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btConvexPolyhedron **)&jarg1; 
  result = (btAlignedObjectArray< btVector3 > *)& ((arg1)->m_vertices);
  *(btAlignedObjectArray< btVector3 > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btConvexPolyhedron_1faces_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  btConvexPolyhedron *arg1 = (btConvexPolyhedron *) 0 ;
  btAlignedObjectArray< btFace > *arg2 = (btAlignedObjectArray< btFace > *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btConvexPolyhedron **)&jarg1; 
  arg2 = *(btAlignedObjectArray< btFace > **)&jarg2; 
  if (arg1) (arg1)->m_faces = *arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btConvexPolyhedron_1faces_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btConvexPolyhedron *arg1 = (btConvexPolyhedron *) 0 ;
  btAlignedObjectArray< btFace > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btConvexPolyhedron **)&jarg1; 
  result = (btAlignedObjectArray< btFace > *)& ((arg1)->m_faces);
  *(btAlignedObjectArray< btFace > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btConvexPolyhedron_1uniqueEdges_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btConvexPolyhedron *arg1 = (btConvexPolyhedron *) 0 ;
  btAlignedObjectArray< btVector3 > *arg2 = (btAlignedObjectArray< btVector3 > *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btConvexPolyhedron **)&jarg1; 
  arg2 = *(btAlignedObjectArray< btVector3 > **)&jarg2; 
  if (arg1) (arg1)->m_uniqueEdges = *arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btConvexPolyhedron_1uniqueEdges_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btConvexPolyhedron *arg1 = (btConvexPolyhedron *) 0 ;
  btAlignedObjectArray< btVector3 > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btConvexPolyhedron **)&jarg1; 
  result = (btAlignedObjectArray< btVector3 > *)& ((arg1)->m_uniqueEdges);
  *(btAlignedObjectArray< btVector3 > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btConvexPolyhedron_1localCenter_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btConvexPolyhedron *arg1 = (btConvexPolyhedron *) 0 ;
  btVector3 *arg2 = (btVector3 *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btConvexPolyhedron **)&jarg1; 
  arg2 = *(btVector3 **)&jarg2; 
  if (arg1) (arg1)->m_localCenter = *arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btConvexPolyhedron_1localCenter_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btConvexPolyhedron *arg1 = (btConvexPolyhedron *) 0 ;
  btVector3 *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btConvexPolyhedron **)&jarg1; 
  result = (btVector3 *)& ((arg1)->m_localCenter);
  *(btVector3 **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btConvexPolyhedron_1extents_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btConvexPolyhedron *arg1 = (btConvexPolyhedron *) 0 ;
  btVector3 *arg2 = (btVector3 *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btConvexPolyhedron **)&jarg1; 
  arg2 = *(btVector3 **)&jarg2; 
  if (arg1) (arg1)->m_extents = *arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btConvexPolyhedron_1extents_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btConvexPolyhedron *arg1 = (btConvexPolyhedron *) 0 ;
  btVector3 *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btConvexPolyhedron **)&jarg1; 
  result = (btVector3 *)& ((arg1)->m_extents);
  *(btVector3 **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btConvexPolyhedron_1radius_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2) {
  btConvexPolyhedron *arg1 = (btConvexPolyhedron *) 0 ;
  btScalar arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btConvexPolyhedron **)&jarg1; 
  arg2 = (btScalar)jarg2; 
  if (arg1) (arg1)->m_radius = arg2;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btConvexPolyhedron_1radius_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jfloat jresult = 0 ;
  btConvexPolyhedron *arg1 = (btConvexPolyhedron *) 0 ;
  btScalar result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btConvexPolyhedron **)&jarg1; 
  result = (btScalar) ((arg1)->m_radius);
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btConvexPolyhedron_1mC_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btConvexPolyhedron *arg1 = (btConvexPolyhedron *) 0 ;
  btVector3 *arg2 = (btVector3 *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btConvexPolyhedron **)&jarg1; 
  arg2 = *(btVector3 **)&jarg2; 
  if (arg1) (arg1)->mC = *arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btConvexPolyhedron_1mC_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btConvexPolyhedron *arg1 = (btConvexPolyhedron *) 0 ;
  btVector3 *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btConvexPolyhedron **)&jarg1; 
  result = (btVector3 *)& ((arg1)->mC);
  *(btVector3 **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btConvexPolyhedron_1mE_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btConvexPolyhedron *arg1 = (btConvexPolyhedron *) 0 ;
  btVector3 *arg2 = (btVector3 *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btConvexPolyhedron **)&jarg1; 
  arg2 = *(btVector3 **)&jarg2; 
  if (arg1) (arg1)->mE = *arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btConvexPolyhedron_1mE_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btConvexPolyhedron *arg1 = (btConvexPolyhedron *) 0 ;
  btVector3 *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btConvexPolyhedron **)&jarg1; 
  result = (btVector3 *)& ((arg1)->mE);
  *(btVector3 **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btConvexPolyhedron_1initialize(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  btConvexPolyhedron *arg1 = (btConvexPolyhedron *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btConvexPolyhedron **)&jarg1; 
  (arg1)->initialize();
}


SWIGEXPORT jboolean JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btConvexPolyhedron_1testContainment(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  btConvexPolyhedron *arg1 = (btConvexPolyhedron *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btConvexPolyhedron **)&jarg1; 
  result = (bool)((btConvexPolyhedron const *)arg1)->testContainment();
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btConvexPolyhedron_1project(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2, jobject jarg3, jlong jarg4, jlong jarg5, jobject jarg6, jobject jarg7) {
  btConvexPolyhedron *arg1 = (btConvexPolyhedron *) 0 ;
  btTransform *arg2 = 0 ;
  btVector3 *arg3 = 0 ;
  btScalar *arg4 = 0 ;
  btScalar *arg5 = 0 ;
  btVector3 *arg6 = 0 ;
  btVector3 *arg7 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btConvexPolyhedron **)&jarg1; 
  btTransform local_arg2;
  gdx_setbtTransformFromMatrix4(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitMatrix4 auto_commit_arg2(jenv, jarg2, &local_arg2);
  btVector3 local_arg3;
  gdx_setbtVector3FromVector3(jenv, local_arg3, jarg3);
  arg3 = &local_arg3;
  gdxAutoCommitVector3 auto_commit_arg3(jenv, jarg3, &local_arg3);
  arg4 = *(btScalar **)&jarg4;
  if (!arg4) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btScalar & reference is null");
    return ;
  } 
  arg5 = *(btScalar **)&jarg5;
  if (!arg5) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btScalar & reference is null");
    return ;
  } 
  btVector3 local_arg6;
  gdx_setbtVector3FromVector3(jenv, local_arg6, jarg6);
  arg6 = &local_arg6;
  gdxAutoCommitVector3 auto_commit_arg6(jenv, jarg6, &local_arg6);
  btVector3 local_arg7;
  gdx_setbtVector3FromVector3(jenv, local_arg7, jarg7);
  arg7 = &local_arg7;
  gdxAutoCommitVector3 auto_commit_arg7(jenv, jarg7, &local_arg7);
  ((btConvexPolyhedron const *)arg1)->project((btTransform const &)*arg2,(btVector3 const &)*arg3,*arg4,*arg5,*arg6,*arg7);
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_new_1btOptimizedBvh(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  btOptimizedBvh *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (btOptimizedBvh *)new btOptimizedBvh();
  *(btOptimizedBvh **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_delete_1btOptimizedBvh(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  btOptimizedBvh *arg1 = (btOptimizedBvh *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(btOptimizedBvh **)&jarg1; 
  delete arg1;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btOptimizedBvh_1build(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jboolean jarg3, jobject jarg4, jobject jarg5) {
  btOptimizedBvh *arg1 = (btOptimizedBvh *) 0 ;
  btStridingMeshInterface *arg2 = (btStridingMeshInterface *) 0 ;
  bool arg3 ;
  btVector3 *arg4 = 0 ;
  btVector3 *arg5 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btOptimizedBvh **)&jarg1; 
  arg2 = *(btStridingMeshInterface **)&jarg2; 
  arg3 = jarg3 ? true : false; 
  btVector3 local_arg4;
  gdx_setbtVector3FromVector3(jenv, local_arg4, jarg4);
  arg4 = &local_arg4;
  gdxAutoCommitVector3 auto_commit_arg4(jenv, jarg4, &local_arg4);
  btVector3 local_arg5;
  gdx_setbtVector3FromVector3(jenv, local_arg5, jarg5);
  arg5 = &local_arg5;
  gdxAutoCommitVector3 auto_commit_arg5(jenv, jarg5, &local_arg5);
  (arg1)->build(arg2,arg3,(btVector3 const &)*arg4,(btVector3 const &)*arg5);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btOptimizedBvh_1refit(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jobject jarg3, jobject jarg4) {
  btOptimizedBvh *arg1 = (btOptimizedBvh *) 0 ;
  btStridingMeshInterface *arg2 = (btStridingMeshInterface *) 0 ;
  btVector3 *arg3 = 0 ;
  btVector3 *arg4 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btOptimizedBvh **)&jarg1; 
  arg2 = *(btStridingMeshInterface **)&jarg2; 
  btVector3 local_arg3;
  gdx_setbtVector3FromVector3(jenv, local_arg3, jarg3);
  arg3 = &local_arg3;
  gdxAutoCommitVector3 auto_commit_arg3(jenv, jarg3, &local_arg3);
  btVector3 local_arg4;
  gdx_setbtVector3FromVector3(jenv, local_arg4, jarg4);
  arg4 = &local_arg4;
  gdxAutoCommitVector3 auto_commit_arg4(jenv, jarg4, &local_arg4);
  (arg1)->refit(arg2,(btVector3 const &)*arg3,(btVector3 const &)*arg4);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btOptimizedBvh_1refitPartial(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jobject jarg3, jobject jarg4) {
  btOptimizedBvh *arg1 = (btOptimizedBvh *) 0 ;
  btStridingMeshInterface *arg2 = (btStridingMeshInterface *) 0 ;
  btVector3 *arg3 = 0 ;
  btVector3 *arg4 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btOptimizedBvh **)&jarg1; 
  arg2 = *(btStridingMeshInterface **)&jarg2; 
  btVector3 local_arg3;
  gdx_setbtVector3FromVector3(jenv, local_arg3, jarg3);
  arg3 = &local_arg3;
  gdxAutoCommitVector3 auto_commit_arg3(jenv, jarg3, &local_arg3);
  btVector3 local_arg4;
  gdx_setbtVector3FromVector3(jenv, local_arg4, jarg4);
  arg4 = &local_arg4;
  gdxAutoCommitVector3 auto_commit_arg4(jenv, jarg4, &local_arg4);
  (arg1)->refitPartial(arg2,(btVector3 const &)*arg3,(btVector3 const &)*arg4);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btOptimizedBvh_1updateBvhNodes(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jint jarg3, jint jarg4, jint jarg5) {
  btOptimizedBvh *arg1 = (btOptimizedBvh *) 0 ;
  btStridingMeshInterface *arg2 = (btStridingMeshInterface *) 0 ;
  int arg3 ;
  int arg4 ;
  int arg5 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btOptimizedBvh **)&jarg1; 
  arg2 = *(btStridingMeshInterface **)&jarg2; 
  arg3 = (int)jarg3; 
  arg4 = (int)jarg4; 
  arg5 = (int)jarg5; 
  (arg1)->updateBvhNodes(arg2,arg3,arg4,arg5);
}


SWIGEXPORT jboolean JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btOptimizedBvh_1serializeInPlace(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jlong jarg3, jboolean jarg4) {
  jboolean jresult = 0 ;
  btOptimizedBvh *arg1 = (btOptimizedBvh *) 0 ;
  void *arg2 = (void *) 0 ;
  unsigned int arg3 ;
  bool arg4 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btOptimizedBvh **)&jarg1; 
  arg2 = (void *)jarg2; 
  arg3 = (unsigned int)jarg3; 
  arg4 = jarg4 ? true : false; 
  result = (bool)((btOptimizedBvh const *)arg1)->serializeInPlace(arg2,arg3,arg4);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btOptimizedBvh_1deSerializeInPlace(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2, jboolean jarg3) {
  jlong jresult = 0 ;
  void *arg1 = (void *) 0 ;
  unsigned int arg2 ;
  bool arg3 ;
  btOptimizedBvh *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (void *)jarg1; 
  arg2 = (unsigned int)jarg2; 
  arg3 = jarg3 ? true : false; 
  result = (btOptimizedBvh *)btOptimizedBvh::deSerializeInPlace(arg1,arg2,arg3);
  *(btOptimizedBvh **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btTriangle_1vertex0_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btTriangle *arg1 = (btTriangle *) 0 ;
  btVector3 *arg2 = (btVector3 *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btTriangle **)&jarg1; 
  arg2 = *(btVector3 **)&jarg2; 
  if (arg1) (arg1)->m_vertex0 = *arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btTriangle_1vertex0_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btTriangle *arg1 = (btTriangle *) 0 ;
  btVector3 *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btTriangle **)&jarg1; 
  result = (btVector3 *)& ((arg1)->m_vertex0);
  *(btVector3 **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btTriangle_1vertex1_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btTriangle *arg1 = (btTriangle *) 0 ;
  btVector3 *arg2 = (btVector3 *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btTriangle **)&jarg1; 
  arg2 = *(btVector3 **)&jarg2; 
  if (arg1) (arg1)->m_vertex1 = *arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btTriangle_1vertex1_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btTriangle *arg1 = (btTriangle *) 0 ;
  btVector3 *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btTriangle **)&jarg1; 
  result = (btVector3 *)& ((arg1)->m_vertex1);
  *(btVector3 **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btTriangle_1vertex2_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btTriangle *arg1 = (btTriangle *) 0 ;
  btVector3 *arg2 = (btVector3 *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btTriangle **)&jarg1; 
  arg2 = *(btVector3 **)&jarg2; 
  if (arg1) (arg1)->m_vertex2 = *arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btTriangle_1vertex2_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btTriangle *arg1 = (btTriangle *) 0 ;
  btVector3 *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btTriangle **)&jarg1; 
  result = (btVector3 *)& ((arg1)->m_vertex2);
  *(btVector3 **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btTriangle_1partId_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  btTriangle *arg1 = (btTriangle *) 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btTriangle **)&jarg1; 
  arg2 = (int)jarg2; 
  if (arg1) (arg1)->m_partId = arg2;
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btTriangle_1partId_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  btTriangle *arg1 = (btTriangle *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btTriangle **)&jarg1; 
  result = (int) ((arg1)->m_partId);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btTriangle_1triangleIndex_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  btTriangle *arg1 = (btTriangle *) 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btTriangle **)&jarg1; 
  arg2 = (int)jarg2; 
  if (arg1) (arg1)->m_triangleIndex = arg2;
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btTriangle_1triangleIndex_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  btTriangle *arg1 = (btTriangle *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btTriangle **)&jarg1; 
  result = (int) ((arg1)->m_triangleIndex);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_new_1btTriangle(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  btTriangle *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (btTriangle *)new btTriangle();
  *(btTriangle **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_delete_1btTriangle(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  btTriangle *arg1 = (btTriangle *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(btTriangle **)&jarg1; 
  delete arg1;
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btTriangleBuffer_1getNumTriangles(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  btTriangleBuffer *arg1 = (btTriangleBuffer *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btTriangleBuffer **)&jarg1; 
  result = (int)((btTriangleBuffer const *)arg1)->getNumTriangles();
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btTriangleBuffer_1getTriangle(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  jlong jresult = 0 ;
  btTriangleBuffer *arg1 = (btTriangleBuffer *) 0 ;
  int arg2 ;
  btTriangle *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btTriangleBuffer **)&jarg1; 
  arg2 = (int)jarg2; 
  result = (btTriangle *) &((btTriangleBuffer const *)arg1)->getTriangle(arg2);
  *(btTriangle **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btTriangleBuffer_1clearBuffer(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  btTriangleBuffer *arg1 = (btTriangleBuffer *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btTriangleBuffer **)&jarg1; 
  (arg1)->clearBuffer();
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_new_1btTriangleBuffer(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  btTriangleBuffer *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (btTriangleBuffer *)new btTriangleBuffer();
  *(btTriangleBuffer **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_delete_1btTriangleBuffer(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  btTriangleBuffer *arg1 = (btTriangleBuffer *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(btTriangleBuffer **)&jarg1; 
  delete arg1;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btIndexedMesh_1numTriangles_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  btIndexedMesh *arg1 = (btIndexedMesh *) 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btIndexedMesh **)&jarg1; 
  arg2 = (int)jarg2; 
  if (arg1) (arg1)->m_numTriangles = arg2;
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btIndexedMesh_1numTriangles_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  btIndexedMesh *arg1 = (btIndexedMesh *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btIndexedMesh **)&jarg1; 
  result = (int) ((arg1)->m_numTriangles);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btIndexedMesh_1triangleIndexBase_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2) {
  btIndexedMesh *arg1 = (btIndexedMesh *) 0 ;
  unsigned char *arg2 = (unsigned char *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btIndexedMesh **)&jarg1; 
  {
    arg2 = (unsigned char*)jenv->GetDirectBufferAddress(jarg2);
    if (arg2 == NULL) {
      SWIG_JavaThrowException(jenv, SWIG_JavaRuntimeException, "Unable to get address of direct buffer. Buffer must be allocated direct.");
    }
  }
  {
    if (arg2) {
      arg1->m_triangleIndexBase = arg2;
    } else {
      arg1->m_triangleIndexBase = 0;
    }
  }
  
}


SWIGEXPORT jobject JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btIndexedMesh_1triangleIndexBase_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jobject jresult = 0 ;
  btIndexedMesh *arg1 = (btIndexedMesh *) 0 ;
  unsigned char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btIndexedMesh **)&jarg1; 
  result = (unsigned char *) ((arg1)->m_triangleIndexBase);
  *(unsigned char **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btIndexedMesh_1triangleIndexStride_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  btIndexedMesh *arg1 = (btIndexedMesh *) 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btIndexedMesh **)&jarg1; 
  arg2 = (int)jarg2; 
  if (arg1) (arg1)->m_triangleIndexStride = arg2;
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btIndexedMesh_1triangleIndexStride_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  btIndexedMesh *arg1 = (btIndexedMesh *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btIndexedMesh **)&jarg1; 
  result = (int) ((arg1)->m_triangleIndexStride);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btIndexedMesh_1numVertices_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  btIndexedMesh *arg1 = (btIndexedMesh *) 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btIndexedMesh **)&jarg1; 
  arg2 = (int)jarg2; 
  if (arg1) (arg1)->m_numVertices = arg2;
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btIndexedMesh_1numVertices_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  btIndexedMesh *arg1 = (btIndexedMesh *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btIndexedMesh **)&jarg1; 
  result = (int) ((arg1)->m_numVertices);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btIndexedMesh_1vertexBase_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2) {
  btIndexedMesh *arg1 = (btIndexedMesh *) 0 ;
  unsigned char *arg2 = (unsigned char *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btIndexedMesh **)&jarg1; 
  {
    arg2 = (unsigned char*)jenv->GetDirectBufferAddress(jarg2);
    if (arg2 == NULL) {
      SWIG_JavaThrowException(jenv, SWIG_JavaRuntimeException, "Unable to get address of direct buffer. Buffer must be allocated direct.");
    }
  }
  {
    if (arg2) {
      arg1->m_vertexBase = arg2;
    } else {
      arg1->m_vertexBase = 0;
    }
  }
  
}


SWIGEXPORT jobject JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btIndexedMesh_1vertexBase_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jobject jresult = 0 ;
  btIndexedMesh *arg1 = (btIndexedMesh *) 0 ;
  unsigned char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btIndexedMesh **)&jarg1; 
  result = (unsigned char *) ((arg1)->m_vertexBase);
  *(unsigned char **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btIndexedMesh_1vertexStride_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  btIndexedMesh *arg1 = (btIndexedMesh *) 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btIndexedMesh **)&jarg1; 
  arg2 = (int)jarg2; 
  if (arg1) (arg1)->m_vertexStride = arg2;
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btIndexedMesh_1vertexStride_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  btIndexedMesh *arg1 = (btIndexedMesh *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btIndexedMesh **)&jarg1; 
  result = (int) ((arg1)->m_vertexStride);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btIndexedMesh_1indexType_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  btIndexedMesh *arg1 = (btIndexedMesh *) 0 ;
  PHY_ScalarType arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btIndexedMesh **)&jarg1; 
  arg2 = (PHY_ScalarType)jarg2; 
  if (arg1) (arg1)->m_indexType = arg2;
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btIndexedMesh_1indexType_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  btIndexedMesh *arg1 = (btIndexedMesh *) 0 ;
  PHY_ScalarType result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btIndexedMesh **)&jarg1; 
  result = (PHY_ScalarType) ((arg1)->m_indexType);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btIndexedMesh_1vertexType_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  btIndexedMesh *arg1 = (btIndexedMesh *) 0 ;
  PHY_ScalarType arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btIndexedMesh **)&jarg1; 
  arg2 = (PHY_ScalarType)jarg2; 
  if (arg1) (arg1)->m_vertexType = arg2;
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btIndexedMesh_1vertexType_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  btIndexedMesh *arg1 = (btIndexedMesh *) 0 ;
  PHY_ScalarType result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btIndexedMesh **)&jarg1; 
  result = (PHY_ScalarType) ((arg1)->m_vertexType);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_new_1btIndexedMesh(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  btIndexedMesh *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (btIndexedMesh *)new btIndexedMesh();
  *(btIndexedMesh **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btIndexedMesh_1setTriangleIndexBase(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2) {
  btIndexedMesh *arg1 = (btIndexedMesh *) 0 ;
  short *arg2 = (short *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btIndexedMesh **)&jarg1; 
  {
    arg2 = (short*)jenv->GetDirectBufferAddress(jarg2);
    if (arg2 == NULL) {
      SWIG_JavaThrowException(jenv, SWIG_JavaRuntimeException, "Unable to get address of direct buffer. Buffer must be allocated direct.");
    }
  }
  btIndexedMesh_setTriangleIndexBase(arg1,arg2);
  
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btIndexedMesh_1setVertexBase(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2) {
  btIndexedMesh *arg1 = (btIndexedMesh *) 0 ;
  float *arg2 = (float *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btIndexedMesh **)&jarg1; 
  {
    arg2 = (float*)jenv->GetDirectBufferAddress(jarg2);
    if (arg2 == NULL) {
      SWIG_JavaThrowException(jenv, SWIG_JavaRuntimeException, "Unable to get address of direct buffer. Buffer must be allocated direct.");
    }
  }
  btIndexedMesh_setVertexBase(arg1,arg2);
  
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btIndexedMesh_1setVertices(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2, jint jarg3, jint jarg4, jint jarg5) {
  btIndexedMesh *arg1 = (btIndexedMesh *) 0 ;
  float *arg2 = (float *) 0 ;
  int arg3 ;
  int arg4 ;
  int arg5 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btIndexedMesh **)&jarg1; 
  {
    arg2 = (float*)jenv->GetDirectBufferAddress(jarg2);
    if (arg2 == NULL) {
      SWIG_JavaThrowException(jenv, SWIG_JavaRuntimeException, "Unable to get address of direct buffer. Buffer must be allocated direct.");
    }
  }
  arg3 = (int)jarg3; 
  arg4 = (int)jarg4; 
  arg5 = (int)jarg5; 
  btIndexedMesh_setVertices(arg1,arg2,arg3,arg4,arg5);
  
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btIndexedMesh_1setIndices(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2, jint jarg3, jint jarg4) {
  btIndexedMesh *arg1 = (btIndexedMesh *) 0 ;
  short *arg2 = (short *) 0 ;
  int arg3 ;
  int arg4 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btIndexedMesh **)&jarg1; 
  {
    arg2 = (short*)jenv->GetDirectBufferAddress(jarg2);
    if (arg2 == NULL) {
      SWIG_JavaThrowException(jenv, SWIG_JavaRuntimeException, "Unable to get address of direct buffer. Buffer must be allocated direct.");
    }
  }
  arg3 = (int)jarg3; 
  arg4 = (int)jarg4; 
  btIndexedMesh_setIndices(arg1,arg2,arg3,arg4);
  
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_delete_1btIndexedMesh(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  btIndexedMesh *arg1 = (btIndexedMesh *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(btIndexedMesh **)&jarg1; 
  delete arg1;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_new_1btTriangleIndexVertexArray(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  btTriangleIndexVertexArray *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (btTriangleIndexVertexArray *)new btTriangleIndexVertexArray();
  *(btTriangleIndexVertexArray **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_delete_1btTriangleIndexVertexArray(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  btTriangleIndexVertexArray *arg1 = (btTriangleIndexVertexArray *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(btTriangleIndexVertexArray **)&jarg1; 
  delete arg1;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btTriangleIndexVertexArray_1internalAddIndexedMesh_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jint jarg3) {
  btTriangleIndexVertexArray *arg1 = (btTriangleIndexVertexArray *) 0 ;
  btIndexedMesh *arg2 = 0 ;
  PHY_ScalarType arg3 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btTriangleIndexVertexArray **)&jarg1; 
  arg2 = *(btIndexedMesh **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btIndexedMesh const & reference is null");
    return ;
  } 
  arg3 = (PHY_ScalarType)jarg3; 
  (arg1)->addIndexedMesh((btIndexedMesh const &)*arg2,arg3);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btTriangleIndexVertexArray_1internalAddIndexedMesh_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btTriangleIndexVertexArray *arg1 = (btTriangleIndexVertexArray *) 0 ;
  btIndexedMesh *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btTriangleIndexVertexArray **)&jarg1; 
  arg2 = *(btIndexedMesh **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btIndexedMesh const & reference is null");
    return ;
  } 
  (arg1)->addIndexedMesh((btIndexedMesh const &)*arg2);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btTriangleIndexVertexArray_1getLockedVertexIndexBase_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jlong jarg3, jlong jarg4, jlong jarg5, jlong jarg6, jlong jarg7, jlong jarg8, jlong jarg9, jint jarg10) {
  btTriangleIndexVertexArray *arg1 = (btTriangleIndexVertexArray *) 0 ;
  unsigned char **arg2 = (unsigned char **) 0 ;
  int *arg3 = 0 ;
  PHY_ScalarType *arg4 = 0 ;
  int *arg5 = 0 ;
  unsigned char **arg6 = (unsigned char **) 0 ;
  int *arg7 = 0 ;
  int *arg8 = 0 ;
  PHY_ScalarType *arg9 = 0 ;
  int arg10 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btTriangleIndexVertexArray **)&jarg1; 
  arg2 = *(unsigned char ***)&jarg2; 
  arg3 = *(int **)&jarg3;
  if (!arg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "int & reference is null");
    return ;
  } 
  arg4 = *(PHY_ScalarType **)&jarg4;
  if (!arg4) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "PHY_ScalarType & reference is null");
    return ;
  } 
  arg5 = *(int **)&jarg5;
  if (!arg5) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "int & reference is null");
    return ;
  } 
  arg6 = *(unsigned char ***)&jarg6; 
  arg7 = *(int **)&jarg7;
  if (!arg7) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "int & reference is null");
    return ;
  } 
  arg8 = *(int **)&jarg8;
  if (!arg8) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "int & reference is null");
    return ;
  } 
  arg9 = *(PHY_ScalarType **)&jarg9;
  if (!arg9) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "PHY_ScalarType & reference is null");
    return ;
  } 
  arg10 = (int)jarg10; 
  (arg1)->getLockedVertexIndexBase(arg2,*arg3,*arg4,*arg5,arg6,*arg7,*arg8,*arg9,arg10);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btTriangleIndexVertexArray_1getLockedVertexIndexBase_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jlong jarg3, jlong jarg4, jlong jarg5, jlong jarg6, jlong jarg7, jlong jarg8, jlong jarg9) {
  btTriangleIndexVertexArray *arg1 = (btTriangleIndexVertexArray *) 0 ;
  unsigned char **arg2 = (unsigned char **) 0 ;
  int *arg3 = 0 ;
  PHY_ScalarType *arg4 = 0 ;
  int *arg5 = 0 ;
  unsigned char **arg6 = (unsigned char **) 0 ;
  int *arg7 = 0 ;
  int *arg8 = 0 ;
  PHY_ScalarType *arg9 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btTriangleIndexVertexArray **)&jarg1; 
  arg2 = *(unsigned char ***)&jarg2; 
  arg3 = *(int **)&jarg3;
  if (!arg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "int & reference is null");
    return ;
  } 
  arg4 = *(PHY_ScalarType **)&jarg4;
  if (!arg4) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "PHY_ScalarType & reference is null");
    return ;
  } 
  arg5 = *(int **)&jarg5;
  if (!arg5) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "int & reference is null");
    return ;
  } 
  arg6 = *(unsigned char ***)&jarg6; 
  arg7 = *(int **)&jarg7;
  if (!arg7) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "int & reference is null");
    return ;
  } 
  arg8 = *(int **)&jarg8;
  if (!arg8) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "int & reference is null");
    return ;
  } 
  arg9 = *(PHY_ScalarType **)&jarg9;
  if (!arg9) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "PHY_ScalarType & reference is null");
    return ;
  } 
  (arg1)->getLockedVertexIndexBase(arg2,*arg3,*arg4,*arg5,arg6,*arg7,*arg8,*arg9);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btTriangleIndexVertexArray_1getLockedReadOnlyVertexIndexBase_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jlong jarg3, jlong jarg4, jlong jarg5, jlong jarg6, jlong jarg7, jlong jarg8, jlong jarg9, jint jarg10) {
  btTriangleIndexVertexArray *arg1 = (btTriangleIndexVertexArray *) 0 ;
  unsigned char **arg2 = (unsigned char **) 0 ;
  int *arg3 = 0 ;
  PHY_ScalarType *arg4 = 0 ;
  int *arg5 = 0 ;
  unsigned char **arg6 = (unsigned char **) 0 ;
  int *arg7 = 0 ;
  int *arg8 = 0 ;
  PHY_ScalarType *arg9 = 0 ;
  int arg10 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btTriangleIndexVertexArray **)&jarg1; 
  arg2 = *(unsigned char ***)&jarg2; 
  arg3 = *(int **)&jarg3;
  if (!arg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "int & reference is null");
    return ;
  } 
  arg4 = *(PHY_ScalarType **)&jarg4;
  if (!arg4) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "PHY_ScalarType & reference is null");
    return ;
  } 
  arg5 = *(int **)&jarg5;
  if (!arg5) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "int & reference is null");
    return ;
  } 
  arg6 = *(unsigned char ***)&jarg6; 
  arg7 = *(int **)&jarg7;
  if (!arg7) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "int & reference is null");
    return ;
  } 
  arg8 = *(int **)&jarg8;
  if (!arg8) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "int & reference is null");
    return ;
  } 
  arg9 = *(PHY_ScalarType **)&jarg9;
  if (!arg9) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "PHY_ScalarType & reference is null");
    return ;
  } 
  arg10 = (int)jarg10; 
  ((btTriangleIndexVertexArray const *)arg1)->getLockedReadOnlyVertexIndexBase((unsigned char const **)arg2,*arg3,*arg4,*arg5,(unsigned char const **)arg6,*arg7,*arg8,*arg9,arg10);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btTriangleIndexVertexArray_1getLockedReadOnlyVertexIndexBase_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jlong jarg3, jlong jarg4, jlong jarg5, jlong jarg6, jlong jarg7, jlong jarg8, jlong jarg9) {
  btTriangleIndexVertexArray *arg1 = (btTriangleIndexVertexArray *) 0 ;
  unsigned char **arg2 = (unsigned char **) 0 ;
  int *arg3 = 0 ;
  PHY_ScalarType *arg4 = 0 ;
  int *arg5 = 0 ;
  unsigned char **arg6 = (unsigned char **) 0 ;
  int *arg7 = 0 ;
  int *arg8 = 0 ;
  PHY_ScalarType *arg9 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btTriangleIndexVertexArray **)&jarg1; 
  arg2 = *(unsigned char ***)&jarg2; 
  arg3 = *(int **)&jarg3;
  if (!arg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "int & reference is null");
    return ;
  } 
  arg4 = *(PHY_ScalarType **)&jarg4;
  if (!arg4) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "PHY_ScalarType & reference is null");
    return ;
  } 
  arg5 = *(int **)&jarg5;
  if (!arg5) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "int & reference is null");
    return ;
  } 
  arg6 = *(unsigned char ***)&jarg6; 
  arg7 = *(int **)&jarg7;
  if (!arg7) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "int & reference is null");
    return ;
  } 
  arg8 = *(int **)&jarg8;
  if (!arg8) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "int & reference is null");
    return ;
  } 
  arg9 = *(PHY_ScalarType **)&jarg9;
  if (!arg9) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "PHY_ScalarType & reference is null");
    return ;
  } 
  ((btTriangleIndexVertexArray const *)arg1)->getLockedReadOnlyVertexIndexBase((unsigned char const **)arg2,*arg3,*arg4,*arg5,(unsigned char const **)arg6,*arg7,*arg8,*arg9);
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btTriangleIndexVertexArray_1getIndexedMeshArray(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btTriangleIndexVertexArray *arg1 = (btTriangleIndexVertexArray *) 0 ;
  IndexedMeshArray *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btTriangleIndexVertexArray **)&jarg1; 
  result = (IndexedMeshArray *) &((btTriangleIndexVertexArray const *)arg1)->getIndexedMeshArray();
  *(IndexedMeshArray **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btMaterial_1friction_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2) {
  btMaterial *arg1 = (btMaterial *) 0 ;
  btScalar arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btMaterial **)&jarg1; 
  arg2 = (btScalar)jarg2; 
  if (arg1) (arg1)->m_friction = arg2;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btMaterial_1friction_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jfloat jresult = 0 ;
  btMaterial *arg1 = (btMaterial *) 0 ;
  btScalar result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btMaterial **)&jarg1; 
  result = (btScalar) ((arg1)->m_friction);
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btMaterial_1restitution_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2) {
  btMaterial *arg1 = (btMaterial *) 0 ;
  btScalar arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btMaterial **)&jarg1; 
  arg2 = (btScalar)jarg2; 
  if (arg1) (arg1)->m_restitution = arg2;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btMaterial_1restitution_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jfloat jresult = 0 ;
  btMaterial *arg1 = (btMaterial *) 0 ;
  btScalar result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btMaterial **)&jarg1; 
  result = (btScalar) ((arg1)->m_restitution);
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btMaterial_1pad_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jintArray jarg2) {
  btMaterial *arg1 = (btMaterial *) 0 ;
  int *arg2 ;
  jint *jarr2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btMaterial **)&jarg1; 
  if (jarg2 && jenv->GetArrayLength(jarg2) != 2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, "incorrect array size");
    return ;
  }
  if (!SWIG_JavaArrayInInt(jenv, &jarr2, (int **)&arg2, jarg2)) return ; 
  {
    size_t ii;
    int *b = (int *) arg1->pad;
    for (ii = 0; ii < (size_t)2; ii++) b[ii] = *((int *) arg2 + ii);
  }
  SWIG_JavaArrayArgoutInt(jenv, jarr2, (int *)arg2, jarg2); 
  delete [] arg2; 
}


SWIGEXPORT jintArray JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btMaterial_1pad_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jintArray jresult = 0 ;
  btMaterial *arg1 = (btMaterial *) 0 ;
  int *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btMaterial **)&jarg1; 
  result = (int *)(int *) ((arg1)->pad);
  jresult = SWIG_JavaArrayOutInt(jenv, (int *)result, 2); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_new_1btMaterial_1_1SWIG_10(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  btMaterial *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (btMaterial *)new btMaterial();
  *(btMaterial **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_new_1btMaterial_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jfloat jarg1, jfloat jarg2) {
  jlong jresult = 0 ;
  btScalar arg1 ;
  btScalar arg2 ;
  btMaterial *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (btScalar)jarg1; 
  arg2 = (btScalar)jarg2; 
  result = (btMaterial *)new btMaterial(arg1,arg2);
  *(btMaterial **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_delete_1btMaterial(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  btMaterial *arg1 = (btMaterial *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(btMaterial **)&jarg1; 
  delete arg1;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_new_1btScaledBvhTriangleMeshShape(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2) {
  jlong jresult = 0 ;
  btBvhTriangleMeshShape *arg1 = (btBvhTriangleMeshShape *) 0 ;
  btVector3 *arg2 = 0 ;
  btScaledBvhTriangleMeshShape *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btBvhTriangleMeshShape **)&jarg1; 
  btVector3 local_arg2;
  gdx_setbtVector3FromVector3(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitVector3 auto_commit_arg2(jenv, jarg2, &local_arg2);
  result = (btScaledBvhTriangleMeshShape *)new btScaledBvhTriangleMeshShape(arg1,(btVector3 const &)*arg2);
  *(btScaledBvhTriangleMeshShape **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_delete_1btScaledBvhTriangleMeshShape(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  btScaledBvhTriangleMeshShape *arg1 = (btScaledBvhTriangleMeshShape *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(btScaledBvhTriangleMeshShape **)&jarg1; 
  delete arg1;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btScaledBvhTriangleMeshShape_1getChildShape_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btScaledBvhTriangleMeshShape *arg1 = (btScaledBvhTriangleMeshShape *) 0 ;
  btBvhTriangleMeshShape *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btScaledBvhTriangleMeshShape **)&jarg1; 
  result = (btBvhTriangleMeshShape *)(arg1)->getChildShape();
  *(btBvhTriangleMeshShape **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btScaledTriangleMeshShapeData_1trimeshShapeData_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btScaledTriangleMeshShapeData *arg1 = (btScaledTriangleMeshShapeData *) 0 ;
  btTriangleMeshShapeData *arg2 = (btTriangleMeshShapeData *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btScaledTriangleMeshShapeData **)&jarg1; 
  arg2 = *(btTriangleMeshShapeData **)&jarg2; 
  if (arg1) (arg1)->m_trimeshShapeData = *arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btScaledTriangleMeshShapeData_1trimeshShapeData_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btScaledTriangleMeshShapeData *arg1 = (btScaledTriangleMeshShapeData *) 0 ;
  btTriangleMeshShapeData *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btScaledTriangleMeshShapeData **)&jarg1; 
  result = (btTriangleMeshShapeData *)& ((arg1)->m_trimeshShapeData);
  *(btTriangleMeshShapeData **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btScaledTriangleMeshShapeData_1localScaling_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btScaledTriangleMeshShapeData *arg1 = (btScaledTriangleMeshShapeData *) 0 ;
  btVector3FloatData *arg2 = (btVector3FloatData *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btScaledTriangleMeshShapeData **)&jarg1; 
  arg2 = *(btVector3FloatData **)&jarg2; 
  if (arg1) (arg1)->m_localScaling = *arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btScaledTriangleMeshShapeData_1localScaling_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btScaledTriangleMeshShapeData *arg1 = (btScaledTriangleMeshShapeData *) 0 ;
  btVector3FloatData *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btScaledTriangleMeshShapeData **)&jarg1; 
  result = (btVector3FloatData *)& ((arg1)->m_localScaling);
  *(btVector3FloatData **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_new_1btScaledTriangleMeshShapeData(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  btScaledTriangleMeshShapeData *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (btScaledTriangleMeshShapeData *)new btScaledTriangleMeshShapeData();
  *(btScaledTriangleMeshShapeData **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_delete_1btScaledTriangleMeshShapeData(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  btScaledTriangleMeshShapeData *arg1 = (btScaledTriangleMeshShapeData *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(btScaledTriangleMeshShapeData **)&jarg1; 
  delete arg1;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_new_1btShapeHull(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btConvexShape *arg1 = (btConvexShape *) 0 ;
  btShapeHull *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btConvexShape **)&jarg1; 
  result = (btShapeHull *)new btShapeHull((btConvexShape const *)arg1);
  *(btShapeHull **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_delete_1btShapeHull(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  btShapeHull *arg1 = (btShapeHull *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(btShapeHull **)&jarg1; 
  delete arg1;
}


SWIGEXPORT jboolean JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btShapeHull_1buildHull(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2) {
  jboolean jresult = 0 ;
  btShapeHull *arg1 = (btShapeHull *) 0 ;
  btScalar arg2 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btShapeHull **)&jarg1; 
  arg2 = (btScalar)jarg2; 
  result = (bool)(arg1)->buildHull(arg2);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btShapeHull_1numTriangles(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  btShapeHull *arg1 = (btShapeHull *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btShapeHull **)&jarg1; 
  result = (int)((btShapeHull const *)arg1)->numTriangles();
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btShapeHull_1numVertices(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  btShapeHull *arg1 = (btShapeHull *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btShapeHull **)&jarg1; 
  result = (int)((btShapeHull const *)arg1)->numVertices();
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btShapeHull_1numIndices(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  btShapeHull *arg1 = (btShapeHull *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btShapeHull **)&jarg1; 
  result = (int)((btShapeHull const *)arg1)->numIndices();
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jobject JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btShapeHull_1getVertex(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  jobject jresult = 0 ;
  btShapeHull *arg1 = (btShapeHull *) 0 ;
  int arg2 ;
  btVector3 *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btShapeHull **)&jarg1; 
  arg2 = (int)jarg2; 
  result = (btVector3 *) &btShapeHull_getVertex(arg1,arg2);
  jresult = gdx_getReturnVector3(jenv);
  gdx_setVector3FrombtVector3(jenv, jresult, result);
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btShapeHull_1getIndex(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  jint jresult = 0 ;
  btShapeHull *arg1 = (btShapeHull *) 0 ;
  int arg2 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btShapeHull **)&jarg1; 
  arg2 = (int)jarg2; 
  result = (int)btShapeHull_getIndex(arg1,arg2);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_new_1btConvexHullShape_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jobject jarg1, jint jarg2, jint jarg3) {
  jlong jresult = 0 ;
  btScalar *arg1 = (btScalar *) 0 ;
  int arg2 ;
  int arg3 ;
  btConvexHullShape *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    arg1 = (btScalar*)jenv->GetDirectBufferAddress(jarg1);
    if (arg1 == NULL) {
      SWIG_JavaThrowException(jenv, SWIG_JavaRuntimeException, "Unable to get address of direct buffer. Buffer must be allocated direct.");
    }
  }
  arg2 = (int)jarg2; 
  arg3 = (int)jarg3; 
  result = (btConvexHullShape *)new btConvexHullShape((btScalar const *)arg1,arg2,arg3);
  *(btConvexHullShape **)&jresult = result; 
  
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_new_1btConvexHullShape_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jobject jarg1, jint jarg2) {
  jlong jresult = 0 ;
  btScalar *arg1 = (btScalar *) 0 ;
  int arg2 ;
  btConvexHullShape *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    arg1 = (btScalar*)jenv->GetDirectBufferAddress(jarg1);
    if (arg1 == NULL) {
      SWIG_JavaThrowException(jenv, SWIG_JavaRuntimeException, "Unable to get address of direct buffer. Buffer must be allocated direct.");
    }
  }
  arg2 = (int)jarg2; 
  result = (btConvexHullShape *)new btConvexHullShape((btScalar const *)arg1,arg2);
  *(btConvexHullShape **)&jresult = result; 
  
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_new_1btConvexHullShape_1_1SWIG_12(JNIEnv *jenv, jclass jcls, jobject jarg1) {
  jlong jresult = 0 ;
  btScalar *arg1 = (btScalar *) 0 ;
  btConvexHullShape *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    arg1 = (btScalar*)jenv->GetDirectBufferAddress(jarg1);
    if (arg1 == NULL) {
      SWIG_JavaThrowException(jenv, SWIG_JavaRuntimeException, "Unable to get address of direct buffer. Buffer must be allocated direct.");
    }
  }
  result = (btConvexHullShape *)new btConvexHullShape((btScalar const *)arg1);
  *(btConvexHullShape **)&jresult = result; 
  
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_new_1btConvexHullShape_1_1SWIG_13(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  btConvexHullShape *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (btConvexHullShape *)new btConvexHullShape();
  *(btConvexHullShape **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btConvexHullShape_1addPoint_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2, jboolean jarg3) {
  btConvexHullShape *arg1 = (btConvexHullShape *) 0 ;
  btVector3 *arg2 = 0 ;
  bool arg3 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btConvexHullShape **)&jarg1; 
  btVector3 local_arg2;
  gdx_setbtVector3FromVector3(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitVector3 auto_commit_arg2(jenv, jarg2, &local_arg2);
  arg3 = jarg3 ? true : false; 
  (arg1)->addPoint((btVector3 const &)*arg2,arg3);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btConvexHullShape_1addPoint_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2) {
  btConvexHullShape *arg1 = (btConvexHullShape *) 0 ;
  btVector3 *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btConvexHullShape **)&jarg1; 
  btVector3 local_arg2;
  gdx_setbtVector3FromVector3(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitVector3 auto_commit_arg2(jenv, jarg2, &local_arg2);
  (arg1)->addPoint((btVector3 const &)*arg2);
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btConvexHullShape_1getUnscaledPoints_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btConvexHullShape *arg1 = (btConvexHullShape *) 0 ;
  btVector3 *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btConvexHullShape **)&jarg1; 
  result = (btVector3 *)(arg1)->getUnscaledPoints();
  *(btVector3 **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btConvexHullShape_1getPoints(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btConvexHullShape *arg1 = (btConvexHullShape *) 0 ;
  btVector3 *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btConvexHullShape **)&jarg1; 
  result = (btVector3 *)((btConvexHullShape const *)arg1)->getPoints();
  *(btVector3 **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btConvexHullShape_1optimizeConvexHull(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  btConvexHullShape *arg1 = (btConvexHullShape *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btConvexHullShape **)&jarg1; 
  (arg1)->optimizeConvexHull();
}


SWIGEXPORT jobject JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btConvexHullShape_1getScaledPoint(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  jobject jresult = 0 ;
  btConvexHullShape *arg1 = (btConvexHullShape *) 0 ;
  int arg2 ;
  btVector3 result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btConvexHullShape **)&jarg1; 
  arg2 = (int)jarg2; 
  result = ((btConvexHullShape const *)arg1)->getScaledPoint(arg2);
  jresult = gdx_getReturnVector3(jenv);
  gdx_setVector3FrombtVector3(jenv, jresult, result);
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btConvexHullShape_1getNumPoints(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  btConvexHullShape *arg1 = (btConvexHullShape *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btConvexHullShape **)&jarg1; 
  result = (int)((btConvexHullShape const *)arg1)->getNumPoints();
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_new_1btConvexHullShape_1_1SWIG_14(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btShapeHull *arg1 = (btShapeHull *) 0 ;
  btConvexHullShape *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btShapeHull **)&jarg1; 
  result = (btConvexHullShape *)new_btConvexHullShape__SWIG_4((btShapeHull const *)arg1);
  *(btConvexHullShape **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_delete_1btConvexHullShape(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  btConvexHullShape *arg1 = (btConvexHullShape *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(btConvexHullShape **)&jarg1; 
  delete arg1;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btConvexHullShapeData_1convexInternalShapeData_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btConvexHullShapeData *arg1 = (btConvexHullShapeData *) 0 ;
  btConvexInternalShapeData *arg2 = (btConvexInternalShapeData *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btConvexHullShapeData **)&jarg1; 
  arg2 = *(btConvexInternalShapeData **)&jarg2; 
  if (arg1) (arg1)->m_convexInternalShapeData = *arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btConvexHullShapeData_1convexInternalShapeData_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btConvexHullShapeData *arg1 = (btConvexHullShapeData *) 0 ;
  btConvexInternalShapeData *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btConvexHullShapeData **)&jarg1; 
  result = (btConvexInternalShapeData *)& ((arg1)->m_convexInternalShapeData);
  *(btConvexInternalShapeData **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btConvexHullShapeData_1unscaledPointsFloatPtr_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btConvexHullShapeData *arg1 = (btConvexHullShapeData *) 0 ;
  btVector3FloatData *arg2 = (btVector3FloatData *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btConvexHullShapeData **)&jarg1; 
  arg2 = *(btVector3FloatData **)&jarg2; 
  if (arg1) (arg1)->m_unscaledPointsFloatPtr = arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btConvexHullShapeData_1unscaledPointsFloatPtr_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btConvexHullShapeData *arg1 = (btConvexHullShapeData *) 0 ;
  btVector3FloatData *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btConvexHullShapeData **)&jarg1; 
  result = (btVector3FloatData *) ((arg1)->m_unscaledPointsFloatPtr);
  *(btVector3FloatData **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btConvexHullShapeData_1unscaledPointsDoublePtr_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btConvexHullShapeData *arg1 = (btConvexHullShapeData *) 0 ;
  btVector3DoubleData *arg2 = (btVector3DoubleData *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btConvexHullShapeData **)&jarg1; 
  arg2 = *(btVector3DoubleData **)&jarg2; 
  if (arg1) (arg1)->m_unscaledPointsDoublePtr = arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btConvexHullShapeData_1unscaledPointsDoublePtr_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btConvexHullShapeData *arg1 = (btConvexHullShapeData *) 0 ;
  btVector3DoubleData *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btConvexHullShapeData **)&jarg1; 
  result = (btVector3DoubleData *) ((arg1)->m_unscaledPointsDoublePtr);
  *(btVector3DoubleData **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btConvexHullShapeData_1numUnscaledPoints_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  btConvexHullShapeData *arg1 = (btConvexHullShapeData *) 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btConvexHullShapeData **)&jarg1; 
  arg2 = (int)jarg2; 
  if (arg1) (arg1)->m_numUnscaledPoints = arg2;
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btConvexHullShapeData_1numUnscaledPoints_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  btConvexHullShapeData *arg1 = (btConvexHullShapeData *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btConvexHullShapeData **)&jarg1; 
  result = (int) ((arg1)->m_numUnscaledPoints);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btConvexHullShapeData_1padding3_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  btConvexHullShapeData *arg1 = (btConvexHullShapeData *) 0 ;
  char *arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btConvexHullShapeData **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return ;
  }
  {
    if(arg2) {
      strncpy((char*)arg1->m_padding3, (const char *)arg2, 4-1);
      arg1->m_padding3[4-1] = 0;
    } else {
      arg1->m_padding3[0] = 0;
    }
  }
  
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
}


SWIGEXPORT jstring JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btConvexHullShapeData_1padding3_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  btConvexHullShapeData *arg1 = (btConvexHullShapeData *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btConvexHullShapeData **)&jarg1; 
  result = (char *)(char *) ((arg1)->m_padding3);
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_new_1btConvexHullShapeData(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  btConvexHullShapeData *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (btConvexHullShapeData *)new btConvexHullShapeData();
  *(btConvexHullShapeData **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_delete_1btConvexHullShapeData(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  btConvexHullShapeData *arg1 = (btConvexHullShapeData *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(btConvexHullShapeData **)&jarg1; 
  delete arg1;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btMaterialProperties_1numMaterials_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  btMaterialProperties *arg1 = (btMaterialProperties *) 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btMaterialProperties **)&jarg1; 
  arg2 = (int)jarg2; 
  if (arg1) (arg1)->m_numMaterials = arg2;
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btMaterialProperties_1numMaterials_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  btMaterialProperties *arg1 = (btMaterialProperties *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btMaterialProperties **)&jarg1; 
  result = (int) ((arg1)->m_numMaterials);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btMaterialProperties_1materialBase_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2) {
  btMaterialProperties *arg1 = (btMaterialProperties *) 0 ;
  unsigned char *arg2 = (unsigned char *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btMaterialProperties **)&jarg1; 
  {
    arg2 = (unsigned char*)jenv->GetDirectBufferAddress(jarg2);
    if (arg2 == NULL) {
      SWIG_JavaThrowException(jenv, SWIG_JavaRuntimeException, "Unable to get address of direct buffer. Buffer must be allocated direct.");
    }
  }
  {
    if (arg2) {
      arg1->m_materialBase = arg2;
    } else {
      arg1->m_materialBase = 0;
    }
  }
  
}


SWIGEXPORT jobject JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btMaterialProperties_1materialBase_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jobject jresult = 0 ;
  btMaterialProperties *arg1 = (btMaterialProperties *) 0 ;
  unsigned char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btMaterialProperties **)&jarg1; 
  result = (unsigned char *) ((arg1)->m_materialBase);
  *(unsigned char **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btMaterialProperties_1materialStride_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  btMaterialProperties *arg1 = (btMaterialProperties *) 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btMaterialProperties **)&jarg1; 
  arg2 = (int)jarg2; 
  if (arg1) (arg1)->m_materialStride = arg2;
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btMaterialProperties_1materialStride_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  btMaterialProperties *arg1 = (btMaterialProperties *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btMaterialProperties **)&jarg1; 
  result = (int) ((arg1)->m_materialStride);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btMaterialProperties_1materialType_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  btMaterialProperties *arg1 = (btMaterialProperties *) 0 ;
  PHY_ScalarType arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btMaterialProperties **)&jarg1; 
  arg2 = (PHY_ScalarType)jarg2; 
  if (arg1) (arg1)->m_materialType = arg2;
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btMaterialProperties_1materialType_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  btMaterialProperties *arg1 = (btMaterialProperties *) 0 ;
  PHY_ScalarType result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btMaterialProperties **)&jarg1; 
  result = (PHY_ScalarType) ((arg1)->m_materialType);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btMaterialProperties_1numTriangles_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  btMaterialProperties *arg1 = (btMaterialProperties *) 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btMaterialProperties **)&jarg1; 
  arg2 = (int)jarg2; 
  if (arg1) (arg1)->m_numTriangles = arg2;
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btMaterialProperties_1numTriangles_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  btMaterialProperties *arg1 = (btMaterialProperties *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btMaterialProperties **)&jarg1; 
  result = (int) ((arg1)->m_numTriangles);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btMaterialProperties_1triangleMaterialsBase_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2) {
  btMaterialProperties *arg1 = (btMaterialProperties *) 0 ;
  unsigned char *arg2 = (unsigned char *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btMaterialProperties **)&jarg1; 
  {
    arg2 = (unsigned char*)jenv->GetDirectBufferAddress(jarg2);
    if (arg2 == NULL) {
      SWIG_JavaThrowException(jenv, SWIG_JavaRuntimeException, "Unable to get address of direct buffer. Buffer must be allocated direct.");
    }
  }
  {
    if (arg2) {
      arg1->m_triangleMaterialsBase = arg2;
    } else {
      arg1->m_triangleMaterialsBase = 0;
    }
  }
  
}


SWIGEXPORT jobject JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btMaterialProperties_1triangleMaterialsBase_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jobject jresult = 0 ;
  btMaterialProperties *arg1 = (btMaterialProperties *) 0 ;
  unsigned char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btMaterialProperties **)&jarg1; 
  result = (unsigned char *) ((arg1)->m_triangleMaterialsBase);
  *(unsigned char **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btMaterialProperties_1triangleMaterialStride_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  btMaterialProperties *arg1 = (btMaterialProperties *) 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btMaterialProperties **)&jarg1; 
  arg2 = (int)jarg2; 
  if (arg1) (arg1)->m_triangleMaterialStride = arg2;
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btMaterialProperties_1triangleMaterialStride_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  btMaterialProperties *arg1 = (btMaterialProperties *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btMaterialProperties **)&jarg1; 
  result = (int) ((arg1)->m_triangleMaterialStride);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btMaterialProperties_1triangleType_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  btMaterialProperties *arg1 = (btMaterialProperties *) 0 ;
  PHY_ScalarType arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btMaterialProperties **)&jarg1; 
  arg2 = (PHY_ScalarType)jarg2; 
  if (arg1) (arg1)->m_triangleType = arg2;
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btMaterialProperties_1triangleType_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  btMaterialProperties *arg1 = (btMaterialProperties *) 0 ;
  PHY_ScalarType result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btMaterialProperties **)&jarg1; 
  result = (PHY_ScalarType) ((arg1)->m_triangleType);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_new_1btMaterialProperties(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  btMaterialProperties *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (btMaterialProperties *)new btMaterialProperties();
  *(btMaterialProperties **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_delete_1btMaterialProperties(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  btMaterialProperties *arg1 = (btMaterialProperties *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(btMaterialProperties **)&jarg1; 
  delete arg1;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_new_1btTriangleIndexVertexMaterialArray_1_1SWIG_10(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  btTriangleIndexVertexMaterialArray *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (btTriangleIndexVertexMaterialArray *)new btTriangleIndexVertexMaterialArray();
  *(btTriangleIndexVertexMaterialArray **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_new_1btTriangleIndexVertexMaterialArray_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jint jarg1, jobject jarg2, jint jarg3, jint jarg4, jobject jarg5, jint jarg6, jint jarg7, jobject jarg8, jint jarg9, jobject jarg10, jint jarg11) {
  jlong jresult = 0 ;
  int arg1 ;
  int *arg2 = (int *) 0 ;
  int arg3 ;
  int arg4 ;
  btScalar *arg5 = (btScalar *) 0 ;
  int arg6 ;
  int arg7 ;
  unsigned char *arg8 = (unsigned char *) 0 ;
  int arg9 ;
  int *arg10 = (int *) 0 ;
  int arg11 ;
  btTriangleIndexVertexMaterialArray *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (int)jarg1; 
  {
    arg2 = (int*)jenv->GetDirectBufferAddress(jarg2);
    if (arg2 == NULL) {
      SWIG_JavaThrowException(jenv, SWIG_JavaRuntimeException, "Unable to get address of direct buffer. Buffer must be allocated direct.");
    }
  }
  arg3 = (int)jarg3; 
  arg4 = (int)jarg4; 
  {
    arg5 = (btScalar*)jenv->GetDirectBufferAddress(jarg5);
    if (arg5 == NULL) {
      SWIG_JavaThrowException(jenv, SWIG_JavaRuntimeException, "Unable to get address of direct buffer. Buffer must be allocated direct.");
    }
  }
  arg6 = (int)jarg6; 
  arg7 = (int)jarg7; 
  {
    arg8 = (unsigned char*)jenv->GetDirectBufferAddress(jarg8);
    if (arg8 == NULL) {
      SWIG_JavaThrowException(jenv, SWIG_JavaRuntimeException, "Unable to get address of direct buffer. Buffer must be allocated direct.");
    }
  }
  arg9 = (int)jarg9; 
  {
    arg10 = (int*)jenv->GetDirectBufferAddress(jarg10);
    if (arg10 == NULL) {
      SWIG_JavaThrowException(jenv, SWIG_JavaRuntimeException, "Unable to get address of direct buffer. Buffer must be allocated direct.");
    }
  }
  arg11 = (int)jarg11; 
  result = (btTriangleIndexVertexMaterialArray *)new btTriangleIndexVertexMaterialArray(arg1,arg2,arg3,arg4,arg5,arg6,arg7,arg8,arg9,arg10,arg11);
  *(btTriangleIndexVertexMaterialArray **)&jresult = result; 
  
  
  
  
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_delete_1btTriangleIndexVertexMaterialArray(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  btTriangleIndexVertexMaterialArray *arg1 = (btTriangleIndexVertexMaterialArray *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(btTriangleIndexVertexMaterialArray **)&jarg1; 
  delete arg1;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btTriangleIndexVertexMaterialArray_1addMaterialProperties_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jint jarg3) {
  btTriangleIndexVertexMaterialArray *arg1 = (btTriangleIndexVertexMaterialArray *) 0 ;
  btMaterialProperties *arg2 = 0 ;
  PHY_ScalarType arg3 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btTriangleIndexVertexMaterialArray **)&jarg1; 
  arg2 = *(btMaterialProperties **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btMaterialProperties const & reference is null");
    return ;
  } 
  arg3 = (PHY_ScalarType)jarg3; 
  (arg1)->addMaterialProperties((btMaterialProperties const &)*arg2,arg3);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btTriangleIndexVertexMaterialArray_1addMaterialProperties_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btTriangleIndexVertexMaterialArray *arg1 = (btTriangleIndexVertexMaterialArray *) 0 ;
  btMaterialProperties *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btTriangleIndexVertexMaterialArray **)&jarg1; 
  arg2 = *(btMaterialProperties **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btMaterialProperties const & reference is null");
    return ;
  } 
  (arg1)->addMaterialProperties((btMaterialProperties const &)*arg2);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btTriangleIndexVertexMaterialArray_1getLockedMaterialBase_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jlong jarg3, jlong jarg4, jlong jarg5, jlong jarg6, jlong jarg7, jlong jarg8, jlong jarg9, jint jarg10) {
  btTriangleIndexVertexMaterialArray *arg1 = (btTriangleIndexVertexMaterialArray *) 0 ;
  unsigned char **arg2 = (unsigned char **) 0 ;
  int *arg3 = 0 ;
  PHY_ScalarType *arg4 = 0 ;
  int *arg5 = 0 ;
  unsigned char **arg6 = (unsigned char **) 0 ;
  int *arg7 = 0 ;
  int *arg8 = 0 ;
  PHY_ScalarType *arg9 = 0 ;
  int arg10 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btTriangleIndexVertexMaterialArray **)&jarg1; 
  arg2 = *(unsigned char ***)&jarg2; 
  arg3 = *(int **)&jarg3;
  if (!arg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "int & reference is null");
    return ;
  } 
  arg4 = *(PHY_ScalarType **)&jarg4;
  if (!arg4) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "PHY_ScalarType & reference is null");
    return ;
  } 
  arg5 = *(int **)&jarg5;
  if (!arg5) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "int & reference is null");
    return ;
  } 
  arg6 = *(unsigned char ***)&jarg6; 
  arg7 = *(int **)&jarg7;
  if (!arg7) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "int & reference is null");
    return ;
  } 
  arg8 = *(int **)&jarg8;
  if (!arg8) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "int & reference is null");
    return ;
  } 
  arg9 = *(PHY_ScalarType **)&jarg9;
  if (!arg9) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "PHY_ScalarType & reference is null");
    return ;
  } 
  arg10 = (int)jarg10; 
  (arg1)->getLockedMaterialBase(arg2,*arg3,*arg4,*arg5,arg6,*arg7,*arg8,*arg9,arg10);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btTriangleIndexVertexMaterialArray_1getLockedMaterialBase_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jlong jarg3, jlong jarg4, jlong jarg5, jlong jarg6, jlong jarg7, jlong jarg8, jlong jarg9) {
  btTriangleIndexVertexMaterialArray *arg1 = (btTriangleIndexVertexMaterialArray *) 0 ;
  unsigned char **arg2 = (unsigned char **) 0 ;
  int *arg3 = 0 ;
  PHY_ScalarType *arg4 = 0 ;
  int *arg5 = 0 ;
  unsigned char **arg6 = (unsigned char **) 0 ;
  int *arg7 = 0 ;
  int *arg8 = 0 ;
  PHY_ScalarType *arg9 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btTriangleIndexVertexMaterialArray **)&jarg1; 
  arg2 = *(unsigned char ***)&jarg2; 
  arg3 = *(int **)&jarg3;
  if (!arg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "int & reference is null");
    return ;
  } 
  arg4 = *(PHY_ScalarType **)&jarg4;
  if (!arg4) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "PHY_ScalarType & reference is null");
    return ;
  } 
  arg5 = *(int **)&jarg5;
  if (!arg5) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "int & reference is null");
    return ;
  } 
  arg6 = *(unsigned char ***)&jarg6; 
  arg7 = *(int **)&jarg7;
  if (!arg7) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "int & reference is null");
    return ;
  } 
  arg8 = *(int **)&jarg8;
  if (!arg8) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "int & reference is null");
    return ;
  } 
  arg9 = *(PHY_ScalarType **)&jarg9;
  if (!arg9) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "PHY_ScalarType & reference is null");
    return ;
  } 
  (arg1)->getLockedMaterialBase(arg2,*arg3,*arg4,*arg5,arg6,*arg7,*arg8,*arg9);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btTriangleIndexVertexMaterialArray_1getLockedReadOnlyMaterialBase_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jlong jarg3, jlong jarg4, jlong jarg5, jlong jarg6, jlong jarg7, jlong jarg8, jlong jarg9, jint jarg10) {
  btTriangleIndexVertexMaterialArray *arg1 = (btTriangleIndexVertexMaterialArray *) 0 ;
  unsigned char **arg2 = (unsigned char **) 0 ;
  int *arg3 = 0 ;
  PHY_ScalarType *arg4 = 0 ;
  int *arg5 = 0 ;
  unsigned char **arg6 = (unsigned char **) 0 ;
  int *arg7 = 0 ;
  int *arg8 = 0 ;
  PHY_ScalarType *arg9 = 0 ;
  int arg10 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btTriangleIndexVertexMaterialArray **)&jarg1; 
  arg2 = *(unsigned char ***)&jarg2; 
  arg3 = *(int **)&jarg3;
  if (!arg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "int & reference is null");
    return ;
  } 
  arg4 = *(PHY_ScalarType **)&jarg4;
  if (!arg4) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "PHY_ScalarType & reference is null");
    return ;
  } 
  arg5 = *(int **)&jarg5;
  if (!arg5) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "int & reference is null");
    return ;
  } 
  arg6 = *(unsigned char ***)&jarg6; 
  arg7 = *(int **)&jarg7;
  if (!arg7) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "int & reference is null");
    return ;
  } 
  arg8 = *(int **)&jarg8;
  if (!arg8) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "int & reference is null");
    return ;
  } 
  arg9 = *(PHY_ScalarType **)&jarg9;
  if (!arg9) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "PHY_ScalarType & reference is null");
    return ;
  } 
  arg10 = (int)jarg10; 
  (arg1)->getLockedReadOnlyMaterialBase((unsigned char const **)arg2,*arg3,*arg4,*arg5,(unsigned char const **)arg6,*arg7,*arg8,*arg9,arg10);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btTriangleIndexVertexMaterialArray_1getLockedReadOnlyMaterialBase_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jlong jarg3, jlong jarg4, jlong jarg5, jlong jarg6, jlong jarg7, jlong jarg8, jlong jarg9) {
  btTriangleIndexVertexMaterialArray *arg1 = (btTriangleIndexVertexMaterialArray *) 0 ;
  unsigned char **arg2 = (unsigned char **) 0 ;
  int *arg3 = 0 ;
  PHY_ScalarType *arg4 = 0 ;
  int *arg5 = 0 ;
  unsigned char **arg6 = (unsigned char **) 0 ;
  int *arg7 = 0 ;
  int *arg8 = 0 ;
  PHY_ScalarType *arg9 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btTriangleIndexVertexMaterialArray **)&jarg1; 
  arg2 = *(unsigned char ***)&jarg2; 
  arg3 = *(int **)&jarg3;
  if (!arg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "int & reference is null");
    return ;
  } 
  arg4 = *(PHY_ScalarType **)&jarg4;
  if (!arg4) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "PHY_ScalarType & reference is null");
    return ;
  } 
  arg5 = *(int **)&jarg5;
  if (!arg5) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "int & reference is null");
    return ;
  } 
  arg6 = *(unsigned char ***)&jarg6; 
  arg7 = *(int **)&jarg7;
  if (!arg7) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "int & reference is null");
    return ;
  } 
  arg8 = *(int **)&jarg8;
  if (!arg8) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "int & reference is null");
    return ;
  } 
  arg9 = *(PHY_ScalarType **)&jarg9;
  if (!arg9) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "PHY_ScalarType & reference is null");
    return ;
  } 
  (arg1)->getLockedReadOnlyMaterialBase((unsigned char const **)arg2,*arg3,*arg4,*arg5,(unsigned char const **)arg6,*arg7,*arg8,*arg9);
}


SWIGEXPORT jobject JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btCylinderShape_1getHalfExtentsWithMargin(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jobject jresult = 0 ;
  btCylinderShape *arg1 = (btCylinderShape *) 0 ;
  btVector3 result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btCylinderShape **)&jarg1; 
  result = ((btCylinderShape const *)arg1)->getHalfExtentsWithMargin();
  jresult = gdx_getReturnVector3(jenv);
  gdx_setVector3FrombtVector3(jenv, jresult, result);
  return jresult;
}


SWIGEXPORT jobject JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btCylinderShape_1getHalfExtentsWithoutMargin(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jobject jresult = 0 ;
  btCylinderShape *arg1 = (btCylinderShape *) 0 ;
  btVector3 *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btCylinderShape **)&jarg1; 
  result = (btVector3 *) &((btCylinderShape const *)arg1)->getHalfExtentsWithoutMargin();
  jresult = gdx_getReturnVector3(jenv);
  gdx_setVector3FrombtVector3(jenv, jresult, result);
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_new_1btCylinderShape(JNIEnv *jenv, jclass jcls, jobject jarg1) {
  jlong jresult = 0 ;
  btVector3 *arg1 = 0 ;
  btCylinderShape *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  btVector3 local_arg1;
  gdx_setbtVector3FromVector3(jenv, local_arg1, jarg1);
  arg1 = &local_arg1;
  gdxAutoCommitVector3 auto_commit_arg1(jenv, jarg1, &local_arg1);
  result = (btCylinderShape *)new btCylinderShape((btVector3 const &)*arg1);
  *(btCylinderShape **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btCylinderShape_1getUpAxis(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  btCylinderShape *arg1 = (btCylinderShape *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btCylinderShape **)&jarg1; 
  result = (int)((btCylinderShape const *)arg1)->getUpAxis();
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btCylinderShape_1getRadius(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jfloat jresult = 0 ;
  btCylinderShape *arg1 = (btCylinderShape *) 0 ;
  btScalar result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btCylinderShape **)&jarg1; 
  result = (btScalar)((btCylinderShape const *)arg1)->getRadius();
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_delete_1btCylinderShape(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  btCylinderShape *arg1 = (btCylinderShape *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(btCylinderShape **)&jarg1; 
  delete arg1;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_new_1btCylinderShapeX(JNIEnv *jenv, jclass jcls, jobject jarg1) {
  jlong jresult = 0 ;
  btVector3 *arg1 = 0 ;
  btCylinderShapeX *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  btVector3 local_arg1;
  gdx_setbtVector3FromVector3(jenv, local_arg1, jarg1);
  arg1 = &local_arg1;
  gdxAutoCommitVector3 auto_commit_arg1(jenv, jarg1, &local_arg1);
  result = (btCylinderShapeX *)new btCylinderShapeX((btVector3 const &)*arg1);
  *(btCylinderShapeX **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_delete_1btCylinderShapeX(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  btCylinderShapeX *arg1 = (btCylinderShapeX *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(btCylinderShapeX **)&jarg1; 
  delete arg1;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_new_1btCylinderShapeZ(JNIEnv *jenv, jclass jcls, jobject jarg1) {
  jlong jresult = 0 ;
  btVector3 *arg1 = 0 ;
  btCylinderShapeZ *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  btVector3 local_arg1;
  gdx_setbtVector3FromVector3(jenv, local_arg1, jarg1);
  arg1 = &local_arg1;
  gdxAutoCommitVector3 auto_commit_arg1(jenv, jarg1, &local_arg1);
  result = (btCylinderShapeZ *)new btCylinderShapeZ((btVector3 const &)*arg1);
  *(btCylinderShapeZ **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_delete_1btCylinderShapeZ(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  btCylinderShapeZ *arg1 = (btCylinderShapeZ *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(btCylinderShapeZ **)&jarg1; 
  delete arg1;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btCylinderShapeData_1convexInternalShapeData_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btCylinderShapeData *arg1 = (btCylinderShapeData *) 0 ;
  btConvexInternalShapeData *arg2 = (btConvexInternalShapeData *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btCylinderShapeData **)&jarg1; 
  arg2 = *(btConvexInternalShapeData **)&jarg2; 
  if (arg1) (arg1)->m_convexInternalShapeData = *arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btCylinderShapeData_1convexInternalShapeData_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btCylinderShapeData *arg1 = (btCylinderShapeData *) 0 ;
  btConvexInternalShapeData *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btCylinderShapeData **)&jarg1; 
  result = (btConvexInternalShapeData *)& ((arg1)->m_convexInternalShapeData);
  *(btConvexInternalShapeData **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btCylinderShapeData_1upAxis_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  btCylinderShapeData *arg1 = (btCylinderShapeData *) 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btCylinderShapeData **)&jarg1; 
  arg2 = (int)jarg2; 
  if (arg1) (arg1)->m_upAxis = arg2;
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btCylinderShapeData_1upAxis_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  btCylinderShapeData *arg1 = (btCylinderShapeData *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btCylinderShapeData **)&jarg1; 
  result = (int) ((arg1)->m_upAxis);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btCylinderShapeData_1padding_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  btCylinderShapeData *arg1 = (btCylinderShapeData *) 0 ;
  char *arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btCylinderShapeData **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return ;
  }
  {
    if(arg2) {
      strncpy((char*)arg1->m_padding, (const char *)arg2, 4-1);
      arg1->m_padding[4-1] = 0;
    } else {
      arg1->m_padding[0] = 0;
    }
  }
  
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
}


SWIGEXPORT jstring JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btCylinderShapeData_1padding_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  btCylinderShapeData *arg1 = (btCylinderShapeData *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btCylinderShapeData **)&jarg1; 
  result = (char *)(char *) ((arg1)->m_padding);
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_new_1btCylinderShapeData(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  btCylinderShapeData *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (btCylinderShapeData *)new btCylinderShapeData();
  *(btCylinderShapeData **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_delete_1btCylinderShapeData(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  btCylinderShapeData *arg1 = (btCylinderShapeData *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(btCylinderShapeData **)&jarg1; 
  delete arg1;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btTriangleMesh_1weldingThreshold_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2) {
  btTriangleMesh *arg1 = (btTriangleMesh *) 0 ;
  btScalar arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btTriangleMesh **)&jarg1; 
  arg2 = (btScalar)jarg2; 
  if (arg1) (arg1)->m_weldingThreshold = arg2;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btTriangleMesh_1weldingThreshold_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jfloat jresult = 0 ;
  btTriangleMesh *arg1 = (btTriangleMesh *) 0 ;
  btScalar result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btTriangleMesh **)&jarg1; 
  result = (btScalar) ((arg1)->m_weldingThreshold);
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_new_1btTriangleMesh_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jboolean jarg1, jboolean jarg2) {
  jlong jresult = 0 ;
  bool arg1 ;
  bool arg2 ;
  btTriangleMesh *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = jarg1 ? true : false; 
  arg2 = jarg2 ? true : false; 
  result = (btTriangleMesh *)new btTriangleMesh(arg1,arg2);
  *(btTriangleMesh **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_new_1btTriangleMesh_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jboolean jarg1) {
  jlong jresult = 0 ;
  bool arg1 ;
  btTriangleMesh *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = jarg1 ? true : false; 
  result = (btTriangleMesh *)new btTriangleMesh(arg1);
  *(btTriangleMesh **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_new_1btTriangleMesh_1_1SWIG_12(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  btTriangleMesh *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (btTriangleMesh *)new btTriangleMesh();
  *(btTriangleMesh **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btTriangleMesh_1getUse32bitIndices(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  btTriangleMesh *arg1 = (btTriangleMesh *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btTriangleMesh **)&jarg1; 
  result = (bool)((btTriangleMesh const *)arg1)->getUse32bitIndices();
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btTriangleMesh_1getUse4componentVertices(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  btTriangleMesh *arg1 = (btTriangleMesh *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btTriangleMesh **)&jarg1; 
  result = (bool)((btTriangleMesh const *)arg1)->getUse4componentVertices();
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btTriangleMesh_1addTriangle_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2, jobject jarg3, jobject jarg4, jboolean jarg5) {
  btTriangleMesh *arg1 = (btTriangleMesh *) 0 ;
  btVector3 *arg2 = 0 ;
  btVector3 *arg3 = 0 ;
  btVector3 *arg4 = 0 ;
  bool arg5 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btTriangleMesh **)&jarg1; 
  btVector3 local_arg2;
  gdx_setbtVector3FromVector3(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitVector3 auto_commit_arg2(jenv, jarg2, &local_arg2);
  btVector3 local_arg3;
  gdx_setbtVector3FromVector3(jenv, local_arg3, jarg3);
  arg3 = &local_arg3;
  gdxAutoCommitVector3 auto_commit_arg3(jenv, jarg3, &local_arg3);
  btVector3 local_arg4;
  gdx_setbtVector3FromVector3(jenv, local_arg4, jarg4);
  arg4 = &local_arg4;
  gdxAutoCommitVector3 auto_commit_arg4(jenv, jarg4, &local_arg4);
  arg5 = jarg5 ? true : false; 
  (arg1)->addTriangle((btVector3 const &)*arg2,(btVector3 const &)*arg3,(btVector3 const &)*arg4,arg5);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btTriangleMesh_1addTriangle_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2, jobject jarg3, jobject jarg4) {
  btTriangleMesh *arg1 = (btTriangleMesh *) 0 ;
  btVector3 *arg2 = 0 ;
  btVector3 *arg3 = 0 ;
  btVector3 *arg4 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btTriangleMesh **)&jarg1; 
  btVector3 local_arg2;
  gdx_setbtVector3FromVector3(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitVector3 auto_commit_arg2(jenv, jarg2, &local_arg2);
  btVector3 local_arg3;
  gdx_setbtVector3FromVector3(jenv, local_arg3, jarg3);
  arg3 = &local_arg3;
  gdxAutoCommitVector3 auto_commit_arg3(jenv, jarg3, &local_arg3);
  btVector3 local_arg4;
  gdx_setbtVector3FromVector3(jenv, local_arg4, jarg4);
  arg4 = &local_arg4;
  gdxAutoCommitVector3 auto_commit_arg4(jenv, jarg4, &local_arg4);
  (arg1)->addTriangle((btVector3 const &)*arg2,(btVector3 const &)*arg3,(btVector3 const &)*arg4);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btTriangleMesh_1addTriangleIndices(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jint jarg3, jint jarg4) {
  btTriangleMesh *arg1 = (btTriangleMesh *) 0 ;
  int arg2 ;
  int arg3 ;
  int arg4 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btTriangleMesh **)&jarg1; 
  arg2 = (int)jarg2; 
  arg3 = (int)jarg3; 
  arg4 = (int)jarg4; 
  (arg1)->addTriangleIndices(arg2,arg3,arg4);
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btTriangleMesh_1getNumTriangles(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  btTriangleMesh *arg1 = (btTriangleMesh *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btTriangleMesh **)&jarg1; 
  result = (int)((btTriangleMesh const *)arg1)->getNumTriangles();
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btTriangleMesh_1findOrAddVertex(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2, jboolean jarg3) {
  jint jresult = 0 ;
  btTriangleMesh *arg1 = (btTriangleMesh *) 0 ;
  btVector3 *arg2 = 0 ;
  bool arg3 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btTriangleMesh **)&jarg1; 
  btVector3 local_arg2;
  gdx_setbtVector3FromVector3(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitVector3 auto_commit_arg2(jenv, jarg2, &local_arg2);
  arg3 = jarg3 ? true : false; 
  result = (int)(arg1)->findOrAddVertex((btVector3 const &)*arg2,arg3);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btTriangleMesh_1addIndex(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  btTriangleMesh *arg1 = (btTriangleMesh *) 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btTriangleMesh **)&jarg1; 
  arg2 = (int)jarg2; 
  (arg1)->addIndex(arg2);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_delete_1btTriangleMesh(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  btTriangleMesh *arg1 = (btTriangleMesh *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(btTriangleMesh **)&jarg1; 
  delete arg1;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_new_1btConeShape(JNIEnv *jenv, jclass jcls, jfloat jarg1, jfloat jarg2) {
  jlong jresult = 0 ;
  btScalar arg1 ;
  btScalar arg2 ;
  btConeShape *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (btScalar)jarg1; 
  arg2 = (btScalar)jarg2; 
  result = (btConeShape *)new btConeShape(arg1,arg2);
  *(btConeShape **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btConeShape_1getRadius(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jfloat jresult = 0 ;
  btConeShape *arg1 = (btConeShape *) 0 ;
  btScalar result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btConeShape **)&jarg1; 
  result = (btScalar)((btConeShape const *)arg1)->getRadius();
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btConeShape_1getHeight(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jfloat jresult = 0 ;
  btConeShape *arg1 = (btConeShape *) 0 ;
  btScalar result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btConeShape **)&jarg1; 
  result = (btScalar)((btConeShape const *)arg1)->getHeight();
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btConeShape_1setRadius(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2) {
  btConeShape *arg1 = (btConeShape *) 0 ;
  btScalar arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btConeShape **)&jarg1; 
  arg2 = (btScalar)jarg2; 
  (arg1)->setRadius(arg2);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btConeShape_1setHeight(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2) {
  btConeShape *arg1 = (btConeShape *) 0 ;
  btScalar arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btConeShape **)&jarg1; 
  arg2 = (btScalar)jarg2; 
  (arg1)->setHeight(arg2);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btConeShape_1setConeUpIndex(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  btConeShape *arg1 = (btConeShape *) 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btConeShape **)&jarg1; 
  arg2 = (int)jarg2; 
  (arg1)->setConeUpIndex(arg2);
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btConeShape_1getConeUpIndex(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  btConeShape *arg1 = (btConeShape *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btConeShape **)&jarg1; 
  result = (int)((btConeShape const *)arg1)->getConeUpIndex();
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_delete_1btConeShape(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  btConeShape *arg1 = (btConeShape *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(btConeShape **)&jarg1; 
  delete arg1;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_new_1btConeShapeX(JNIEnv *jenv, jclass jcls, jfloat jarg1, jfloat jarg2) {
  jlong jresult = 0 ;
  btScalar arg1 ;
  btScalar arg2 ;
  btConeShapeX *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (btScalar)jarg1; 
  arg2 = (btScalar)jarg2; 
  result = (btConeShapeX *)new btConeShapeX(arg1,arg2);
  *(btConeShapeX **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_delete_1btConeShapeX(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  btConeShapeX *arg1 = (btConeShapeX *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(btConeShapeX **)&jarg1; 
  delete arg1;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_new_1btConeShapeZ(JNIEnv *jenv, jclass jcls, jfloat jarg1, jfloat jarg2) {
  jlong jresult = 0 ;
  btScalar arg1 ;
  btScalar arg2 ;
  btConeShapeZ *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (btScalar)jarg1; 
  arg2 = (btScalar)jarg2; 
  result = (btConeShapeZ *)new btConeShapeZ(arg1,arg2);
  *(btConeShapeZ **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_delete_1btConeShapeZ(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  btConeShapeZ *arg1 = (btConeShapeZ *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(btConeShapeZ **)&jarg1; 
  delete arg1;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btConeShapeData_1convexInternalShapeData_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btConeShapeData *arg1 = (btConeShapeData *) 0 ;
  btConvexInternalShapeData *arg2 = (btConvexInternalShapeData *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btConeShapeData **)&jarg1; 
  arg2 = *(btConvexInternalShapeData **)&jarg2; 
  if (arg1) (arg1)->m_convexInternalShapeData = *arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btConeShapeData_1convexInternalShapeData_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btConeShapeData *arg1 = (btConeShapeData *) 0 ;
  btConvexInternalShapeData *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btConeShapeData **)&jarg1; 
  result = (btConvexInternalShapeData *)& ((arg1)->m_convexInternalShapeData);
  *(btConvexInternalShapeData **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btConeShapeData_1upIndex_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  btConeShapeData *arg1 = (btConeShapeData *) 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btConeShapeData **)&jarg1; 
  arg2 = (int)jarg2; 
  if (arg1) (arg1)->m_upIndex = arg2;
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btConeShapeData_1upIndex_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  btConeShapeData *arg1 = (btConeShapeData *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btConeShapeData **)&jarg1; 
  result = (int) ((arg1)->m_upIndex);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btConeShapeData_1padding_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  btConeShapeData *arg1 = (btConeShapeData *) 0 ;
  char *arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btConeShapeData **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return ;
  }
  {
    if(arg2) {
      strncpy((char*)arg1->m_padding, (const char *)arg2, 4-1);
      arg1->m_padding[4-1] = 0;
    } else {
      arg1->m_padding[0] = 0;
    }
  }
  
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
}


SWIGEXPORT jstring JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btConeShapeData_1padding_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  btConeShapeData *arg1 = (btConeShapeData *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btConeShapeData **)&jarg1; 
  result = (char *)(char *) ((arg1)->m_padding);
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_new_1btConeShapeData(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  btConeShapeData *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (btConeShapeData *)new btConeShapeData();
  *(btConeShapeData **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_delete_1btConeShapeData(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  btConeShapeData *arg1 = (btConeShapeData *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(btConeShapeData **)&jarg1; 
  delete arg1;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_new_1btConvexTriangleMeshShape_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jboolean jarg2) {
  jlong jresult = 0 ;
  btStridingMeshInterface *arg1 = (btStridingMeshInterface *) 0 ;
  bool arg2 ;
  btConvexTriangleMeshShape *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btStridingMeshInterface **)&jarg1; 
  arg2 = jarg2 ? true : false; 
  result = (btConvexTriangleMeshShape *)new btConvexTriangleMeshShape(arg1,arg2);
  *(btConvexTriangleMeshShape **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_new_1btConvexTriangleMeshShape_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btStridingMeshInterface *arg1 = (btStridingMeshInterface *) 0 ;
  btConvexTriangleMeshShape *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btStridingMeshInterface **)&jarg1; 
  result = (btConvexTriangleMeshShape *)new btConvexTriangleMeshShape(arg1);
  *(btConvexTriangleMeshShape **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btConvexTriangleMeshShape_1getMeshInterface_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btConvexTriangleMeshShape *arg1 = (btConvexTriangleMeshShape *) 0 ;
  btStridingMeshInterface *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btConvexTriangleMeshShape **)&jarg1; 
  result = (btStridingMeshInterface *)(arg1)->getMeshInterface();
  *(btStridingMeshInterface **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btConvexTriangleMeshShape_1calculatePrincipalAxisTransform(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2, jobject jarg3, jlong jarg4) {
  btConvexTriangleMeshShape *arg1 = (btConvexTriangleMeshShape *) 0 ;
  btTransform *arg2 = 0 ;
  btVector3 *arg3 = 0 ;
  btScalar *arg4 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btConvexTriangleMeshShape **)&jarg1; 
  btTransform local_arg2;
  gdx_setbtTransformFromMatrix4(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitMatrix4 auto_commit_arg2(jenv, jarg2, &local_arg2);
  btVector3 local_arg3;
  gdx_setbtVector3FromVector3(jenv, local_arg3, jarg3);
  arg3 = &local_arg3;
  gdxAutoCommitVector3 auto_commit_arg3(jenv, jarg3, &local_arg3);
  arg4 = *(btScalar **)&jarg4;
  if (!arg4) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btScalar & reference is null");
    return ;
  } 
  ((btConvexTriangleMeshShape const *)arg1)->calculatePrincipalAxisTransform(*arg2,*arg3,*arg4);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_delete_1btConvexTriangleMeshShape(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  btConvexTriangleMeshShape *arg1 = (btConvexTriangleMeshShape *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(btConvexTriangleMeshShape **)&jarg1; 
  delete arg1;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_new_1btEmptyShape(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  btEmptyShape *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (btEmptyShape *)new btEmptyShape();
  *(btEmptyShape **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_delete_1btEmptyShape(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  btEmptyShape *arg1 = (btEmptyShape *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(btEmptyShape **)&jarg1; 
  delete arg1;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_new_1btMultimaterialTriangleMeshShape_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jboolean jarg2, jboolean jarg3) {
  jlong jresult = 0 ;
  btStridingMeshInterface *arg1 = (btStridingMeshInterface *) 0 ;
  bool arg2 ;
  bool arg3 ;
  btMultimaterialTriangleMeshShape *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btStridingMeshInterface **)&jarg1; 
  arg2 = jarg2 ? true : false; 
  arg3 = jarg3 ? true : false; 
  result = (btMultimaterialTriangleMeshShape *)new btMultimaterialTriangleMeshShape(arg1,arg2,arg3);
  *(btMultimaterialTriangleMeshShape **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_new_1btMultimaterialTriangleMeshShape_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jboolean jarg2) {
  jlong jresult = 0 ;
  btStridingMeshInterface *arg1 = (btStridingMeshInterface *) 0 ;
  bool arg2 ;
  btMultimaterialTriangleMeshShape *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btStridingMeshInterface **)&jarg1; 
  arg2 = jarg2 ? true : false; 
  result = (btMultimaterialTriangleMeshShape *)new btMultimaterialTriangleMeshShape(arg1,arg2);
  *(btMultimaterialTriangleMeshShape **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_new_1btMultimaterialTriangleMeshShape_1_1SWIG_12(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jboolean jarg2, jobject jarg3, jobject jarg4, jboolean jarg5) {
  jlong jresult = 0 ;
  btStridingMeshInterface *arg1 = (btStridingMeshInterface *) 0 ;
  bool arg2 ;
  btVector3 *arg3 = 0 ;
  btVector3 *arg4 = 0 ;
  bool arg5 ;
  btMultimaterialTriangleMeshShape *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btStridingMeshInterface **)&jarg1; 
  arg2 = jarg2 ? true : false; 
  btVector3 local_arg3;
  gdx_setbtVector3FromVector3(jenv, local_arg3, jarg3);
  arg3 = &local_arg3;
  gdxAutoCommitVector3 auto_commit_arg3(jenv, jarg3, &local_arg3);
  btVector3 local_arg4;
  gdx_setbtVector3FromVector3(jenv, local_arg4, jarg4);
  arg4 = &local_arg4;
  gdxAutoCommitVector3 auto_commit_arg4(jenv, jarg4, &local_arg4);
  arg5 = jarg5 ? true : false; 
  result = (btMultimaterialTriangleMeshShape *)new btMultimaterialTriangleMeshShape(arg1,arg2,(btVector3 const &)*arg3,(btVector3 const &)*arg4,arg5);
  *(btMultimaterialTriangleMeshShape **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_new_1btMultimaterialTriangleMeshShape_1_1SWIG_13(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jboolean jarg2, jobject jarg3, jobject jarg4) {
  jlong jresult = 0 ;
  btStridingMeshInterface *arg1 = (btStridingMeshInterface *) 0 ;
  bool arg2 ;
  btVector3 *arg3 = 0 ;
  btVector3 *arg4 = 0 ;
  btMultimaterialTriangleMeshShape *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btStridingMeshInterface **)&jarg1; 
  arg2 = jarg2 ? true : false; 
  btVector3 local_arg3;
  gdx_setbtVector3FromVector3(jenv, local_arg3, jarg3);
  arg3 = &local_arg3;
  gdxAutoCommitVector3 auto_commit_arg3(jenv, jarg3, &local_arg3);
  btVector3 local_arg4;
  gdx_setbtVector3FromVector3(jenv, local_arg4, jarg4);
  arg4 = &local_arg4;
  gdxAutoCommitVector3 auto_commit_arg4(jenv, jarg4, &local_arg4);
  result = (btMultimaterialTriangleMeshShape *)new btMultimaterialTriangleMeshShape(arg1,arg2,(btVector3 const &)*arg3,(btVector3 const &)*arg4);
  *(btMultimaterialTriangleMeshShape **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_delete_1btMultimaterialTriangleMeshShape(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  btMultimaterialTriangleMeshShape *arg1 = (btMultimaterialTriangleMeshShape *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(btMultimaterialTriangleMeshShape **)&jarg1; 
  delete arg1;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btMultimaterialTriangleMeshShape_1getMaterialProperties(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jint jarg3) {
  jlong jresult = 0 ;
  btMultimaterialTriangleMeshShape *arg1 = (btMultimaterialTriangleMeshShape *) 0 ;
  int arg2 ;
  int arg3 ;
  btMaterial *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btMultimaterialTriangleMeshShape **)&jarg1; 
  arg2 = (int)jarg2; 
  arg3 = (int)jarg3; 
  result = (btMaterial *)(arg1)->getMaterialProperties(arg2,arg3);
  *(btMaterial **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_new_1btBU_1Simplex1to4_1_1SWIG_10(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  btBU_Simplex1to4 *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (btBU_Simplex1to4 *)new btBU_Simplex1to4();
  *(btBU_Simplex1to4 **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_new_1btBU_1Simplex1to4_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jobject jarg1) {
  jlong jresult = 0 ;
  btVector3 *arg1 = 0 ;
  btBU_Simplex1to4 *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  btVector3 local_arg1;
  gdx_setbtVector3FromVector3(jenv, local_arg1, jarg1);
  arg1 = &local_arg1;
  gdxAutoCommitVector3 auto_commit_arg1(jenv, jarg1, &local_arg1);
  result = (btBU_Simplex1to4 *)new btBU_Simplex1to4((btVector3 const &)*arg1);
  *(btBU_Simplex1to4 **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_new_1btBU_1Simplex1to4_1_1SWIG_12(JNIEnv *jenv, jclass jcls, jobject jarg1, jobject jarg2) {
  jlong jresult = 0 ;
  btVector3 *arg1 = 0 ;
  btVector3 *arg2 = 0 ;
  btBU_Simplex1to4 *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  btVector3 local_arg1;
  gdx_setbtVector3FromVector3(jenv, local_arg1, jarg1);
  arg1 = &local_arg1;
  gdxAutoCommitVector3 auto_commit_arg1(jenv, jarg1, &local_arg1);
  btVector3 local_arg2;
  gdx_setbtVector3FromVector3(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitVector3 auto_commit_arg2(jenv, jarg2, &local_arg2);
  result = (btBU_Simplex1to4 *)new btBU_Simplex1to4((btVector3 const &)*arg1,(btVector3 const &)*arg2);
  *(btBU_Simplex1to4 **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_new_1btBU_1Simplex1to4_1_1SWIG_13(JNIEnv *jenv, jclass jcls, jobject jarg1, jobject jarg2, jobject jarg3) {
  jlong jresult = 0 ;
  btVector3 *arg1 = 0 ;
  btVector3 *arg2 = 0 ;
  btVector3 *arg3 = 0 ;
  btBU_Simplex1to4 *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  btVector3 local_arg1;
  gdx_setbtVector3FromVector3(jenv, local_arg1, jarg1);
  arg1 = &local_arg1;
  gdxAutoCommitVector3 auto_commit_arg1(jenv, jarg1, &local_arg1);
  btVector3 local_arg2;
  gdx_setbtVector3FromVector3(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitVector3 auto_commit_arg2(jenv, jarg2, &local_arg2);
  btVector3 local_arg3;
  gdx_setbtVector3FromVector3(jenv, local_arg3, jarg3);
  arg3 = &local_arg3;
  gdxAutoCommitVector3 auto_commit_arg3(jenv, jarg3, &local_arg3);
  result = (btBU_Simplex1to4 *)new btBU_Simplex1to4((btVector3 const &)*arg1,(btVector3 const &)*arg2,(btVector3 const &)*arg3);
  *(btBU_Simplex1to4 **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_new_1btBU_1Simplex1to4_1_1SWIG_14(JNIEnv *jenv, jclass jcls, jobject jarg1, jobject jarg2, jobject jarg3, jobject jarg4) {
  jlong jresult = 0 ;
  btVector3 *arg1 = 0 ;
  btVector3 *arg2 = 0 ;
  btVector3 *arg3 = 0 ;
  btVector3 *arg4 = 0 ;
  btBU_Simplex1to4 *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  btVector3 local_arg1;
  gdx_setbtVector3FromVector3(jenv, local_arg1, jarg1);
  arg1 = &local_arg1;
  gdxAutoCommitVector3 auto_commit_arg1(jenv, jarg1, &local_arg1);
  btVector3 local_arg2;
  gdx_setbtVector3FromVector3(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitVector3 auto_commit_arg2(jenv, jarg2, &local_arg2);
  btVector3 local_arg3;
  gdx_setbtVector3FromVector3(jenv, local_arg3, jarg3);
  arg3 = &local_arg3;
  gdxAutoCommitVector3 auto_commit_arg3(jenv, jarg3, &local_arg3);
  btVector3 local_arg4;
  gdx_setbtVector3FromVector3(jenv, local_arg4, jarg4);
  arg4 = &local_arg4;
  gdxAutoCommitVector3 auto_commit_arg4(jenv, jarg4, &local_arg4);
  result = (btBU_Simplex1to4 *)new btBU_Simplex1to4((btVector3 const &)*arg1,(btVector3 const &)*arg2,(btVector3 const &)*arg3,(btVector3 const &)*arg4);
  *(btBU_Simplex1to4 **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btBU_1Simplex1to4_1reset(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  btBU_Simplex1to4 *arg1 = (btBU_Simplex1to4 *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btBU_Simplex1to4 **)&jarg1; 
  (arg1)->reset();
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btBU_1Simplex1to4_1addVertex(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2) {
  btBU_Simplex1to4 *arg1 = (btBU_Simplex1to4 *) 0 ;
  btVector3 *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btBU_Simplex1to4 **)&jarg1; 
  btVector3 local_arg2;
  gdx_setbtVector3FromVector3(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitVector3 auto_commit_arg2(jenv, jarg2, &local_arg2);
  (arg1)->addVertex((btVector3 const &)*arg2);
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btBU_1Simplex1to4_1getIndex(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  jint jresult = 0 ;
  btBU_Simplex1to4 *arg1 = (btBU_Simplex1to4 *) 0 ;
  int arg2 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btBU_Simplex1to4 **)&jarg1; 
  arg2 = (int)jarg2; 
  result = (int)((btBU_Simplex1to4 const *)arg1)->getIndex(arg2);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_delete_1btBU_1Simplex1to4(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  btBU_Simplex1to4 *arg1 = (btBU_Simplex1to4 *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(btBU_Simplex1to4 **)&jarg1; 
  delete arg1;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_new_1btUniformScalingShape(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2) {
  jlong jresult = 0 ;
  btConvexShape *arg1 = (btConvexShape *) 0 ;
  btScalar arg2 ;
  btUniformScalingShape *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btConvexShape **)&jarg1; 
  arg2 = (btScalar)jarg2; 
  result = (btUniformScalingShape *)new btUniformScalingShape(arg1,arg2);
  *(btUniformScalingShape **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_delete_1btUniformScalingShape(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  btUniformScalingShape *arg1 = (btUniformScalingShape *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(btUniformScalingShape **)&jarg1; 
  delete arg1;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btUniformScalingShape_1getUniformScalingFactor(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jfloat jresult = 0 ;
  btUniformScalingShape *arg1 = (btUniformScalingShape *) 0 ;
  btScalar result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btUniformScalingShape **)&jarg1; 
  result = (btScalar)((btUniformScalingShape const *)arg1)->getUniformScalingFactor();
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btUniformScalingShape_1getChildShape_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btUniformScalingShape *arg1 = (btUniformScalingShape *) 0 ;
  btConvexShape *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btUniformScalingShape **)&jarg1; 
  result = (btConvexShape *)(arg1)->getChildShape();
  *(btConvexShape **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_new_1btConvexPointCloudShape_1_1SWIG_10(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  btConvexPointCloudShape *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (btConvexPointCloudShape *)new btConvexPointCloudShape();
  *(btConvexPointCloudShape **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_new_1btConvexPointCloudShape_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jobject jarg3, jboolean jarg4) {
  jlong jresult = 0 ;
  btVector3 *arg1 = (btVector3 *) 0 ;
  int arg2 ;
  btVector3 *arg3 = 0 ;
  bool arg4 ;
  btConvexPointCloudShape *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btVector3 **)&jarg1; 
  arg2 = (int)jarg2; 
  btVector3 local_arg3;
  gdx_setbtVector3FromVector3(jenv, local_arg3, jarg3);
  arg3 = &local_arg3;
  gdxAutoCommitVector3 auto_commit_arg3(jenv, jarg3, &local_arg3);
  arg4 = jarg4 ? true : false; 
  result = (btConvexPointCloudShape *)new btConvexPointCloudShape(arg1,arg2,(btVector3 const &)*arg3,arg4);
  *(btConvexPointCloudShape **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_new_1btConvexPointCloudShape_1_1SWIG_12(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jobject jarg3) {
  jlong jresult = 0 ;
  btVector3 *arg1 = (btVector3 *) 0 ;
  int arg2 ;
  btVector3 *arg3 = 0 ;
  btConvexPointCloudShape *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btVector3 **)&jarg1; 
  arg2 = (int)jarg2; 
  btVector3 local_arg3;
  gdx_setbtVector3FromVector3(jenv, local_arg3, jarg3);
  arg3 = &local_arg3;
  gdxAutoCommitVector3 auto_commit_arg3(jenv, jarg3, &local_arg3);
  result = (btConvexPointCloudShape *)new btConvexPointCloudShape(arg1,arg2,(btVector3 const &)*arg3);
  *(btConvexPointCloudShape **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btConvexPointCloudShape_1setPoints_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jint jarg3, jboolean jarg4, jobject jarg5) {
  btConvexPointCloudShape *arg1 = (btConvexPointCloudShape *) 0 ;
  btVector3 *arg2 = (btVector3 *) 0 ;
  int arg3 ;
  bool arg4 ;
  btVector3 *arg5 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btConvexPointCloudShape **)&jarg1; 
  arg2 = *(btVector3 **)&jarg2; 
  arg3 = (int)jarg3; 
  arg4 = jarg4 ? true : false; 
  btVector3 local_arg5;
  gdx_setbtVector3FromVector3(jenv, local_arg5, jarg5);
  arg5 = &local_arg5;
  gdxAutoCommitVector3 auto_commit_arg5(jenv, jarg5, &local_arg5);
  (arg1)->setPoints(arg2,arg3,arg4,(btVector3 const &)*arg5);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btConvexPointCloudShape_1setPoints_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jint jarg3, jboolean jarg4) {
  btConvexPointCloudShape *arg1 = (btConvexPointCloudShape *) 0 ;
  btVector3 *arg2 = (btVector3 *) 0 ;
  int arg3 ;
  bool arg4 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btConvexPointCloudShape **)&jarg1; 
  arg2 = *(btVector3 **)&jarg2; 
  arg3 = (int)jarg3; 
  arg4 = jarg4 ? true : false; 
  (arg1)->setPoints(arg2,arg3,arg4);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btConvexPointCloudShape_1setPoints_1_1SWIG_12(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jint jarg3) {
  btConvexPointCloudShape *arg1 = (btConvexPointCloudShape *) 0 ;
  btVector3 *arg2 = (btVector3 *) 0 ;
  int arg3 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btConvexPointCloudShape **)&jarg1; 
  arg2 = *(btVector3 **)&jarg2; 
  arg3 = (int)jarg3; 
  (arg1)->setPoints(arg2,arg3);
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btConvexPointCloudShape_1getUnscaledPoints_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btConvexPointCloudShape *arg1 = (btConvexPointCloudShape *) 0 ;
  btVector3 *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btConvexPointCloudShape **)&jarg1; 
  result = (btVector3 *)(arg1)->getUnscaledPoints();
  *(btVector3 **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btConvexPointCloudShape_1getNumPoints(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  btConvexPointCloudShape *arg1 = (btConvexPointCloudShape *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btConvexPointCloudShape **)&jarg1; 
  result = (int)((btConvexPointCloudShape const *)arg1)->getNumPoints();
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jobject JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btConvexPointCloudShape_1getScaledPoint(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  jobject jresult = 0 ;
  btConvexPointCloudShape *arg1 = (btConvexPointCloudShape *) 0 ;
  int arg2 ;
  btVector3 result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btConvexPointCloudShape **)&jarg1; 
  arg2 = (int)jarg2; 
  result = ((btConvexPointCloudShape const *)arg1)->getScaledPoint(arg2);
  jresult = gdx_getReturnVector3(jenv);
  gdx_setVector3FrombtVector3(jenv, jresult, result);
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_delete_1btConvexPointCloudShape(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  btConvexPointCloudShape *arg1 = (btConvexPointCloudShape *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(btConvexPointCloudShape **)&jarg1; 
  delete arg1;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_new_1btConvex2dShape(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btConvexShape *arg1 = (btConvexShape *) 0 ;
  btConvex2dShape *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btConvexShape **)&jarg1; 
  result = (btConvex2dShape *)new btConvex2dShape(arg1);
  *(btConvex2dShape **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_delete_1btConvex2dShape(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  btConvex2dShape *arg1 = (btConvex2dShape *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(btConvex2dShape **)&jarg1; 
  delete arg1;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btConvex2dShape_1getChildShape_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btConvex2dShape *arg1 = (btConvex2dShape *) 0 ;
  btConvexShape *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btConvex2dShape **)&jarg1; 
  result = (btConvexShape *)(arg1)->getChildShape();
  *(btConvexShape **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btCollisionObject_1mergesSimulationIslands(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  btCollisionObject *arg1 = (btCollisionObject *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btCollisionObject **)&jarg1; 
  result = (bool)((btCollisionObject const *)arg1)->mergesSimulationIslands();
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jobject JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btCollisionObject_1getAnisotropicFriction_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jobject jresult = 0 ;
  btCollisionObject *arg1 = (btCollisionObject *) 0 ;
  btVector3 *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btCollisionObject **)&jarg1; 
  result = (btVector3 *) &((btCollisionObject const *)arg1)->getAnisotropicFriction();
  jresult = gdx_getReturnVector3(jenv);
  gdx_setVector3FrombtVector3(jenv, jresult, result);
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btCollisionObject_1setAnisotropicFriction_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2, jint jarg3) {
  btCollisionObject *arg1 = (btCollisionObject *) 0 ;
  btVector3 *arg2 = 0 ;
  int arg3 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btCollisionObject **)&jarg1; 
  btVector3 local_arg2;
  gdx_setbtVector3FromVector3(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitVector3 auto_commit_arg2(jenv, jarg2, &local_arg2);
  arg3 = (int)jarg3; 
  (arg1)->setAnisotropicFriction((btVector3 const &)*arg2,arg3);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btCollisionObject_1setAnisotropicFriction_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2) {
  btCollisionObject *arg1 = (btCollisionObject *) 0 ;
  btVector3 *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btCollisionObject **)&jarg1; 
  btVector3 local_arg2;
  gdx_setbtVector3FromVector3(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitVector3 auto_commit_arg2(jenv, jarg2, &local_arg2);
  (arg1)->setAnisotropicFriction((btVector3 const &)*arg2);
}


SWIGEXPORT jboolean JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btCollisionObject_1hasAnisotropicFriction_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  jboolean jresult = 0 ;
  btCollisionObject *arg1 = (btCollisionObject *) 0 ;
  int arg2 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btCollisionObject **)&jarg1; 
  arg2 = (int)jarg2; 
  result = (bool)((btCollisionObject const *)arg1)->hasAnisotropicFriction(arg2);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btCollisionObject_1hasAnisotropicFriction_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  btCollisionObject *arg1 = (btCollisionObject *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btCollisionObject **)&jarg1; 
  result = (bool)((btCollisionObject const *)arg1)->hasAnisotropicFriction();
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btCollisionObject_1setContactProcessingThreshold(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2) {
  btCollisionObject *arg1 = (btCollisionObject *) 0 ;
  btScalar arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btCollisionObject **)&jarg1; 
  arg2 = (btScalar)jarg2; 
  (arg1)->setContactProcessingThreshold(arg2);
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btCollisionObject_1getContactProcessingThreshold(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jfloat jresult = 0 ;
  btCollisionObject *arg1 = (btCollisionObject *) 0 ;
  btScalar result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btCollisionObject **)&jarg1; 
  result = (btScalar)((btCollisionObject const *)arg1)->getContactProcessingThreshold();
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btCollisionObject_1isStaticObject(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  btCollisionObject *arg1 = (btCollisionObject *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btCollisionObject **)&jarg1; 
  result = (bool)((btCollisionObject const *)arg1)->isStaticObject();
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btCollisionObject_1isKinematicObject(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  btCollisionObject *arg1 = (btCollisionObject *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btCollisionObject **)&jarg1; 
  result = (bool)((btCollisionObject const *)arg1)->isKinematicObject();
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btCollisionObject_1isStaticOrKinematicObject(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  btCollisionObject *arg1 = (btCollisionObject *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btCollisionObject **)&jarg1; 
  result = (bool)((btCollisionObject const *)arg1)->isStaticOrKinematicObject();
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btCollisionObject_1hasContactResponse(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  btCollisionObject *arg1 = (btCollisionObject *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btCollisionObject **)&jarg1; 
  result = (bool)((btCollisionObject const *)arg1)->hasContactResponse();
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_new_1btCollisionObject(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  btCollisionObject *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (btCollisionObject *)new btCollisionObject();
  *(btCollisionObject **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_delete_1btCollisionObject(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  btCollisionObject *arg1 = (btCollisionObject *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(btCollisionObject **)&jarg1; 
  delete arg1;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btCollisionObject_1internalSetCollisionShape(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btCollisionObject *arg1 = (btCollisionObject *) 0 ;
  btCollisionShape *arg2 = (btCollisionShape *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btCollisionObject **)&jarg1; 
  arg2 = *(btCollisionShape **)&jarg2; 
  (arg1)->setCollisionShape(arg2);
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btCollisionObject_1internalGetCollisionShape_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btCollisionObject *arg1 = (btCollisionObject *) 0 ;
  btCollisionShape *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btCollisionObject **)&jarg1; 
  result = (btCollisionShape *)((btCollisionObject const *)arg1)->getCollisionShape();
  *(btCollisionShape **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btCollisionObject_1setIgnoreCollisionCheck(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jboolean jarg3) {
  btCollisionObject *arg1 = (btCollisionObject *) 0 ;
  btCollisionObject *arg2 = (btCollisionObject *) 0 ;
  bool arg3 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btCollisionObject **)&jarg1; 
  arg2 = *(btCollisionObject **)&jarg2; 
  arg3 = jarg3 ? true : false; 
  (arg1)->setIgnoreCollisionCheck((btCollisionObject const *)arg2,arg3);
}


SWIGEXPORT jboolean JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btCollisionObject_1checkCollideWithOverride(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  jboolean jresult = 0 ;
  btCollisionObject *arg1 = (btCollisionObject *) 0 ;
  btCollisionObject *arg2 = (btCollisionObject *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btCollisionObject **)&jarg1; 
  arg2 = *(btCollisionObject **)&jarg2; 
  result = (bool)((btCollisionObject const *)arg1)->checkCollideWithOverride((btCollisionObject const *)arg2);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btCollisionObject_1internalGetExtensionPointer(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btCollisionObject *arg1 = (btCollisionObject *) 0 ;
  void *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btCollisionObject **)&jarg1; 
  result = (void *)((btCollisionObject const *)arg1)->internalGetExtensionPointer();
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btCollisionObject_1internalSetExtensionPointer(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  btCollisionObject *arg1 = (btCollisionObject *) 0 ;
  void *arg2 = (void *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btCollisionObject **)&jarg1; 
  arg2 = (void *)jarg2; 
  (arg1)->internalSetExtensionPointer(arg2);
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btCollisionObject_1getActivationState(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  btCollisionObject *arg1 = (btCollisionObject *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btCollisionObject **)&jarg1; 
  result = (int)((btCollisionObject const *)arg1)->getActivationState();
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btCollisionObject_1setActivationState(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  btCollisionObject *arg1 = (btCollisionObject *) 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btCollisionObject **)&jarg1; 
  arg2 = (int)jarg2; 
  ((btCollisionObject const *)arg1)->setActivationState(arg2);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btCollisionObject_1setDeactivationTime(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2) {
  btCollisionObject *arg1 = (btCollisionObject *) 0 ;
  btScalar arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btCollisionObject **)&jarg1; 
  arg2 = (btScalar)jarg2; 
  (arg1)->setDeactivationTime(arg2);
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btCollisionObject_1getDeactivationTime(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jfloat jresult = 0 ;
  btCollisionObject *arg1 = (btCollisionObject *) 0 ;
  btScalar result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btCollisionObject **)&jarg1; 
  result = (btScalar)((btCollisionObject const *)arg1)->getDeactivationTime();
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btCollisionObject_1forceActivationState(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  btCollisionObject *arg1 = (btCollisionObject *) 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btCollisionObject **)&jarg1; 
  arg2 = (int)jarg2; 
  ((btCollisionObject const *)arg1)->forceActivationState(arg2);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btCollisionObject_1activate_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jboolean jarg2) {
  btCollisionObject *arg1 = (btCollisionObject *) 0 ;
  bool arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btCollisionObject **)&jarg1; 
  arg2 = jarg2 ? true : false; 
  ((btCollisionObject const *)arg1)->activate(arg2);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btCollisionObject_1activate_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  btCollisionObject *arg1 = (btCollisionObject *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btCollisionObject **)&jarg1; 
  ((btCollisionObject const *)arg1)->activate();
}


SWIGEXPORT jboolean JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btCollisionObject_1isActive(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  btCollisionObject *arg1 = (btCollisionObject *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btCollisionObject **)&jarg1; 
  result = (bool)((btCollisionObject const *)arg1)->isActive();
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btCollisionObject_1setRestitution(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2) {
  btCollisionObject *arg1 = (btCollisionObject *) 0 ;
  btScalar arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btCollisionObject **)&jarg1; 
  arg2 = (btScalar)jarg2; 
  (arg1)->setRestitution(arg2);
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btCollisionObject_1getRestitution(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jfloat jresult = 0 ;
  btCollisionObject *arg1 = (btCollisionObject *) 0 ;
  btScalar result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btCollisionObject **)&jarg1; 
  result = (btScalar)((btCollisionObject const *)arg1)->getRestitution();
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btCollisionObject_1setFriction(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2) {
  btCollisionObject *arg1 = (btCollisionObject *) 0 ;
  btScalar arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btCollisionObject **)&jarg1; 
  arg2 = (btScalar)jarg2; 
  (arg1)->setFriction(arg2);
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btCollisionObject_1getFriction(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jfloat jresult = 0 ;
  btCollisionObject *arg1 = (btCollisionObject *) 0 ;
  btScalar result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btCollisionObject **)&jarg1; 
  result = (btScalar)((btCollisionObject const *)arg1)->getFriction();
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btCollisionObject_1setRollingFriction(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2) {
  btCollisionObject *arg1 = (btCollisionObject *) 0 ;
  btScalar arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btCollisionObject **)&jarg1; 
  arg2 = (btScalar)jarg2; 
  (arg1)->setRollingFriction(arg2);
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btCollisionObject_1getRollingFriction(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jfloat jresult = 0 ;
  btCollisionObject *arg1 = (btCollisionObject *) 0 ;
  btScalar result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btCollisionObject **)&jarg1; 
  result = (btScalar)((btCollisionObject const *)arg1)->getRollingFriction();
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btCollisionObject_1setSpinningFriction(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2) {
  btCollisionObject *arg1 = (btCollisionObject *) 0 ;
  btScalar arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btCollisionObject **)&jarg1; 
  arg2 = (btScalar)jarg2; 
  (arg1)->setSpinningFriction(arg2);
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btCollisionObject_1getSpinningFriction(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jfloat jresult = 0 ;
  btCollisionObject *arg1 = (btCollisionObject *) 0 ;
  btScalar result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btCollisionObject **)&jarg1; 
  result = (btScalar)((btCollisionObject const *)arg1)->getSpinningFriction();
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btCollisionObject_1setContactStiffnessAndDamping(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2, jfloat jarg3) {
  btCollisionObject *arg1 = (btCollisionObject *) 0 ;
  btScalar arg2 ;
  btScalar arg3 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btCollisionObject **)&jarg1; 
  arg2 = (btScalar)jarg2; 
  arg3 = (btScalar)jarg3; 
  (arg1)->setContactStiffnessAndDamping(arg2,arg3);
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btCollisionObject_1getContactStiffness(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jfloat jresult = 0 ;
  btCollisionObject *arg1 = (btCollisionObject *) 0 ;
  btScalar result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btCollisionObject **)&jarg1; 
  result = (btScalar)((btCollisionObject const *)arg1)->getContactStiffness();
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btCollisionObject_1getContactDamping(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jfloat jresult = 0 ;
  btCollisionObject *arg1 = (btCollisionObject *) 0 ;
  btScalar result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btCollisionObject **)&jarg1; 
  result = (btScalar)((btCollisionObject const *)arg1)->getContactDamping();
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btCollisionObject_1getInternalType(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  btCollisionObject *arg1 = (btCollisionObject *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btCollisionObject **)&jarg1; 
  result = (int)((btCollisionObject const *)arg1)->getInternalType();
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jobject JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btCollisionObject_1getWorldTransform_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jobject jresult = 0 ;
  btCollisionObject *arg1 = (btCollisionObject *) 0 ;
  btTransform *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btCollisionObject **)&jarg1; 
  result = (btTransform *) &(arg1)->getWorldTransform();
  jresult = gdx_getReturnMatrix4(jenv);
  gdx_setMatrix4FrombtTransform(jenv, jresult, result);
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btCollisionObject_1setWorldTransform(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2) {
  btCollisionObject *arg1 = (btCollisionObject *) 0 ;
  btTransform *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btCollisionObject **)&jarg1; 
  btTransform local_arg2;
  gdx_setbtTransformFromMatrix4(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitMatrix4 auto_commit_arg2(jenv, jarg2, &local_arg2);
  (arg1)->setWorldTransform((btTransform const &)*arg2);
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btCollisionObject_1getBroadphaseHandle_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btCollisionObject *arg1 = (btCollisionObject *) 0 ;
  btBroadphaseProxy *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btCollisionObject **)&jarg1; 
  result = (btBroadphaseProxy *)(arg1)->getBroadphaseHandle();
  *(btBroadphaseProxy **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btCollisionObject_1setBroadphaseHandle(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btCollisionObject *arg1 = (btCollisionObject *) 0 ;
  btBroadphaseProxy *arg2 = (btBroadphaseProxy *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btCollisionObject **)&jarg1; 
  arg2 = *(btBroadphaseProxy **)&jarg2; 
  (arg1)->setBroadphaseHandle(arg2);
}


SWIGEXPORT jobject JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btCollisionObject_1getInterpolationWorldTransform_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jobject jresult = 0 ;
  btCollisionObject *arg1 = (btCollisionObject *) 0 ;
  btTransform *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btCollisionObject **)&jarg1; 
  result = (btTransform *) &((btCollisionObject const *)arg1)->getInterpolationWorldTransform();
  jresult = gdx_getReturnMatrix4(jenv);
  gdx_setMatrix4FrombtTransform(jenv, jresult, result);
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btCollisionObject_1setInterpolationWorldTransform(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2) {
  btCollisionObject *arg1 = (btCollisionObject *) 0 ;
  btTransform *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btCollisionObject **)&jarg1; 
  btTransform local_arg2;
  gdx_setbtTransformFromMatrix4(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitMatrix4 auto_commit_arg2(jenv, jarg2, &local_arg2);
  (arg1)->setInterpolationWorldTransform((btTransform const &)*arg2);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btCollisionObject_1setInterpolationLinearVelocity(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2) {
  btCollisionObject *arg1 = (btCollisionObject *) 0 ;
  btVector3 *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btCollisionObject **)&jarg1; 
  btVector3 local_arg2;
  gdx_setbtVector3FromVector3(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitVector3 auto_commit_arg2(jenv, jarg2, &local_arg2);
  (arg1)->setInterpolationLinearVelocity((btVector3 const &)*arg2);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btCollisionObject_1setInterpolationAngularVelocity(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2) {
  btCollisionObject *arg1 = (btCollisionObject *) 0 ;
  btVector3 *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btCollisionObject **)&jarg1; 
  btVector3 local_arg2;
  gdx_setbtVector3FromVector3(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitVector3 auto_commit_arg2(jenv, jarg2, &local_arg2);
  (arg1)->setInterpolationAngularVelocity((btVector3 const &)*arg2);
}


SWIGEXPORT jobject JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btCollisionObject_1getInterpolationLinearVelocity_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jobject jresult = 0 ;
  btCollisionObject *arg1 = (btCollisionObject *) 0 ;
  btVector3 *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btCollisionObject **)&jarg1; 
  result = (btVector3 *) &((btCollisionObject const *)arg1)->getInterpolationLinearVelocity();
  jresult = gdx_getReturnVector3(jenv);
  gdx_setVector3FrombtVector3(jenv, jresult, result);
  return jresult;
}


SWIGEXPORT jobject JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btCollisionObject_1getInterpolationAngularVelocity_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jobject jresult = 0 ;
  btCollisionObject *arg1 = (btCollisionObject *) 0 ;
  btVector3 *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btCollisionObject **)&jarg1; 
  result = (btVector3 *) &((btCollisionObject const *)arg1)->getInterpolationAngularVelocity();
  jresult = gdx_getReturnVector3(jenv);
  gdx_setVector3FrombtVector3(jenv, jresult, result);
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btCollisionObject_1getIslandTag(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  btCollisionObject *arg1 = (btCollisionObject *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btCollisionObject **)&jarg1; 
  result = (int)((btCollisionObject const *)arg1)->getIslandTag();
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btCollisionObject_1setIslandTag(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  btCollisionObject *arg1 = (btCollisionObject *) 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btCollisionObject **)&jarg1; 
  arg2 = (int)jarg2; 
  (arg1)->setIslandTag(arg2);
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btCollisionObject_1getCompanionId(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  btCollisionObject *arg1 = (btCollisionObject *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btCollisionObject **)&jarg1; 
  result = (int)((btCollisionObject const *)arg1)->getCompanionId();
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btCollisionObject_1setCompanionId(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  btCollisionObject *arg1 = (btCollisionObject *) 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btCollisionObject **)&jarg1; 
  arg2 = (int)jarg2; 
  (arg1)->setCompanionId(arg2);
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btCollisionObject_1getHitFraction(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jfloat jresult = 0 ;
  btCollisionObject *arg1 = (btCollisionObject *) 0 ;
  btScalar result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btCollisionObject **)&jarg1; 
  result = (btScalar)((btCollisionObject const *)arg1)->getHitFraction();
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btCollisionObject_1setHitFraction(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2) {
  btCollisionObject *arg1 = (btCollisionObject *) 0 ;
  btScalar arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btCollisionObject **)&jarg1; 
  arg2 = (btScalar)jarg2; 
  (arg1)->setHitFraction(arg2);
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btCollisionObject_1getCollisionFlags(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  btCollisionObject *arg1 = (btCollisionObject *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btCollisionObject **)&jarg1; 
  result = (int)((btCollisionObject const *)arg1)->getCollisionFlags();
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btCollisionObject_1setCollisionFlags(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  btCollisionObject *arg1 = (btCollisionObject *) 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btCollisionObject **)&jarg1; 
  arg2 = (int)jarg2; 
  (arg1)->setCollisionFlags(arg2);
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btCollisionObject_1getCcdSweptSphereRadius(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jfloat jresult = 0 ;
  btCollisionObject *arg1 = (btCollisionObject *) 0 ;
  btScalar result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btCollisionObject **)&jarg1; 
  result = (btScalar)((btCollisionObject const *)arg1)->getCcdSweptSphereRadius();
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btCollisionObject_1setCcdSweptSphereRadius(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2) {
  btCollisionObject *arg1 = (btCollisionObject *) 0 ;
  btScalar arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btCollisionObject **)&jarg1; 
  arg2 = (btScalar)jarg2; 
  (arg1)->setCcdSweptSphereRadius(arg2);
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btCollisionObject_1getCcdMotionThreshold(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jfloat jresult = 0 ;
  btCollisionObject *arg1 = (btCollisionObject *) 0 ;
  btScalar result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btCollisionObject **)&jarg1; 
  result = (btScalar)((btCollisionObject const *)arg1)->getCcdMotionThreshold();
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btCollisionObject_1getCcdSquareMotionThreshold(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jfloat jresult = 0 ;
  btCollisionObject *arg1 = (btCollisionObject *) 0 ;
  btScalar result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btCollisionObject **)&jarg1; 
  result = (btScalar)((btCollisionObject const *)arg1)->getCcdSquareMotionThreshold();
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btCollisionObject_1setCcdMotionThreshold(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2) {
  btCollisionObject *arg1 = (btCollisionObject *) 0 ;
  btScalar arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btCollisionObject **)&jarg1; 
  arg2 = (btScalar)jarg2; 
  (arg1)->setCcdMotionThreshold(arg2);
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btCollisionObject_1getUserPointer(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btCollisionObject *arg1 = (btCollisionObject *) 0 ;
  void *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btCollisionObject **)&jarg1; 
  result = (void *)((btCollisionObject const *)arg1)->getUserPointer();
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btCollisionObject_1getUserIndex(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  btCollisionObject *arg1 = (btCollisionObject *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btCollisionObject **)&jarg1; 
  result = (int)((btCollisionObject const *)arg1)->getUserIndex();
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btCollisionObject_1getUserIndex2(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  btCollisionObject *arg1 = (btCollisionObject *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btCollisionObject **)&jarg1; 
  result = (int)((btCollisionObject const *)arg1)->getUserIndex2();
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btCollisionObject_1setUserPointer(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  btCollisionObject *arg1 = (btCollisionObject *) 0 ;
  void *arg2 = (void *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btCollisionObject **)&jarg1; 
  arg2 = (void *)jarg2; 
  (arg1)->setUserPointer(arg2);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btCollisionObject_1setUserIndex(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  btCollisionObject *arg1 = (btCollisionObject *) 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btCollisionObject **)&jarg1; 
  arg2 = (int)jarg2; 
  (arg1)->setUserIndex(arg2);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btCollisionObject_1setUserIndex2(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  btCollisionObject *arg1 = (btCollisionObject *) 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btCollisionObject **)&jarg1; 
  arg2 = (int)jarg2; 
  (arg1)->setUserIndex2(arg2);
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btCollisionObject_1getUpdateRevisionInternal(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  btCollisionObject *arg1 = (btCollisionObject *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btCollisionObject **)&jarg1; 
  result = (int)((btCollisionObject const *)arg1)->getUpdateRevisionInternal();
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btCollisionObject_1checkCollideWith(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  jboolean jresult = 0 ;
  btCollisionObject *arg1 = (btCollisionObject *) 0 ;
  btCollisionObject *arg2 = (btCollisionObject *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btCollisionObject **)&jarg1; 
  arg2 = *(btCollisionObject **)&jarg2; 
  result = (bool)((btCollisionObject const *)arg1)->checkCollideWith((btCollisionObject const *)arg2);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btCollisionObject_1calculateSerializeBufferSize(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  btCollisionObject *arg1 = (btCollisionObject *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btCollisionObject **)&jarg1; 
  result = (int)((btCollisionObject const *)arg1)->calculateSerializeBufferSize();
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btCollisionObject_1serialize(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jlong jarg3) {
  jstring jresult = 0 ;
  btCollisionObject *arg1 = (btCollisionObject *) 0 ;
  void *arg2 = (void *) 0 ;
  btSerializer *arg3 = (btSerializer *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btCollisionObject **)&jarg1; 
  arg2 = (void *)jarg2; 
  arg3 = *(btSerializer **)&jarg3; 
  result = (char *)((btCollisionObject const *)arg1)->serialize(arg2,arg3);
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btCollisionObject_1serializeSingleObject(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  btCollisionObject *arg1 = (btCollisionObject *) 0 ;
  btSerializer *arg2 = (btSerializer *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btCollisionObject **)&jarg1; 
  arg2 = *(btSerializer **)&jarg2; 
  ((btCollisionObject const *)arg1)->serializeSingleObject(arg2);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btCollisionObject_1internalSetGdxBridge(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btCollisionObject *arg1 = (btCollisionObject *) 0 ;
  GdxCollisionObjectBridge *arg2 = (GdxCollisionObjectBridge *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btCollisionObject **)&jarg1; 
  arg2 = *(GdxCollisionObjectBridge **)&jarg2; 
  btCollisionObject_internalSetGdxBridge(arg1,arg2);
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btCollisionObject_1internalGetGdxBridge(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btCollisionObject *arg1 = (btCollisionObject *) 0 ;
  GdxCollisionObjectBridge *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btCollisionObject **)&jarg1; 
  result = (GdxCollisionObjectBridge *)btCollisionObject_internalGetGdxBridge(arg1);
  *(GdxCollisionObjectBridge **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btCollisionObject_1getAnisotropicFriction_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2) {
  btCollisionObject *arg1 = (btCollisionObject *) 0 ;
  btVector3 *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btCollisionObject **)&jarg1; 
  btVector3 local_arg2;
  gdx_setbtVector3FromVector3(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitVector3 auto_commit_arg2(jenv, jarg2, &local_arg2);
  btCollisionObject_getAnisotropicFriction__SWIG_1(arg1,*arg2);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btCollisionObject_1getWorldTransform_1_1SWIG_12(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2) {
  btCollisionObject *arg1 = (btCollisionObject *) 0 ;
  btTransform *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btCollisionObject **)&jarg1; 
  btTransform local_arg2;
  gdx_setbtTransformFromMatrix4(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitMatrix4 auto_commit_arg2(jenv, jarg2, &local_arg2);
  btCollisionObject_getWorldTransform__SWIG_2(arg1,*arg2);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btCollisionObject_1getInterpolationWorldTransform_1_1SWIG_12(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2) {
  btCollisionObject *arg1 = (btCollisionObject *) 0 ;
  btTransform *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btCollisionObject **)&jarg1; 
  btTransform local_arg2;
  gdx_setbtTransformFromMatrix4(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitMatrix4 auto_commit_arg2(jenv, jarg2, &local_arg2);
  btCollisionObject_getInterpolationWorldTransform__SWIG_2(arg1,*arg2);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btCollisionObject_1getInterpolationLinearVelocity_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2) {
  btCollisionObject *arg1 = (btCollisionObject *) 0 ;
  btVector3 *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btCollisionObject **)&jarg1; 
  btVector3 local_arg2;
  gdx_setbtVector3FromVector3(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitVector3 auto_commit_arg2(jenv, jarg2, &local_arg2);
  btCollisionObject_getInterpolationLinearVelocity__SWIG_1(arg1,*arg2);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btCollisionObject_1getInterpolationAngularVelocity_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2) {
  btCollisionObject *arg1 = (btCollisionObject *) 0 ;
  btVector3 *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btCollisionObject **)&jarg1; 
  btVector3 local_arg2;
  gdx_setbtVector3FromVector3(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitVector3 auto_commit_arg2(jenv, jarg2, &local_arg2);
  btCollisionObject_getInterpolationAngularVelocity__SWIG_1(arg1,*arg2);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btCollisionObjectDoubleData_1broadphaseHandle_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  btCollisionObjectDoubleData *arg1 = (btCollisionObjectDoubleData *) 0 ;
  void *arg2 = (void *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btCollisionObjectDoubleData **)&jarg1; 
  arg2 = (void *)jarg2; 
  if (arg1) (arg1)->m_broadphaseHandle = arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btCollisionObjectDoubleData_1broadphaseHandle_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btCollisionObjectDoubleData *arg1 = (btCollisionObjectDoubleData *) 0 ;
  void *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btCollisionObjectDoubleData **)&jarg1; 
  result = (void *) ((arg1)->m_broadphaseHandle);
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btCollisionObjectDoubleData_1collisionShape_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  btCollisionObjectDoubleData *arg1 = (btCollisionObjectDoubleData *) 0 ;
  void *arg2 = (void *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btCollisionObjectDoubleData **)&jarg1; 
  arg2 = (void *)jarg2; 
  if (arg1) (arg1)->m_collisionShape = arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btCollisionObjectDoubleData_1collisionShape_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btCollisionObjectDoubleData *arg1 = (btCollisionObjectDoubleData *) 0 ;
  void *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btCollisionObjectDoubleData **)&jarg1; 
  result = (void *) ((arg1)->m_collisionShape);
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btCollisionObjectDoubleData_1rootCollisionShape_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btCollisionObjectDoubleData *arg1 = (btCollisionObjectDoubleData *) 0 ;
  btCollisionShapeData *arg2 = (btCollisionShapeData *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btCollisionObjectDoubleData **)&jarg1; 
  arg2 = *(btCollisionShapeData **)&jarg2; 
  if (arg1) (arg1)->m_rootCollisionShape = arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btCollisionObjectDoubleData_1rootCollisionShape_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btCollisionObjectDoubleData *arg1 = (btCollisionObjectDoubleData *) 0 ;
  btCollisionShapeData *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btCollisionObjectDoubleData **)&jarg1; 
  result = (btCollisionShapeData *) ((arg1)->m_rootCollisionShape);
  *(btCollisionShapeData **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btCollisionObjectDoubleData_1name_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  btCollisionObjectDoubleData *arg1 = (btCollisionObjectDoubleData *) 0 ;
  char *arg2 = (char *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btCollisionObjectDoubleData **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return ;
  }
  {
    delete [] arg1->m_name;
    if (arg2) {
      arg1->m_name = (char *) (new char[strlen((const char *)arg2)+1]);
      strcpy((char *)arg1->m_name, (const char *)arg2);
    } else {
      arg1->m_name = 0;
    }
  }
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
}


SWIGEXPORT jstring JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btCollisionObjectDoubleData_1name_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  btCollisionObjectDoubleData *arg1 = (btCollisionObjectDoubleData *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btCollisionObjectDoubleData **)&jarg1; 
  result = (char *) ((arg1)->m_name);
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btCollisionObjectDoubleData_1worldTransform_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btCollisionObjectDoubleData *arg1 = (btCollisionObjectDoubleData *) 0 ;
  btTransformDoubleData *arg2 = (btTransformDoubleData *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btCollisionObjectDoubleData **)&jarg1; 
  arg2 = *(btTransformDoubleData **)&jarg2; 
  if (arg1) (arg1)->m_worldTransform = *arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btCollisionObjectDoubleData_1worldTransform_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btCollisionObjectDoubleData *arg1 = (btCollisionObjectDoubleData *) 0 ;
  btTransformDoubleData *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btCollisionObjectDoubleData **)&jarg1; 
  result = (btTransformDoubleData *)& ((arg1)->m_worldTransform);
  *(btTransformDoubleData **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btCollisionObjectDoubleData_1interpolationWorldTransform_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btCollisionObjectDoubleData *arg1 = (btCollisionObjectDoubleData *) 0 ;
  btTransformDoubleData *arg2 = (btTransformDoubleData *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btCollisionObjectDoubleData **)&jarg1; 
  arg2 = *(btTransformDoubleData **)&jarg2; 
  if (arg1) (arg1)->m_interpolationWorldTransform = *arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btCollisionObjectDoubleData_1interpolationWorldTransform_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btCollisionObjectDoubleData *arg1 = (btCollisionObjectDoubleData *) 0 ;
  btTransformDoubleData *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btCollisionObjectDoubleData **)&jarg1; 
  result = (btTransformDoubleData *)& ((arg1)->m_interpolationWorldTransform);
  *(btTransformDoubleData **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btCollisionObjectDoubleData_1interpolationLinearVelocity_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btCollisionObjectDoubleData *arg1 = (btCollisionObjectDoubleData *) 0 ;
  btVector3DoubleData *arg2 = (btVector3DoubleData *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btCollisionObjectDoubleData **)&jarg1; 
  arg2 = *(btVector3DoubleData **)&jarg2; 
  if (arg1) (arg1)->m_interpolationLinearVelocity = *arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btCollisionObjectDoubleData_1interpolationLinearVelocity_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btCollisionObjectDoubleData *arg1 = (btCollisionObjectDoubleData *) 0 ;
  btVector3DoubleData *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btCollisionObjectDoubleData **)&jarg1; 
  result = (btVector3DoubleData *)& ((arg1)->m_interpolationLinearVelocity);
  *(btVector3DoubleData **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btCollisionObjectDoubleData_1interpolationAngularVelocity_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btCollisionObjectDoubleData *arg1 = (btCollisionObjectDoubleData *) 0 ;
  btVector3DoubleData *arg2 = (btVector3DoubleData *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btCollisionObjectDoubleData **)&jarg1; 
  arg2 = *(btVector3DoubleData **)&jarg2; 
  if (arg1) (arg1)->m_interpolationAngularVelocity = *arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btCollisionObjectDoubleData_1interpolationAngularVelocity_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btCollisionObjectDoubleData *arg1 = (btCollisionObjectDoubleData *) 0 ;
  btVector3DoubleData *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btCollisionObjectDoubleData **)&jarg1; 
  result = (btVector3DoubleData *)& ((arg1)->m_interpolationAngularVelocity);
  *(btVector3DoubleData **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btCollisionObjectDoubleData_1anisotropicFriction_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btCollisionObjectDoubleData *arg1 = (btCollisionObjectDoubleData *) 0 ;
  btVector3DoubleData *arg2 = (btVector3DoubleData *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btCollisionObjectDoubleData **)&jarg1; 
  arg2 = *(btVector3DoubleData **)&jarg2; 
  if (arg1) (arg1)->m_anisotropicFriction = *arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btCollisionObjectDoubleData_1anisotropicFriction_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btCollisionObjectDoubleData *arg1 = (btCollisionObjectDoubleData *) 0 ;
  btVector3DoubleData *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btCollisionObjectDoubleData **)&jarg1; 
  result = (btVector3DoubleData *)& ((arg1)->m_anisotropicFriction);
  *(btVector3DoubleData **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btCollisionObjectDoubleData_1contactProcessingThreshold_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jdouble jarg2) {
  btCollisionObjectDoubleData *arg1 = (btCollisionObjectDoubleData *) 0 ;
  double arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btCollisionObjectDoubleData **)&jarg1; 
  arg2 = (double)jarg2; 
  if (arg1) (arg1)->m_contactProcessingThreshold = arg2;
}


SWIGEXPORT jdouble JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btCollisionObjectDoubleData_1contactProcessingThreshold_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jdouble jresult = 0 ;
  btCollisionObjectDoubleData *arg1 = (btCollisionObjectDoubleData *) 0 ;
  double result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btCollisionObjectDoubleData **)&jarg1; 
  result = (double) ((arg1)->m_contactProcessingThreshold);
  jresult = (jdouble)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btCollisionObjectDoubleData_1deactivationTime_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jdouble jarg2) {
  btCollisionObjectDoubleData *arg1 = (btCollisionObjectDoubleData *) 0 ;
  double arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btCollisionObjectDoubleData **)&jarg1; 
  arg2 = (double)jarg2; 
  if (arg1) (arg1)->m_deactivationTime = arg2;
}


SWIGEXPORT jdouble JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btCollisionObjectDoubleData_1deactivationTime_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jdouble jresult = 0 ;
  btCollisionObjectDoubleData *arg1 = (btCollisionObjectDoubleData *) 0 ;
  double result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btCollisionObjectDoubleData **)&jarg1; 
  result = (double) ((arg1)->m_deactivationTime);
  jresult = (jdouble)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btCollisionObjectDoubleData_1friction_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jdouble jarg2) {
  btCollisionObjectDoubleData *arg1 = (btCollisionObjectDoubleData *) 0 ;
  double arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btCollisionObjectDoubleData **)&jarg1; 
  arg2 = (double)jarg2; 
  if (arg1) (arg1)->m_friction = arg2;
}


SWIGEXPORT jdouble JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btCollisionObjectDoubleData_1friction_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jdouble jresult = 0 ;
  btCollisionObjectDoubleData *arg1 = (btCollisionObjectDoubleData *) 0 ;
  double result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btCollisionObjectDoubleData **)&jarg1; 
  result = (double) ((arg1)->m_friction);
  jresult = (jdouble)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btCollisionObjectDoubleData_1rollingFriction_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jdouble jarg2) {
  btCollisionObjectDoubleData *arg1 = (btCollisionObjectDoubleData *) 0 ;
  double arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btCollisionObjectDoubleData **)&jarg1; 
  arg2 = (double)jarg2; 
  if (arg1) (arg1)->m_rollingFriction = arg2;
}


SWIGEXPORT jdouble JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btCollisionObjectDoubleData_1rollingFriction_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jdouble jresult = 0 ;
  btCollisionObjectDoubleData *arg1 = (btCollisionObjectDoubleData *) 0 ;
  double result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btCollisionObjectDoubleData **)&jarg1; 
  result = (double) ((arg1)->m_rollingFriction);
  jresult = (jdouble)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btCollisionObjectDoubleData_1contactDamping_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jdouble jarg2) {
  btCollisionObjectDoubleData *arg1 = (btCollisionObjectDoubleData *) 0 ;
  double arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btCollisionObjectDoubleData **)&jarg1; 
  arg2 = (double)jarg2; 
  if (arg1) (arg1)->m_contactDamping = arg2;
}


SWIGEXPORT jdouble JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btCollisionObjectDoubleData_1contactDamping_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jdouble jresult = 0 ;
  btCollisionObjectDoubleData *arg1 = (btCollisionObjectDoubleData *) 0 ;
  double result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btCollisionObjectDoubleData **)&jarg1; 
  result = (double) ((arg1)->m_contactDamping);
  jresult = (jdouble)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btCollisionObjectDoubleData_1contactStiffness_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jdouble jarg2) {
  btCollisionObjectDoubleData *arg1 = (btCollisionObjectDoubleData *) 0 ;
  double arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btCollisionObjectDoubleData **)&jarg1; 
  arg2 = (double)jarg2; 
  if (arg1) (arg1)->m_contactStiffness = arg2;
}


SWIGEXPORT jdouble JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btCollisionObjectDoubleData_1contactStiffness_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jdouble jresult = 0 ;
  btCollisionObjectDoubleData *arg1 = (btCollisionObjectDoubleData *) 0 ;
  double result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btCollisionObjectDoubleData **)&jarg1; 
  result = (double) ((arg1)->m_contactStiffness);
  jresult = (jdouble)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btCollisionObjectDoubleData_1restitution_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jdouble jarg2) {
  btCollisionObjectDoubleData *arg1 = (btCollisionObjectDoubleData *) 0 ;
  double arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btCollisionObjectDoubleData **)&jarg1; 
  arg2 = (double)jarg2; 
  if (arg1) (arg1)->m_restitution = arg2;
}


SWIGEXPORT jdouble JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btCollisionObjectDoubleData_1restitution_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jdouble jresult = 0 ;
  btCollisionObjectDoubleData *arg1 = (btCollisionObjectDoubleData *) 0 ;
  double result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btCollisionObjectDoubleData **)&jarg1; 
  result = (double) ((arg1)->m_restitution);
  jresult = (jdouble)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btCollisionObjectDoubleData_1hitFraction_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jdouble jarg2) {
  btCollisionObjectDoubleData *arg1 = (btCollisionObjectDoubleData *) 0 ;
  double arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btCollisionObjectDoubleData **)&jarg1; 
  arg2 = (double)jarg2; 
  if (arg1) (arg1)->m_hitFraction = arg2;
}


SWIGEXPORT jdouble JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btCollisionObjectDoubleData_1hitFraction_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jdouble jresult = 0 ;
  btCollisionObjectDoubleData *arg1 = (btCollisionObjectDoubleData *) 0 ;
  double result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btCollisionObjectDoubleData **)&jarg1; 
  result = (double) ((arg1)->m_hitFraction);
  jresult = (jdouble)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btCollisionObjectDoubleData_1ccdSweptSphereRadius_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jdouble jarg2) {
  btCollisionObjectDoubleData *arg1 = (btCollisionObjectDoubleData *) 0 ;
  double arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btCollisionObjectDoubleData **)&jarg1; 
  arg2 = (double)jarg2; 
  if (arg1) (arg1)->m_ccdSweptSphereRadius = arg2;
}


SWIGEXPORT jdouble JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btCollisionObjectDoubleData_1ccdSweptSphereRadius_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jdouble jresult = 0 ;
  btCollisionObjectDoubleData *arg1 = (btCollisionObjectDoubleData *) 0 ;
  double result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btCollisionObjectDoubleData **)&jarg1; 
  result = (double) ((arg1)->m_ccdSweptSphereRadius);
  jresult = (jdouble)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btCollisionObjectDoubleData_1ccdMotionThreshold_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jdouble jarg2) {
  btCollisionObjectDoubleData *arg1 = (btCollisionObjectDoubleData *) 0 ;
  double arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btCollisionObjectDoubleData **)&jarg1; 
  arg2 = (double)jarg2; 
  if (arg1) (arg1)->m_ccdMotionThreshold = arg2;
}


SWIGEXPORT jdouble JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btCollisionObjectDoubleData_1ccdMotionThreshold_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jdouble jresult = 0 ;
  btCollisionObjectDoubleData *arg1 = (btCollisionObjectDoubleData *) 0 ;
  double result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btCollisionObjectDoubleData **)&jarg1; 
  result = (double) ((arg1)->m_ccdMotionThreshold);
  jresult = (jdouble)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btCollisionObjectDoubleData_1hasAnisotropicFriction_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  btCollisionObjectDoubleData *arg1 = (btCollisionObjectDoubleData *) 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btCollisionObjectDoubleData **)&jarg1; 
  arg2 = (int)jarg2; 
  if (arg1) (arg1)->m_hasAnisotropicFriction = arg2;
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btCollisionObjectDoubleData_1hasAnisotropicFriction_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  btCollisionObjectDoubleData *arg1 = (btCollisionObjectDoubleData *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btCollisionObjectDoubleData **)&jarg1; 
  result = (int) ((arg1)->m_hasAnisotropicFriction);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btCollisionObjectDoubleData_1collisionFlags_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  btCollisionObjectDoubleData *arg1 = (btCollisionObjectDoubleData *) 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btCollisionObjectDoubleData **)&jarg1; 
  arg2 = (int)jarg2; 
  if (arg1) (arg1)->m_collisionFlags = arg2;
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btCollisionObjectDoubleData_1collisionFlags_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  btCollisionObjectDoubleData *arg1 = (btCollisionObjectDoubleData *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btCollisionObjectDoubleData **)&jarg1; 
  result = (int) ((arg1)->m_collisionFlags);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btCollisionObjectDoubleData_1islandTag1_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  btCollisionObjectDoubleData *arg1 = (btCollisionObjectDoubleData *) 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btCollisionObjectDoubleData **)&jarg1; 
  arg2 = (int)jarg2; 
  if (arg1) (arg1)->m_islandTag1 = arg2;
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btCollisionObjectDoubleData_1islandTag1_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  btCollisionObjectDoubleData *arg1 = (btCollisionObjectDoubleData *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btCollisionObjectDoubleData **)&jarg1; 
  result = (int) ((arg1)->m_islandTag1);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btCollisionObjectDoubleData_1companionId_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  btCollisionObjectDoubleData *arg1 = (btCollisionObjectDoubleData *) 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btCollisionObjectDoubleData **)&jarg1; 
  arg2 = (int)jarg2; 
  if (arg1) (arg1)->m_companionId = arg2;
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btCollisionObjectDoubleData_1companionId_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  btCollisionObjectDoubleData *arg1 = (btCollisionObjectDoubleData *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btCollisionObjectDoubleData **)&jarg1; 
  result = (int) ((arg1)->m_companionId);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btCollisionObjectDoubleData_1activationState1_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  btCollisionObjectDoubleData *arg1 = (btCollisionObjectDoubleData *) 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btCollisionObjectDoubleData **)&jarg1; 
  arg2 = (int)jarg2; 
  if (arg1) (arg1)->m_activationState1 = arg2;
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btCollisionObjectDoubleData_1activationState1_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  btCollisionObjectDoubleData *arg1 = (btCollisionObjectDoubleData *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btCollisionObjectDoubleData **)&jarg1; 
  result = (int) ((arg1)->m_activationState1);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btCollisionObjectDoubleData_1internalType_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  btCollisionObjectDoubleData *arg1 = (btCollisionObjectDoubleData *) 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btCollisionObjectDoubleData **)&jarg1; 
  arg2 = (int)jarg2; 
  if (arg1) (arg1)->m_internalType = arg2;
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btCollisionObjectDoubleData_1internalType_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  btCollisionObjectDoubleData *arg1 = (btCollisionObjectDoubleData *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btCollisionObjectDoubleData **)&jarg1; 
  result = (int) ((arg1)->m_internalType);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btCollisionObjectDoubleData_1checkCollideWith_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  btCollisionObjectDoubleData *arg1 = (btCollisionObjectDoubleData *) 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btCollisionObjectDoubleData **)&jarg1; 
  arg2 = (int)jarg2; 
  if (arg1) (arg1)->m_checkCollideWith = arg2;
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btCollisionObjectDoubleData_1checkCollideWith_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  btCollisionObjectDoubleData *arg1 = (btCollisionObjectDoubleData *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btCollisionObjectDoubleData **)&jarg1; 
  result = (int) ((arg1)->m_checkCollideWith);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btCollisionObjectDoubleData_1padding_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  btCollisionObjectDoubleData *arg1 = (btCollisionObjectDoubleData *) 0 ;
  char *arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btCollisionObjectDoubleData **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return ;
  }
  {
    if(arg2) {
      strncpy((char*)arg1->m_padding, (const char *)arg2, 4-1);
      arg1->m_padding[4-1] = 0;
    } else {
      arg1->m_padding[0] = 0;
    }
  }
  
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
}


SWIGEXPORT jstring JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btCollisionObjectDoubleData_1padding_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  btCollisionObjectDoubleData *arg1 = (btCollisionObjectDoubleData *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btCollisionObjectDoubleData **)&jarg1; 
  result = (char *)(char *) ((arg1)->m_padding);
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_new_1btCollisionObjectDoubleData(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  btCollisionObjectDoubleData *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (btCollisionObjectDoubleData *)new btCollisionObjectDoubleData();
  *(btCollisionObjectDoubleData **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_delete_1btCollisionObjectDoubleData(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  btCollisionObjectDoubleData *arg1 = (btCollisionObjectDoubleData *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(btCollisionObjectDoubleData **)&jarg1; 
  delete arg1;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btCollisionObjectFloatData_1broadphaseHandle_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  btCollisionObjectFloatData *arg1 = (btCollisionObjectFloatData *) 0 ;
  void *arg2 = (void *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btCollisionObjectFloatData **)&jarg1; 
  arg2 = (void *)jarg2; 
  if (arg1) (arg1)->m_broadphaseHandle = arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btCollisionObjectFloatData_1broadphaseHandle_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btCollisionObjectFloatData *arg1 = (btCollisionObjectFloatData *) 0 ;
  void *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btCollisionObjectFloatData **)&jarg1; 
  result = (void *) ((arg1)->m_broadphaseHandle);
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btCollisionObjectFloatData_1collisionShape_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  btCollisionObjectFloatData *arg1 = (btCollisionObjectFloatData *) 0 ;
  void *arg2 = (void *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btCollisionObjectFloatData **)&jarg1; 
  arg2 = (void *)jarg2; 
  if (arg1) (arg1)->m_collisionShape = arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btCollisionObjectFloatData_1collisionShape_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btCollisionObjectFloatData *arg1 = (btCollisionObjectFloatData *) 0 ;
  void *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btCollisionObjectFloatData **)&jarg1; 
  result = (void *) ((arg1)->m_collisionShape);
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btCollisionObjectFloatData_1rootCollisionShape_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btCollisionObjectFloatData *arg1 = (btCollisionObjectFloatData *) 0 ;
  btCollisionShapeData *arg2 = (btCollisionShapeData *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btCollisionObjectFloatData **)&jarg1; 
  arg2 = *(btCollisionShapeData **)&jarg2; 
  if (arg1) (arg1)->m_rootCollisionShape = arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btCollisionObjectFloatData_1rootCollisionShape_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btCollisionObjectFloatData *arg1 = (btCollisionObjectFloatData *) 0 ;
  btCollisionShapeData *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btCollisionObjectFloatData **)&jarg1; 
  result = (btCollisionShapeData *) ((arg1)->m_rootCollisionShape);
  *(btCollisionShapeData **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btCollisionObjectFloatData_1name_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  btCollisionObjectFloatData *arg1 = (btCollisionObjectFloatData *) 0 ;
  char *arg2 = (char *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btCollisionObjectFloatData **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return ;
  }
  {
    delete [] arg1->m_name;
    if (arg2) {
      arg1->m_name = (char *) (new char[strlen((const char *)arg2)+1]);
      strcpy((char *)arg1->m_name, (const char *)arg2);
    } else {
      arg1->m_name = 0;
    }
  }
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
}


SWIGEXPORT jstring JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btCollisionObjectFloatData_1name_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  btCollisionObjectFloatData *arg1 = (btCollisionObjectFloatData *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btCollisionObjectFloatData **)&jarg1; 
  result = (char *) ((arg1)->m_name);
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btCollisionObjectFloatData_1worldTransform_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btCollisionObjectFloatData *arg1 = (btCollisionObjectFloatData *) 0 ;
  btTransformFloatData *arg2 = (btTransformFloatData *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btCollisionObjectFloatData **)&jarg1; 
  arg2 = *(btTransformFloatData **)&jarg2; 
  if (arg1) (arg1)->m_worldTransform = *arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btCollisionObjectFloatData_1worldTransform_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btCollisionObjectFloatData *arg1 = (btCollisionObjectFloatData *) 0 ;
  btTransformFloatData *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btCollisionObjectFloatData **)&jarg1; 
  result = (btTransformFloatData *)& ((arg1)->m_worldTransform);
  *(btTransformFloatData **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btCollisionObjectFloatData_1interpolationWorldTransform_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btCollisionObjectFloatData *arg1 = (btCollisionObjectFloatData *) 0 ;
  btTransformFloatData *arg2 = (btTransformFloatData *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btCollisionObjectFloatData **)&jarg1; 
  arg2 = *(btTransformFloatData **)&jarg2; 
  if (arg1) (arg1)->m_interpolationWorldTransform = *arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btCollisionObjectFloatData_1interpolationWorldTransform_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btCollisionObjectFloatData *arg1 = (btCollisionObjectFloatData *) 0 ;
  btTransformFloatData *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btCollisionObjectFloatData **)&jarg1; 
  result = (btTransformFloatData *)& ((arg1)->m_interpolationWorldTransform);
  *(btTransformFloatData **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btCollisionObjectFloatData_1interpolationLinearVelocity_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btCollisionObjectFloatData *arg1 = (btCollisionObjectFloatData *) 0 ;
  btVector3FloatData *arg2 = (btVector3FloatData *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btCollisionObjectFloatData **)&jarg1; 
  arg2 = *(btVector3FloatData **)&jarg2; 
  if (arg1) (arg1)->m_interpolationLinearVelocity = *arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btCollisionObjectFloatData_1interpolationLinearVelocity_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btCollisionObjectFloatData *arg1 = (btCollisionObjectFloatData *) 0 ;
  btVector3FloatData *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btCollisionObjectFloatData **)&jarg1; 
  result = (btVector3FloatData *)& ((arg1)->m_interpolationLinearVelocity);
  *(btVector3FloatData **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btCollisionObjectFloatData_1interpolationAngularVelocity_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btCollisionObjectFloatData *arg1 = (btCollisionObjectFloatData *) 0 ;
  btVector3FloatData *arg2 = (btVector3FloatData *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btCollisionObjectFloatData **)&jarg1; 
  arg2 = *(btVector3FloatData **)&jarg2; 
  if (arg1) (arg1)->m_interpolationAngularVelocity = *arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btCollisionObjectFloatData_1interpolationAngularVelocity_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btCollisionObjectFloatData *arg1 = (btCollisionObjectFloatData *) 0 ;
  btVector3FloatData *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btCollisionObjectFloatData **)&jarg1; 
  result = (btVector3FloatData *)& ((arg1)->m_interpolationAngularVelocity);
  *(btVector3FloatData **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btCollisionObjectFloatData_1anisotropicFriction_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btCollisionObjectFloatData *arg1 = (btCollisionObjectFloatData *) 0 ;
  btVector3FloatData *arg2 = (btVector3FloatData *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btCollisionObjectFloatData **)&jarg1; 
  arg2 = *(btVector3FloatData **)&jarg2; 
  if (arg1) (arg1)->m_anisotropicFriction = *arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btCollisionObjectFloatData_1anisotropicFriction_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btCollisionObjectFloatData *arg1 = (btCollisionObjectFloatData *) 0 ;
  btVector3FloatData *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btCollisionObjectFloatData **)&jarg1; 
  result = (btVector3FloatData *)& ((arg1)->m_anisotropicFriction);
  *(btVector3FloatData **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btCollisionObjectFloatData_1contactProcessingThreshold_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2) {
  btCollisionObjectFloatData *arg1 = (btCollisionObjectFloatData *) 0 ;
  float arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btCollisionObjectFloatData **)&jarg1; 
  arg2 = (float)jarg2; 
  if (arg1) (arg1)->m_contactProcessingThreshold = arg2;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btCollisionObjectFloatData_1contactProcessingThreshold_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jfloat jresult = 0 ;
  btCollisionObjectFloatData *arg1 = (btCollisionObjectFloatData *) 0 ;
  float result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btCollisionObjectFloatData **)&jarg1; 
  result = (float) ((arg1)->m_contactProcessingThreshold);
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btCollisionObjectFloatData_1deactivationTime_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2) {
  btCollisionObjectFloatData *arg1 = (btCollisionObjectFloatData *) 0 ;
  float arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btCollisionObjectFloatData **)&jarg1; 
  arg2 = (float)jarg2; 
  if (arg1) (arg1)->m_deactivationTime = arg2;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btCollisionObjectFloatData_1deactivationTime_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jfloat jresult = 0 ;
  btCollisionObjectFloatData *arg1 = (btCollisionObjectFloatData *) 0 ;
  float result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btCollisionObjectFloatData **)&jarg1; 
  result = (float) ((arg1)->m_deactivationTime);
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btCollisionObjectFloatData_1friction_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2) {
  btCollisionObjectFloatData *arg1 = (btCollisionObjectFloatData *) 0 ;
  float arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btCollisionObjectFloatData **)&jarg1; 
  arg2 = (float)jarg2; 
  if (arg1) (arg1)->m_friction = arg2;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btCollisionObjectFloatData_1friction_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jfloat jresult = 0 ;
  btCollisionObjectFloatData *arg1 = (btCollisionObjectFloatData *) 0 ;
  float result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btCollisionObjectFloatData **)&jarg1; 
  result = (float) ((arg1)->m_friction);
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btCollisionObjectFloatData_1rollingFriction_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2) {
  btCollisionObjectFloatData *arg1 = (btCollisionObjectFloatData *) 0 ;
  float arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btCollisionObjectFloatData **)&jarg1; 
  arg2 = (float)jarg2; 
  if (arg1) (arg1)->m_rollingFriction = arg2;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btCollisionObjectFloatData_1rollingFriction_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jfloat jresult = 0 ;
  btCollisionObjectFloatData *arg1 = (btCollisionObjectFloatData *) 0 ;
  float result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btCollisionObjectFloatData **)&jarg1; 
  result = (float) ((arg1)->m_rollingFriction);
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btCollisionObjectFloatData_1contactDamping_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2) {
  btCollisionObjectFloatData *arg1 = (btCollisionObjectFloatData *) 0 ;
  float arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btCollisionObjectFloatData **)&jarg1; 
  arg2 = (float)jarg2; 
  if (arg1) (arg1)->m_contactDamping = arg2;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btCollisionObjectFloatData_1contactDamping_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jfloat jresult = 0 ;
  btCollisionObjectFloatData *arg1 = (btCollisionObjectFloatData *) 0 ;
  float result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btCollisionObjectFloatData **)&jarg1; 
  result = (float) ((arg1)->m_contactDamping);
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btCollisionObjectFloatData_1contactStiffness_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2) {
  btCollisionObjectFloatData *arg1 = (btCollisionObjectFloatData *) 0 ;
  float arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btCollisionObjectFloatData **)&jarg1; 
  arg2 = (float)jarg2; 
  if (arg1) (arg1)->m_contactStiffness = arg2;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btCollisionObjectFloatData_1contactStiffness_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jfloat jresult = 0 ;
  btCollisionObjectFloatData *arg1 = (btCollisionObjectFloatData *) 0 ;
  float result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btCollisionObjectFloatData **)&jarg1; 
  result = (float) ((arg1)->m_contactStiffness);
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btCollisionObjectFloatData_1restitution_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2) {
  btCollisionObjectFloatData *arg1 = (btCollisionObjectFloatData *) 0 ;
  float arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btCollisionObjectFloatData **)&jarg1; 
  arg2 = (float)jarg2; 
  if (arg1) (arg1)->m_restitution = arg2;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btCollisionObjectFloatData_1restitution_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jfloat jresult = 0 ;
  btCollisionObjectFloatData *arg1 = (btCollisionObjectFloatData *) 0 ;
  float result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btCollisionObjectFloatData **)&jarg1; 
  result = (float) ((arg1)->m_restitution);
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btCollisionObjectFloatData_1hitFraction_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2) {
  btCollisionObjectFloatData *arg1 = (btCollisionObjectFloatData *) 0 ;
  float arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btCollisionObjectFloatData **)&jarg1; 
  arg2 = (float)jarg2; 
  if (arg1) (arg1)->m_hitFraction = arg2;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btCollisionObjectFloatData_1hitFraction_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jfloat jresult = 0 ;
  btCollisionObjectFloatData *arg1 = (btCollisionObjectFloatData *) 0 ;
  float result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btCollisionObjectFloatData **)&jarg1; 
  result = (float) ((arg1)->m_hitFraction);
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btCollisionObjectFloatData_1ccdSweptSphereRadius_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2) {
  btCollisionObjectFloatData *arg1 = (btCollisionObjectFloatData *) 0 ;
  float arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btCollisionObjectFloatData **)&jarg1; 
  arg2 = (float)jarg2; 
  if (arg1) (arg1)->m_ccdSweptSphereRadius = arg2;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btCollisionObjectFloatData_1ccdSweptSphereRadius_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jfloat jresult = 0 ;
  btCollisionObjectFloatData *arg1 = (btCollisionObjectFloatData *) 0 ;
  float result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btCollisionObjectFloatData **)&jarg1; 
  result = (float) ((arg1)->m_ccdSweptSphereRadius);
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btCollisionObjectFloatData_1ccdMotionThreshold_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2) {
  btCollisionObjectFloatData *arg1 = (btCollisionObjectFloatData *) 0 ;
  float arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btCollisionObjectFloatData **)&jarg1; 
  arg2 = (float)jarg2; 
  if (arg1) (arg1)->m_ccdMotionThreshold = arg2;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btCollisionObjectFloatData_1ccdMotionThreshold_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jfloat jresult = 0 ;
  btCollisionObjectFloatData *arg1 = (btCollisionObjectFloatData *) 0 ;
  float result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btCollisionObjectFloatData **)&jarg1; 
  result = (float) ((arg1)->m_ccdMotionThreshold);
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btCollisionObjectFloatData_1hasAnisotropicFriction_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  btCollisionObjectFloatData *arg1 = (btCollisionObjectFloatData *) 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btCollisionObjectFloatData **)&jarg1; 
  arg2 = (int)jarg2; 
  if (arg1) (arg1)->m_hasAnisotropicFriction = arg2;
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btCollisionObjectFloatData_1hasAnisotropicFriction_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  btCollisionObjectFloatData *arg1 = (btCollisionObjectFloatData *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btCollisionObjectFloatData **)&jarg1; 
  result = (int) ((arg1)->m_hasAnisotropicFriction);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btCollisionObjectFloatData_1collisionFlags_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  btCollisionObjectFloatData *arg1 = (btCollisionObjectFloatData *) 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btCollisionObjectFloatData **)&jarg1; 
  arg2 = (int)jarg2; 
  if (arg1) (arg1)->m_collisionFlags = arg2;
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btCollisionObjectFloatData_1collisionFlags_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  btCollisionObjectFloatData *arg1 = (btCollisionObjectFloatData *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btCollisionObjectFloatData **)&jarg1; 
  result = (int) ((arg1)->m_collisionFlags);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btCollisionObjectFloatData_1islandTag1_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  btCollisionObjectFloatData *arg1 = (btCollisionObjectFloatData *) 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btCollisionObjectFloatData **)&jarg1; 
  arg2 = (int)jarg2; 
  if (arg1) (arg1)->m_islandTag1 = arg2;
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btCollisionObjectFloatData_1islandTag1_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  btCollisionObjectFloatData *arg1 = (btCollisionObjectFloatData *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btCollisionObjectFloatData **)&jarg1; 
  result = (int) ((arg1)->m_islandTag1);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btCollisionObjectFloatData_1companionId_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  btCollisionObjectFloatData *arg1 = (btCollisionObjectFloatData *) 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btCollisionObjectFloatData **)&jarg1; 
  arg2 = (int)jarg2; 
  if (arg1) (arg1)->m_companionId = arg2;
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btCollisionObjectFloatData_1companionId_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  btCollisionObjectFloatData *arg1 = (btCollisionObjectFloatData *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btCollisionObjectFloatData **)&jarg1; 
  result = (int) ((arg1)->m_companionId);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btCollisionObjectFloatData_1activationState1_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  btCollisionObjectFloatData *arg1 = (btCollisionObjectFloatData *) 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btCollisionObjectFloatData **)&jarg1; 
  arg2 = (int)jarg2; 
  if (arg1) (arg1)->m_activationState1 = arg2;
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btCollisionObjectFloatData_1activationState1_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  btCollisionObjectFloatData *arg1 = (btCollisionObjectFloatData *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btCollisionObjectFloatData **)&jarg1; 
  result = (int) ((arg1)->m_activationState1);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btCollisionObjectFloatData_1internalType_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  btCollisionObjectFloatData *arg1 = (btCollisionObjectFloatData *) 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btCollisionObjectFloatData **)&jarg1; 
  arg2 = (int)jarg2; 
  if (arg1) (arg1)->m_internalType = arg2;
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btCollisionObjectFloatData_1internalType_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  btCollisionObjectFloatData *arg1 = (btCollisionObjectFloatData *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btCollisionObjectFloatData **)&jarg1; 
  result = (int) ((arg1)->m_internalType);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btCollisionObjectFloatData_1checkCollideWith_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  btCollisionObjectFloatData *arg1 = (btCollisionObjectFloatData *) 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btCollisionObjectFloatData **)&jarg1; 
  arg2 = (int)jarg2; 
  if (arg1) (arg1)->m_checkCollideWith = arg2;
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btCollisionObjectFloatData_1checkCollideWith_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  btCollisionObjectFloatData *arg1 = (btCollisionObjectFloatData *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btCollisionObjectFloatData **)&jarg1; 
  result = (int) ((arg1)->m_checkCollideWith);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btCollisionObjectFloatData_1padding_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  btCollisionObjectFloatData *arg1 = (btCollisionObjectFloatData *) 0 ;
  char *arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btCollisionObjectFloatData **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return ;
  }
  {
    if(arg2) {
      strncpy((char*)arg1->m_padding, (const char *)arg2, 4-1);
      arg1->m_padding[4-1] = 0;
    } else {
      arg1->m_padding[0] = 0;
    }
  }
  
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
}


SWIGEXPORT jstring JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btCollisionObjectFloatData_1padding_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  btCollisionObjectFloatData *arg1 = (btCollisionObjectFloatData *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btCollisionObjectFloatData **)&jarg1; 
  result = (char *)(char *) ((arg1)->m_padding);
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_new_1btCollisionObjectFloatData(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  btCollisionObjectFloatData *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (btCollisionObjectFloatData *)new btCollisionObjectFloatData();
  *(btCollisionObjectFloatData **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_delete_1btCollisionObjectFloatData(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  btCollisionObjectFloatData *arg1 = (btCollisionObjectFloatData *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(btCollisionObjectFloatData **)&jarg1; 
  delete arg1;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_GdxCollisionObjectBridge_1userValue_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  GdxCollisionObjectBridge *arg1 = (GdxCollisionObjectBridge *) 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(GdxCollisionObjectBridge **)&jarg1; 
  arg2 = (int)jarg2; 
  if (arg1) (arg1)->userValue = arg2;
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_GdxCollisionObjectBridge_1userValue_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  GdxCollisionObjectBridge *arg1 = (GdxCollisionObjectBridge *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(GdxCollisionObjectBridge **)&jarg1; 
  result = (int) ((arg1)->userValue);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_GdxCollisionObjectBridge_1contactCallbackFlag_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  GdxCollisionObjectBridge *arg1 = (GdxCollisionObjectBridge *) 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(GdxCollisionObjectBridge **)&jarg1; 
  arg2 = (int)jarg2; 
  if (arg1) (arg1)->contactCallbackFlag = arg2;
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_GdxCollisionObjectBridge_1contactCallbackFlag_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  GdxCollisionObjectBridge *arg1 = (GdxCollisionObjectBridge *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(GdxCollisionObjectBridge **)&jarg1; 
  result = (int) ((arg1)->contactCallbackFlag);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_GdxCollisionObjectBridge_1contactCallbackFilter_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  GdxCollisionObjectBridge *arg1 = (GdxCollisionObjectBridge *) 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(GdxCollisionObjectBridge **)&jarg1; 
  arg2 = (int)jarg2; 
  if (arg1) (arg1)->contactCallbackFilter = arg2;
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_GdxCollisionObjectBridge_1contactCallbackFilter_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  GdxCollisionObjectBridge *arg1 = (GdxCollisionObjectBridge *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(GdxCollisionObjectBridge **)&jarg1; 
  result = (int) ((arg1)->contactCallbackFilter);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_new_1GdxCollisionObjectBridge(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  GdxCollisionObjectBridge *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (GdxCollisionObjectBridge *)new GdxCollisionObjectBridge();
  *(GdxCollisionObjectBridge **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_delete_1GdxCollisionObjectBridge(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  GdxCollisionObjectBridge *arg1 = (GdxCollisionObjectBridge *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(GdxCollisionObjectBridge **)&jarg1; 
  delete arg1;
}


SWIGEXPORT jboolean JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_gdxCheckFilter_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jint jarg1, jint jarg2) {
  jboolean jresult = 0 ;
  int arg1 ;
  int arg2 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (int)jarg1; 
  arg2 = (int)jarg2; 
  result = (bool)gdxCheckFilter(arg1,arg2);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_gdxCheckFilter_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  jboolean jresult = 0 ;
  btCollisionObject *arg1 = (btCollisionObject *) 0 ;
  btCollisionObject *arg2 = (btCollisionObject *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btCollisionObject **)&jarg1; 
  arg2 = *(btCollisionObject **)&jarg2; 
  result = (bool)gdxCheckFilter((btCollisionObject const *)arg1,(btCollisionObject const *)arg2);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jobject JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btDbvtAabbMm_1Center(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jobject jresult = 0 ;
  btDbvtAabbMm *arg1 = (btDbvtAabbMm *) 0 ;
  btVector3 result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btDbvtAabbMm **)&jarg1; 
  result = ((btDbvtAabbMm const *)arg1)->Center();
  jresult = gdx_getReturnVector3(jenv);
  gdx_setVector3FrombtVector3(jenv, jresult, result);
  return jresult;
}


SWIGEXPORT jobject JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btDbvtAabbMm_1Lengths(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jobject jresult = 0 ;
  btDbvtAabbMm *arg1 = (btDbvtAabbMm *) 0 ;
  btVector3 result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btDbvtAabbMm **)&jarg1; 
  result = ((btDbvtAabbMm const *)arg1)->Lengths();
  jresult = gdx_getReturnVector3(jenv);
  gdx_setVector3FrombtVector3(jenv, jresult, result);
  return jresult;
}


SWIGEXPORT jobject JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btDbvtAabbMm_1Extents(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jobject jresult = 0 ;
  btDbvtAabbMm *arg1 = (btDbvtAabbMm *) 0 ;
  btVector3 result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btDbvtAabbMm **)&jarg1; 
  result = ((btDbvtAabbMm const *)arg1)->Extents();
  jresult = gdx_getReturnVector3(jenv);
  gdx_setVector3FrombtVector3(jenv, jresult, result);
  return jresult;
}


SWIGEXPORT jobject JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btDbvtAabbMm_1Mins(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jobject jresult = 0 ;
  btDbvtAabbMm *arg1 = (btDbvtAabbMm *) 0 ;
  btVector3 *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btDbvtAabbMm **)&jarg1; 
  result = (btVector3 *) &((btDbvtAabbMm const *)arg1)->Mins();
  jresult = gdx_getReturnVector3(jenv);
  gdx_setVector3FrombtVector3(jenv, jresult, result);
  return jresult;
}


SWIGEXPORT jobject JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btDbvtAabbMm_1Maxs(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jobject jresult = 0 ;
  btDbvtAabbMm *arg1 = (btDbvtAabbMm *) 0 ;
  btVector3 *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btDbvtAabbMm **)&jarg1; 
  result = (btVector3 *) &((btDbvtAabbMm const *)arg1)->Maxs();
  jresult = gdx_getReturnVector3(jenv);
  gdx_setVector3FrombtVector3(jenv, jresult, result);
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btDbvtAabbMm_1FromCE(JNIEnv *jenv, jclass jcls, jobject jarg1, jobject jarg2) {
  jlong jresult = 0 ;
  btVector3 *arg1 = 0 ;
  btVector3 *arg2 = 0 ;
  btDbvtAabbMm result;
  
  (void)jenv;
  (void)jcls;
  btVector3 local_arg1;
  gdx_setbtVector3FromVector3(jenv, local_arg1, jarg1);
  arg1 = &local_arg1;
  gdxAutoCommitVector3 auto_commit_arg1(jenv, jarg1, &local_arg1);
  btVector3 local_arg2;
  gdx_setbtVector3FromVector3(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitVector3 auto_commit_arg2(jenv, jarg2, &local_arg2);
  result = btDbvtAabbMm::FromCE((btVector3 const &)*arg1,(btVector3 const &)*arg2);
  *(btDbvtAabbMm **)&jresult = new btDbvtAabbMm((const btDbvtAabbMm &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btDbvtAabbMm_1FromCR(JNIEnv *jenv, jclass jcls, jobject jarg1, jfloat jarg2) {
  jlong jresult = 0 ;
  btVector3 *arg1 = 0 ;
  btScalar arg2 ;
  btDbvtAabbMm result;
  
  (void)jenv;
  (void)jcls;
  btVector3 local_arg1;
  gdx_setbtVector3FromVector3(jenv, local_arg1, jarg1);
  arg1 = &local_arg1;
  gdxAutoCommitVector3 auto_commit_arg1(jenv, jarg1, &local_arg1);
  arg2 = (btScalar)jarg2; 
  result = btDbvtAabbMm::FromCR((btVector3 const &)*arg1,arg2);
  *(btDbvtAabbMm **)&jresult = new btDbvtAabbMm((const btDbvtAabbMm &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btDbvtAabbMm_1FromMM(JNIEnv *jenv, jclass jcls, jobject jarg1, jobject jarg2) {
  jlong jresult = 0 ;
  btVector3 *arg1 = 0 ;
  btVector3 *arg2 = 0 ;
  btDbvtAabbMm result;
  
  (void)jenv;
  (void)jcls;
  btVector3 local_arg1;
  gdx_setbtVector3FromVector3(jenv, local_arg1, jarg1);
  arg1 = &local_arg1;
  gdxAutoCommitVector3 auto_commit_arg1(jenv, jarg1, &local_arg1);
  btVector3 local_arg2;
  gdx_setbtVector3FromVector3(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitVector3 auto_commit_arg2(jenv, jarg2, &local_arg2);
  result = btDbvtAabbMm::FromMM((btVector3 const &)*arg1,(btVector3 const &)*arg2);
  *(btDbvtAabbMm **)&jresult = new btDbvtAabbMm((const btDbvtAabbMm &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btDbvtAabbMm_1FromPoints_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  jlong jresult = 0 ;
  btVector3 *arg1 = (btVector3 *) 0 ;
  int arg2 ;
  btDbvtAabbMm result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btVector3 **)&jarg1; 
  arg2 = (int)jarg2; 
  result = btDbvtAabbMm::FromPoints((btVector3 const *)arg1,arg2);
  *(btDbvtAabbMm **)&jresult = new btDbvtAabbMm((const btDbvtAabbMm &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btDbvtAabbMm_1FromPoints_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
  jlong jresult = 0 ;
  btVector3 **arg1 = (btVector3 **) 0 ;
  int arg2 ;
  btDbvtAabbMm result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(btVector3 ***)&jarg1; 
  arg2 = (int)jarg2; 
  result = btDbvtAabbMm::FromPoints((btVector3 const **)arg1,arg2);
  *(btDbvtAabbMm **)&jresult = new btDbvtAabbMm((const btDbvtAabbMm &)result); 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btDbvtAabbMm_1Expand(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2) {
  btDbvtAabbMm *arg1 = (btDbvtAabbMm *) 0 ;
  btVector3 *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btDbvtAabbMm **)&jarg1; 
  btVector3 local_arg2;
  gdx_setbtVector3FromVector3(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitVector3 auto_commit_arg2(jenv, jarg2, &local_arg2);
  (arg1)->Expand((btVector3 const &)*arg2);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btDbvtAabbMm_1SignedExpand(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2) {
  btDbvtAabbMm *arg1 = (btDbvtAabbMm *) 0 ;
  btVector3 *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btDbvtAabbMm **)&jarg1; 
  btVector3 local_arg2;
  gdx_setbtVector3FromVector3(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitVector3 auto_commit_arg2(jenv, jarg2, &local_arg2);
  (arg1)->SignedExpand((btVector3 const &)*arg2);
}


SWIGEXPORT jboolean JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btDbvtAabbMm_1Contain(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  jboolean jresult = 0 ;
  btDbvtAabbMm *arg1 = (btDbvtAabbMm *) 0 ;
  btDbvtAabbMm *arg2 = 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btDbvtAabbMm **)&jarg1; 
  arg2 = *(btDbvtAabbMm **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btDbvtAabbMm const & reference is null");
    return 0;
  } 
  result = (bool)((btDbvtAabbMm const *)arg1)->Contain((btDbvtAabbMm const &)*arg2);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btDbvtAabbMm_1Classify(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2, jfloat jarg3, jint jarg4) {
  jint jresult = 0 ;
  btDbvtAabbMm *arg1 = (btDbvtAabbMm *) 0 ;
  btVector3 *arg2 = 0 ;
  btScalar arg3 ;
  int arg4 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btDbvtAabbMm **)&jarg1; 
  btVector3 local_arg2;
  gdx_setbtVector3FromVector3(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitVector3 auto_commit_arg2(jenv, jarg2, &local_arg2);
  arg3 = (btScalar)jarg3; 
  arg4 = (int)jarg4; 
  result = (int)((btDbvtAabbMm const *)arg1)->Classify((btVector3 const &)*arg2,arg3,arg4);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btDbvtAabbMm_1ProjectMinimum(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2, jlong jarg3) {
  jfloat jresult = 0 ;
  btDbvtAabbMm *arg1 = (btDbvtAabbMm *) 0 ;
  btVector3 *arg2 = 0 ;
  unsigned int arg3 ;
  btScalar result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btDbvtAabbMm **)&jarg1; 
  btVector3 local_arg2;
  gdx_setbtVector3FromVector3(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitVector3 auto_commit_arg2(jenv, jarg2, &local_arg2);
  arg3 = (unsigned int)jarg3; 
  result = (btScalar)((btDbvtAabbMm const *)arg1)->ProjectMinimum((btVector3 const &)*arg2,arg3);
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_Intersect_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  jboolean jresult = 0 ;
  btDbvtAabbMm *arg1 = 0 ;
  btDbvtAabbMm *arg2 = 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btDbvtAabbMm **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btDbvtAabbMm const & reference is null");
    return 0;
  } 
  arg2 = *(btDbvtAabbMm **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btDbvtAabbMm const & reference is null");
    return 0;
  } 
  result = (bool)Intersect((btDbvtAabbMm const &)*arg1,(btDbvtAabbMm const &)*arg2);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_Intersect_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2) {
  jboolean jresult = 0 ;
  btDbvtAabbMm *arg1 = 0 ;
  btVector3 *arg2 = 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btDbvtAabbMm **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btDbvtAabbMm const & reference is null");
    return 0;
  } 
  btVector3 local_arg2;
  gdx_setbtVector3FromVector3(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitVector3 auto_commit_arg2(jenv, jarg2, &local_arg2);
  result = (bool)Intersect((btDbvtAabbMm const &)*arg1,(btVector3 const &)*arg2);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_Proximity(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  jfloat jresult = 0 ;
  btDbvtAabbMm *arg1 = 0 ;
  btDbvtAabbMm *arg2 = 0 ;
  btScalar result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btDbvtAabbMm **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btDbvtAabbMm const & reference is null");
    return 0;
  } 
  arg2 = *(btDbvtAabbMm **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btDbvtAabbMm const & reference is null");
    return 0;
  } 
  result = (btScalar)Proximity((btDbvtAabbMm const &)*arg1,(btDbvtAabbMm const &)*arg2);
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_Select(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlong jarg3, jobject jarg3_) {
  jint jresult = 0 ;
  btDbvtAabbMm *arg1 = 0 ;
  btDbvtAabbMm *arg2 = 0 ;
  btDbvtAabbMm *arg3 = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  (void)jarg3_;
  arg1 = *(btDbvtAabbMm **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btDbvtAabbMm const & reference is null");
    return 0;
  } 
  arg2 = *(btDbvtAabbMm **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btDbvtAabbMm const & reference is null");
    return 0;
  } 
  arg3 = *(btDbvtAabbMm **)&jarg3;
  if (!arg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btDbvtAabbMm const & reference is null");
    return 0;
  } 
  result = (int)Select((btDbvtAabbMm const &)*arg1,(btDbvtAabbMm const &)*arg2,(btDbvtAabbMm const &)*arg3);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_Merge(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlong jarg3, jobject jarg3_) {
  btDbvtAabbMm *arg1 = 0 ;
  btDbvtAabbMm *arg2 = 0 ;
  btDbvtAabbMm *arg3 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  (void)jarg3_;
  arg1 = *(btDbvtAabbMm **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btDbvtAabbMm const & reference is null");
    return ;
  } 
  arg2 = *(btDbvtAabbMm **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btDbvtAabbMm const & reference is null");
    return ;
  } 
  arg3 = *(btDbvtAabbMm **)&jarg3;
  if (!arg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btDbvtAabbMm & reference is null");
    return ;
  } 
  Merge((btDbvtAabbMm const &)*arg1,(btDbvtAabbMm const &)*arg2,*arg3);
}


SWIGEXPORT jboolean JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_NotEqual(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  jboolean jresult = 0 ;
  btDbvtAabbMm *arg1 = 0 ;
  btDbvtAabbMm *arg2 = 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btDbvtAabbMm **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btDbvtAabbMm const & reference is null");
    return 0;
  } 
  arg2 = *(btDbvtAabbMm **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btDbvtAabbMm const & reference is null");
    return 0;
  } 
  result = (bool)NotEqual((btDbvtAabbMm const &)*arg1,(btDbvtAabbMm const &)*arg2);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jobject JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btDbvtAabbMm_1tMins(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jobject jresult = 0 ;
  btDbvtAabbMm *arg1 = (btDbvtAabbMm *) 0 ;
  btVector3 *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btDbvtAabbMm **)&jarg1; 
  result = (btVector3 *) &(arg1)->tMins();
  jresult = gdx_getReturnVector3(jenv);
  gdx_setVector3FrombtVector3(jenv, jresult, result);
  return jresult;
}


SWIGEXPORT jobject JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btDbvtAabbMm_1tMaxs(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jobject jresult = 0 ;
  btDbvtAabbMm *arg1 = (btDbvtAabbMm *) 0 ;
  btVector3 *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btDbvtAabbMm **)&jarg1; 
  result = (btVector3 *) &(arg1)->tMaxs();
  jresult = gdx_getReturnVector3(jenv);
  gdx_setVector3FrombtVector3(jenv, jresult, result);
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_new_1btDbvtAabbMm(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  btDbvtAabbMm *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (btDbvtAabbMm *)new btDbvtAabbMm();
  *(btDbvtAabbMm **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_delete_1btDbvtAabbMm(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  btDbvtAabbMm *arg1 = (btDbvtAabbMm *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(btDbvtAabbMm **)&jarg1; 
  delete arg1;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btDbvtNode_1volume_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btDbvtNode *arg1 = (btDbvtNode *) 0 ;
  btDbvtVolume *arg2 = (btDbvtVolume *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btDbvtNode **)&jarg1; 
  arg2 = *(btDbvtVolume **)&jarg2; 
  if (arg1) (arg1)->volume = *arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btDbvtNode_1volume_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btDbvtNode *arg1 = (btDbvtNode *) 0 ;
  btDbvtVolume *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btDbvtNode **)&jarg1; 
  result = (btDbvtVolume *)& ((arg1)->volume);
  *(btDbvtVolume **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btDbvtNode_1parent_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btDbvtNode *arg1 = (btDbvtNode *) 0 ;
  btDbvtNode *arg2 = (btDbvtNode *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btDbvtNode **)&jarg1; 
  arg2 = *(btDbvtNode **)&jarg2; 
  if (arg1) (arg1)->parent = arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btDbvtNode_1parent_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btDbvtNode *arg1 = (btDbvtNode *) 0 ;
  btDbvtNode *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btDbvtNode **)&jarg1; 
  result = (btDbvtNode *) ((arg1)->parent);
  *(btDbvtNode **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btDbvtNode_1isleaf(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  btDbvtNode *arg1 = (btDbvtNode *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btDbvtNode **)&jarg1; 
  result = (bool)((btDbvtNode const *)arg1)->isleaf();
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btDbvtNode_1isinternal(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  btDbvtNode *arg1 = (btDbvtNode *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btDbvtNode **)&jarg1; 
  result = (bool)((btDbvtNode const *)arg1)->isinternal();
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btDbvtNode_1childs_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  btDbvtNode *arg1 = (btDbvtNode *) 0 ;
  btDbvtNode **arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btDbvtNode **)&jarg1; 
  arg2 = *(btDbvtNode ***)&jarg2; 
  {
    size_t ii;
    btDbvtNode * *b = (btDbvtNode * *) arg1->childs;
    for (ii = 0; ii < (size_t)2; ii++) b[ii] = *((btDbvtNode * *) arg2 + ii);
  }
  
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btDbvtNode_1childs_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btDbvtNode *arg1 = (btDbvtNode *) 0 ;
  btDbvtNode **result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btDbvtNode **)&jarg1; 
  result = (btDbvtNode **)(btDbvtNode **) ((arg1)->childs);
  *(btDbvtNode ***)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btDbvtNode_1data_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  btDbvtNode *arg1 = (btDbvtNode *) 0 ;
  void *arg2 = (void *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btDbvtNode **)&jarg1; 
  arg2 = (void *)jarg2; 
  if (arg1) (arg1)->data = arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btDbvtNode_1data_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btDbvtNode *arg1 = (btDbvtNode *) 0 ;
  void *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btDbvtNode **)&jarg1; 
  result = (void *) ((arg1)->data);
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btDbvtNode_1dataAsInt_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  btDbvtNode *arg1 = (btDbvtNode *) 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btDbvtNode **)&jarg1; 
  arg2 = (int)jarg2; 
  if (arg1) (arg1)->dataAsInt = arg2;
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btDbvtNode_1dataAsInt_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  btDbvtNode *arg1 = (btDbvtNode *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btDbvtNode **)&jarg1; 
  result = (int) ((arg1)->dataAsInt);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btDbvtNode_1getChild(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  jlong jresult = 0 ;
  btDbvtNode *arg1 = (btDbvtNode *) 0 ;
  int *arg2 = 0 ;
  int temp2 ;
  btDbvtNode *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btDbvtNode **)&jarg1; 
  temp2 = (int)jarg2; 
  arg2 = &temp2; 
  result = (btDbvtNode *)btDbvtNode_getChild(arg1,(int const &)*arg2);
  *(btDbvtNode **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btDbvtNode_1getChild0(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btDbvtNode *arg1 = (btDbvtNode *) 0 ;
  btDbvtNode *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btDbvtNode **)&jarg1; 
  result = (btDbvtNode *)btDbvtNode_getChild0(arg1);
  *(btDbvtNode **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btDbvtNode_1getChild1(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btDbvtNode *arg1 = (btDbvtNode *) 0 ;
  btDbvtNode *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btDbvtNode **)&jarg1; 
  result = (btDbvtNode *)btDbvtNode_getChild1(arg1);
  *(btDbvtNode **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btDbvtNode_1getDataAsProxy(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btDbvtNode *arg1 = (btDbvtNode *) 0 ;
  btBroadphaseProxy *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btDbvtNode **)&jarg1; 
  result = (btBroadphaseProxy *)btDbvtNode_getDataAsProxy(arg1);
  *(btBroadphaseProxy **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btDbvtNode_1getDataAsProxyClientObject(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btDbvtNode *arg1 = (btDbvtNode *) 0 ;
  btCollisionObject *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btDbvtNode **)&jarg1; 
  result = (btCollisionObject *)btDbvtNode_getDataAsProxyClientObject(arg1);
  *(btCollisionObject **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_new_1btDbvtNode(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  btDbvtNode *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (btDbvtNode *)new btDbvtNode();
  *(btDbvtNode **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_delete_1btDbvtNode(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  btDbvtNode *arg1 = (btDbvtNode *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(btDbvtNode **)&jarg1; 
  delete arg1;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btDbvt_1sStkNN_1a_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btDbvt::sStkNN *arg1 = (btDbvt::sStkNN *) 0 ;
  btDbvtNode *arg2 = (btDbvtNode *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btDbvt::sStkNN **)&jarg1; 
  arg2 = *(btDbvtNode **)&jarg2; 
  if (arg1) (arg1)->a = (btDbvtNode const *)arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btDbvt_1sStkNN_1a_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btDbvt::sStkNN *arg1 = (btDbvt::sStkNN *) 0 ;
  btDbvtNode *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btDbvt::sStkNN **)&jarg1; 
  result = (btDbvtNode *) ((arg1)->a);
  *(btDbvtNode **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btDbvt_1sStkNN_1b_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btDbvt::sStkNN *arg1 = (btDbvt::sStkNN *) 0 ;
  btDbvtNode *arg2 = (btDbvtNode *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btDbvt::sStkNN **)&jarg1; 
  arg2 = *(btDbvtNode **)&jarg2; 
  if (arg1) (arg1)->b = (btDbvtNode const *)arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btDbvt_1sStkNN_1b_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btDbvt::sStkNN *arg1 = (btDbvt::sStkNN *) 0 ;
  btDbvtNode *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btDbvt::sStkNN **)&jarg1; 
  result = (btDbvtNode *) ((arg1)->b);
  *(btDbvtNode **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_new_1btDbvt_1sStkNN_1_1SWIG_10(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  btDbvt::sStkNN *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (btDbvt::sStkNN *)new btDbvt::sStkNN();
  *(btDbvt::sStkNN **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_new_1btDbvt_1sStkNN_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  jlong jresult = 0 ;
  btDbvtNode *arg1 = (btDbvtNode *) 0 ;
  btDbvtNode *arg2 = (btDbvtNode *) 0 ;
  btDbvt::sStkNN *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btDbvtNode **)&jarg1; 
  arg2 = *(btDbvtNode **)&jarg2; 
  result = (btDbvt::sStkNN *)new btDbvt::sStkNN((btDbvtNode const *)arg1,(btDbvtNode const *)arg2);
  *(btDbvt::sStkNN **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_delete_1btDbvt_1sStkNN(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  btDbvt::sStkNN *arg1 = (btDbvt::sStkNN *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(btDbvt::sStkNN **)&jarg1; 
  delete arg1;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btDbvt_1sStkNP_1node_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btDbvt::sStkNP *arg1 = (btDbvt::sStkNP *) 0 ;
  btDbvtNode *arg2 = (btDbvtNode *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btDbvt::sStkNP **)&jarg1; 
  arg2 = *(btDbvtNode **)&jarg2; 
  if (arg1) (arg1)->node = (btDbvtNode const *)arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btDbvt_1sStkNP_1node_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btDbvt::sStkNP *arg1 = (btDbvt::sStkNP *) 0 ;
  btDbvtNode *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btDbvt::sStkNP **)&jarg1; 
  result = (btDbvtNode *) ((arg1)->node);
  *(btDbvtNode **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btDbvt_1sStkNP_1mask_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  btDbvt::sStkNP *arg1 = (btDbvt::sStkNP *) 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btDbvt::sStkNP **)&jarg1; 
  arg2 = (int)jarg2; 
  if (arg1) (arg1)->mask = arg2;
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btDbvt_1sStkNP_1mask_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  btDbvt::sStkNP *arg1 = (btDbvt::sStkNP *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btDbvt::sStkNP **)&jarg1; 
  result = (int) ((arg1)->mask);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_new_1btDbvt_1sStkNP(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  jlong jresult = 0 ;
  btDbvtNode *arg1 = (btDbvtNode *) 0 ;
  unsigned int arg2 ;
  btDbvt::sStkNP *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btDbvtNode **)&jarg1; 
  arg2 = (unsigned int)jarg2; 
  result = (btDbvt::sStkNP *)new btDbvt::sStkNP((btDbvtNode const *)arg1,arg2);
  *(btDbvt::sStkNP **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_delete_1btDbvt_1sStkNP(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  btDbvt::sStkNP *arg1 = (btDbvt::sStkNP *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(btDbvt::sStkNP **)&jarg1; 
  delete arg1;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btDbvt_1sStkNPS_1node_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btDbvt::sStkNPS *arg1 = (btDbvt::sStkNPS *) 0 ;
  btDbvtNode *arg2 = (btDbvtNode *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btDbvt::sStkNPS **)&jarg1; 
  arg2 = *(btDbvtNode **)&jarg2; 
  if (arg1) (arg1)->node = (btDbvtNode const *)arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btDbvt_1sStkNPS_1node_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btDbvt::sStkNPS *arg1 = (btDbvt::sStkNPS *) 0 ;
  btDbvtNode *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btDbvt::sStkNPS **)&jarg1; 
  result = (btDbvtNode *) ((arg1)->node);
  *(btDbvtNode **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btDbvt_1sStkNPS_1mask_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  btDbvt::sStkNPS *arg1 = (btDbvt::sStkNPS *) 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btDbvt::sStkNPS **)&jarg1; 
  arg2 = (int)jarg2; 
  if (arg1) (arg1)->mask = arg2;
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btDbvt_1sStkNPS_1mask_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  btDbvt::sStkNPS *arg1 = (btDbvt::sStkNPS *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btDbvt::sStkNPS **)&jarg1; 
  result = (int) ((arg1)->mask);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btDbvt_1sStkNPS_1value_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2) {
  btDbvt::sStkNPS *arg1 = (btDbvt::sStkNPS *) 0 ;
  btScalar arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btDbvt::sStkNPS **)&jarg1; 
  arg2 = (btScalar)jarg2; 
  if (arg1) (arg1)->value = arg2;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btDbvt_1sStkNPS_1value_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jfloat jresult = 0 ;
  btDbvt::sStkNPS *arg1 = (btDbvt::sStkNPS *) 0 ;
  btScalar result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btDbvt::sStkNPS **)&jarg1; 
  result = (btScalar) ((arg1)->value);
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_new_1btDbvt_1sStkNPS_1_1SWIG_10(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  btDbvt::sStkNPS *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (btDbvt::sStkNPS *)new btDbvt::sStkNPS();
  *(btDbvt::sStkNPS **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_new_1btDbvt_1sStkNPS_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jfloat jarg3) {
  jlong jresult = 0 ;
  btDbvtNode *arg1 = (btDbvtNode *) 0 ;
  unsigned int arg2 ;
  btScalar arg3 ;
  btDbvt::sStkNPS *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btDbvtNode **)&jarg1; 
  arg2 = (unsigned int)jarg2; 
  arg3 = (btScalar)jarg3; 
  result = (btDbvt::sStkNPS *)new btDbvt::sStkNPS((btDbvtNode const *)arg1,arg2,arg3);
  *(btDbvt::sStkNPS **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_delete_1btDbvt_1sStkNPS(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  btDbvt::sStkNPS *arg1 = (btDbvt::sStkNPS *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(btDbvt::sStkNPS **)&jarg1; 
  delete arg1;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btDbvt_1sStkCLN_1node_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btDbvt::sStkCLN *arg1 = (btDbvt::sStkCLN *) 0 ;
  btDbvtNode *arg2 = (btDbvtNode *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btDbvt::sStkCLN **)&jarg1; 
  arg2 = *(btDbvtNode **)&jarg2; 
  if (arg1) (arg1)->node = (btDbvtNode const *)arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btDbvt_1sStkCLN_1node_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btDbvt::sStkCLN *arg1 = (btDbvt::sStkCLN *) 0 ;
  btDbvtNode *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btDbvt::sStkCLN **)&jarg1; 
  result = (btDbvtNode *) ((arg1)->node);
  *(btDbvtNode **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btDbvt_1sStkCLN_1parent_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btDbvt::sStkCLN *arg1 = (btDbvt::sStkCLN *) 0 ;
  btDbvtNode *arg2 = (btDbvtNode *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btDbvt::sStkCLN **)&jarg1; 
  arg2 = *(btDbvtNode **)&jarg2; 
  if (arg1) (arg1)->parent = arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btDbvt_1sStkCLN_1parent_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btDbvt::sStkCLN *arg1 = (btDbvt::sStkCLN *) 0 ;
  btDbvtNode *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btDbvt::sStkCLN **)&jarg1; 
  result = (btDbvtNode *) ((arg1)->parent);
  *(btDbvtNode **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_new_1btDbvt_1sStkCLN(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  jlong jresult = 0 ;
  btDbvtNode *arg1 = (btDbvtNode *) 0 ;
  btDbvtNode *arg2 = (btDbvtNode *) 0 ;
  btDbvt::sStkCLN *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btDbvtNode **)&jarg1; 
  arg2 = *(btDbvtNode **)&jarg2; 
  result = (btDbvt::sStkCLN *)new btDbvt::sStkCLN((btDbvtNode const *)arg1,arg2);
  *(btDbvt::sStkCLN **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_delete_1btDbvt_1sStkCLN(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  btDbvt::sStkCLN *arg1 = (btDbvt::sStkCLN *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(btDbvt::sStkCLN **)&jarg1; 
  delete arg1;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_delete_1btDbvt_1IWriter(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  btDbvt::IWriter *arg1 = (btDbvt::IWriter *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(btDbvt::IWriter **)&jarg1; 
  delete arg1;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btDbvt_1IWriter_1Prepare(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jint jarg3) {
  btDbvt::IWriter *arg1 = (btDbvt::IWriter *) 0 ;
  btDbvtNode *arg2 = (btDbvtNode *) 0 ;
  int arg3 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btDbvt::IWriter **)&jarg1; 
  arg2 = *(btDbvtNode **)&jarg2; 
  arg3 = (int)jarg3; 
  (arg1)->Prepare((btDbvtNode const *)arg2,arg3);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btDbvt_1IWriter_1WriteNode(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jint jarg3, jint jarg4, jint jarg5, jint jarg6) {
  btDbvt::IWriter *arg1 = (btDbvt::IWriter *) 0 ;
  btDbvtNode *arg2 = (btDbvtNode *) 0 ;
  int arg3 ;
  int arg4 ;
  int arg5 ;
  int arg6 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btDbvt::IWriter **)&jarg1; 
  arg2 = *(btDbvtNode **)&jarg2; 
  arg3 = (int)jarg3; 
  arg4 = (int)jarg4; 
  arg5 = (int)jarg5; 
  arg6 = (int)jarg6; 
  (arg1)->WriteNode((btDbvtNode const *)arg2,arg3,arg4,arg5,arg6);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btDbvt_1IWriter_1WriteLeaf(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jint jarg3, jint jarg4) {
  btDbvt::IWriter *arg1 = (btDbvt::IWriter *) 0 ;
  btDbvtNode *arg2 = (btDbvtNode *) 0 ;
  int arg3 ;
  int arg4 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btDbvt::IWriter **)&jarg1; 
  arg2 = *(btDbvtNode **)&jarg2; 
  arg3 = (int)jarg3; 
  arg4 = (int)jarg4; 
  (arg1)->WriteLeaf((btDbvtNode const *)arg2,arg3,arg4);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_delete_1btDbvt_1IClone(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  btDbvt::IClone *arg1 = (btDbvt::IClone *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(btDbvt::IClone **)&jarg1; 
  delete arg1;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btDbvt_1IClone_1CloneLeaf(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btDbvt::IClone *arg1 = (btDbvt::IClone *) 0 ;
  btDbvtNode *arg2 = (btDbvtNode *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btDbvt::IClone **)&jarg1; 
  arg2 = *(btDbvtNode **)&jarg2; 
  (arg1)->CloneLeaf(arg2);
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_new_1btDbvt_1IClone(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  btDbvt::IClone *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (btDbvt::IClone *)new btDbvt::IClone();
  *(btDbvt::IClone **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btDbvt_1root_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btDbvt *arg1 = (btDbvt *) 0 ;
  btDbvtNode *arg2 = (btDbvtNode *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btDbvt **)&jarg1; 
  arg2 = *(btDbvtNode **)&jarg2; 
  if (arg1) (arg1)->m_root = arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btDbvt_1root_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btDbvt *arg1 = (btDbvt *) 0 ;
  btDbvtNode *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btDbvt **)&jarg1; 
  result = (btDbvtNode *) ((arg1)->m_root);
  *(btDbvtNode **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btDbvt_1free_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btDbvt *arg1 = (btDbvt *) 0 ;
  btDbvtNode *arg2 = (btDbvtNode *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btDbvt **)&jarg1; 
  arg2 = *(btDbvtNode **)&jarg2; 
  if (arg1) (arg1)->m_free = arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btDbvt_1free_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btDbvt *arg1 = (btDbvt *) 0 ;
  btDbvtNode *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btDbvt **)&jarg1; 
  result = (btDbvtNode *) ((arg1)->m_free);
  *(btDbvtNode **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btDbvt_1lkhd_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  btDbvt *arg1 = (btDbvt *) 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btDbvt **)&jarg1; 
  arg2 = (int)jarg2; 
  if (arg1) (arg1)->m_lkhd = arg2;
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btDbvt_1lkhd_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  btDbvt *arg1 = (btDbvt *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btDbvt **)&jarg1; 
  result = (int) ((arg1)->m_lkhd);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btDbvt_1leaves_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  btDbvt *arg1 = (btDbvt *) 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btDbvt **)&jarg1; 
  arg2 = (int)jarg2; 
  if (arg1) (arg1)->m_leaves = arg2;
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btDbvt_1leaves_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  btDbvt *arg1 = (btDbvt *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btDbvt **)&jarg1; 
  result = (int) ((arg1)->m_leaves);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btDbvt_1opath_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  btDbvt *arg1 = (btDbvt *) 0 ;
  unsigned int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btDbvt **)&jarg1; 
  arg2 = (unsigned int)jarg2; 
  if (arg1) (arg1)->m_opath = arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btDbvt_1opath_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btDbvt *arg1 = (btDbvt *) 0 ;
  unsigned int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btDbvt **)&jarg1; 
  result = (unsigned int) ((arg1)->m_opath);
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btDbvt_1stkStack_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  btDbvt *arg1 = (btDbvt *) 0 ;
  btAlignedObjectArray< btDbvt::sStkNN > *arg2 = (btAlignedObjectArray< btDbvt::sStkNN > *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btDbvt **)&jarg1; 
  arg2 = *(btAlignedObjectArray< btDbvt::sStkNN > **)&jarg2; 
  if (arg1) (arg1)->m_stkStack = *arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btDbvt_1stkStack_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btDbvt *arg1 = (btDbvt *) 0 ;
  btAlignedObjectArray< btDbvt::sStkNN > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btDbvt **)&jarg1; 
  result = (btAlignedObjectArray< btDbvt::sStkNN > *)& ((arg1)->m_stkStack);
  *(btAlignedObjectArray< btDbvt::sStkNN > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btDbvt_1rayTestStack_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  btDbvt *arg1 = (btDbvt *) 0 ;
  btAlignedObjectArray< btDbvtNode const * > *arg2 = (btAlignedObjectArray< btDbvtNode const * > *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btDbvt **)&jarg1; 
  arg2 = *(btAlignedObjectArray< btDbvtNode const * > **)&jarg2; 
  if (arg1) (arg1)->m_rayTestStack = *arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btDbvt_1rayTestStack_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btDbvt *arg1 = (btDbvt *) 0 ;
  btAlignedObjectArray< btDbvtNode const * > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btDbvt **)&jarg1; 
  result = (btAlignedObjectArray< btDbvtNode const * > *)& ((arg1)->m_rayTestStack);
  *(btAlignedObjectArray< btDbvtNode const * > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_new_1btDbvt(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  btDbvt *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (btDbvt *)new btDbvt();
  *(btDbvt **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_delete_1btDbvt(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  btDbvt *arg1 = (btDbvt *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(btDbvt **)&jarg1; 
  delete arg1;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btDbvt_1clear(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  btDbvt *arg1 = (btDbvt *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btDbvt **)&jarg1; 
  (arg1)->clear();
}


SWIGEXPORT jboolean JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btDbvt_1empty(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  btDbvt *arg1 = (btDbvt *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btDbvt **)&jarg1; 
  result = (bool)((btDbvt const *)arg1)->empty();
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btDbvt_1optimizeBottomUp(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  btDbvt *arg1 = (btDbvt *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btDbvt **)&jarg1; 
  (arg1)->optimizeBottomUp();
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_collision_CollisionJNI_btDbvt_1optimizeTopDown_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  btDbvt *arg1 = (btDbvt *) 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btDbvt **)&jarg1; 