/*
 * Decompiled with CFR 0.152.
 */
package org.moe.natj.objc;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.Callable;
import org.moe.natj.c.OpaquePtr;
import org.moe.natj.general.NatJ;
import org.moe.natj.general.NativeRuntime;
import org.moe.natj.general.Pointer;
import org.moe.natj.objc.Class;
import org.moe.natj.objc.IFrameworkInitializer;
import org.moe.natj.objc.ObjCObject;
import org.moe.natj.objc.WeakReference;
import org.moe.natj.objc.ann.ObjCBlock;
import org.moe.natj.objc.ann.ObjCCategory;
import org.moe.natj.objc.ann.ObjCProtocolName;
import org.moe.natj.objc.map.ObjCCallbackMapper;
import org.moe.natj.objc.map.ObjCObjectMapper;
import org.moe.natj.objc.map.ObjCStringMapper;

public class ObjCRuntime
extends NativeRuntime {
    private static Pointer.Releaser strongReleaser;
    private static java.lang.Class<? extends ObjCObject> rootType;
    private static String platformRoot;
    private HashMap<Long, java.lang.Class<?>> resolvedObjCClasses = new HashMap();
    private Set<String> sdkPackages = new HashSet<String>();
    private SortedMap<String, Set<String>> preferablePackagesForPrefixes = new TreeMap<String, Set<String>>();
    private Set<String> externalPackages = new HashSet<String>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doRegistration(java.lang.Class<?> type) {
        long objcClass = ObjCRuntime.registerClass(type);
        ObjCCategory ann = type.getAnnotation(ObjCCategory.class);
        if (ann != null) {
            type = ann.value();
        }
        HashMap<Long, java.lang.Class<?>> hashMap = this.resolvedObjCClasses;
        synchronized (hashMap) {
            this.resolvedObjCClasses.put(objcClass, type);
        }
    }

    private ObjCRuntime() {
        super(ObjCObjectMapper.class, ObjCStringMapper.class, ObjCCallbackMapper.class);
        String platform = NatJ.getPlatformName();
        if ("ios".equals(platform)) {
            String coreimage = "apple.coreimage";
            String foundation = "apple.foundation";
            String uikit = "apple.uikit";
            String mapkit = "apple.mapkit";
            String glkit = "apple.glkit";
            platformRoot = "apple";
            this.sdkPackages.add(coreimage);
            this.sdkPackages.add(foundation);
            this.sdkPackages.add(uikit);
            this.sdkPackages.add(mapkit);
            this.sdkPackages.add(glkit);
            this.sdkPackages.add(platformRoot);
            this.preferablePackagesForPrefixes.put("CI", new HashSet<String>(Arrays.asList(coreimage)));
            this.preferablePackagesForPrefixes.put("NS", new HashSet<String>(Arrays.asList(foundation, uikit, platformRoot)));
            this.preferablePackagesForPrefixes.put("UI", new HashSet<String>(Arrays.asList(uikit)));
            this.preferablePackagesForPrefixes.put("MK", new HashSet<String>(Arrays.asList(mapkit)));
            this.preferablePackagesForPrefixes.put("GLK", new HashSet<String>(Arrays.asList(glkit)));
        } else if ("mac".equals(platform)) {
            String foundation = "apple.foundation";
            platformRoot = "apple";
            this.sdkPackages.add(foundation);
            this.sdkPackages.add(platformRoot);
            this.preferablePackagesForPrefixes.put("NS", new HashSet<String>(Arrays.asList(foundation, platformRoot)));
        } else if ("tvos".equals(platform)) {
            String coreimage = "apple.coreimage";
            String foundation = "apple.foundation";
            String uikit = "apple.uikit";
            String glkit = "apple.glkit";
            platformRoot = "apple";
            this.sdkPackages.add(coreimage);
            this.sdkPackages.add(foundation);
            this.sdkPackages.add(uikit);
            this.sdkPackages.add(glkit);
            this.sdkPackages.add(platformRoot);
            this.preferablePackagesForPrefixes.put("CI", new HashSet<String>(Arrays.asList(coreimage)));
            this.preferablePackagesForPrefixes.put("NS", new HashSet<String>(Arrays.asList(foundation, uikit, platformRoot)));
            this.preferablePackagesForPrefixes.put("UI", new HashSet<String>(Arrays.asList(uikit)));
            this.preferablePackagesForPrefixes.put("GLK", new HashSet<String>(Arrays.asList(glkit)));
        } else {
            throw new RuntimeException("Unsupported platform!");
        }
        ObjCRuntime.initialize(this);
    }

    public static Pointer createStrongPointer(long peer, boolean owned) {
        if (!owned) {
            ObjCRuntime.retainObject(peer);
        }
        return new Pointer(peer, strongReleaser);
    }

    public static WeakReference createWeakReference(long peer) {
        return new WeakReference(peer);
    }

    @Override
    public void tryToDisposeCallback(Object callback) {
    }

    public static String getExceptionStacktrace(Throwable throwable) {
        StringWriter sw = new StringWriter();
        throwable.printStackTrace(new PrintWriter(sw));
        return sw.toString();
    }

    public static String getObjectClassName(Object instance) {
        Pointer peer;
        if (ObjCObject.class.isAssignableFrom(instance.getClass())) {
            peer = ((ObjCObject)instance).getPeer();
        } else {
            peer = ((ObjCObjectMapper)NatJ.getOrCreateInstanceOfRuntimeClass(ObjCRuntime.class).getObjectMapper()).getNativePeerOfProxyedObject(instance);
            if (peer == null) {
                throw new RuntimeException("No native object found for the Java instance!");
            }
        }
        if (ObjCRuntime.isObjectString(peer.getPeer())) {
            return "NSString";
        }
        return ObjCRuntime.getClassName(peer.getPeer());
    }

    public static <T extends ObjCObject> T cast(Object instance, java.lang.Class<T> cls) {
        return ObjCRuntime.cast(instance, cls, true);
    }

    public static <T extends ObjCObject> T cast(Object instance, java.lang.Class<T> cls, boolean transparent) {
        if (instance == null) {
            return null;
        }
        if (!ObjCObject.class.isAssignableFrom(instance.getClass())) {
            throw new UnsupportedOperationException("Only instances of ObjCObject are castable!");
        }
        long peer = ((ObjCObject)instance).getPeer().getPeer();
        long proxyPeer = ObjCRuntime.createObjCCastProxy(peer, Class.fromJavaClass(cls).getPeerPointer(), transparent);
        NatJ.JavaObjectConstructionInfo toObjCObjectInfo = NatJ.buildJavaObjectConstructionInfo(NatJ.getOrCreateInstanceOfRuntimeClass(ObjCRuntime.class), cls, null, null, null, true, false, false);
        return (T)((ObjCObject)NatJ.toJava(proxyPeer, toObjCObjectInfo));
    }

    public static <T> T castToProtocol(Object instance, java.lang.Class<T> cls) {
        return ObjCRuntime.castToProtocol(instance, cls, true);
    }

    public static <T> T castToProtocol(Object instance, java.lang.Class<T> cls, boolean transparent) {
        if (instance == null) {
            return null;
        }
        if (!ObjCObject.class.isAssignableFrom(instance.getClass())) {
            throw new UnsupportedOperationException("Only instances of ObjCObject are castable!");
        }
        if (!cls.isInterface() || !cls.isAnnotationPresent(ObjCProtocolName.class)) {
            throw new UnsupportedOperationException("Target type has to be an Objective-C protocol binding!");
        }
        long peer = ((ObjCObject)instance).getPeer().getPeer();
        long proxyPeer = ObjCRuntime.createObjCCastProxy(peer, 0L, transparent);
        NatJ.JavaObjectConstructionInfo toObjCObjectInfo = NatJ.buildJavaObjectConstructionInfo(NatJ.getOrCreateInstanceOfRuntimeClass(ObjCRuntime.class), cls, null, null, null, true, false, false);
        return (T)NatJ.toJava(proxyPeer, toObjCObjectInfo);
    }

    public static <T extends ObjCObject> T cast(OpaquePtr ptr, java.lang.Class<T> cls) {
        NatJ.JavaObjectConstructionInfo toObjCObjectInfo = NatJ.buildJavaObjectConstructionInfo(NatJ.getOrCreateInstanceOfRuntimeClass(ObjCRuntime.class), cls, null, null, null, false, false, false);
        return (T)((ObjCObject)NatJ.toJava(ptr.getPeer().getPeer(), toObjCObjectInfo));
    }

    public static <T extends OpaquePtr> T cast(ObjCObject obj, java.lang.Class<T> cls) {
        NatJ.JavaObjectConstructionInfo toOpqquePtrInfo = NatJ.buildJavaObjectConstructionInfo(null, cls, null, null, null, false, false, false);
        return (T)((OpaquePtr)NatJ.toJava(obj.getPeer().getPeer(), toOpqquePtrInfo));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static java.lang.Class<? extends ObjCObject> getHierarchyRootType() {
        if (rootType != null) return rootType;
        java.lang.Class<ObjCRuntime> clazz = ObjCRuntime.class;
        synchronized (ObjCRuntime.class) {
            if (rootType != null) return rootType;
            try {
                java.lang.Class<?> resolvedRootType = java.lang.Class.forName(platformRoot + ".NSObject");
                rootType = resolvedRootType;
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException("NSObject class can not be found!", e);
            }
            catch (ClassCastException e) {
                throw new RuntimeException("NSObject class has inconsistent type!", e);
            }
            return rootType;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleFrameworkInitializer(IFrameworkInitializer initializer) {
        Map<String, Set<String>> preferables;
        Set<String> externals = initializer.getExternalPackages();
        if (externals != null) {
            Set<String> set = this.externalPackages;
            synchronized (set) {
                this.externalPackages.addAll(externals);
            }
        }
        if ((preferables = initializer.getExternalPackagesAndPrefixes()) != null) {
            for (Map.Entry<String, Set<String>> entry : preferables.entrySet()) {
                this.addExternalPackagesForPrefix(entry.getKey(), entry.getValue());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addExternalPackage(String name) {
        Set<String> set = this.externalPackages;
        synchronized (set) {
            this.externalPackages.add(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addExternalPackagesForPrefix(String prefix, Set<String> packages) {
        SortedMap<String, Set<String>> sortedMap = this.preferablePackagesForPrefixes;
        synchronized (sortedMap) {
            Set oldPackages = (Set)this.preferablePackagesForPrefixes.get(prefix);
            HashSet<String> newPackages = new HashSet<String>();
            if (oldPackages != null) {
                newPackages.addAll(oldPackages);
            }
            newPackages.addAll(packages);
            this.preferablePackagesForPrefixes.put(prefix, newPackages);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public java.lang.Class<?> resolveObjCClass(long cls) {
        HashMap<Long, java.lang.Class<?>> hashMap = this.resolvedObjCClasses;
        synchronized (hashMap) {
            java.lang.Class<?> javaClass = this.resolvedObjCClasses.get(cls);
            if (javaClass == null) {
                SortedMap<String, Set<String>> sortedMap = this.preferablePackagesForPrefixes;
                synchronized (sortedMap) {
                    Set<String> set = this.sdkPackages;
                    synchronized (set) {
                        Set<String> set2 = this.externalPackages;
                        synchronized (set2) {
                            LinkedList<Long> resolvables = new LinkedList<Long>();
                            String name = ObjCRuntime.getObjectDescription(cls);
                            resolvables.add(cls);
                            while (name.startsWith("_") && (javaClass = this.resolvedObjCClasses.get(cls = ObjCRuntime.getClassParent(cls))) == null) {
                                resolvables.add(cls);
                                name = ObjCRuntime.getObjectDescription(cls);
                            }
                            if (javaClass == null) {
                                HashSet packagesList = new HashSet();
                                SortedMap<String, Set<String>> subMap = this.preferablePackagesForPrefixes;
                                for (int i = 0; i < name.length() && subMap.size() > 0; ++i) {
                                    String subfix = name.substring(0, i + 1);
                                    String end = name.substring(0, i) + (char)(name.charAt(i) + '\u0001');
                                    subMap = subMap.subMap(subfix, end);
                                    for (Map.Entry<String, Set<String>> entry : subMap.entrySet()) {
                                        if (entry.getKey().length() != i + 1) continue;
                                        packagesList.addAll(entry.getValue());
                                    }
                                }
                                for (String pack : packagesList) {
                                    try {
                                        javaClass = java.lang.Class.forName(pack + "." + name);
                                        break;
                                    }
                                    catch (Exception exception2) {
                                    }
                                }
                                if (javaClass == null) {
                                    for (String pack : this.sdkPackages) {
                                        if (packagesList.contains(pack)) continue;
                                        try {
                                            javaClass = java.lang.Class.forName(pack + "." + name);
                                            break;
                                        }
                                        catch (Exception exception3) {
                                        }
                                    }
                                }
                                if (javaClass == null) {
                                    for (String pack : this.externalPackages) {
                                        if (packagesList.contains(pack) || this.sdkPackages.contains(pack)) continue;
                                        try {
                                            javaClass = java.lang.Class.forName(pack + "." + name);
                                            break;
                                        }
                                        catch (Exception exception4) {
                                        }
                                    }
                                }
                                if (javaClass == null) {
                                    javaClass = this.resolveObjCClass(ObjCRuntime.getClassParent(cls));
                                }
                            }
                            for (Long resolvable : resolvables) {
                                this.resolvedObjCClasses.put(resolvable, javaClass == null ? ObjCRuntime.getHierarchyRootType() : javaClass);
                            }
                        }
                    }
                }
            }
            return javaClass == null ? ObjCRuntime.getHierarchyRootType() : javaClass;
        }
    }

    private void cleanupObjCProxy(Object peer) {
        ((ObjCObjectMapper)this.getObjectMapper()).cleanupObjCProxy(peer);
    }

    private void cleanupObjCBlock(Object peer, Method method) {
        ((ObjCCallbackMapper)this.getCallbackMapper()).cleanupObjCBlock(peer, method);
    }

    public static void associateObjCObject(long owner, Object instance) {
        long pool = ObjCRuntime.createAutoreleasePool();
        long peer = NatJ.toNative(instance, ObjCAssociation.associationInfo);
        ObjCRuntime.associateObjCObject(owner, peer);
        ObjCRuntime.releaseAutoreleasePool(pool);
    }

    public static void associateObjCObject(ObjCObject owner, Object instance) {
        ObjCRuntime.associateObjCObject(owner.getPeer().getPeer(), instance);
    }

    public static void associateObjCObject(long owner, Object instance, String name, java.lang.Class<?>[] argTypes) {
        long pool = ObjCRuntime.createAutoreleasePool();
        long peer = NatJ.toNative(instance, ObjCAssociation.createBuildInfoForBlockAssociation(name, argTypes));
        ObjCRuntime.associateObjCObject(owner, peer);
        ObjCRuntime.releaseAutoreleasePool(pool);
    }

    public static void associateObjCObject(ObjCObject owner, Object instance, String name, java.lang.Class<?>[] argTypes) {
        ObjCRuntime.associateObjCObject(owner.getPeer().getPeer(), instance, name, argTypes);
    }

    public static void dissociateObjCObject(long owner, Object instance) {
        long pool = ObjCRuntime.createAutoreleasePool();
        long peer = NatJ.toNative(instance, ObjCAssociation.associationInfo);
        ObjCRuntime.dissociateObjCObject(owner, peer);
        ObjCRuntime.releaseAutoreleasePool(pool);
    }

    public static void dissociateObjCObject(ObjCObject owner, Object instance) {
        ObjCRuntime.dissociateObjCObject(owner.getPeer().getPeer(), instance);
    }

    public static void dissociateObjCObject(long owner, Object instance, String name, java.lang.Class<?>[] argTypes) {
        long pool = ObjCRuntime.createAutoreleasePool();
        long peer = NatJ.toNative(instance, ObjCAssociation.createBuildInfoForBlockAssociation(name, argTypes));
        ObjCRuntime.dissociateObjCObject(owner, peer);
        ObjCRuntime.releaseAutoreleasePool(pool);
    }

    public static void dissociateObjCObject(ObjCObject owner, Object instance, String name, java.lang.Class<?>[] argTypes) {
        ObjCRuntime.dissociateObjCObject(owner.getPeer().getPeer(), instance, name, argTypes);
    }

    @Override
    public byte getDefaultUnboxPolicy() {
        return 2;
    }

    private static native void initialize(ObjCRuntime var0);

    private static native long registerClass(java.lang.Class<?> var0);

    public static native void retainObject(long var0);

    public static native void releaseObject(long var0);

    public static native void autoreleaseObject(long var0);

    public static void disposeObject(Object object) {
        if (((ObjCCallbackMapper)NatJ.getOrCreateInstanceOfRuntimeClass(ObjCRuntime.class).getCallbackMapper()).dispose(object)) {
            return;
        }
        if (((ObjCObjectMapper)NatJ.getOrCreateInstanceOfRuntimeClass(ObjCRuntime.class).getObjectMapper()).dispose(object)) {
            return;
        }
    }

    public static native String createJavaString(long var0);

    public static native long createNativeString(String var0);

    public static native long createProxyClass(java.lang.Class<?> var0);

    public static native long createProxyClassWithExtension(java.lang.Class<?> var0, String var1, java.lang.Class<? extends ProxyExtensionBase> var2);

    public static native long createProxyInstance(long var0, Object var2);

    public static native long createDataForNativeBlock(Object var0);

    public static native Object[] createDataForNativeProtocolProxy(java.lang.Class<?> var0);

    public static native long createDataForJavaBlock(Object var0);

    public static native long createNativeCallbackFromJavaInstance(Object var0, long var1);

    public static native Object getInstanceForJavaBlock(long var0);

    public static native Object getJavaReferenceOfBindingObject(long var0);

    public static native void setJavaReferenceOfBindingObject(long var0, Object var2);

    public static native Object getJavaReferenceOfCustomObject(long var0);

    public static native void setJavaReferenceOfCustomObject(long var0, Object var2);

    public static native boolean isKindOfInheritedClass(long var0);

    public static native boolean isKindOfProxyClass(long var0);

    public static native boolean isKindOfHybridClass(long var0);

    public static native String getObjectDescription(long var0);

    public static native long getObjectClass(long var0);

    public static native long getClassParent(long var0);

    public static native long getClassByName(String var0);

    public static native boolean isObjectString(long var0);

    public static native boolean isObjectBlock(long var0);

    public static native boolean isStackBlock(long var0);

    public static native long copyBlock(long var0);

    public static native String getClassName(long var0);

    public static native Object getInitTargetOnCurrentThread();

    public static native long registerSelector(String var0);

    public static native void lockObject(long var0);

    public static native void unlockObject(long var0);

    public static native java.lang.Class<?> getJavaTypeForHybridClass(long var0);

    public static native void storeWeak(long var0, long var2);

    public static native long loadWeak(long var0);

    public static native void destroyWeak(long var0);

    public static native void associateObjCObject(long var0, long var2);

    public static native void dissociateObjCObject(long var0, long var2);

    public static native long createAutoreleasePool();

    public static native void releaseAutoreleasePool(long var0);

    public static void autoreleasepool(Runnable runnable) {
        if (runnable == null) {
            throw new NullPointerException();
        }
        long pool = ObjCRuntime.createAutoreleasePool();
        try {
            runnable.run();
        }
        finally {
            ObjCRuntime.releaseAutoreleasePool(pool);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T autoreleasepool(Callable<T> callable) throws Exception {
        if (callable == null) {
            throw new NullPointerException();
        }
        long pool = ObjCRuntime.createAutoreleasePool();
        try {
            T t = callable.call();
            return t;
        }
        finally {
            ObjCRuntime.releaseAutoreleasePool(pool);
        }
    }

    public static native boolean forwardBooleanBlockCall(long var0, long var2, Object[] var4);

    public static native byte forwardByteBlockCall(long var0, long var2, Object[] var4);

    public static native char forwardCharBlockCall(long var0, long var2, Object[] var4);

    public static native short forwardShortBlockCall(long var0, long var2, Object[] var4);

    public static native int forwardIntBlockCall(long var0, long var2, Object[] var4);

    public static native long forwardLongBlockCall(long var0, long var2, Object[] var4);

    public static native float forwardFloatBlockCall(long var0, long var2, Object[] var4);

    public static native double forwardDoubleBlockCall(long var0, long var2, Object[] var4);

    public static native void forwardVoidBlockCall(long var0, long var2, Object[] var4);

    public static native Object forwardObjectBlockCall(long var0, long var2, Object[] var4);

    public static native boolean forwardBooleanProtocolCall(long var0, long var2, Object[] var4);

    public static native byte forwardByteProtocolCall(long var0, long var2, Object[] var4);

    public static native char forwardCharProtocolCall(long var0, long var2, Object[] var4);

    public static native short forwardShortProtocolCall(long var0, long var2, Object[] var4);

    public static native int forwardIntProtocolCall(long var0, long var2, Object[] var4);

    public static native long forwardLongProtocolCall(long var0, long var2, Object[] var4);

    public static native float forwardFloatProtocolCall(long var0, long var2, Object[] var4);

    public static native double forwardDoubleProtocolCall(long var0, long var2, Object[] var4);

    public static native void forwardVoidProtocolCall(long var0, long var2, Object[] var4);

    public static native Object forwardObjectProtocolCall(long var0, long var2, Object[] var4);

    private static native long createObjCCastProxy(long var0, long var2, boolean var4);

    public static native long getObjCCastProxyPeer(long var0);

    static {
        NatJ.registerRuntime(ObjCRuntime.class);
        strongReleaser = new Pointer.Releaser(){

            @Override
            public void release(long peer) {
                ObjCRuntime.releaseObject(peer);
            }

            @Override
            public boolean ifFinalizedExternally() {
                return true;
            }
        };
        rootType = null;
        platformRoot = null;
    }

    public static class ProxyExtensionBase<T> {
        protected T target;

        public ProxyExtensionBase(Object target) {
            this.target = target;
        }
    }

    private static class ObjCAssociation {
        public static NatJ.NativeObjectConstructionInfo associationInfo = ObjCAssociation.createBuildInfoForAssociation();

        private ObjCAssociation() {
        }

        private static NatJ.NativeObjectConstructionInfo createBuildInfoForAssociation() {
            try {
                return NatJ.buildNativeObjectConstructionInfo(NatJ.getOrCreateInstanceOfRuntimeClass(ObjCRuntime.class), Object.class, ObjCObjectMapper.class, null, false, false, true);
            }
            catch (Exception e) {
                return null;
            }
        }

        public static NatJ.NativeObjectConstructionInfo createBuildInfoForBlockAssociation(String name, java.lang.Class<?>[] argTypes) {
            try {
                return NatJ.buildNativeObjectConstructionInfo(NatJ.getOrCreateInstanceOfRuntimeClass(ObjCRuntime.class), Object.class, ObjCObjectMapper.class, new ObjCBlockInfo(name, argTypes), false, false, true);
            }
            catch (Exception e) {
                return null;
            }
        }

        private static class ObjCBlockInfo
        implements ObjCBlock {
            private String name;
            private java.lang.Class<?>[] argTypes;

            public ObjCBlockInfo(String name, java.lang.Class<?>[] argTypes) {
            }

            @Override
            public java.lang.Class<? extends Annotation> annotationType() {
                return ObjCBlock.class;
            }

            @Override
            public String name() {
                return this.name;
            }

            @Override
            public java.lang.Class<?>[] argTypes() {
                return this.argTypes;
            }
        }
    }
}

