/*
 * Decompiled with CFR 0.152.
 */
package org.moe.natj.general.ptr.impl;

import org.moe.natj.c.CRuntime;
import org.moe.natj.general.Pointer;
import org.moe.natj.general.ptr.IGuardedPtr;
import org.moe.natj.general.ptr.WCharTPtr;
import org.moe.natj.general.ptr.impl.VoidPtrImpl;

class WCharTPtrImpl
extends VoidPtrImpl
implements WCharTPtr {
    protected static final int ELEM_SIZE = CRuntime.NATIVE_WCHART_SIZE;

    protected WCharTPtrImpl(Pointer peer) {
        super(peer);
    }

    protected WCharTPtrImpl(long peer, Object bufferOwner) {
        super(peer, false, bufferOwner);
    }

    WCharTPtrImpl(int capacity, boolean owned) {
        super(ELEM_SIZE == 4 ? CRuntime.allocInt(capacity) : CRuntime.allocChar(capacity), owned, null);
    }

    @Override
    public boolean isConstPtr() {
        return false;
    }

    @Override
    public final Integer get() {
        return this.getValue(0);
    }

    @Override
    public final Integer get(int idx) {
        return this.getValue(idx);
    }

    @Override
    public final int getValue() {
        return this.getValue(0);
    }

    @Override
    public int getValue(int idx) {
        if (ELEM_SIZE == 4) {
            return CRuntime.loadInt(this.getRoot(), idx);
        }
        return CRuntime.loadChar(this.getRoot(), idx);
    }

    public final Integer[] toArray(int length) {
        return this.toArray(0, length);
    }

    public Integer[] toArray(int fromIndex, int toIndex) {
        if (toIndex < fromIndex) {
            throw new IllegalArgumentException();
        }
        int length = toIndex - fromIndex;
        Integer[] array = new Integer[length];
        this.copyTo(fromIndex, array, 0, length);
        return array;
    }

    @Override
    public final int[] toIntArray(int length) {
        return this.toIntArray(0, length);
    }

    @Override
    public int[] toIntArray(int fromIndex, int toIndex) {
        if (toIndex < fromIndex) {
            throw new IllegalArgumentException();
        }
        if (ELEM_SIZE == 4) {
            return CRuntime.createIntArray(this.getRoot() + (long)(fromIndex * ELEM_SIZE), toIndex - fromIndex);
        }
        char[] charArray = CRuntime.createCharArray(this.getRoot() + (long)(fromIndex * ELEM_SIZE), toIndex - fromIndex);
        int[] intArray = new int[charArray.length];
        for (int i = 0; i < charArray.length; ++i) {
            intArray[i] = charArray[i];
        }
        return intArray;
    }

    public final void copyTo(Integer[] dest) {
        if (dest == null) {
            throw new IllegalArgumentException();
        }
        this.copyTo(0, dest, 0, dest.length);
    }

    public final void copyTo(Integer[] dest, int length) {
        if (dest == null) {
            throw new IllegalArgumentException();
        }
        this.copyTo(0, dest, 0, length);
    }

    public void copyTo(int srcOffset, Integer[] dest, int destOffset, int length) {
        if (dest == null || destOffset < 0 || length < 0 || destOffset + length > dest.length) {
            throw new IllegalArgumentException();
        }
        long root = this.getRoot();
        if (ELEM_SIZE == 4) {
            int idx = 0;
            while (idx < length) {
                dest[destOffset] = CRuntime.loadInt(root, srcOffset);
                ++idx;
                ++srcOffset;
                ++destOffset;
            }
        } else {
            int idx = 0;
            while (idx < length) {
                dest[destOffset] = CRuntime.loadChar(root, srcOffset);
                ++idx;
                ++srcOffset;
                ++destOffset;
            }
        }
    }

    @Override
    public final void copyTo(int[] dest) {
        if (dest == null) {
            throw new IllegalArgumentException();
        }
        this.copyTo(0, dest, 0, dest.length);
    }

    @Override
    public final void copyTo(int[] dest, int length) {
        if (dest == null) {
            throw new IllegalArgumentException();
        }
        this.copyTo(0, dest, 0, length);
    }

    @Override
    public void copyTo(int srcOffset, int[] dest, int destOffset, int length) {
        if (dest == null || destOffset < 0 || length < 0 || destOffset + length > dest.length) {
            throw new IllegalArgumentException();
        }
        if (ELEM_SIZE == 4) {
            CRuntime.copyFromNativeIntArray(dest, destOffset, this.getRoot(), srcOffset, length);
        } else {
            long root = this.getRoot();
            int idx = 0;
            while (idx < length) {
                dest[destOffset] = CRuntime.loadChar(root, srcOffset);
                ++idx;
                ++srcOffset;
                ++destOffset;
            }
        }
    }

    @Override
    public void set(Integer obj) {
        this.setValue(obj);
    }

    @Override
    public void set(int idx, Integer obj) {
        this.setValue(idx, obj);
    }

    @Override
    public void setValue(int value) {
        this.setValue(0, value);
    }

    @Override
    public void setValue(int idx, int value) {
        if (ELEM_SIZE == 4) {
            CRuntime.storeInt(this.getRoot(), idx, value);
        } else {
            CRuntime.storeChar(this.getRoot(), idx, (char)value);
        }
    }

    public void copyFrom(Integer[] src) {
        if (src == null) {
            throw new IllegalArgumentException();
        }
        this.copyFrom(src, 0, 0, src.length);
    }

    public void copyFrom(Integer[] src, int destOffset) {
        if (src == null) {
            throw new IllegalArgumentException();
        }
        this.copyFrom(src, 0, destOffset, src.length);
    }

    public void copyFrom(Integer[] src, int destOffset, int length) {
        if (src == null) {
            throw new IllegalArgumentException();
        }
        this.copyFrom(src, 0, destOffset, length);
    }

    public void copyFrom(Integer[] src, int srcOffset, int destOffset, int length) {
        if (src == null || srcOffset < 0 || length < 0 || srcOffset + length > src.length) {
            throw new IllegalArgumentException();
        }
        long root = this.getRoot();
        if (ELEM_SIZE == 4) {
            int i = 0;
            while (i < length) {
                CRuntime.storeInt(root, destOffset, src[srcOffset]);
                ++i;
                ++srcOffset;
                ++destOffset;
            }
        } else {
            int i = 0;
            while (i < length) {
                CRuntime.storeChar(root, destOffset, (char)src[srcOffset].intValue());
                ++i;
                ++srcOffset;
                ++destOffset;
            }
        }
    }

    @Override
    public void copyFrom(int[] src) {
        if (src == null) {
            throw new IllegalArgumentException();
        }
        this.copyFrom(src, 0, 0, src.length);
    }

    @Override
    public void copyFrom(int[] src, int destOffset) {
        if (src == null) {
            throw new IllegalArgumentException();
        }
        this.copyFrom(src, 0, destOffset, src.length);
    }

    @Override
    public void copyFrom(int[] src, int destOffset, int length) {
        if (src == null) {
            throw new IllegalArgumentException();
        }
        this.copyFrom(src, 0, destOffset, length);
    }

    @Override
    public void copyFrom(int[] src, int srcOffset, int destOffset, int length) {
        if (src == null || srcOffset < 0 || length < 0 || srcOffset + length > src.length) {
            throw new IllegalArgumentException();
        }
        if (ELEM_SIZE == 4) {
            CRuntime.copyIntArray(this.getRoot(), destOffset, src, srcOffset, length);
        } else {
            char[] charArray = new char[length];
            for (int i = 0; i < length; ++i) {
                charArray[i] = (char)src[i + srcOffset];
            }
            CRuntime.copyCharArray(this.getRoot(), destOffset, charArray, 0, length);
        }
    }

    @Override
    public WCharTPtr ofs(int elemOffset) {
        return new WCharTPtrImpl(this.getRoot() + (long)(elemOffset * ELEM_SIZE), this);
    }

    @Override
    public boolean isGuarded() {
        return false;
    }

    @Override
    public final WCharTPtr getGuarded(int length) {
        return this.getGuarded(0, length);
    }

    @Override
    public WCharTPtr getGuarded(int fromIndex, int toIndex) {
        if (toIndex < fromIndex) {
            throw new IllegalArgumentException();
        }
        return new GuardedWCharTPtrImpl(this.getRoot(), this, fromIndex, toIndex);
    }

    @Override
    public int getGuardLow() {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getGuardHigh() {
        throw new UnsupportedOperationException();
    }

    static {
        if (ELEM_SIZE != 4 && ELEM_SIZE != 2) {
            throw new RuntimeException("Unexpected wchar_t size");
        }
    }

    private static class GuardedConstWCharTPtrImpl
    extends GuardedWCharTPtrImpl {
        public GuardedConstWCharTPtrImpl(long peer, Object bufferOwner, int low, int hi) {
            super(peer, bufferOwner, low, hi);
        }

        @Override
        public boolean isConstPtr() {
            return true;
        }

        @Override
        public void set(Integer obj) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void set(int idx, Integer obj) {
            throw new UnsupportedOperationException();
        }

        @Override
        public final void setValue(int value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public final void setValue(int idx, int value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public final void copyFrom(Integer[] src) {
            throw new UnsupportedOperationException();
        }

        @Override
        public final void copyFrom(Integer[] src, int destOffset) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void copyFrom(Integer[] src, int destOffset, int length) {
            throw new UnsupportedOperationException();
        }

        @Override
        public final void copyFrom(Integer[] src, int srcOffset, int destOffset, int length) {
            throw new UnsupportedOperationException();
        }

        @Override
        public final void copyFrom(int[] src) {
            throw new UnsupportedOperationException();
        }

        @Override
        public final void copyFrom(int[] src, int destOffset) {
            throw new UnsupportedOperationException();
        }

        @Override
        public final void copyFrom(int[] src, int srcOffset, int destOffset) {
            throw new UnsupportedOperationException();
        }

        @Override
        public final void copyFrom(int[] src, int srcOffset, int destOffset, int length) {
            throw new UnsupportedOperationException();
        }

        @Override
        public final WCharTPtr ofs(int elemOffset) {
            return new GuardedConstWCharTPtrImpl(this.getRoot() + (long)(elemOffset * ELEM_SIZE), this, this.low + elemOffset, this.hi + elemOffset);
        }

        @Override
        public WCharTPtr getGuarded(int fromIndex, int toIndex) {
            if (toIndex < fromIndex) {
                throw new IllegalArgumentException();
            }
            return new GuardedConstWCharTPtrImpl(this.getRoot(), this, fromIndex, toIndex);
        }
    }

    private static class GuardedWCharTPtrImpl
    extends WCharTPtrImpl
    implements IGuardedPtr {
        protected final int low;
        protected final int hi;

        public GuardedWCharTPtrImpl(long peer, Object bufferOwner, int low, int hi) {
            super(peer, bufferOwner);
            if (low > hi) {
                throw new IllegalArgumentException();
            }
            this.low = low;
            this.hi = hi;
        }

        @Override
        public boolean checkIndex(int index) {
            return index >= this.low && index < this.hi;
        }

        @Override
        public boolean isGuarded() {
            return true;
        }

        @Override
        public int getValue(int idx) {
            if (!this.checkIndex(idx)) {
                throw new IndexOutOfBoundsException();
            }
            return super.get(idx);
        }

        @Override
        public Integer[] toArray(int fromIndex, int toIndex) {
            if (!this.checkIndex(fromIndex) || !this.checkIndex(toIndex)) {
                throw new IndexOutOfBoundsException();
            }
            return super.toArray(fromIndex, toIndex);
        }

        @Override
        public int[] toIntArray(int fromIndex, int toIndex) {
            if (!this.checkIndex(fromIndex) || !this.checkIndex(toIndex)) {
                throw new IndexOutOfBoundsException();
            }
            return super.toIntArray(fromIndex, toIndex);
        }

        @Override
        public void copyTo(int srcOffset, Integer[] dest, int destOffset, int length) {
            if (!this.checkIndex(srcOffset) || !this.checkIndex(srcOffset + length)) {
                throw new IndexOutOfBoundsException();
            }
            super.copyTo(srcOffset, dest, destOffset, length);
        }

        @Override
        public void copyTo(int srcOffset, int[] dest, int destOffset, int length) {
            if (!this.checkIndex(srcOffset) || !this.checkIndex(srcOffset + length)) {
                throw new IndexOutOfBoundsException();
            }
            super.copyTo(srcOffset, dest, destOffset, length);
        }

        @Override
        public void setValue(int idx, int value) {
            if (!this.checkIndex(idx)) {
                throw new IndexOutOfBoundsException();
            }
            super.set(idx, value);
        }

        @Override
        public void copyFrom(Integer[] src, int srcOffset, int destOffset, int length) {
            if (!this.checkIndex(destOffset) || !this.checkIndex(destOffset + length)) {
                throw new IndexOutOfBoundsException();
            }
            super.copyFrom(src, srcOffset, destOffset, length);
        }

        @Override
        public void copyFrom(int[] src, int srcOffset, int destOffset, int length) {
            if (!this.checkIndex(destOffset) || !this.checkIndex(destOffset + length)) {
                throw new IndexOutOfBoundsException();
            }
            super.copyFrom(src, srcOffset, destOffset, length);
        }

        @Override
        public WCharTPtr ofs(int elemOffset) {
            return new GuardedWCharTPtrImpl(this.getRoot() + (long)(elemOffset * ELEM_SIZE), this, this.low + elemOffset, this.hi + elemOffset);
        }

        @Override
        public WCharTPtr getGuarded(int fromIndex, int toIndex) {
            if (toIndex < fromIndex) {
                throw new IllegalArgumentException();
            }
            return new GuardedWCharTPtrImpl(this.getRoot(), this, fromIndex, toIndex);
        }

        @Override
        public int getGuardLow() {
            return this.low;
        }

        @Override
        public int getGuardHigh() {
            return this.hi;
        }
    }

    static class ConstWCharTPtrImpl
    extends WCharTPtrImpl {
        protected ConstWCharTPtrImpl(Pointer peer) {
            super(peer);
        }

        protected ConstWCharTPtrImpl(long peer, Object bufferOwner) {
            super(peer, bufferOwner);
        }

        ConstWCharTPtrImpl(int capacity, boolean owned) {
            super(capacity, owned);
        }

        @Override
        public boolean isConstPtr() {
            return true;
        }

        @Override
        public void set(Integer obj) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void set(int idx, Integer obj) {
            throw new UnsupportedOperationException();
        }

        @Override
        public final void setValue(int value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public final void setValue(int idx, int value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public final void copyFrom(Integer[] src) {
            throw new UnsupportedOperationException();
        }

        @Override
        public final void copyFrom(Integer[] src, int destOffset) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void copyFrom(Integer[] src, int destOffset, int length) {
            throw new UnsupportedOperationException();
        }

        @Override
        public final void copyFrom(Integer[] src, int srcOffset, int destOffset, int length) {
            throw new UnsupportedOperationException();
        }

        @Override
        public final void copyFrom(int[] src) {
            throw new UnsupportedOperationException();
        }

        @Override
        public final void copyFrom(int[] src, int destOffset) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void copyFrom(int[] src, int destOffset, int length) {
            throw new UnsupportedOperationException();
        }

        @Override
        public final void copyFrom(int[] src, int srcOffset, int destOffset, int length) {
            throw new UnsupportedOperationException();
        }

        @Override
        public final WCharTPtr ofs(int elemOffset) {
            return new ConstWCharTPtrImpl(this.getRoot() + (long)(elemOffset * ELEM_SIZE), this);
        }

        @Override
        public WCharTPtr getGuarded(int fromIndex, int toIndex) {
            if (toIndex < fromIndex) {
                throw new IllegalArgumentException();
            }
            return new GuardedConstWCharTPtrImpl(this.getRoot(), this, fromIndex, toIndex);
        }
    }
}

