/*
 * Decompiled with CFR 0.152.
 */
package org.moe.natj.general.ptr.impl;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import java.nio.ShortBuffer;
import org.moe.natj.c.CRuntime;
import org.moe.natj.c.OpaquePtr;
import org.moe.natj.c.StructObject;
import org.moe.natj.cxx.CxxObject;
import org.moe.natj.general.ptr.BoolPtr;
import org.moe.natj.general.ptr.BytePtr;
import org.moe.natj.general.ptr.CharPtr;
import org.moe.natj.general.ptr.DoublePtr;
import org.moe.natj.general.ptr.FloatPtr;
import org.moe.natj.general.ptr.IntPtr;
import org.moe.natj.general.ptr.LongPtr;
import org.moe.natj.general.ptr.NFloatPtr;
import org.moe.natj.general.ptr.NIntPtr;
import org.moe.natj.general.ptr.NLongPtr;
import org.moe.natj.general.ptr.NUIntPtr;
import org.moe.natj.general.ptr.NULongPtr;
import org.moe.natj.general.ptr.Ptr;
import org.moe.natj.general.ptr.ShortPtr;
import org.moe.natj.general.ptr.VoidPtr;
import org.moe.natj.general.ptr.WCharTPtr;
import org.moe.natj.general.ptr.impl.BoolPtrImpl;
import org.moe.natj.general.ptr.impl.BytePtrImpl;
import org.moe.natj.general.ptr.impl.CharPtrImpl;
import org.moe.natj.general.ptr.impl.CxxObjectPtrImpl;
import org.moe.natj.general.ptr.impl.DoublePtrImpl;
import org.moe.natj.general.ptr.impl.FloatPtrImpl;
import org.moe.natj.general.ptr.impl.IndirectPtrImpl;
import org.moe.natj.general.ptr.impl.IntPtrImpl;
import org.moe.natj.general.ptr.impl.LongPtrImpl;
import org.moe.natj.general.ptr.impl.NFloatPtrImpl;
import org.moe.natj.general.ptr.impl.NIntPtrImpl;
import org.moe.natj.general.ptr.impl.NLongPtrImpl;
import org.moe.natj.general.ptr.impl.NUIntPtrImpl;
import org.moe.natj.general.ptr.impl.NULongPtrImpl;
import org.moe.natj.general.ptr.impl.ObjCObjectPtrImpl;
import org.moe.natj.general.ptr.impl.ShortPtrImpl;
import org.moe.natj.general.ptr.impl.StructPtrImpl;
import org.moe.natj.general.ptr.impl.VoidPtrImpl;
import org.moe.natj.general.ptr.impl.WCharTPtrImpl;
import org.moe.natj.objc.ObjCObject;

public final class PtrFactory {
    private PtrFactory() {
    }

    public static final VoidPtr newPtr(Buffer buffer) {
        if (buffer == null) {
            return null;
        }
        if (buffer instanceof ByteBuffer) {
            return PtrFactory.newBytePtr((ByteBuffer)buffer);
        }
        if (buffer instanceof CharBuffer) {
            return PtrFactory.newCharPtr((CharBuffer)buffer);
        }
        if (buffer instanceof DoubleBuffer) {
            return PtrFactory.newDoublePtr((DoubleBuffer)buffer);
        }
        if (buffer instanceof FloatBuffer) {
            return PtrFactory.newFloatPtr((FloatBuffer)buffer);
        }
        if (buffer instanceof IntBuffer) {
            return PtrFactory.newIntPtr((IntBuffer)buffer);
        }
        if (buffer instanceof LongBuffer) {
            return PtrFactory.newLongPtr((LongBuffer)buffer);
        }
        if (buffer instanceof ShortBuffer) {
            return PtrFactory.newShortPtr((ShortBuffer)buffer);
        }
        throw new IllegalArgumentException("Could not create offset reference from a non-primitive buffer!");
    }

    public static final VoidPtr newVoidPtr(long peer) {
        return new VoidPtrImpl(peer, true, null);
    }

    public static final VoidPtr newWeakVoidPtr(long peer) {
        return new VoidPtrImpl(peer, false, null);
    }

    public static final CharPtr newCharPtr(int capacity, boolean owned, boolean guarded) {
        if (capacity < 0) {
            throw new IllegalArgumentException();
        }
        if (guarded) {
            return new CharPtrImpl(capacity, owned).getGuarded(capacity);
        }
        return new CharPtrImpl(capacity, owned);
    }

    public static final CharPtr newCharPtr(CharBuffer buffer) {
        if (buffer == null) {
            throw new IllegalArgumentException();
        }
        return new CharPtrImpl(CRuntime.getCharBufferPointer(buffer), buffer);
    }

    public static final CharPtr newCharReference() {
        return new CharPtrImpl(1, true);
    }

    public static final CharPtr newCharReference(char value) {
        CharPtrImpl ptr = new CharPtrImpl(1, true);
        ptr.set(Character.valueOf(value));
        return ptr;
    }

    public static final CharPtr newCharArray(int capacity) {
        if (capacity < 0) {
            throw new IllegalArgumentException();
        }
        return new CharPtrImpl(capacity, true);
    }

    public static final CharPtr newCharArray(int capacity, char value) {
        if (capacity < 0) {
            throw new IllegalArgumentException();
        }
        CharPtrImpl pointer = new CharPtrImpl(capacity, true);
        for (int idx = 0; idx < capacity; ++idx) {
            pointer.set(idx, Character.valueOf(value));
        }
        return pointer;
    }

    public static final CharPtr newCharArray(char[] buffer) {
        if (buffer == null) {
            throw new IllegalArgumentException();
        }
        int size = buffer.length;
        CharPtrImpl pointer = new CharPtrImpl(size, true);
        pointer.copyFrom(buffer);
        return pointer;
    }

    public static final CharPtr newWeakCharReference() {
        return new CharPtrImpl(1, false);
    }

    public static final CharPtr newWeakCharReference(char value) {
        CharPtrImpl ptr = new CharPtrImpl(1, false);
        ptr.set(Character.valueOf(value));
        return ptr;
    }

    public static final CharPtr newWeakCharArray(int capacity) {
        if (capacity < 0) {
            throw new IllegalArgumentException();
        }
        return new CharPtrImpl(capacity, false);
    }

    public static final CharPtr newWeakCharArray(int capacity, char value) {
        if (capacity < 0) {
            throw new IllegalArgumentException();
        }
        CharPtrImpl pointer = new CharPtrImpl(capacity, false);
        for (int idx = 0; idx < capacity; ++idx) {
            pointer.set(idx, Character.valueOf(value));
        }
        return pointer;
    }

    public static final CharPtr newWeakCharArray(char[] buffer) {
        if (buffer == null) {
            throw new IllegalArgumentException();
        }
        int size = buffer.length;
        CharPtrImpl pointer = new CharPtrImpl(size, false);
        pointer.copyFrom(buffer);
        return pointer;
    }

    public static final CharPtr newGuardedCharReference() {
        return PtrFactory.newCharReference().getGuarded(1);
    }

    public static final CharPtr newGuardedCharReference(char value) {
        return PtrFactory.newCharReference(value).getGuarded(1);
    }

    public static final CharPtr newGuardedCharArray(int capacity) {
        return PtrFactory.newCharArray(capacity).getGuarded(capacity);
    }

    public static final CharPtr newGuardedCharArray(int capacity, char value) {
        return PtrFactory.newCharArray(capacity, value).getGuarded(capacity);
    }

    public static final CharPtr newGuardedCharArray(char[] buffer) {
        return PtrFactory.newCharArray(buffer).getGuarded(buffer.length);
    }

    public static final CharPtr newGuardedWeakCharReference() {
        return PtrFactory.newWeakCharReference().getGuarded(1);
    }

    public static final CharPtr newGuardedWeakCharReference(char value) {
        return PtrFactory.newWeakCharReference(value).getGuarded(1);
    }

    public static final CharPtr newGuardedWeakCharArray(int capacity) {
        return PtrFactory.newWeakCharArray(capacity).getGuarded(capacity);
    }

    public static final CharPtr newGuardedWeakCharArray(int capacity, char value) {
        return PtrFactory.newWeakCharArray(capacity, value).getGuarded(capacity);
    }

    public static final CharPtr newGuardedWeakCharArray(char[] buffer) {
        return PtrFactory.newWeakCharArray(buffer).getGuarded(buffer.length);
    }

    public static final BoolPtr newBoolPtr(int capacity, boolean owned, boolean guarded) {
        if (capacity < 0) {
            throw new IllegalArgumentException();
        }
        if (guarded) {
            return new BoolPtrImpl(capacity, owned).getGuarded(capacity);
        }
        return new BoolPtrImpl(capacity, owned);
    }

    public static final BoolPtr newBoolReference() {
        return new BoolPtrImpl(1, true);
    }

    public static final BoolPtr newBoolReference(boolean value) {
        BoolPtrImpl ptr = new BoolPtrImpl(1, true);
        ptr.set(value);
        return ptr;
    }

    public static final BoolPtr newBoolArray(int capacity) {
        if (capacity < 0) {
            throw new IllegalArgumentException();
        }
        return new BoolPtrImpl(capacity, true);
    }

    public static final BoolPtr newBoolArray(int capacity, boolean value) {
        if (capacity < 0) {
            throw new IllegalArgumentException();
        }
        BoolPtrImpl pointer = new BoolPtrImpl(capacity, true);
        for (int idx = 0; idx < capacity; ++idx) {
            pointer.set(idx, value);
        }
        return pointer;
    }

    public static final BoolPtr newBoolArray(boolean[] buffer) {
        if (buffer == null) {
            throw new IllegalArgumentException();
        }
        int size = buffer.length;
        BoolPtrImpl pointer = new BoolPtrImpl(size, true);
        pointer.copyFrom(buffer);
        return pointer;
    }

    public static final BoolPtr newWeakBoolReference() {
        return new BoolPtrImpl(1, false);
    }

    public static final BoolPtr newWeakBoolReference(boolean value) {
        BoolPtrImpl ptr = new BoolPtrImpl(1, false);
        ptr.set(value);
        return ptr;
    }

    public static final BoolPtr newWeakBoolArray(int capacity) {
        if (capacity < 0) {
            throw new IllegalArgumentException();
        }
        return new BoolPtrImpl(capacity, false);
    }

    public static final BoolPtr newWeakBoolArray(int capacity, boolean value) {
        if (capacity < 0) {
            throw new IllegalArgumentException();
        }
        BoolPtrImpl pointer = new BoolPtrImpl(capacity, false);
        for (int idx = 0; idx < capacity; ++idx) {
            pointer.set(idx, value);
        }
        return pointer;
    }

    public static final BoolPtr newWeakBoolArray(boolean[] buffer) {
        if (buffer == null) {
            throw new IllegalArgumentException();
        }
        int size = buffer.length;
        BoolPtrImpl pointer = new BoolPtrImpl(size, false);
        pointer.copyFrom(buffer);
        return pointer;
    }

    public static final BoolPtr newGuardedBoolReference() {
        return PtrFactory.newBoolReference().getGuarded(1);
    }

    public static final BoolPtr newGuardedBoolReference(boolean value) {
        return PtrFactory.newBoolReference(value).getGuarded(1);
    }

    public static final BoolPtr newGuardedBoolArray(int capacity) {
        return PtrFactory.newBoolArray(capacity).getGuarded(capacity);
    }

    public static final BoolPtr newGuardedBoolArray(int capacity, boolean value) {
        return PtrFactory.newBoolArray(capacity, value).getGuarded(capacity);
    }

    public static final BoolPtr newGuardedBoolArray(boolean[] buffer) {
        return PtrFactory.newBoolArray(buffer).getGuarded(buffer.length);
    }

    public static final BoolPtr newGuardedWeakBoolReference() {
        return PtrFactory.newWeakBoolReference().getGuarded(1);
    }

    public static final BoolPtr newGuardedWeakBoolReference(boolean value) {
        return PtrFactory.newWeakBoolReference(value).getGuarded(1);
    }

    public static final BoolPtr newGuardedWeakBoolArray(int capacity) {
        return PtrFactory.newWeakBoolArray(capacity).getGuarded(capacity);
    }

    public static final BoolPtr newGuardedWeakBoolArray(int capacity, boolean value) {
        return PtrFactory.newWeakBoolArray(capacity, value).getGuarded(capacity);
    }

    public static final BoolPtr newGuardedWeakBoolArray(boolean[] buffer) {
        return PtrFactory.newWeakBoolArray(buffer).getGuarded(buffer.length);
    }

    public static final BytePtr newBytePtr(int capacity, boolean owned, boolean guarded) {
        if (capacity < 0) {
            throw new IllegalArgumentException();
        }
        if (guarded) {
            return new BytePtrImpl(capacity, owned).getGuarded(capacity);
        }
        return new BytePtrImpl(capacity, owned);
    }

    public static final BytePtr newBytePtr(ByteBuffer buffer) {
        if (buffer == null) {
            throw new IllegalArgumentException();
        }
        return new BytePtrImpl(CRuntime.getByteBufferPointer(buffer), buffer);
    }

    public static final BytePtr newByteReference() {
        return new BytePtrImpl(1, true);
    }

    public static final BytePtr newByteReference(byte value) {
        BytePtrImpl ptr = new BytePtrImpl(1, true);
        ptr.set(value);
        return ptr;
    }

    public static final BytePtr newByteArray(int capacity) {
        if (capacity < 0) {
            throw new IllegalArgumentException();
        }
        return new BytePtrImpl(capacity, true);
    }

    public static final BytePtr newByteArray(int capacity, byte value) {
        if (capacity < 0) {
            throw new IllegalArgumentException();
        }
        BytePtrImpl pointer = new BytePtrImpl(capacity, true);
        for (int idx = 0; idx < capacity; ++idx) {
            pointer.set(idx, value);
        }
        return pointer;
    }

    public static final BytePtr newByteArray(byte[] buffer) {
        if (buffer == null) {
            throw new IllegalArgumentException();
        }
        int size = buffer.length;
        BytePtrImpl pointer = new BytePtrImpl(size, true);
        pointer.copyFrom(buffer);
        return pointer;
    }

    public static final BytePtr newWeakByteReference() {
        return new BytePtrImpl(1, false);
    }

    public static final BytePtr newWeakByteReference(byte value) {
        BytePtrImpl ptr = new BytePtrImpl(1, false);
        ptr.set(value);
        return ptr;
    }

    public static final BytePtr newWeakByteArray(int capacity) {
        if (capacity < 0) {
            throw new IllegalArgumentException();
        }
        return new BytePtrImpl(capacity, false);
    }

    public static final BytePtr newWeakByteArray(int capacity, byte value) {
        if (capacity < 0) {
            throw new IllegalArgumentException();
        }
        BytePtrImpl pointer = new BytePtrImpl(capacity, false);
        for (int idx = 0; idx < capacity; ++idx) {
            pointer.set(idx, value);
        }
        return pointer;
    }

    public static final BytePtr newWeakByteArray(byte[] buffer) {
        if (buffer == null) {
            throw new IllegalArgumentException();
        }
        int size = buffer.length;
        BytePtrImpl pointer = new BytePtrImpl(size, false);
        pointer.copyFrom(buffer);
        return pointer;
    }

    public static final BytePtr newGuardedByteReference() {
        return PtrFactory.newByteReference().getGuarded(1);
    }

    public static final BytePtr newGuardedByteReference(byte value) {
        return PtrFactory.newByteReference(value).getGuarded(1);
    }

    public static final BytePtr newGuardedByteArray(int capacity) {
        return PtrFactory.newByteArray(capacity).getGuarded(capacity);
    }

    public static final BytePtr newGuardedByteArray(int capacity, byte value) {
        return PtrFactory.newByteArray(capacity, value).getGuarded(capacity);
    }

    public static final BytePtr newGuardedByteArray(byte[] buffer) {
        return PtrFactory.newByteArray(buffer).getGuarded(buffer.length);
    }

    public static final BytePtr newGuardedWeakByteReference() {
        return PtrFactory.newWeakByteReference().getGuarded(1);
    }

    public static final BytePtr newGuardedWeakByteReference(byte value) {
        return PtrFactory.newWeakByteReference(value).getGuarded(1);
    }

    public static final BytePtr newGuardedWeakByteArray(int capacity) {
        return PtrFactory.newWeakByteArray(capacity).getGuarded(capacity);
    }

    public static final BytePtr newGuardedWeakByteArray(int capacity, byte value) {
        return PtrFactory.newWeakByteArray(capacity, value).getGuarded(capacity);
    }

    public static final BytePtr newGuardedWeakByteArray(byte[] buffer) {
        return PtrFactory.newWeakByteArray(buffer).getGuarded(buffer.length);
    }

    public static final ShortPtr newShortPtr(int capacity, boolean owned, boolean guarded) {
        if (capacity < 0) {
            throw new IllegalArgumentException();
        }
        if (guarded) {
            return new ShortPtrImpl(capacity, owned).getGuarded(capacity);
        }
        return new ShortPtrImpl(capacity, owned);
    }

    public static final ShortPtr newShortPtr(ShortBuffer buffer) {
        if (buffer == null) {
            throw new IllegalArgumentException();
        }
        return new ShortPtrImpl(CRuntime.getShortBufferPointer(buffer), buffer);
    }

    public static final ShortPtr newShortReference() {
        return new ShortPtrImpl(1, true);
    }

    public static final ShortPtr newShortReference(short value) {
        ShortPtrImpl ptr = new ShortPtrImpl(1, true);
        ptr.set(value);
        return ptr;
    }

    public static final ShortPtr newShortArray(int capacity) {
        if (capacity < 0) {
            throw new IllegalArgumentException();
        }
        return new ShortPtrImpl(capacity, true);
    }

    public static final ShortPtr newShortArray(int capacity, short value) {
        if (capacity < 0) {
            throw new IllegalArgumentException();
        }
        ShortPtrImpl pointer = new ShortPtrImpl(capacity, true);
        for (int idx = 0; idx < capacity; ++idx) {
            pointer.set(idx, value);
        }
        return pointer;
    }

    public static final ShortPtr newShortArray(short[] buffer) {
        if (buffer == null) {
            throw new IllegalArgumentException();
        }
        int size = buffer.length;
        ShortPtrImpl pointer = new ShortPtrImpl(size, true);
        pointer.copyFrom(buffer);
        return pointer;
    }

    public static final ShortPtr newWeakShortReference() {
        return new ShortPtrImpl(1, false);
    }

    public static final ShortPtr newWeakShortReference(short value) {
        ShortPtrImpl ptr = new ShortPtrImpl(1, false);
        ptr.set(value);
        return ptr;
    }

    public static final ShortPtr newWeakShortArray(int capacity) {
        if (capacity < 0) {
            throw new IllegalArgumentException();
        }
        return new ShortPtrImpl(capacity, false);
    }

    public static final ShortPtr newWeakShortArray(int capacity, short value) {
        if (capacity < 0) {
            throw new IllegalArgumentException();
        }
        ShortPtrImpl pointer = new ShortPtrImpl(capacity, false);
        for (int idx = 0; idx < capacity; ++idx) {
            pointer.set(idx, value);
        }
        return pointer;
    }

    public static final ShortPtr newWeakShortArray(short[] buffer) {
        if (buffer == null) {
            throw new IllegalArgumentException();
        }
        int size = buffer.length;
        ShortPtrImpl pointer = new ShortPtrImpl(size, false);
        pointer.copyFrom(buffer);
        return pointer;
    }

    public static final ShortPtr newGuardedShortReference() {
        return PtrFactory.newShortReference().getGuarded(1);
    }

    public static final ShortPtr newGuardedShortReference(short value) {
        return PtrFactory.newShortReference(value).getGuarded(1);
    }

    public static final ShortPtr newGuardedShortArray(int capacity) {
        return PtrFactory.newShortArray(capacity).getGuarded(capacity);
    }

    public static final ShortPtr newGuardedShortArray(int capacity, short value) {
        return PtrFactory.newShortArray(capacity, value).getGuarded(capacity);
    }

    public static final ShortPtr newGuardedShortArray(short[] buffer) {
        return PtrFactory.newShortArray(buffer).getGuarded(buffer.length);
    }

    public static final ShortPtr newGuardedWeakShortReference() {
        return PtrFactory.newWeakShortReference().getGuarded(1);
    }

    public static final ShortPtr newGuardedWeakShortReference(short value) {
        return PtrFactory.newWeakShortReference(value).getGuarded(1);
    }

    public static final ShortPtr newGuardedWeakShortArray(int capacity) {
        return PtrFactory.newWeakShortArray(capacity).getGuarded(capacity);
    }

    public static final ShortPtr newGuardedWeakShortArray(int capacity, short value) {
        return PtrFactory.newWeakShortArray(capacity, value).getGuarded(capacity);
    }

    public static final ShortPtr newGuardedWeakShortArray(short[] buffer) {
        return PtrFactory.newWeakShortArray(buffer).getGuarded(buffer.length);
    }

    public static final IntPtr newIntPtr(int capacity, boolean owned, boolean guarded) {
        if (capacity < 0) {
            throw new IllegalArgumentException();
        }
        if (guarded) {
            return new IntPtrImpl(capacity, owned).getGuarded(capacity);
        }
        return new IntPtrImpl(capacity, owned);
    }

    public static final IntPtr newIntPtr(IntBuffer buffer) {
        if (buffer == null) {
            throw new IllegalArgumentException();
        }
        return new IntPtrImpl(CRuntime.getIntBufferPointer(buffer), buffer);
    }

    public static final IntPtr newIntReference() {
        return new IntPtrImpl(1, true);
    }

    public static final IntPtr newIntReference(int value) {
        IntPtrImpl ptr = new IntPtrImpl(1, true);
        ptr.set(value);
        return ptr;
    }

    public static final IntPtr newIntArray(int capacity) {
        if (capacity < 0) {
            throw new IllegalArgumentException();
        }
        return new IntPtrImpl(capacity, true);
    }

    public static final IntPtr newIntArray(int capacity, int value) {
        if (capacity < 0) {
            throw new IllegalArgumentException();
        }
        IntPtrImpl pointer = new IntPtrImpl(capacity, true);
        for (int idx = 0; idx < capacity; ++idx) {
            pointer.set(idx, value);
        }
        return pointer;
    }

    public static final IntPtr newIntArray(int[] buffer) {
        if (buffer == null) {
            throw new IllegalArgumentException();
        }
        int size = buffer.length;
        IntPtrImpl pointer = new IntPtrImpl(size, true);
        pointer.copyFrom(buffer);
        return pointer;
    }

    public static final IntPtr newWeakIntReference() {
        return new IntPtrImpl(1, false);
    }

    public static final IntPtr newWeakIntReference(int value) {
        IntPtrImpl ptr = new IntPtrImpl(1, false);
        ptr.set(value);
        return ptr;
    }

    public static final IntPtr newWeakIntArray(int capacity) {
        if (capacity < 0) {
            throw new IllegalArgumentException();
        }
        return new IntPtrImpl(capacity, false);
    }

    public static final IntPtr newWeakIntArray(int capacity, int value) {
        if (capacity < 0) {
            throw new IllegalArgumentException();
        }
        IntPtrImpl pointer = new IntPtrImpl(capacity, false);
        for (int idx = 0; idx < capacity; ++idx) {
            pointer.set(idx, value);
        }
        return pointer;
    }

    public static final IntPtr newWeakIntArray(int[] buffer) {
        if (buffer == null) {
            throw new IllegalArgumentException();
        }
        int size = buffer.length;
        IntPtrImpl pointer = new IntPtrImpl(size, false);
        pointer.copyFrom(buffer);
        return pointer;
    }

    public static final IntPtr newGuardedIntReference() {
        return PtrFactory.newIntReference().getGuarded(1);
    }

    public static final IntPtr newGuardedIntReference(int value) {
        return PtrFactory.newIntReference(value).getGuarded(1);
    }

    public static final IntPtr newGuardedIntArray(int capacity) {
        return PtrFactory.newIntArray(capacity).getGuarded(capacity);
    }

    public static final IntPtr newGuardedIntArray(int capacity, int value) {
        return PtrFactory.newIntArray(capacity, value).getGuarded(capacity);
    }

    public static final IntPtr newGuardedIntArray(int[] buffer) {
        return PtrFactory.newIntArray(buffer).getGuarded(buffer.length);
    }

    public static final IntPtr newGuardedWeakIntReference() {
        return PtrFactory.newWeakIntReference().getGuarded(1);
    }

    public static final IntPtr newGuardedWeakIntReference(int value) {
        return PtrFactory.newWeakIntReference(value).getGuarded(1);
    }

    public static final IntPtr newGuardedWeakIntArray(int capacity) {
        return PtrFactory.newWeakIntArray(capacity).getGuarded(capacity);
    }

    public static final IntPtr newGuardedWeakIntArray(int capacity, int value) {
        return PtrFactory.newWeakIntArray(capacity, value).getGuarded(capacity);
    }

    public static final IntPtr newGuardedWeakIntArray(int[] buffer) {
        return PtrFactory.newWeakIntArray(buffer).getGuarded(buffer.length);
    }

    public static final LongPtr newLongPtr(int capacity, boolean owned, boolean guarded) {
        if (capacity < 0) {
            throw new IllegalArgumentException();
        }
        if (guarded) {
            return new LongPtrImpl(capacity, owned).getGuarded(capacity);
        }
        return new LongPtrImpl(capacity, owned);
    }

    public static final LongPtr newLongPtr(LongBuffer buffer) {
        if (buffer == null) {
            throw new IllegalArgumentException();
        }
        return new LongPtrImpl(CRuntime.getLongBufferPointer(buffer), buffer);
    }

    public static final LongPtr newLongReference() {
        return new LongPtrImpl(1, true);
    }

    public static final LongPtr newLongReference(long value) {
        LongPtrImpl ptr = new LongPtrImpl(1, true);
        ptr.set(value);
        return ptr;
    }

    public static final LongPtr newLongArray(int capacity) {
        if (capacity < 0) {
            throw new IllegalArgumentException();
        }
        return new LongPtrImpl(capacity, true);
    }

    public static final LongPtr newLongArray(int capacity, long value) {
        if (capacity < 0) {
            throw new IllegalArgumentException();
        }
        LongPtrImpl pointer = new LongPtrImpl(capacity, true);
        for (int idx = 0; idx < capacity; ++idx) {
            pointer.set(idx, value);
        }
        return pointer;
    }

    public static final LongPtr newLongArray(long[] buffer) {
        if (buffer == null) {
            throw new IllegalArgumentException();
        }
        int size = buffer.length;
        LongPtrImpl pointer = new LongPtrImpl(size, true);
        pointer.copyFrom(buffer);
        return pointer;
    }

    public static final LongPtr newWeakLongReference() {
        return new LongPtrImpl(1, false);
    }

    public static final LongPtr newWeakLongReference(long value) {
        LongPtrImpl ptr = new LongPtrImpl(1, false);
        ptr.set(value);
        return ptr;
    }

    public static final LongPtr newWeakLongArray(int capacity) {
        if (capacity < 0) {
            throw new IllegalArgumentException();
        }
        return new LongPtrImpl(capacity, false);
    }

    public static final LongPtr newWeakLongArray(int capacity, long value) {
        if (capacity < 0) {
            throw new IllegalArgumentException();
        }
        LongPtrImpl pointer = new LongPtrImpl(capacity, false);
        for (int idx = 0; idx < capacity; ++idx) {
            pointer.set(idx, value);
        }
        return pointer;
    }

    public static final LongPtr newWeakLongArray(long[] buffer) {
        if (buffer == null) {
            throw new IllegalArgumentException();
        }
        int size = buffer.length;
        LongPtrImpl pointer = new LongPtrImpl(size, false);
        pointer.copyFrom(buffer);
        return pointer;
    }

    public static final LongPtr newGuardedLongReference() {
        return PtrFactory.newLongReference().getGuarded(1);
    }

    public static final LongPtr newGuardedLongReference(long value) {
        return PtrFactory.newLongReference(value).getGuarded(1);
    }

    public static final LongPtr newGuardedLongArray(int capacity) {
        return PtrFactory.newLongArray(capacity).getGuarded(capacity);
    }

    public static final LongPtr newGuardedLongArray(int capacity, long value) {
        return PtrFactory.newLongArray(capacity, value).getGuarded(capacity);
    }

    public static final LongPtr newGuardedLongArray(long[] buffer) {
        return PtrFactory.newLongArray(buffer).getGuarded(buffer.length);
    }

    public static final LongPtr newGuardedWeakLongReference() {
        return PtrFactory.newWeakLongReference().getGuarded(1);
    }

    public static final LongPtr newGuardedWeakLongReference(long value) {
        return PtrFactory.newWeakLongReference(value).getGuarded(1);
    }

    public static final LongPtr newGuardedWeakLongArray(int capacity) {
        return PtrFactory.newWeakLongArray(capacity).getGuarded(capacity);
    }

    public static final LongPtr newGuardedWeakLongArray(int capacity, long value) {
        return PtrFactory.newWeakLongArray(capacity, value).getGuarded(capacity);
    }

    public static final LongPtr newGuardedWeakLongArray(long[] buffer) {
        return PtrFactory.newWeakLongArray(buffer).getGuarded(buffer.length);
    }

    public static final FloatPtr newFloatPtr(int capacity, boolean owned, boolean guarded) {
        if (capacity < 0) {
            throw new IllegalArgumentException();
        }
        if (guarded) {
            return new FloatPtrImpl(capacity, owned).getGuarded(capacity);
        }
        return new FloatPtrImpl(capacity, owned);
    }

    public static final FloatPtr newFloatPtr(FloatBuffer buffer) {
        if (buffer == null) {
            throw new IllegalArgumentException();
        }
        return new FloatPtrImpl(CRuntime.getFloatBufferPointer(buffer), buffer);
    }

    public static final FloatPtr newFloatReference() {
        return new FloatPtrImpl(1, true);
    }

    public static final FloatPtr newFloatReference(float value) {
        FloatPtrImpl ptr = new FloatPtrImpl(1, true);
        ptr.set(Float.valueOf(value));
        return ptr;
    }

    public static final FloatPtr newFloatArray(int capacity) {
        if (capacity < 0) {
            throw new IllegalArgumentException();
        }
        return new FloatPtrImpl(capacity, true);
    }

    public static final FloatPtr newFloatArray(int capacity, float value) {
        if (capacity < 0) {
            throw new IllegalArgumentException();
        }
        FloatPtrImpl pointer = new FloatPtrImpl(capacity, true);
        for (int idx = 0; idx < capacity; ++idx) {
            pointer.set(idx, Float.valueOf(value));
        }
        return pointer;
    }

    public static final FloatPtr newFloatArray(float[] buffer) {
        if (buffer == null) {
            throw new IllegalArgumentException();
        }
        int size = buffer.length;
        FloatPtrImpl pointer = new FloatPtrImpl(size, true);
        pointer.copyFrom(buffer);
        return pointer;
    }

    public static final FloatPtr newWeakFloatReference() {
        return new FloatPtrImpl(1, false);
    }

    public static final FloatPtr newWeakFloatReference(float value) {
        FloatPtrImpl ptr = new FloatPtrImpl(1, false);
        ptr.set(Float.valueOf(value));
        return ptr;
    }

    public static final FloatPtr newWeakFloatArray(int capacity) {
        if (capacity < 0) {
            throw new IllegalArgumentException();
        }
        return new FloatPtrImpl(capacity, false);
    }

    public static final FloatPtr newWeakFloatArray(int capacity, float value) {
        if (capacity < 0) {
            throw new IllegalArgumentException();
        }
        FloatPtrImpl pointer = new FloatPtrImpl(capacity, false);
        for (int idx = 0; idx < capacity; ++idx) {
            pointer.set(idx, Float.valueOf(value));
        }
        return pointer;
    }

    public static final FloatPtr newWeakFloatArray(float[] buffer) {
        if (buffer == null) {
            throw new IllegalArgumentException();
        }
        int size = buffer.length;
        FloatPtrImpl pointer = new FloatPtrImpl(size, false);
        pointer.copyFrom(buffer);
        return pointer;
    }

    public static final FloatPtr newGuardedFloatReference() {
        return PtrFactory.newFloatReference().getGuarded(1);
    }

    public static final FloatPtr newGuardedFloatReference(float value) {
        return PtrFactory.newFloatReference(value).getGuarded(1);
    }

    public static final FloatPtr newGuardedFloatArray(int capacity) {
        return PtrFactory.newFloatArray(capacity).getGuarded(capacity);
    }

    public static final FloatPtr newGuardedFloatArray(int capacity, float value) {
        return PtrFactory.newFloatArray(capacity, value).getGuarded(capacity);
    }

    public static final FloatPtr newGuardedFloatArray(float[] buffer) {
        return PtrFactory.newFloatArray(buffer).getGuarded(buffer.length);
    }

    public static final FloatPtr newGuardedWeakFloatReference() {
        return PtrFactory.newWeakFloatReference().getGuarded(1);
    }

    public static final FloatPtr newGuardedWeakFloatReference(float value) {
        return PtrFactory.newWeakFloatReference(value).getGuarded(1);
    }

    public static final FloatPtr newGuardedWeakFloatArray(int capacity) {
        return PtrFactory.newWeakFloatArray(capacity).getGuarded(capacity);
    }

    public static final FloatPtr newGuardedWeakFloatArray(int capacity, float value) {
        return PtrFactory.newWeakFloatArray(capacity, value).getGuarded(capacity);
    }

    public static final FloatPtr newGuardedWeakFloatArray(float[] buffer) {
        return PtrFactory.newWeakFloatArray(buffer).getGuarded(buffer.length);
    }

    public static final DoublePtr newDoublePtr(int capacity, boolean owned, boolean guarded) {
        if (capacity < 0) {
            throw new IllegalArgumentException();
        }
        if (guarded) {
            return new DoublePtrImpl(capacity, owned).getGuarded(capacity);
        }
        return new DoublePtrImpl(capacity, owned);
    }

    public static final DoublePtr newDoublePtr(DoubleBuffer buffer) {
        if (buffer == null) {
            throw new IllegalArgumentException();
        }
        return new DoublePtrImpl(CRuntime.getDoubleBufferPointer(buffer), buffer);
    }

    public static final DoublePtr newDoubleReference() {
        return new DoublePtrImpl(1, true);
    }

    public static final DoublePtr newDoubleReference(double value) {
        DoublePtrImpl ptr = new DoublePtrImpl(1, true);
        ptr.set(value);
        return ptr;
    }

    public static final DoublePtr newDoubleArray(int capacity) {
        if (capacity < 0) {
            throw new IllegalArgumentException();
        }
        return new DoublePtrImpl(capacity, true);
    }

    public static final DoublePtr newDoubleArray(int capacity, double value) {
        if (capacity < 0) {
            throw new IllegalArgumentException();
        }
        DoublePtrImpl pointer = new DoublePtrImpl(capacity, true);
        for (int idx = 0; idx < capacity; ++idx) {
            pointer.set(idx, value);
        }
        return pointer;
    }

    public static final DoublePtr newDoubleArray(double[] buffer) {
        if (buffer == null) {
            throw new IllegalArgumentException();
        }
        int size = buffer.length;
        DoublePtrImpl pointer = new DoublePtrImpl(size, true);
        pointer.copyFrom(buffer);
        return pointer;
    }

    public static final DoublePtr newWeakDoubleReference() {
        return new DoublePtrImpl(1, false);
    }

    public static final DoublePtr newWeakDoubleReference(double value) {
        DoublePtrImpl ptr = new DoublePtrImpl(1, false);
        ptr.set(value);
        return ptr;
    }

    public static final DoublePtr newWeakDoubleArray(int capacity) {
        if (capacity < 0) {
            throw new IllegalArgumentException();
        }
        return new DoublePtrImpl(capacity, false);
    }

    public static final DoublePtr newWeakDoubleArray(int capacity, double value) {
        if (capacity < 0) {
            throw new IllegalArgumentException();
        }
        DoublePtrImpl pointer = new DoublePtrImpl(capacity, false);
        for (int idx = 0; idx < capacity; ++idx) {
            pointer.set(idx, value);
        }
        return pointer;
    }

    public static final DoublePtr newWeakDoubleArray(double[] buffer) {
        if (buffer == null) {
            throw new IllegalArgumentException();
        }
        int size = buffer.length;
        DoublePtrImpl pointer = new DoublePtrImpl(size, false);
        pointer.copyFrom(buffer);
        return pointer;
    }

    public static final DoublePtr newGuardedDoubleReference() {
        return PtrFactory.newDoubleReference().getGuarded(1);
    }

    public static final DoublePtr newGuardedDoubleReference(double value) {
        return PtrFactory.newDoubleReference(value).getGuarded(1);
    }

    public static final DoublePtr newGuardedDoubleArray(int capacity) {
        return PtrFactory.newDoubleArray(capacity).getGuarded(capacity);
    }

    public static final DoublePtr newGuardedDoubleArray(int capacity, double value) {
        return PtrFactory.newDoubleArray(capacity, value).getGuarded(capacity);
    }

    public static final DoublePtr newGuardedDoubleArray(double[] buffer) {
        return PtrFactory.newDoubleArray(buffer).getGuarded(buffer.length);
    }

    public static final DoublePtr newGuardedWeakDoubleReference() {
        return PtrFactory.newWeakDoubleReference().getGuarded(1);
    }

    public static final DoublePtr newGuardedWeakDoubleReference(double value) {
        return PtrFactory.newWeakDoubleReference(value).getGuarded(1);
    }

    public static final DoublePtr newGuardedWeakDoubleArray(int capacity) {
        return PtrFactory.newWeakDoubleArray(capacity).getGuarded(capacity);
    }

    public static final DoublePtr newGuardedWeakDoubleArray(int capacity, double value) {
        return PtrFactory.newWeakDoubleArray(capacity, value).getGuarded(capacity);
    }

    public static final DoublePtr newGuardedWeakDoubleArray(double[] buffer) {
        return PtrFactory.newWeakDoubleArray(buffer).getGuarded(buffer.length);
    }

    public static final NFloatPtr newNFloatPtr(int capacity, boolean owned, boolean guarded) {
        if (capacity < 0) {
            throw new IllegalArgumentException();
        }
        if (guarded) {
            return new NFloatPtrImpl(capacity, owned).getGuarded(capacity);
        }
        return new NFloatPtrImpl(capacity, owned);
    }

    public static final NFloatPtr newNFloatReference() {
        return new NFloatPtrImpl(1, true);
    }

    public static final NFloatPtr newNFloatReference(double value) {
        NFloatPtrImpl ptr = new NFloatPtrImpl(1, true);
        ptr.set(value);
        return ptr;
    }

    public static final NFloatPtr newNFloatArray(int capacity) {
        if (capacity < 0) {
            throw new IllegalArgumentException();
        }
        return new NFloatPtrImpl(capacity, true);
    }

    public static final NFloatPtr newNFloatArray(int capacity, double value) {
        if (capacity < 0) {
            throw new IllegalArgumentException();
        }
        NFloatPtrImpl pointer = new NFloatPtrImpl(capacity, true);
        for (int idx = 0; idx < capacity; ++idx) {
            pointer.set(idx, value);
        }
        return pointer;
    }

    public static final NFloatPtr newNFloatArray(double[] buffer) {
        if (buffer == null) {
            throw new IllegalArgumentException();
        }
        int size = buffer.length;
        NFloatPtrImpl pointer = new NFloatPtrImpl(size, true);
        pointer.copyFrom(buffer);
        return pointer;
    }

    public static final NFloatPtr newWeakNFloatReference() {
        return new NFloatPtrImpl(1, false);
    }

    public static final NFloatPtr newWeakNFloatReference(double value) {
        NFloatPtrImpl ptr = new NFloatPtrImpl(1, false);
        ptr.set(value);
        return ptr;
    }

    public static final NFloatPtr newWeakNFloatArray(int capacity) {
        if (capacity < 0) {
            throw new IllegalArgumentException();
        }
        return new NFloatPtrImpl(capacity, false);
    }

    public static final NFloatPtr newWeakNFloatArray(int capacity, double value) {
        if (capacity < 0) {
            throw new IllegalArgumentException();
        }
        NFloatPtrImpl pointer = new NFloatPtrImpl(capacity, false);
        for (int idx = 0; idx < capacity; ++idx) {
            pointer.set(idx, value);
        }
        return pointer;
    }

    public static final NFloatPtr newWeakNFloatArray(double[] buffer) {
        if (buffer == null) {
            throw new IllegalArgumentException();
        }
        int size = buffer.length;
        NFloatPtrImpl pointer = new NFloatPtrImpl(size, false);
        pointer.copyFrom(buffer);
        return pointer;
    }

    public static final NFloatPtr newGuardedNFloatReference() {
        return PtrFactory.newNFloatReference().getGuarded(1);
    }

    public static final NFloatPtr newGuardedNFloatReference(double value) {
        return PtrFactory.newNFloatReference(value).getGuarded(1);
    }

    public static final NFloatPtr newGuardedNFloatArray(int capacity) {
        return PtrFactory.newNFloatArray(capacity).getGuarded(capacity);
    }

    public static final NFloatPtr newGuardedNFloatArray(int capacity, double value) {
        return PtrFactory.newNFloatArray(capacity, value).getGuarded(capacity);
    }

    public static final NFloatPtr newGuardedNFloatArray(double[] buffer) {
        return PtrFactory.newNFloatArray(buffer).getGuarded(buffer.length);
    }

    public static final NFloatPtr newGuardedWeakNFloatReference() {
        return PtrFactory.newWeakNFloatReference().getGuarded(1);
    }

    public static final NFloatPtr newGuardedWeakNFloatReference(double value) {
        return PtrFactory.newWeakNFloatReference(value).getGuarded(1);
    }

    public static final NFloatPtr newGuardedWeakNFloatArray(int capacity) {
        return PtrFactory.newWeakNFloatArray(capacity).getGuarded(capacity);
    }

    public static final NFloatPtr newGuardedWeakNFloatArray(int capacity, double value) {
        return PtrFactory.newWeakNFloatArray(capacity, value).getGuarded(capacity);
    }

    public static final NFloatPtr newGuardedWeakNFloatArray(double[] buffer) {
        return PtrFactory.newWeakNFloatArray(buffer).getGuarded(buffer.length);
    }

    public static final NUIntPtr newNUIntPtr(int capacity, boolean owned, boolean guarded) {
        if (capacity < 0) {
            throw new IllegalArgumentException();
        }
        if (guarded) {
            return new NUIntPtrImpl(capacity, owned).getGuarded(capacity);
        }
        return new NUIntPtrImpl(capacity, owned);
    }

    public static final NUIntPtr newNUIntReference() {
        return new NUIntPtrImpl(1, true);
    }

    public static final NUIntPtr newNUIntReference(long value) {
        NUIntPtrImpl ptr = new NUIntPtrImpl(1, true);
        ptr.set(value);
        return ptr;
    }

    public static final NUIntPtr newNUIntArray(int capacity) {
        if (capacity < 0) {
            throw new IllegalArgumentException();
        }
        return new NUIntPtrImpl(capacity, true);
    }

    public static final NUIntPtr newNUIntArray(int capacity, long value) {
        if (capacity < 0) {
            throw new IllegalArgumentException();
        }
        NUIntPtrImpl pointer = new NUIntPtrImpl(capacity, true);
        for (int idx = 0; idx < capacity; ++idx) {
            pointer.set(idx, value);
        }
        return pointer;
    }

    public static final NUIntPtr newNUIntArray(long[] buffer) {
        if (buffer == null) {
            throw new IllegalArgumentException();
        }
        int size = buffer.length;
        NUIntPtrImpl pointer = new NUIntPtrImpl(size, true);
        pointer.copyFrom(buffer);
        return pointer;
    }

    public static final NUIntPtr newWeakNUIntReference() {
        return new NUIntPtrImpl(1, false);
    }

    public static final NUIntPtr newWeakNUIntReference(long value) {
        NUIntPtrImpl ptr = new NUIntPtrImpl(1, false);
        ptr.set(value);
        return ptr;
    }

    public static final NUIntPtr newWeakNUIntArray(int capacity) {
        if (capacity < 0) {
            throw new IllegalArgumentException();
        }
        return new NUIntPtrImpl(capacity, false);
    }

    public static final NUIntPtr newWeakNUIntArray(int capacity, long value) {
        if (capacity < 0) {
            throw new IllegalArgumentException();
        }
        NUIntPtrImpl pointer = new NUIntPtrImpl(capacity, false);
        for (int idx = 0; idx < capacity; ++idx) {
            pointer.set(idx, value);
        }
        return pointer;
    }

    public static final NUIntPtr newWeakNUIntArray(long[] buffer) {
        if (buffer == null) {
            throw new IllegalArgumentException();
        }
        int size = buffer.length;
        NUIntPtrImpl pointer = new NUIntPtrImpl(size, false);
        pointer.copyFrom(buffer);
        return pointer;
    }

    public static final NUIntPtr newGuardedNUIntReference() {
        return PtrFactory.newNUIntReference().getGuarded(1);
    }

    public static final NUIntPtr newGuardedNUIntReference(long value) {
        return PtrFactory.newNUIntReference(value).getGuarded(1);
    }

    public static final NUIntPtr newGuardedNUIntArray(int capacity) {
        return PtrFactory.newNUIntArray(capacity).getGuarded(capacity);
    }

    public static final NUIntPtr newGuardedNUIntArray(int capacity, long value) {
        return PtrFactory.newNUIntArray(capacity, value).getGuarded(capacity);
    }

    public static final NUIntPtr newGuardedNUIntArray(long[] buffer) {
        return PtrFactory.newNUIntArray(buffer).getGuarded(buffer.length);
    }

    public static final NUIntPtr newGuardedWeakNUIntReference() {
        return PtrFactory.newWeakNUIntReference().getGuarded(1);
    }

    public static final NUIntPtr newGuardedWeakNUIntReference(long value) {
        return PtrFactory.newWeakNUIntReference(value).getGuarded(1);
    }

    public static final NUIntPtr newGuardedWeakNUIntArray(int capacity) {
        return PtrFactory.newWeakNUIntArray(capacity).getGuarded(capacity);
    }

    public static final NUIntPtr newGuardedWeakNUIntArray(int capacity, long value) {
        return PtrFactory.newWeakNUIntArray(capacity, value).getGuarded(capacity);
    }

    public static final NUIntPtr newGuardedWeakNUIntArray(long[] buffer) {
        return PtrFactory.newWeakNUIntArray(buffer).getGuarded(buffer.length);
    }

    public static final NIntPtr newNIntPtr(int capacity, boolean owned, boolean guarded) {
        if (capacity < 0) {
            throw new IllegalArgumentException();
        }
        if (guarded) {
            return new NIntPtrImpl(capacity, owned).getGuarded(capacity);
        }
        return new NIntPtrImpl(capacity, owned);
    }

    public static final NIntPtr newNIntReference() {
        return new NIntPtrImpl(1, true);
    }

    public static final NIntPtr newNIntReference(long value) {
        NIntPtrImpl ptr = new NIntPtrImpl(1, true);
        ptr.set(value);
        return ptr;
    }

    public static final NIntPtr newNIntArray(int capacity) {
        if (capacity < 0) {
            throw new IllegalArgumentException();
        }
        return new NIntPtrImpl(capacity, true);
    }

    public static final NIntPtr newNIntArray(int capacity, long value) {
        if (capacity < 0) {
            throw new IllegalArgumentException();
        }
        NIntPtrImpl pointer = new NIntPtrImpl(capacity, true);
        for (int idx = 0; idx < capacity; ++idx) {
            pointer.set(idx, value);
        }
        return pointer;
    }

    public static final NIntPtr newNIntArray(long[] buffer) {
        if (buffer == null) {
            throw new IllegalArgumentException();
        }
        int size = buffer.length;
        NIntPtrImpl pointer = new NIntPtrImpl(size, true);
        pointer.copyFrom(buffer);
        return pointer;
    }

    public static final NIntPtr newWeakNIntReference() {
        return new NIntPtrImpl(1, false);
    }

    public static final NIntPtr newWeakNIntReference(long value) {
        NIntPtrImpl ptr = new NIntPtrImpl(1, false);
        ptr.set(value);
        return ptr;
    }

    public static final NIntPtr newWeakNIntArray(int capacity) {
        if (capacity < 0) {
            throw new IllegalArgumentException();
        }
        return new NIntPtrImpl(capacity, false);
    }

    public static final NIntPtr newWeakNIntArray(int capacity, long value) {
        if (capacity < 0) {
            throw new IllegalArgumentException();
        }
        NIntPtrImpl pointer = new NIntPtrImpl(capacity, false);
        for (int idx = 0; idx < capacity; ++idx) {
            pointer.set(idx, value);
        }
        return pointer;
    }

    public static final NIntPtr newWeakNIntArray(long[] buffer) {
        if (buffer == null) {
            throw new IllegalArgumentException();
        }
        int size = buffer.length;
        NIntPtrImpl pointer = new NIntPtrImpl(size, false);
        pointer.copyFrom(buffer);
        return pointer;
    }

    public static final NIntPtr newGuardedNIntReference() {
        return PtrFactory.newNIntReference().getGuarded(1);
    }

    public static final NIntPtr newGuardedNIntReference(long value) {
        return PtrFactory.newNIntReference(value).getGuarded(1);
    }

    public static final NIntPtr newGuardedNIntArray(int capacity) {
        return PtrFactory.newNIntArray(capacity).getGuarded(capacity);
    }

    public static final NIntPtr newGuardedNIntArray(int capacity, long value) {
        return PtrFactory.newNIntArray(capacity, value).getGuarded(capacity);
    }

    public static final NIntPtr newGuardedNIntArray(long[] buffer) {
        return PtrFactory.newNIntArray(buffer).getGuarded(buffer.length);
    }

    public static final NIntPtr newGuardedWeakNIntReference() {
        return PtrFactory.newWeakNIntReference().getGuarded(1);
    }

    public static final NIntPtr newGuardedWeakNIntReference(long value) {
        return PtrFactory.newWeakNIntReference(value).getGuarded(1);
    }

    public static final NIntPtr newGuardedWeakNIntArray(int capacity) {
        return PtrFactory.newWeakNIntArray(capacity).getGuarded(capacity);
    }

    public static final NIntPtr newGuardedWeakNIntArray(int capacity, long value) {
        return PtrFactory.newWeakNIntArray(capacity, value).getGuarded(capacity);
    }

    public static final NIntPtr newGuardedWeakNIntArray(long[] buffer) {
        return PtrFactory.newWeakNIntArray(buffer).getGuarded(buffer.length);
    }

    public static final NULongPtr newNULongPtr(int capacity, boolean owned, boolean guarded) {
        if (capacity < 0) {
            throw new IllegalArgumentException();
        }
        if (guarded) {
            return new NULongPtrImpl(capacity, owned).getGuarded(capacity);
        }
        return new NULongPtrImpl(capacity, owned);
    }

    public static final NULongPtr newNULongReference() {
        return new NULongPtrImpl(1, true);
    }

    public static final NULongPtr newNULongReference(long value) {
        NULongPtrImpl ptr = new NULongPtrImpl(1, true);
        ptr.set(value);
        return ptr;
    }

    public static final NULongPtr newNULongArray(int capacity) {
        if (capacity < 0) {
            throw new IllegalArgumentException();
        }
        return new NULongPtrImpl(capacity, true);
    }

    public static final NULongPtr newNULongArray(int capacity, long value) {
        if (capacity < 0) {
            throw new IllegalArgumentException();
        }
        NULongPtrImpl pointer = new NULongPtrImpl(capacity, true);
        for (int idx = 0; idx < capacity; ++idx) {
            pointer.set(idx, value);
        }
        return pointer;
    }

    public static final NULongPtr newNULongArray(long[] buffer) {
        if (buffer == null) {
            throw new IllegalArgumentException();
        }
        int size = buffer.length;
        NULongPtrImpl pointer = new NULongPtrImpl(size, true);
        pointer.copyFrom(buffer);
        return pointer;
    }

    public static final NULongPtr newWeakNULongReference() {
        return new NULongPtrImpl(1, false);
    }

    public static final NULongPtr newWeakNULongReference(long value) {
        NULongPtrImpl ptr = new NULongPtrImpl(1, false);
        ptr.set(value);
        return ptr;
    }

    public static final NULongPtr newWeakNULongArray(int capacity) {
        if (capacity < 0) {
            throw new IllegalArgumentException();
        }
        return new NULongPtrImpl(capacity, false);
    }

    public static final NULongPtr newWeakNULongArray(int capacity, long value) {
        if (capacity < 0) {
            throw new IllegalArgumentException();
        }
        NULongPtrImpl pointer = new NULongPtrImpl(capacity, false);
        for (int idx = 0; idx < capacity; ++idx) {
            pointer.set(idx, value);
        }
        return pointer;
    }

    public static final NULongPtr newWeakNULongArray(long[] buffer) {
        if (buffer == null) {
            throw new IllegalArgumentException();
        }
        int size = buffer.length;
        NULongPtrImpl pointer = new NULongPtrImpl(size, false);
        pointer.copyFrom(buffer);
        return pointer;
    }

    public static final NULongPtr newGuardedNULongReference() {
        return PtrFactory.newNULongReference().getGuarded(1);
    }

    public static final NULongPtr newGuardedNULongReference(long value) {
        return PtrFactory.newNULongReference(value).getGuarded(1);
    }

    public static final NULongPtr newGuardedNULongArray(int capacity) {
        return PtrFactory.newNULongArray(capacity).getGuarded(capacity);
    }

    public static final NULongPtr newGuardedNULongArray(int capacity, long value) {
        return PtrFactory.newNULongArray(capacity, value).getGuarded(capacity);
    }

    public static final NULongPtr newGuardedNULongArray(long[] buffer) {
        return PtrFactory.newNULongArray(buffer).getGuarded(buffer.length);
    }

    public static final NULongPtr newGuardedWeakNULongReference() {
        return PtrFactory.newWeakNULongReference().getGuarded(1);
    }

    public static final NULongPtr newGuardedWeakNULongReference(long value) {
        return PtrFactory.newWeakNULongReference(value).getGuarded(1);
    }

    public static final NULongPtr newGuardedWeakNULongArray(int capacity) {
        return PtrFactory.newWeakNULongArray(capacity).getGuarded(capacity);
    }

    public static final NULongPtr newGuardedWeakNULongArray(int capacity, long value) {
        return PtrFactory.newWeakNULongArray(capacity, value).getGuarded(capacity);
    }

    public static final NULongPtr newGuardedWeakNULongArray(long[] buffer) {
        return PtrFactory.newWeakNULongArray(buffer).getGuarded(buffer.length);
    }

    public static final NLongPtr newNLongPtr(int capacity, boolean owned, boolean guarded) {
        if (capacity < 0) {
            throw new IllegalArgumentException();
        }
        if (guarded) {
            return new NLongPtrImpl(capacity, owned).getGuarded(capacity);
        }
        return new NLongPtrImpl(capacity, owned);
    }

    public static final NLongPtr newNLongReference() {
        return new NLongPtrImpl(1, true);
    }

    public static final NLongPtr newNLongReference(long value) {
        NLongPtrImpl ptr = new NLongPtrImpl(1, true);
        ptr.set(value);
        return ptr;
    }

    public static final NLongPtr newNLongArray(int capacity) {
        if (capacity < 0) {
            throw new IllegalArgumentException();
        }
        return new NLongPtrImpl(capacity, true);
    }

    public static final NLongPtr newNLongArray(int capacity, long value) {
        if (capacity < 0) {
            throw new IllegalArgumentException();
        }
        NLongPtrImpl pointer = new NLongPtrImpl(capacity, true);
        for (int idx = 0; idx < capacity; ++idx) {
            pointer.set(idx, value);
        }
        return pointer;
    }

    public static final NLongPtr newNLongArray(long[] buffer) {
        if (buffer == null) {
            throw new IllegalArgumentException();
        }
        int size = buffer.length;
        NLongPtrImpl pointer = new NLongPtrImpl(size, true);
        pointer.copyFrom(buffer);
        return pointer;
    }

    public static final NLongPtr newWeakNLongReference() {
        return new NLongPtrImpl(1, false);
    }

    public static final NLongPtr newWeakNLongReference(long value) {
        NLongPtrImpl ptr = new NLongPtrImpl(1, false);
        ptr.set(value);
        return ptr;
    }

    public static final NLongPtr newWeakNLongArray(int capacity) {
        if (capacity < 0) {
            throw new IllegalArgumentException();
        }
        return new NLongPtrImpl(capacity, false);
    }

    public static final NLongPtr newWeakNLongArray(int capacity, long value) {
        if (capacity < 0) {
            throw new IllegalArgumentException();
        }
        NLongPtrImpl pointer = new NLongPtrImpl(capacity, false);
        for (int idx = 0; idx < capacity; ++idx) {
            pointer.set(idx, value);
        }
        return pointer;
    }

    public static final NLongPtr newWeakNLongArray(long[] buffer) {
        if (buffer == null) {
            throw new IllegalArgumentException();
        }
        int size = buffer.length;
        NLongPtrImpl pointer = new NLongPtrImpl(size, false);
        pointer.copyFrom(buffer);
        return pointer;
    }

    public static final NLongPtr newGuardedNLongReference() {
        return PtrFactory.newNLongReference().getGuarded(1);
    }

    public static final NLongPtr newGuardedNLongReference(long value) {
        return PtrFactory.newNLongReference(value).getGuarded(1);
    }

    public static final NLongPtr newGuardedNLongArray(int capacity) {
        return PtrFactory.newNLongArray(capacity).getGuarded(capacity);
    }

    public static final NLongPtr newGuardedNLongArray(int capacity, long value) {
        return PtrFactory.newNLongArray(capacity, value).getGuarded(capacity);
    }

    public static final NLongPtr newGuardedNLongArray(long[] buffer) {
        return PtrFactory.newNLongArray(buffer).getGuarded(buffer.length);
    }

    public static final NLongPtr newGuardedWeakNLongReference() {
        return PtrFactory.newWeakNLongReference().getGuarded(1);
    }

    public static final NLongPtr newGuardedWeakNLongReference(long value) {
        return PtrFactory.newWeakNLongReference(value).getGuarded(1);
    }

    public static final NLongPtr newGuardedWeakNLongArray(int capacity) {
        return PtrFactory.newWeakNLongArray(capacity).getGuarded(capacity);
    }

    public static final NLongPtr newGuardedWeakNLongArray(int capacity, long value) {
        return PtrFactory.newWeakNLongArray(capacity, value).getGuarded(capacity);
    }

    public static final NLongPtr newGuardedWeakNLongArray(long[] buffer) {
        return PtrFactory.newWeakNLongArray(buffer).getGuarded(buffer.length);
    }

    public static final WCharTPtr newWCharTPtr(int capacity, boolean owned, boolean guarded) {
        if (capacity < 0) {
            throw new IllegalArgumentException();
        }
        if (guarded) {
            return new WCharTPtrImpl(capacity, owned).getGuarded(capacity);
        }
        return new WCharTPtrImpl(capacity, owned);
    }

    public static final WCharTPtr newWCharTPtr(IntBuffer buffer) {
        if (buffer == null) {
            throw new IllegalArgumentException();
        }
        return new WCharTPtrImpl(CRuntime.getIntBufferPointer(buffer), buffer);
    }

    public static final WCharTPtr newWCharTReference() {
        return new WCharTPtrImpl(1, true);
    }

    public static final WCharTPtr newWCharTReference(int value) {
        WCharTPtrImpl ptr = new WCharTPtrImpl(1, true);
        ptr.set(value);
        return ptr;
    }

    public static final WCharTPtr newWCharTArray(int capacity) {
        if (capacity < 0) {
            throw new IllegalArgumentException();
        }
        return new WCharTPtrImpl(capacity, true);
    }

    public static final WCharTPtr newWCharTArray(int capacity, int value) {
        if (capacity < 0) {
            throw new IllegalArgumentException();
        }
        WCharTPtrImpl pointer = new WCharTPtrImpl(capacity, true);
        for (int idx = 0; idx < capacity; ++idx) {
            pointer.set(idx, value);
        }
        return pointer;
    }

    public static final WCharTPtr newWCharTArray(int[] buffer) {
        if (buffer == null) {
            throw new IllegalArgumentException();
        }
        int size = buffer.length;
        WCharTPtrImpl pointer = new WCharTPtrImpl(size, true);
        pointer.copyFrom(buffer);
        return pointer;
    }

    public static final WCharTPtr newWeakWCharTReference() {
        return new WCharTPtrImpl(1, false);
    }

    public static final WCharTPtr newWeakWCharTReference(int value) {
        WCharTPtrImpl ptr = new WCharTPtrImpl(1, false);
        ptr.set(value);
        return ptr;
    }

    public static final WCharTPtr newWeakWCharTArray(int capacity) {
        if (capacity < 0) {
            throw new IllegalArgumentException();
        }
        return new WCharTPtrImpl(capacity, false);
    }

    public static final WCharTPtr newWeakWCharTArray(int capacity, int value) {
        if (capacity < 0) {
            throw new IllegalArgumentException();
        }
        WCharTPtrImpl pointer = new WCharTPtrImpl(capacity, false);
        for (int idx = 0; idx < capacity; ++idx) {
            pointer.set(idx, value);
        }
        return pointer;
    }

    public static final WCharTPtr newWeakWCharTArray(int[] buffer) {
        if (buffer == null) {
            throw new IllegalArgumentException();
        }
        int size = buffer.length;
        WCharTPtrImpl pointer = new WCharTPtrImpl(size, false);
        pointer.copyFrom(buffer);
        return pointer;
    }

    public static final WCharTPtr newGuardedWCharTReference() {
        return PtrFactory.newWCharTReference().getGuarded(1);
    }

    public static final WCharTPtr newGuardedWCharTReference(int value) {
        return PtrFactory.newWCharTReference(value).getGuarded(1);
    }

    public static final WCharTPtr newGuardedWCharTArray(int capacity) {
        return PtrFactory.newWCharTArray(capacity).getGuarded(capacity);
    }

    public static final WCharTPtr newGuardedWCharTArray(int capacity, int value) {
        return PtrFactory.newWCharTArray(capacity, value).getGuarded(capacity);
    }

    public static final WCharTPtr newGuardedWCharTArray(int[] buffer) {
        return PtrFactory.newWCharTArray(buffer).getGuarded(buffer.length);
    }

    public static final WCharTPtr newGuardedWeakWCharTReference() {
        return PtrFactory.newWeakWCharTReference().getGuarded(1);
    }

    public static final WCharTPtr newGuardedWeakWCharTReference(int value) {
        return PtrFactory.newWeakWCharTReference(value).getGuarded(1);
    }

    public static final WCharTPtr newGuardedWeakWCharTArray(int capacity) {
        return PtrFactory.newWeakWCharTArray(capacity).getGuarded(capacity);
    }

    public static final WCharTPtr newGuardedWeakWCharTArray(int capacity, int value) {
        return PtrFactory.newWeakWCharTArray(capacity, value).getGuarded(capacity);
    }

    public static final WCharTPtr newGuardedWeakWCharTArray(int[] buffer) {
        return PtrFactory.newWeakWCharTArray(buffer).getGuarded(buffer.length);
    }

    public static final <T extends StructObject> Ptr<T> newStructPtr(Class<T> type, int capacity, boolean owned, boolean guarded) {
        if (type == null || capacity < 0) {
            throw new IllegalArgumentException();
        }
        if (guarded) {
            return new StructPtrImpl<T>(type, capacity, owned).getGuarded(capacity);
        }
        return new StructPtrImpl<T>(type, capacity, owned);
    }

    public static final <T extends StructObject> Ptr<T> newStructReference(Class<T> type) {
        if (type == null) {
            throw new IllegalArgumentException();
        }
        return new StructPtrImpl<T>(type, 1, true);
    }

    public static final <T extends StructObject> Ptr<T> newStructReference(T value) {
        if (value == null) {
            throw new IllegalArgumentException();
        }
        StructPtrImpl ptr = new StructPtrImpl(value.getClass(), 1, true);
        ptr.set(value);
        return ptr;
    }

    public static final <T extends StructObject> Ptr<T> newStructArray(Class<T> type, int capacity) {
        if (type == null || capacity < 0) {
            throw new IllegalArgumentException();
        }
        return new StructPtrImpl<T>(type, capacity, true);
    }

    public static final <T extends StructObject> Ptr<T> newStructArray(int capacity, T value) {
        if (capacity < 0 || value == null) {
            throw new IllegalArgumentException();
        }
        StructPtrImpl pointer = new StructPtrImpl(value.getClass(), capacity, true);
        for (int idx = 0; idx < capacity; ++idx) {
            pointer.set(idx, value);
        }
        return pointer;
    }

    public static final <T extends StructObject> Ptr<T> newStructArray(Class<T> type, T[] buffer) {
        if (type == null || buffer == null) {
            throw new IllegalArgumentException();
        }
        int size = buffer.length;
        StructPtrImpl<T> pointer = new StructPtrImpl<T>(type, size, true);
        pointer.copyFrom(buffer);
        return pointer;
    }

    public static final <T extends StructObject> Ptr<T> newWeakStructReference(Class<T> type) {
        if (type == null) {
            throw new IllegalArgumentException();
        }
        return new StructPtrImpl<T>(type, 1, false);
    }

    public static final <T extends StructObject> Ptr<T> newWeakStructReference(T value) {
        if (value == null) {
            throw new IllegalArgumentException();
        }
        StructPtrImpl ptr = new StructPtrImpl(value.getClass(), 1, false);
        ptr.set(value);
        return ptr;
    }

    public static final <T extends StructObject> Ptr<T> newWeakStructArray(Class<T> type, int capacity) {
        if (type == null || capacity < 0) {
            throw new IllegalArgumentException();
        }
        return new StructPtrImpl<T>(type, capacity, false);
    }

    public static final <T extends StructObject> Ptr<T> newWeakStructArray(int capacity, T value) {
        if (capacity < 0 || value == null) {
            throw new IllegalArgumentException();
        }
        StructPtrImpl pointer = new StructPtrImpl(value.getClass(), capacity, false);
        for (int idx = 0; idx < capacity; ++idx) {
            pointer.set(idx, value);
        }
        return pointer;
    }

    public static final <T extends StructObject> Ptr<T> newWeakStructArray(Class<T> type, T[] buffer) {
        if (type == null || buffer == null) {
            throw new IllegalArgumentException();
        }
        int size = buffer.length;
        StructPtrImpl<T> pointer = new StructPtrImpl<T>(type, size, false);
        pointer.copyFrom(buffer);
        return pointer;
    }

    public static final <T extends StructObject> Ptr<T> newGuardedStructReference(Class<T> type) {
        return (Ptr)PtrFactory.newStructReference(type).getGuarded(1);
    }

    public static final <T extends StructObject> Ptr<T> newGuardedStructReference(T value) {
        return (Ptr)PtrFactory.newStructReference(value).getGuarded(1);
    }

    public static final <T extends StructObject> Ptr<T> newGuardedStructArray(Class<T> type, int capacity) {
        return (Ptr)PtrFactory.newStructArray(type, capacity).getGuarded(capacity);
    }

    public static final <T extends StructObject> Ptr<T> newGuardedStructArray(int capacity, T value) {
        return (Ptr)PtrFactory.newStructArray(capacity, value).getGuarded(capacity);
    }

    public static final <T extends StructObject> Ptr<T> newGuardedStructArray(Class<T> type, T[] buffer) {
        return (Ptr)PtrFactory.newStructArray(type, buffer).getGuarded(buffer.length);
    }

    public static final <T extends StructObject> Ptr<T> newGuardedWeakStructReference(Class<T> type) {
        return (Ptr)PtrFactory.newWeakStructReference(type).getGuarded(1);
    }

    public static final <T extends StructObject> Ptr<T> newGuardedWeakStructReference(T value) {
        return (Ptr)PtrFactory.newWeakStructReference(value).getGuarded(1);
    }

    public static final <T extends StructObject> Ptr<T> newGuardedWeakStructArray(Class<T> type, int capacity) {
        return (Ptr)PtrFactory.newWeakStructArray(type, capacity).getGuarded(capacity);
    }

    public static final <T extends StructObject> Ptr<T> newGuardedWeakStructArray(int capacity, T value) {
        return (Ptr)PtrFactory.newWeakStructArray(capacity, value).getGuarded(capacity);
    }

    public static final <T extends StructObject> Ptr<T> newGuardedWeakStructArray(Class<T> type, T[] buffer) {
        return (Ptr)PtrFactory.newWeakStructArray(type, buffer).getGuarded(buffer.length);
    }

    public static final <T extends OpaquePtr> Ptr<T> newOpaquePtrPtr(Class<T> type, int capacity, boolean owned, boolean guarded) {
        if (type == null || capacity < 0) {
            throw new IllegalArgumentException();
        }
        return PtrFactory.newPointerPtr(type, 2, capacity, owned, guarded);
    }

    public static final <T extends OpaquePtr> Ptr<T> newOpaquePtrReference(Class<T> type) {
        if (type == null) {
            throw new IllegalArgumentException();
        }
        return PtrFactory.newOpaquePtrPtr(type, 1, true, false);
    }

    public static final <T extends OpaquePtr> Ptr<T> newOpaquePtrReference(T value) {
        if (value == null) {
            throw new IllegalArgumentException();
        }
        Ptr<?> ptr = PtrFactory.newOpaquePtrPtr(value.getClass(), 1, true, false);
        ptr.set(value);
        return ptr;
    }

    public static final <T extends OpaquePtr> Ptr<T> newOpaquePtrArray(Class<T> type, int capacity) {
        if (type == null || capacity < 0) {
            throw new IllegalArgumentException();
        }
        return PtrFactory.newOpaquePtrPtr(type, capacity, true, false);
    }

    public static final <T extends OpaquePtr> Ptr<T> newOpaquePtrArray(int capacity, T value) {
        if (capacity < 0 || value == null) {
            throw new IllegalArgumentException();
        }
        Ptr<?> pointer = PtrFactory.newOpaquePtrPtr(value.getClass(), capacity, true, false);
        for (int idx = 0; idx < capacity; ++idx) {
            pointer.set(idx, value);
        }
        return pointer;
    }

    public static final <T extends OpaquePtr> Ptr<T> newOpaquePtrArray(Class<T> type, T[] buffer) {
        if (type == null || buffer == null) {
            throw new IllegalArgumentException();
        }
        int size = buffer.length;
        Ptr<T> pointer = PtrFactory.newOpaquePtrPtr(type, size, true, false);
        pointer.copyFrom(buffer);
        return pointer;
    }

    public static final <T extends OpaquePtr> Ptr<T> newWeakOpaquePtrReference(Class<T> type) {
        if (type == null) {
            throw new IllegalArgumentException();
        }
        return PtrFactory.newOpaquePtrPtr(type, 1, false, false);
    }

    public static final <T extends OpaquePtr> Ptr<T> newWeakOpaquePtrReference(T value) {
        if (value == null) {
            throw new IllegalArgumentException();
        }
        Ptr<?> ptr = PtrFactory.newOpaquePtrPtr(value.getClass(), 1, false, false);
        ptr.set(value);
        return ptr;
    }

    public static final <T extends OpaquePtr> Ptr<T> newWeakOpaquePtrArray(Class<T> type, int capacity) {
        if (type == null || capacity < 0) {
            throw new IllegalArgumentException();
        }
        return PtrFactory.newOpaquePtrPtr(type, capacity, false, false);
    }

    public static final <T extends OpaquePtr> Ptr<T> newWeakOpaquePtrArray(int capacity, T value) {
        if (capacity < 0 || value == null) {
            throw new IllegalArgumentException();
        }
        Ptr<?> pointer = PtrFactory.newOpaquePtrPtr(value.getClass(), capacity, false, false);
        for (int idx = 0; idx < capacity; ++idx) {
            pointer.set(idx, value);
        }
        return pointer;
    }

    public static final <T extends OpaquePtr> Ptr<T> newWeakOpaquePtrArray(Class<T> type, T[] buffer) {
        if (type == null || buffer == null) {
            throw new IllegalArgumentException();
        }
        int size = buffer.length;
        Ptr<T> pointer = PtrFactory.newOpaquePtrPtr(type, size, false, false);
        pointer.copyFrom(buffer);
        return pointer;
    }

    public static final <T extends OpaquePtr> Ptr<T> newGuardedOpaquePtrReference(Class<T> type) {
        return (Ptr)PtrFactory.newOpaquePtrReference(type).getGuarded(1);
    }

    public static final <T extends OpaquePtr> Ptr<T> newGuardedOpaquePtrReference(T value) {
        return (Ptr)PtrFactory.newOpaquePtrReference(value).getGuarded(1);
    }

    public static final <T extends OpaquePtr> Ptr<T> newGuardedOpaquePtrArray(Class<T> type, int capacity) {
        return (Ptr)PtrFactory.newOpaquePtrArray(type, capacity).getGuarded(capacity);
    }

    public static final <T extends OpaquePtr> Ptr<T> newGuardedOpaquePtrArray(int capacity, T value) {
        return (Ptr)PtrFactory.newOpaquePtrArray(capacity, value).getGuarded(capacity);
    }

    public static final <T extends OpaquePtr> Ptr<T> newGuardedOpaquePtrArray(Class<T> type, T[] buffer) {
        return (Ptr)PtrFactory.newOpaquePtrArray(type, buffer).getGuarded(buffer.length);
    }

    public static final <T extends OpaquePtr> Ptr<T> newGuardedWeakOpaquePtrReference(Class<T> type) {
        return (Ptr)PtrFactory.newWeakOpaquePtrReference(type).getGuarded(1);
    }

    public static final <T extends OpaquePtr> Ptr<T> newGuardedWeakOpaquePtrReference(T value) {
        return (Ptr)PtrFactory.newWeakOpaquePtrReference(value).getGuarded(1);
    }

    public static final <T extends OpaquePtr> Ptr<T> newGuardedWeakOpaquePtrArray(Class<T> type, int capacity) {
        return (Ptr)PtrFactory.newWeakOpaquePtrArray(type, capacity).getGuarded(capacity);
    }

    public static final <T extends OpaquePtr> Ptr<T> newGuardedWeakOpaquePtrArray(int capacity, T value) {
        return (Ptr)PtrFactory.newWeakOpaquePtrArray(capacity, value).getGuarded(capacity);
    }

    public static final <T extends OpaquePtr> Ptr<T> newGuardedWeakOpaquePtrArray(Class<T> type, T[] buffer) {
        return (Ptr)PtrFactory.newWeakOpaquePtrArray(type, buffer).getGuarded(buffer.length);
    }

    public static final <T extends ObjCObject> Ptr<T> newObjectPtr(Class<T> type, int capacity, boolean owned, boolean guarded) {
        if (type == null || capacity < 0) {
            throw new IllegalArgumentException();
        }
        if (guarded) {
            return new ObjCObjectPtrImpl<T>(type, capacity, owned).getGuarded(capacity);
        }
        return new ObjCObjectPtrImpl<T>(type, capacity, owned);
    }

    public static final <T extends ObjCObject> Ptr<T> newObjectReference(Class<T> type) {
        if (type == null) {
            throw new IllegalArgumentException();
        }
        return new ObjCObjectPtrImpl<T>(type, 1, true);
    }

    public static final <T extends ObjCObject> Ptr<T> newObjectReference(T value) {
        if (value == null) {
            throw new IllegalArgumentException();
        }
        ObjCObjectPtrImpl ptr = new ObjCObjectPtrImpl(value.getClass(), 1, true);
        ptr.set(value);
        return ptr;
    }

    public static final <T extends ObjCObject> Ptr<T> newObjectArray(Class<T> type, int capacity) {
        if (type == null || capacity < 0) {
            throw new IllegalArgumentException();
        }
        return new ObjCObjectPtrImpl<T>(type, capacity, true);
    }

    public static final <T extends ObjCObject> Ptr<T> newObjectArray(int capacity, T value) {
        if (capacity < 0 || value == null) {
            throw new IllegalArgumentException();
        }
        ObjCObjectPtrImpl pointer = new ObjCObjectPtrImpl(value.getClass(), capacity, true);
        for (int idx = 0; idx < capacity; ++idx) {
            pointer.set(idx, value);
        }
        return pointer;
    }

    public static final <T extends ObjCObject> Ptr<T> newObjectArray(Class<T> type, T[] buffer) {
        if (type == null || buffer == null) {
            throw new IllegalArgumentException();
        }
        int size = buffer.length;
        ObjCObjectPtrImpl<T> pointer = new ObjCObjectPtrImpl<T>(type, size, true);
        pointer.copyFrom(buffer);
        return pointer;
    }

    public static final <T extends ObjCObject> Ptr<T> newWeakObjectReference(Class<T> type) {
        if (type == null) {
            throw new IllegalArgumentException();
        }
        return new ObjCObjectPtrImpl<T>(type, 1, false);
    }

    public static final <T extends ObjCObject> Ptr<T> newWeakObjectReference(T value) {
        if (value == null) {
            throw new IllegalArgumentException();
        }
        ObjCObjectPtrImpl ptr = new ObjCObjectPtrImpl(value.getClass(), 1, false);
        ptr.set(value);
        return ptr;
    }

    public static final <T extends ObjCObject> Ptr<T> newWeakObjectArray(Class<T> type, int capacity) {
        if (type == null || capacity < 0) {
            throw new IllegalArgumentException();
        }
        return new ObjCObjectPtrImpl<T>(type, capacity, false);
    }

    public static final <T extends ObjCObject> Ptr<T> newWeakObjectArray(int capacity, T value) {
        if (capacity < 0 || value == null) {
            throw new IllegalArgumentException();
        }
        ObjCObjectPtrImpl pointer = new ObjCObjectPtrImpl(value.getClass(), capacity, false);
        for (int idx = 0; idx < capacity; ++idx) {
            pointer.set(idx, value);
        }
        return pointer;
    }

    public static final <T extends ObjCObject> Ptr<T> newWeakObjectArray(Class<T> type, T[] buffer) {
        if (type == null || buffer == null) {
            throw new IllegalArgumentException();
        }
        int size = buffer.length;
        ObjCObjectPtrImpl<T> pointer = new ObjCObjectPtrImpl<T>(type, size, false);
        pointer.copyFrom(buffer);
        return pointer;
    }

    public static final <T extends ObjCObject> Ptr<T> newGuardedObjectReference(Class<T> type) {
        return (Ptr)PtrFactory.newObjectReference(type).getGuarded(1);
    }

    public static final <T extends ObjCObject> Ptr<T> newGuardedObjectReference(T value) {
        return (Ptr)PtrFactory.newObjectReference(value).getGuarded(1);
    }

    public static final <T extends ObjCObject> Ptr<T> newGuardedObjectArray(Class<T> type, int capacity) {
        return (Ptr)PtrFactory.newObjectArray(type, capacity).getGuarded(capacity);
    }

    public static final <T extends ObjCObject> Ptr<T> newGuardedObjectArray(int capacity, T value) {
        return (Ptr)PtrFactory.newObjectArray(capacity, value).getGuarded(capacity);
    }

    public static final <T extends ObjCObject> Ptr<T> newGuardedObjectArray(Class<T> type, T[] buffer) {
        return (Ptr)PtrFactory.newObjectArray(type, buffer).getGuarded(buffer.length);
    }

    public static final <T extends ObjCObject> Ptr<T> newGuardedWeakObjectReference(Class<T> type) {
        return (Ptr)PtrFactory.newWeakObjectReference(type).getGuarded(1);
    }

    public static final <T extends ObjCObject> Ptr<T> newGuardedWeakObjectReference(T value) {
        return (Ptr)PtrFactory.newWeakObjectReference(value).getGuarded(1);
    }

    public static final <T extends ObjCObject> Ptr<T> newGuardedWeakObjectArray(Class<T> type, int capacity) {
        return (Ptr)PtrFactory.newWeakObjectArray(type, capacity).getGuarded(capacity);
    }

    public static final <T extends ObjCObject> Ptr<T> newGuardedWeakObjectArray(int capacity, T value) {
        return (Ptr)PtrFactory.newWeakObjectArray(capacity, value).getGuarded(capacity);
    }

    public static final <T extends ObjCObject> Ptr<T> newGuardedWeakObjectArray(Class<T> type, T[] buffer) {
        return (Ptr)PtrFactory.newWeakObjectArray(type, buffer).getGuarded(buffer.length);
    }

    public static final <T extends CxxObject> Ptr<T> newCxxObjectPtr(Class<T> type, int capacity, boolean owned) {
        if (type == null || capacity < 0) {
            throw new IllegalArgumentException();
        }
        return new CxxObjectPtrImpl<T>(type, capacity, owned);
    }

    public static final <T> Ptr<?> newPointerPtr(Class<T> type, int depth, int capacity, boolean owned, boolean guarded) {
        if (type == null || capacity < 0 || depth < 2) {
            throw new IllegalArgumentException();
        }
        if (guarded) {
            return new IndirectPtrImpl(type, depth, capacity, owned).getGuarded(capacity);
        }
        return new IndirectPtrImpl(type, depth, capacity, owned);
    }
}

