/*
 * Decompiled with CFR 0.152.
 */
package org.moe.natj.general.ptr.impl;

import org.moe.natj.c.CRuntime;
import org.moe.natj.general.NatJ;
import org.moe.natj.general.Pointer;
import org.moe.natj.general.ptr.IGuardedPtr;
import org.moe.natj.general.ptr.Ptr;
import org.moe.natj.general.ptr.impl.AbstractNativeObjectPtr;
import org.moe.natj.objc.ObjCObject;
import org.moe.natj.objc.ObjCRuntime;

class ObjCObjectPtrImpl<T extends ObjCObject>
extends AbstractNativeObjectPtr<T> {
    protected static final int ELEM_SIZE = CRuntime.POINTER_SIZE;
    protected Object[] retainList;

    private int computeRetainIndex(int idx) {
        if (this.bufferOwner == null) {
            return idx;
        }
        ObjCObjectPtrImpl root = this;
        while (root.bufferOwner != null) {
            root = (ObjCObjectPtrImpl)root.bufferOwner;
        }
        int offs = (int)((this.getRoot() - root.getRoot()) / (long)ELEM_SIZE);
        return idx + offs;
    }

    protected void refreshRetainList() {
        if (this.retainList != null) {
            int i = 0;
            int n = this.retainList.length;
            for (int idx = this.computeRetainIndex(0); idx < n; ++idx) {
                this.retainList[idx] = this.getJavaValue(this.getPointer(i));
                ++i;
            }
        }
    }

    protected ObjCObjectPtrImpl(Class<T> type, Pointer peer) {
        super(type, NatJ.getOrCreateInstanceOfRuntimeClass(ObjCRuntime.class), peer);
    }

    private ObjCObjectPtrImpl(Class<T> type, long peer, ObjCObjectPtrImpl<T> bufferOwner) {
        super(type, NatJ.getOrCreateInstanceOfRuntimeClass(ObjCRuntime.class), peer, bufferOwner);
        this.retainList = bufferOwner.retainList;
    }

    ObjCObjectPtrImpl(Class<T> type, int capacity, boolean owned) {
        super(type, NatJ.getOrCreateInstanceOfRuntimeClass(ObjCRuntime.class), CRuntime.allocPointer(capacity), owned);
        this.retainList = new Object[capacity];
    }

    private final long getPointer(int idx) {
        return CRuntime.loadPointer(this.getRoot(), idx);
    }

    @Override
    public boolean isConstPtr() {
        return false;
    }

    @Override
    public T get(int idx) {
        if (this.retainList != null) {
            return (T)((ObjCObject)this.retainList[this.computeRetainIndex(idx)]);
        }
        return (T)((ObjCObject)this.getJavaValue(this.getPointer(idx)));
    }

    @Override
    public void set(int idx, T obj) {
        if (this.retainList != null) {
            this.retainList[this.computeRetainIndex((int)idx)] = obj;
        }
        CRuntime.storePointer(this.getRoot(), idx, this.getNativeValue(obj));
    }

    @Override
    public boolean isGuarded() {
        return false;
    }

    @Override
    public Ptr<T> getGuarded(int fromIndex, int toIndex) {
        if (toIndex < fromIndex) {
            throw new IllegalArgumentException();
        }
        return new GuardedObjCObjectPtrImpl(this.type, this.getRoot(), this, fromIndex, toIndex);
    }

    @Override
    public Ptr<T> ofs(int elemOffset) {
        return new ObjCObjectPtrImpl<T>(this.type, this.getRoot() + (long)(elemOffset * ELEM_SIZE), this);
    }

    private static class GuardedConstObjCObjectPtrImpl<T extends ObjCObject>
    extends GuardedObjCObjectPtrImpl<T> {
        public GuardedConstObjCObjectPtrImpl(Class<T> type, long peer, ObjCObjectPtrImpl<T> bufferOwner, int low, int hi) {
            super(type, peer, bufferOwner, low, hi);
        }

        @Override
        public boolean isConstPtr() {
            return true;
        }

        @Override
        public final void set(T value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public final void set(int idx, T value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public final void copyFrom(T[] src) {
            throw new UnsupportedOperationException();
        }

        @Override
        public final void copyFrom(T[] src, int destOffset) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void copyFrom(T[] src, int destOffset, int length) {
            throw new UnsupportedOperationException();
        }

        @Override
        public final void copyFrom(T[] src, int srcOffset, int destOffset, int length) {
            throw new UnsupportedOperationException();
        }

        @Override
        public final Ptr<T> ofs(int elemOffset) {
            return new GuardedConstObjCObjectPtrImpl<T>(this.type, this.getRoot() + (long)(elemOffset * ELEM_SIZE), this, this.low + elemOffset, this.hi + elemOffset);
        }

        @Override
        public Ptr<T> getGuarded(int fromIndex, int toIndex) {
            if (toIndex < fromIndex) {
                throw new IllegalArgumentException();
            }
            return new GuardedConstObjCObjectPtrImpl<T>(this.type, this.getRoot(), this, fromIndex, toIndex);
        }
    }

    private static class GuardedObjCObjectPtrImpl<T extends ObjCObject>
    extends ObjCObjectPtrImpl<T>
    implements IGuardedPtr {
        protected final int low;
        protected final int hi;

        public GuardedObjCObjectPtrImpl(Class<T> type, long peer, ObjCObjectPtrImpl<T> bufferOwner, int low, int hi) {
            super(type, peer, bufferOwner);
            if (low > hi) {
                throw new IllegalArgumentException();
            }
            this.low = low;
            this.hi = hi;
        }

        @Override
        public boolean checkIndex(int index) {
            return index >= this.low && index < this.hi;
        }

        @Override
        public boolean isGuarded() {
            return true;
        }

        @Override
        public T get(int idx) {
            if (!this.checkIndex(idx)) {
                throw new IndexOutOfBoundsException();
            }
            return (T)super.get(idx);
        }

        @Override
        public void copyTo(int srcOffset, T[] dest, int destOffset, int length) {
            if (!this.checkIndex(srcOffset) || !this.checkIndex(srcOffset + length)) {
                throw new IndexOutOfBoundsException();
            }
            super.copyTo(srcOffset, (E[])dest, destOffset, length);
        }

        @Override
        public void set(int idx, T value) {
            if (!this.checkIndex(idx)) {
                throw new IndexOutOfBoundsException();
            }
            super.set(idx, value);
        }

        @Override
        public void copyFrom(T[] src, int srcOffset, int destOffset, int length) {
            if (!this.checkIndex(destOffset) || !this.checkIndex(destOffset + length)) {
                throw new IndexOutOfBoundsException();
            }
            super.copyFrom((E[])src, srcOffset, destOffset, length);
        }

        @Override
        public Ptr<T> ofs(int elemOffset) {
            return new GuardedObjCObjectPtrImpl<T>(this.type, this.getRoot() + (long)(elemOffset * ELEM_SIZE), this, this.low + elemOffset, this.hi + elemOffset);
        }

        @Override
        public Ptr<T> getGuarded(int fromIndex, int toIndex) {
            if (toIndex < fromIndex) {
                throw new IllegalArgumentException();
            }
            return new GuardedObjCObjectPtrImpl<T>(this.type, this.getRoot(), this, fromIndex, toIndex);
        }

        @Override
        public int getGuardLow() {
            return this.low;
        }

        @Override
        public int getGuardHigh() {
            return this.hi;
        }
    }

    static class ConstObjCObjectPtrImpl<T extends ObjCObject>
    extends ObjCObjectPtrImpl<T> {
        protected ConstObjCObjectPtrImpl(Class<T> type, Pointer peer) {
            super(type, peer);
        }

        private ConstObjCObjectPtrImpl(Class<T> type, long peer, ObjCObjectPtrImpl<T> bufferOwner) {
            super(type, peer, bufferOwner);
        }

        ConstObjCObjectPtrImpl(Class<T> type, int capacity, boolean owned) {
            super(type, capacity, owned);
        }

        @Override
        public boolean isConstPtr() {
            return true;
        }

        @Override
        public final void set(T value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public final void set(int idx, T value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public final void copyFrom(T[] src) {
            throw new UnsupportedOperationException();
        }

        @Override
        public final void copyFrom(T[] src, int destOffset) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void copyFrom(T[] src, int destOffset, int length) {
            throw new UnsupportedOperationException();
        }

        @Override
        public final void copyFrom(T[] src, int srcOffset, int destOffset, int length) {
            throw new UnsupportedOperationException();
        }

        @Override
        public final Ptr<T> ofs(int elemOffset) {
            return new ConstObjCObjectPtrImpl<T>(this.type, this.getRoot() + (long)(elemOffset * ELEM_SIZE), this);
        }

        @Override
        public Ptr<T> getGuarded(int fromIndex, int toIndex) {
            if (toIndex < fromIndex) {
                throw new IllegalArgumentException();
            }
            return new GuardedConstObjCObjectPtrImpl(this.type, this.getRoot(), this, fromIndex, toIndex);
        }
    }
}

