/*
 * Decompiled with CFR 0.152.
 */
package org.moe.natj.general.ptr.impl;

import org.moe.natj.c.CRuntime;
import org.moe.natj.general.Pointer;
import org.moe.natj.general.ptr.IGuardedPtr;
import org.moe.natj.general.ptr.LongPtr;
import org.moe.natj.general.ptr.impl.VoidPtrImpl;

class LongPtrImpl
extends VoidPtrImpl
implements LongPtr {
    protected static final int ELEM_SIZE = 8;

    protected LongPtrImpl(Pointer peer) {
        super(peer);
    }

    protected LongPtrImpl(long peer, Object bufferOwner) {
        super(peer, false, bufferOwner);
    }

    LongPtrImpl(int capacity, boolean owned) {
        super(CRuntime.allocLong(capacity), owned, null);
    }

    @Override
    public boolean isConstPtr() {
        return false;
    }

    @Override
    public final Long get() {
        return this.getValue(0);
    }

    @Override
    public final Long get(int idx) {
        return this.getValue(idx);
    }

    @Override
    public final long getValue() {
        return this.getValue(0);
    }

    @Override
    public long getValue(int idx) {
        return CRuntime.loadLong(this.getRoot(), idx);
    }

    public final Long[] toArray(int length) {
        return this.toArray(0, length);
    }

    public Long[] toArray(int fromIndex, int toIndex) {
        if (toIndex < fromIndex) {
            throw new IllegalArgumentException();
        }
        int length = toIndex - fromIndex;
        Long[] array = new Long[length];
        this.copyTo(fromIndex, array, 0, length);
        return array;
    }

    @Override
    public final long[] toLongArray(int length) {
        return this.toLongArray(0, length);
    }

    @Override
    public long[] toLongArray(int fromIndex, int toIndex) {
        if (toIndex < fromIndex) {
            throw new IllegalArgumentException();
        }
        return CRuntime.createLongArray(this.getRoot() + (long)(fromIndex * 8), toIndex - fromIndex);
    }

    public final void copyTo(Long[] dest) {
        if (dest == null) {
            throw new IllegalArgumentException();
        }
        this.copyTo(0, dest, 0, dest.length);
    }

    public final void copyTo(Long[] dest, int length) {
        if (dest == null) {
            throw new IllegalArgumentException();
        }
        this.copyTo(0, dest, 0, length);
    }

    public void copyTo(int srcOffset, Long[] dest, int destOffset, int length) {
        if (dest == null || destOffset < 0 || length < 0 || destOffset + length > dest.length) {
            throw new IllegalArgumentException();
        }
        long root = this.getRoot();
        int idx = 0;
        while (idx < length) {
            dest[destOffset] = CRuntime.loadLong(root, srcOffset);
            ++idx;
            ++srcOffset;
            ++destOffset;
        }
    }

    @Override
    public final void copyTo(long[] dest) {
        if (dest == null) {
            throw new IllegalArgumentException();
        }
        this.copyTo(0, dest, 0, dest.length);
    }

    @Override
    public final void copyTo(long[] dest, int length) {
        if (dest == null) {
            throw new IllegalArgumentException();
        }
        this.copyTo(0, dest, 0, length);
    }

    @Override
    public void copyTo(int srcOffset, long[] dest, int destOffset, int length) {
        if (dest == null || destOffset < 0 || length < 0 || destOffset + length > dest.length) {
            throw new IllegalArgumentException();
        }
        CRuntime.copyFromNativeLongArray(dest, destOffset, this.getRoot(), srcOffset, length);
    }

    @Override
    public void set(Long obj) {
        this.setValue(obj);
    }

    @Override
    public void set(int idx, Long obj) {
        this.setValue(idx, obj);
    }

    @Override
    public void setValue(long value) {
        this.setValue(0, value);
    }

    @Override
    public void setValue(int idx, long value) {
        CRuntime.storeLong(this.getRoot(), idx, value);
    }

    public void copyFrom(Long[] src) {
        if (src == null) {
            throw new IllegalArgumentException();
        }
        this.copyFrom(src, 0, 0, src.length);
    }

    public void copyFrom(Long[] src, int destOffset) {
        if (src == null) {
            throw new IllegalArgumentException();
        }
        this.copyFrom(src, 0, destOffset, src.length);
    }

    public void copyFrom(Long[] src, int destOffset, int length) {
        if (src == null) {
            throw new IllegalArgumentException();
        }
        this.copyFrom(src, 0, destOffset, length);
    }

    public void copyFrom(Long[] src, int srcOffset, int destOffset, int length) {
        if (src == null || srcOffset < 0 || length < 0 || srcOffset + length > src.length) {
            throw new IllegalArgumentException();
        }
        long root = this.getRoot();
        int i = 0;
        while (i < length) {
            CRuntime.storeLong(root, destOffset, src[srcOffset]);
            ++i;
            ++srcOffset;
            ++destOffset;
        }
    }

    @Override
    public void copyFrom(long[] src) {
        if (src == null) {
            throw new IllegalArgumentException();
        }
        this.copyFrom(src, 0, 0, src.length);
    }

    @Override
    public void copyFrom(long[] src, int destOffset) {
        if (src == null) {
            throw new IllegalArgumentException();
        }
        this.copyFrom(src, 0, destOffset, src.length);
    }

    @Override
    public void copyFrom(long[] src, int destOffset, int length) {
        if (src == null) {
            throw new IllegalArgumentException();
        }
        this.copyFrom(src, 0, destOffset, length);
    }

    @Override
    public void copyFrom(long[] src, int srcOffset, int destOffset, int length) {
        if (src == null || srcOffset < 0 || length < 0 || srcOffset + length > src.length) {
            throw new IllegalArgumentException();
        }
        CRuntime.copyLongArray(this.getRoot(), destOffset, src, srcOffset, length);
    }

    @Override
    public LongPtr ofs(int elemOffset) {
        return new LongPtrImpl(this.getRoot() + (long)(elemOffset * 8), this);
    }

    @Override
    public boolean isGuarded() {
        return false;
    }

    @Override
    public final LongPtr getGuarded(int length) {
        return this.getGuarded(0, length);
    }

    @Override
    public LongPtr getGuarded(int fromIndex, int toIndex) {
        if (toIndex < fromIndex) {
            throw new IllegalArgumentException();
        }
        return new GuardedLongPtrImpl(this.getRoot(), this, fromIndex, toIndex);
    }

    @Override
    public int getGuardLow() {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getGuardHigh() {
        throw new UnsupportedOperationException();
    }

    private static class GuardedConstLongPtrImpl
    extends GuardedLongPtrImpl {
        public GuardedConstLongPtrImpl(long peer, Object bufferOwner, int low, int hi) {
            super(peer, bufferOwner, low, hi);
        }

        @Override
        public boolean isConstPtr() {
            return true;
        }

        @Override
        public void set(Long obj) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void set(int idx, Long obj) {
            throw new UnsupportedOperationException();
        }

        @Override
        public final void setValue(long value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public final void setValue(int idx, long value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public final void copyFrom(Long[] src) {
            throw new UnsupportedOperationException();
        }

        @Override
        public final void copyFrom(Long[] src, int destOffset) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void copyFrom(Long[] src, int destOffset, int length) {
            throw new UnsupportedOperationException();
        }

        @Override
        public final void copyFrom(Long[] src, int srcOffset, int destOffset, int length) {
            throw new UnsupportedOperationException();
        }

        @Override
        public final void copyFrom(long[] src) {
            throw new UnsupportedOperationException();
        }

        @Override
        public final void copyFrom(long[] src, int destOffset) {
            throw new UnsupportedOperationException();
        }

        @Override
        public final void copyFrom(long[] src, int srcOffset, int destOffset) {
            throw new UnsupportedOperationException();
        }

        @Override
        public final void copyFrom(long[] src, int srcOffset, int destOffset, int length) {
            throw new UnsupportedOperationException();
        }

        @Override
        public final LongPtr ofs(int elemOffset) {
            return new GuardedConstLongPtrImpl(this.getRoot() + (long)(elemOffset * 8), this, this.low + elemOffset, this.hi + elemOffset);
        }

        @Override
        public LongPtr getGuarded(int fromIndex, int toIndex) {
            if (toIndex < fromIndex) {
                throw new IllegalArgumentException();
            }
            return new GuardedConstLongPtrImpl(this.getRoot(), this, fromIndex, toIndex);
        }
    }

    private static class GuardedLongPtrImpl
    extends LongPtrImpl
    implements IGuardedPtr {
        protected final int low;
        protected final int hi;

        public GuardedLongPtrImpl(long peer, Object bufferOwner, int low, int hi) {
            super(peer, bufferOwner);
            if (low > hi) {
                throw new IllegalArgumentException();
            }
            this.low = low;
            this.hi = hi;
        }

        @Override
        public boolean checkIndex(int index) {
            return index >= this.low && index < this.hi;
        }

        @Override
        public boolean isGuarded() {
            return true;
        }

        @Override
        public long getValue(int idx) {
            if (!this.checkIndex(idx)) {
                throw new IndexOutOfBoundsException();
            }
            return super.get(idx);
        }

        @Override
        public Long[] toArray(int fromIndex, int toIndex) {
            if (!this.checkIndex(fromIndex) || !this.checkIndex(toIndex)) {
                throw new IndexOutOfBoundsException();
            }
            return super.toArray(fromIndex, toIndex);
        }

        @Override
        public long[] toLongArray(int fromIndex, int toIndex) {
            if (!this.checkIndex(fromIndex) || !this.checkIndex(toIndex)) {
                throw new IndexOutOfBoundsException();
            }
            return super.toLongArray(fromIndex, toIndex);
        }

        @Override
        public void copyTo(int srcOffset, Long[] dest, int destOffset, int length) {
            if (!this.checkIndex(srcOffset) || !this.checkIndex(srcOffset + length)) {
                throw new IndexOutOfBoundsException();
            }
            super.copyTo(srcOffset, dest, destOffset, length);
        }

        @Override
        public void copyTo(int srcOffset, long[] dest, int destOffset, int length) {
            if (!this.checkIndex(srcOffset) || !this.checkIndex(srcOffset + length)) {
                throw new IndexOutOfBoundsException();
            }
            super.copyTo(srcOffset, dest, destOffset, length);
        }

        @Override
        public void setValue(int idx, long value) {
            if (!this.checkIndex(idx)) {
                throw new IndexOutOfBoundsException();
            }
            super.set(idx, value);
        }

        @Override
        public void copyFrom(Long[] src, int srcOffset, int destOffset, int length) {
            if (!this.checkIndex(destOffset) || !this.checkIndex(destOffset + length)) {
                throw new IndexOutOfBoundsException();
            }
            super.copyFrom(src, srcOffset, destOffset, length);
        }

        @Override
        public void copyFrom(long[] src, int srcOffset, int destOffset, int length) {
            if (!this.checkIndex(destOffset) || !this.checkIndex(destOffset + length)) {
                throw new IndexOutOfBoundsException();
            }
            super.copyFrom(src, srcOffset, destOffset, length);
        }

        @Override
        public LongPtr ofs(int elemOffset) {
            return new GuardedLongPtrImpl(this.getRoot() + (long)(elemOffset * 8), this, this.low + elemOffset, this.hi + elemOffset);
        }

        @Override
        public LongPtr getGuarded(int fromIndex, int toIndex) {
            if (toIndex < fromIndex) {
                throw new IllegalArgumentException();
            }
            return new GuardedLongPtrImpl(this.getRoot(), this, fromIndex, toIndex);
        }

        @Override
        public int getGuardLow() {
            return this.low;
        }

        @Override
        public int getGuardHigh() {
            return this.hi;
        }
    }

    static class ConstLongPtrImpl
    extends LongPtrImpl {
        protected ConstLongPtrImpl(Pointer peer) {
            super(peer);
        }

        protected ConstLongPtrImpl(long peer, Object bufferOwner) {
            super(peer, bufferOwner);
        }

        ConstLongPtrImpl(int capacity, boolean owned) {
            super(capacity, owned);
        }

        @Override
        public boolean isConstPtr() {
            return true;
        }

        @Override
        public void set(Long obj) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void set(int idx, Long obj) {
            throw new UnsupportedOperationException();
        }

        @Override
        public final void setValue(long value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public final void setValue(int idx, long value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public final void copyFrom(Long[] src) {
            throw new UnsupportedOperationException();
        }

        @Override
        public final void copyFrom(Long[] src, int destOffset) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void copyFrom(Long[] src, int destOffset, int length) {
            throw new UnsupportedOperationException();
        }

        @Override
        public final void copyFrom(Long[] src, int srcOffset, int destOffset, int length) {
            throw new UnsupportedOperationException();
        }

        @Override
        public final void copyFrom(long[] src) {
            throw new UnsupportedOperationException();
        }

        @Override
        public final void copyFrom(long[] src, int destOffset) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void copyFrom(long[] src, int destOffset, int length) {
            throw new UnsupportedOperationException();
        }

        @Override
        public final void copyFrom(long[] src, int srcOffset, int destOffset, int length) {
            throw new UnsupportedOperationException();
        }

        @Override
        public final LongPtr ofs(int elemOffset) {
            return new ConstLongPtrImpl(this.getRoot() + (long)(elemOffset * 8), this);
        }

        @Override
        public LongPtr getGuarded(int fromIndex, int toIndex) {
            if (toIndex < fromIndex) {
                throw new IllegalArgumentException();
            }
            return new GuardedConstLongPtrImpl(this.getRoot(), this, fromIndex, toIndex);
        }
    }
}

