/*
 * Decompiled with CFR 0.152.
 */
package org.moe.natj.general.ptr.impl;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.concurrent.ConcurrentHashMap;
import org.moe.natj.cxx.CxxObject;
import org.moe.natj.cxx.CxxRuntime;
import org.moe.natj.general.Pointer;
import org.moe.natj.general.ptr.IGuardedPtr;
import org.moe.natj.general.ptr.Ptr;
import org.moe.natj.general.ptr.impl.AbstractTypedPtr;

class CxxObjectPtrImpl<T extends CxxObject>
extends AbstractTypedPtr<T, T> {
    private static final ConcurrentHashMap<Class<?>, Method> CREATE_METHODS = new ConcurrentHashMap();
    private static final ConcurrentHashMap<Class<?>, Method> DELETE_METHODS = new ConcurrentHashMap();
    private static final ConcurrentHashMap<Class<?>, Method> GETTER_METHODS = new ConcurrentHashMap();
    private static final ConcurrentHashMap<Class<?>, Method> SETTER_METHODS = new ConcurrentHashMap();
    private Method getter;
    private Method setter;
    protected final long sizeof;

    protected CxxObjectPtrImpl(Class<T> type, Pointer peer) {
        super(CxxObjectPtrImpl.initMethods(type), peer);
        this.sizeof = CxxRuntime.sizeof(type);
        this.getter = GETTER_METHODS.get(type);
        this.setter = SETTER_METHODS.get(type);
    }

    private CxxObjectPtrImpl(Class<T> type, long peer, Object bufferOwner) {
        super(CxxObjectPtrImpl.initMethods(type), peer, bufferOwner);
        this.sizeof = CxxRuntime.sizeof(type);
        this.getter = GETTER_METHODS.get(type);
        this.setter = SETTER_METHODS.get(type);
    }

    CxxObjectPtrImpl(Class<T> type, int capacity, boolean owned) {
        super(type, CxxObjectPtrImpl.createPointer(CxxObjectPtrImpl.initMethods(type), capacity, owned));
        this.sizeof = CxxRuntime.sizeof(type);
        this.getter = GETTER_METHODS.get(type);
        this.setter = SETTER_METHODS.get(type);
    }

    private static <T extends CxxObject> Pointer createPointer(Class<T> type, int capacity, boolean owned) {
        Long peer;
        Method create = CREATE_METHODS.get(type);
        Method delete = DELETE_METHODS.get(type);
        if (create == null || delete == null) {
            throw new UnsupportedOperationException();
        }
        try {
            peer = (Long)create.invoke(null, capacity);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            if (e.getCause() instanceof UnsupportedOperationException) {
                throw (UnsupportedOperationException)e.getCause();
            }
            throw new RuntimeException(e);
        }
        if (owned) {
            return new Pointer(peer, new CxxObjectReleaser(delete));
        }
        return new Pointer(peer);
    }

    private static <T extends CxxObject> Class<T> initMethods(Class<T> type) {
        Method setter;
        Method getter;
        Method delete;
        Class<T> impl = CxxRuntime.getImplClass(type);
        Method create = CREATE_METHODS.get(type);
        if (create == null && (create = CxxRuntime.getPtrNewMethod(impl)) != null) {
            CREATE_METHODS.putIfAbsent(type, create);
        }
        if ((delete = DELETE_METHODS.get(type)) == null && (delete = CxxRuntime.getPtrDeleteMethod(impl)) != null) {
            DELETE_METHODS.putIfAbsent(type, delete);
        }
        if ((getter = GETTER_METHODS.get(type)) == null && (getter = CxxRuntime.getPtrGetMethod(impl)) != null) {
            GETTER_METHODS.putIfAbsent(type, getter);
        }
        if ((setter = SETTER_METHODS.get(type)) == null && (setter = CxxRuntime.getPtrSetMethod(impl)) != null) {
            SETTER_METHODS.putIfAbsent(type, setter);
        }
        return type;
    }

    @Override
    public boolean isConstPtr() {
        return false;
    }

    @Override
    public T get(int idx) {
        long ptr;
        if (this.getter == null) {
            throw new UnsupportedOperationException();
        }
        try {
            ptr = (Long)this.getter.invoke(null, this.getRoot(), idx);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            if (e.getCause() instanceof UnsupportedOperationException) {
                throw (UnsupportedOperationException)e.getCause();
            }
            throw new RuntimeException(e);
        }
        Class implClass = CxxRuntime.getImplClass(this.type);
        if (ptr == 0L) {
            return null;
        }
        CxxObject t = CxxRuntime.get(ptr);
        if (t != null && implClass.isAssignableFrom(t.getClass())) {
            return (T)t;
        }
        return CxxRuntime.construct(ptr, implClass);
    }

    final T getRef(int idx) {
        long ptr = this.getRoot() + (long)idx * this.sizeof;
        Class implClass = CxxRuntime.getImplClass(this.type);
        CxxObject t = CxxRuntime.get(ptr);
        if (t != null && implClass.isAssignableFrom(t.getClass())) {
            return (T)t;
        }
        return CxxRuntime.construct(ptr, implClass);
    }

    @Override
    public void set(int idx, T obj) {
        if (this.setter == null) {
            throw new UnsupportedOperationException();
        }
        if (obj == null) {
            throw new NullPointerException();
        }
        try {
            this.setter.invoke(null, this.getRoot(), idx, obj._cxx_rt_peer());
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            if (e.getCause() instanceof UnsupportedOperationException) {
                throw (UnsupportedOperationException)e.getCause();
            }
            throw new RuntimeException(e);
        }
    }

    @Override
    public boolean isGuarded() {
        return false;
    }

    @Override
    public Ptr<T> getGuarded(int fromIndex, int toIndex) {
        if (toIndex < fromIndex) {
            throw new IllegalArgumentException();
        }
        return new GuardedCxxObjectPtrImpl(this.type, this.getRoot(), this, fromIndex, toIndex);
    }

    @Override
    public Ptr<T> ofs(int elemOffset) {
        return new CxxObjectPtrImpl<T>(this.type, this.getRoot() + (long)elemOffset * this.sizeof, (Object)this);
    }

    public void invokeDeletePointer() {
        Method delete = DELETE_METHODS.get(this.type);
        if (delete == null) {
            throw new UnsupportedOperationException();
        }
        try {
            delete.invoke(null, this.getRoot());
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            if (e.getCause() instanceof UnsupportedOperationException) {
                throw (UnsupportedOperationException)e.getCause();
            }
            throw new RuntimeException(e);
        }
    }

    private static class CxxObjectReleaser
    implements Pointer.Releaser {
        private final Method delete;

        public CxxObjectReleaser(Method delete) {
            this.delete = delete;
        }

        @Override
        public void release(long peer) {
            try {
                this.delete.invoke(null, peer);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
            catch (InvocationTargetException e) {
                if (e.getCause() instanceof UnsupportedOperationException) {
                    throw (UnsupportedOperationException)e.getCause();
                }
                throw new RuntimeException(e);
            }
        }

        @Override
        public boolean ifFinalizedExternally() {
            return false;
        }
    }

    private static class GuardedConstCxxObjectPtrImpl<T extends CxxObject>
    extends GuardedCxxObjectPtrImpl<T> {
        public GuardedConstCxxObjectPtrImpl(Class<T> type, long peer, Object bufferOwner, int low, int hi) {
            super(type, peer, bufferOwner, low, hi);
        }

        @Override
        public boolean isConstPtr() {
            return true;
        }

        @Override
        public final void set(T value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public final void set(int idx, T value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public final void copyFrom(T[] src) {
            throw new UnsupportedOperationException();
        }

        @Override
        public final void copyFrom(T[] src, int destOffset) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void copyFrom(T[] src, int destOffset, int length) {
            throw new UnsupportedOperationException();
        }

        @Override
        public final void copyFrom(T[] src, int srcOffset, int destOffset, int length) {
            throw new UnsupportedOperationException();
        }

        @Override
        public final Ptr<T> ofs(int elemOffset) {
            return new GuardedConstCxxObjectPtrImpl<T>(this.type, this.getRoot() + (long)elemOffset * this.sizeof, this, this.low + elemOffset, this.hi + elemOffset);
        }

        @Override
        public Ptr<T> getGuarded(int fromIndex, int toIndex) {
            if (toIndex < fromIndex) {
                throw new IllegalArgumentException();
            }
            return new GuardedConstCxxObjectPtrImpl<T>(this.type, this.getRoot(), this, fromIndex, toIndex);
        }
    }

    private static class GuardedCxxObjectPtrImpl<T extends CxxObject>
    extends CxxObjectPtrImpl<T>
    implements IGuardedPtr {
        protected final int low;
        protected final int hi;

        public GuardedCxxObjectPtrImpl(Class<T> type, long peer, Object bufferOwner, int low, int hi) {
            super(type, peer, bufferOwner);
            if (low > hi) {
                throw new IllegalArgumentException();
            }
            this.low = low;
            this.hi = hi;
        }

        @Override
        public boolean checkIndex(int index) {
            return index >= this.low && index < this.hi;
        }

        @Override
        public boolean isGuarded() {
            return true;
        }

        @Override
        public T get(int idx) {
            if (!this.checkIndex(idx)) {
                throw new IndexOutOfBoundsException();
            }
            return (T)super.get(idx);
        }

        @Override
        public void copyTo(int srcOffset, T[] dest, int destOffset, int length) {
            if (!this.checkIndex(srcOffset) || !this.checkIndex(srcOffset + length)) {
                throw new IndexOutOfBoundsException();
            }
            super.copyTo(srcOffset, (E[])dest, destOffset, length);
        }

        @Override
        public void set(int idx, T value) {
            if (!this.checkIndex(idx)) {
                throw new IndexOutOfBoundsException();
            }
            super.set(idx, value);
        }

        @Override
        public void copyFrom(T[] src, int srcOffset, int destOffset, int length) {
            if (!this.checkIndex(destOffset) || !this.checkIndex(destOffset + length)) {
                throw new IndexOutOfBoundsException();
            }
            super.copyFrom((E[])src, srcOffset, destOffset, length);
        }

        @Override
        public Ptr<T> ofs(int elemOffset) {
            return new GuardedCxxObjectPtrImpl<T>(this.type, this.getRoot() + (long)elemOffset * this.sizeof, this, this.low + elemOffset, this.hi + elemOffset);
        }

        @Override
        public Ptr<T> getGuarded(int fromIndex, int toIndex) {
            if (toIndex < fromIndex) {
                throw new IllegalArgumentException();
            }
            return new GuardedCxxObjectPtrImpl<T>(this.type, this.getRoot(), this, fromIndex, toIndex);
        }

        @Override
        public int getGuardLow() {
            return this.low;
        }

        @Override
        public int getGuardHigh() {
            return this.hi;
        }
    }

    static class ConstCxxObjectPtrImpl<T extends CxxObject>
    extends CxxObjectPtrImpl<T> {
        protected ConstCxxObjectPtrImpl(Class<T> type, Pointer peer) {
            super(type, peer);
        }

        private ConstCxxObjectPtrImpl(Class<T> type, long peer, Object bufferOwner) {
            super(type, peer, bufferOwner);
        }

        ConstCxxObjectPtrImpl(Class<T> type, int capacity, boolean owned) {
            super(type, capacity, owned);
        }

        @Override
        public boolean isConstPtr() {
            return true;
        }

        @Override
        public final void set(T value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public final void set(int idx, T value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public final void copyFrom(T[] src) {
            throw new UnsupportedOperationException();
        }

        @Override
        public final void copyFrom(T[] src, int destOffset) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void copyFrom(T[] src, int destOffset, int length) {
            throw new UnsupportedOperationException();
        }

        @Override
        public final void copyFrom(T[] src, int srcOffset, int destOffset, int length) {
            throw new UnsupportedOperationException();
        }

        @Override
        public final Ptr<T> ofs(int elemOffset) {
            return new ConstCxxObjectPtrImpl<T>(this.type, this.getRoot() + (long)elemOffset * this.sizeof, (Object)this);
        }

        @Override
        public Ptr<T> getGuarded(int fromIndex, int toIndex) {
            if (toIndex < fromIndex) {
                throw new IllegalArgumentException();
            }
            return new GuardedConstCxxObjectPtrImpl(this.type, this.getRoot(), this, fromIndex, toIndex);
        }
    }
}

