/*
 * Decompiled with CFR 0.152.
 */
package org.moe.natj.general.ptr.impl;

import org.moe.natj.c.CRuntime;
import org.moe.natj.general.Pointer;
import org.moe.natj.general.ptr.CharPtr;
import org.moe.natj.general.ptr.IGuardedPtr;
import org.moe.natj.general.ptr.impl.VoidPtrImpl;

class CharPtrImpl
extends VoidPtrImpl
implements CharPtr {
    protected static final int ELEM_SIZE = 2;

    protected CharPtrImpl(Pointer peer) {
        super(peer);
    }

    protected CharPtrImpl(long peer, Object bufferOwner) {
        super(peer, false, bufferOwner);
    }

    CharPtrImpl(int capacity, boolean owned) {
        super(CRuntime.allocChar(capacity), owned, null);
    }

    @Override
    public boolean isConstPtr() {
        return false;
    }

    @Override
    public final Character get() {
        return Character.valueOf(this.getValue(0));
    }

    @Override
    public final Character get(int idx) {
        return Character.valueOf(this.getValue(idx));
    }

    @Override
    public final char getValue() {
        return this.getValue(0);
    }

    @Override
    public char getValue(int idx) {
        return CRuntime.loadChar(this.getRoot(), idx);
    }

    public final Character[] toArray(int length) {
        return this.toArray(0, length);
    }

    public Character[] toArray(int fromIndex, int toIndex) {
        if (toIndex < fromIndex) {
            throw new IllegalArgumentException();
        }
        int length = toIndex - fromIndex;
        Character[] array = new Character[length];
        this.copyTo(fromIndex, array, 0, length);
        return array;
    }

    @Override
    public final char[] toCharArray(int length) {
        return this.toCharArray(0, length);
    }

    @Override
    public char[] toCharArray(int fromIndex, int toIndex) {
        if (toIndex < fromIndex) {
            throw new IllegalArgumentException();
        }
        return CRuntime.createCharArray(this.getRoot() + (long)(fromIndex * 2), toIndex - fromIndex);
    }

    public final void copyTo(Character[] dest) {
        if (dest == null) {
            throw new IllegalArgumentException();
        }
        this.copyTo(0, dest, 0, dest.length);
    }

    public final void copyTo(Character[] dest, int length) {
        if (dest == null) {
            throw new IllegalArgumentException();
        }
        this.copyTo(0, dest, 0, length);
    }

    public void copyTo(int srcOffset, Character[] dest, int destOffset, int length) {
        if (dest == null || destOffset < 0 || length < 0 || destOffset + length > dest.length) {
            throw new IllegalArgumentException();
        }
        long root = this.getRoot();
        int idx = 0;
        while (idx < length) {
            dest[destOffset] = Character.valueOf(CRuntime.loadChar(root, srcOffset));
            ++idx;
            ++srcOffset;
            ++destOffset;
        }
    }

    @Override
    public final void copyTo(char[] dest) {
        if (dest == null) {
            throw new IllegalArgumentException();
        }
        this.copyTo(0, dest, 0, dest.length);
    }

    @Override
    public final void copyTo(char[] dest, int length) {
        if (dest == null) {
            throw new IllegalArgumentException();
        }
        this.copyTo(0, dest, 0, length);
    }

    @Override
    public void copyTo(int srcOffset, char[] dest, int destOffset, int length) {
        if (dest == null || destOffset < 0 || length < 0 || destOffset + length > dest.length) {
            throw new IllegalArgumentException();
        }
        CRuntime.copyFromNativeCharArray(dest, destOffset, this.getRoot(), srcOffset, length);
    }

    @Override
    public void set(Character obj) {
        this.setValue(obj.charValue());
    }

    @Override
    public void set(int idx, Character obj) {
        this.setValue(idx, obj.charValue());
    }

    @Override
    public void setValue(char value) {
        this.setValue(0, value);
    }

    @Override
    public void setValue(int idx, char value) {
        CRuntime.storeChar(this.getRoot(), idx, value);
    }

    public void copyFrom(Character[] src) {
        if (src == null) {
            throw new IllegalArgumentException();
        }
        this.copyFrom(src, 0, 0, src.length);
    }

    public void copyFrom(Character[] src, int destOffset) {
        if (src == null) {
            throw new IllegalArgumentException();
        }
        this.copyFrom(src, 0, destOffset, src.length);
    }

    public void copyFrom(Character[] src, int destOffset, int length) {
        if (src == null) {
            throw new IllegalArgumentException();
        }
        this.copyFrom(src, 0, destOffset, length);
    }

    public void copyFrom(Character[] src, int srcOffset, int destOffset, int length) {
        if (src == null || srcOffset < 0 || length < 0 || srcOffset + length > src.length) {
            throw new IllegalArgumentException();
        }
        long root = this.getRoot();
        int i = 0;
        while (i < length) {
            CRuntime.storeChar(root, destOffset, src[srcOffset].charValue());
            ++i;
            ++srcOffset;
            ++destOffset;
        }
    }

    @Override
    public void copyFrom(char[] src) {
        if (src == null) {
            throw new IllegalArgumentException();
        }
        this.copyFrom(src, 0, 0, src.length);
    }

    @Override
    public void copyFrom(char[] src, int destOffset) {
        if (src == null) {
            throw new IllegalArgumentException();
        }
        this.copyFrom(src, 0, destOffset, src.length);
    }

    @Override
    public void copyFrom(char[] src, int destOffset, int length) {
        if (src == null) {
            throw new IllegalArgumentException();
        }
        this.copyFrom(src, 0, destOffset, length);
    }

    @Override
    public void copyFrom(char[] src, int srcOffset, int destOffset, int length) {
        if (src == null || srcOffset < 0 || length < 0 || srcOffset + length > src.length) {
            throw new IllegalArgumentException();
        }
        CRuntime.copyCharArray(this.getRoot(), destOffset, src, srcOffset, length);
    }

    @Override
    public CharPtr ofs(int elemOffset) {
        return new CharPtrImpl(this.getRoot() + (long)(elemOffset * 2), this);
    }

    @Override
    public boolean isGuarded() {
        return false;
    }

    @Override
    public final CharPtr getGuarded(int length) {
        return this.getGuarded(0, length);
    }

    @Override
    public CharPtr getGuarded(int fromIndex, int toIndex) {
        if (toIndex < fromIndex) {
            throw new IllegalArgumentException();
        }
        return new GuardedCharPtrImpl(this.getRoot(), this, fromIndex, toIndex);
    }

    @Override
    public int getGuardLow() {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getGuardHigh() {
        throw new UnsupportedOperationException();
    }

    private static class GuardedConstCharPtrImpl
    extends GuardedCharPtrImpl {
        public GuardedConstCharPtrImpl(long peer, Object bufferOwner, int low, int hi) {
            super(peer, bufferOwner, low, hi);
        }

        @Override
        public boolean isConstPtr() {
            return true;
        }

        @Override
        public void set(Character obj) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void set(int idx, Character obj) {
            throw new UnsupportedOperationException();
        }

        @Override
        public final void setValue(char value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public final void setValue(int idx, char value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public final void copyFrom(Character[] src) {
            throw new UnsupportedOperationException();
        }

        @Override
        public final void copyFrom(Character[] src, int destOffset) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void copyFrom(Character[] src, int destOffset, int length) {
            throw new UnsupportedOperationException();
        }

        @Override
        public final void copyFrom(Character[] src, int srcOffset, int destOffset, int length) {
            throw new UnsupportedOperationException();
        }

        @Override
        public final void copyFrom(char[] src) {
            throw new UnsupportedOperationException();
        }

        @Override
        public final void copyFrom(char[] src, int destOffset) {
            throw new UnsupportedOperationException();
        }

        @Override
        public final void copyFrom(char[] src, int srcOffset, int destOffset) {
            throw new UnsupportedOperationException();
        }

        @Override
        public final void copyFrom(char[] src, int srcOffset, int destOffset, int length) {
            throw new UnsupportedOperationException();
        }

        @Override
        public final CharPtr ofs(int elemOffset) {
            return new GuardedConstCharPtrImpl(this.getRoot() + (long)(elemOffset * 2), this, this.low + elemOffset, this.hi + elemOffset);
        }

        @Override
        public CharPtr getGuarded(int fromIndex, int toIndex) {
            if (toIndex < fromIndex) {
                throw new IllegalArgumentException();
            }
            return new GuardedConstCharPtrImpl(this.getRoot(), this, fromIndex, toIndex);
        }
    }

    private static class GuardedCharPtrImpl
    extends CharPtrImpl
    implements IGuardedPtr {
        protected final int low;
        protected final int hi;

        public GuardedCharPtrImpl(long peer, Object bufferOwner, int low, int hi) {
            super(peer, bufferOwner);
            if (low > hi) {
                throw new IllegalArgumentException();
            }
            this.low = low;
            this.hi = hi;
        }

        @Override
        public boolean checkIndex(int index) {
            return index >= this.low && index < this.hi;
        }

        @Override
        public boolean isGuarded() {
            return true;
        }

        @Override
        public char getValue(int idx) {
            if (!this.checkIndex(idx)) {
                throw new IndexOutOfBoundsException();
            }
            return super.get(idx).charValue();
        }

        @Override
        public Character[] toArray(int fromIndex, int toIndex) {
            if (!this.checkIndex(fromIndex) || !this.checkIndex(toIndex)) {
                throw new IndexOutOfBoundsException();
            }
            return super.toArray(fromIndex, toIndex);
        }

        @Override
        public char[] toCharArray(int fromIndex, int toIndex) {
            if (!this.checkIndex(fromIndex) || !this.checkIndex(toIndex)) {
                throw new IndexOutOfBoundsException();
            }
            return super.toCharArray(fromIndex, toIndex);
        }

        @Override
        public void copyTo(int srcOffset, Character[] dest, int destOffset, int length) {
            if (!this.checkIndex(srcOffset) || !this.checkIndex(srcOffset + length)) {
                throw new IndexOutOfBoundsException();
            }
            super.copyTo(srcOffset, dest, destOffset, length);
        }

        @Override
        public void copyTo(int srcOffset, char[] dest, int destOffset, int length) {
            if (!this.checkIndex(srcOffset) || !this.checkIndex(srcOffset + length)) {
                throw new IndexOutOfBoundsException();
            }
            super.copyTo(srcOffset, dest, destOffset, length);
        }

        @Override
        public void setValue(int idx, char value) {
            if (!this.checkIndex(idx)) {
                throw new IndexOutOfBoundsException();
            }
            super.set(idx, Character.valueOf(value));
        }

        @Override
        public void copyFrom(Character[] src, int srcOffset, int destOffset, int length) {
            if (!this.checkIndex(destOffset) || !this.checkIndex(destOffset + length)) {
                throw new IndexOutOfBoundsException();
            }
            super.copyFrom(src, srcOffset, destOffset, length);
        }

        @Override
        public void copyFrom(char[] src, int srcOffset, int destOffset, int length) {
            if (!this.checkIndex(destOffset) || !this.checkIndex(destOffset + length)) {
                throw new IndexOutOfBoundsException();
            }
            super.copyFrom(src, srcOffset, destOffset, length);
        }

        @Override
        public CharPtr ofs(int elemOffset) {
            return new GuardedCharPtrImpl(this.getRoot() + (long)(elemOffset * 2), this, this.low + elemOffset, this.hi + elemOffset);
        }

        @Override
        public CharPtr getGuarded(int fromIndex, int toIndex) {
            if (toIndex < fromIndex) {
                throw new IllegalArgumentException();
            }
            return new GuardedCharPtrImpl(this.getRoot(), this, fromIndex, toIndex);
        }

        @Override
        public int getGuardLow() {
            return this.low;
        }

        @Override
        public int getGuardHigh() {
            return this.hi;
        }
    }

    static class ConstCharPtrImpl
    extends CharPtrImpl {
        protected ConstCharPtrImpl(Pointer peer) {
            super(peer);
        }

        protected ConstCharPtrImpl(long peer, Object bufferOwner) {
            super(peer, bufferOwner);
        }

        ConstCharPtrImpl(int capacity, boolean owned) {
            super(capacity, owned);
        }

        @Override
        public boolean isConstPtr() {
            return true;
        }

        @Override
        public void set(Character obj) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void set(int idx, Character obj) {
            throw new UnsupportedOperationException();
        }

        @Override
        public final void setValue(char value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public final void setValue(int idx, char value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public final void copyFrom(Character[] src) {
            throw new UnsupportedOperationException();
        }

        @Override
        public final void copyFrom(Character[] src, int destOffset) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void copyFrom(Character[] src, int destOffset, int length) {
            throw new UnsupportedOperationException();
        }

        @Override
        public final void copyFrom(Character[] src, int srcOffset, int destOffset, int length) {
            throw new UnsupportedOperationException();
        }

        @Override
        public final void copyFrom(char[] src) {
            throw new UnsupportedOperationException();
        }

        @Override
        public final void copyFrom(char[] src, int destOffset) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void copyFrom(char[] src, int destOffset, int length) {
            throw new UnsupportedOperationException();
        }

        @Override
        public final void copyFrom(char[] src, int srcOffset, int destOffset, int length) {
            throw new UnsupportedOperationException();
        }

        @Override
        public final CharPtr ofs(int elemOffset) {
            return new ConstCharPtrImpl(this.getRoot() + (long)(elemOffset * 2), this);
        }

        @Override
        public CharPtr getGuarded(int fromIndex, int toIndex) {
            if (toIndex < fromIndex) {
                throw new IllegalArgumentException();
            }
            return new GuardedConstCharPtrImpl(this.getRoot(), this, fromIndex, toIndex);
        }
    }
}

