/*
 * Decompiled with CFR 0.152.
 */
package org.moe.natj.general.ptr.impl;

import org.moe.natj.c.CRuntime;
import org.moe.natj.general.Pointer;
import org.moe.natj.general.ptr.BoolPtr;
import org.moe.natj.general.ptr.IGuardedPtr;
import org.moe.natj.general.ptr.impl.VoidPtrImpl;

class BoolPtrImpl
extends VoidPtrImpl
implements BoolPtr {
    protected static final int ELEM_SIZE = 1;

    protected BoolPtrImpl(Pointer peer) {
        super(peer);
    }

    protected BoolPtrImpl(long peer, Object bufferOwner) {
        super(peer, false, bufferOwner);
    }

    BoolPtrImpl(int capacity, boolean owned) {
        super(CRuntime.allocBoolean(capacity), owned, null);
    }

    @Override
    public boolean isConstPtr() {
        return false;
    }

    @Override
    public final Boolean get() {
        return this.getValue(0);
    }

    @Override
    public final Boolean get(int idx) {
        return this.getValue(idx);
    }

    @Override
    public final boolean getValue() {
        return this.getValue(0);
    }

    @Override
    public boolean getValue(int idx) {
        return CRuntime.loadBoolean(this.getRoot(), idx);
    }

    public final Boolean[] toArray(int length) {
        return this.toArray(0, length);
    }

    public Boolean[] toArray(int fromIndex, int toIndex) {
        if (toIndex < fromIndex) {
            throw new IllegalArgumentException();
        }
        int length = toIndex - fromIndex;
        Boolean[] array = new Boolean[length];
        this.copyTo(fromIndex, array, 0, length);
        return array;
    }

    @Override
    public final boolean[] toBoolArray(int length) {
        return this.toBoolArray(0, length);
    }

    @Override
    public boolean[] toBoolArray(int fromIndex, int toIndex) {
        if (toIndex < fromIndex) {
            throw new IllegalArgumentException();
        }
        return CRuntime.createBooleanArray(this.getRoot() + (long)(fromIndex * 1), toIndex - fromIndex);
    }

    public final void copyTo(Boolean[] dest) {
        if (dest == null) {
            throw new IllegalArgumentException();
        }
        this.copyTo(0, dest, 0, dest.length);
    }

    public final void copyTo(Boolean[] dest, int length) {
        if (dest == null) {
            throw new IllegalArgumentException();
        }
        this.copyTo(0, dest, 0, length);
    }

    public void copyTo(int srcOffset, Boolean[] dest, int destOffset, int length) {
        if (dest == null || destOffset < 0 || length < 0 || destOffset + length > dest.length) {
            throw new IllegalArgumentException();
        }
        long root = this.getRoot();
        int idx = 0;
        while (idx < length) {
            dest[destOffset] = CRuntime.loadBoolean(root, srcOffset);
            ++idx;
            ++srcOffset;
            ++destOffset;
        }
    }

    @Override
    public final void copyTo(boolean[] dest) {
        if (dest == null) {
            throw new IllegalArgumentException();
        }
        this.copyTo(0, dest, 0, dest.length);
    }

    @Override
    public final void copyTo(boolean[] dest, int length) {
        if (dest == null) {
            throw new IllegalArgumentException();
        }
        this.copyTo(0, dest, 0, length);
    }

    @Override
    public void copyTo(int srcOffset, boolean[] dest, int destOffset, int length) {
        if (dest == null || destOffset < 0 || length < 0 || destOffset + length > dest.length) {
            throw new IllegalArgumentException();
        }
        CRuntime.copyFromNativeBooleanArray(dest, destOffset, this.getRoot(), srcOffset, length);
    }

    @Override
    public void set(Boolean obj) {
        this.setValue(obj);
    }

    @Override
    public void set(int idx, Boolean obj) {
        this.setValue(idx, obj);
    }

    @Override
    public void setValue(boolean value) {
        this.setValue(0, value);
    }

    @Override
    public void setValue(int idx, boolean value) {
        CRuntime.storeBoolean(this.getRoot(), idx, value);
    }

    public void copyFrom(Boolean[] src) {
        if (src == null) {
            throw new IllegalArgumentException();
        }
        this.copyFrom(src, 0, 0, src.length);
    }

    public void copyFrom(Boolean[] src, int destOffset) {
        if (src == null) {
            throw new IllegalArgumentException();
        }
        this.copyFrom(src, 0, destOffset, src.length);
    }

    public void copyFrom(Boolean[] src, int destOffset, int length) {
        if (src == null) {
            throw new IllegalArgumentException();
        }
        this.copyFrom(src, 0, destOffset, length);
    }

    public void copyFrom(Boolean[] src, int srcOffset, int destOffset, int length) {
        if (src == null || srcOffset < 0 || length < 0 || srcOffset + length > src.length) {
            throw new IllegalArgumentException();
        }
        long root = this.getRoot();
        int i = 0;
        while (i < length) {
            CRuntime.storeBoolean(root, destOffset, src[srcOffset]);
            ++i;
            ++srcOffset;
            ++destOffset;
        }
    }

    @Override
    public void copyFrom(boolean[] src) {
        if (src == null) {
            throw new IllegalArgumentException();
        }
        this.copyFrom(src, 0, 0, src.length);
    }

    @Override
    public void copyFrom(boolean[] src, int destOffset) {
        if (src == null) {
            throw new IllegalArgumentException();
        }
        this.copyFrom(src, 0, destOffset, src.length);
    }

    @Override
    public void copyFrom(boolean[] src, int destOffset, int length) {
        if (src == null) {
            throw new IllegalArgumentException();
        }
        this.copyFrom(src, 0, destOffset, length);
    }

    @Override
    public void copyFrom(boolean[] src, int srcOffset, int destOffset, int length) {
        if (src == null || srcOffset < 0 || length < 0 || srcOffset + length > src.length) {
            throw new IllegalArgumentException();
        }
        CRuntime.copyBooleanArray(this.getRoot(), destOffset, src, srcOffset, length);
    }

    @Override
    public BoolPtr ofs(int elemOffset) {
        return new BoolPtrImpl(this.getRoot() + (long)(elemOffset * 1), this);
    }

    @Override
    public boolean isGuarded() {
        return false;
    }

    @Override
    public final BoolPtr getGuarded(int length) {
        return this.getGuarded(0, length);
    }

    @Override
    public BoolPtr getGuarded(int fromIndex, int toIndex) {
        if (toIndex < fromIndex) {
            throw new IllegalArgumentException();
        }
        return new GuardedBoolPtrImpl(this.getRoot(), this, fromIndex, toIndex);
    }

    @Override
    public int getGuardLow() {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getGuardHigh() {
        throw new UnsupportedOperationException();
    }

    private static class GuardedConstBoolPtrImpl
    extends GuardedBoolPtrImpl {
        public GuardedConstBoolPtrImpl(long peer, Object bufferOwner, int low, int hi) {
            super(peer, bufferOwner, low, hi);
        }

        @Override
        public boolean isConstPtr() {
            return true;
        }

        @Override
        public void set(Boolean obj) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void set(int idx, Boolean obj) {
            throw new UnsupportedOperationException();
        }

        @Override
        public final void setValue(boolean value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public final void setValue(int idx, boolean value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public final void copyFrom(Boolean[] src) {
            throw new UnsupportedOperationException();
        }

        @Override
        public final void copyFrom(Boolean[] src, int destOffset) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void copyFrom(Boolean[] src, int destOffset, int length) {
            throw new UnsupportedOperationException();
        }

        @Override
        public final void copyFrom(Boolean[] src, int srcOffset, int destOffset, int length) {
            throw new UnsupportedOperationException();
        }

        @Override
        public final void copyFrom(boolean[] src) {
            throw new UnsupportedOperationException();
        }

        @Override
        public final void copyFrom(boolean[] src, int destOffset) {
            throw new UnsupportedOperationException();
        }

        @Override
        public final void copyFrom(boolean[] src, int srcOffset, int destOffset) {
            throw new UnsupportedOperationException();
        }

        @Override
        public final void copyFrom(boolean[] src, int srcOffset, int destOffset, int length) {
            throw new UnsupportedOperationException();
        }

        @Override
        public final BoolPtr ofs(int elemOffset) {
            return new GuardedConstBoolPtrImpl(this.getRoot() + (long)(elemOffset * 1), this, this.low + elemOffset, this.hi + elemOffset);
        }

        @Override
        public BoolPtr getGuarded(int fromIndex, int toIndex) {
            if (toIndex < fromIndex) {
                throw new IllegalArgumentException();
            }
            return new GuardedConstBoolPtrImpl(this.getRoot(), this, fromIndex, toIndex);
        }
    }

    private static class GuardedBoolPtrImpl
    extends BoolPtrImpl
    implements IGuardedPtr {
        protected final int low;
        protected final int hi;

        public GuardedBoolPtrImpl(long peer, Object bufferOwner, int low, int hi) {
            super(peer, bufferOwner);
            if (low > hi) {
                throw new IllegalArgumentException();
            }
            this.low = low;
            this.hi = hi;
        }

        @Override
        public boolean checkIndex(int index) {
            return index >= this.low && index < this.hi;
        }

        @Override
        public boolean isGuarded() {
            return true;
        }

        @Override
        public boolean getValue(int idx) {
            if (!this.checkIndex(idx)) {
                throw new IndexOutOfBoundsException();
            }
            return super.get(idx);
        }

        @Override
        public Boolean[] toArray(int fromIndex, int toIndex) {
            if (!this.checkIndex(fromIndex) || !this.checkIndex(toIndex)) {
                throw new IndexOutOfBoundsException();
            }
            return super.toArray(fromIndex, toIndex);
        }

        @Override
        public boolean[] toBoolArray(int fromIndex, int toIndex) {
            if (!this.checkIndex(fromIndex) || !this.checkIndex(toIndex)) {
                throw new IndexOutOfBoundsException();
            }
            return super.toBoolArray(fromIndex, toIndex);
        }

        @Override
        public void copyTo(int srcOffset, Boolean[] dest, int destOffset, int length) {
            if (!this.checkIndex(srcOffset) || !this.checkIndex(srcOffset + length)) {
                throw new IndexOutOfBoundsException();
            }
            super.copyTo(srcOffset, dest, destOffset, length);
        }

        @Override
        public void copyTo(int srcOffset, boolean[] dest, int destOffset, int length) {
            if (!this.checkIndex(srcOffset) || !this.checkIndex(srcOffset + length)) {
                throw new IndexOutOfBoundsException();
            }
            super.copyTo(srcOffset, dest, destOffset, length);
        }

        @Override
        public void setValue(int idx, boolean value) {
            if (!this.checkIndex(idx)) {
                throw new IndexOutOfBoundsException();
            }
            super.set(idx, value);
        }

        @Override
        public void copyFrom(Boolean[] src, int srcOffset, int destOffset, int length) {
            if (!this.checkIndex(destOffset) || !this.checkIndex(destOffset + length)) {
                throw new IndexOutOfBoundsException();
            }
            super.copyFrom(src, srcOffset, destOffset, length);
        }

        @Override
        public void copyFrom(boolean[] src, int srcOffset, int destOffset, int length) {
            if (!this.checkIndex(destOffset) || !this.checkIndex(destOffset + length)) {
                throw new IndexOutOfBoundsException();
            }
            super.copyFrom(src, srcOffset, destOffset, length);
        }

        @Override
        public BoolPtr ofs(int elemOffset) {
            return new GuardedBoolPtrImpl(this.getRoot() + (long)(elemOffset * 1), this, this.low + elemOffset, this.hi + elemOffset);
        }

        @Override
        public BoolPtr getGuarded(int fromIndex, int toIndex) {
            if (toIndex < fromIndex) {
                throw new IllegalArgumentException();
            }
            return new GuardedBoolPtrImpl(this.getRoot(), this, fromIndex, toIndex);
        }

        @Override
        public int getGuardLow() {
            return this.low;
        }

        @Override
        public int getGuardHigh() {
            return this.hi;
        }
    }

    static class ConstBoolPtrImpl
    extends BoolPtrImpl {
        protected ConstBoolPtrImpl(Pointer peer) {
            super(peer);
        }

        protected ConstBoolPtrImpl(long peer, Object bufferOwner) {
            super(peer, bufferOwner);
        }

        ConstBoolPtrImpl(int capacity, boolean owned) {
            super(capacity, owned);
        }

        @Override
        public boolean isConstPtr() {
            return true;
        }

        @Override
        public void set(Boolean obj) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void set(int idx, Boolean obj) {
            throw new UnsupportedOperationException();
        }

        @Override
        public final void setValue(boolean value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public final void setValue(int idx, boolean value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public final void copyFrom(Boolean[] src) {
            throw new UnsupportedOperationException();
        }

        @Override
        public final void copyFrom(Boolean[] src, int destOffset) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void copyFrom(Boolean[] src, int destOffset, int length) {
            throw new UnsupportedOperationException();
        }

        @Override
        public final void copyFrom(Boolean[] src, int srcOffset, int destOffset, int length) {
            throw new UnsupportedOperationException();
        }

        @Override
        public final void copyFrom(boolean[] src) {
            throw new UnsupportedOperationException();
        }

        @Override
        public final void copyFrom(boolean[] src, int destOffset) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void copyFrom(boolean[] src, int destOffset, int length) {
            throw new UnsupportedOperationException();
        }

        @Override
        public final void copyFrom(boolean[] src, int srcOffset, int destOffset, int length) {
            throw new UnsupportedOperationException();
        }

        @Override
        public final BoolPtr ofs(int elemOffset) {
            return new ConstBoolPtrImpl(this.getRoot() + (long)(elemOffset * 1), this);
        }

        @Override
        public BoolPtr getGuarded(int fromIndex, int toIndex) {
            if (toIndex < fromIndex) {
                throw new IllegalArgumentException();
            }
            return new GuardedConstBoolPtrImpl(this.getRoot(), this, fromIndex, toIndex);
        }
    }
}

