/*
 * Decompiled with CFR 0.152.
 */
package org.moe.natj.general;

import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.Map;
import org.moe.natj.general.Mapper;

public abstract class NativeRuntime {
    private Map<Class<?>, Mapper> class2mapper = new HashMap();
    protected Mapper objectMapper;
    protected Mapper stringMapper;
    protected Mapper callbackMapper;

    protected Mapper createMapper(Class<?> mapperClass) {
        try {
            Constructor<?> constructor = mapperClass.getConstructor(new Class[0]);
            return (Mapper)constructor.newInstance(new Object[0]);
        }
        catch (Exception ex) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Mapper getMapper(Class<?> mapperClass) {
        Mapper mapper;
        Map<Class<?>, Mapper> map = this.class2mapper;
        synchronized (map) {
            mapper = this.class2mapper.get(mapperClass);
            if (mapper == null) {
                mapper = this.createMapper(mapperClass);
                this.class2mapper.put(mapperClass, mapper);
            }
        }
        return mapper;
    }

    protected NativeRuntime(Class<?> objectMapperClass, Class<?> stringMapperClass, Class<?> callbackMapperClass) {
        if (objectMapperClass != null) {
            this.objectMapper = this.createMapper(objectMapperClass);
            this.class2mapper.put(objectMapperClass, this.objectMapper);
        }
        if (stringMapperClass != null) {
            this.stringMapper = this.createMapper(stringMapperClass);
            this.class2mapper.put(stringMapperClass, this.stringMapper);
        }
        if (callbackMapperClass != null) {
            this.callbackMapper = callbackMapperClass == null ? null : this.createMapper(callbackMapperClass);
            this.class2mapper.put(callbackMapperClass, this.callbackMapper);
        }
    }

    public Mapper getObjectMapper() {
        return this.objectMapper;
    }

    public Mapper getStringMapper() {
        return this.stringMapper;
    }

    public Mapper getCallbackMapper() {
        return this.callbackMapper;
    }

    public abstract byte getDefaultUnboxPolicy();

    public abstract void tryToDisposeCallback(Object var1);

    protected abstract void doRegistration(Class<?> var1);
}

