/*
 * Decompiled with CFR 0.152.
 */
package org.moe.natj.cxx.impl;

import java.util.concurrent.atomic.AtomicBoolean;

public class UniqueIndexProvider {
    private final AtomicBoolean mLock = new AtomicBoolean(false);
    private final Slice mSlice = new Slice(1L);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long acquire() {
        Slice slice = this.mSlice;
        long index;
        while ((index = slice.acquire()) == 0L) {
            while (this.mLock.compareAndSet(false, true)) {
            }
            try {
                Slice next = slice.mNext;
                if (next == null) {
                    next = new Slice(slice.mStart + 256L);
                    slice.mNext = next;
                } else if (next.mStart != slice.mStart + 256L) {
                    next = new Slice(slice.mStart + 256L);
                    next.mNext = slice.mNext;
                    slice.mNext = next;
                }
                slice = next;
                continue;
            }
            finally {
                this.mLock.set(false);
                continue;
            }
            break;
        }
        return index;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release(long index) {
        if (index == 0L) {
            throw new IllegalArgumentException();
        }
        Slice slice = this.mSlice;
        while (!slice.release(index)) {
            while (this.mLock.compareAndSet(false, true)) {
            }
            try {
                slice = slice.mNext;
            }
            finally {
                this.mLock.set(false);
            }
        }
    }

    public void optimize() {
        while (this.mLock.compareAndSet(false, true)) {
        }
        try {
            Slice current = this.mSlice;
            Slice next = current.mNext;
            while (next != null) {
                if (next.isEmpty()) {
                    current.mNext = next.mNext;
                    next = next.mNext;
                    continue;
                }
                current = next;
                next = next.mNext;
            }
        }
        finally {
            this.mLock.set(false);
        }
    }

    private static final class Slice {
        private static final int CAPACITY = 256;
        private final AtomicBoolean mLock = new AtomicBoolean(false);
        private final long mStart;
        private long mTable0 = 0L;
        private long mTable1 = 0L;
        private long mTable2 = 0L;
        private long mTable3 = 0L;
        private Slice mNext = null;

        private Slice(long start) {
            this.mStart = start;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public long acquire() {
            while (this.mLock.compareAndSet(false, true)) {
            }
            try {
                if (this.mTable0 != -1L) {
                    int index = 0;
                    long table = this.mTable0;
                    while ((table & 1L) != 0L) {
                        table >>>= 1;
                        ++index;
                    }
                    this.mTable0 |= 1L << index;
                    long l = this.mStart + (long)index;
                    return l;
                }
                if (this.mTable1 != -1L) {
                    int index = 0;
                    long table = this.mTable1;
                    while ((table & 1L) != 0L) {
                        table >>>= 1;
                        ++index;
                    }
                    this.mTable1 |= 1L << index;
                    long l = this.mStart + 64L + (long)index;
                    return l;
                }
                if (this.mTable2 != -1L) {
                    int index = 0;
                    long table = this.mTable2;
                    while ((table & 1L) != 0L) {
                        table >>>= 1;
                        ++index;
                    }
                    this.mTable2 |= 1L << index;
                    long l = this.mStart + 128L + (long)index;
                    return l;
                }
                if (this.mTable3 != -1L) {
                    int index = 0;
                    long table = this.mTable3;
                    while ((table & 1L) != 0L) {
                        table >>>= 1;
                        ++index;
                    }
                    this.mTable3 |= 1L << index;
                    long l = this.mStart + 192L + (long)index;
                    return l;
                }
            }
            finally {
                this.mLock.set(false);
            }
            return 0L;
        }

        public boolean release(long index) {
            if (index >= this.mStart + 256L) {
                return false;
            }
            while (this.mLock.compareAndSet(false, true)) {
            }
            try {
                int offset = (int)(index - this.mStart);
                int tIndex = offset >> 6;
                switch (tIndex) {
                    case 0: {
                        this.mTable0 &= 1L << offset - (tIndex << 6) ^ 0xFFFFFFFFFFFFFFFFL;
                        boolean bl = true;
                        return bl;
                    }
                    case 1: {
                        this.mTable1 &= 1L << offset - (tIndex << 6) ^ 0xFFFFFFFFFFFFFFFFL;
                        boolean bl = true;
                        return bl;
                    }
                    case 2: {
                        this.mTable2 &= 1L << offset - (tIndex << 6) ^ 0xFFFFFFFFFFFFFFFFL;
                        boolean bl = true;
                        return bl;
                    }
                    case 3: {
                        this.mTable3 &= 1L << offset - (tIndex << 6) ^ 0xFFFFFFFFFFFFFFFFL;
                        boolean bl = true;
                        return bl;
                    }
                }
                throw new IllegalStateException();
            }
            finally {
                this.mLock.set(false);
            }
        }

        public boolean isEmpty() {
            return this.mTable0 == 0L && this.mTable1 == 0L && this.mTable2 == 0L && this.mTable3 == 0L;
        }
    }
}

