/*
 * Decompiled with CFR 0.152.
 */
package org.moe.natj.cxx.impl;

import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import org.moe.natj.cxx.impl.UniqueIndexProvider;

public class ReferenceManager {
    private final AtomicBoolean mapLock = new AtomicBoolean(false);
    private final ReferenceQueue<Object> queue = new ReferenceQueue();
    private final HashMap<WeakReference<Object>, Integer> javaToIdentityMap = new HashMap();
    private final HashMap<Integer, Long> identityToNativeMap = new HashMap();
    private final HashMap<Long, WeakReference<Object>> nativeToJavaMap = new HashMap();
    private final UniqueIndexProvider indexProvider = new UniqueIndexProvider();

    public ReferenceManager() {
        Thread cleaner = new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void run() {
                while (true) {
                    WeakReference ref;
                    try {
                        ref = (WeakReference)ReferenceManager.this.queue.remove();
                    }
                    catch (InterruptedException e) {
                        System.out.println("Stopping NatJ Reference Manager Clean Daemon");
                        return;
                    }
                    ReferenceManager.this.aquireLock();
                    try {
                        Integer ihc = (Integer)ReferenceManager.this.javaToIdentityMap.get(ref);
                        Long id = (Long)ReferenceManager.this.identityToNativeMap.get(ihc);
                        ReferenceManager.this.nativeToJavaMap.remove(id);
                        ReferenceManager.this.identityToNativeMap.remove(ihc);
                        ReferenceManager.this.javaToIdentityMap.remove(ref);
                        ReferenceManager.this.indexProvider.release(id);
                        continue;
                    }
                    finally {
                        ReferenceManager.this.releaseLock();
                        continue;
                    }
                    break;
                }
            }
        });
        cleaner.setDaemon(true);
        cleaner.setName("NatJ Reference Manager Clean Daemon");
        cleaner.start();
    }

    private void aquireLock() {
        while (!this.mapLock.compareAndSet(false, true)) {
        }
    }

    public int objectCount() {
        this.aquireLock();
        try {
            int n = this.javaToIdentityMap.size();
            return n;
        }
        finally {
            this.releaseLock();
        }
    }

    private void releaseLock() {
        this.mapLock.set(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long put(Object obj) {
        if (obj == null) {
            return 0L;
        }
        this.aquireLock();
        try {
            int identityHashCode = System.identityHashCode(obj);
            Long key = this.identityToNativeMap.get(identityHashCode);
            if (key != null) {
                long l = key;
                return l;
            }
            key = this.indexProvider.acquire();
            WeakReference<Object> wref = new WeakReference<Object>(obj, this.queue);
            this.javaToIdentityMap.put(wref, identityHashCode);
            this.identityToNativeMap.put(identityHashCode, key);
            this.nativeToJavaMap.put(key, wref);
            long l = key;
            return l;
        }
        finally {
            this.releaseLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object get(long id) {
        if (id == 0L) {
            return null;
        }
        this.aquireLock();
        try {
            WeakReference<Object> wref = this.nativeToJavaMap.get(id);
            if (wref == null) {
                throw new IllegalStateException();
            }
            Object t = wref.get();
            return t;
        }
        finally {
            this.releaseLock();
        }
    }
}

