/*
 * Decompiled with CFR 0.152.
 */
package org.moe.natj.cxx;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.moe.natj.cxx.CxxObject;
import org.moe.natj.cxx.CxxObjectBaseImpl;
import org.moe.natj.cxx.impl.ReferenceManager;
import org.moe.natj.general.Pointer;
import org.moe.natj.general.ann.NFloat;
import org.moe.natj.general.ann.NLong;
import org.moe.natj.general.ann.NULong;
import org.moe.natj.general.ann.WCharT;
import org.moe.natj.general.ptr.BoolPtr;
import org.moe.natj.general.ptr.BytePtr;
import org.moe.natj.general.ptr.CharPtr;
import org.moe.natj.general.ptr.ConstVoidPtr;
import org.moe.natj.general.ptr.DoublePtr;
import org.moe.natj.general.ptr.FloatPtr;
import org.moe.natj.general.ptr.IntPtr;
import org.moe.natj.general.ptr.LongPtr;
import org.moe.natj.general.ptr.NFloatPtr;
import org.moe.natj.general.ptr.NLongPtr;
import org.moe.natj.general.ptr.NULongPtr;
import org.moe.natj.general.ptr.ShortPtr;
import org.moe.natj.general.ptr.VoidPtr;
import org.moe.natj.general.ptr.WCharTPtr;
import org.moe.natj.general.ptr.impl.PtrFactory;
import org.moe.natj.general.ptr.impl.PtrImplementer;

public class CxxRuntime {
    public static final long ILLEGAL_MEMORY_ADDRESS = -2401034268329525521L;
    private static final ReadWriteLock READ_WRITE_LOCK = new ReentrantReadWriteLock();
    private static final Lock READ_LOCK = READ_WRITE_LOCK.readLock();
    private static final Lock WRITE_LOCK = READ_WRITE_LOCK.writeLock();
    private static final HashMap<Long, CxxObject> NATIVE_OBJECT_MAP = new HashMap();
    private static final ReferenceManager REFERENCE_MANAGER = new ReferenceManager();
    public static final Map<Class<?>, Class<?>> primitivePtrTypeMap;

    private CxxRuntime() {
    }

    public static void initialize() {
    }

    private static native void setupVM();

    public static Class<?> getClassImplForName(String className, String implSuffix) {
        try {
            return Class.forName(className + implSuffix);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void delete(CxxObject obj) {
        CxxObjectBaseImpl impl = (CxxObjectBaseImpl)obj;
        long peer = impl._cxx_rt_peer();
        WRITE_LOCK.lock();
        try {
            NATIVE_OBJECT_MAP.remove(peer);
        }
        finally {
            WRITE_LOCK.unlock();
        }
        impl._cxx_rt_delete2();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T extends CxxObject> void deleteWith(T object, Releaser<T> releaser) {
        if (object == null) {
            throw new NullPointerException();
        }
        if (releaser == null) {
            throw new NullPointerException();
        }
        try {
            releaser.release(object);
        }
        finally {
            CxxObjectBaseImpl impl = (CxxObjectBaseImpl)object;
            long peer = impl._cxx_rt_peer();
            impl._cxx_rt_invalidate();
            WRITE_LOCK.lock();
            try {
                NATIVE_OBJECT_MAP.remove(peer);
            }
            finally {
                WRITE_LOCK.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T extends CxxObject> void detachOnly(T object) {
        if (object == null) {
            throw new NullPointerException();
        }
        CxxObjectBaseImpl impl = (CxxObjectBaseImpl)object;
        long peer = impl._cxx_rt_peer();
        WRITE_LOCK.lock();
        try {
            NATIVE_OBJECT_MAP.remove(peer);
        }
        finally {
            WRITE_LOCK.unlock();
        }
    }

    public static CxxObject get(long peer) {
        if (peer == 0L) {
            return null;
        }
        READ_LOCK.lock();
        try {
            CxxObject cxxObject = NATIVE_OBJECT_MAP.get(peer);
            return cxxObject;
        }
        finally {
            READ_LOCK.unlock();
        }
    }

    public static <T extends CxxObject> T construct(long peer, Class<T> implClass) {
        Constructor<T> ctor;
        if (peer == 0L) {
            return null;
        }
        try {
            ctor = implClass.getConstructor(Long.TYPE);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
        WRITE_LOCK.lock();
        try {
            CxxObject e = (CxxObject)ctor.newInstance(peer);
            return (T)e;
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (InstantiationException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e);
        }
        finally {
            WRITE_LOCK.unlock();
        }
    }

    public static void register(CxxObject object) {
        if (object == null) {
            throw new NullPointerException();
        }
        WRITE_LOCK.lock();
        try {
            NATIVE_OBJECT_MAP.put(object._cxx_rt_peer(), object);
        }
        finally {
            WRITE_LOCK.unlock();
        }
    }

    public static long getUIDForObject(Object object) {
        return REFERENCE_MANAGER.put(object);
    }

    public static Object getObjectForUID(long uid) {
        return REFERENCE_MANAGER.get(uid);
    }

    public static ConstVoidPtr constructPtrForPeer(long peer, int depth, Class<?> elementClass) {
        Constructor<?> constructor;
        Class<?> implClass;
        if (peer == 0L) {
            return null;
        }
        if (depth < 1) {
            throw new IllegalArgumentException("depth must be greater than or equal to 1");
        }
        if (elementClass == null) {
            throw new NullPointerException();
        }
        Pointer pointer = new Pointer(peer);
        if (depth == 1) {
            Constructor<?> constructor2;
            Class<?> implClass2;
            if (CxxObject.class.isAssignableFrom(elementClass)) {
                Class<?> cls = elementClass;
                return PtrImplementer.getCxxObjectPtr(cls, pointer);
            }
            Class<?> ptrClass = primitivePtrTypeMap.get(elementClass);
            if (ptrClass != null) {
                implClass2 = PtrImplementer.primitivePtrTypeMap.get(ptrClass);
                if (implClass2 == null) {
                    throw new RuntimeException("failed to locate impl class");
                }
            } else {
                throw new RuntimeException("failed to locate ptr class");
            }
            try {
                constructor2 = implClass2.getDeclaredConstructor(Pointer.class);
            }
            catch (NoSuchMethodException e) {
                throw new RuntimeException(e);
            }
            if (constructor2 == null) {
                throw new RuntimeException("failed to locate impl class constructor");
            }
            constructor2.setAccessible(true);
            try {
                return (ConstVoidPtr)constructor2.newInstance(pointer);
            }
            catch (InstantiationException e) {
                throw new RuntimeException(e);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
            catch (InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        }
        try {
            implClass = Class.forName("org.moe.natj.general.ptr.impl.IndirectPtrImpl");
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
        try {
            constructor = implClass.getDeclaredConstructor(Class.class, Integer.TYPE, Pointer.class);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
        if (constructor == null) {
            throw new RuntimeException("failed to locate impl class constructor");
        }
        constructor.setAccessible(true);
        try {
            return (ConstVoidPtr)constructor.newInstance(elementClass, depth, pointer);
        }
        catch (InstantiationException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    public static final long sizeof(CxxObject object) {
        if (object == null) {
            throw new NullPointerException();
        }
        return CxxRuntime.sizeof(object.getClass());
    }

    public static final <T extends CxxObject> long sizeof(Class<T> cls) {
        Field cxx_rt_sizeof;
        cls = CxxRuntime.getImplClass(cls);
        try {
            cxx_rt_sizeof = cls.getField("_CXX_RT_SIZEOF");
        }
        catch (NoSuchFieldException e) {
            return -1L;
        }
        try {
            return cxx_rt_sizeof.getLong(null);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    public static final <T extends CxxObject> Method getPtrNewMethod(Class<T> cls) {
        String methodName = "__cxx_op_6ptrnewi";
        Class[] parameterTypes = new Class[]{Integer.TYPE};
        return CxxRuntime.getBridgeMethod(cls, "__cxx_op_6ptrnewi", parameterTypes);
    }

    public static final <T extends CxxObject> Method getPtrDeleteMethod(Class<T> cls) {
        String methodName = "__cxx_op_9ptrdeletej";
        Class[] parameterTypes = new Class[]{Long.TYPE};
        return CxxRuntime.getBridgeMethod(cls, "__cxx_op_9ptrdeletej", parameterTypes);
    }

    public static final <T extends CxxObject> Method getPtrSetMethod(Class<T> cls) {
        String methodName = "__cxx_op_6ptrsetjij";
        Class[] parameterTypes = new Class[]{Long.TYPE, Integer.TYPE, Long.TYPE};
        return CxxRuntime.getBridgeMethod(cls, "__cxx_op_6ptrsetjij", parameterTypes);
    }

    public static final <T extends CxxObject> Method getPtrGetMethod(Class<T> cls) {
        String methodName = "__cxx_op_6ptrgetji";
        Class[] parameterTypes = new Class[]{Long.TYPE, Integer.TYPE};
        return CxxRuntime.getBridgeMethod(cls, "__cxx_op_6ptrgetji", parameterTypes);
    }

    private static <T extends CxxObject> Method getBridgeMethod(Class<T> cls, String methodName, Class<?>[] parameterTypes) {
        try {
            return cls.getMethod(methodName, parameterTypes);
        }
        catch (NoSuchMethodException e) {
            return null;
        }
    }

    public static <T extends CxxObject> Class<T> getImplClass(Class<T> cls) {
        if (cls == null) {
            throw new NullPointerException();
        }
        if (cls.isInterface()) {
            try {
                cls = Class.forName(cls.getName() + "$__cxx_Impl");
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(e);
            }
        }
        return cls;
    }

    public static <T extends CxxObject> VoidPtr castToPtr(T object) {
        if (object == null) {
            return null;
        }
        return PtrFactory.newWeakVoidPtr(object._cxx_rt_peer());
    }

    static {
        CxxRuntime.setupVM();
        HashMap<Class<WCharT>, Class<WCharTPtr>> ptrMap = new HashMap<Class<WCharT>, Class<WCharTPtr>>(32);
        ptrMap.put(Void.class, VoidPtr.class);
        ptrMap.put(Character.class, CharPtr.class);
        ptrMap.put(Boolean.class, BoolPtr.class);
        ptrMap.put(Byte.class, BytePtr.class);
        ptrMap.put(Short.class, ShortPtr.class);
        ptrMap.put(Integer.class, IntPtr.class);
        ptrMap.put(Long.class, LongPtr.class);
        ptrMap.put(Float.class, FloatPtr.class);
        ptrMap.put(Double.class, DoublePtr.class);
        ptrMap.put(NFloat.class, NFloatPtr.class);
        ptrMap.put(NULong.class, NULongPtr.class);
        ptrMap.put(NLong.class, NLongPtr.class);
        ptrMap.put(WCharT.class, WCharTPtr.class);
        primitivePtrTypeMap = Collections.unmodifiableMap(ptrMap);
    }

    public static interface Releaser<T extends CxxObject> {
        public void release(T var1);
    }
}

