/*
 * Decompiled with CFR 0.152.
 */
package org.moe.natj.c.map;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import org.moe.natj.c.CRuntime;
import org.moe.natj.c.ann.FunctionPtr;
import org.moe.natj.general.Mapper;
import org.moe.natj.general.NatJ;
import org.moe.natj.general.Pointer;

public class CCallbackMapper
implements Mapper {
    public Map<Object, CallbackInfo[]> instance2callbacks = new HashMap<Object, CallbackInfo[]>();
    public Map<Long, Long> callback2extras = new HashMap<Long, Long>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public long toNative(Object instance, NatJ.NativeObjectConstructionInfo info) {
        long peer;
        CallbackInfo[] callbackInfoArray;
        if (instance == null) {
            return 0L;
        }
        Class<?> cls = instance.getClass();
        int[] idxRef = new int[1];
        Object countRef22 = new int[1];
        FunctionPtr cb = (FunctionPtr)info.callback;
        Method method = NatJ.getMethod(cls, cb.name(), cb.argTypes(), idxRef, countRef22);
        if (method == null) {
            return 0L;
        }
        int idx = idxRef[0];
        int count = countRef22[0];
        CallbackInfo[] cache = null;
        try {
            Object object = instance;
            countRef22 = object;
            // MONITORENTER : object
            cache = (CallbackInfo[])NatJ.getOrCreateObjectCacheForRuntime(CRuntime.class, instance, new CCallbackCacheConstructor(count));
            // MONITOREXIT : countRef22
        }
        catch (Exception countRef22) {
            // empty catch block
        }
        if (cache == null) {
            callbackInfoArray = this.instance2callbacks;
            // MONITORENTER : this.instance2callbacks
            cache = this.instance2callbacks.get(instance);
            if (cache == null) {
                cache = new CallbackInfo[count];
                this.instance2callbacks.put(instance, cache);
            }
            // MONITOREXIT : callbackInfoArray
        }
        callbackInfoArray = cache;
        // MONITORENTER : cache
        if (cache[idx] == null) {
            long[] extra = new long[1];
            peer = CRuntime.allocNativeCallback(instance, method, extra);
            Pointer callback = CRuntime.createStrongPointer(peer, false);
            cache[idx] = new CallbackInfo(callback, extra[0]);
            Map<Long, Long> map = this.callback2extras;
            // MONITORENTER : map
            this.callback2extras.put(callback.getPeer(), extra[0]);
            // MONITOREXIT : map
            return peer;
        }
        peer = cache[idx].callback.getPeer();
        // MONITOREXIT : callbackInfoArray
        return peer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object toJava(long peer, NatJ.JavaObjectConstructionInfo info) {
        Long cbInfo;
        if (peer == 0L) {
            return null;
        }
        Map<Long, Long> map = this.callback2extras;
        synchronized (map) {
            cbInfo = this.callback2extras.get(peer);
        }
        if (cbInfo == null) {
            return null;
        }
        return CRuntime.createJavaCallback(cbInfo);
    }

    private class CCallbackCacheConstructor
    implements NatJ.CacheConstructor {
        int size;

        public CCallbackCacheConstructor(int size) {
            this.size = size;
        }

        @Override
        public Object constructCache() {
            return new CallbackInfo[this.size];
        }
    }

    public static class CallbackInfo {
        public Pointer callback;
        public long extra;

        public CallbackInfo(Pointer callback, long extra) {
            this.callback = callback;
            this.extra = extra;
        }
    }
}

