
local function fn()
    local inst = CreateEntity()
    inst.entity:AddTransform()
	
	inst.entity:AddAnimState()
    inst.entity:AddNetwork()
	
	inst.AnimState:SetBank("deerclops_icespike")
    inst.AnimState:SetBuild("deerclops_icespike")
	inst.AnimState:PlayAnimation("spike1")
	inst.AnimState:SetPercent("spike1", 0.333)
	
    MakeInventoryPhysics(inst)
    RemovePhysicsColliders(inst)
	
	inst:AddTag("NOCLICK")
	inst:AddTag("FX")
	
    inst.entity:SetPristine()
	
    if not TheWorld.ismastersim then
        return inst
    end
	
	inst.persists = false
	inst._mult = 1
	
	inst.DoExplode = function (inst)
		for i = 1, 16 do
			local fx = SpawnPrefab("rem_icespike")
			if fx then
				fx.Transform:SetPosition( inst.Transform:GetWorldPosition() )
				fx.Transform:SetRotation( 360/16 * (i-1) )
				fx.master = inst.master
				fx.Physics:SetMotorVelOverride(10,0,0) 
			end
		end
	end
	
	local period = .1
	inst.collide_task_table = {}
	inst:DoPeriodicTask(period, function()
	
		local pt = inst:GetPosition()	
		local r = 2
		local ents = TheSim:FindEntities(pt.x, pt.y, pt.z, r, nil, {"FX", "NOCLICK", "DECOR", "INLIMBO"})
		
		for k,v in pairs(ents) do
			--ӹģ
			if v and v ~= inst.master and 
				not (v.components.follower and v.components.follower.leader == inst.master ) and 
				(TheNet:GetPVPEnabled() or not v:HasTag("player")) and
				not table.contains(inst._collide_table, v.GUID) and 
				not v:HasTag("companion") and
				not v:HasTag("wall")
			then
				
				if not table.contains(inst.collide_task_table, v.GUID) then
				
					if v.components.combat then
						if v.components.combat.Zg_GetAttacked then
							v.components.combat:Zg_GetAttacked(inst, 100 )
						else
							v.components.combat:GetAttacked(inst, 100 )
						end
						table.insert(inst.collide_task_table, v.GUID)
						
						if inst._mult == 2 then
							inst:DoExplode(inst)
							--inst:Remove()
						end
					end
					
				end
				
			end
		end
		
	end)
	
	inst:DoTaskInTime(2, function()
		if inst then
			if inst._mult == 2 then
				inst:DoExplode(inst)
			end
			inst:Remove()
		end
	end)

    return inst
end

return Prefab ("rem_icespike", fn)