local assets =
{
	Asset( "ANIM", "anim/rem_armor.zip" ),
	Asset( "ATLAS", "images/rem_armor.xml" ),
}

local function onequip(inst, owner) 
	if owner.prefab == "rem" then
		--owner.AnimState:OverrideSymbol("swap_body", "rem_armor", "swap_body")
		owner.AnimState:ClearOverrideSymbol("swap_body")
		if inst.components.container ~= nil then
			inst.components.container:Open(owner)
		end
	else
		owner:DoTaskInTime(0, function()
			local inv = owner.components.inventory 
			if inv then
				inv:GiveItem(inst)
			end
			local talker = owner.components.talker 
			if talker then
				talker:Say("This is only for Rem!")
			end
		end)
	end
end

local function onunequip(inst, owner) 
    owner.AnimState:ClearOverrideSymbol("swap_body")
	if inst.components.container ~= nil then
        inst.components.container:Close(owner)
    end
end

local function fn()
    local inst = CreateEntity()

    inst.entity:AddTransform()
    inst.entity:AddAnimState()
    inst.entity:AddNetwork()

    MakeInventoryPhysics(inst)

    inst.AnimState:SetBank("rem_armor")
    inst.AnimState:SetBuild("rem_armor")
    inst.AnimState:PlayAnimation("anim")

    inst.entity:SetPristine()

    if not TheWorld.ismastersim then
        return inst
    end

    inst:AddComponent("inspectable")

    inst:AddComponent("inventoryitem")
	inst.components.inventoryitem.imagename = "rem_armor"
    inst.components.inventoryitem.atlasname = "images/rem_armor.xml"

    inst:AddComponent("equippable")
    inst.components.equippable.equipslot = EQUIPSLOTS.BODY
    inst.components.equippable:SetOnEquip(onequip)
    inst.components.equippable:SetOnUnequip(onunequip)
	
	--齨
	inst:AddComponent("container")
	inst.components.container:WidgetSetup("rem_armor")

    return inst
end

return Prefab("rem_armor", fn, assets)
