"use strict";

var _classProps = function (child, staticProps, instanceProps) {
  if (staticProps) Object.defineProperties(child, staticProps);
  if (instanceProps) Object.defineProperties(child.prototype, instanceProps);
};

var _extends = function (child, parent) {
  child.prototype = Object.create(parent.prototype, {
    constructor: {
      value: child,
      enumerable: false,
      writable: true,
      configurable: true
    }
  });
  child.__proto__ = parent;
};

var Node = require("./node");
var vendor = require("./vendor");

// CSS declaration like “color: black” in rules
var Declaration = (function (Node) {
  var Declaration = function Declaration(defaults) {
    this.type = "decl";
    Node.call(this, defaults);
  };

  _extends(Declaration, Node);

  _classProps(Declaration, null, {
    styleMap: {
      writable: true,
      value: function () {
        return {
          beforeDecl: this.before,
          colon: this.between
        };
      }
    },
    stringify: {
      writable: true,


      // Stringify declaration
      value: function (builder, semicolon) {
        var before = this.style("beforeDecl");
        if (before) builder(before);

        var between = this.style("colon");
        var string = this.prop + between + this.stringifyRaw("value");

        if (this.important) {
          string += this._important || " !important";
        }

        if (semicolon) string += ";";
        builder(string, this);
      }
    },
    clone: {
      writable: true,


      // Clean `before` and `between` property in clone to copy it from new
      // parent rule
      value: function (overrides) {
        if (overrides === undefined) overrides = {};
        var cloned = Node.prototype.clone.call(this, overrides);
        delete cloned.before;
        delete cloned.between;
        return cloned;
      }
    }
  });

  return Declaration;
})(Node);

module.exports = Declaration;