local addonName, addonNamespace = ...

LoadAddOn("Blizzard_InspectUI")

local AddOn = LibStub("AceAddon-3.0"):NewAddon(
    addonName,
    "AceConsole-3.0",
    "AceEvent-3.0"
)

_G[addonName] = AddOn

AddOn.configPanel = nil
AddOn.defaults = {
    profile = {
        Upgrades = false,
        UpgradesSummary = true,
        Character = true,
        Inspection = true,
        Color = true,
        Small = false,
        Debug = false,
    }
}
AddOn.characterVisible = false
AddOn.inspectorVisible = false

function AddOn:OnInitialize()
    self.db = LibStub("AceDB-3.0"):New(self:GetName() .. "DB", self.defaults, true)

    self:Debug("OnInitialize")

    LibStub("AceConfig-3.0"):RegisterOptionsTable(self:GetName(), {
        type = "group",
        args = {
        },
    }, "/kib")

    self:RegisterChatCommand("kib", function(input)
        if not input or input:trim() == "" then
            InterfaceOptionsFrame_OpenToCategory(self.configPanel)

            InterfaceOptionsFrameTab2:Click("LeftButton", true)

            for _, button in pairs(self:FindFrames("InterfaceOptionsFrameAddOnsButton")) do
                if button.Click and button.GetText and button:GetText() == self.configPanel.name then
                    button:Click("LeftButton", true)
                    break
                end
            end
        else
            LibStub("AceConfigCmd-3.0").HandleCommand(MyAddon, "kib", self:GetName(), input)
        end
    end)

    self.L = LibStub("AceLocale-3.0"):GetLocale(self:GetName())
    self.playerSlotIconManager = addonNamespace.SlotIconManager:new("player")
    self.inspectorSlotIconManager = addonNamespace.SlotIconManager:new("target")

    self.characterPaneVisible = false
    self.inspectorPaneVisible = false

    self:ApplyStyle()

    self.db.RegisterCallback(self, "OnProfileChanged", function()
        self:Debug("OnProfileChanged")
        self:UpdateVisibility()
        self:Refresh()
    end)

    self.db.RegisterCallback(self, "OnProfileCopied", function()
        self:Debug("OnProfileCopied")
        self:UpdateVisibility()
        self:Refresh()
    end)

    self.db.RegisterCallback(self, "OnProfileReset", function()
        self:Debug("OnProfileReset")
        self:UpdateVisibility()
        self:Refresh()
    end)

    if self.configPanel then
        self:EnhanceControls(self.configPanel)

        self.configPanel.name = self.L["Kibs Item Level"]

        self.configPanel.okay = function()
            self:Debug("configPanel.okay")
            self.db.profile.Upgrades = self.configPanel.controls.Upgrades:GetChecked()
            self.db.profile.UpgradesSummary = self.configPanel.controls.UpgradesSummary:GetChecked()
            self.db.profile.Character = self.configPanel.controls.Character:GetChecked()
            self.db.profile.Inspection = self.configPanel.controls.Inspection:GetChecked()
            self.db.profile.Small = self.configPanel.controls.Small:GetChecked()
            self.db.profile.Color = self.configPanel.controls.Color:GetChecked()
            self.db.profile.Debug = self.configPanel.controls.Debug:GetChecked()
            self:UpdateVisibility()
            self:Refresh()
        end

        self.configPanel.cancel = function()
            self:Debug("configPanel.cancel")
        end

        self.configPanel.refresh = function()
            self:Debug("configPanel.refresh")
            self.configPanel.controls.Upgrades:SetChecked(self.db.profile.Upgrades)
            self.configPanel.controls.UpgradesSummary:SetChecked(self.db.profile.UpgradesSummary)
            self.configPanel.controls.Character:SetChecked(self.db.profile.Character)
            self.configPanel.controls.Inspection:SetChecked(self.db.profile.Inspection)
            self.configPanel.controls.Small:SetChecked(self.db.profile.Small)
            self.configPanel.controls.Color:SetChecked(self.db.profile.Color)
            self.configPanel.controls.Debug:SetChecked(self.db.profile.Debug)
        end

        self.configPanel.default = function()
            self:Debug("configPanel.default")
            self.db:ResetProfile()
        end

        InterfaceOptions_AddCategory(self.configPanel)
    end

    self:RegisterMessage("OnCharacterShow", function()
        self:Debug("OnCharacterShow")
        self.characterPaneVisible = true
        self:UpdateVisibility()
    end)

    self:RegisterMessage("OnCharacterHide", function()
        self:Debug("OnCharacterHide")
        self.characterPaneVisible = false
        self:UpdateVisibility()
    end)

    self:RegisterMessage("OnInspectorShow", function()
        self:Debug("OnInspectorShow")
        self.inspectorPaneVisible = true
        self:UpdateVisibility()
    end)

    self:RegisterMessage("OnInspectorHide", function()
        self:Debug("OnInspectorHide")
        self.inspectorPaneVisible = false
        self:UpdateVisibility()
    end)

    self:RegisterEvent("PLAYER_EQUIPMENT_CHANGED", function()
        self:Debug("PLAYER_EQUIPMENT_CHANGED")
        self:Refresh()
    end)

    self:RegisterEvent("SOCKET_INFO_CLOSE", function()
        self:Debug("SOCKET_INFO_CLOSE")
        self:Refresh()
    end)

    self:RegisterEvent("SOCKET_INFO_SUCCESS", function()
        self:Debug("SOCKET_INFO_SUCCESS")
        self:Refresh()
    end)

    self:RegisterEvent("SOCKET_INFO_UPDATE", function()
        self:Debug("SOCKET_INFO_UPDATE")
        self:Refresh()
    end)

    self:RegisterEvent("INSPECT_READY", function()
        self:Debug("INSPECT_READY")
        self:Refresh()
    end)

    local KIB_CONFLICT_FLAG = 'KIB_CONFLICT_FLAG'

    if _G[KIB_CONFLICT_FLAG] then
        local KIB_CONFLICT_DIALOG = 'KIB_CONFLICT_DIALOG'

        StaticPopupDialogs[KIB_CONFLICT_DIALOG] = {
            showAlert = true,
            text = self.L['Looks like both Kibs Item Level add-on and its Continued version are installed. They provide exactly the same functionality (they both updated to the latest version), and having them both is just a CPU/memory overhead and a source of UI glitches. Please, disable or uninstall one of them.'],
            button1 = "OK",
            timeout = 0,
            enterClicksFirstButton = true,
            hideOnEscape = true,
            preferredIndex = 3,
        }

        StaticPopup_Show(KIB_CONFLICT_DIALOG)
    else
        _G[KIB_CONFLICT_FLAG] = true
    end
end

function AddOn:UpdateVisibility()
    self:Debug("UpdateVisibility")
    self.playerSlotIconManager:SetHostVisibility(self.characterPaneVisible and self.db.profile.Character)
    self.inspectorSlotIconManager:SetHostVisibility(self.inspectorPaneVisible and self.db.profile.Inspection)
end

function AddOn:Refresh()
    self:Debug("Refresh")
    self:ApplyStyle()
    self.playerSlotIconManager:Refresh()
    self.inspectorSlotIconManager:Refresh()
end

function AddOn:ApplyStyle()
    self:Debug("ApplyStyle")

    local style = 0

    if self.db.profile.Small then
        style = style + addonNamespace.SlotIconManager.STYLE.SMALL
    end

    if self.db.profile.Upgrades then
        style = style + addonNamespace.SlotIconManager.STYLE.UPGRADES
    end

    self.playerSlotIconManager:SetStyle(style)
    self.inspectorSlotIconManager:SetStyle(style)
end

function AddOn:FindFrames(prefix)
    local result = {}

    if type(prefix) == "string" then
        local len = string.len(prefix)

        for name, ref in pairs(_G) do
            if ref and type(ref) == "table" and ref.GetObjectType and string.sub(name, 1, len) == prefix then
                result[name] = ref
            end
        end
    end

    return result
end

function AddOn:EnhanceControls(rootFrame)
    self:Debug("EnhanceControls")

    for name, frame in pairs(self:FindFrames(rootFrame:GetName())) do
        local type = frame:GetObjectType()

        if type == "FontString" then
            local text = frame:GetText()

            if text then
                frame:SetText(self.L[text])
            end
        elseif type == "CheckButton" then
            if frame.tooltipText then
                frame.tooltipText = self.L[frame.tooltipText]
            end

            local text = _G[name .. "Text"]

            frame.Disable = function(self)
                getmetatable(self).__index.Disable(self)
                text:SetTextColor(GRAY_FONT_COLOR.r, GRAY_FONT_COLOR.g, GRAY_FONT_COLOR.b)
            end

            frame.Enable = function(self)
                getmetatable(self).__index.Enable(self)
                text:SetTextColor(text:GetFontObject():GetTextColor())
            end
        end
    end
end

function AddOn:RegisterConfigPanel(frame)
    self:Debug("RegisterConfigPanel")
    self.configPanel = frame
end

function AddOn:Debug(...)
    if self.db and self.db.profile.Debug then
        self:Print(...)
    end
end
