/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.sound;

import jpcsp.HLE.Modules;
import jpcsp.sound.ISampleSource;
import jpcsp.sound.SampleSourceAtrac3;
import jpcsp.sound.SampleSourceEmpty;
import jpcsp.sound.SampleSourceMono;
import jpcsp.sound.SampleSourcePCM;
import jpcsp.sound.SampleSourceVAG;
import jpcsp.sound.SampleSourceWithADSR;
import jpcsp.sound.SampleSourceWithDelay;
import jpcsp.sound.SampleSourceWithPitch;
import jpcsp.sound.SoundVoice;
import org.apache.log4j.Logger;

public class SoftwareSynthesizer {
    public static Logger log = Logger.getLogger((String)"sound");
    private SoundVoice voice;
    private ISampleSource sampleSource;
    private static final int defaultDelay = 32;

    public SoftwareSynthesizer(SoundVoice voice) {
        this.voice = voice;
    }

    public ISampleSource getSampleSource() {
        if (this.sampleSource == null || this.voice.isChanged()) {
            this.voice.setChanged(false);
            if (this.voice.getAtracId() != null) {
                this.sampleSource = new SampleSourceAtrac3(this.voice.getAtracId());
            } else if (this.voice.getPcmAddress() != 0) {
                this.sampleSource = new SampleSourcePCM(this.voice, this.voice.getPcmAddress(), this.voice.getPcmSize(), this.voice.getLoopMode());
                if (Modules.sceSasCoreModule.getOutputMode() == 0) {
                    this.sampleSource = new SampleSourceMono(this.sampleSource);
                }
            } else if (this.voice.getVAGAddress() != 0) {
                this.sampleSource = new SampleSourceVAG(this.voice, this.voice.getVAGAddress(), this.voice.getVAGSize(), this.voice.getLoopMode() != 0);
                if (Modules.sceSasCoreModule.getOutputMode() == 0) {
                    this.sampleSource = new SampleSourceMono(this.sampleSource);
                }
            } else {
                this.sampleSource = new SampleSourceEmpty();
            }
            if (this.voice.getPitch() != 4096) {
                this.sampleSource = new SampleSourceWithPitch(this.sampleSource, this.voice.getPitch());
            }
            this.sampleSource = new SampleSourceWithADSR(this.sampleSource, this.voice, this.voice.getEnvelope());
            this.sampleSource = new SampleSourceWithDelay(this.sampleSource, 32);
        }
        return this.sampleSource;
    }
}

