/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.network.jpcsp;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import jpcsp.HLE.Modules;
import jpcsp.HLE.kernel.types.pspNetMacAddress;
import jpcsp.HLE.modules150.sceNetAdhoc;
import jpcsp.HLE.modules150.sceNetInet;
import jpcsp.HLE.modules150.sceUtility;
import jpcsp.hardware.Wlan;
import jpcsp.network.BaseNetworkAdapter;
import jpcsp.network.adhoc.AdhocMatchingEventMessage;
import jpcsp.network.adhoc.AdhocMessage;
import jpcsp.network.adhoc.MatchingObject;
import jpcsp.network.adhoc.PdpObject;
import jpcsp.network.adhoc.PtpObject;
import jpcsp.network.jpcsp.JpcspAdhocGameModeMessage;
import jpcsp.network.jpcsp.JpcspAdhocMatchingEventMessage;
import jpcsp.network.jpcsp.JpcspAdhocPdpMessage;
import jpcsp.network.jpcsp.JpcspAdhocPtpMessage;
import jpcsp.network.jpcsp.JpcspAdhocctlMessage;
import jpcsp.network.jpcsp.JpcspMatchingObject;
import jpcsp.network.jpcsp.JpcspPdpObject;
import jpcsp.network.jpcsp.JpcspPtpObject;

public class JpcspNetworkAdapter
extends BaseNetworkAdapter {
    private DatagramSocket adhocctlSocket;
    private static final int adhocctlBroadcastPort = 30000;

    @Override
    public void sceNetAdhocctlInit() {
    }

    @Override
    public void sceNetAdhocctlTerm() {
    }

    @Override
    public void sceNetAdhocctlConnect() {
    }

    @Override
    public void sceNetAdhocctlCreate() {
    }

    @Override
    public void sceNetAdhocctlJoin() {
    }

    @Override
    public void sceNetAdhocctlDisconnect() {
    }

    @Override
    public void sceNetAdhocctlScan() {
    }

    @Override
    public AdhocMessage createAdhocPdpMessage(int address, int length, byte[] destMacAddress) {
        return new JpcspAdhocPdpMessage(address, length, destMacAddress);
    }

    @Override
    public AdhocMessage createAdhocPdpMessage(byte[] message, int length) {
        return new JpcspAdhocPdpMessage(message, length);
    }

    @Override
    public PdpObject createPdpObject() {
        return new JpcspPdpObject(this);
    }

    @Override
    public PtpObject createPtpObject() {
        return new JpcspPtpObject(this);
    }

    @Override
    public AdhocMessage createAdhocPtpMessage(int address, int length) {
        return new JpcspAdhocPtpMessage(address, length, 3);
    }

    @Override
    public AdhocMessage createAdhocPtpMessage(byte[] message, int length) {
        return new JpcspAdhocPtpMessage(message, length);
    }

    @Override
    public AdhocMessage createAdhocGameModeMessage(sceNetAdhoc.GameModeArea gameModeArea) {
        return new JpcspAdhocGameModeMessage(gameModeArea);
    }

    @Override
    public AdhocMessage createAdhocGameModeMessage(byte[] message, int length) {
        return new JpcspAdhocGameModeMessage(message, length);
    }

    @Override
    public SocketAddress getSocketAddress(byte[] macAddress, int realPort) throws UnknownHostException {
        if (Modules.sceNetAdhocModule.hasNetPortShiftActive()) {
            return new InetSocketAddress(InetAddress.getLocalHost(), realPort);
        }
        return sceNetInet.getBroadcastInetSocketAddress(realPort)[0];
    }

    @Override
    public SocketAddress[] getMultiSocketAddress(byte[] macAddress, int realPort) throws UnknownHostException {
        if (Modules.sceNetAdhocModule.hasNetPortShiftActive()) {
            return super.getMultiSocketAddress(macAddress, realPort);
        }
        return sceNetInet.getBroadcastInetSocketAddress(realPort);
    }

    @Override
    public MatchingObject createMatchingObject() {
        return new JpcspMatchingObject(this);
    }

    @Override
    public AdhocMatchingEventMessage createAdhocMatchingEventMessage(MatchingObject matchingObject, int event) {
        return new JpcspAdhocMatchingEventMessage(matchingObject, event);
    }

    @Override
    public AdhocMatchingEventMessage createAdhocMatchingEventMessage(MatchingObject matchingObject, int event, int data, int dataLength, byte[] macAddress) {
        return new JpcspAdhocMatchingEventMessage(matchingObject, event, data, dataLength, macAddress);
    }

    @Override
    public AdhocMatchingEventMessage createAdhocMatchingEventMessage(MatchingObject matchingObject, byte[] message, int length) {
        return new JpcspAdhocMatchingEventMessage(matchingObject, message, length);
    }

    @Override
    public void sendChatMessage(String message) {
        log.warn((Object)String.format("Chat functionality not supported: %s", message));
    }

    @Override
    public boolean isConnectComplete() {
        return Modules.sceNetAdhocctlModule.getNumberPeers() > 0 || Modules.sceNetAdhocctlModule.hleNetAdhocctlGetState() == 0;
    }

    private void openSocket() throws SocketException {
        if (this.adhocctlSocket == null) {
            this.adhocctlSocket = new DatagramSocket(Modules.sceNetAdhocModule.getRealPortFromServerPort(30000));
            this.adhocctlSocket.setBroadcast(true);
            this.adhocctlSocket.setSoTimeout(1);
        }
    }

    private void broadcastPeers() {
        if (Modules.sceNetAdhocctlModule.hleNetAdhocctlGetGroupName() == null) {
            return;
        }
        try {
            this.openSocket();
            JpcspAdhocctlMessage adhocctlMessage = new JpcspAdhocctlMessage(sceUtility.getSystemParamNickname(), Wlan.getMacAddress(), Modules.sceNetAdhocctlModule.hleNetAdhocctlGetGroupName());
            if (Modules.sceNetAdhocctlModule.hleNetAdhocctlGetMode() == 1 && Modules.sceNetAdhocctlModule.hleNetAdhocctlGetRequiredGameModeMacs().size() > 0) {
                boolean gameModeComplete = Modules.sceNetAdhocctlModule.isGameModeComplete();
                adhocctlMessage.setGameModeComplete(gameModeComplete, Modules.sceNetAdhocctlModule.hleNetAdhocctlGetRequiredGameModeMacs());
            }
            SocketAddress[] socketAddress = Modules.sceNetAdhocModule.getMultiSocketAddress(sceNetAdhoc.ANY_MAC_ADDRESS, Modules.sceNetAdhocModule.getRealPortFromClientPort(sceNetAdhoc.ANY_MAC_ADDRESS, 30000));
            for (int i = 0; i < socketAddress.length; ++i) {
                DatagramPacket packet = new DatagramPacket(adhocctlMessage.getMessage(), JpcspAdhocctlMessage.getMessageLength(), socketAddress[i]);
                this.adhocctlSocket.send(packet);
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)String.format("broadcast sent to peer[%s]: %s", socketAddress[i], adhocctlMessage));
            }
        }
        catch (SocketException e) {
            log.error((Object)"broadcastPeers", (Throwable)e);
        }
        catch (IOException e) {
            log.error((Object)"broadcastPeers", (Throwable)e);
        }
    }

    private void pollPeers() {
        try {
            this.openSocket();
            while (true) {
                byte[][] macs;
                byte[] bytes = new byte[JpcspAdhocctlMessage.getMessageLength()];
                DatagramPacket packet = new DatagramPacket(bytes, bytes.length);
                this.adhocctlSocket.receive(packet);
                JpcspAdhocctlMessage adhocctlMessage = new JpcspAdhocctlMessage(packet.getData(), packet.getLength());
                if (log.isDebugEnabled()) {
                    log.debug((Object)String.format("broadcast received from peer: %s", adhocctlMessage));
                }
                if (sceNetAdhoc.isSameMacAddress(Wlan.getMacAddress(), adhocctlMessage.macAddress)) continue;
                if (adhocctlMessage.groupName.equals(Modules.sceNetAdhocctlModule.hleNetAdhocctlGetGroupName())) {
                    Modules.sceNetAdhocctlModule.hleNetAdhocctlAddPeer(adhocctlMessage.nickName, new pspNetMacAddress(adhocctlMessage.macAddress));
                }
                if (!adhocctlMessage.ibss.equals(Modules.sceNetAdhocctlModule.hleNetAdhocctlGetIBSS())) continue;
                Modules.sceNetAdhocctlModule.hleNetAdhocctlAddNetwork(adhocctlMessage.groupName, new pspNetMacAddress(adhocctlMessage.macAddress), adhocctlMessage.channel, adhocctlMessage.ibss, adhocctlMessage.mode);
                if (adhocctlMessage.mode != 1) continue;
                Modules.sceNetAdhocctlModule.hleNetAdhocctlAddGameModeMac(adhocctlMessage.macAddress);
                if (Modules.sceNetAdhocctlModule.hleNetAdhocctlGetRequiredGameModeMacs().size() > 0) continue;
                Modules.sceNetAdhocctlModule.hleNetAdhocctlSetGameModeJoinComplete(adhocctlMessage.gameModeComplete);
                if (!adhocctlMessage.gameModeComplete || (macs = adhocctlMessage.gameModeMacs) == null) continue;
                Modules.sceNetAdhocctlModule.hleNetAdhocctlSetGameModeMacs(macs);
            }
        }
        catch (SocketException e) {
            log.error((Object)"broadcastPeers", (Throwable)e);
        }
        catch (SocketTimeoutException e) {
        }
        catch (IOException e) {
            log.error((Object)"broadcastPeers", (Throwable)e);
        }
    }

    @Override
    public void updatePeers() {
        this.broadcastPeers();
        this.pollPeers();
    }
}

