/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.memory;

import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import jpcsp.memory.FastMemory;

public class SafeFastMemory
extends FastMemory {
    private boolean isAddressGood(int address, int length) {
        return SafeFastMemory.isAddressGood(address) && SafeFastMemory.isAddressGood(address + length - 1);
    }

    @Override
    public int read8(int address) {
        if (!SafeFastMemory.isAddressGood(address)) {
            int normalizedAddress = SafeFastMemory.normalizeAddress(address);
            if (SafeFastMemory.isRawAddressGood(normalizedAddress)) {
                address = normalizedAddress;
            } else {
                this.invalidMemoryAddress(address, "read8", 4);
                return 0;
            }
        }
        return super.read8(address);
    }

    @Override
    public int read16(int address) {
        if (!SafeFastMemory.isAddressGood(address)) {
            int normalizedAddress = SafeFastMemory.normalizeAddress(address);
            if (SafeFastMemory.isRawAddressGood(normalizedAddress)) {
                address = normalizedAddress;
            } else {
                this.invalidMemoryAddress(address, "read16", 4);
                return 0;
            }
        }
        return super.read16(address);
    }

    @Override
    public int read32(int address) {
        if (!SafeFastMemory.isAddressGood(address)) {
            if (this.read32AllowedInvalidAddress(address)) {
                return 0;
            }
            int normalizedAddress = SafeFastMemory.normalizeAddress(address);
            if (SafeFastMemory.isRawAddressGood(normalizedAddress)) {
                address = normalizedAddress;
            } else {
                this.invalidMemoryAddress(address, "read32", 4);
                return 0;
            }
        }
        return super.read32(address);
    }

    @Override
    public long read64(int address) {
        if (!SafeFastMemory.isAddressGood(address)) {
            int normalizedAddress = SafeFastMemory.normalizeAddress(address);
            if (SafeFastMemory.isRawAddressGood(normalizedAddress)) {
                address = normalizedAddress;
            } else {
                this.invalidMemoryAddress(address, "read64", 4);
                return 0L;
            }
        }
        return super.read64(address);
    }

    @Override
    public void write8(int address, byte data) {
        if (!SafeFastMemory.isAddressGood(address)) {
            int normalizedAddress = SafeFastMemory.normalizeAddress(address);
            if (SafeFastMemory.isRawAddressGood(normalizedAddress)) {
                address = normalizedAddress;
            } else {
                this.invalidMemoryAddress(address, "write8", 8);
                return;
            }
        }
        super.write8(address, data);
    }

    @Override
    public void write16(int address, short data) {
        if (!SafeFastMemory.isAddressGood(address)) {
            int normalizedAddress = SafeFastMemory.normalizeAddress(address);
            if (SafeFastMemory.isRawAddressGood(normalizedAddress)) {
                address = normalizedAddress;
            } else {
                this.invalidMemoryAddress(address, "write16", 8);
                return;
            }
        }
        super.write16(address, data);
    }

    @Override
    public void write32(int address, int data) {
        if (!SafeFastMemory.isAddressGood(address)) {
            int normalizedAddress = SafeFastMemory.normalizeAddress(address);
            if (SafeFastMemory.isRawAddressGood(normalizedAddress)) {
                address = normalizedAddress;
            } else {
                this.invalidMemoryAddress(address, "write32", 8);
                return;
            }
        }
        super.write32(address, data);
    }

    @Override
    public void write64(int address, long data) {
        if (!SafeFastMemory.isAddressGood(address)) {
            int normalizedAddress = SafeFastMemory.normalizeAddress(address);
            if (SafeFastMemory.isRawAddressGood(normalizedAddress)) {
                address = normalizedAddress;
            } else {
                this.invalidMemoryAddress(address, "write64", 8);
                return;
            }
        }
        super.write64(address, data);
    }

    @Override
    public void memset(int address, byte data, int length) {
        if (length <= 0) {
            return;
        }
        if (!this.isAddressGood(address, length)) {
            this.invalidMemoryAddress(address, "memset", 8);
            return;
        }
        super.memset(address, data, length);
    }

    @Override
    public void copyToMemory(int address, ByteBuffer source, int length) {
        if (!this.isAddressGood(address, length)) {
            this.invalidMemoryAddress(address, "copyToMemory", 8);
            return;
        }
        super.copyToMemory(address, source, length);
    }

    @Override
    public IntBuffer getBuffer(int address, int length) {
        if (!(this.isAddressGood(address, length) || SafeFastMemory.isAddressGood(address) && address >= 0x4000000 && address <= 0x41FFFFF)) {
            this.invalidMemoryAddress(address, "getBuffer", 4);
            return null;
        }
        return super.getBuffer(address, length);
    }

    @Override
    public void memcpy(int destination, int source, int length, boolean checkOverlap) {
        if (length <= 0) {
            return;
        }
        if (!this.isAddressGood(destination, length)) {
            this.invalidMemoryAddress(destination, length, "memcpy", 8);
            return;
        }
        if (!this.isAddressGood(source, length)) {
            this.invalidMemoryAddress(source, length, "memcpy", 4);
            return;
        }
        super.memcpy(destination, source, length, checkOverlap);
    }
}

