/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.media;

import jpcsp.HLE.VFS.IVirtualFile;
import jpcsp.media.IMediaChannel;
import org.apache.log4j.Logger;

public class VirtualFileProtocolHandler
implements IMediaChannel {
    private static Logger log = Logger.getLogger((String)"VirtualFileProtocolHandler");
    private IVirtualFile vFile;
    private int readLength;

    public VirtualFileProtocolHandler(IVirtualFile vFile) {
        this.vFile = vFile;
    }

    public int close() {
        log.debug((Object)"close");
        if (this.vFile != null) {
            this.vFile.ioClose();
            this.vFile = null;
        }
        return 0;
    }

    public boolean isStreamed(String url, int flags) {
        return false;
    }

    public int open(String url, int flags) {
        if (this.vFile == null) {
            return -1;
        }
        return 0;
    }

    public int read(byte[] buf, int size) {
        int result;
        if (this.vFile == null) {
            return -1;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("read size=0x%X", size));
        }
        if ((result = this.vFile.ioRead(buf, 0, size)) < 0) {
            return -1;
        }
        this.readLength += result;
        return result;
    }

    public long seek(long offset, int whence) {
        long seek;
        if (this.vFile == null) {
            return -1L;
        }
        switch (whence) {
            case 0: {
                seek = offset;
                break;
            }
            case 1: {
                seek = this.vFile.getPosition() + offset;
                break;
            }
            case 2: {
                seek = this.vFile.length() + offset;
                break;
            }
            case 65536: {
                if (log.isDebugEnabled()) {
                    log.debug((Object)String.format("seek SEEK_SIZE returning 0x%X", this.vFile.length()));
                }
                return this.vFile.length();
            }
            default: {
                return -1L;
            }
        }
        long result = this.vFile.ioLseek(seek);
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("seek offset=0x%X, whence=%d, returning 0x%X, seek position 0x%X", offset, whence, result, seek));
        }
        if (result < 0L) {
            return -1L;
        }
        return result;
    }

    public int write(byte[] buf, int size) {
        int result;
        if (this.vFile == null) {
            return -1;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("write size=0x%X", size));
        }
        if ((result = this.vFile.ioWrite(buf, 0, size)) < 0) {
            return -1;
        }
        return result;
    }

    @Override
    public int getReadLength() {
        return this.readLength;
    }

    @Override
    public void setReadLength(int readLength) {
        this.readLength = readLength;
    }
}

