/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.hardware;

import java.util.Random;
import jpcsp.HLE.modules150.sceNet;
import jpcsp.HLE.modules150.sceUtility;
import jpcsp.settings.Settings;

public class Wlan {
    public static int PSP_WLAN_SWITCH_OFF = 0;
    public static int PSP_WLAN_SWITCH_ON;
    private static int switchState;
    public static final int MAC_ADDRESS_LENGTH = 6;
    private static byte[] macAddress;
    private static final String settingsMacAddress = "macAddress";
    public static int PSP_ADHOC_CHANNEL_AUTO;
    public static int PSP_ADHOC_CHANNEL_DEFAULT;
    private static int signalStrength;

    public static void initialize() {
        String macAddressString = Settings.getInstance().readString(settingsMacAddress);
        if (macAddressString == null || macAddressString.length() <= 0) {
            Random random = new Random();
            for (int i = 0; i < macAddress.length; ++i) {
                Wlan.macAddress[i] = (byte)random.nextInt(256);
            }
            macAddress[0] = (byte)(macAddress[0] & 0xFC);
        } else {
            macAddress = sceNet.convertStringToMacAddress(macAddressString);
            macAddress[0] = (byte)(macAddress[0] & 0xFC);
        }
    }

    public static int getSwitchState() {
        return switchState;
    }

    public static void setSwitchState(int switchState) {
        Wlan.switchState = switchState;
    }

    public static byte[] getMacAddress() {
        return macAddress;
    }

    public static void setMacAddress(byte[] newMacAddress) {
        System.arraycopy(newMacAddress, 0, macAddress, 0, 6);
    }

    public static int getAdhocChannel() {
        int channel = sceUtility.getSystemParamAdhocChannel();
        if (channel == PSP_ADHOC_CHANNEL_AUTO) {
            channel = PSP_ADHOC_CHANNEL_DEFAULT;
        }
        return channel;
    }

    public static int getSignalStrenth() {
        return signalStrength;
    }

    static {
        switchState = PSP_WLAN_SWITCH_ON = 1;
        macAddress = new byte[]{1, 2, 3, 4, 5, 6};
        PSP_ADHOC_CHANNEL_AUTO = 0;
        PSP_ADHOC_CHANNEL_DEFAULT = 11;
        signalStrength = 100;
    }
}

