/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.crypto;

import java.nio.ByteBuffer;
import jpcsp.crypto.KIRK;
import jpcsp.crypto.KeyVault;

public class AMCTRL {
    private static KIRK kirk;

    public AMCTRL() {
        kirk = new KIRK();
    }

    private void ScrambleBB(byte[] buf, int size, int seed, int cbc, int kirk_code) {
        buf[0] = 0;
        buf[1] = 0;
        buf[2] = 0;
        buf[3] = (byte)cbc;
        buf[4] = 0;
        buf[5] = 0;
        buf[6] = 0;
        buf[7] = 0;
        buf[8] = 0;
        buf[9] = 0;
        buf[10] = 0;
        buf[11] = 0;
        buf[12] = 0;
        buf[13] = 0;
        buf[14] = 0;
        buf[15] = (byte)seed;
        buf[16] = (byte)(size >> 24 & 0xFF);
        buf[17] = (byte)(size >> 16 & 0xFF);
        buf[18] = (byte)(size >> 8 & 0xFF);
        buf[19] = (byte)(size & 0xFF);
        ByteBuffer bBuf = ByteBuffer.wrap(buf);
        kirk.hleUtilsBufferCopyWithRange(bBuf, size, bBuf, size, kirk_code);
    }

    public byte[] DecryptBBMacKey(byte[] key) {
        byte[] scrambleBuf = new byte[36];
        byte[] decKey = new byte[16];
        System.arraycopy(key, 0, scrambleBuf, 20, 16);
        this.ScrambleBB(scrambleBuf, 16, 99, 5, 7);
        System.arraycopy(scrambleBuf, 0, decKey, 0, 16);
        return decKey;
    }

    public int GetKeyFromBBMac(BBMac_Ctx ctx, byte[] bbmac, byte[] key) {
        byte[] tmpBuf = new byte[16];
        byte[] scrambleBuf = new byte[36];
        byte[] decKey = new byte[16];
        byte[] scrambleDecBuf = new byte[36];
        byte[] finalKey = new byte[16];
        this.hleDrmBBMacFinal(ctx, tmpBuf, null);
        if ((ctx.mode & 3) == 3) {
            System.arraycopy(bbmac, 0, scrambleBuf, 20, 16);
            this.ScrambleBB(scrambleBuf, 16, 99, 5, 7);
            System.arraycopy(scrambleBuf, 0, decKey, 0, 16);
        } else {
            System.arraycopy(bbmac, 0, decKey, 0, 16);
        }
        int seed = 56;
        if ((ctx.mode & 2) == 2) {
            seed = 58;
        }
        System.arraycopy(decKey, 0, scrambleDecBuf, 20, 16);
        this.ScrambleBB(scrambleDecBuf, 16, seed, 5, 7);
        System.arraycopy(scrambleDecBuf, 0, finalKey, 0, 16);
        for (int i = 0; i < 16; ++i) {
            key[i] = (byte)(tmpBuf[i] ^ finalKey[i]);
        }
        return 0;
    }

    public int hleDrmBBMacInit(BBMac_Ctx ctx, int encMode) {
        ctx.mode = encMode;
        return 0;
    }

    public int hleDrmBBMacUpdate(BBMac_Ctx ctx, byte[] data, int length) {
        if (ctx.padSize > 16) {
            return -1;
        }
        if (ctx.padSize + length <= 16) {
            System.arraycopy(data, 0, ctx.pad, ctx.padSize, length);
            ctx.padSize += length;
            return 0;
        }
        int seed = 56;
        if (ctx.mode == 2) {
            seed = 58;
        }
        byte[] scrambleBuf = new byte[length + ctx.padSize + 20];
        System.arraycopy(ctx.pad, 0, scrambleBuf, 20, ctx.padSize);
        int kLen = ctx.padSize;
        ctx.padSize += length;
        ctx.padSize &= 15;
        if (ctx.padSize == 0) {
            ctx.padSize = 16;
        }
        System.arraycopy(data, length -= ctx.padSize, ctx.pad, 0, ctx.padSize);
        int blockSize = 0;
        int dataOffset = 0;
        while (length > 0) {
            blockSize = length + kLen >= 2048 ? 2048 : length + kLen;
            System.arraycopy(data, dataOffset, scrambleBuf, 20 + kLen, blockSize - kLen);
            for (int i = 0; i < 16; ++i) {
                scrambleBuf[20 + i] = (byte)(scrambleBuf[20 + i] ^ ctx.key[i]);
            }
            this.ScrambleBB(scrambleBuf, blockSize, seed, 4, 4);
            System.arraycopy(scrambleBuf, blockSize + 4 - 20, ctx.key, 0, 16);
            length -= blockSize - kLen;
            dataOffset += blockSize - kLen;
            kLen = 0;
        }
        return 0;
    }

    public int hleDrmBBMacFinal(BBMac_Ctx ctx, byte[] hash, byte[] key) {
        int b2;
        int b1;
        int i;
        if (ctx.padSize > 16) {
            return -1;
        }
        byte[] scrambleEmptyBuf = new byte[36];
        byte[] keyBuf = new byte[16];
        byte[] scrambleKeyBuf = new byte[36];
        byte[] resultBuf = new byte[16];
        byte[] scrambleResultBuf = new byte[36];
        byte[] scrambleResultKeyBuf = new byte[36];
        byte[] scrambleResultKeyBuf2 = new byte[36];
        int seed = 56;
        if (ctx.mode == 2) {
            seed = 58;
        }
        this.ScrambleBB(scrambleEmptyBuf, 16, seed, 4, 4);
        System.arraycopy(scrambleEmptyBuf, 0, keyBuf, 0, 16);
        int b = (keyBuf[0] & 0x80) == 128 ? 135 : 0;
        for (i = 0; i < 15; ++i) {
            b1 = keyBuf[i + 0] & 0xFF;
            b2 = keyBuf[i + 1] & 0xFF;
            b1 = b1 << 1 & 0xFF;
            b2 = b2 >> 7 & 0xFF;
            b2 = (b2 | b1) & 0xFF;
            keyBuf[i + 0] = (byte)(b2 & 0xFF);
        }
        int b3 = keyBuf[15] & 0xFF;
        b3 = b3 << 1 & 0xFF;
        b3 = (b3 ^ b) & 0xFF;
        keyBuf[15] = (byte)(b3 & 0xFF);
        if (ctx.padSize < 16) {
            b = (keyBuf[0] & 0x80) == 128 ? 135 : 0;
            for (i = 0; i < 15; ++i) {
                b1 = keyBuf[i + 0] & 0xFF;
                b2 = keyBuf[i + 1] & 0xFF;
                b1 = b1 << 1 & 0xFF;
                b2 = b2 >> 7 & 0xFF;
                b2 = (b2 | b1) & 0xFF;
                keyBuf[i + 0] = (byte)(b2 & 0xFF);
            }
            b3 = keyBuf[15] & 0xFF;
            b3 = b3 << 1 & 0xFF;
            b3 = (b3 ^ b) & 0xFF;
            keyBuf[15] = (byte)(b3 & 0xFF);
            ((BBMac_Ctx)ctx).pad[((BBMac_Ctx)ctx).padSize] = -128;
            if (ctx.padSize + 1 < 16) {
                for (i = 0; i < 16 - ctx.padSize - 1; ++i) {
                    ((BBMac_Ctx)ctx).pad[((BBMac_Ctx)ctx).padSize + 1 + i] = 0;
                }
            }
        }
        for (i = 0; i < 16; ++i) {
            ((BBMac_Ctx)ctx).pad[i] = (byte)(ctx.pad[i] & 0xFF ^ keyBuf[i] & 0xFF);
        }
        System.arraycopy(ctx.pad, 0, scrambleKeyBuf, 20, 16);
        System.arraycopy(ctx.key, 0, resultBuf, 0, 16);
        for (i = 0; i < 16; ++i) {
            scrambleKeyBuf[20 + i] = (byte)(scrambleKeyBuf[20 + i] ^ resultBuf[i]);
        }
        this.ScrambleBB(scrambleKeyBuf, 16, seed, 4, 4);
        System.arraycopy(scrambleKeyBuf, 0, resultBuf, 0, 16);
        for (i = 0; i < 16; ++i) {
            resultBuf[i] = (byte)(resultBuf[i] ^ KeyVault.amHashKey3[i]);
        }
        if (ctx.mode == 2) {
            System.arraycopy(resultBuf, 0, scrambleResultBuf, 20, 16);
            this.ScrambleBB(scrambleResultBuf, 16, 256, 4, 5);
            System.arraycopy(scrambleResultBuf, 0, scrambleResultKeyBuf2, 20, 16);
            this.ScrambleBB(scrambleResultKeyBuf2, 16, seed, 4, 4);
            System.arraycopy(scrambleResultKeyBuf2, 0, resultBuf, 0, 16);
        }
        if (key != null) {
            for (i = 0; i < 16; ++i) {
                resultBuf[i] = (byte)(resultBuf[i] ^ key[i]);
            }
            System.arraycopy(resultBuf, 0, scrambleResultKeyBuf, 20, 16);
            this.ScrambleBB(scrambleResultKeyBuf, 16, seed, 4, 4);
            System.arraycopy(scrambleResultKeyBuf, 0, resultBuf, 0, 16);
        }
        System.arraycopy(resultBuf, 0, hash, 0, 16);
        ctx.mode = 0;
        ctx.padSize = 0;
        for (i = 0; i < 16; ++i) {
            ((BBMac_Ctx)ctx).pad[i] = 0;
        }
        for (i = 0; i < 16; ++i) {
            ((BBMac_Ctx)ctx).key[i] = 0;
        }
        return 0;
    }

    public int hleDrmBBMacFinal2(BBMac_Ctx ctx, byte[] hash, byte[] key) {
        byte[] resBuf = new byte[16];
        byte[] hashBuf = new byte[16];
        int mode = ctx.mode;
        this.hleDrmBBMacFinal(ctx, resBuf, key);
        hashBuf = (mode & 3) == 3 ? this.DecryptBBMacKey(hash) : hash;
        for (int i = 0; i < 16; ++i) {
            if (hashBuf[i] == resBuf[i]) continue;
            return -1;
        }
        return 0;
    }

    public int hleDrmBBCipherInit(BBCipher_Ctx ctx, int encMode, int genMode, byte[] data, byte[] key, int seed) {
        if (key.length < 16) {
            return -1;
        }
        ctx.mode = encMode;
        ctx.seed = 1;
        if (genMode == 1) {
            int i;
            byte[] header = new byte[36];
            byte[] random = new byte[20];
            byte[] newKey = new byte[16];
            ctx.seed = 1;
            ByteBuffer bRandom = ByteBuffer.wrap(random);
            kirk.hleUtilsBufferCopyWithRange(bRandom, 20, null, 0, 14);
            for (i = 15; i >= 0; --i) {
                newKey[15 - i] = random[i];
            }
            System.arraycopy(newKey, 0, header, 20, 16);
            for (i = 0; i < 4; ++i) {
                header[32 + i] = 0;
            }
            if (ctx.mode == 1) {
                for (i = 0; i < 16; ++i) {
                    header[20 + i] = (byte)(header[20 + i] ^ KeyVault.amHashKey4[i]);
                }
                this.ScrambleBB(header, 16, 57, 4, 4);
                for (i = 0; i < 16; ++i) {
                    header[i] = (byte)(header[i] ^ KeyVault.amHashKey5[i]);
                }
                System.arraycopy(header, 0, ctx.buf, 0, 16);
                System.arraycopy(header, 0, data, 0, 16);
                if (key != null) {
                    for (i = 0; i < 16; ++i) {
                        ((BBCipher_Ctx)ctx).buf[i] = (byte)(ctx.buf[i] ^ key[i]);
                    }
                }
                return 0;
            }
            if (ctx.mode == 2) {
                for (i = 0; i < 16; ++i) {
                    header[20 + i] = (byte)(header[20 + i] ^ KeyVault.amHashKey4[i]);
                }
                this.ScrambleBB(header, 16, 256, 4, 5);
                for (i = 0; i < 16; ++i) {
                    header[i] = (byte)(header[i] ^ KeyVault.amHashKey5[i]);
                }
                System.arraycopy(header, 0, ctx.buf, 0, 16);
                System.arraycopy(header, 0, data, 0, 16);
                if (key != null) {
                    for (i = 0; i < 16; ++i) {
                        ((BBCipher_Ctx)ctx).buf[i] = (byte)(ctx.buf[i] ^ key[i]);
                    }
                }
                return 0;
            }
            return -1;
        }
        if (genMode == 2) {
            ctx.seed = seed + 1;
            System.arraycopy(data, 0, ctx.buf, 0, 16);
            if (key != null) {
                for (int i = 0; i < 16; ++i) {
                    ((BBCipher_Ctx)ctx).buf[i] = (byte)(ctx.buf[i] ^ key[i]);
                }
            }
            return 0;
        }
        return -1;
    }

    public int hleDrmBBCipherUpdate(BBCipher_Ctx ctx, byte[] data, int length) {
        int i;
        if (length <= 0) {
            return -1;
        }
        byte[] dataBuf = new byte[length + 20];
        byte[] keyBuf = new byte[32];
        byte[] hashBuf = new byte[16];
        System.arraycopy(ctx.buf, 0, dataBuf, 20, 16);
        if (ctx.mode == 1) {
            for (i = 0; i < 16; ++i) {
                dataBuf[20 + i] = (byte)(dataBuf[20 + i] ^ KeyVault.amHashKey5[i]);
            }
            this.ScrambleBB(dataBuf, 16, 57, 5, 7);
            for (i = 0; i < 16; ++i) {
                dataBuf[i] = (byte)(dataBuf[i] ^ KeyVault.amHashKey4[i]);
            }
        } else if (ctx.mode == 2) {
            for (i = 0; i < 16; ++i) {
                dataBuf[20 + i] = (byte)(dataBuf[20 + i] ^ KeyVault.amHashKey5[i]);
            }
            this.ScrambleBB(dataBuf, 16, 256, 5, 8);
            for (i = 0; i < 16; ++i) {
                dataBuf[i] = (byte)(dataBuf[i] ^ KeyVault.amHashKey4[i]);
            }
        }
        System.arraycopy(dataBuf, 0, keyBuf, 16, 16);
        if (ctx.seed != 1) {
            System.arraycopy(keyBuf, 16, keyBuf, 0, 12);
            keyBuf[12] = (byte)(ctx.seed - 1 & 0xFF);
            keyBuf[13] = (byte)(ctx.seed - 1 >> 8 & 0xFF);
            keyBuf[14] = (byte)(ctx.seed - 1 >> 16 & 0xFF);
            keyBuf[15] = (byte)(ctx.seed - 1 >> 24 & 0xFF);
        }
        for (i = 20; i < length + 20; i += 16) {
            System.arraycopy(keyBuf, 16, dataBuf, i, 12);
            dataBuf[i + 12] = (byte)(ctx.seed & 0xFF);
            dataBuf[i + 13] = (byte)(ctx.seed >> 8 & 0xFF);
            dataBuf[i + 14] = (byte)(ctx.seed >> 16 & 0xFF);
            dataBuf[i + 15] = (byte)(ctx.seed >> 24 & 0xFF);
            ctx.seed++;
        }
        System.arraycopy(dataBuf, length + 4, hashBuf, 0, 16);
        this.ScrambleBB(dataBuf, length, 99, 5, 7);
        for (i = 0; i < 16; ++i) {
            dataBuf[i] = (byte)(dataBuf[i] ^ keyBuf[i]);
        }
        System.arraycopy(hashBuf, 0, keyBuf, 0, 16);
        for (i = 0; i < length; ++i) {
            data[i] = (byte)(data[i] ^ dataBuf[i]);
        }
        return 0;
    }

    public int hleDrmBBCipherFinal(BBCipher_Ctx ctx) {
        ctx.mode = 0;
        ctx.seed = 0;
        for (int i = 0; i < 16; ++i) {
            ((BBCipher_Ctx)ctx).buf[i] = 0;
        }
        return 0;
    }

    public static class BBMac_Ctx {
        private int mode = 0;
        private byte[] key = new byte[16];
        private byte[] pad = new byte[16];
        private int padSize = 0;
    }

    public static class BBCipher_Ctx {
        private int mode = 0;
        private int seed = 0;
        private byte[] buf = new byte[16];
    }
}

