/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.HLE.modules150;

import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import jpcsp.HLE.HLEFunction;
import jpcsp.HLE.HLELogging;
import jpcsp.HLE.Modules;
import jpcsp.HLE.PspString;
import jpcsp.HLE.TPointer;
import jpcsp.HLE.kernel.types.IWaitStateChecker;
import jpcsp.HLE.kernel.types.SceKernelCallbackInfo;
import jpcsp.HLE.kernel.types.SceKernelThreadInfo;
import jpcsp.HLE.kernel.types.ThreadWaitInfo;
import jpcsp.HLE.kernel.types.pspUmdInfo;
import jpcsp.HLE.modules.HLEModule;
import jpcsp.HLE.modules.ThreadManForUser;
import jpcsp.filesystems.umdiso.UmdIsoReader;
import org.apache.log4j.Logger;

@HLELogging
public class sceUmdUser
extends HLEModule {
    public static Logger log = Modules.getLogger("sceUmdUser");
    protected static final int PSP_UMD_INIT = 0;
    protected static final int PSP_UMD_NOT_PRESENT = 1;
    protected static final int PSP_UMD_PRESENT = 2;
    protected static final int PSP_UMD_CHANGED = 4;
    protected static final int PSP_UMD_NOT_READY = 8;
    protected static final int PSP_UMD_READY = 16;
    protected static final int PSP_UMD_READABLE = 32;
    protected UmdIsoReader iso;
    protected boolean umdActivated;
    protected boolean umdDeactivateCalled;
    protected List<SceKernelThreadInfo> waitingThreads;
    protected int umdErrorStat;
    protected UmdWaitStateChecker umdWaitStateChecker;

    @Override
    public String getName() {
        return "sceUmdUser";
    }

    @Override
    public void start() {
        this.setUmdActivated();
        this.umdDeactivateCalled = false;
        this.waitingThreads = new LinkedList<SceKernelThreadInfo>();
        this.umdErrorStat = 0;
        this.umdWaitStateChecker = new UmdWaitStateChecker();
        super.start();
    }

    public void setIsoReader(UmdIsoReader iso) {
        this.iso = iso;
        this.setUmdActivated();
    }

    public void setUmdErrorStat(int stat) {
        this.umdErrorStat = stat;
    }

    public int getUmdErrorStat() {
        return this.umdErrorStat;
    }

    private void setUmdActivated() {
        this.umdActivated = this.iso != null;
        Modules.IoFileMgrForUserModule.registerUmdIso();
    }

    public boolean isUmdActivated() {
        return this.umdActivated;
    }

    public int getUmdStat() {
        int stat;
        if (this.iso != null) {
            stat = 18;
            if (this.umdActivated) {
                stat |= 0x20;
            }
        } else {
            stat = 1;
            if (this.umdDeactivateCalled) {
                stat |= 8;
            }
        }
        return stat;
    }

    protected boolean checkDriveStat(int wantedStat) {
        int currentStat = this.getUmdStat();
        return (currentStat & wantedStat) != 0;
    }

    protected void removeWaitingThread(SceKernelThreadInfo thread) {
        ListIterator<SceKernelThreadInfo> lit = this.waitingThreads.listIterator();
        while (lit.hasNext()) {
            SceKernelThreadInfo waitingThread = lit.next();
            if (waitingThread.uid != thread.uid) continue;
            lit.remove();
            break;
        }
    }

    public void onThreadWaitTimeout(SceKernelThreadInfo thread) {
        log.info((Object)"UMD stat timedout");
        this.removeWaitingThread(thread);
        thread.cpuContext._v0 = -2147352152;
    }

    public void onThreadWaitReleased(SceKernelThreadInfo thread) {
        log.info((Object)"UMD stat released");
        this.removeWaitingThread(thread);
        thread.cpuContext._v0 = -2147352150;
    }

    public void onThreadDeleted(SceKernelThreadInfo thread) {
        if (thread.waitType == 257) {
            this.removeWaitingThread(thread);
        }
    }

    protected void checkWaitingThreads() {
        ListIterator<SceKernelThreadInfo> lit = this.waitingThreads.listIterator();
        while (lit.hasNext()) {
            SceKernelThreadInfo waitingThread = lit.next();
            if (waitingThread.status != 4) continue;
            int wantedUmdStat = waitingThread.wait.wantedUmdStat;
            if (waitingThread.waitType != 257 || !this.checkDriveStat(wantedUmdStat)) continue;
            if (log.isDebugEnabled()) {
                log.debug((Object)("sceUmdUser - checkWaitingThreads waking " + Integer.toHexString(waitingThread.uid) + " thread:'" + waitingThread.name + "'"));
            }
            lit.remove();
            waitingThread.cpuContext._v0 = 0;
            Modules.ThreadManForUserModule.hleChangeThreadState(waitingThread, 2);
        }
    }

    protected int hleUmdWaitDriveStat(int wantedStat, boolean doCallbacks, boolean doTimeout, int timeout) {
        ThreadManForUser threadMan = Modules.ThreadManForUserModule;
        if (!this.checkDriveStat(wantedStat)) {
            SceKernelThreadInfo currentThread = threadMan.getCurrentThread();
            currentThread.wait.wantedUmdStat = wantedStat;
            this.waitingThreads.add(currentThread);
            threadMan.hleKernelThreadEnterWaitState(currentThread, 257, -1, this.umdWaitStateChecker, timeout, !doTimeout, doCallbacks);
        }
        threadMan.hleRescheduleCurrentThread(doCallbacks);
        return 0;
    }

    protected int getNotificationArg() {
        int notifyArg;
        if (this.iso != null) {
            notifyArg = 34;
            if (Modules.SysMemUserForUserModule.hleKernelGetCompiledSdkVersion() != 0) {
                notifyArg |= 0x10;
            }
        } else {
            notifyArg = 9;
        }
        return notifyArg;
    }

    @HLEFunction(nid=1189852969, version=150)
    public boolean sceUmdCheckMedium() {
        return this.iso != null;
    }

    @HLEFunction(nid=-971489977, version=150, checkInsideInterrupt=true)
    public int sceUmdActivate(int mode, PspString drive) {
        this.umdActivated = true;
        Modules.IoFileMgrForUserModule.registerUmdIso();
        int notifyArg = this.getNotificationArg();
        Modules.ThreadManForUserModule.hleKernelNotifyCallback(0, notifyArg);
        this.checkWaitingThreads();
        return 0;
    }

    @HLEFunction(nid=-399031622, version=150, checkInsideInterrupt=true)
    public int sceUmdDeactivate(int mode, PspString drive) {
        boolean triggerCallback = this.umdActivated;
        this.umdActivated = false;
        Modules.IoFileMgrForUserModule.registerUmdIso();
        this.umdDeactivateCalled = true;
        if (triggerCallback) {
            int notifyArg = this.iso != null ? 18 : 9;
            Modules.ThreadManForUserModule.hleKernelNotifyCallback(0, notifyArg);
        }
        this.checkWaitingThreads();
        return 0;
    }

    @HLEFunction(nid=-1896837170, version=150, checkInsideInterrupt=true)
    public int sceUmdWaitDriveStat(int wantedStat) {
        return this.hleUmdWaitDriveStat(wantedStat, false, false, 0);
    }

    @HLEFunction(nid=1444948339, version=150, checkInsideInterrupt=true)
    public int sceUmdWaitDriveStatWithTimer(int wantedStat, int timeout) {
        return this.hleUmdWaitDriveStat(wantedStat, false, true, timeout);
    }

    @HLEFunction(nid=1251892777, version=150, checkInsideInterrupt=true)
    public int sceUmdWaitDriveStatCB(int wantedStat, int timeout) {
        return this.hleUmdWaitDriveStat(wantedStat, true, true, timeout);
    }

    @HLEFunction(nid=1794749706, version=150)
    public int sceUmdCancelWaitDriveStat() {
        ThreadManForUser threadMan = Modules.ThreadManForUserModule;
        ListIterator<SceKernelThreadInfo> lit = this.waitingThreads.listIterator();
        while (lit.hasNext()) {
            SceKernelThreadInfo waitingThread = lit.next();
            if (!waitingThread.isWaiting() || waitingThread.waitType != 257) {
                log.warn((Object)String.format("sceUmdCancelWaitDriveStat thread %s not waiting on umd", waitingThread));
                continue;
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("sceUmdCancelWaitDriveStat waking thread %s", waitingThread));
            }
            lit.remove();
            waitingThread.cpuContext._v0 = -2147352151;
            threadMan.hleChangeThreadState(waitingThread, 2);
        }
        return 0;
    }

    @HLEFunction(nid=1800017004, version=150)
    public int sceUmdGetDriveStat() {
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("sceUmdGetDriveStat returning 0x%X", this.getUmdStat()));
        }
        return this.getUmdStat();
    }

    @HLEFunction(nid=543329903, version=150)
    public int sceUmdGetErrorStat() {
        return this.getUmdErrorStat();
    }

    @HLEFunction(nid=873166470, version=150, checkInsideInterrupt=true)
    public int sceUmdGetDiscInfo(TPointer pspUmdInfoAddr) {
        pspUmdInfo umdInfo = new pspUmdInfo();
        umdInfo.read(pspUmdInfoAddr);
        if (umdInfo.sizeof() != 8) {
            return -2147418090;
        }
        umdInfo.type = 16;
        umdInfo.write(pspUmdInfoAddr);
        return 0;
    }

    @HLEFunction(nid=-1360576435, version=150, checkInsideInterrupt=true)
    public int sceUmdRegisterUMDCallBack(int uid) {
        ThreadManForUser threadMan = Modules.ThreadManForUserModule;
        if (!threadMan.hleKernelRegisterCallback(0, uid)) {
            return -1;
        }
        return 0;
    }

    @HLEFunction(nid=-1121198585, version=150)
    public int sceUmdUnRegisterUMDCallBack(int uid) {
        SceKernelCallbackInfo info = Modules.ThreadManForUserModule.hleKernelUnRegisterCallback(0, uid);
        if (info == null) {
            return -1;
        }
        return 0;
    }

    protected class UmdWaitStateChecker
    implements IWaitStateChecker {
        protected UmdWaitStateChecker() {
        }

        @Override
        public boolean continueWaitState(SceKernelThreadInfo thread, ThreadWaitInfo wait) {
            if (sceUmdUser.this.checkDriveStat(wait.wantedUmdStat)) {
                sceUmdUser.this.waitingThreads.remove(thread);
                thread.cpuContext._v0 = 0;
                return false;
            }
            return true;
        }
    }
}

